# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetManagedInstancesResult',
    'AwaitableGetManagedInstancesResult',
    'get_managed_instances',
    'get_managed_instances_output',
]

@pulumi.output_type
class GetManagedInstancesResult:
    """
    A collection of values returned by getManagedInstances.
    """
    def __init__(__self__, advisory_names=None, arch_types=None, compartment_id=None, display_name_contains=None, display_names=None, filters=None, group=None, group_not_equal_to=None, id=None, is_attached_to_group_or_lifecycle_stage=None, is_managed_by_autonomous_linux=None, is_management_station=None, is_profile_attached=None, lifecycle_environment=None, lifecycle_environment_not_equal_to=None, lifecycle_stage=None, lifecycle_stage_not_equal_to=None, location_not_equal_tos=None, locations=None, managed_instance_collections=None, managed_instance_id=None, os_families=None, profile_not_equal_tos=None, profiles=None, software_source_id=None, statuses=None):
        if advisory_names and not isinstance(advisory_names, list):
            raise TypeError("Expected argument 'advisory_names' to be a list")
        pulumi.set(__self__, "advisory_names", advisory_names)
        if arch_types and not isinstance(arch_types, list):
            raise TypeError("Expected argument 'arch_types' to be a list")
        pulumi.set(__self__, "arch_types", arch_types)
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if display_name_contains and not isinstance(display_name_contains, str):
            raise TypeError("Expected argument 'display_name_contains' to be a str")
        pulumi.set(__self__, "display_name_contains", display_name_contains)
        if display_names and not isinstance(display_names, list):
            raise TypeError("Expected argument 'display_names' to be a list")
        pulumi.set(__self__, "display_names", display_names)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if group and not isinstance(group, str):
            raise TypeError("Expected argument 'group' to be a str")
        pulumi.set(__self__, "group", group)
        if group_not_equal_to and not isinstance(group_not_equal_to, str):
            raise TypeError("Expected argument 'group_not_equal_to' to be a str")
        pulumi.set(__self__, "group_not_equal_to", group_not_equal_to)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if is_attached_to_group_or_lifecycle_stage and not isinstance(is_attached_to_group_or_lifecycle_stage, bool):
            raise TypeError("Expected argument 'is_attached_to_group_or_lifecycle_stage' to be a bool")
        pulumi.set(__self__, "is_attached_to_group_or_lifecycle_stage", is_attached_to_group_or_lifecycle_stage)
        if is_managed_by_autonomous_linux and not isinstance(is_managed_by_autonomous_linux, bool):
            raise TypeError("Expected argument 'is_managed_by_autonomous_linux' to be a bool")
        pulumi.set(__self__, "is_managed_by_autonomous_linux", is_managed_by_autonomous_linux)
        if is_management_station and not isinstance(is_management_station, bool):
            raise TypeError("Expected argument 'is_management_station' to be a bool")
        pulumi.set(__self__, "is_management_station", is_management_station)
        if is_profile_attached and not isinstance(is_profile_attached, bool):
            raise TypeError("Expected argument 'is_profile_attached' to be a bool")
        pulumi.set(__self__, "is_profile_attached", is_profile_attached)
        if lifecycle_environment and not isinstance(lifecycle_environment, str):
            raise TypeError("Expected argument 'lifecycle_environment' to be a str")
        pulumi.set(__self__, "lifecycle_environment", lifecycle_environment)
        if lifecycle_environment_not_equal_to and not isinstance(lifecycle_environment_not_equal_to, str):
            raise TypeError("Expected argument 'lifecycle_environment_not_equal_to' to be a str")
        pulumi.set(__self__, "lifecycle_environment_not_equal_to", lifecycle_environment_not_equal_to)
        if lifecycle_stage and not isinstance(lifecycle_stage, str):
            raise TypeError("Expected argument 'lifecycle_stage' to be a str")
        pulumi.set(__self__, "lifecycle_stage", lifecycle_stage)
        if lifecycle_stage_not_equal_to and not isinstance(lifecycle_stage_not_equal_to, str):
            raise TypeError("Expected argument 'lifecycle_stage_not_equal_to' to be a str")
        pulumi.set(__self__, "lifecycle_stage_not_equal_to", lifecycle_stage_not_equal_to)
        if location_not_equal_tos and not isinstance(location_not_equal_tos, list):
            raise TypeError("Expected argument 'location_not_equal_tos' to be a list")
        pulumi.set(__self__, "location_not_equal_tos", location_not_equal_tos)
        if locations and not isinstance(locations, list):
            raise TypeError("Expected argument 'locations' to be a list")
        pulumi.set(__self__, "locations", locations)
        if managed_instance_collections and not isinstance(managed_instance_collections, list):
            raise TypeError("Expected argument 'managed_instance_collections' to be a list")
        pulumi.set(__self__, "managed_instance_collections", managed_instance_collections)
        if managed_instance_id and not isinstance(managed_instance_id, str):
            raise TypeError("Expected argument 'managed_instance_id' to be a str")
        pulumi.set(__self__, "managed_instance_id", managed_instance_id)
        if os_families and not isinstance(os_families, list):
            raise TypeError("Expected argument 'os_families' to be a list")
        pulumi.set(__self__, "os_families", os_families)
        if profile_not_equal_tos and not isinstance(profile_not_equal_tos, list):
            raise TypeError("Expected argument 'profile_not_equal_tos' to be a list")
        pulumi.set(__self__, "profile_not_equal_tos", profile_not_equal_tos)
        if profiles and not isinstance(profiles, list):
            raise TypeError("Expected argument 'profiles' to be a list")
        pulumi.set(__self__, "profiles", profiles)
        if software_source_id and not isinstance(software_source_id, str):
            raise TypeError("Expected argument 'software_source_id' to be a str")
        pulumi.set(__self__, "software_source_id", software_source_id)
        if statuses and not isinstance(statuses, list):
            raise TypeError("Expected argument 'statuses' to be a list")
        pulumi.set(__self__, "statuses", statuses)

    @property
    @pulumi.getter(name="advisoryNames")
    def advisory_names(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "advisory_names")

    @property
    @pulumi.getter(name="archTypes")
    def arch_types(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "arch_types")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment that contains the managed instance.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="displayNameContains")
    def display_name_contains(self) -> Optional[str]:
        return pulumi.get(self, "display_name_contains")

    @property
    @pulumi.getter(name="displayNames")
    def display_names(self) -> Optional[Sequence[str]]:
        """
        Software source name.
        """
        return pulumi.get(self, "display_names")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetManagedInstancesFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def group(self) -> Optional[str]:
        return pulumi.get(self, "group")

    @property
    @pulumi.getter(name="groupNotEqualTo")
    def group_not_equal_to(self) -> Optional[str]:
        return pulumi.get(self, "group_not_equal_to")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="isAttachedToGroupOrLifecycleStage")
    def is_attached_to_group_or_lifecycle_stage(self) -> Optional[bool]:
        return pulumi.get(self, "is_attached_to_group_or_lifecycle_stage")

    @property
    @pulumi.getter(name="isManagedByAutonomousLinux")
    def is_managed_by_autonomous_linux(self) -> Optional[bool]:
        """
        Indicates whether the Autonomous Linux service manages the instance.
        """
        return pulumi.get(self, "is_managed_by_autonomous_linux")

    @property
    @pulumi.getter(name="isManagementStation")
    def is_management_station(self) -> Optional[bool]:
        """
        Indicates whether this managed instance is acting as an on-premises management station.
        """
        return pulumi.get(self, "is_management_station")

    @property
    @pulumi.getter(name="isProfileAttached")
    def is_profile_attached(self) -> Optional[bool]:
        return pulumi.get(self, "is_profile_attached")

    @property
    @pulumi.getter(name="lifecycleEnvironment")
    def lifecycle_environment(self) -> Optional[str]:
        """
        Id and name of a resource to simplify the display for the user.
        """
        return pulumi.get(self, "lifecycle_environment")

    @property
    @pulumi.getter(name="lifecycleEnvironmentNotEqualTo")
    def lifecycle_environment_not_equal_to(self) -> Optional[str]:
        return pulumi.get(self, "lifecycle_environment_not_equal_to")

    @property
    @pulumi.getter(name="lifecycleStage")
    def lifecycle_stage(self) -> Optional[str]:
        """
        Id and name of a resource to simplify the display for the user.
        """
        return pulumi.get(self, "lifecycle_stage")

    @property
    @pulumi.getter(name="lifecycleStageNotEqualTo")
    def lifecycle_stage_not_equal_to(self) -> Optional[str]:
        return pulumi.get(self, "lifecycle_stage_not_equal_to")

    @property
    @pulumi.getter(name="locationNotEqualTos")
    def location_not_equal_tos(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "location_not_equal_tos")

    @property
    @pulumi.getter
    def locations(self) -> Optional[Sequence[str]]:
        """
        The location of the managed instance.
        """
        return pulumi.get(self, "locations")

    @property
    @pulumi.getter(name="managedInstanceCollections")
    def managed_instance_collections(self) -> Sequence['outputs.GetManagedInstancesManagedInstanceCollectionResult']:
        """
        The list of managed_instance_collection.
        """
        return pulumi.get(self, "managed_instance_collections")

    @property
    @pulumi.getter(name="managedInstanceId")
    def managed_instance_id(self) -> Optional[str]:
        return pulumi.get(self, "managed_instance_id")

    @property
    @pulumi.getter(name="osFamilies")
    def os_families(self) -> Optional[Sequence[str]]:
        """
        The operating system type of the managed instance.
        """
        return pulumi.get(self, "os_families")

    @property
    @pulumi.getter(name="profileNotEqualTos")
    def profile_not_equal_tos(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "profile_not_equal_tos")

    @property
    @pulumi.getter
    def profiles(self) -> Optional[Sequence[str]]:
        """
        The profile that was used to register this instance with the service.
        """
        return pulumi.get(self, "profiles")

    @property
    @pulumi.getter(name="softwareSourceId")
    def software_source_id(self) -> Optional[str]:
        return pulumi.get(self, "software_source_id")

    @property
    @pulumi.getter
    def statuses(self) -> Optional[Sequence[str]]:
        """
        Current status of the managed instance.
        """
        return pulumi.get(self, "statuses")


class AwaitableGetManagedInstancesResult(GetManagedInstancesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetManagedInstancesResult(
            advisory_names=self.advisory_names,
            arch_types=self.arch_types,
            compartment_id=self.compartment_id,
            display_name_contains=self.display_name_contains,
            display_names=self.display_names,
            filters=self.filters,
            group=self.group,
            group_not_equal_to=self.group_not_equal_to,
            id=self.id,
            is_attached_to_group_or_lifecycle_stage=self.is_attached_to_group_or_lifecycle_stage,
            is_managed_by_autonomous_linux=self.is_managed_by_autonomous_linux,
            is_management_station=self.is_management_station,
            is_profile_attached=self.is_profile_attached,
            lifecycle_environment=self.lifecycle_environment,
            lifecycle_environment_not_equal_to=self.lifecycle_environment_not_equal_to,
            lifecycle_stage=self.lifecycle_stage,
            lifecycle_stage_not_equal_to=self.lifecycle_stage_not_equal_to,
            location_not_equal_tos=self.location_not_equal_tos,
            locations=self.locations,
            managed_instance_collections=self.managed_instance_collections,
            managed_instance_id=self.managed_instance_id,
            os_families=self.os_families,
            profile_not_equal_tos=self.profile_not_equal_tos,
            profiles=self.profiles,
            software_source_id=self.software_source_id,
            statuses=self.statuses)


def get_managed_instances(advisory_names: Optional[Sequence[str]] = None,
                          arch_types: Optional[Sequence[str]] = None,
                          compartment_id: Optional[str] = None,
                          display_name_contains: Optional[str] = None,
                          display_names: Optional[Sequence[str]] = None,
                          filters: Optional[Sequence[Union['GetManagedInstancesFilterArgs', 'GetManagedInstancesFilterArgsDict']]] = None,
                          group: Optional[str] = None,
                          group_not_equal_to: Optional[str] = None,
                          is_attached_to_group_or_lifecycle_stage: Optional[bool] = None,
                          is_managed_by_autonomous_linux: Optional[bool] = None,
                          is_management_station: Optional[bool] = None,
                          is_profile_attached: Optional[bool] = None,
                          lifecycle_environment: Optional[str] = None,
                          lifecycle_environment_not_equal_to: Optional[str] = None,
                          lifecycle_stage: Optional[str] = None,
                          lifecycle_stage_not_equal_to: Optional[str] = None,
                          location_not_equal_tos: Optional[Sequence[str]] = None,
                          locations: Optional[Sequence[str]] = None,
                          managed_instance_id: Optional[str] = None,
                          os_families: Optional[Sequence[str]] = None,
                          profile_not_equal_tos: Optional[Sequence[str]] = None,
                          profiles: Optional[Sequence[str]] = None,
                          software_source_id: Optional[str] = None,
                          statuses: Optional[Sequence[str]] = None,
                          opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetManagedInstancesResult:
    """
    This data source provides the list of Managed Instances in Oracle Cloud Infrastructure Os Management Hub service.

    Lists managed instances that match the specified compartment or managed instance OCID. Filter the list against a variety of criteria including but not limited to its name, status, architecture, and OS version.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_managed_instances = oci.OsManagementHub.get_managed_instances(advisory_names=managed_instance_advisory_name,
        arch_types=managed_instance_arch_type,
        compartment_id=compartment_id,
        display_names=managed_instance_display_name,
        display_name_contains=managed_instance_display_name_contains,
        group=managed_instance_group,
        group_not_equal_to=managed_instance_group_not_equal_to,
        is_attached_to_group_or_lifecycle_stage=managed_instance_is_attached_to_group_or_lifecycle_stage,
        is_managed_by_autonomous_linux=managed_instance_is_managed_by_autonomous_linux,
        is_management_station=managed_instance_is_management_station,
        is_profile_attached=managed_instance_is_profile_attached,
        lifecycle_environment=managed_instance_lifecycle_environment,
        lifecycle_environment_not_equal_to=managed_instance_lifecycle_environment_not_equal_to,
        lifecycle_stage=managed_instance_lifecycle_stage,
        lifecycle_stage_not_equal_to=managed_instance_lifecycle_stage_not_equal_to,
        locations=managed_instance_location,
        location_not_equal_tos=managed_instance_location_not_equal_to,
        managed_instance_id=test_managed_instance["id"],
        os_families=managed_instance_os_family,
        profiles=managed_instance_profile,
        profile_not_equal_tos=managed_instance_profile_not_equal_to,
        software_source_id=test_software_source["id"],
        statuses=managed_instance_status)
    ```


    :param Sequence[str] advisory_names: The assigned erratum name. It's unique and not changeable.  Example: `ELSA-2020-5804`
    :param Sequence[str] arch_types: A filter to return only instances whose architecture type matches the given architecture.
    :param str compartment_id: The OCID of the compartment that contains the resources to list. This filter returns only resources contained within the specified compartment.
    :param str display_name_contains: A filter to return resources that may partially match the given display name.
    :param Sequence[str] display_names: A filter to return resources that match the given display names.
    :param str group: A filter to return only managed instances that are attached to the specified group.
    :param str group_not_equal_to: A filter to return only managed instances that are NOT attached to the specified group.
    :param bool is_attached_to_group_or_lifecycle_stage: A filter to return only managed instances that are attached to the specified group or lifecycle environment.
    :param bool is_managed_by_autonomous_linux: Indicates whether to list only resources managed by the Autonomous Linux service.
    :param bool is_management_station: A filter to return only managed instances that are acting as management stations.
    :param bool is_profile_attached: A filter to return only managed instances with a registration profile attached.
    :param str lifecycle_environment: A filter to return only managed instances in a specific lifecycle environment.
    :param str lifecycle_environment_not_equal_to: A filter to return only managed instances that aren't in a specific lifecycle environment.
    :param str lifecycle_stage: A filter to return only managed instances that are associated with the specified lifecycle environment.
    :param str lifecycle_stage_not_equal_to: A filter to return only managed instances that are NOT associated with the specified lifecycle environment.
    :param Sequence[str] location_not_equal_tos: A filter to return only resources whose location does not match the given value.
    :param Sequence[str] locations: A filter to return only resources whose location matches the given value.
    :param str managed_instance_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the managed instance. This filter returns resources associated with this managed instance.
    :param Sequence[str] os_families: A filter to return only resources that match the given operating system family.
    :param Sequence[str] profile_not_equal_tos: A multi filter to return only managed instances that don't contain the given profile [OCIDs](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
    :param Sequence[str] profiles: A multi filter to return only managed instances that match the given profile ids.
    :param str software_source_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the software source. This filter returns resources associated with this software source.
    :param Sequence[str] statuses: A filter to return only managed instances whose status matches the status provided.
    """
    __args__ = dict()
    __args__['advisoryNames'] = advisory_names
    __args__['archTypes'] = arch_types
    __args__['compartmentId'] = compartment_id
    __args__['displayNameContains'] = display_name_contains
    __args__['displayNames'] = display_names
    __args__['filters'] = filters
    __args__['group'] = group
    __args__['groupNotEqualTo'] = group_not_equal_to
    __args__['isAttachedToGroupOrLifecycleStage'] = is_attached_to_group_or_lifecycle_stage
    __args__['isManagedByAutonomousLinux'] = is_managed_by_autonomous_linux
    __args__['isManagementStation'] = is_management_station
    __args__['isProfileAttached'] = is_profile_attached
    __args__['lifecycleEnvironment'] = lifecycle_environment
    __args__['lifecycleEnvironmentNotEqualTo'] = lifecycle_environment_not_equal_to
    __args__['lifecycleStage'] = lifecycle_stage
    __args__['lifecycleStageNotEqualTo'] = lifecycle_stage_not_equal_to
    __args__['locationNotEqualTos'] = location_not_equal_tos
    __args__['locations'] = locations
    __args__['managedInstanceId'] = managed_instance_id
    __args__['osFamilies'] = os_families
    __args__['profileNotEqualTos'] = profile_not_equal_tos
    __args__['profiles'] = profiles
    __args__['softwareSourceId'] = software_source_id
    __args__['statuses'] = statuses
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:OsManagementHub/getManagedInstances:getManagedInstances', __args__, opts=opts, typ=GetManagedInstancesResult).value

    return AwaitableGetManagedInstancesResult(
        advisory_names=pulumi.get(__ret__, 'advisory_names'),
        arch_types=pulumi.get(__ret__, 'arch_types'),
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        display_name_contains=pulumi.get(__ret__, 'display_name_contains'),
        display_names=pulumi.get(__ret__, 'display_names'),
        filters=pulumi.get(__ret__, 'filters'),
        group=pulumi.get(__ret__, 'group'),
        group_not_equal_to=pulumi.get(__ret__, 'group_not_equal_to'),
        id=pulumi.get(__ret__, 'id'),
        is_attached_to_group_or_lifecycle_stage=pulumi.get(__ret__, 'is_attached_to_group_or_lifecycle_stage'),
        is_managed_by_autonomous_linux=pulumi.get(__ret__, 'is_managed_by_autonomous_linux'),
        is_management_station=pulumi.get(__ret__, 'is_management_station'),
        is_profile_attached=pulumi.get(__ret__, 'is_profile_attached'),
        lifecycle_environment=pulumi.get(__ret__, 'lifecycle_environment'),
        lifecycle_environment_not_equal_to=pulumi.get(__ret__, 'lifecycle_environment_not_equal_to'),
        lifecycle_stage=pulumi.get(__ret__, 'lifecycle_stage'),
        lifecycle_stage_not_equal_to=pulumi.get(__ret__, 'lifecycle_stage_not_equal_to'),
        location_not_equal_tos=pulumi.get(__ret__, 'location_not_equal_tos'),
        locations=pulumi.get(__ret__, 'locations'),
        managed_instance_collections=pulumi.get(__ret__, 'managed_instance_collections'),
        managed_instance_id=pulumi.get(__ret__, 'managed_instance_id'),
        os_families=pulumi.get(__ret__, 'os_families'),
        profile_not_equal_tos=pulumi.get(__ret__, 'profile_not_equal_tos'),
        profiles=pulumi.get(__ret__, 'profiles'),
        software_source_id=pulumi.get(__ret__, 'software_source_id'),
        statuses=pulumi.get(__ret__, 'statuses'))
def get_managed_instances_output(advisory_names: Optional[pulumi.Input[Optional[Sequence[str]]]] = None,
                                 arch_types: Optional[pulumi.Input[Optional[Sequence[str]]]] = None,
                                 compartment_id: Optional[pulumi.Input[Optional[str]]] = None,
                                 display_name_contains: Optional[pulumi.Input[Optional[str]]] = None,
                                 display_names: Optional[pulumi.Input[Optional[Sequence[str]]]] = None,
                                 filters: Optional[pulumi.Input[Optional[Sequence[Union['GetManagedInstancesFilterArgs', 'GetManagedInstancesFilterArgsDict']]]]] = None,
                                 group: Optional[pulumi.Input[Optional[str]]] = None,
                                 group_not_equal_to: Optional[pulumi.Input[Optional[str]]] = None,
                                 is_attached_to_group_or_lifecycle_stage: Optional[pulumi.Input[Optional[bool]]] = None,
                                 is_managed_by_autonomous_linux: Optional[pulumi.Input[Optional[bool]]] = None,
                                 is_management_station: Optional[pulumi.Input[Optional[bool]]] = None,
                                 is_profile_attached: Optional[pulumi.Input[Optional[bool]]] = None,
                                 lifecycle_environment: Optional[pulumi.Input[Optional[str]]] = None,
                                 lifecycle_environment_not_equal_to: Optional[pulumi.Input[Optional[str]]] = None,
                                 lifecycle_stage: Optional[pulumi.Input[Optional[str]]] = None,
                                 lifecycle_stage_not_equal_to: Optional[pulumi.Input[Optional[str]]] = None,
                                 location_not_equal_tos: Optional[pulumi.Input[Optional[Sequence[str]]]] = None,
                                 locations: Optional[pulumi.Input[Optional[Sequence[str]]]] = None,
                                 managed_instance_id: Optional[pulumi.Input[Optional[str]]] = None,
                                 os_families: Optional[pulumi.Input[Optional[Sequence[str]]]] = None,
                                 profile_not_equal_tos: Optional[pulumi.Input[Optional[Sequence[str]]]] = None,
                                 profiles: Optional[pulumi.Input[Optional[Sequence[str]]]] = None,
                                 software_source_id: Optional[pulumi.Input[Optional[str]]] = None,
                                 statuses: Optional[pulumi.Input[Optional[Sequence[str]]]] = None,
                                 opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetManagedInstancesResult]:
    """
    This data source provides the list of Managed Instances in Oracle Cloud Infrastructure Os Management Hub service.

    Lists managed instances that match the specified compartment or managed instance OCID. Filter the list against a variety of criteria including but not limited to its name, status, architecture, and OS version.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_managed_instances = oci.OsManagementHub.get_managed_instances(advisory_names=managed_instance_advisory_name,
        arch_types=managed_instance_arch_type,
        compartment_id=compartment_id,
        display_names=managed_instance_display_name,
        display_name_contains=managed_instance_display_name_contains,
        group=managed_instance_group,
        group_not_equal_to=managed_instance_group_not_equal_to,
        is_attached_to_group_or_lifecycle_stage=managed_instance_is_attached_to_group_or_lifecycle_stage,
        is_managed_by_autonomous_linux=managed_instance_is_managed_by_autonomous_linux,
        is_management_station=managed_instance_is_management_station,
        is_profile_attached=managed_instance_is_profile_attached,
        lifecycle_environment=managed_instance_lifecycle_environment,
        lifecycle_environment_not_equal_to=managed_instance_lifecycle_environment_not_equal_to,
        lifecycle_stage=managed_instance_lifecycle_stage,
        lifecycle_stage_not_equal_to=managed_instance_lifecycle_stage_not_equal_to,
        locations=managed_instance_location,
        location_not_equal_tos=managed_instance_location_not_equal_to,
        managed_instance_id=test_managed_instance["id"],
        os_families=managed_instance_os_family,
        profiles=managed_instance_profile,
        profile_not_equal_tos=managed_instance_profile_not_equal_to,
        software_source_id=test_software_source["id"],
        statuses=managed_instance_status)
    ```


    :param Sequence[str] advisory_names: The assigned erratum name. It's unique and not changeable.  Example: `ELSA-2020-5804`
    :param Sequence[str] arch_types: A filter to return only instances whose architecture type matches the given architecture.
    :param str compartment_id: The OCID of the compartment that contains the resources to list. This filter returns only resources contained within the specified compartment.
    :param str display_name_contains: A filter to return resources that may partially match the given display name.
    :param Sequence[str] display_names: A filter to return resources that match the given display names.
    :param str group: A filter to return only managed instances that are attached to the specified group.
    :param str group_not_equal_to: A filter to return only managed instances that are NOT attached to the specified group.
    :param bool is_attached_to_group_or_lifecycle_stage: A filter to return only managed instances that are attached to the specified group or lifecycle environment.
    :param bool is_managed_by_autonomous_linux: Indicates whether to list only resources managed by the Autonomous Linux service.
    :param bool is_management_station: A filter to return only managed instances that are acting as management stations.
    :param bool is_profile_attached: A filter to return only managed instances with a registration profile attached.
    :param str lifecycle_environment: A filter to return only managed instances in a specific lifecycle environment.
    :param str lifecycle_environment_not_equal_to: A filter to return only managed instances that aren't in a specific lifecycle environment.
    :param str lifecycle_stage: A filter to return only managed instances that are associated with the specified lifecycle environment.
    :param str lifecycle_stage_not_equal_to: A filter to return only managed instances that are NOT associated with the specified lifecycle environment.
    :param Sequence[str] location_not_equal_tos: A filter to return only resources whose location does not match the given value.
    :param Sequence[str] locations: A filter to return only resources whose location matches the given value.
    :param str managed_instance_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the managed instance. This filter returns resources associated with this managed instance.
    :param Sequence[str] os_families: A filter to return only resources that match the given operating system family.
    :param Sequence[str] profile_not_equal_tos: A multi filter to return only managed instances that don't contain the given profile [OCIDs](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
    :param Sequence[str] profiles: A multi filter to return only managed instances that match the given profile ids.
    :param str software_source_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the software source. This filter returns resources associated with this software source.
    :param Sequence[str] statuses: A filter to return only managed instances whose status matches the status provided.
    """
    __args__ = dict()
    __args__['advisoryNames'] = advisory_names
    __args__['archTypes'] = arch_types
    __args__['compartmentId'] = compartment_id
    __args__['displayNameContains'] = display_name_contains
    __args__['displayNames'] = display_names
    __args__['filters'] = filters
    __args__['group'] = group
    __args__['groupNotEqualTo'] = group_not_equal_to
    __args__['isAttachedToGroupOrLifecycleStage'] = is_attached_to_group_or_lifecycle_stage
    __args__['isManagedByAutonomousLinux'] = is_managed_by_autonomous_linux
    __args__['isManagementStation'] = is_management_station
    __args__['isProfileAttached'] = is_profile_attached
    __args__['lifecycleEnvironment'] = lifecycle_environment
    __args__['lifecycleEnvironmentNotEqualTo'] = lifecycle_environment_not_equal_to
    __args__['lifecycleStage'] = lifecycle_stage
    __args__['lifecycleStageNotEqualTo'] = lifecycle_stage_not_equal_to
    __args__['locationNotEqualTos'] = location_not_equal_tos
    __args__['locations'] = locations
    __args__['managedInstanceId'] = managed_instance_id
    __args__['osFamilies'] = os_families
    __args__['profileNotEqualTos'] = profile_not_equal_tos
    __args__['profiles'] = profiles
    __args__['softwareSourceId'] = software_source_id
    __args__['statuses'] = statuses
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:OsManagementHub/getManagedInstances:getManagedInstances', __args__, opts=opts, typ=GetManagedInstancesResult)
    return __ret__.apply(lambda __response__: GetManagedInstancesResult(
        advisory_names=pulumi.get(__response__, 'advisory_names'),
        arch_types=pulumi.get(__response__, 'arch_types'),
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        display_name_contains=pulumi.get(__response__, 'display_name_contains'),
        display_names=pulumi.get(__response__, 'display_names'),
        filters=pulumi.get(__response__, 'filters'),
        group=pulumi.get(__response__, 'group'),
        group_not_equal_to=pulumi.get(__response__, 'group_not_equal_to'),
        id=pulumi.get(__response__, 'id'),
        is_attached_to_group_or_lifecycle_stage=pulumi.get(__response__, 'is_attached_to_group_or_lifecycle_stage'),
        is_managed_by_autonomous_linux=pulumi.get(__response__, 'is_managed_by_autonomous_linux'),
        is_management_station=pulumi.get(__response__, 'is_management_station'),
        is_profile_attached=pulumi.get(__response__, 'is_profile_attached'),
        lifecycle_environment=pulumi.get(__response__, 'lifecycle_environment'),
        lifecycle_environment_not_equal_to=pulumi.get(__response__, 'lifecycle_environment_not_equal_to'),
        lifecycle_stage=pulumi.get(__response__, 'lifecycle_stage'),
        lifecycle_stage_not_equal_to=pulumi.get(__response__, 'lifecycle_stage_not_equal_to'),
        location_not_equal_tos=pulumi.get(__response__, 'location_not_equal_tos'),
        locations=pulumi.get(__response__, 'locations'),
        managed_instance_collections=pulumi.get(__response__, 'managed_instance_collections'),
        managed_instance_id=pulumi.get(__response__, 'managed_instance_id'),
        os_families=pulumi.get(__response__, 'os_families'),
        profile_not_equal_tos=pulumi.get(__response__, 'profile_not_equal_tos'),
        profiles=pulumi.get(__response__, 'profiles'),
        software_source_id=pulumi.get(__response__, 'software_source_id'),
        statuses=pulumi.get(__response__, 'statuses')))
