# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ManagedInstanceInstallWindowsUpdatesManagementArgs', 'ManagedInstanceInstallWindowsUpdatesManagement']

@pulumi.input_type
class ManagedInstanceInstallWindowsUpdatesManagementArgs:
    def __init__(__self__, *,
                 managed_instance_id: pulumi.Input[str],
                 windows_update_names: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 windows_update_types: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 work_request_details: Optional[pulumi.Input['ManagedInstanceInstallWindowsUpdatesManagementWorkRequestDetailsArgs']] = None):
        """
        The set of arguments for constructing a ManagedInstanceInstallWindowsUpdatesManagement resource.
        :param pulumi.Input[str] managed_instance_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the managed instance.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] windows_update_names: The list of Windows update unique identifiers.  Note that this is not an OCID, but is a unique identifier assigned by Microsoft. Example: '6981d463-cd91-4a26-b7c4-ea4ded9183ed'
        :param pulumi.Input[Sequence[pulumi.Input[str]]] windows_update_types: The types of Windows updates to be installed.
        :param pulumi.Input['ManagedInstanceInstallWindowsUpdatesManagementWorkRequestDetailsArgs'] work_request_details: Provides the name and description of the job.
        """
        pulumi.set(__self__, "managed_instance_id", managed_instance_id)
        if windows_update_names is not None:
            pulumi.set(__self__, "windows_update_names", windows_update_names)
        if windows_update_types is not None:
            pulumi.set(__self__, "windows_update_types", windows_update_types)
        if work_request_details is not None:
            pulumi.set(__self__, "work_request_details", work_request_details)

    @property
    @pulumi.getter(name="managedInstanceId")
    def managed_instance_id(self) -> pulumi.Input[str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the managed instance.
        """
        return pulumi.get(self, "managed_instance_id")

    @managed_instance_id.setter
    def managed_instance_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "managed_instance_id", value)

    @property
    @pulumi.getter(name="windowsUpdateNames")
    def windows_update_names(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The list of Windows update unique identifiers.  Note that this is not an OCID, but is a unique identifier assigned by Microsoft. Example: '6981d463-cd91-4a26-b7c4-ea4ded9183ed'
        """
        return pulumi.get(self, "windows_update_names")

    @windows_update_names.setter
    def windows_update_names(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "windows_update_names", value)

    @property
    @pulumi.getter(name="windowsUpdateTypes")
    def windows_update_types(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The types of Windows updates to be installed.
        """
        return pulumi.get(self, "windows_update_types")

    @windows_update_types.setter
    def windows_update_types(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "windows_update_types", value)

    @property
    @pulumi.getter(name="workRequestDetails")
    def work_request_details(self) -> Optional[pulumi.Input['ManagedInstanceInstallWindowsUpdatesManagementWorkRequestDetailsArgs']]:
        """
        Provides the name and description of the job.
        """
        return pulumi.get(self, "work_request_details")

    @work_request_details.setter
    def work_request_details(self, value: Optional[pulumi.Input['ManagedInstanceInstallWindowsUpdatesManagementWorkRequestDetailsArgs']]):
        pulumi.set(self, "work_request_details", value)


@pulumi.input_type
class _ManagedInstanceInstallWindowsUpdatesManagementState:
    def __init__(__self__, *,
                 managed_instance_id: Optional[pulumi.Input[str]] = None,
                 windows_update_names: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 windows_update_types: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 work_request_details: Optional[pulumi.Input['ManagedInstanceInstallWindowsUpdatesManagementWorkRequestDetailsArgs']] = None):
        """
        Input properties used for looking up and filtering ManagedInstanceInstallWindowsUpdatesManagement resources.
        :param pulumi.Input[str] managed_instance_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the managed instance.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] windows_update_names: The list of Windows update unique identifiers.  Note that this is not an OCID, but is a unique identifier assigned by Microsoft. Example: '6981d463-cd91-4a26-b7c4-ea4ded9183ed'
        :param pulumi.Input[Sequence[pulumi.Input[str]]] windows_update_types: The types of Windows updates to be installed.
        :param pulumi.Input['ManagedInstanceInstallWindowsUpdatesManagementWorkRequestDetailsArgs'] work_request_details: Provides the name and description of the job.
        """
        if managed_instance_id is not None:
            pulumi.set(__self__, "managed_instance_id", managed_instance_id)
        if windows_update_names is not None:
            pulumi.set(__self__, "windows_update_names", windows_update_names)
        if windows_update_types is not None:
            pulumi.set(__self__, "windows_update_types", windows_update_types)
        if work_request_details is not None:
            pulumi.set(__self__, "work_request_details", work_request_details)

    @property
    @pulumi.getter(name="managedInstanceId")
    def managed_instance_id(self) -> Optional[pulumi.Input[str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the managed instance.
        """
        return pulumi.get(self, "managed_instance_id")

    @managed_instance_id.setter
    def managed_instance_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "managed_instance_id", value)

    @property
    @pulumi.getter(name="windowsUpdateNames")
    def windows_update_names(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The list of Windows update unique identifiers.  Note that this is not an OCID, but is a unique identifier assigned by Microsoft. Example: '6981d463-cd91-4a26-b7c4-ea4ded9183ed'
        """
        return pulumi.get(self, "windows_update_names")

    @windows_update_names.setter
    def windows_update_names(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "windows_update_names", value)

    @property
    @pulumi.getter(name="windowsUpdateTypes")
    def windows_update_types(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The types of Windows updates to be installed.
        """
        return pulumi.get(self, "windows_update_types")

    @windows_update_types.setter
    def windows_update_types(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "windows_update_types", value)

    @property
    @pulumi.getter(name="workRequestDetails")
    def work_request_details(self) -> Optional[pulumi.Input['ManagedInstanceInstallWindowsUpdatesManagementWorkRequestDetailsArgs']]:
        """
        Provides the name and description of the job.
        """
        return pulumi.get(self, "work_request_details")

    @work_request_details.setter
    def work_request_details(self, value: Optional[pulumi.Input['ManagedInstanceInstallWindowsUpdatesManagementWorkRequestDetailsArgs']]):
        pulumi.set(self, "work_request_details", value)


class ManagedInstanceInstallWindowsUpdatesManagement(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 managed_instance_id: Optional[pulumi.Input[str]] = None,
                 windows_update_names: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 windows_update_types: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 work_request_details: Optional[pulumi.Input[Union['ManagedInstanceInstallWindowsUpdatesManagementWorkRequestDetailsArgs', 'ManagedInstanceInstallWindowsUpdatesManagementWorkRequestDetailsArgsDict']]] = None,
                 __props__=None):
        """
        This resource provides the Managed Instance Install Windows Updates Management resource in Oracle Cloud Infrastructure Os Management Hub service.

        Installs Windows updates on the specified managed instance.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_managed_instance_install_windows_updates_management = oci.os_management_hub.ManagedInstanceInstallWindowsUpdatesManagement("test_managed_instance_install_windows_updates_management",
            managed_instance_id=test_managed_instance["id"],
            windows_update_names=test_windows_update["name"],
            windows_update_types=managed_instance_install_windows_updates_management_windows_update_types,
            work_request_details={
                "description": managed_instance_install_windows_updates_management_work_request_details_description,
                "display_name": managed_instance_install_windows_updates_management_work_request_details_display_name,
            })
        ```

        ## Import

        ManagedInstanceInstallWindowsUpdatesManagement can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:OsManagementHub/managedInstanceInstallWindowsUpdatesManagement:ManagedInstanceInstallWindowsUpdatesManagement test_managed_instance_install_windows_updates_management "id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] managed_instance_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the managed instance.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] windows_update_names: The list of Windows update unique identifiers.  Note that this is not an OCID, but is a unique identifier assigned by Microsoft. Example: '6981d463-cd91-4a26-b7c4-ea4ded9183ed'
        :param pulumi.Input[Sequence[pulumi.Input[str]]] windows_update_types: The types of Windows updates to be installed.
        :param pulumi.Input[Union['ManagedInstanceInstallWindowsUpdatesManagementWorkRequestDetailsArgs', 'ManagedInstanceInstallWindowsUpdatesManagementWorkRequestDetailsArgsDict']] work_request_details: Provides the name and description of the job.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ManagedInstanceInstallWindowsUpdatesManagementArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Managed Instance Install Windows Updates Management resource in Oracle Cloud Infrastructure Os Management Hub service.

        Installs Windows updates on the specified managed instance.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_managed_instance_install_windows_updates_management = oci.os_management_hub.ManagedInstanceInstallWindowsUpdatesManagement("test_managed_instance_install_windows_updates_management",
            managed_instance_id=test_managed_instance["id"],
            windows_update_names=test_windows_update["name"],
            windows_update_types=managed_instance_install_windows_updates_management_windows_update_types,
            work_request_details={
                "description": managed_instance_install_windows_updates_management_work_request_details_description,
                "display_name": managed_instance_install_windows_updates_management_work_request_details_display_name,
            })
        ```

        ## Import

        ManagedInstanceInstallWindowsUpdatesManagement can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:OsManagementHub/managedInstanceInstallWindowsUpdatesManagement:ManagedInstanceInstallWindowsUpdatesManagement test_managed_instance_install_windows_updates_management "id"
        ```

        :param str resource_name: The name of the resource.
        :param ManagedInstanceInstallWindowsUpdatesManagementArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ManagedInstanceInstallWindowsUpdatesManagementArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 managed_instance_id: Optional[pulumi.Input[str]] = None,
                 windows_update_names: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 windows_update_types: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 work_request_details: Optional[pulumi.Input[Union['ManagedInstanceInstallWindowsUpdatesManagementWorkRequestDetailsArgs', 'ManagedInstanceInstallWindowsUpdatesManagementWorkRequestDetailsArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ManagedInstanceInstallWindowsUpdatesManagementArgs.__new__(ManagedInstanceInstallWindowsUpdatesManagementArgs)

            if managed_instance_id is None and not opts.urn:
                raise TypeError("Missing required property 'managed_instance_id'")
            __props__.__dict__["managed_instance_id"] = managed_instance_id
            __props__.__dict__["windows_update_names"] = windows_update_names
            __props__.__dict__["windows_update_types"] = windows_update_types
            __props__.__dict__["work_request_details"] = work_request_details
        super(ManagedInstanceInstallWindowsUpdatesManagement, __self__).__init__(
            'oci:OsManagementHub/managedInstanceInstallWindowsUpdatesManagement:ManagedInstanceInstallWindowsUpdatesManagement',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            managed_instance_id: Optional[pulumi.Input[str]] = None,
            windows_update_names: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            windows_update_types: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            work_request_details: Optional[pulumi.Input[Union['ManagedInstanceInstallWindowsUpdatesManagementWorkRequestDetailsArgs', 'ManagedInstanceInstallWindowsUpdatesManagementWorkRequestDetailsArgsDict']]] = None) -> 'ManagedInstanceInstallWindowsUpdatesManagement':
        """
        Get an existing ManagedInstanceInstallWindowsUpdatesManagement resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] managed_instance_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the managed instance.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] windows_update_names: The list of Windows update unique identifiers.  Note that this is not an OCID, but is a unique identifier assigned by Microsoft. Example: '6981d463-cd91-4a26-b7c4-ea4ded9183ed'
        :param pulumi.Input[Sequence[pulumi.Input[str]]] windows_update_types: The types of Windows updates to be installed.
        :param pulumi.Input[Union['ManagedInstanceInstallWindowsUpdatesManagementWorkRequestDetailsArgs', 'ManagedInstanceInstallWindowsUpdatesManagementWorkRequestDetailsArgsDict']] work_request_details: Provides the name and description of the job.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ManagedInstanceInstallWindowsUpdatesManagementState.__new__(_ManagedInstanceInstallWindowsUpdatesManagementState)

        __props__.__dict__["managed_instance_id"] = managed_instance_id
        __props__.__dict__["windows_update_names"] = windows_update_names
        __props__.__dict__["windows_update_types"] = windows_update_types
        __props__.__dict__["work_request_details"] = work_request_details
        return ManagedInstanceInstallWindowsUpdatesManagement(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="managedInstanceId")
    def managed_instance_id(self) -> pulumi.Output[str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the managed instance.
        """
        return pulumi.get(self, "managed_instance_id")

    @property
    @pulumi.getter(name="windowsUpdateNames")
    def windows_update_names(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        The list of Windows update unique identifiers.  Note that this is not an OCID, but is a unique identifier assigned by Microsoft. Example: '6981d463-cd91-4a26-b7c4-ea4ded9183ed'
        """
        return pulumi.get(self, "windows_update_names")

    @property
    @pulumi.getter(name="windowsUpdateTypes")
    def windows_update_types(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        The types of Windows updates to be installed.
        """
        return pulumi.get(self, "windows_update_types")

    @property
    @pulumi.getter(name="workRequestDetails")
    def work_request_details(self) -> pulumi.Output['outputs.ManagedInstanceInstallWindowsUpdatesManagementWorkRequestDetails']:
        """
        Provides the name and description of the job.
        """
        return pulumi.get(self, "work_request_details")

