# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetInvoicesInvoiceLineResult',
    'AwaitableGetInvoicesInvoiceLineResult',
    'get_invoices_invoice_line',
    'get_invoices_invoice_line_output',
]

@pulumi.output_type
class GetInvoicesInvoiceLineResult:
    """
    A collection of values returned by getInvoicesInvoiceLine.
    """
    def __init__(__self__, compartment_id=None, id=None, internal_invoice_id=None, items=None, osp_home_region=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if internal_invoice_id and not isinstance(internal_invoice_id, str):
            raise TypeError("Expected argument 'internal_invoice_id' to be a str")
        pulumi.set(__self__, "internal_invoice_id", internal_invoice_id)
        if items and not isinstance(items, list):
            raise TypeError("Expected argument 'items' to be a list")
        pulumi.set(__self__, "items", items)
        if osp_home_region and not isinstance(osp_home_region, str):
            raise TypeError("Expected argument 'osp_home_region' to be a str")
        pulumi.set(__self__, "osp_home_region", osp_home_region)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="internalInvoiceId")
    def internal_invoice_id(self) -> str:
        return pulumi.get(self, "internal_invoice_id")

    @property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetInvoicesInvoiceLineItemResult']:
        """
        Invoice line list elements
        """
        return pulumi.get(self, "items")

    @property
    @pulumi.getter(name="ospHomeRegion")
    def osp_home_region(self) -> str:
        return pulumi.get(self, "osp_home_region")


class AwaitableGetInvoicesInvoiceLineResult(GetInvoicesInvoiceLineResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetInvoicesInvoiceLineResult(
            compartment_id=self.compartment_id,
            id=self.id,
            internal_invoice_id=self.internal_invoice_id,
            items=self.items,
            osp_home_region=self.osp_home_region)


def get_invoices_invoice_line(compartment_id: Optional[str] = None,
                              internal_invoice_id: Optional[str] = None,
                              osp_home_region: Optional[str] = None,
                              opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetInvoicesInvoiceLineResult:
    """
    This data source provides details about a specific Invoices Invoice Line resource in Oracle Cloud Infrastructure Osp Gateway service.

    Returns the invoice product list by invoice id

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_invoices_invoice_line = oci.OspGateway.get_invoices_invoice_line(compartment_id=compartment_id,
        internal_invoice_id=test_invoice["id"],
        osp_home_region=invoices_invoice_line_osp_home_region)
    ```


    :param str compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
    :param str internal_invoice_id: The identifier of the invoice.
    :param str osp_home_region: The home region's public name of the logged in user.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['internalInvoiceId'] = internal_invoice_id
    __args__['ospHomeRegion'] = osp_home_region
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:OspGateway/getInvoicesInvoiceLine:getInvoicesInvoiceLine', __args__, opts=opts, typ=GetInvoicesInvoiceLineResult).value

    return AwaitableGetInvoicesInvoiceLineResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        id=pulumi.get(__ret__, 'id'),
        internal_invoice_id=pulumi.get(__ret__, 'internal_invoice_id'),
        items=pulumi.get(__ret__, 'items'),
        osp_home_region=pulumi.get(__ret__, 'osp_home_region'))
def get_invoices_invoice_line_output(compartment_id: Optional[pulumi.Input[str]] = None,
                                     internal_invoice_id: Optional[pulumi.Input[str]] = None,
                                     osp_home_region: Optional[pulumi.Input[str]] = None,
                                     opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetInvoicesInvoiceLineResult]:
    """
    This data source provides details about a specific Invoices Invoice Line resource in Oracle Cloud Infrastructure Osp Gateway service.

    Returns the invoice product list by invoice id

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_invoices_invoice_line = oci.OspGateway.get_invoices_invoice_line(compartment_id=compartment_id,
        internal_invoice_id=test_invoice["id"],
        osp_home_region=invoices_invoice_line_osp_home_region)
    ```


    :param str compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
    :param str internal_invoice_id: The identifier of the invoice.
    :param str osp_home_region: The home region's public name of the logged in user.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['internalInvoiceId'] = internal_invoice_id
    __args__['ospHomeRegion'] = osp_home_region
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:OspGateway/getInvoicesInvoiceLine:getInvoicesInvoiceLine', __args__, opts=opts, typ=GetInvoicesInvoiceLineResult)
    return __ret__.apply(lambda __response__: GetInvoicesInvoiceLineResult(
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        id=pulumi.get(__response__, 'id'),
        internal_invoice_id=pulumi.get(__response__, 'internal_invoice_id'),
        items=pulumi.get(__response__, 'items'),
        osp_home_region=pulumi.get(__response__, 'osp_home_region')))
