# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ProtectedDatabaseArgs', 'ProtectedDatabase']

@pulumi.input_type
class ProtectedDatabaseArgs:
    def __init__(__self__, *,
                 compartment_id: pulumi.Input[str],
                 db_unique_name: pulumi.Input[str],
                 display_name: pulumi.Input[str],
                 password: pulumi.Input[str],
                 protection_policy_id: pulumi.Input[str],
                 recovery_service_subnets: pulumi.Input[Sequence[pulumi.Input['ProtectedDatabaseRecoveryServiceSubnetArgs']]],
                 database_id: Optional[pulumi.Input[str]] = None,
                 database_size: Optional[pulumi.Input[str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 deletion_schedule: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 is_redo_logs_shipped: Optional[pulumi.Input[bool]] = None,
                 subscription_id: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a ProtectedDatabase resource.
        :param pulumi.Input[str] compartment_id: (Updatable) The OCID of the compartment that contains the protected database.
        :param pulumi.Input[str] db_unique_name: The dbUniqueName of the protected database in Recovery Service. You cannot change the unique name.
        :param pulumi.Input[str] display_name: (Updatable) The protected database name. You can change the displayName. Avoid entering confidential information.
        :param pulumi.Input[str] password: (Updatable) Password credential which can be used to connect to Protected Database. It must contain at least 2 uppercase, 2 lowercase, 2 numeric and 2 special characters. The special characters must be underscore (_), number sign (https://docs.cloud.oracle.com/iaas/api/#) or hyphen (-). The password must not contain the username "admin", regardless of casing.
        :param pulumi.Input[str] protection_policy_id: (Updatable) The OCID of the protection policy associated with the protected database.
        :param pulumi.Input[Sequence[pulumi.Input['ProtectedDatabaseRecoveryServiceSubnetArgs']]] recovery_service_subnets: (Updatable) List of recovery service subnet resources associated with the protected database.
        :param pulumi.Input[str] database_id: The OCID of the protected database.
        :param pulumi.Input[str] database_size: (Updatable) The size of the protected database. XS - Less than 5GB, S - 5GB to 50GB, M - 50GB to 500GB, L - 500GB to 1TB, XL - 1TB to 5TB, XXL - Greater than 5TB.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`. For more information, see [Resource Tags](https://docs.oracle.com/en-us/iaas/Content/General/Concepts/resourcetags.htm)
        :param pulumi.Input[str] deletion_schedule: (Updatable) Defines a preferred schedule to delete a protected database after you terminate the source database.
               * The default schedule is DELETE_AFTER_72_HOURS, so that the delete operation can occur 72 hours (3 days) after the source database is terminated.
               * The alternate schedule is DELETE_AFTER_RETENTION_PERIOD. Specify this option if you want to delete a protected database only after the policy-defined backup retention period expires.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input[bool] is_redo_logs_shipped: (Updatable) The value TRUE indicates that the protected database is configured to use Real-time data protection, and redo-data is sent from the protected database to Recovery Service. Real-time data protection substantially reduces the window of potential data loss that exists between successive archived redo log backups.
        :param pulumi.Input[str] subscription_id: (Updatable) The OCID of the cloud service subscription to which you want to link the protected database.  For example, specify the Microsoft Azure subscription ID if you want to provision the protected database in Azure. 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "db_unique_name", db_unique_name)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "password", password)
        pulumi.set(__self__, "protection_policy_id", protection_policy_id)
        pulumi.set(__self__, "recovery_service_subnets", recovery_service_subnets)
        if database_id is not None:
            pulumi.set(__self__, "database_id", database_id)
        if database_size is not None:
            pulumi.set(__self__, "database_size", database_size)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if deletion_schedule is not None:
            pulumi.set(__self__, "deletion_schedule", deletion_schedule)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if is_redo_logs_shipped is not None:
            pulumi.set(__self__, "is_redo_logs_shipped", is_redo_logs_shipped)
        if subscription_id is not None:
            pulumi.set(__self__, "subscription_id", subscription_id)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Input[str]:
        """
        (Updatable) The OCID of the compartment that contains the protected database.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="dbUniqueName")
    def db_unique_name(self) -> pulumi.Input[str]:
        """
        The dbUniqueName of the protected database in Recovery Service. You cannot change the unique name.
        """
        return pulumi.get(self, "db_unique_name")

    @db_unique_name.setter
    def db_unique_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "db_unique_name", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Input[str]:
        """
        (Updatable) The protected database name. You can change the displayName. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter
    def password(self) -> pulumi.Input[str]:
        """
        (Updatable) Password credential which can be used to connect to Protected Database. It must contain at least 2 uppercase, 2 lowercase, 2 numeric and 2 special characters. The special characters must be underscore (_), number sign (https://docs.cloud.oracle.com/iaas/api/#) or hyphen (-). The password must not contain the username "admin", regardless of casing.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: pulumi.Input[str]):
        pulumi.set(self, "password", value)

    @property
    @pulumi.getter(name="protectionPolicyId")
    def protection_policy_id(self) -> pulumi.Input[str]:
        """
        (Updatable) The OCID of the protection policy associated with the protected database.
        """
        return pulumi.get(self, "protection_policy_id")

    @protection_policy_id.setter
    def protection_policy_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "protection_policy_id", value)

    @property
    @pulumi.getter(name="recoveryServiceSubnets")
    def recovery_service_subnets(self) -> pulumi.Input[Sequence[pulumi.Input['ProtectedDatabaseRecoveryServiceSubnetArgs']]]:
        """
        (Updatable) List of recovery service subnet resources associated with the protected database.
        """
        return pulumi.get(self, "recovery_service_subnets")

    @recovery_service_subnets.setter
    def recovery_service_subnets(self, value: pulumi.Input[Sequence[pulumi.Input['ProtectedDatabaseRecoveryServiceSubnetArgs']]]):
        pulumi.set(self, "recovery_service_subnets", value)

    @property
    @pulumi.getter(name="databaseId")
    def database_id(self) -> Optional[pulumi.Input[str]]:
        """
        The OCID of the protected database.
        """
        return pulumi.get(self, "database_id")

    @database_id.setter
    def database_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "database_id", value)

    @property
    @pulumi.getter(name="databaseSize")
    def database_size(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The size of the protected database. XS - Less than 5GB, S - 5GB to 50GB, M - 50GB to 500GB, L - 500GB to 1TB, XL - 1TB to 5TB, XXL - Greater than 5TB.
        """
        return pulumi.get(self, "database_size")

    @database_size.setter
    def database_size(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "database_size", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`. For more information, see [Resource Tags](https://docs.oracle.com/en-us/iaas/Content/General/Concepts/resourcetags.htm)
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter(name="deletionSchedule")
    def deletion_schedule(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Defines a preferred schedule to delete a protected database after you terminate the source database.
        * The default schedule is DELETE_AFTER_72_HOURS, so that the delete operation can occur 72 hours (3 days) after the source database is terminated.
        * The alternate schedule is DELETE_AFTER_RETENTION_PERIOD. Specify this option if you want to delete a protected database only after the policy-defined backup retention period expires.
        """
        return pulumi.get(self, "deletion_schedule")

    @deletion_schedule.setter
    def deletion_schedule(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "deletion_schedule", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter(name="isRedoLogsShipped")
    def is_redo_logs_shipped(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) The value TRUE indicates that the protected database is configured to use Real-time data protection, and redo-data is sent from the protected database to Recovery Service. Real-time data protection substantially reduces the window of potential data loss that exists between successive archived redo log backups.
        """
        return pulumi.get(self, "is_redo_logs_shipped")

    @is_redo_logs_shipped.setter
    def is_redo_logs_shipped(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_redo_logs_shipped", value)

    @property
    @pulumi.getter(name="subscriptionId")
    def subscription_id(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The OCID of the cloud service subscription to which you want to link the protected database.  For example, specify the Microsoft Azure subscription ID if you want to provision the protected database in Azure. 


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "subscription_id")

    @subscription_id.setter
    def subscription_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "subscription_id", value)


@pulumi.input_type
class _ProtectedDatabaseState:
    def __init__(__self__, *,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 database_id: Optional[pulumi.Input[str]] = None,
                 database_size: Optional[pulumi.Input[str]] = None,
                 db_unique_name: Optional[pulumi.Input[str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 deletion_schedule: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 health: Optional[pulumi.Input[str]] = None,
                 health_details: Optional[pulumi.Input[str]] = None,
                 is_read_only_resource: Optional[pulumi.Input[bool]] = None,
                 is_redo_logs_shipped: Optional[pulumi.Input[bool]] = None,
                 lifecycle_details: Optional[pulumi.Input[str]] = None,
                 metrics: Optional[pulumi.Input[Sequence[pulumi.Input['ProtectedDatabaseMetricArgs']]]] = None,
                 password: Optional[pulumi.Input[str]] = None,
                 policy_locked_date_time: Optional[pulumi.Input[str]] = None,
                 protection_policy_id: Optional[pulumi.Input[str]] = None,
                 recovery_service_subnets: Optional[pulumi.Input[Sequence[pulumi.Input['ProtectedDatabaseRecoveryServiceSubnetArgs']]]] = None,
                 state: Optional[pulumi.Input[str]] = None,
                 subscription_id: Optional[pulumi.Input[str]] = None,
                 system_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 time_created: Optional[pulumi.Input[str]] = None,
                 time_updated: Optional[pulumi.Input[str]] = None,
                 vpc_user_name: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering ProtectedDatabase resources.
        :param pulumi.Input[str] compartment_id: (Updatable) The OCID of the compartment that contains the protected database.
        :param pulumi.Input[str] database_id: The OCID of the protected database.
        :param pulumi.Input[str] database_size: (Updatable) The size of the protected database. XS - Less than 5GB, S - 5GB to 50GB, M - 50GB to 500GB, L - 500GB to 1TB, XL - 1TB to 5TB, XXL - Greater than 5TB.
        :param pulumi.Input[str] db_unique_name: The dbUniqueName of the protected database in Recovery Service. You cannot change the unique name.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`. For more information, see [Resource Tags](https://docs.oracle.com/en-us/iaas/Content/General/Concepts/resourcetags.htm)
        :param pulumi.Input[str] deletion_schedule: (Updatable) Defines a preferred schedule to delete a protected database after you terminate the source database.
               * The default schedule is DELETE_AFTER_72_HOURS, so that the delete operation can occur 72 hours (3 days) after the source database is terminated.
               * The alternate schedule is DELETE_AFTER_RETENTION_PERIOD. Specify this option if you want to delete a protected database only after the policy-defined backup retention period expires.
        :param pulumi.Input[str] display_name: (Updatable) The protected database name. You can change the displayName. Avoid entering confidential information.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input[str] health: Indicates the protection status of the database.
        :param pulumi.Input[str] health_details: A message describing the current health of the protected database.
        :param pulumi.Input[bool] is_read_only_resource: Indicates whether the protected database is created by Recovery Service or created manually. Set to <b>TRUE</b> for a service-defined protected database. When you enable the OCI-managed automatic backups option for a database and set Recovery Service as the backup destination, then Recovery Service creates the associated protected database resource. Set to <b>FALSE</b> for a user-defined protected database.
        :param pulumi.Input[bool] is_redo_logs_shipped: (Updatable) The value TRUE indicates that the protected database is configured to use Real-time data protection, and redo-data is sent from the protected database to Recovery Service. Real-time data protection substantially reduces the window of potential data loss that exists between successive archived redo log backups.
        :param pulumi.Input[str] lifecycle_details: Detailed description about the current lifecycle state of the protected database. For example, it can be used to provide actionable information for a resource in a Failed state.
        :param pulumi.Input[Sequence[pulumi.Input['ProtectedDatabaseMetricArgs']]] metrics: Backup performance and storage utilization metrics for the protected database.
        :param pulumi.Input[str] password: (Updatable) Password credential which can be used to connect to Protected Database. It must contain at least 2 uppercase, 2 lowercase, 2 numeric and 2 special characters. The special characters must be underscore (_), number sign (https://docs.cloud.oracle.com/iaas/api/#) or hyphen (-). The password must not contain the username "admin", regardless of casing.
        :param pulumi.Input[str] policy_locked_date_time: An RFC3339 formatted datetime string that specifies the exact date and time for the retention lock to take effect and permanently lock the retention period defined in the policy.
        :param pulumi.Input[str] protection_policy_id: (Updatable) The OCID of the protection policy associated with the protected database.
        :param pulumi.Input[Sequence[pulumi.Input['ProtectedDatabaseRecoveryServiceSubnetArgs']]] recovery_service_subnets: (Updatable) List of recovery service subnet resources associated with the protected database.
        :param pulumi.Input[str] state: The current state of the Protected Database.
        :param pulumi.Input[str] subscription_id: (Updatable) The OCID of the cloud service subscription to which you want to link the protected database.  For example, specify the Microsoft Azure subscription ID if you want to provision the protected database in Azure. 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] system_tags: Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`. For more information, see [Resource Tags](https://docs.oracle.com/en-us/iaas/Content/General/Concepts/resourcetags.htm)
        :param pulumi.Input[str] time_created: An RFC3339 formatted datetime string that indicates the created time for a protected database. For example: '2020-05-22T21:10:29.600Z'
        :param pulumi.Input[str] time_updated: An RFC3339 formatted datetime string that indicates the last updated time for a protected database. For example: '2020-05-22T21:10:29.600Z'
        :param pulumi.Input[str] vpc_user_name: The virtual private catalog (VPC) user credentials that authenticates the protected database to access Recovery Service.
        """
        if compartment_id is not None:
            pulumi.set(__self__, "compartment_id", compartment_id)
        if database_id is not None:
            pulumi.set(__self__, "database_id", database_id)
        if database_size is not None:
            pulumi.set(__self__, "database_size", database_size)
        if db_unique_name is not None:
            pulumi.set(__self__, "db_unique_name", db_unique_name)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if deletion_schedule is not None:
            pulumi.set(__self__, "deletion_schedule", deletion_schedule)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if health is not None:
            pulumi.set(__self__, "health", health)
        if health_details is not None:
            pulumi.set(__self__, "health_details", health_details)
        if is_read_only_resource is not None:
            pulumi.set(__self__, "is_read_only_resource", is_read_only_resource)
        if is_redo_logs_shipped is not None:
            pulumi.set(__self__, "is_redo_logs_shipped", is_redo_logs_shipped)
        if lifecycle_details is not None:
            pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        if metrics is not None:
            pulumi.set(__self__, "metrics", metrics)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if policy_locked_date_time is not None:
            pulumi.set(__self__, "policy_locked_date_time", policy_locked_date_time)
        if protection_policy_id is not None:
            pulumi.set(__self__, "protection_policy_id", protection_policy_id)
        if recovery_service_subnets is not None:
            pulumi.set(__self__, "recovery_service_subnets", recovery_service_subnets)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if subscription_id is not None:
            pulumi.set(__self__, "subscription_id", subscription_id)
        if system_tags is not None:
            pulumi.set(__self__, "system_tags", system_tags)
        if time_created is not None:
            pulumi.set(__self__, "time_created", time_created)
        if time_updated is not None:
            pulumi.set(__self__, "time_updated", time_updated)
        if vpc_user_name is not None:
            pulumi.set(__self__, "vpc_user_name", vpc_user_name)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The OCID of the compartment that contains the protected database.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="databaseId")
    def database_id(self) -> Optional[pulumi.Input[str]]:
        """
        The OCID of the protected database.
        """
        return pulumi.get(self, "database_id")

    @database_id.setter
    def database_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "database_id", value)

    @property
    @pulumi.getter(name="databaseSize")
    def database_size(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The size of the protected database. XS - Less than 5GB, S - 5GB to 50GB, M - 50GB to 500GB, L - 500GB to 1TB, XL - 1TB to 5TB, XXL - Greater than 5TB.
        """
        return pulumi.get(self, "database_size")

    @database_size.setter
    def database_size(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "database_size", value)

    @property
    @pulumi.getter(name="dbUniqueName")
    def db_unique_name(self) -> Optional[pulumi.Input[str]]:
        """
        The dbUniqueName of the protected database in Recovery Service. You cannot change the unique name.
        """
        return pulumi.get(self, "db_unique_name")

    @db_unique_name.setter
    def db_unique_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "db_unique_name", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`. For more information, see [Resource Tags](https://docs.oracle.com/en-us/iaas/Content/General/Concepts/resourcetags.htm)
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter(name="deletionSchedule")
    def deletion_schedule(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Defines a preferred schedule to delete a protected database after you terminate the source database.
        * The default schedule is DELETE_AFTER_72_HOURS, so that the delete operation can occur 72 hours (3 days) after the source database is terminated.
        * The alternate schedule is DELETE_AFTER_RETENTION_PERIOD. Specify this option if you want to delete a protected database only after the policy-defined backup retention period expires.
        """
        return pulumi.get(self, "deletion_schedule")

    @deletion_schedule.setter
    def deletion_schedule(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "deletion_schedule", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The protected database name. You can change the displayName. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter
    def health(self) -> Optional[pulumi.Input[str]]:
        """
        Indicates the protection status of the database.
        """
        return pulumi.get(self, "health")

    @health.setter
    def health(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "health", value)

    @property
    @pulumi.getter(name="healthDetails")
    def health_details(self) -> Optional[pulumi.Input[str]]:
        """
        A message describing the current health of the protected database.
        """
        return pulumi.get(self, "health_details")

    @health_details.setter
    def health_details(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "health_details", value)

    @property
    @pulumi.getter(name="isReadOnlyResource")
    def is_read_only_resource(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates whether the protected database is created by Recovery Service or created manually. Set to <b>TRUE</b> for a service-defined protected database. When you enable the OCI-managed automatic backups option for a database and set Recovery Service as the backup destination, then Recovery Service creates the associated protected database resource. Set to <b>FALSE</b> for a user-defined protected database.
        """
        return pulumi.get(self, "is_read_only_resource")

    @is_read_only_resource.setter
    def is_read_only_resource(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_read_only_resource", value)

    @property
    @pulumi.getter(name="isRedoLogsShipped")
    def is_redo_logs_shipped(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) The value TRUE indicates that the protected database is configured to use Real-time data protection, and redo-data is sent from the protected database to Recovery Service. Real-time data protection substantially reduces the window of potential data loss that exists between successive archived redo log backups.
        """
        return pulumi.get(self, "is_redo_logs_shipped")

    @is_redo_logs_shipped.setter
    def is_redo_logs_shipped(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_redo_logs_shipped", value)

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> Optional[pulumi.Input[str]]:
        """
        Detailed description about the current lifecycle state of the protected database. For example, it can be used to provide actionable information for a resource in a Failed state.
        """
        return pulumi.get(self, "lifecycle_details")

    @lifecycle_details.setter
    def lifecycle_details(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "lifecycle_details", value)

    @property
    @pulumi.getter
    def metrics(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ProtectedDatabaseMetricArgs']]]]:
        """
        Backup performance and storage utilization metrics for the protected database.
        """
        return pulumi.get(self, "metrics")

    @metrics.setter
    def metrics(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ProtectedDatabaseMetricArgs']]]]):
        pulumi.set(self, "metrics", value)

    @property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Password credential which can be used to connect to Protected Database. It must contain at least 2 uppercase, 2 lowercase, 2 numeric and 2 special characters. The special characters must be underscore (_), number sign (https://docs.cloud.oracle.com/iaas/api/#) or hyphen (-). The password must not contain the username "admin", regardless of casing.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "password", value)

    @property
    @pulumi.getter(name="policyLockedDateTime")
    def policy_locked_date_time(self) -> Optional[pulumi.Input[str]]:
        """
        An RFC3339 formatted datetime string that specifies the exact date and time for the retention lock to take effect and permanently lock the retention period defined in the policy.
        """
        return pulumi.get(self, "policy_locked_date_time")

    @policy_locked_date_time.setter
    def policy_locked_date_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "policy_locked_date_time", value)

    @property
    @pulumi.getter(name="protectionPolicyId")
    def protection_policy_id(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The OCID of the protection policy associated with the protected database.
        """
        return pulumi.get(self, "protection_policy_id")

    @protection_policy_id.setter
    def protection_policy_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "protection_policy_id", value)

    @property
    @pulumi.getter(name="recoveryServiceSubnets")
    def recovery_service_subnets(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ProtectedDatabaseRecoveryServiceSubnetArgs']]]]:
        """
        (Updatable) List of recovery service subnet resources associated with the protected database.
        """
        return pulumi.get(self, "recovery_service_subnets")

    @recovery_service_subnets.setter
    def recovery_service_subnets(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ProtectedDatabaseRecoveryServiceSubnetArgs']]]]):
        pulumi.set(self, "recovery_service_subnets", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[str]]:
        """
        The current state of the Protected Database.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter(name="subscriptionId")
    def subscription_id(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The OCID of the cloud service subscription to which you want to link the protected database.  For example, specify the Microsoft Azure subscription ID if you want to provision the protected database in Azure. 


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "subscription_id")

    @subscription_id.setter
    def subscription_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "subscription_id", value)

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`. For more information, see [Resource Tags](https://docs.oracle.com/en-us/iaas/Content/General/Concepts/resourcetags.htm)
        """
        return pulumi.get(self, "system_tags")

    @system_tags.setter
    def system_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "system_tags", value)

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[pulumi.Input[str]]:
        """
        An RFC3339 formatted datetime string that indicates the created time for a protected database. For example: '2020-05-22T21:10:29.600Z'
        """
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_created", value)

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> Optional[pulumi.Input[str]]:
        """
        An RFC3339 formatted datetime string that indicates the last updated time for a protected database. For example: '2020-05-22T21:10:29.600Z'
        """
        return pulumi.get(self, "time_updated")

    @time_updated.setter
    def time_updated(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_updated", value)

    @property
    @pulumi.getter(name="vpcUserName")
    def vpc_user_name(self) -> Optional[pulumi.Input[str]]:
        """
        The virtual private catalog (VPC) user credentials that authenticates the protected database to access Recovery Service.
        """
        return pulumi.get(self, "vpc_user_name")

    @vpc_user_name.setter
    def vpc_user_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vpc_user_name", value)


class ProtectedDatabase(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 database_id: Optional[pulumi.Input[str]] = None,
                 database_size: Optional[pulumi.Input[str]] = None,
                 db_unique_name: Optional[pulumi.Input[str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 deletion_schedule: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 is_redo_logs_shipped: Optional[pulumi.Input[bool]] = None,
                 password: Optional[pulumi.Input[str]] = None,
                 protection_policy_id: Optional[pulumi.Input[str]] = None,
                 recovery_service_subnets: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ProtectedDatabaseRecoveryServiceSubnetArgs', 'ProtectedDatabaseRecoveryServiceSubnetArgsDict']]]]] = None,
                 subscription_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        This resource provides the Protected Database resource in Oracle Cloud Infrastructure Recovery service.

        Creates a new Protected Database.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_protected_database = oci.recovery_mod.ProtectedDatabase("test_protected_database",
            compartment_id=compartment_id,
            db_unique_name=protected_database_db_unique_name,
            display_name=protected_database_display_name,
            password=protected_database_password,
            protection_policy_id=test_protection_policy["id"],
            recovery_service_subnets=[{
                "recovery_service_subnet_id": test_recovery_service_subnet["id"],
            }],
            database_id=test_database["id"],
            database_size=protected_database_database_size,
            defined_tags={
                "foo-namespace.bar-key": "value",
            },
            deletion_schedule="DELETE_AFTER_72_HOURS",
            freeform_tags={
                "bar-key": "value",
            },
            is_redo_logs_shipped=protected_database_is_redo_logs_shipped,
            subscription_id=test_subscription["id"])
        ```

        ## Import

        ProtectedDatabases can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:RecoveryMod/protectedDatabase:ProtectedDatabase test_protected_database "id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] compartment_id: (Updatable) The OCID of the compartment that contains the protected database.
        :param pulumi.Input[str] database_id: The OCID of the protected database.
        :param pulumi.Input[str] database_size: (Updatable) The size of the protected database. XS - Less than 5GB, S - 5GB to 50GB, M - 50GB to 500GB, L - 500GB to 1TB, XL - 1TB to 5TB, XXL - Greater than 5TB.
        :param pulumi.Input[str] db_unique_name: The dbUniqueName of the protected database in Recovery Service. You cannot change the unique name.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`. For more information, see [Resource Tags](https://docs.oracle.com/en-us/iaas/Content/General/Concepts/resourcetags.htm)
        :param pulumi.Input[str] deletion_schedule: (Updatable) Defines a preferred schedule to delete a protected database after you terminate the source database.
               * The default schedule is DELETE_AFTER_72_HOURS, so that the delete operation can occur 72 hours (3 days) after the source database is terminated.
               * The alternate schedule is DELETE_AFTER_RETENTION_PERIOD. Specify this option if you want to delete a protected database only after the policy-defined backup retention period expires.
        :param pulumi.Input[str] display_name: (Updatable) The protected database name. You can change the displayName. Avoid entering confidential information.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input[bool] is_redo_logs_shipped: (Updatable) The value TRUE indicates that the protected database is configured to use Real-time data protection, and redo-data is sent from the protected database to Recovery Service. Real-time data protection substantially reduces the window of potential data loss that exists between successive archived redo log backups.
        :param pulumi.Input[str] password: (Updatable) Password credential which can be used to connect to Protected Database. It must contain at least 2 uppercase, 2 lowercase, 2 numeric and 2 special characters. The special characters must be underscore (_), number sign (https://docs.cloud.oracle.com/iaas/api/#) or hyphen (-). The password must not contain the username "admin", regardless of casing.
        :param pulumi.Input[str] protection_policy_id: (Updatable) The OCID of the protection policy associated with the protected database.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ProtectedDatabaseRecoveryServiceSubnetArgs', 'ProtectedDatabaseRecoveryServiceSubnetArgsDict']]]] recovery_service_subnets: (Updatable) List of recovery service subnet resources associated with the protected database.
        :param pulumi.Input[str] subscription_id: (Updatable) The OCID of the cloud service subscription to which you want to link the protected database.  For example, specify the Microsoft Azure subscription ID if you want to provision the protected database in Azure. 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ProtectedDatabaseArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Protected Database resource in Oracle Cloud Infrastructure Recovery service.

        Creates a new Protected Database.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_protected_database = oci.recovery_mod.ProtectedDatabase("test_protected_database",
            compartment_id=compartment_id,
            db_unique_name=protected_database_db_unique_name,
            display_name=protected_database_display_name,
            password=protected_database_password,
            protection_policy_id=test_protection_policy["id"],
            recovery_service_subnets=[{
                "recovery_service_subnet_id": test_recovery_service_subnet["id"],
            }],
            database_id=test_database["id"],
            database_size=protected_database_database_size,
            defined_tags={
                "foo-namespace.bar-key": "value",
            },
            deletion_schedule="DELETE_AFTER_72_HOURS",
            freeform_tags={
                "bar-key": "value",
            },
            is_redo_logs_shipped=protected_database_is_redo_logs_shipped,
            subscription_id=test_subscription["id"])
        ```

        ## Import

        ProtectedDatabases can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:RecoveryMod/protectedDatabase:ProtectedDatabase test_protected_database "id"
        ```

        :param str resource_name: The name of the resource.
        :param ProtectedDatabaseArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ProtectedDatabaseArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 database_id: Optional[pulumi.Input[str]] = None,
                 database_size: Optional[pulumi.Input[str]] = None,
                 db_unique_name: Optional[pulumi.Input[str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 deletion_schedule: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 is_redo_logs_shipped: Optional[pulumi.Input[bool]] = None,
                 password: Optional[pulumi.Input[str]] = None,
                 protection_policy_id: Optional[pulumi.Input[str]] = None,
                 recovery_service_subnets: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ProtectedDatabaseRecoveryServiceSubnetArgs', 'ProtectedDatabaseRecoveryServiceSubnetArgsDict']]]]] = None,
                 subscription_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ProtectedDatabaseArgs.__new__(ProtectedDatabaseArgs)

            if compartment_id is None and not opts.urn:
                raise TypeError("Missing required property 'compartment_id'")
            __props__.__dict__["compartment_id"] = compartment_id
            __props__.__dict__["database_id"] = database_id
            __props__.__dict__["database_size"] = database_size
            if db_unique_name is None and not opts.urn:
                raise TypeError("Missing required property 'db_unique_name'")
            __props__.__dict__["db_unique_name"] = db_unique_name
            __props__.__dict__["defined_tags"] = defined_tags
            __props__.__dict__["deletion_schedule"] = deletion_schedule
            if display_name is None and not opts.urn:
                raise TypeError("Missing required property 'display_name'")
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["freeform_tags"] = freeform_tags
            __props__.__dict__["is_redo_logs_shipped"] = is_redo_logs_shipped
            if password is None and not opts.urn:
                raise TypeError("Missing required property 'password'")
            __props__.__dict__["password"] = None if password is None else pulumi.Output.secret(password)
            if protection_policy_id is None and not opts.urn:
                raise TypeError("Missing required property 'protection_policy_id'")
            __props__.__dict__["protection_policy_id"] = protection_policy_id
            if recovery_service_subnets is None and not opts.urn:
                raise TypeError("Missing required property 'recovery_service_subnets'")
            __props__.__dict__["recovery_service_subnets"] = recovery_service_subnets
            __props__.__dict__["subscription_id"] = subscription_id
            __props__.__dict__["health"] = None
            __props__.__dict__["health_details"] = None
            __props__.__dict__["is_read_only_resource"] = None
            __props__.__dict__["lifecycle_details"] = None
            __props__.__dict__["metrics"] = None
            __props__.__dict__["policy_locked_date_time"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["system_tags"] = None
            __props__.__dict__["time_created"] = None
            __props__.__dict__["time_updated"] = None
            __props__.__dict__["vpc_user_name"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["password"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(ProtectedDatabase, __self__).__init__(
            'oci:RecoveryMod/protectedDatabase:ProtectedDatabase',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            compartment_id: Optional[pulumi.Input[str]] = None,
            database_id: Optional[pulumi.Input[str]] = None,
            database_size: Optional[pulumi.Input[str]] = None,
            db_unique_name: Optional[pulumi.Input[str]] = None,
            defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            deletion_schedule: Optional[pulumi.Input[str]] = None,
            display_name: Optional[pulumi.Input[str]] = None,
            freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            health: Optional[pulumi.Input[str]] = None,
            health_details: Optional[pulumi.Input[str]] = None,
            is_read_only_resource: Optional[pulumi.Input[bool]] = None,
            is_redo_logs_shipped: Optional[pulumi.Input[bool]] = None,
            lifecycle_details: Optional[pulumi.Input[str]] = None,
            metrics: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ProtectedDatabaseMetricArgs', 'ProtectedDatabaseMetricArgsDict']]]]] = None,
            password: Optional[pulumi.Input[str]] = None,
            policy_locked_date_time: Optional[pulumi.Input[str]] = None,
            protection_policy_id: Optional[pulumi.Input[str]] = None,
            recovery_service_subnets: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ProtectedDatabaseRecoveryServiceSubnetArgs', 'ProtectedDatabaseRecoveryServiceSubnetArgsDict']]]]] = None,
            state: Optional[pulumi.Input[str]] = None,
            subscription_id: Optional[pulumi.Input[str]] = None,
            system_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            time_created: Optional[pulumi.Input[str]] = None,
            time_updated: Optional[pulumi.Input[str]] = None,
            vpc_user_name: Optional[pulumi.Input[str]] = None) -> 'ProtectedDatabase':
        """
        Get an existing ProtectedDatabase resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] compartment_id: (Updatable) The OCID of the compartment that contains the protected database.
        :param pulumi.Input[str] database_id: The OCID of the protected database.
        :param pulumi.Input[str] database_size: (Updatable) The size of the protected database. XS - Less than 5GB, S - 5GB to 50GB, M - 50GB to 500GB, L - 500GB to 1TB, XL - 1TB to 5TB, XXL - Greater than 5TB.
        :param pulumi.Input[str] db_unique_name: The dbUniqueName of the protected database in Recovery Service. You cannot change the unique name.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`. For more information, see [Resource Tags](https://docs.oracle.com/en-us/iaas/Content/General/Concepts/resourcetags.htm)
        :param pulumi.Input[str] deletion_schedule: (Updatable) Defines a preferred schedule to delete a protected database after you terminate the source database.
               * The default schedule is DELETE_AFTER_72_HOURS, so that the delete operation can occur 72 hours (3 days) after the source database is terminated.
               * The alternate schedule is DELETE_AFTER_RETENTION_PERIOD. Specify this option if you want to delete a protected database only after the policy-defined backup retention period expires.
        :param pulumi.Input[str] display_name: (Updatable) The protected database name. You can change the displayName. Avoid entering confidential information.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input[str] health: Indicates the protection status of the database.
        :param pulumi.Input[str] health_details: A message describing the current health of the protected database.
        :param pulumi.Input[bool] is_read_only_resource: Indicates whether the protected database is created by Recovery Service or created manually. Set to <b>TRUE</b> for a service-defined protected database. When you enable the OCI-managed automatic backups option for a database and set Recovery Service as the backup destination, then Recovery Service creates the associated protected database resource. Set to <b>FALSE</b> for a user-defined protected database.
        :param pulumi.Input[bool] is_redo_logs_shipped: (Updatable) The value TRUE indicates that the protected database is configured to use Real-time data protection, and redo-data is sent from the protected database to Recovery Service. Real-time data protection substantially reduces the window of potential data loss that exists between successive archived redo log backups.
        :param pulumi.Input[str] lifecycle_details: Detailed description about the current lifecycle state of the protected database. For example, it can be used to provide actionable information for a resource in a Failed state.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ProtectedDatabaseMetricArgs', 'ProtectedDatabaseMetricArgsDict']]]] metrics: Backup performance and storage utilization metrics for the protected database.
        :param pulumi.Input[str] password: (Updatable) Password credential which can be used to connect to Protected Database. It must contain at least 2 uppercase, 2 lowercase, 2 numeric and 2 special characters. The special characters must be underscore (_), number sign (https://docs.cloud.oracle.com/iaas/api/#) or hyphen (-). The password must not contain the username "admin", regardless of casing.
        :param pulumi.Input[str] policy_locked_date_time: An RFC3339 formatted datetime string that specifies the exact date and time for the retention lock to take effect and permanently lock the retention period defined in the policy.
        :param pulumi.Input[str] protection_policy_id: (Updatable) The OCID of the protection policy associated with the protected database.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ProtectedDatabaseRecoveryServiceSubnetArgs', 'ProtectedDatabaseRecoveryServiceSubnetArgsDict']]]] recovery_service_subnets: (Updatable) List of recovery service subnet resources associated with the protected database.
        :param pulumi.Input[str] state: The current state of the Protected Database.
        :param pulumi.Input[str] subscription_id: (Updatable) The OCID of the cloud service subscription to which you want to link the protected database.  For example, specify the Microsoft Azure subscription ID if you want to provision the protected database in Azure. 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] system_tags: Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`. For more information, see [Resource Tags](https://docs.oracle.com/en-us/iaas/Content/General/Concepts/resourcetags.htm)
        :param pulumi.Input[str] time_created: An RFC3339 formatted datetime string that indicates the created time for a protected database. For example: '2020-05-22T21:10:29.600Z'
        :param pulumi.Input[str] time_updated: An RFC3339 formatted datetime string that indicates the last updated time for a protected database. For example: '2020-05-22T21:10:29.600Z'
        :param pulumi.Input[str] vpc_user_name: The virtual private catalog (VPC) user credentials that authenticates the protected database to access Recovery Service.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ProtectedDatabaseState.__new__(_ProtectedDatabaseState)

        __props__.__dict__["compartment_id"] = compartment_id
        __props__.__dict__["database_id"] = database_id
        __props__.__dict__["database_size"] = database_size
        __props__.__dict__["db_unique_name"] = db_unique_name
        __props__.__dict__["defined_tags"] = defined_tags
        __props__.__dict__["deletion_schedule"] = deletion_schedule
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["freeform_tags"] = freeform_tags
        __props__.__dict__["health"] = health
        __props__.__dict__["health_details"] = health_details
        __props__.__dict__["is_read_only_resource"] = is_read_only_resource
        __props__.__dict__["is_redo_logs_shipped"] = is_redo_logs_shipped
        __props__.__dict__["lifecycle_details"] = lifecycle_details
        __props__.__dict__["metrics"] = metrics
        __props__.__dict__["password"] = password
        __props__.__dict__["policy_locked_date_time"] = policy_locked_date_time
        __props__.__dict__["protection_policy_id"] = protection_policy_id
        __props__.__dict__["recovery_service_subnets"] = recovery_service_subnets
        __props__.__dict__["state"] = state
        __props__.__dict__["subscription_id"] = subscription_id
        __props__.__dict__["system_tags"] = system_tags
        __props__.__dict__["time_created"] = time_created
        __props__.__dict__["time_updated"] = time_updated
        __props__.__dict__["vpc_user_name"] = vpc_user_name
        return ProtectedDatabase(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Output[str]:
        """
        (Updatable) The OCID of the compartment that contains the protected database.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="databaseId")
    def database_id(self) -> pulumi.Output[str]:
        """
        The OCID of the protected database.
        """
        return pulumi.get(self, "database_id")

    @property
    @pulumi.getter(name="databaseSize")
    def database_size(self) -> pulumi.Output[str]:
        """
        (Updatable) The size of the protected database. XS - Less than 5GB, S - 5GB to 50GB, M - 50GB to 500GB, L - 500GB to 1TB, XL - 1TB to 5TB, XXL - Greater than 5TB.
        """
        return pulumi.get(self, "database_size")

    @property
    @pulumi.getter(name="dbUniqueName")
    def db_unique_name(self) -> pulumi.Output[str]:
        """
        The dbUniqueName of the protected database in Recovery Service. You cannot change the unique name.
        """
        return pulumi.get(self, "db_unique_name")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> pulumi.Output[Mapping[str, str]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`. For more information, see [Resource Tags](https://docs.oracle.com/en-us/iaas/Content/General/Concepts/resourcetags.htm)
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="deletionSchedule")
    def deletion_schedule(self) -> pulumi.Output[str]:
        """
        (Updatable) Defines a preferred schedule to delete a protected database after you terminate the source database.
        * The default schedule is DELETE_AFTER_72_HOURS, so that the delete operation can occur 72 hours (3 days) after the source database is terminated.
        * The alternate schedule is DELETE_AFTER_RETENTION_PERIOD. Specify this option if you want to delete a protected database only after the policy-defined backup retention period expires.
        """
        return pulumi.get(self, "deletion_schedule")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[str]:
        """
        (Updatable) The protected database name. You can change the displayName. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> pulumi.Output[Mapping[str, str]]:
        """
        (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def health(self) -> pulumi.Output[str]:
        """
        Indicates the protection status of the database.
        """
        return pulumi.get(self, "health")

    @property
    @pulumi.getter(name="healthDetails")
    def health_details(self) -> pulumi.Output[str]:
        """
        A message describing the current health of the protected database.
        """
        return pulumi.get(self, "health_details")

    @property
    @pulumi.getter(name="isReadOnlyResource")
    def is_read_only_resource(self) -> pulumi.Output[bool]:
        """
        Indicates whether the protected database is created by Recovery Service or created manually. Set to <b>TRUE</b> for a service-defined protected database. When you enable the OCI-managed automatic backups option for a database and set Recovery Service as the backup destination, then Recovery Service creates the associated protected database resource. Set to <b>FALSE</b> for a user-defined protected database.
        """
        return pulumi.get(self, "is_read_only_resource")

    @property
    @pulumi.getter(name="isRedoLogsShipped")
    def is_redo_logs_shipped(self) -> pulumi.Output[bool]:
        """
        (Updatable) The value TRUE indicates that the protected database is configured to use Real-time data protection, and redo-data is sent from the protected database to Recovery Service. Real-time data protection substantially reduces the window of potential data loss that exists between successive archived redo log backups.
        """
        return pulumi.get(self, "is_redo_logs_shipped")

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> pulumi.Output[str]:
        """
        Detailed description about the current lifecycle state of the protected database. For example, it can be used to provide actionable information for a resource in a Failed state.
        """
        return pulumi.get(self, "lifecycle_details")

    @property
    @pulumi.getter
    def metrics(self) -> pulumi.Output[Sequence['outputs.ProtectedDatabaseMetric']]:
        """
        Backup performance and storage utilization metrics for the protected database.
        """
        return pulumi.get(self, "metrics")

    @property
    @pulumi.getter
    def password(self) -> pulumi.Output[str]:
        """
        (Updatable) Password credential which can be used to connect to Protected Database. It must contain at least 2 uppercase, 2 lowercase, 2 numeric and 2 special characters. The special characters must be underscore (_), number sign (https://docs.cloud.oracle.com/iaas/api/#) or hyphen (-). The password must not contain the username "admin", regardless of casing.
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter(name="policyLockedDateTime")
    def policy_locked_date_time(self) -> pulumi.Output[str]:
        """
        An RFC3339 formatted datetime string that specifies the exact date and time for the retention lock to take effect and permanently lock the retention period defined in the policy.
        """
        return pulumi.get(self, "policy_locked_date_time")

    @property
    @pulumi.getter(name="protectionPolicyId")
    def protection_policy_id(self) -> pulumi.Output[str]:
        """
        (Updatable) The OCID of the protection policy associated with the protected database.
        """
        return pulumi.get(self, "protection_policy_id")

    @property
    @pulumi.getter(name="recoveryServiceSubnets")
    def recovery_service_subnets(self) -> pulumi.Output[Sequence['outputs.ProtectedDatabaseRecoveryServiceSubnet']]:
        """
        (Updatable) List of recovery service subnet resources associated with the protected database.
        """
        return pulumi.get(self, "recovery_service_subnets")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[str]:
        """
        The current state of the Protected Database.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="subscriptionId")
    def subscription_id(self) -> pulumi.Output[str]:
        """
        (Updatable) The OCID of the cloud service subscription to which you want to link the protected database.  For example, specify the Microsoft Azure subscription ID if you want to provision the protected database in Azure. 


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "subscription_id")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> pulumi.Output[Mapping[str, str]]:
        """
        Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`. For more information, see [Resource Tags](https://docs.oracle.com/en-us/iaas/Content/General/Concepts/resourcetags.htm)
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> pulumi.Output[str]:
        """
        An RFC3339 formatted datetime string that indicates the created time for a protected database. For example: '2020-05-22T21:10:29.600Z'
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> pulumi.Output[str]:
        """
        An RFC3339 formatted datetime string that indicates the last updated time for a protected database. For example: '2020-05-22T21:10:29.600Z'
        """
        return pulumi.get(self, "time_updated")

    @property
    @pulumi.getter(name="vpcUserName")
    def vpc_user_name(self) -> pulumi.Output[str]:
        """
        The virtual private catalog (VPC) user credentials that authenticates the protected database to access Recovery Service.
        """
        return pulumi.get(self, "vpc_user_name")

