# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetSecretbundleSecretBundleContentResult',
    'GetSecretbundleVersionsFilterResult',
    'GetSecretbundleVersionsSecretBundleVersionResult',
]

@pulumi.output_type
class GetSecretbundleSecretBundleContentResult(dict):
    def __init__(__self__, *,
                 content: str,
                 content_type: str):
        """
        :param str content: The base64-encoded content of the secret.
        :param str content_type: The formatting type of the secret contents.
        """
        pulumi.set(__self__, "content", content)
        pulumi.set(__self__, "content_type", content_type)

    @property
    @pulumi.getter
    def content(self) -> str:
        """
        The base64-encoded content of the secret.
        """
        return pulumi.get(self, "content")

    @property
    @pulumi.getter(name="contentType")
    def content_type(self) -> str:
        """
        The formatting type of the secret contents.
        """
        return pulumi.get(self, "content_type")


@pulumi.output_type
class GetSecretbundleVersionsFilterResult(dict):
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetSecretbundleVersionsSecretBundleVersionResult(dict):
    def __init__(__self__, *,
                 secret_id: str,
                 stages: Sequence[str],
                 time_created: str,
                 time_of_deletion: str,
                 time_of_expiry: str,
                 version_name: str,
                 version_number: str):
        """
        :param str secret_id: The OCID of the secret.
        :param Sequence[str] stages: A list of possible rotation states for the secret bundle.
        :param str time_created: The time when the secret bundle was created.
        :param str time_of_deletion: An optional property indicating when to delete the secret version, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format. Example: `2019-04-03T21:10:29.600Z`
        :param str time_of_expiry: An optional property indicating when the secret version will expire, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format. Example: `2019-04-03T21:10:29.600Z`
        :param str version_name: The version name of the secret bundle, as provided when the secret was created or last rotated.
        :param str version_number: The version number of the secret.
        """
        pulumi.set(__self__, "secret_id", secret_id)
        pulumi.set(__self__, "stages", stages)
        pulumi.set(__self__, "time_created", time_created)
        pulumi.set(__self__, "time_of_deletion", time_of_deletion)
        pulumi.set(__self__, "time_of_expiry", time_of_expiry)
        pulumi.set(__self__, "version_name", version_name)
        pulumi.set(__self__, "version_number", version_number)

    @property
    @pulumi.getter(name="secretId")
    def secret_id(self) -> str:
        """
        The OCID of the secret.
        """
        return pulumi.get(self, "secret_id")

    @property
    @pulumi.getter
    def stages(self) -> Sequence[str]:
        """
        A list of possible rotation states for the secret bundle.
        """
        return pulumi.get(self, "stages")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> str:
        """
        The time when the secret bundle was created.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeOfDeletion")
    def time_of_deletion(self) -> str:
        """
        An optional property indicating when to delete the secret version, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format. Example: `2019-04-03T21:10:29.600Z`
        """
        return pulumi.get(self, "time_of_deletion")

    @property
    @pulumi.getter(name="timeOfExpiry")
    def time_of_expiry(self) -> str:
        """
        An optional property indicating when the secret version will expire, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format. Example: `2019-04-03T21:10:29.600Z`
        """
        return pulumi.get(self, "time_of_expiry")

    @property
    @pulumi.getter(name="versionName")
    def version_name(self) -> str:
        """
        The version name of the secret bundle, as provided when the secret was created or last rotated.
        """
        return pulumi.get(self, "version_name")

    @property
    @pulumi.getter(name="versionNumber")
    def version_number(self) -> str:
        """
        The version number of the secret.
        """
        return pulumi.get(self, "version_number")


