# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['MaintenanceWindowsRetryFailedOperationArgs', 'MaintenanceWindowsRetryFailedOperation']

@pulumi.input_type
class MaintenanceWindowsRetryFailedOperationArgs:
    def __init__(__self__, *,
                 maintenance_window_id: pulumi.Input[str]):
        """
        The set of arguments for constructing a MaintenanceWindowsRetryFailedOperation resource.
        :param pulumi.Input[str] maintenance_window_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of maintenance window.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        pulumi.set(__self__, "maintenance_window_id", maintenance_window_id)

    @property
    @pulumi.getter(name="maintenanceWindowId")
    def maintenance_window_id(self) -> pulumi.Input[str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of maintenance window.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "maintenance_window_id")

    @maintenance_window_id.setter
    def maintenance_window_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "maintenance_window_id", value)


@pulumi.input_type
class _MaintenanceWindowsRetryFailedOperationState:
    def __init__(__self__, *,
                 maintenance_window_id: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering MaintenanceWindowsRetryFailedOperation resources.
        :param pulumi.Input[str] maintenance_window_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of maintenance window.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        if maintenance_window_id is not None:
            pulumi.set(__self__, "maintenance_window_id", maintenance_window_id)

    @property
    @pulumi.getter(name="maintenanceWindowId")
    def maintenance_window_id(self) -> Optional[pulumi.Input[str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of maintenance window.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "maintenance_window_id")

    @maintenance_window_id.setter
    def maintenance_window_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "maintenance_window_id", value)


class MaintenanceWindowsRetryFailedOperation(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 maintenance_window_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        This resource provides the Maintenance Windows Retry Failed Operation resource in Oracle Cloud Infrastructure Stack Monitoring service.

        Retry the last failed operation. The operation failed will be the most recent one. It won't apply for previous failed operations.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_maintenance_windows_retry_failed_operation = oci.stack_monitoring.MaintenanceWindowsRetryFailedOperation("test_maintenance_windows_retry_failed_operation", maintenance_window_id=test_maintenance_window["id"])
        ```

        ## Import

        MaintenanceWindowsRetryFailedOperation can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:StackMonitoring/maintenanceWindowsRetryFailedOperation:MaintenanceWindowsRetryFailedOperation test_maintenance_windows_retry_failed_operation "id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] maintenance_window_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of maintenance window.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: MaintenanceWindowsRetryFailedOperationArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Maintenance Windows Retry Failed Operation resource in Oracle Cloud Infrastructure Stack Monitoring service.

        Retry the last failed operation. The operation failed will be the most recent one. It won't apply for previous failed operations.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_maintenance_windows_retry_failed_operation = oci.stack_monitoring.MaintenanceWindowsRetryFailedOperation("test_maintenance_windows_retry_failed_operation", maintenance_window_id=test_maintenance_window["id"])
        ```

        ## Import

        MaintenanceWindowsRetryFailedOperation can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:StackMonitoring/maintenanceWindowsRetryFailedOperation:MaintenanceWindowsRetryFailedOperation test_maintenance_windows_retry_failed_operation "id"
        ```

        :param str resource_name: The name of the resource.
        :param MaintenanceWindowsRetryFailedOperationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(MaintenanceWindowsRetryFailedOperationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 maintenance_window_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = MaintenanceWindowsRetryFailedOperationArgs.__new__(MaintenanceWindowsRetryFailedOperationArgs)

            if maintenance_window_id is None and not opts.urn:
                raise TypeError("Missing required property 'maintenance_window_id'")
            __props__.__dict__["maintenance_window_id"] = maintenance_window_id
        super(MaintenanceWindowsRetryFailedOperation, __self__).__init__(
            'oci:StackMonitoring/maintenanceWindowsRetryFailedOperation:MaintenanceWindowsRetryFailedOperation',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            maintenance_window_id: Optional[pulumi.Input[str]] = None) -> 'MaintenanceWindowsRetryFailedOperation':
        """
        Get an existing MaintenanceWindowsRetryFailedOperation resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] maintenance_window_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of maintenance window.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _MaintenanceWindowsRetryFailedOperationState.__new__(_MaintenanceWindowsRetryFailedOperationState)

        __props__.__dict__["maintenance_window_id"] = maintenance_window_id
        return MaintenanceWindowsRetryFailedOperation(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="maintenanceWindowId")
    def maintenance_window_id(self) -> pulumi.Output[str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of maintenance window.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "maintenance_window_id")

