# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetCustomProtectionRulesResult',
    'AwaitableGetCustomProtectionRulesResult',
    'get_custom_protection_rules',
    'get_custom_protection_rules_output',
]

@pulumi.output_type
class GetCustomProtectionRulesResult:
    """
    A collection of values returned by getCustomProtectionRules.
    """
    def __init__(__self__, compartment_id=None, custom_protection_rules=None, display_names=None, filters=None, id=None, ids=None, states=None, time_created_greater_than_or_equal_to=None, time_created_less_than=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if custom_protection_rules and not isinstance(custom_protection_rules, list):
            raise TypeError("Expected argument 'custom_protection_rules' to be a list")
        pulumi.set(__self__, "custom_protection_rules", custom_protection_rules)
        if display_names and not isinstance(display_names, list):
            raise TypeError("Expected argument 'display_names' to be a list")
        pulumi.set(__self__, "display_names", display_names)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ids and not isinstance(ids, list):
            raise TypeError("Expected argument 'ids' to be a list")
        pulumi.set(__self__, "ids", ids)
        if states and not isinstance(states, list):
            raise TypeError("Expected argument 'states' to be a list")
        pulumi.set(__self__, "states", states)
        if time_created_greater_than_or_equal_to and not isinstance(time_created_greater_than_or_equal_to, str):
            raise TypeError("Expected argument 'time_created_greater_than_or_equal_to' to be a str")
        pulumi.set(__self__, "time_created_greater_than_or_equal_to", time_created_greater_than_or_equal_to)
        if time_created_less_than and not isinstance(time_created_less_than, str):
            raise TypeError("Expected argument 'time_created_less_than' to be a str")
        pulumi.set(__self__, "time_created_less_than", time_created_less_than)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the custom protection rule's compartment.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="customProtectionRules")
    def custom_protection_rules(self) -> Sequence['outputs.GetCustomProtectionRulesCustomProtectionRuleResult']:
        """
        The list of custom_protection_rules.
        """
        return pulumi.get(self, "custom_protection_rules")

    @property
    @pulumi.getter(name="displayNames")
    def display_names(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "display_names")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetCustomProtectionRulesFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def ids(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "ids")

    @property
    @pulumi.getter
    def states(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "states")

    @property
    @pulumi.getter(name="timeCreatedGreaterThanOrEqualTo")
    def time_created_greater_than_or_equal_to(self) -> Optional[str]:
        return pulumi.get(self, "time_created_greater_than_or_equal_to")

    @property
    @pulumi.getter(name="timeCreatedLessThan")
    def time_created_less_than(self) -> Optional[str]:
        return pulumi.get(self, "time_created_less_than")


class AwaitableGetCustomProtectionRulesResult(GetCustomProtectionRulesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetCustomProtectionRulesResult(
            compartment_id=self.compartment_id,
            custom_protection_rules=self.custom_protection_rules,
            display_names=self.display_names,
            filters=self.filters,
            id=self.id,
            ids=self.ids,
            states=self.states,
            time_created_greater_than_or_equal_to=self.time_created_greater_than_or_equal_to,
            time_created_less_than=self.time_created_less_than)


def get_custom_protection_rules(compartment_id: Optional[str] = None,
                                display_names: Optional[Sequence[str]] = None,
                                filters: Optional[Sequence[Union['GetCustomProtectionRulesFilterArgs', 'GetCustomProtectionRulesFilterArgsDict']]] = None,
                                ids: Optional[Sequence[str]] = None,
                                states: Optional[Sequence[str]] = None,
                                time_created_greater_than_or_equal_to: Optional[str] = None,
                                time_created_less_than: Optional[str] = None,
                                opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetCustomProtectionRulesResult:
    """
    This data source provides the list of Custom Protection Rules in Oracle Cloud Infrastructure Web Application Acceleration and Security service.

    Gets a list of custom protection rules for the specified Web Application Firewall.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_custom_protection_rules = oci.Waas.get_custom_protection_rules(compartment_id=compartment_id,
        display_names=custom_protection_rule_display_names,
        ids=custom_protection_rule_ids,
        states=custom_protection_rule_states,
        time_created_greater_than_or_equal_to=custom_protection_rule_time_created_greater_than_or_equal_to,
        time_created_less_than=custom_protection_rule_time_created_less_than)
    ```


    :param str compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment. This number is generated when the compartment is created.
    :param Sequence[str] display_names: Filter custom protection rules using a list of display names.
    :param Sequence[str] ids: Filter custom protection rules using a list of custom protection rule OCIDs.
    :param Sequence[str] states: Filter Custom Protection rules using a list of lifecycle states.
    :param str time_created_greater_than_or_equal_to: A filter that matches Custom Protection rules created on or after the specified date-time.
    :param str time_created_less_than: A filter that matches custom protection rules created before the specified date-time.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['displayNames'] = display_names
    __args__['filters'] = filters
    __args__['ids'] = ids
    __args__['states'] = states
    __args__['timeCreatedGreaterThanOrEqualTo'] = time_created_greater_than_or_equal_to
    __args__['timeCreatedLessThan'] = time_created_less_than
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Waas/getCustomProtectionRules:getCustomProtectionRules', __args__, opts=opts, typ=GetCustomProtectionRulesResult).value

    return AwaitableGetCustomProtectionRulesResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        custom_protection_rules=pulumi.get(__ret__, 'custom_protection_rules'),
        display_names=pulumi.get(__ret__, 'display_names'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        ids=pulumi.get(__ret__, 'ids'),
        states=pulumi.get(__ret__, 'states'),
        time_created_greater_than_or_equal_to=pulumi.get(__ret__, 'time_created_greater_than_or_equal_to'),
        time_created_less_than=pulumi.get(__ret__, 'time_created_less_than'))
def get_custom_protection_rules_output(compartment_id: Optional[pulumi.Input[str]] = None,
                                       display_names: Optional[pulumi.Input[Optional[Sequence[str]]]] = None,
                                       filters: Optional[pulumi.Input[Optional[Sequence[Union['GetCustomProtectionRulesFilterArgs', 'GetCustomProtectionRulesFilterArgsDict']]]]] = None,
                                       ids: Optional[pulumi.Input[Optional[Sequence[str]]]] = None,
                                       states: Optional[pulumi.Input[Optional[Sequence[str]]]] = None,
                                       time_created_greater_than_or_equal_to: Optional[pulumi.Input[Optional[str]]] = None,
                                       time_created_less_than: Optional[pulumi.Input[Optional[str]]] = None,
                                       opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetCustomProtectionRulesResult]:
    """
    This data source provides the list of Custom Protection Rules in Oracle Cloud Infrastructure Web Application Acceleration and Security service.

    Gets a list of custom protection rules for the specified Web Application Firewall.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_custom_protection_rules = oci.Waas.get_custom_protection_rules(compartment_id=compartment_id,
        display_names=custom_protection_rule_display_names,
        ids=custom_protection_rule_ids,
        states=custom_protection_rule_states,
        time_created_greater_than_or_equal_to=custom_protection_rule_time_created_greater_than_or_equal_to,
        time_created_less_than=custom_protection_rule_time_created_less_than)
    ```


    :param str compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment. This number is generated when the compartment is created.
    :param Sequence[str] display_names: Filter custom protection rules using a list of display names.
    :param Sequence[str] ids: Filter custom protection rules using a list of custom protection rule OCIDs.
    :param Sequence[str] states: Filter Custom Protection rules using a list of lifecycle states.
    :param str time_created_greater_than_or_equal_to: A filter that matches Custom Protection rules created on or after the specified date-time.
    :param str time_created_less_than: A filter that matches custom protection rules created before the specified date-time.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['displayNames'] = display_names
    __args__['filters'] = filters
    __args__['ids'] = ids
    __args__['states'] = states
    __args__['timeCreatedGreaterThanOrEqualTo'] = time_created_greater_than_or_equal_to
    __args__['timeCreatedLessThan'] = time_created_less_than
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:Waas/getCustomProtectionRules:getCustomProtectionRules', __args__, opts=opts, typ=GetCustomProtectionRulesResult)
    return __ret__.apply(lambda __response__: GetCustomProtectionRulesResult(
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        custom_protection_rules=pulumi.get(__response__, 'custom_protection_rules'),
        display_names=pulumi.get(__response__, 'display_names'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        ids=pulumi.get(__response__, 'ids'),
        states=pulumi.get(__response__, 'states'),
        time_created_greater_than_or_equal_to=pulumi.get(__response__, 'time_created_greater_than_or_equal_to'),
        time_created_less_than=pulumi.get(__response__, 'time_created_less_than')))
