# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetWebAppFirewallPolicyResult',
    'AwaitableGetWebAppFirewallPolicyResult',
    'get_web_app_firewall_policy',
    'get_web_app_firewall_policy_output',
]

@pulumi.output_type
class GetWebAppFirewallPolicyResult:
    """
    A collection of values returned by getWebAppFirewallPolicy.
    """
    def __init__(__self__, actions=None, compartment_id=None, defined_tags=None, display_name=None, freeform_tags=None, id=None, lifecycle_details=None, request_access_controls=None, request_protections=None, request_rate_limitings=None, response_access_controls=None, response_protections=None, state=None, system_tags=None, time_created=None, time_updated=None, web_app_firewall_policy_id=None):
        if actions and not isinstance(actions, list):
            raise TypeError("Expected argument 'actions' to be a list")
        pulumi.set(__self__, "actions", actions)
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if defined_tags and not isinstance(defined_tags, dict):
            raise TypeError("Expected argument 'defined_tags' to be a dict")
        pulumi.set(__self__, "defined_tags", defined_tags)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if freeform_tags and not isinstance(freeform_tags, dict):
            raise TypeError("Expected argument 'freeform_tags' to be a dict")
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if lifecycle_details and not isinstance(lifecycle_details, str):
            raise TypeError("Expected argument 'lifecycle_details' to be a str")
        pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        if request_access_controls and not isinstance(request_access_controls, list):
            raise TypeError("Expected argument 'request_access_controls' to be a list")
        pulumi.set(__self__, "request_access_controls", request_access_controls)
        if request_protections and not isinstance(request_protections, list):
            raise TypeError("Expected argument 'request_protections' to be a list")
        pulumi.set(__self__, "request_protections", request_protections)
        if request_rate_limitings and not isinstance(request_rate_limitings, list):
            raise TypeError("Expected argument 'request_rate_limitings' to be a list")
        pulumi.set(__self__, "request_rate_limitings", request_rate_limitings)
        if response_access_controls and not isinstance(response_access_controls, list):
            raise TypeError("Expected argument 'response_access_controls' to be a list")
        pulumi.set(__self__, "response_access_controls", response_access_controls)
        if response_protections and not isinstance(response_protections, list):
            raise TypeError("Expected argument 'response_protections' to be a list")
        pulumi.set(__self__, "response_protections", response_protections)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if system_tags and not isinstance(system_tags, dict):
            raise TypeError("Expected argument 'system_tags' to be a dict")
        pulumi.set(__self__, "system_tags", system_tags)
        if time_created and not isinstance(time_created, str):
            raise TypeError("Expected argument 'time_created' to be a str")
        pulumi.set(__self__, "time_created", time_created)
        if time_updated and not isinstance(time_updated, str):
            raise TypeError("Expected argument 'time_updated' to be a str")
        pulumi.set(__self__, "time_updated", time_updated)
        if web_app_firewall_policy_id and not isinstance(web_app_firewall_policy_id, str):
            raise TypeError("Expected argument 'web_app_firewall_policy_id' to be a str")
        pulumi.set(__self__, "web_app_firewall_policy_id", web_app_firewall_policy_id)

    @property
    @pulumi.getter
    def actions(self) -> Sequence['outputs.GetWebAppFirewallPolicyActionResult']:
        """
        Predefined actions for use in multiple different rules. Not all actions are supported in every module. Some actions terminate further execution of modules and rules in a module and some do not. Actions names must be unique within this array.
        """
        return pulumi.get(self, "actions")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, str]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        WebAppFirewallPolicy display name, can be renamed.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, str]:
        """
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the WebAppFirewallPolicy.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> str:
        """
        A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in FAILED state.
        """
        return pulumi.get(self, "lifecycle_details")

    @property
    @pulumi.getter(name="requestAccessControls")
    def request_access_controls(self) -> Sequence['outputs.GetWebAppFirewallPolicyRequestAccessControlResult']:
        """
        Module that allows inspection of HTTP request properties and to return a defined HTTP response. In this module, rules with the name 'Default Action' are not allowed, since this name is reserved for default action logs.
        """
        return pulumi.get(self, "request_access_controls")

    @property
    @pulumi.getter(name="requestProtections")
    def request_protections(self) -> Sequence['outputs.GetWebAppFirewallPolicyRequestProtectionResult']:
        """
        Module that allows to enable OCI-managed protection capabilities for incoming HTTP requests.
        """
        return pulumi.get(self, "request_protections")

    @property
    @pulumi.getter(name="requestRateLimitings")
    def request_rate_limitings(self) -> Sequence['outputs.GetWebAppFirewallPolicyRequestRateLimitingResult']:
        """
        Module that allows inspection of HTTP connection properties and to limit requests frequency for a given key.
        """
        return pulumi.get(self, "request_rate_limitings")

    @property
    @pulumi.getter(name="responseAccessControls")
    def response_access_controls(self) -> Sequence['outputs.GetWebAppFirewallPolicyResponseAccessControlResult']:
        """
        Module that allows inspection of HTTP response properties and to return a defined HTTP response.
        """
        return pulumi.get(self, "response_access_controls")

    @property
    @pulumi.getter(name="responseProtections")
    def response_protections(self) -> Sequence['outputs.GetWebAppFirewallPolicyResponseProtectionResult']:
        """
        Module that allows to enable OCI-managed protection capabilities for HTTP responses.
        """
        return pulumi.get(self, "response_protections")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        The current state of the WebAppFirewallPolicy.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Mapping[str, str]:
        """
        Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> str:
        """
        The time the WebAppFirewallPolicy was created. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> str:
        """
        The time the WebAppFirewallPolicy was updated. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_updated")

    @property
    @pulumi.getter(name="webAppFirewallPolicyId")
    def web_app_firewall_policy_id(self) -> str:
        return pulumi.get(self, "web_app_firewall_policy_id")


class AwaitableGetWebAppFirewallPolicyResult(GetWebAppFirewallPolicyResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetWebAppFirewallPolicyResult(
            actions=self.actions,
            compartment_id=self.compartment_id,
            defined_tags=self.defined_tags,
            display_name=self.display_name,
            freeform_tags=self.freeform_tags,
            id=self.id,
            lifecycle_details=self.lifecycle_details,
            request_access_controls=self.request_access_controls,
            request_protections=self.request_protections,
            request_rate_limitings=self.request_rate_limitings,
            response_access_controls=self.response_access_controls,
            response_protections=self.response_protections,
            state=self.state,
            system_tags=self.system_tags,
            time_created=self.time_created,
            time_updated=self.time_updated,
            web_app_firewall_policy_id=self.web_app_firewall_policy_id)


def get_web_app_firewall_policy(web_app_firewall_policy_id: Optional[str] = None,
                                opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetWebAppFirewallPolicyResult:
    """
    This data source provides details about a specific Web App Firewall Policy resource in Oracle Cloud Infrastructure Waf service.

    Gets a WebAppFirewallPolicy with the given OCID.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_web_app_firewall_policy = oci.Waf.get_web_app_firewall_policy(web_app_firewall_policy_id=test_web_app_firewall_policy_oci_waf_web_app_firewall_policy["id"])
    ```


    :param str web_app_firewall_policy_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the WebAppFirewallPolicy.
    """
    __args__ = dict()
    __args__['webAppFirewallPolicyId'] = web_app_firewall_policy_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Waf/getWebAppFirewallPolicy:getWebAppFirewallPolicy', __args__, opts=opts, typ=GetWebAppFirewallPolicyResult).value

    return AwaitableGetWebAppFirewallPolicyResult(
        actions=pulumi.get(__ret__, 'actions'),
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        defined_tags=pulumi.get(__ret__, 'defined_tags'),
        display_name=pulumi.get(__ret__, 'display_name'),
        freeform_tags=pulumi.get(__ret__, 'freeform_tags'),
        id=pulumi.get(__ret__, 'id'),
        lifecycle_details=pulumi.get(__ret__, 'lifecycle_details'),
        request_access_controls=pulumi.get(__ret__, 'request_access_controls'),
        request_protections=pulumi.get(__ret__, 'request_protections'),
        request_rate_limitings=pulumi.get(__ret__, 'request_rate_limitings'),
        response_access_controls=pulumi.get(__ret__, 'response_access_controls'),
        response_protections=pulumi.get(__ret__, 'response_protections'),
        state=pulumi.get(__ret__, 'state'),
        system_tags=pulumi.get(__ret__, 'system_tags'),
        time_created=pulumi.get(__ret__, 'time_created'),
        time_updated=pulumi.get(__ret__, 'time_updated'),
        web_app_firewall_policy_id=pulumi.get(__ret__, 'web_app_firewall_policy_id'))
def get_web_app_firewall_policy_output(web_app_firewall_policy_id: Optional[pulumi.Input[str]] = None,
                                       opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetWebAppFirewallPolicyResult]:
    """
    This data source provides details about a specific Web App Firewall Policy resource in Oracle Cloud Infrastructure Waf service.

    Gets a WebAppFirewallPolicy with the given OCID.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_web_app_firewall_policy = oci.Waf.get_web_app_firewall_policy(web_app_firewall_policy_id=test_web_app_firewall_policy_oci_waf_web_app_firewall_policy["id"])
    ```


    :param str web_app_firewall_policy_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the WebAppFirewallPolicy.
    """
    __args__ = dict()
    __args__['webAppFirewallPolicyId'] = web_app_firewall_policy_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:Waf/getWebAppFirewallPolicy:getWebAppFirewallPolicy', __args__, opts=opts, typ=GetWebAppFirewallPolicyResult)
    return __ret__.apply(lambda __response__: GetWebAppFirewallPolicyResult(
        actions=pulumi.get(__response__, 'actions'),
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        defined_tags=pulumi.get(__response__, 'defined_tags'),
        display_name=pulumi.get(__response__, 'display_name'),
        freeform_tags=pulumi.get(__response__, 'freeform_tags'),
        id=pulumi.get(__response__, 'id'),
        lifecycle_details=pulumi.get(__response__, 'lifecycle_details'),
        request_access_controls=pulumi.get(__response__, 'request_access_controls'),
        request_protections=pulumi.get(__response__, 'request_protections'),
        request_rate_limitings=pulumi.get(__response__, 'request_rate_limitings'),
        response_access_controls=pulumi.get(__response__, 'response_access_controls'),
        response_protections=pulumi.get(__response__, 'response_protections'),
        state=pulumi.get(__response__, 'state'),
        system_tags=pulumi.get(__response__, 'system_tags'),
        time_created=pulumi.get(__response__, 'time_created'),
        time_updated=pulumi.get(__response__, 'time_updated'),
        web_app_firewall_policy_id=pulumi.get(__response__, 'web_app_firewall_policy_id')))
