"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Image = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdk8s_1 = require("cdk8s");
const constructs_1 = require("constructs");
const _shell_1 = require("./_shell");
const PARSE_DIGEST = /digest:\ (sha256:[0-9a-f]+)/;
/**
 * Represents a docker image built during synthesis from a context directory
 * (`dir`) with a `Dockerfile`.
 *
 * The image will be built using `docker build` and then pushed through `docker
 * push`. The URL of the pushed image can be accessed through `image.url`.
 *
 * If you push to a registry other than docker hub, you can specify the registry
 * URL through the `registry` option.
 */
class Image extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        const registry = props.registry ?? 'docker.io/library';
        const name = props.name || cdk8s_1.Names.toDnsLabel(this);
        const tag = props.tag || 'latest';
        const fullTag = `${registry}/${name}:${tag}`;
        const allBuildArgs = [];
        props.buildArgs?.forEach((arg) => {
            allBuildArgs.push('--build-arg');
            allBuildArgs.push(`${arg.name}=${arg.value}`);
        });
        if (props.file) {
            allBuildArgs.push('-f');
            allBuildArgs.push(props.file);
        }
        if (props.platform) {
            allBuildArgs.push(`--platform=${props.platform}`);
        }
        console.error(`building docker image ${fullTag} from ${props.file ? props.file : props.dir}`);
        _shell_1.shell('docker', 'build', '-t', fullTag, props.dir, ...allBuildArgs);
        console.error(`pushing docker image ${fullTag} to ${registry}`);
        const push = _shell_1.shell('docker', 'push', fullTag);
        const result = PARSE_DIGEST.exec(push);
        if (!result) {
            throw new Error(`unable to read image digest after push: ${push}`);
        }
        this.url = props.tag ? fullTag : `${registry}/${name}@${result[1]}`;
    }
}
exports.Image = Image;
_a = JSII_RTTI_SYMBOL_1;
Image[_a] = { fqn: "cdk8s-image.Image", version: "0.2.640" };
//# sourceMappingURL=data:application/json;base64,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