import { Construct } from 'constructs';
import { Job } from './job';
import { WorkflowTriggers } from './triggers';
import { YamlFile } from '../file/yaml-file';
export interface WorkflowProps {
    readonly repoName: string;
    /**
     * File path where the workflow should be synthesized.
     *
     * @default ".github/workflows/deploy.yml"
     */
    readonly workflowPath?: string;
    /**
     * Name of the workflow file.
     *
     * @default "deploy"
     */
    readonly workflowName?: string;
    /**
     * GitHub workflow triggers.
     *
     * @default - By default, workflow is triggered on push to the `main` branch
     * and can also be triggered manually (`workflow_dispatch`).
     */
    readonly workflowTriggers?: WorkflowTriggers;
    readonly jobs?: Job[];
}
export declare class Workflow extends Construct {
    readonly repoName: string;
    readonly workflowPath: string;
    readonly workflowFile: YamlFile;
    readonly workflowName: string;
    readonly workflowTriggers: WorkflowTriggers;
    readonly jobs: Job[];
    constructor(scope: Construct, id: string, props: WorkflowProps);
    addJob(job: Job): void;
    private createSecret;
    private validateJobs;
    private jobsToRecords;
    private buildWorkflow;
}
