# coding: utf-8

"""
    VRt.Studio [ST]

    Veeroute Studio API.  # Description  Server part of the Veeroute Studio.  ## Entity relationship diagram  ![erd](../uml/studio.svg) 

    The version of the OpenAPI document: 7.6.2491
    Contact: servicedesk@veeroute.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from vrt_lss_studio.models.capacity import Capacity
from vrt_lss_studio.models.cargo_compatibilities import CargoCompatibilities
from typing import Optional, Set
from typing_extensions import Self

class Cargo(BaseModel):
    """
    Cargo. Regardless of capacity, cargo can only move inside the transport box. 
    """ # noqa: E501
    key: Annotated[str, Field(min_length=1, strict=True, max_length=1024)] = Field(description="Cargo key, unique identifier.")
    capacity: Optional[Capacity] = None
    compatibilities: Optional[CargoCompatibilities] = None
    target_box_key: Optional[Annotated[str, Field(min_length=1, strict=True, max_length=1024)]] = Field(default=None, description="The key of the transport box in which the cargo is already located. Applicable only for cargo that is in the order with the type `DROP_FROM_BOX`. For other order types, the key must be empty. ")
    __properties: ClassVar[List[str]] = ["key", "capacity", "compatibilities", "target_box_key"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of Cargo from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of capacity
        if self.capacity:
            _dict['capacity'] = self.capacity.to_dict()
        # override the default output from pydantic by calling `to_dict()` of compatibilities
        if self.compatibilities:
            _dict['compatibilities'] = self.compatibilities.to_dict()
        # set to None if capacity (nullable) is None
        # and model_fields_set contains the field
        if self.capacity is None and "capacity" in self.model_fields_set:
            _dict['capacity'] = None

        # set to None if compatibilities (nullable) is None
        # and model_fields_set contains the field
        if self.compatibilities is None and "compatibilities" in self.model_fields_set:
            _dict['compatibilities'] = None

        # set to None if target_box_key (nullable) is None
        # and model_fields_set contains the field
        if self.target_box_key is None and "target_box_key" in self.model_fields_set:
            _dict['target_box_key'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of Cargo from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "key": obj.get("key"),
            "capacity": Capacity.from_dict(obj["capacity"]) if obj.get("capacity") is not None else None,
            "compatibilities": CargoCompatibilities.from_dict(obj["compatibilities"]) if obj.get("compatibilities") is not None else None,
            "target_box_key": obj.get("target_box_key")
        })
        return _obj


