# coding: utf-8

"""
    VRt.Studio [ST]

    Veeroute Studio API.  # Description  Server part of the Veeroute Studio.  ## Entity relationship diagram  ![erd](../uml/studio.svg) 

    The version of the OpenAPI document: 7.6.2491
    Contact: servicedesk@veeroute.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from vrt_lss_studio.models.entity_error import EntityError
from vrt_lss_studio.models.entity_warning import EntityWarning
from typing import Optional, Set
from typing_extensions import Self

class ExperimentCheck(BaseModel):
    """
    The result of checking the data on the experiment.
    """ # noqa: E501
    logical_errors: Optional[Annotated[List[EntityError], Field(min_length=0, max_length=15001)]] = Field(default=None, description="List with fatal errors. ")
    warnings: Optional[Annotated[List[EntityWarning], Field(min_length=0, max_length=15001)]] = Field(default=None, description="Warning list.")
    __properties: ClassVar[List[str]] = ["logical_errors", "warnings"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ExperimentCheck from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in logical_errors (list)
        _items = []
        if self.logical_errors:
            for _item in self.logical_errors:
                if _item:
                    _items.append(_item.to_dict())
            _dict['logical_errors'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in warnings (list)
        _items = []
        if self.warnings:
            for _item in self.warnings:
                if _item:
                    _items.append(_item.to_dict())
            _dict['warnings'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ExperimentCheck from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "logical_errors": [EntityError.from_dict(_item) for _item in obj["logical_errors"]] if obj.get("logical_errors") is not None else None,
            "warnings": [EntityWarning.from_dict(_item) for _item in obj["warnings"]] if obj.get("warnings") is not None else None
        })
        return _obj


