# coding: utf-8

"""
    VRt.Studio [ST]

    Veeroute Studio API.  # Description  Server part of the Veeroute Studio.  ## Entity relationship diagram  ![erd](../uml/studio.svg) 

    The version of the OpenAPI document: 7.6.2491
    Contact: servicedesk@veeroute.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from vrt_lss_studio.models.folder_counters import FolderCounters
from vrt_lss_studio.models.folder_type import FolderType
from typing import Optional, Set
from typing_extensions import Self

class Filesystem(BaseModel):
    """
    File system.  Only one object can be of type ROOT. 
    """ # noqa: E501
    key: StrictStr = Field(description="Key, unique identifier.")
    type: FolderType
    name: Annotated[str, Field(min_length=1, strict=True, max_length=100)] = Field(description="Folder name.")
    comment: Optional[Annotated[str, Field(min_length=0, strict=True, max_length=10000)]] = Field(default=None, description="Folder comment.")
    counters: FolderCounters
    elements: Optional[Annotated[List[Filesystem], Field(min_length=0, max_length=101)]] = Field(default=None, description="A list of child's elements.")
    __properties: ClassVar[List[str]] = ["key", "type", "name", "comment", "counters", "elements"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of Filesystem from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * OpenAPI `readOnly` fields are excluded.
        """
        excluded_fields: Set[str] = set([
            "elements",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of counters
        if self.counters:
            _dict['counters'] = self.counters.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in elements (list)
        _items = []
        if self.elements:
            for _item in self.elements:
                if _item:
                    _items.append(_item.to_dict())
            _dict['elements'] = _items
        # set to None if comment (nullable) is None
        # and model_fields_set contains the field
        if self.comment is None and "comment" in self.model_fields_set:
            _dict['comment'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of Filesystem from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "key": obj.get("key"),
            "type": obj.get("type"),
            "name": obj.get("name"),
            "comment": obj.get("comment"),
            "counters": FolderCounters.from_dict(obj["counters"]) if obj.get("counters") is not None else None,
            "elements": [Filesystem.from_dict(_item) for _item in obj["elements"]] if obj.get("elements") is not None else None
        })
        return _obj

# TODO: Rewrite to not use raise_errors
Filesystem.model_rebuild(raise_errors=False)

