# coding: utf-8

"""
    VRt.Studio [ST]

    Veeroute Studio API.  # Description  Server part of the Veeroute Studio.  ## Entity relationship diagram  ![erd](../uml/studio.svg) 

    The version of the OpenAPI document: 7.6.2491
    Contact: servicedesk@veeroute.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, List
from typing_extensions import Annotated
from vrt_lss_studio.models.table_list_counters import TableListCounters
from vrt_lss_studio.models.web_performer_geopoint import WebPerformerGeopoint
from typing import Optional, Set
from typing_extensions import Self

class WebPerformerGeopointList(BaseModel):
    """
    Geopoints for map.
    """ # noqa: E501
    geopoints: Annotated[List[WebPerformerGeopoint], Field(min_length=0, max_length=60002)] = Field(description="A list of points.")
    counters: TableListCounters
    __properties: ClassVar[List[str]] = ["geopoints", "counters"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of WebPerformerGeopointList from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in geopoints (list)
        _items = []
        if self.geopoints:
            for _item in self.geopoints:
                if _item:
                    _items.append(_item.to_dict())
            _dict['geopoints'] = _items
        # override the default output from pydantic by calling `to_dict()` of counters
        if self.counters:
            _dict['counters'] = self.counters.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of WebPerformerGeopointList from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "geopoints": [WebPerformerGeopoint.from_dict(_item) for _item in obj["geopoints"]] if obj.get("geopoints") is not None else None,
            "counters": TableListCounters.from_dict(obj["counters"]) if obj.get("counters") is not None else None
        })
        return _obj


