/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.sqlserver.jdbc;

import com.microsoft.sqlserver.jdbc.CekTable;
import com.microsoft.sqlserver.jdbc.CekTableEntry;
import com.microsoft.sqlserver.jdbc.Column;
import com.microsoft.sqlserver.jdbc.CryptoMetadata;
import com.microsoft.sqlserver.jdbc.SQLIdentifier;
import com.microsoft.sqlserver.jdbc.SQLServerException;
import com.microsoft.sqlserver.jdbc.SSType;
import com.microsoft.sqlserver.jdbc.StreamColInfo;
import com.microsoft.sqlserver.jdbc.StreamPacket;
import com.microsoft.sqlserver.jdbc.StreamTabName;
import com.microsoft.sqlserver.jdbc.TDSReader;
import com.microsoft.sqlserver.jdbc.TypeInfo;

final class StreamColumns
extends StreamPacket {
    private Column[] columns;
    private CekTable cekTable = null;
    private boolean shouldHonorAEForRead = false;

    CekTable getCekTable() {
        return this.cekTable;
    }

    StreamColumns() {
        super(129);
    }

    StreamColumns(boolean bl) {
        super(129);
        this.shouldHonorAEForRead = bl;
    }

    CekTableEntry readCEKTableEntry(TDSReader tDSReader) throws SQLServerException {
        int n = tDSReader.readInt();
        int n2 = tDSReader.readInt();
        int n3 = tDSReader.readInt();
        byte[] byArray = new byte[8];
        tDSReader.readBytes(byArray, 0, 8);
        int n4 = tDSReader.readUnsignedByte();
        CekTableEntry cekTableEntry = new CekTableEntry(n4);
        for (int i = 0; i < n4; ++i) {
            short s = tDSReader.readShort();
            byte[] byArray2 = new byte[s];
            tDSReader.readBytes(byArray2, 0, s);
            int n5 = tDSReader.readUnsignedByte();
            String string = tDSReader.readUnicodeString(n5);
            short s2 = tDSReader.readShort();
            String string2 = tDSReader.readUnicodeString(s2);
            int n6 = tDSReader.readUnsignedByte();
            String string3 = tDSReader.readUnicodeString(n6);
            cekTableEntry.add(byArray2, n, n2, n3, byArray, string2, string, string3);
        }
        return cekTableEntry;
    }

    void readCEKTable(TDSReader tDSReader) throws SQLServerException {
        int n = tDSReader.readShort();
        if (0 != n) {
            this.cekTable = new CekTable(n);
            for (int i = 0; i < n; ++i) {
                this.cekTable.setCekTableEntry(i, this.readCEKTableEntry(tDSReader));
            }
        }
    }

    CryptoMetadata readCryptoMetadata(TDSReader tDSReader) throws SQLServerException {
        short s = 0;
        if (null != this.cekTable) {
            s = tDSReader.readShort();
        }
        TypeInfo typeInfo = TypeInfo.getInstance(tDSReader, false);
        byte by2 = (byte)tDSReader.readUnsignedByte();
        String string = null;
        if (0 == by2) {
            int by = tDSReader.readUnsignedByte();
            string = tDSReader.readUnicodeString(by);
        }
        byte by = (byte)tDSReader.readUnsignedByte();
        byte by3 = (byte)tDSReader.readUnsignedByte();
        CryptoMetadata cryptoMetadata = new CryptoMetadata(this.cekTable == null ? null : this.cekTable.getCekTableEntry(s), s, by2, string, by, by3);
        cryptoMetadata.setBaseTypeInfo(typeInfo);
        return cryptoMetadata;
    }

    @Override
    void setFromTDS(TDSReader tDSReader) throws SQLServerException {
        if (129 != tDSReader.readUnsignedByte()) assert (false);
        int n = tDSReader.readUnsignedShort();
        if (65535 == n) {
            return;
        }
        if (tDSReader.getServerSupportsColumnEncryption()) {
            this.readCEKTable(tDSReader);
        }
        this.columns = new Column[n];
        for (int i = 0; i < n; ++i) {
            TypeInfo typeInfo = TypeInfo.getInstance(tDSReader, true);
            SQLIdentifier sQLIdentifier = new SQLIdentifier();
            if (SSType.TEXT == typeInfo.getSSType() || SSType.NTEXT == typeInfo.getSSType() || SSType.IMAGE == typeInfo.getSSType()) {
                sQLIdentifier = tDSReader.readSQLIdentifier();
            }
            CryptoMetadata cryptoMetadata = null;
            if (tDSReader.getServerSupportsColumnEncryption() && typeInfo.isEncrypted()) {
                cryptoMetadata = this.readCryptoMetadata(tDSReader);
                cryptoMetadata.baseTypeInfo.setFlags(typeInfo.getFlagsAsShort());
                typeInfo.setSQLCollation(cryptoMetadata.baseTypeInfo.getSQLCollation());
            }
            String string = tDSReader.readUnicodeString(tDSReader.readUnsignedByte());
            this.columns[i] = this.shouldHonorAEForRead ? new Column(typeInfo, string, sQLIdentifier, cryptoMetadata) : new Column(typeInfo, string, sQLIdentifier, null);
        }
    }

    Column[] buildColumns(StreamColInfo streamColInfo, StreamTabName streamTabName) throws SQLServerException {
        if (null != streamColInfo && null != streamTabName) {
            streamTabName.applyTo(this.columns, streamColInfo.applyTo(this.columns));
        }
        return this.columns;
    }
}

