# coding: utf-8

"""
    Vidispine API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)  # noqa: E501

    The version of the OpenAPI document: 5.x
    Contact: info@vidispine.com
    Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from vidispine.models import *
from vidispine.api_client import ApiClient
from vidispine.exceptions import (
    ApiTypeError,
    ApiValueError
)


class AccessApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def create_access_control(self, type, entity_id, access_control_type, **kwargs):  # noqa: E501
        """Create an access control entry  # noqa: E501

        Adds a new access control entry for the specified entity.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_access_control(type, entity_id, access_control_type, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str type: The type of entity. (required)
        :param str entity_id: The entity id. (required)
        :param AccessControlType access_control_type: (required)
        :key bool allow_duplicate: Set to `false` in order to avoid adding a duplicate access control.
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: AccessControlType.
                 If the method is called asynchronously, returns the request thread.
        :rtype: AccessControlType or multiprocessing.pool.AsyncResult
        """
        kwargs['_return_http_data_only'] = True
        return self.create_access_control_with_http_info(type, entity_id, access_control_type, **kwargs)  # noqa: E501

    def create_access_control_with_http_info(self, type, entity_id, access_control_type, **kwargs):  # noqa: E501
        """Create an access control entry  # noqa: E501

        Adds a new access control entry for the specified entity.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_access_control_with_http_info(type, entity_id, access_control_type, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str type: The type of entity. (required)
        :param str entity_id: The entity id. (required)
        :param AccessControlType access_control_type: (required)
        :key bool allow_duplicate: Set to `false` in order to avoid adding a duplicate access control.
        :key _return_http_data_only: response data without head status code
                                       and headers
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(AccessControlType, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['type', 'entity_id', 'access_control_type', 'allow_duplicate']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_access_control" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'type' is set
        if ('type' not in local_var_params or
                local_var_params['type'] is None):
            raise ApiValueError("Missing the required parameter `type` when calling `create_access_control`")  # noqa: E501
        # verify the required parameter 'entity_id' is set
        if ('entity_id' not in local_var_params or
                local_var_params['entity_id'] is None):
            raise ApiValueError("Missing the required parameter `entity_id` when calling `create_access_control`")  # noqa: E501
        # verify the required parameter 'access_control_type' is set
        if ('access_control_type' not in local_var_params or
                local_var_params['access_control_type'] is None):
            raise ApiValueError("Missing the required parameter `access_control_type` when calling `create_access_control`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'type' in local_var_params:
            path_params['type'] = local_var_params['type']  # noqa: E501
        if 'entity_id' in local_var_params:
            path_params['entity-id'] = local_var_params['entity_id']  # noqa: E501

        query_params = []
        if 'allow_duplicate' in local_var_params:
            query_params.append(('allowDuplicate', local_var_params['allow_duplicate']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'access_control_type' in local_var_params:
            body_params = local_var_params['access_control_type']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'text/plain', 'application/xml'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'application/xml'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/{type}/{entity-id}/access', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AccessControlType',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_access_control_for_all_items(self, access_control_type, **kwargs):  # noqa: E501
        """Add access control entries to all items  # noqa: E501

        Adds access control entries to all known items.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_access_control_for_all_items(access_control_type, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param AccessControlType access_control_type: (required)
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None.
                 If the method is called asynchronously, returns the request thread.
        :rtype: None or multiprocessing.pool.AsyncResult
        """
        kwargs['_return_http_data_only'] = True
        return self.create_access_control_for_all_items_with_http_info(access_control_type, **kwargs)  # noqa: E501

    def create_access_control_for_all_items_with_http_info(self, access_control_type, **kwargs):  # noqa: E501
        """Add access control entries to all items  # noqa: E501

        Adds access control entries to all known items.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_access_control_for_all_items_with_http_info(access_control_type, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param AccessControlType access_control_type: (required)
        :key _return_http_data_only: response data without head status code
                                       and headers
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['access_control_type']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_access_control_for_all_items" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'access_control_type' is set
        if ('access_control_type' not in local_var_params or
                local_var_params['access_control_type'] is None):
            raise ApiValueError("Missing the required parameter `access_control_type` when calling `create_access_control_for_all_items`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'access_control_type' in local_var_params:
            body_params = local_var_params['access_control_type']
        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'application/xml'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/item/access', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_access_controls(self, type, entity_id, access_control_list_type, **kwargs):  # noqa: E501
        """Create multiple entry access control entries  # noqa: E501

        Adds multiple new access control entries to the specified entity.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_access_controls(type, entity_id, access_control_list_type, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str type: The type of entity. (required)
        :param str entity_id: The entity id. (required)
        :param AccessControlListType access_control_list_type: (required)
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: AccessControlListType.
                 If the method is called asynchronously, returns the request thread.
        :rtype: AccessControlListType or multiprocessing.pool.AsyncResult
        """
        kwargs['_return_http_data_only'] = True
        return self.create_access_controls_with_http_info(type, entity_id, access_control_list_type, **kwargs)  # noqa: E501

    def create_access_controls_with_http_info(self, type, entity_id, access_control_list_type, **kwargs):  # noqa: E501
        """Create multiple entry access control entries  # noqa: E501

        Adds multiple new access control entries to the specified entity.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_access_controls_with_http_info(type, entity_id, access_control_list_type, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str type: The type of entity. (required)
        :param str entity_id: The entity id. (required)
        :param AccessControlListType access_control_list_type: (required)
        :key _return_http_data_only: response data without head status code
                                       and headers
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(AccessControlListType, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['type', 'entity_id', 'access_control_list_type']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_access_controls" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'type' is set
        if ('type' not in local_var_params or
                local_var_params['type'] is None):
            raise ApiValueError("Missing the required parameter `type` when calling `create_access_controls`")  # noqa: E501
        # verify the required parameter 'entity_id' is set
        if ('entity_id' not in local_var_params or
                local_var_params['entity_id'] is None):
            raise ApiValueError("Missing the required parameter `entity_id` when calling `create_access_controls`")  # noqa: E501
        # verify the required parameter 'access_control_list_type' is set
        if ('access_control_list_type' not in local_var_params or
                local_var_params['access_control_list_type'] is None):
            raise ApiValueError("Missing the required parameter `access_control_list_type` when calling `create_access_controls`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'type' in local_var_params:
            path_params['type'] = local_var_params['type']  # noqa: E501
        if 'entity_id' in local_var_params:
            path_params['entity-id'] = local_var_params['entity_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'access_control_list_type' in local_var_params:
            body_params = local_var_params['access_control_list_type']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'text/plain', 'application/xml'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'application/xml'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/{type}/{entity-id}/access/bulk', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AccessControlListType',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_access_control(self, type, entity_id, access_id, **kwargs):  # noqa: E501
        """Delete an access control entry  # noqa: E501

        Removes the desired access control entry.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_access_control(type, entity_id, access_id, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str type: The type of entity. (required)
        :param str entity_id: The entity id. (required)
        :param str access_id: The access id. (required)
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None.
                 If the method is called asynchronously, returns the request thread.
        :rtype: None or multiprocessing.pool.AsyncResult
        """
        kwargs['_return_http_data_only'] = True
        return self.delete_access_control_with_http_info(type, entity_id, access_id, **kwargs)  # noqa: E501

    def delete_access_control_with_http_info(self, type, entity_id, access_id, **kwargs):  # noqa: E501
        """Delete an access control entry  # noqa: E501

        Removes the desired access control entry.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_access_control_with_http_info(type, entity_id, access_id, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str type: The type of entity. (required)
        :param str entity_id: The entity id. (required)
        :param str access_id: The access id. (required)
        :key _return_http_data_only: response data without head status code
                                       and headers
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['type', 'entity_id', 'access_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_access_control" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'type' is set
        if ('type' not in local_var_params or
                local_var_params['type'] is None):
            raise ApiValueError("Missing the required parameter `type` when calling `delete_access_control`")  # noqa: E501
        # verify the required parameter 'entity_id' is set
        if ('entity_id' not in local_var_params or
                local_var_params['entity_id'] is None):
            raise ApiValueError("Missing the required parameter `entity_id` when calling `delete_access_control`")  # noqa: E501
        # verify the required parameter 'access_id' is set
        if ('access_id' not in local_var_params or
                local_var_params['access_id'] is None):
            raise ApiValueError("Missing the required parameter `access_id` when calling `delete_access_control`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'type' in local_var_params:
            path_params['type'] = local_var_params['type']  # noqa: E501
        if 'entity_id' in local_var_params:
            path_params['entity-id'] = local_var_params['entity_id']  # noqa: E501
        if 'access_id' in local_var_params:
            path_params['access-id'] = local_var_params['access_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/{type}/{entity-id}/access/{access-id}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_access_controls(self, type, entity_id, access_control_list_type, **kwargs):  # noqa: E501
        """Delete multiple access control entries  # noqa: E501

        Deletes multiple access control entries by id.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_access_controls(type, entity_id, access_control_list_type, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str type: The type of entity. (required)
        :param str entity_id: The entity id. (required)
        :param AccessControlListType access_control_list_type: (required)
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None.
                 If the method is called asynchronously, returns the request thread.
        :rtype: None or multiprocessing.pool.AsyncResult
        """
        kwargs['_return_http_data_only'] = True
        return self.delete_access_controls_with_http_info(type, entity_id, access_control_list_type, **kwargs)  # noqa: E501

    def delete_access_controls_with_http_info(self, type, entity_id, access_control_list_type, **kwargs):  # noqa: E501
        """Delete multiple access control entries  # noqa: E501

        Deletes multiple access control entries by id.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_access_controls_with_http_info(type, entity_id, access_control_list_type, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str type: The type of entity. (required)
        :param str entity_id: The entity id. (required)
        :param AccessControlListType access_control_list_type: (required)
        :key _return_http_data_only: response data without head status code
                                       and headers
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['type', 'entity_id', 'access_control_list_type']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_access_controls" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'type' is set
        if ('type' not in local_var_params or
                local_var_params['type'] is None):
            raise ApiValueError("Missing the required parameter `type` when calling `delete_access_controls`")  # noqa: E501
        # verify the required parameter 'entity_id' is set
        if ('entity_id' not in local_var_params or
                local_var_params['entity_id'] is None):
            raise ApiValueError("Missing the required parameter `entity_id` when calling `delete_access_controls`")  # noqa: E501
        # verify the required parameter 'access_control_list_type' is set
        if ('access_control_list_type' not in local_var_params or
                local_var_params['access_control_list_type'] is None):
            raise ApiValueError("Missing the required parameter `access_control_list_type` when calling `delete_access_controls`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'type' in local_var_params:
            path_params['type'] = local_var_params['type']  # noqa: E501
        if 'entity_id' in local_var_params:
            path_params['entity-id'] = local_var_params['entity_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'access_control_list_type' in local_var_params:
            body_params = local_var_params['access_control_list_type']
        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'application/xml'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/{type}/{entity-id}/access/bulk', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_access_controls_from_all_items(self, **kwargs):  # noqa: E501
        """Delete all access control entries from all items  # noqa: E501

        Deletes all access control entries from all known items.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_access_controls_from_all_items(async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None.
                 If the method is called asynchronously, returns the request thread.
        :rtype: None or multiprocessing.pool.AsyncResult
        """
        kwargs['_return_http_data_only'] = True
        return self.delete_access_controls_from_all_items_with_http_info(**kwargs)  # noqa: E501

    def delete_access_controls_from_all_items_with_http_info(self, **kwargs):  # noqa: E501
        """Delete all access control entries from all items  # noqa: E501

        Deletes all access control entries from all known items.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_access_controls_from_all_items_with_http_info(async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :key _return_http_data_only: response data without head status code
                                       and headers
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_access_controls_from_all_items" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/item/access', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_access_control(self, type, entity_id, access_id, **kwargs):  # noqa: E501
        """Retrieve an access control entry  # noqa: E501

        Retrieves the desired access control entry.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_access_control(type, entity_id, access_id, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str type: The type of entity. (required)
        :param str entity_id: The entity id. (required)
        :param str access_id: The access id. (required)
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: AccessControlType.
                 If the method is called asynchronously, returns the request thread.
        :rtype: AccessControlType or multiprocessing.pool.AsyncResult
        """
        kwargs['_return_http_data_only'] = True
        return self.get_access_control_with_http_info(type, entity_id, access_id, **kwargs)  # noqa: E501

    def get_access_control_with_http_info(self, type, entity_id, access_id, **kwargs):  # noqa: E501
        """Retrieve an access control entry  # noqa: E501

        Retrieves the desired access control entry.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_access_control_with_http_info(type, entity_id, access_id, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str type: The type of entity. (required)
        :param str entity_id: The entity id. (required)
        :param str access_id: The access id. (required)
        :key _return_http_data_only: response data without head status code
                                       and headers
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(AccessControlType, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['type', 'entity_id', 'access_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_access_control" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'type' is set
        if ('type' not in local_var_params or
                local_var_params['type'] is None):
            raise ApiValueError("Missing the required parameter `type` when calling `get_access_control`")  # noqa: E501
        # verify the required parameter 'entity_id' is set
        if ('entity_id' not in local_var_params or
                local_var_params['entity_id'] is None):
            raise ApiValueError("Missing the required parameter `entity_id` when calling `get_access_control`")  # noqa: E501
        # verify the required parameter 'access_id' is set
        if ('access_id' not in local_var_params or
                local_var_params['access_id'] is None):
            raise ApiValueError("Missing the required parameter `access_id` when calling `get_access_control`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'type' in local_var_params:
            path_params['type'] = local_var_params['type']  # noqa: E501
        if 'entity_id' in local_var_params:
            path_params['entity-id'] = local_var_params['entity_id']  # noqa: E501
        if 'access_id' in local_var_params:
            path_params['access-id'] = local_var_params['access_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'text/plain', 'application/xml'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/{type}/{entity-id}/access/{access-id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AccessControlType',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_access_controls(self, type, entity_id, **kwargs):  # noqa: E501
        """Retrieve the access control list for an entity  # noqa: E501

        Retrieves the entire access control list for the specified entity.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_access_controls(type, entity_id, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str type: The type of entity. (required)
        :param str entity_id: The entity id. (required)
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: AccessControlListType.
                 If the method is called asynchronously, returns the request thread.
        :rtype: AccessControlListType or multiprocessing.pool.AsyncResult
        """
        kwargs['_return_http_data_only'] = True
        return self.get_access_controls_with_http_info(type, entity_id, **kwargs)  # noqa: E501

    def get_access_controls_with_http_info(self, type, entity_id, **kwargs):  # noqa: E501
        """Retrieve the access control list for an entity  # noqa: E501

        Retrieves the entire access control list for the specified entity.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_access_controls_with_http_info(type, entity_id, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str type: The type of entity. (required)
        :param str entity_id: The entity id. (required)
        :key _return_http_data_only: response data without head status code
                                       and headers
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(AccessControlListType, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['type', 'entity_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_access_controls" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'type' is set
        if ('type' not in local_var_params or
                local_var_params['type'] is None):
            raise ApiValueError("Missing the required parameter `type` when calling `get_access_controls`")  # noqa: E501
        # verify the required parameter 'entity_id' is set
        if ('entity_id' not in local_var_params or
                local_var_params['entity_id'] is None):
            raise ApiValueError("Missing the required parameter `entity_id` when calling `get_access_controls`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'type' in local_var_params:
            path_params['type'] = local_var_params['type']  # noqa: E501
        if 'entity_id' in local_var_params:
            path_params['entity-id'] = local_var_params['entity_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'text/plain', 'application/xml'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/{type}/{entity-id}/access', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AccessControlListType',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_access_graph(self, type, entity_id, **kwargs):  # noqa: E501
        """Retrieve the access graph  # noqa: E501

        Shows the entity and any ancestor collections or libraries and the access controls on each. The access-entity can be item or collection (library is not implemented).  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_access_graph(type, entity_id, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str type: The type of entity. (required)
        :param str entity_id: The entity id. (required)
        :key bool users: If the user and group hierarchy should be shown as a subgraph for the relevant users/groups.
        :key str type2: - `ancestor` - Show the entity and ancestor entities in a hierarchy.  - `grant` - Show users and how permissions have been granted.
        :key bool groups: If groups should be shown as nodes in the grant graph.
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: file.
                 If the method is called asynchronously, returns the request thread.
        :rtype: file or multiprocessing.pool.AsyncResult
        """
        kwargs['_return_http_data_only'] = True
        return self.get_access_graph_with_http_info(type, entity_id, **kwargs)  # noqa: E501

    def get_access_graph_with_http_info(self, type, entity_id, **kwargs):  # noqa: E501
        """Retrieve the access graph  # noqa: E501

        Shows the entity and any ancestor collections or libraries and the access controls on each. The access-entity can be item or collection (library is not implemented).  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_access_graph_with_http_info(type, entity_id, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str type: The type of entity. (required)
        :param str entity_id: The entity id. (required)
        :key bool users: If the user and group hierarchy should be shown as a subgraph for the relevant users/groups.
        :key str type2: - `ancestor` - Show the entity and ancestor entities in a hierarchy.  - `grant` - Show users and how permissions have been granted.
        :key bool groups: If groups should be shown as nodes in the grant graph.
        :key _return_http_data_only: response data without head status code
                                       and headers
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(file, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['type', 'entity_id', 'users', 'type2', 'groups']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_access_graph" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'type' is set
        if ('type' not in local_var_params or
                local_var_params['type'] is None):
            raise ApiValueError("Missing the required parameter `type` when calling `get_access_graph`")  # noqa: E501
        # verify the required parameter 'entity_id' is set
        if ('entity_id' not in local_var_params or
                local_var_params['entity_id'] is None):
            raise ApiValueError("Missing the required parameter `entity_id` when calling `get_access_graph`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'type' in local_var_params:
            path_params['type'] = local_var_params['type']  # noqa: E501
        if 'entity_id' in local_var_params:
            path_params['entity-id'] = local_var_params['entity_id']  # noqa: E501

        query_params = []
        if 'users' in local_var_params:
            query_params.append(('users', local_var_params['users']))  # noqa: E501
        if 'type2' in local_var_params:
            query_params.append(('type', local_var_params['type2']))  # noqa: E501
        if 'groups' in local_var_params:
            query_params.append(('groups', local_var_params['groups']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['image/png'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/{type}/{entity-id}/access/graph', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='file',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_access_graph_dot(self, type, entity_id, **kwargs):  # noqa: E501
        """Retrieve the access graph as dot file  # noqa: E501

        Shows the entity and any ancestor collections or libraries and the access controls on each. The access-entity can be item or collection (library is not implemented).  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_access_graph_dot(type, entity_id, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str type: The type of entity. (required)
        :param str entity_id: The entity id. (required)
        :key bool users: If the user and group hierarchy should be shown as a subgraph for the relevant users/groups.
        :key str type2: - `ancestor` - Show the entity and ancestor entities in a hierarchy.  - `grant` - Show users and how permissions have been granted.
        :key bool groups: If groups should be shown as nodes in the grant graph.
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: str.
                 If the method is called asynchronously, returns the request thread.
        :rtype: str or multiprocessing.pool.AsyncResult
        """
        kwargs['_return_http_data_only'] = True
        return self.get_access_graph_dot_with_http_info(type, entity_id, **kwargs)  # noqa: E501

    def get_access_graph_dot_with_http_info(self, type, entity_id, **kwargs):  # noqa: E501
        """Retrieve the access graph as dot file  # noqa: E501

        Shows the entity and any ancestor collections or libraries and the access controls on each. The access-entity can be item or collection (library is not implemented).  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_access_graph_dot_with_http_info(type, entity_id, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str type: The type of entity. (required)
        :param str entity_id: The entity id. (required)
        :key bool users: If the user and group hierarchy should be shown as a subgraph for the relevant users/groups.
        :key str type2: - `ancestor` - Show the entity and ancestor entities in a hierarchy.  - `grant` - Show users and how permissions have been granted.
        :key bool groups: If groups should be shown as nodes in the grant graph.
        :key _return_http_data_only: response data without head status code
                                       and headers
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(str, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['type', 'entity_id', 'users', 'type2', 'groups']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_access_graph_dot" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'type' is set
        if ('type' not in local_var_params or
                local_var_params['type'] is None):
            raise ApiValueError("Missing the required parameter `type` when calling `get_access_graph_dot`")  # noqa: E501
        # verify the required parameter 'entity_id' is set
        if ('entity_id' not in local_var_params or
                local_var_params['entity_id'] is None):
            raise ApiValueError("Missing the required parameter `entity_id` when calling `get_access_graph_dot`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'type' in local_var_params:
            path_params['type'] = local_var_params['type']  # noqa: E501
        if 'entity_id' in local_var_params:
            path_params['entity-id'] = local_var_params['entity_id']  # noqa: E501

        query_params = []
        if 'users' in local_var_params:
            query_params.append(('users', local_var_params['users']))  # noqa: E501
        if 'type2' in local_var_params:
            query_params.append(('type', local_var_params['type2']))  # noqa: E501
        if 'groups' in local_var_params:
            query_params.append(('groups', local_var_params['groups']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/vnd.graphviz', 'text/plain'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/{type}/{entity-id}/access/graph/dot', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='str',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_merged_access(self, type, entity_id, **kwargs):  # noqa: E501
        """List the applied access control entries for an entity  # noqa: E501

        Retrieves a list of all access control entries that affects each user for a given entity. This includes all access derived from the user's group memberships, and from the entity's inclusion in collections or libraries.  There are two modes of operation, either retrieving the access on the item for all users or querying for the access of a specific user. In the former case no parameters are specified and in the latter all parameters must be supplied.  The `access` element of the *AccessControlMergedDocument* includes the following fields:  The entries are listed grouped by user, in order of priority for each user.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_merged_access(type, entity_id, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str type: The type of entity. (required)
        :param str entity_id: The entity id. (required)
        :key str type2: The type of operation to check for.
        :key str permission: The lowest required permission level.
        :key str username: The name of the user to check.
        :key str extradata: Any possible extradata.
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: AccessControlMergedType.
                 If the method is called asynchronously, returns the request thread.
        :rtype: AccessControlMergedType or multiprocessing.pool.AsyncResult
        """
        kwargs['_return_http_data_only'] = True
        return self.get_merged_access_with_http_info(type, entity_id, **kwargs)  # noqa: E501

    def get_merged_access_with_http_info(self, type, entity_id, **kwargs):  # noqa: E501
        """List the applied access control entries for an entity  # noqa: E501

        Retrieves a list of all access control entries that affects each user for a given entity. This includes all access derived from the user's group memberships, and from the entity's inclusion in collections or libraries.  There are two modes of operation, either retrieving the access on the item for all users or querying for the access of a specific user. In the former case no parameters are specified and in the latter all parameters must be supplied.  The `access` element of the *AccessControlMergedDocument* includes the following fields:  The entries are listed grouped by user, in order of priority for each user.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_merged_access_with_http_info(type, entity_id, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str type: The type of entity. (required)
        :param str entity_id: The entity id. (required)
        :key str type2: The type of operation to check for.
        :key str permission: The lowest required permission level.
        :key str username: The name of the user to check.
        :key str extradata: Any possible extradata.
        :key _return_http_data_only: response data without head status code
                                       and headers
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(AccessControlMergedType, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['type', 'entity_id', 'type2', 'permission', 'username', 'extradata']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_merged_access" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'type' is set
        if ('type' not in local_var_params or
                local_var_params['type'] is None):
            raise ApiValueError("Missing the required parameter `type` when calling `get_merged_access`")  # noqa: E501
        # verify the required parameter 'entity_id' is set
        if ('entity_id' not in local_var_params or
                local_var_params['entity_id'] is None):
            raise ApiValueError("Missing the required parameter `entity_id` when calling `get_merged_access`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'type' in local_var_params:
            path_params['type'] = local_var_params['type']  # noqa: E501
        if 'entity_id' in local_var_params:
            path_params['entity-id'] = local_var_params['entity_id']  # noqa: E501

        query_params = []
        if 'type2' in local_var_params:
            query_params.append(('type', local_var_params['type2']))  # noqa: E501
        if 'permission' in local_var_params:
            query_params.append(('permission', local_var_params['permission']))  # noqa: E501
        if 'username' in local_var_params:
            query_params.append(('username', local_var_params['username']))  # noqa: E501
        if 'extradata' in local_var_params:
            query_params.append(('extradata', local_var_params['extradata']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'application/xml'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/{type}/{entity-id}/merged-access/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AccessControlMergedType',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_merged_access_for_group(self, type, entity_id, **kwargs):  # noqa: E501
        """List the applied access control entries that affects groups  # noqa: E501

        Lists groups that have access to an entity.  Even though a user belongs to a group that has access to an entity, the user may not have access due to other access control entries that take precedence.  Groups without users will not appear, unless the group belongs to an inheritance hierarchy that has users.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_merged_access_for_group(type, entity_id, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str type: The type of entity. (required)
        :param str entity_id: The entity id. (required)
        :key bool full: - `true` - Return all access controls that apply for a group.  Also include additional information about the access controls in the response.  - `false` (default) - Return a single access entry with the permission that applies for each group and type.
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: AccessControlMergedGroupType.
                 If the method is called asynchronously, returns the request thread.
        :rtype: AccessControlMergedGroupType or multiprocessing.pool.AsyncResult
        """
        kwargs['_return_http_data_only'] = True
        return self.get_merged_access_for_group_with_http_info(type, entity_id, **kwargs)  # noqa: E501

    def get_merged_access_for_group_with_http_info(self, type, entity_id, **kwargs):  # noqa: E501
        """List the applied access control entries that affects groups  # noqa: E501

        Lists groups that have access to an entity.  Even though a user belongs to a group that has access to an entity, the user may not have access due to other access control entries that take precedence.  Groups without users will not appear, unless the group belongs to an inheritance hierarchy that has users.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_merged_access_for_group_with_http_info(type, entity_id, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str type: The type of entity. (required)
        :param str entity_id: The entity id. (required)
        :key bool full: - `true` - Return all access controls that apply for a group.  Also include additional information about the access controls in the response.  - `false` (default) - Return a single access entry with the permission that applies for each group and type.
        :key _return_http_data_only: response data without head status code
                                       and headers
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(AccessControlMergedGroupType, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['type', 'entity_id', 'full']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_merged_access_for_group" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'type' is set
        if ('type' not in local_var_params or
                local_var_params['type'] is None):
            raise ApiValueError("Missing the required parameter `type` when calling `get_merged_access_for_group`")  # noqa: E501
        # verify the required parameter 'entity_id' is set
        if ('entity_id' not in local_var_params or
                local_var_params['entity_id'] is None):
            raise ApiValueError("Missing the required parameter `entity_id` when calling `get_merged_access_for_group`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'type' in local_var_params:
            path_params['type'] = local_var_params['type']  # noqa: E501
        if 'entity_id' in local_var_params:
            path_params['entity-id'] = local_var_params['entity_id']  # noqa: E501

        query_params = []
        if 'full' in local_var_params:
            query_params.append(('full', local_var_params['full']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'application/xml'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/{type}/{entity-id}/merged-access/group', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AccessControlMergedGroupType',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_owner(self, type, entity_id, username, **kwargs):  # noqa: E501
        """Update the owner of an entity  # noqa: E501

        Update the owner of the specified entity to the specified user.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_owner(type, entity_id, username, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str type: The type of entity. (required)
        :param str entity_id: The entity id. (required)
        :param str username: The username. (required)
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: AccessControlType.
                 If the method is called asynchronously, returns the request thread.
        :rtype: AccessControlType or multiprocessing.pool.AsyncResult
        """
        kwargs['_return_http_data_only'] = True
        return self.update_owner_with_http_info(type, entity_id, username, **kwargs)  # noqa: E501

    def update_owner_with_http_info(self, type, entity_id, username, **kwargs):  # noqa: E501
        """Update the owner of an entity  # noqa: E501

        Update the owner of the specified entity to the specified user.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_owner_with_http_info(type, entity_id, username, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str type: The type of entity. (required)
        :param str entity_id: The entity id. (required)
        :param str username: The username. (required)
        :key _return_http_data_only: response data without head status code
                                       and headers
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(AccessControlType, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['type', 'entity_id', 'username']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_owner" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'type' is set
        if ('type' not in local_var_params or
                local_var_params['type'] is None):
            raise ApiValueError("Missing the required parameter `type` when calling `update_owner`")  # noqa: E501
        # verify the required parameter 'entity_id' is set
        if ('entity_id' not in local_var_params or
                local_var_params['entity_id'] is None):
            raise ApiValueError("Missing the required parameter `entity_id` when calling `update_owner`")  # noqa: E501
        # verify the required parameter 'username' is set
        if ('username' not in local_var_params or
                local_var_params['username'] is None):
            raise ApiValueError("Missing the required parameter `username` when calling `update_owner`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'type' in local_var_params:
            path_params['type'] = local_var_params['type']  # noqa: E501
        if 'entity_id' in local_var_params:
            path_params['entity-id'] = local_var_params['entity_id']  # noqa: E501
        if 'username' in local_var_params:
            path_params['username'] = local_var_params['username']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'application/xml'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/{type}/{entity-id}/access/owner/{username}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AccessControlType',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)
