# coding: utf-8

"""
    Vidispine API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)  # noqa: E501

    The version of the OpenAPI document: 5.x
    Contact: info@vidispine.com
    Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from vidispine.models import *
from vidispine.api_client import ApiClient
from vidispine.exceptions import (
    ApiTypeError,
    ApiValueError
)


class AnalyzeApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def create_item_analyze_job(self, item_id, analyze_job_type, **kwargs):  # noqa: E501
        """Analyze an item  # noqa: E501

        Analyzes an item with the parameters specified in the job document. The result of the analyze will appear in the bulky metadata of the shape when doing a transcoder analysis, or in the metadata of the item when doing a cognitive service analysis.  New in version 5.0.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_item_analyze_job(item_id, analyze_job_type, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str item_id: The item id. (required)
        :param AnalyzeJobType analyze_job_type: (required)
        :key list[str] jobmetadata: Additional information for the job task.
        :key str notification_data: Any additional data to include for notifications on this job.
        :key str storage_id: The storage on which to store a temporary analysis data file when using a Vidinet transcoder to analyze a shape.  If no storage id has been specified Vidispine will (by default) automatically pick a supported storage.  The storage id will be ignored when using a non Vidinet transcoder.
        :key str tag: The shape tag to analyze.  If omitted the original shape tag will be used.
        :key str notification: The placeholder job notification to use for this job.
        :key str priority: The priority to assign to the job.
        :key str resource_id: The transcoder or cognitive service resource to use to execute the analysis.
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: JobType.
                 If the method is called asynchronously, returns the request thread.
        :rtype: JobType or multiprocessing.pool.AsyncResult
        """
        kwargs['_return_http_data_only'] = True
        return self.create_item_analyze_job_with_http_info(item_id, analyze_job_type, **kwargs)  # noqa: E501

    def create_item_analyze_job_with_http_info(self, item_id, analyze_job_type, **kwargs):  # noqa: E501
        """Analyze an item  # noqa: E501

        Analyzes an item with the parameters specified in the job document. The result of the analyze will appear in the bulky metadata of the shape when doing a transcoder analysis, or in the metadata of the item when doing a cognitive service analysis.  New in version 5.0.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_item_analyze_job_with_http_info(item_id, analyze_job_type, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str item_id: The item id. (required)
        :param AnalyzeJobType analyze_job_type: (required)
        :key list[str] jobmetadata: Additional information for the job task.
        :key str notification_data: Any additional data to include for notifications on this job.
        :key str storage_id: The storage on which to store a temporary analysis data file when using a Vidinet transcoder to analyze a shape.  If no storage id has been specified Vidispine will (by default) automatically pick a supported storage.  The storage id will be ignored when using a non Vidinet transcoder.
        :key str tag: The shape tag to analyze.  If omitted the original shape tag will be used.
        :key str notification: The placeholder job notification to use for this job.
        :key str priority: The priority to assign to the job.
        :key str resource_id: The transcoder or cognitive service resource to use to execute the analysis.
        :key _return_http_data_only: response data without head status code
                                       and headers
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(JobType, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['item_id', 'analyze_job_type', 'jobmetadata', 'notification_data', 'storage_id', 'tag', 'notification', 'priority', 'resource_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_item_analyze_job" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'item_id' is set
        if ('item_id' not in local_var_params or
                local_var_params['item_id'] is None):
            raise ApiValueError("Missing the required parameter `item_id` when calling `create_item_analyze_job`")  # noqa: E501
        # verify the required parameter 'analyze_job_type' is set
        if ('analyze_job_type' not in local_var_params or
                local_var_params['analyze_job_type'] is None):
            raise ApiValueError("Missing the required parameter `analyze_job_type` when calling `create_item_analyze_job`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'item_id' in local_var_params:
            path_params['item-id'] = local_var_params['item_id']  # noqa: E501

        query_params = []
        if 'jobmetadata' in local_var_params:
            query_params.append(('jobmetadata', local_var_params['jobmetadata']))  # noqa: E501
            collection_formats['jobmetadata'] = 'multi'  # noqa: E501
        if 'notification_data' in local_var_params:
            query_params.append(('notificationData', local_var_params['notification_data']))  # noqa: E501
        if 'storage_id' in local_var_params:
            query_params.append(('storageId', local_var_params['storage_id']))  # noqa: E501
        if 'tag' in local_var_params:
            query_params.append(('tag', local_var_params['tag']))  # noqa: E501
        if 'notification' in local_var_params:
            query_params.append(('notification', local_var_params['notification']))  # noqa: E501
        if 'priority' in local_var_params:
            query_params.append(('priority', local_var_params['priority']))  # noqa: E501
        if 'resource_id' in local_var_params:
            query_params.append(('resourceId', local_var_params['resource_id']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'analyze_job_type' in local_var_params:
            body_params = local_var_params['analyze_job_type']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'application/xml'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'application/xml'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/item/{item-id}/analyze', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='JobType',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_shape_analyze_job(self, item_id, shape_id, analyze_job_type, **kwargs):  # noqa: E501
        """Analyze a specific shape  # noqa: E501

        Analyzes the specified shape with the parameters specified in the job document. The result of the analyze will appear in the bulky metadata of the shape when doing a transcoder analysis, or in the metadata of the item when doing a cognitive service analysis.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_shape_analyze_job(item_id, shape_id, analyze_job_type, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str item_id: The item id. (required)
        :param str shape_id: The shape id. (required)
        :param AnalyzeJobType analyze_job_type: (required)
        :key list[str] jobmetadata: Additional information for the job task.
        :key str notification_data: Any additional data to include for notifications on this job.
        :key str storage_id: The storage on which to store a temporary analysis data file when using a Vidinet transcoder to analyze a shape.  If no storage id has been specified Vidispine will (by default) automatically pick a supported storage.  The storage id will be ignored when using a non Vidinet transcoder.
        :key str notification: The placeholder job notification to use for this job.
        :key str priority: The priority to assign to the job.
        :key str resource_id: The transcoder or cognitive service resource to use to execute the analysis.
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: JobType.
                 If the method is called asynchronously, returns the request thread.
        :rtype: JobType or multiprocessing.pool.AsyncResult
        """
        kwargs['_return_http_data_only'] = True
        return self.create_shape_analyze_job_with_http_info(item_id, shape_id, analyze_job_type, **kwargs)  # noqa: E501

    def create_shape_analyze_job_with_http_info(self, item_id, shape_id, analyze_job_type, **kwargs):  # noqa: E501
        """Analyze a specific shape  # noqa: E501

        Analyzes the specified shape with the parameters specified in the job document. The result of the analyze will appear in the bulky metadata of the shape when doing a transcoder analysis, or in the metadata of the item when doing a cognitive service analysis.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_shape_analyze_job_with_http_info(item_id, shape_id, analyze_job_type, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str item_id: The item id. (required)
        :param str shape_id: The shape id. (required)
        :param AnalyzeJobType analyze_job_type: (required)
        :key list[str] jobmetadata: Additional information for the job task.
        :key str notification_data: Any additional data to include for notifications on this job.
        :key str storage_id: The storage on which to store a temporary analysis data file when using a Vidinet transcoder to analyze a shape.  If no storage id has been specified Vidispine will (by default) automatically pick a supported storage.  The storage id will be ignored when using a non Vidinet transcoder.
        :key str notification: The placeholder job notification to use for this job.
        :key str priority: The priority to assign to the job.
        :key str resource_id: The transcoder or cognitive service resource to use to execute the analysis.
        :key _return_http_data_only: response data without head status code
                                       and headers
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(JobType, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['item_id', 'shape_id', 'analyze_job_type', 'jobmetadata', 'notification_data', 'storage_id', 'notification', 'priority', 'resource_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_shape_analyze_job" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'item_id' is set
        if ('item_id' not in local_var_params or
                local_var_params['item_id'] is None):
            raise ApiValueError("Missing the required parameter `item_id` when calling `create_shape_analyze_job`")  # noqa: E501
        # verify the required parameter 'shape_id' is set
        if ('shape_id' not in local_var_params or
                local_var_params['shape_id'] is None):
            raise ApiValueError("Missing the required parameter `shape_id` when calling `create_shape_analyze_job`")  # noqa: E501
        # verify the required parameter 'analyze_job_type' is set
        if ('analyze_job_type' not in local_var_params or
                local_var_params['analyze_job_type'] is None):
            raise ApiValueError("Missing the required parameter `analyze_job_type` when calling `create_shape_analyze_job`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'item_id' in local_var_params:
            path_params['item-id'] = local_var_params['item_id']  # noqa: E501
        if 'shape_id' in local_var_params:
            path_params['shape-id'] = local_var_params['shape_id']  # noqa: E501

        query_params = []
        if 'jobmetadata' in local_var_params:
            query_params.append(('jobmetadata', local_var_params['jobmetadata']))  # noqa: E501
            collection_formats['jobmetadata'] = 'multi'  # noqa: E501
        if 'notification_data' in local_var_params:
            query_params.append(('notificationData', local_var_params['notification_data']))  # noqa: E501
        if 'storage_id' in local_var_params:
            query_params.append(('storageId', local_var_params['storage_id']))  # noqa: E501
        if 'notification' in local_var_params:
            query_params.append(('notification', local_var_params['notification']))  # noqa: E501
        if 'priority' in local_var_params:
            query_params.append(('priority', local_var_params['priority']))  # noqa: E501
        if 'resource_id' in local_var_params:
            query_params.append(('resourceId', local_var_params['resource_id']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'analyze_job_type' in local_var_params:
            body_params = local_var_params['analyze_job_type']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'application/xml'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'application/xml'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/item/{item-id}/shape/{shape-id}/analyze', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='JobType',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)
