# coding: utf-8

"""
    Vidispine API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)  # noqa: E501

    The version of the OpenAPI document: 5.x
    Contact: info@vidispine.com
    Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from vidispine.models import *
from vidispine.api_client import ApiClient
from vidispine.exceptions import (
    ApiTypeError,
    ApiValueError
)


class CollectionApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def add_to_collection(self, collection_id, id, **kwargs):  # noqa: E501
        """Add an item, library or collection to a collection  # noqa: E501

        Adds an item, library or collection with the id `id`, to the collection with the id `collection-id`. If `id` is already present within the collection, this is a no-op, except if the query parameter metadata is used. In that case, metadata is updated for the specified entity.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.add_to_collection(collection_id, id, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str collection_id: The collection id. (required)
        :param str id: The id. (required)
        :key str type: - `collection` - The object identified by `id` is a collection.  - `item` (default) - The object identified by `id` is an item.  - `library` - The object identified by `id` is a library.
        :key list[str] metadata: - *key* `=` *value* - Set or add metadata field to the relation between the collection and entity.  Can be used multiple times to add several fields.  The key cannot be empty or start with a minus sign.  To delete a field enter the same key with a minus sign at the beginning.  Note that `=` is part of the query parameter, and has to be encoded (`%3d`).
        :key bool add_items: - `true` - Library items will be added individually.  Only has any effect when `type=library`.  - `false` - Library will be added to collection, not specific items.
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None.
                 If the method is called asynchronously, returns the request thread.
        :rtype: None or multiprocessing.pool.AsyncResult
        """
        kwargs['_return_http_data_only'] = True
        return self.add_to_collection_with_http_info(collection_id, id, **kwargs)  # noqa: E501

    def add_to_collection_with_http_info(self, collection_id, id, **kwargs):  # noqa: E501
        """Add an item, library or collection to a collection  # noqa: E501

        Adds an item, library or collection with the id `id`, to the collection with the id `collection-id`. If `id` is already present within the collection, this is a no-op, except if the query parameter metadata is used. In that case, metadata is updated for the specified entity.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_to_collection_with_http_info(collection_id, id, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str collection_id: The collection id. (required)
        :param str id: The id. (required)
        :key str type: - `collection` - The object identified by `id` is a collection.  - `item` (default) - The object identified by `id` is an item.  - `library` - The object identified by `id` is a library.
        :key list[str] metadata: - *key* `=` *value* - Set or add metadata field to the relation between the collection and entity.  Can be used multiple times to add several fields.  The key cannot be empty or start with a minus sign.  To delete a field enter the same key with a minus sign at the beginning.  Note that `=` is part of the query parameter, and has to be encoded (`%3d`).
        :key bool add_items: - `true` - Library items will be added individually.  Only has any effect when `type=library`.  - `false` - Library will be added to collection, not specific items.
        :key _return_http_data_only: response data without head status code
                                       and headers
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['collection_id', 'id', 'type', 'metadata', 'add_items']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method add_to_collection" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'collection_id' is set
        if ('collection_id' not in local_var_params or
                local_var_params['collection_id'] is None):
            raise ApiValueError("Missing the required parameter `collection_id` when calling `add_to_collection`")  # noqa: E501
        # verify the required parameter 'id' is set
        if ('id' not in local_var_params or
                local_var_params['id'] is None):
            raise ApiValueError("Missing the required parameter `id` when calling `add_to_collection`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'collection_id' in local_var_params:
            path_params['collection-id'] = local_var_params['collection_id']  # noqa: E501
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []
        if 'type' in local_var_params:
            query_params.append(('type', local_var_params['type']))  # noqa: E501
        if 'metadata' in local_var_params:
            query_params.append(('metadata', local_var_params['metadata']))  # noqa: E501
            collection_formats['metadata'] = 'multi'  # noqa: E501
        if 'add_items' in local_var_params:
            query_params.append(('addItems', local_var_params['add_items']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/collection/{collection-id}/{id}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_collection(self, collection_type, **kwargs):  # noqa: E501
        """Create a collection  # noqa: E501

        Generates a new collection and returns the id associated with that collection.  This resource accepts a collection document that can contain both metadata that should be set for the collection and the entities that it should contain.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_collection(collection_type, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param CollectionType collection_type: (required)
        :key str name: Name of the collection.
        :key str settings: Pre-configured import settings.
        :key str external_id: An external identifier to assign to the collection.
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: CollectionType.
                 If the method is called asynchronously, returns the request thread.
        :rtype: CollectionType or multiprocessing.pool.AsyncResult
        """
        kwargs['_return_http_data_only'] = True
        return self.create_collection_with_http_info(collection_type, **kwargs)  # noqa: E501

    def create_collection_with_http_info(self, collection_type, **kwargs):  # noqa: E501
        """Create a collection  # noqa: E501

        Generates a new collection and returns the id associated with that collection.  This resource accepts a collection document that can contain both metadata that should be set for the collection and the entities that it should contain.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_collection_with_http_info(collection_type, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param CollectionType collection_type: (required)
        :key str name: Name of the collection.
        :key str settings: Pre-configured import settings.
        :key str external_id: An external identifier to assign to the collection.
        :key _return_http_data_only: response data without head status code
                                       and headers
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(CollectionType, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['collection_type', 'name', 'settings', 'external_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_collection" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'collection_type' is set
        if ('collection_type' not in local_var_params or
                local_var_params['collection_type'] is None):
            raise ApiValueError("Missing the required parameter `collection_type` when calling `create_collection`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'name' in local_var_params:
            query_params.append(('name', local_var_params['name']))  # noqa: E501
        if 'settings' in local_var_params:
            query_params.append(('settings', local_var_params['settings']))  # noqa: E501
        if 'external_id' in local_var_params:
            query_params.append(('externalId', local_var_params['external_id']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'collection_type' in local_var_params:
            body_params = local_var_params['collection_type']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'text/plain', 'application/xml'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'application/xml'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/collection', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CollectionType',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_collection_export_job(self, collection_id, **kwargs):  # noqa: E501
        """Start an export job for a collection or a library  # noqa: E501

        Creates a new export job that will copy all matching files in the collection/library to a remote location.  A shape tag can be specified to decide which shapes that will be exported. The files will retain their original names and the URI should therefore point to the folder where the files should be placed.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_collection_export_job(collection_id, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str collection_id: The collection id. (required)
        :key list[str] jobmetadata: Additional information for the job task.
        :key list[str] track: Comma-separated list of item track ids.  Can include wildcards, e. g.  `A*`.  Can also contain component ids.
        :key str notification_data: Any additional data to include for notifications on this job.
        :key bool use_original_filename: If set to `true`, the file(s) will be exported with their original filename if available.
        :key str tag: Finds a shape with the specified tag and uses that for export.  If not specified, the system will attempt to use the original shape.
        :key bool all: - `true` (default) - Fail the job if not all files from the selected shapes could be exported.  - `false` - Don't export lost or unavailable files.
        :key str projection: Defines the projection to use when exporting the metadata.
        :key bool use_original_component_filename: If set to `true`, the file(s) will be exported with their original component filename if available.
        :key str notification: The placeholder job notification to use for this job.
        :key str priority: The priority to assign to the job.
        :key str version: - *essence-version-id* - Return shapes for a specified version.  - `all` - Return shapes for all versions.  - `latest` (default) - Return shapes for the latest version.  - `latest-per-shapetag` - Return shapes with the highest essence version number per shape tag.
        :key str uri: A URI to the destination of the file.
        :key bool metadata: - `true` - Metadata will also be exported to side-car XML file.  - `false` (default) - No metadata is exported.
        :key str template: export template to use.
        :key str location_name: The name of an export location.
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: JobType.
                 If the method is called asynchronously, returns the request thread.
        :rtype: JobType or multiprocessing.pool.AsyncResult
        """
        kwargs['_return_http_data_only'] = True
        return self.create_collection_export_job_with_http_info(collection_id, **kwargs)  # noqa: E501

    def create_collection_export_job_with_http_info(self, collection_id, **kwargs):  # noqa: E501
        """Start an export job for a collection or a library  # noqa: E501

        Creates a new export job that will copy all matching files in the collection/library to a remote location.  A shape tag can be specified to decide which shapes that will be exported. The files will retain their original names and the URI should therefore point to the folder where the files should be placed.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_collection_export_job_with_http_info(collection_id, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str collection_id: The collection id. (required)
        :key list[str] jobmetadata: Additional information for the job task.
        :key list[str] track: Comma-separated list of item track ids.  Can include wildcards, e. g.  `A*`.  Can also contain component ids.
        :key str notification_data: Any additional data to include for notifications on this job.
        :key bool use_original_filename: If set to `true`, the file(s) will be exported with their original filename if available.
        :key str tag: Finds a shape with the specified tag and uses that for export.  If not specified, the system will attempt to use the original shape.
        :key bool all: - `true` (default) - Fail the job if not all files from the selected shapes could be exported.  - `false` - Don't export lost or unavailable files.
        :key str projection: Defines the projection to use when exporting the metadata.
        :key bool use_original_component_filename: If set to `true`, the file(s) will be exported with their original component filename if available.
        :key str notification: The placeholder job notification to use for this job.
        :key str priority: The priority to assign to the job.
        :key str version: - *essence-version-id* - Return shapes for a specified version.  - `all` - Return shapes for all versions.  - `latest` (default) - Return shapes for the latest version.  - `latest-per-shapetag` - Return shapes with the highest essence version number per shape tag.
        :key str uri: A URI to the destination of the file.
        :key bool metadata: - `true` - Metadata will also be exported to side-car XML file.  - `false` (default) - No metadata is exported.
        :key str template: export template to use.
        :key str location_name: The name of an export location.
        :key _return_http_data_only: response data without head status code
                                       and headers
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(JobType, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['collection_id', 'jobmetadata', 'track', 'notification_data', 'use_original_filename', 'tag', 'all', 'projection', 'use_original_component_filename', 'notification', 'priority', 'version', 'uri', 'metadata', 'template', 'location_name']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_collection_export_job" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'collection_id' is set
        if ('collection_id' not in local_var_params or
                local_var_params['collection_id'] is None):
            raise ApiValueError("Missing the required parameter `collection_id` when calling `create_collection_export_job`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'collection_id' in local_var_params:
            path_params['collection-id'] = local_var_params['collection_id']  # noqa: E501

        query_params = []
        if 'jobmetadata' in local_var_params:
            query_params.append(('jobmetadata', local_var_params['jobmetadata']))  # noqa: E501
            collection_formats['jobmetadata'] = 'multi'  # noqa: E501
        if 'track' in local_var_params:
            query_params.append(('track', local_var_params['track']))  # noqa: E501
            collection_formats['track'] = 'csv'  # noqa: E501
        if 'notification_data' in local_var_params:
            query_params.append(('notificationData', local_var_params['notification_data']))  # noqa: E501
        if 'use_original_filename' in local_var_params:
            query_params.append(('useOriginalFilename', local_var_params['use_original_filename']))  # noqa: E501
        if 'tag' in local_var_params:
            query_params.append(('tag', local_var_params['tag']))  # noqa: E501
        if 'all' in local_var_params:
            query_params.append(('all', local_var_params['all']))  # noqa: E501
        if 'projection' in local_var_params:
            query_params.append(('projection', local_var_params['projection']))  # noqa: E501
        if 'use_original_component_filename' in local_var_params:
            query_params.append(('useOriginalComponentFilename', local_var_params['use_original_component_filename']))  # noqa: E501
        if 'notification' in local_var_params:
            query_params.append(('notification', local_var_params['notification']))  # noqa: E501
        if 'priority' in local_var_params:
            query_params.append(('priority', local_var_params['priority']))  # noqa: E501
        if 'version' in local_var_params:
            query_params.append(('version', local_var_params['version']))  # noqa: E501
        if 'uri' in local_var_params:
            query_params.append(('uri', local_var_params['uri']))  # noqa: E501
        if 'metadata' in local_var_params:
            query_params.append(('metadata', local_var_params['metadata']))  # noqa: E501
        if 'template' in local_var_params:
            query_params.append(('template', local_var_params['template']))  # noqa: E501
        if 'location_name' in local_var_params:
            query_params.append(('locationName', local_var_params['location_name']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'application/xml'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/collection/{collection-id}/export', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='JobType',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_collection_to_folder_mapping(self, collection_id, **kwargs):  # noqa: E501
        """Mark a collection as folder mapped  # noqa: E501

        Marks collection `collection-id` as mapped to folder. Files in child items will be moved to the corresponding folder in the storages.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_collection_to_folder_mapping(collection_id, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str collection_id: The collection id. (required)
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None.
                 If the method is called asynchronously, returns the request thread.
        :rtype: None or multiprocessing.pool.AsyncResult
        """
        kwargs['_return_http_data_only'] = True
        return self.create_collection_to_folder_mapping_with_http_info(collection_id, **kwargs)  # noqa: E501

    def create_collection_to_folder_mapping_with_http_info(self, collection_id, **kwargs):  # noqa: E501
        """Mark a collection as folder mapped  # noqa: E501

        Marks collection `collection-id` as mapped to folder. Files in child items will be moved to the corresponding folder in the storages.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_collection_to_folder_mapping_with_http_info(collection_id, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str collection_id: The collection id. (required)
        :key _return_http_data_only: response data without head status code
                                       and headers
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['collection_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_collection_to_folder_mapping" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'collection_id' is set
        if ('collection_id' not in local_var_params or
                local_var_params['collection_id'] is None):
            raise ApiValueError("Missing the required parameter `collection_id` when calling `create_collection_to_folder_mapping`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'collection_id' in local_var_params:
            path_params['collection-id'] = local_var_params['collection_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/collection/{collection-id}/map-to-folder', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_collection(self, collection_id, **kwargs):  # noqa: E501
        """Delete a collection  # noqa: E501

        Delete specified collection.  Note that the actual items and libraries that are contained within the collection are not modified.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_collection(collection_id, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str collection_id: The collection id. (required)
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None.
                 If the method is called asynchronously, returns the request thread.
        :rtype: None or multiprocessing.pool.AsyncResult
        """
        kwargs['_return_http_data_only'] = True
        return self.delete_collection_with_http_info(collection_id, **kwargs)  # noqa: E501

    def delete_collection_with_http_info(self, collection_id, **kwargs):  # noqa: E501
        """Delete a collection  # noqa: E501

        Delete specified collection.  Note that the actual items and libraries that are contained within the collection are not modified.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_collection_with_http_info(collection_id, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str collection_id: The collection id. (required)
        :key _return_http_data_only: response data without head status code
                                       and headers
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['collection_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_collection" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'collection_id' is set
        if ('collection_id' not in local_var_params or
                local_var_params['collection_id'] is None):
            raise ApiValueError("Missing the required parameter `collection_id` when calling `delete_collection`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'collection_id' in local_var_params:
            path_params['collection-id'] = local_var_params['collection_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/collection/{collection-id}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_collection_to_folder_mapping(self, collection_id, **kwargs):  # noqa: E501
        """Unmark a collection as folder mapped  # noqa: E501

        Marks collection `collection-id` as *not* mapped to folder. Files in child items will be moved to the root directory in the storages.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_collection_to_folder_mapping(collection_id, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str collection_id: The collection id. (required)
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None.
                 If the method is called asynchronously, returns the request thread.
        :rtype: None or multiprocessing.pool.AsyncResult
        """
        kwargs['_return_http_data_only'] = True
        return self.delete_collection_to_folder_mapping_with_http_info(collection_id, **kwargs)  # noqa: E501

    def delete_collection_to_folder_mapping_with_http_info(self, collection_id, **kwargs):  # noqa: E501
        """Unmark a collection as folder mapped  # noqa: E501

        Marks collection `collection-id` as *not* mapped to folder. Files in child items will be moved to the root directory in the storages.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_collection_to_folder_mapping_with_http_info(collection_id, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str collection_id: The collection id. (required)
        :key _return_http_data_only: response data without head status code
                                       and headers
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['collection_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_collection_to_folder_mapping" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'collection_id' is set
        if ('collection_id' not in local_var_params or
                local_var_params['collection_id'] is None):
            raise ApiValueError("Missing the required parameter `collection_id` when calling `delete_collection_to_folder_mapping`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'collection_id' in local_var_params:
            path_params['collection-id'] = local_var_params['collection_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/collection/{collection-id}/map-to-folder', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_collections(self, id, **kwargs):  # noqa: E501
        """Delete multiple collections  # noqa: E501

        Delete multiple collections.  Note that the actual items and libraries that are contained within the collection are not modified.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_collections(id, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param list[str] id: Comma-separated list of collection ids or external ids. (required)
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None.
                 If the method is called asynchronously, returns the request thread.
        :rtype: None or multiprocessing.pool.AsyncResult
        """
        kwargs['_return_http_data_only'] = True
        return self.delete_collections_with_http_info(id, **kwargs)  # noqa: E501

    def delete_collections_with_http_info(self, id, **kwargs):  # noqa: E501
        """Delete multiple collections  # noqa: E501

        Delete multiple collections.  Note that the actual items and libraries that are contained within the collection are not modified.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_collections_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param list[str] id: Comma-separated list of collection ids or external ids. (required)
        :key _return_http_data_only: response data without head status code
                                       and headers
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_collections" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in local_var_params or
                local_var_params['id'] is None):
            raise ApiValueError("Missing the required parameter `id` when calling `delete_collections`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'id' in local_var_params:
            query_params.append(('id', local_var_params['id']))  # noqa: E501
            collection_formats['id'] = 'csv'  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/collection', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_collection(self, collection_id, **kwargs):  # noqa: E501
        """Retrieve a collection  # noqa: E501

        Return the ids of the objects contained within the collection, that has the id `collection-id`.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_collection(collection_id, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str collection_id: The collection id. (required)
        :key list[str] language: Comma-separated list.   - *language-tag* - Return metadata for specific language, e. g.  `en_US`.  Wildcards may be used, e. g.  `*_CA` for both Canadian French and Canadian English.  - `none` - Return all metadata without language specification.  - `all` (default) - Return all metadata, with or without language specification.
        :key list[str] track: Comma-separated list.   - *track-type* *track-number* - Return metadata for specified track.  Example of track is `A2`.  - *track-type* *t1* `-` *t2* - Return metadata for specified track interval, e. g.  `A2-4`.  - *track-type* `*` - Return metadata for all tracks of specified type, e. g.  `A*`.  - `generic` - Return all non-tracked metadata.  - `all` (default) - All metadata, with or without track specification, are returned.
        :key list[str] children: Comma-separated list of types to include in the result.  Default is to return everything.   - `collection` - Return collections contained in this collection.  - `item` - Return items contained in this collection.  - `library` - Return libraries contained in this collection.  New in version 4. 16. 6.
        :key str conflict: - `yes` (default) - Include all metadata conflicts, unresolved.  - `no` - Return conflicts resolved according to field rules.
        :key str merged_extradata: Any possible extra data.
        :key list[str] content: Comma-separated list of additional content to retrieve.
        :key str terse: - `yes` - Return metadata in terse format.  - `no` (default) - Return metadata in verbose format.
        :key str merged_permission: The lowest required permission level.
        :key str sample_rate: Convert all outgoing time instants to specified rate.  *NB!* Time codes which cannot be expressed in an integer number of samples will be returned as a decimal number, with risk of losing precision.
        :key bool include_transient_metadata: - `true` (default) - Include transient metadata.  - `false` - Do not include transient metadata in response.
        :key str merged_type: The type of operation to check for.
        :key bool default_value: - `true` - For unset fields, return default values.  - `false` (default) - Do not return default values.
        :key list[str] interval: Comma-separated list  - *time-span* - Filter out metadata, return only metadata for specified time span.  - `generic` - Return all non-timed metadata.  - `all` (default) - Return all metadata, same as `interval=generic,-INF-+INF`
        :key list[str] group: Comma-separated list.   - *group-name* - Return specified group.  - *group-name* `+` - Return specified group and subgroups.  - *group-name* `:` *new-name* - Return specified group, renamed to a new name in return value.  - `-` *group-name* - Exclude specified group.  - (default) - Return all groups.
        :key list[str] field: Comma-separated list.   - *field-name* - Return specified field.  - *field-name* \":\" *new-name* - Return specified field, renamed to a new name in return value.  - \"-\" *field-name* - Exclude specified field.  - (default) - Return all fields.
        :key str include: A list of keys.   Includes additional field specific data.  Additionally, if set to `type` the type definition of the field will be retrieved.
        :key str revision: Specifying what revision of metadata to display.  Only used if requesting a single item or collection.
        :key bool include_values: Return the value enumeration for each metadata field.
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: CollectionType.
                 If the method is called asynchronously, returns the request thread.
        :rtype: CollectionType or multiprocessing.pool.AsyncResult
        """
        kwargs['_return_http_data_only'] = True
        return self.get_collection_with_http_info(collection_id, **kwargs)  # noqa: E501

    def get_collection_with_http_info(self, collection_id, **kwargs):  # noqa: E501
        """Retrieve a collection  # noqa: E501

        Return the ids of the objects contained within the collection, that has the id `collection-id`.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_collection_with_http_info(collection_id, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str collection_id: The collection id. (required)
        :key list[str] language: Comma-separated list.   - *language-tag* - Return metadata for specific language, e. g.  `en_US`.  Wildcards may be used, e. g.  `*_CA` for both Canadian French and Canadian English.  - `none` - Return all metadata without language specification.  - `all` (default) - Return all metadata, with or without language specification.
        :key list[str] track: Comma-separated list.   - *track-type* *track-number* - Return metadata for specified track.  Example of track is `A2`.  - *track-type* *t1* `-` *t2* - Return metadata for specified track interval, e. g.  `A2-4`.  - *track-type* `*` - Return metadata for all tracks of specified type, e. g.  `A*`.  - `generic` - Return all non-tracked metadata.  - `all` (default) - All metadata, with or without track specification, are returned.
        :key list[str] children: Comma-separated list of types to include in the result.  Default is to return everything.   - `collection` - Return collections contained in this collection.  - `item` - Return items contained in this collection.  - `library` - Return libraries contained in this collection.  New in version 4. 16. 6.
        :key str conflict: - `yes` (default) - Include all metadata conflicts, unresolved.  - `no` - Return conflicts resolved according to field rules.
        :key str merged_extradata: Any possible extra data.
        :key list[str] content: Comma-separated list of additional content to retrieve.
        :key str terse: - `yes` - Return metadata in terse format.  - `no` (default) - Return metadata in verbose format.
        :key str merged_permission: The lowest required permission level.
        :key str sample_rate: Convert all outgoing time instants to specified rate.  *NB!* Time codes which cannot be expressed in an integer number of samples will be returned as a decimal number, with risk of losing precision.
        :key bool include_transient_metadata: - `true` (default) - Include transient metadata.  - `false` - Do not include transient metadata in response.
        :key str merged_type: The type of operation to check for.
        :key bool default_value: - `true` - For unset fields, return default values.  - `false` (default) - Do not return default values.
        :key list[str] interval: Comma-separated list  - *time-span* - Filter out metadata, return only metadata for specified time span.  - `generic` - Return all non-timed metadata.  - `all` (default) - Return all metadata, same as `interval=generic,-INF-+INF`
        :key list[str] group: Comma-separated list.   - *group-name* - Return specified group.  - *group-name* `+` - Return specified group and subgroups.  - *group-name* `:` *new-name* - Return specified group, renamed to a new name in return value.  - `-` *group-name* - Exclude specified group.  - (default) - Return all groups.
        :key list[str] field: Comma-separated list.   - *field-name* - Return specified field.  - *field-name* \":\" *new-name* - Return specified field, renamed to a new name in return value.  - \"-\" *field-name* - Exclude specified field.  - (default) - Return all fields.
        :key str include: A list of keys.   Includes additional field specific data.  Additionally, if set to `type` the type definition of the field will be retrieved.
        :key str revision: Specifying what revision of metadata to display.  Only used if requesting a single item or collection.
        :key bool include_values: Return the value enumeration for each metadata field.
        :key _return_http_data_only: response data without head status code
                                       and headers
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(CollectionType, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['collection_id', 'language', 'track', 'children', 'conflict', 'merged_extradata', 'content', 'terse', 'merged_permission', 'sample_rate', 'include_transient_metadata', 'merged_type', 'default_value', 'interval', 'group', 'field', 'include', 'revision', 'include_values']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_collection" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'collection_id' is set
        if ('collection_id' not in local_var_params or
                local_var_params['collection_id'] is None):
            raise ApiValueError("Missing the required parameter `collection_id` when calling `get_collection`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'collection_id' in local_var_params:
            path_params['collection-id'] = local_var_params['collection_id']  # noqa: E501

        query_params = []
        if 'language' in local_var_params:
            query_params.append(('language', local_var_params['language']))  # noqa: E501
            collection_formats['language'] = 'csv'  # noqa: E501
        if 'track' in local_var_params:
            query_params.append(('track', local_var_params['track']))  # noqa: E501
            collection_formats['track'] = 'csv'  # noqa: E501
        if 'children' in local_var_params:
            query_params.append(('children', local_var_params['children']))  # noqa: E501
            collection_formats['children'] = 'csv'  # noqa: E501
        if 'conflict' in local_var_params:
            query_params.append(('conflict', local_var_params['conflict']))  # noqa: E501
        if 'merged_extradata' in local_var_params:
            query_params.append(('mergedExtradata', local_var_params['merged_extradata']))  # noqa: E501
        if 'content' in local_var_params:
            query_params.append(('content', local_var_params['content']))  # noqa: E501
            collection_formats['content'] = 'csv'  # noqa: E501
        if 'terse' in local_var_params:
            query_params.append(('terse', local_var_params['terse']))  # noqa: E501
        if 'merged_permission' in local_var_params:
            query_params.append(('mergedPermission', local_var_params['merged_permission']))  # noqa: E501
        if 'sample_rate' in local_var_params:
            query_params.append(('sampleRate', local_var_params['sample_rate']))  # noqa: E501
        if 'include_transient_metadata' in local_var_params:
            query_params.append(('includeTransientMetadata', local_var_params['include_transient_metadata']))  # noqa: E501
        if 'merged_type' in local_var_params:
            query_params.append(('mergedType', local_var_params['merged_type']))  # noqa: E501
        if 'default_value' in local_var_params:
            query_params.append(('defaultValue', local_var_params['default_value']))  # noqa: E501
        if 'interval' in local_var_params:
            query_params.append(('interval', local_var_params['interval']))  # noqa: E501
            collection_formats['interval'] = 'csv'  # noqa: E501
        if 'group' in local_var_params:
            query_params.append(('group', local_var_params['group']))  # noqa: E501
            collection_formats['group'] = 'csv'  # noqa: E501
        if 'field' in local_var_params:
            query_params.append(('field', local_var_params['field']))  # noqa: E501
            collection_formats['field'] = 'csv'  # noqa: E501
        if 'include' in local_var_params:
            query_params.append(('include', local_var_params['include']))  # noqa: E501
        if 'revision' in local_var_params:
            query_params.append(('revision', local_var_params['revision']))  # noqa: E501
        if 'include_values' in local_var_params:
            query_params.append(('includeValues', local_var_params['include_values']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'text/plain', 'application/xml'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/collection/{collection-id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CollectionType',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_collection_ancestors(self, collection_id, **kwargs):  # noqa: E501
        """Retrieve the ancestors of a collection  # noqa: E501

        Retrieves the ids of all ancestors of the collection.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_collection_ancestors(collection_id, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str collection_id: The collection id. (required)
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: URIListType.
                 If the method is called asynchronously, returns the request thread.
        :rtype: URIListType or multiprocessing.pool.AsyncResult
        """
        kwargs['_return_http_data_only'] = True
        return self.get_collection_ancestors_with_http_info(collection_id, **kwargs)  # noqa: E501

    def get_collection_ancestors_with_http_info(self, collection_id, **kwargs):  # noqa: E501
        """Retrieve the ancestors of a collection  # noqa: E501

        Retrieves the ids of all ancestors of the collection.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_collection_ancestors_with_http_info(collection_id, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str collection_id: The collection id. (required)
        :key _return_http_data_only: response data without head status code
                                       and headers
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(URIListType, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['collection_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_collection_ancestors" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'collection_id' is set
        if ('collection_id' not in local_var_params or
                local_var_params['collection_id'] is None):
            raise ApiValueError("Missing the required parameter `collection_id` when calling `get_collection_ancestors`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'collection_id' in local_var_params:
            path_params['collection-id'] = local_var_params['collection_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'text/plain', 'application/xml'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/collection/{collection-id}/ancestor', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='URIListType',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_collection_items(self, collection_id, **kwargs):  # noqa: E501
        """Retrieve the items of a collection  # noqa: E501

        Retrieves only the items of the collection.  Queries on collection items will now return items in creation order by default. See `indexCollectionItemOrder` on how to revert back to using the insert/custom collection item ordering.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_collection_items(collection_id, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str collection_id: The collection id. (required)
        :key list[str] language: Comma-separated list.   - *language-tag* - Return metadata for specific language, e. g.  `en_US`.  Wildcards may be used, e. g.  `*_CA` for both Canadian French and Canadian English.  - `none` - Return all metadata without language specification.  - `all` (default) - Return all metadata, with or without language specification.
        :key str storage_type: Only return URIs for files from storages of this type.
        :key int first: From the resulting list of items, start return list from specified offset.
        :key bool closed_files: A URI parameter:  - `true` (default) - Return only URIs that point to closed files.  - `false` - Return all URIs.
        :key str terse: - `yes` - Return metadata in terse format.  - `no` (default) - Return metadata in verbose format.
        :key str method_metadata: Metadata used with storage method.
        :key str update_frequency: When creating a library, use this update frequency.  Defaults to no periodic updates.
        :key int number: The number of entities to fetch.
        :key list[str] interval: Comma-separated list  - *time-span* - Filter out metadata, return only metadata for specified time span.  - `generic` - Return all non-timed metadata.  - `all` (default) - Return all metadata, same as `interval=generic,-INF-+INF`
        :key list[str] group: Comma-separated list.   - *group-name* - Return specified group.  - *group-name* `+` - Return specified group and subgroups.  - *group-name* `:` *new-name* - Return specified group, renamed to a new name in return value.  - `-` *group-name* - Exclude specified group.  - (default) - Return all groups.
        :key str merged_permission: The lowest required permission level.
        :key str storage_group: Storage group id.  Return only files from storages specified in the storage group.
        :key list[str] track: Comma-separated list.   - *track-type* *track-number* - Return metadata for specified track.  Example of track is `A2`.  - *track-type* *t1* `-` *t2* - Return metadata for specified track interval, e. g.  `A2-4`.  - *track-type* `*` - Return metadata for all tracks of specified type, e. g.  `A*`.  - `generic` - Return all non-tracked metadata.  - `all` (default) - All metadata, with or without track specification, are returned.
        :key str conflict: - `yes` (default) - Include all metadata conflicts, unresolved.  - `no` - Return conflicts resolved according to field rules.
        :key bool starttc: - `true` - Interval is given relative to start timecode of item.  - `false` (default) - Interval is 0-based.
        :key list[str] content: Comma-separated list of the types of content to retrieve.
        :key list[str] uri_type: Comma-separated list of format types (container format) to return.
        :key bool include_transient_metadata: - `true` (default) - Include transient metadata.  - `false` - Do not include transient metadata in response.
        :key str merged_type: The type of operation to check for.
        :key bool default_value: - `true` - For unset fields, return default values.  - `false` (default) - Do not return default values.
        :key str tag: A URI parameter: Comma-separated list of shape tags to return.
        :key list[str] field: Comma-separated list.   - *field-name* - Return specified field.  - *field-name* \":\" *new-name* - Return specified field, renamed to a new name in return value.  - \"-\" *field-name* - Exclude specified field.  - (default) - Return all fields.
        :key str include: A list of keys.   Includes additional field specific data.  Additionally, if set to `type` the type definition of the field will be retrieved.
        :key str method_type: Access method.   - `AUTO` - Gives an APInoauth URI to the media.  Access to file is tunneled through Vidispine.  - `AZURE_SAS` - If the storage schema is azure:// you can get direct access to the media.  The resulting URI will not tunnel through Vidispine but rather point directly to the media location at the azure storage.
        :key str q: XML/JSON, *ItemSearchDocument*.  Only with GET.
        :key list[str] p: Comma-separated list of paths specifying the content to include.  Overrides the content and filter parameters.
        :key str library: Restricts search to within library, identifier.
        :key str base_uri: Which base URI to use for the thumbnail URLs.
        :key str merged_extradata: Any possible extra data.
        :key str result: - `list` (default) - Return a list of items.  - `library` - Create a library with the matching items.
        :key list[str] storage: List of storage ids.  Return only files from specific storages.  Can be specified multiple times.
        :key str revision: Specifying which metadata revision to display.  Only used if requesting a single item or collection.
        :key bool url: - `true` - Return list of URLs.  - `false` (default) - Return list of ids.
        :key str scheme: URI scheme to return.
        :key bool auto_refresh: When creating a library, make it self-refresh.
        :key str version: Specifying which essence version to return for shapes.  If special value `all`, display all versions.  If special value `latest` (default), display latest version of shapes.
        :key str cursor: New in version 4. 16.   - `*` - The initial cursor.  - `string-from-search` - Cursor string returned from the search results.  If set, the cursorMark / search after features from Solr/Elasticsearch would be used to improve the deep paging  performance during a search.  When `cursor` is used, The value of `first` will be ignored.  Only metadata searches in the `generic` interval supports `cursor`.
        :key bool include_values: Return the value enumeration for each metadata field.
        :key str sample_rate: Convert all outgoing time instants to specified rate.  *NB!* Time codes which cannot be expressed in an integer number of samples will be returned as a decimal number, with risk of losing precision.
        :key str library_id: If set, the library identified by this id will be used instead of creating a new library.
        :key bool count: - `true` (default) - Return hits in result.  - `false` - Do not return hits in result, in order to produce results faster.
        :key bool save: - `true` - Returns a `303 See Other`, with a `Location` header containing an URI to fetch the search result - `false` (default) - Returns a regular search result
        :key bool noauth_url: - `true` Return URIs that do not need authentication.  - `false` (default) Return normal URIs
        :key str update_mode: When creating a library, use this update mode.
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: ItemListType.
                 If the method is called asynchronously, returns the request thread.
        :rtype: ItemListType or multiprocessing.pool.AsyncResult
        """
        kwargs['_return_http_data_only'] = True
        return self.get_collection_items_with_http_info(collection_id, **kwargs)  # noqa: E501

    def get_collection_items_with_http_info(self, collection_id, **kwargs):  # noqa: E501
        """Retrieve the items of a collection  # noqa: E501

        Retrieves only the items of the collection.  Queries on collection items will now return items in creation order by default. See `indexCollectionItemOrder` on how to revert back to using the insert/custom collection item ordering.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_collection_items_with_http_info(collection_id, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str collection_id: The collection id. (required)
        :key list[str] language: Comma-separated list.   - *language-tag* - Return metadata for specific language, e. g.  `en_US`.  Wildcards may be used, e. g.  `*_CA` for both Canadian French and Canadian English.  - `none` - Return all metadata without language specification.  - `all` (default) - Return all metadata, with or without language specification.
        :key str storage_type: Only return URIs for files from storages of this type.
        :key int first: From the resulting list of items, start return list from specified offset.
        :key bool closed_files: A URI parameter:  - `true` (default) - Return only URIs that point to closed files.  - `false` - Return all URIs.
        :key str terse: - `yes` - Return metadata in terse format.  - `no` (default) - Return metadata in verbose format.
        :key str method_metadata: Metadata used with storage method.
        :key str update_frequency: When creating a library, use this update frequency.  Defaults to no periodic updates.
        :key int number: The number of entities to fetch.
        :key list[str] interval: Comma-separated list  - *time-span* - Filter out metadata, return only metadata for specified time span.  - `generic` - Return all non-timed metadata.  - `all` (default) - Return all metadata, same as `interval=generic,-INF-+INF`
        :key list[str] group: Comma-separated list.   - *group-name* - Return specified group.  - *group-name* `+` - Return specified group and subgroups.  - *group-name* `:` *new-name* - Return specified group, renamed to a new name in return value.  - `-` *group-name* - Exclude specified group.  - (default) - Return all groups.
        :key str merged_permission: The lowest required permission level.
        :key str storage_group: Storage group id.  Return only files from storages specified in the storage group.
        :key list[str] track: Comma-separated list.   - *track-type* *track-number* - Return metadata for specified track.  Example of track is `A2`.  - *track-type* *t1* `-` *t2* - Return metadata for specified track interval, e. g.  `A2-4`.  - *track-type* `*` - Return metadata for all tracks of specified type, e. g.  `A*`.  - `generic` - Return all non-tracked metadata.  - `all` (default) - All metadata, with or without track specification, are returned.
        :key str conflict: - `yes` (default) - Include all metadata conflicts, unresolved.  - `no` - Return conflicts resolved according to field rules.
        :key bool starttc: - `true` - Interval is given relative to start timecode of item.  - `false` (default) - Interval is 0-based.
        :key list[str] content: Comma-separated list of the types of content to retrieve.
        :key list[str] uri_type: Comma-separated list of format types (container format) to return.
        :key bool include_transient_metadata: - `true` (default) - Include transient metadata.  - `false` - Do not include transient metadata in response.
        :key str merged_type: The type of operation to check for.
        :key bool default_value: - `true` - For unset fields, return default values.  - `false` (default) - Do not return default values.
        :key str tag: A URI parameter: Comma-separated list of shape tags to return.
        :key list[str] field: Comma-separated list.   - *field-name* - Return specified field.  - *field-name* \":\" *new-name* - Return specified field, renamed to a new name in return value.  - \"-\" *field-name* - Exclude specified field.  - (default) - Return all fields.
        :key str include: A list of keys.   Includes additional field specific data.  Additionally, if set to `type` the type definition of the field will be retrieved.
        :key str method_type: Access method.   - `AUTO` - Gives an APInoauth URI to the media.  Access to file is tunneled through Vidispine.  - `AZURE_SAS` - If the storage schema is azure:// you can get direct access to the media.  The resulting URI will not tunnel through Vidispine but rather point directly to the media location at the azure storage.
        :key str q: XML/JSON, *ItemSearchDocument*.  Only with GET.
        :key list[str] p: Comma-separated list of paths specifying the content to include.  Overrides the content and filter parameters.
        :key str library: Restricts search to within library, identifier.
        :key str base_uri: Which base URI to use for the thumbnail URLs.
        :key str merged_extradata: Any possible extra data.
        :key str result: - `list` (default) - Return a list of items.  - `library` - Create a library with the matching items.
        :key list[str] storage: List of storage ids.  Return only files from specific storages.  Can be specified multiple times.
        :key str revision: Specifying which metadata revision to display.  Only used if requesting a single item or collection.
        :key bool url: - `true` - Return list of URLs.  - `false` (default) - Return list of ids.
        :key str scheme: URI scheme to return.
        :key bool auto_refresh: When creating a library, make it self-refresh.
        :key str version: Specifying which essence version to return for shapes.  If special value `all`, display all versions.  If special value `latest` (default), display latest version of shapes.
        :key str cursor: New in version 4. 16.   - `*` - The initial cursor.  - `string-from-search` - Cursor string returned from the search results.  If set, the cursorMark / search after features from Solr/Elasticsearch would be used to improve the deep paging  performance during a search.  When `cursor` is used, The value of `first` will be ignored.  Only metadata searches in the `generic` interval supports `cursor`.
        :key bool include_values: Return the value enumeration for each metadata field.
        :key str sample_rate: Convert all outgoing time instants to specified rate.  *NB!* Time codes which cannot be expressed in an integer number of samples will be returned as a decimal number, with risk of losing precision.
        :key str library_id: If set, the library identified by this id will be used instead of creating a new library.
        :key bool count: - `true` (default) - Return hits in result.  - `false` - Do not return hits in result, in order to produce results faster.
        :key bool save: - `true` - Returns a `303 See Other`, with a `Location` header containing an URI to fetch the search result - `false` (default) - Returns a regular search result
        :key bool noauth_url: - `true` Return URIs that do not need authentication.  - `false` (default) Return normal URIs
        :key str update_mode: When creating a library, use this update mode.
        :key _return_http_data_only: response data without head status code
                                       and headers
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(ItemListType, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['collection_id', 'language', 'storage_type', 'first', 'closed_files', 'terse', 'method_metadata', 'update_frequency', 'number', 'interval', 'group', 'merged_permission', 'storage_group', 'track', 'conflict', 'starttc', 'content', 'uri_type', 'include_transient_metadata', 'merged_type', 'default_value', 'tag', 'field', 'include', 'method_type', 'q', 'p', 'library', 'base_uri', 'merged_extradata', 'result', 'storage', 'revision', 'url', 'scheme', 'auto_refresh', 'version', 'cursor', 'include_values', 'sample_rate', 'library_id', 'count', 'save', 'noauth_url', 'update_mode']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_collection_items" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'collection_id' is set
        if ('collection_id' not in local_var_params or
                local_var_params['collection_id'] is None):
            raise ApiValueError("Missing the required parameter `collection_id` when calling `get_collection_items`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'collection_id' in local_var_params:
            path_params['collection-id'] = local_var_params['collection_id']  # noqa: E501

        query_params = []
        if 'language' in local_var_params:
            query_params.append(('language', local_var_params['language']))  # noqa: E501
            collection_formats['language'] = 'csv'  # noqa: E501
        if 'storage_type' in local_var_params:
            query_params.append(('storageType', local_var_params['storage_type']))  # noqa: E501
        if 'first' in local_var_params:
            query_params.append(('first', local_var_params['first']))  # noqa: E501
        if 'closed_files' in local_var_params:
            query_params.append(('closedFiles', local_var_params['closed_files']))  # noqa: E501
        if 'terse' in local_var_params:
            query_params.append(('terse', local_var_params['terse']))  # noqa: E501
        if 'method_metadata' in local_var_params:
            query_params.append(('methodMetadata', local_var_params['method_metadata']))  # noqa: E501
        if 'update_frequency' in local_var_params:
            query_params.append(('updateFrequency', local_var_params['update_frequency']))  # noqa: E501
        if 'number' in local_var_params:
            query_params.append(('number', local_var_params['number']))  # noqa: E501
        if 'interval' in local_var_params:
            query_params.append(('interval', local_var_params['interval']))  # noqa: E501
            collection_formats['interval'] = 'csv'  # noqa: E501
        if 'group' in local_var_params:
            query_params.append(('group', local_var_params['group']))  # noqa: E501
            collection_formats['group'] = 'csv'  # noqa: E501
        if 'merged_permission' in local_var_params:
            query_params.append(('mergedPermission', local_var_params['merged_permission']))  # noqa: E501
        if 'storage_group' in local_var_params:
            query_params.append(('storageGroup', local_var_params['storage_group']))  # noqa: E501
        if 'track' in local_var_params:
            query_params.append(('track', local_var_params['track']))  # noqa: E501
            collection_formats['track'] = 'csv'  # noqa: E501
        if 'conflict' in local_var_params:
            query_params.append(('conflict', local_var_params['conflict']))  # noqa: E501
        if 'starttc' in local_var_params:
            query_params.append(('starttc', local_var_params['starttc']))  # noqa: E501
        if 'content' in local_var_params:
            query_params.append(('content', local_var_params['content']))  # noqa: E501
            collection_formats['content'] = 'csv'  # noqa: E501
        if 'uri_type' in local_var_params:
            query_params.append(('uriType', local_var_params['uri_type']))  # noqa: E501
            collection_formats['uriType'] = 'csv'  # noqa: E501
        if 'include_transient_metadata' in local_var_params:
            query_params.append(('includeTransientMetadata', local_var_params['include_transient_metadata']))  # noqa: E501
        if 'merged_type' in local_var_params:
            query_params.append(('mergedType', local_var_params['merged_type']))  # noqa: E501
        if 'default_value' in local_var_params:
            query_params.append(('defaultValue', local_var_params['default_value']))  # noqa: E501
        if 'tag' in local_var_params:
            query_params.append(('tag', local_var_params['tag']))  # noqa: E501
        if 'field' in local_var_params:
            query_params.append(('field', local_var_params['field']))  # noqa: E501
            collection_formats['field'] = 'csv'  # noqa: E501
        if 'include' in local_var_params:
            query_params.append(('include', local_var_params['include']))  # noqa: E501
        if 'method_type' in local_var_params:
            query_params.append(('methodType', local_var_params['method_type']))  # noqa: E501
        if 'q' in local_var_params:
            query_params.append(('q', local_var_params['q']))  # noqa: E501
        if 'p' in local_var_params:
            query_params.append(('p', local_var_params['p']))  # noqa: E501
            collection_formats['p'] = 'csv'  # noqa: E501
        if 'library' in local_var_params:
            query_params.append(('library', local_var_params['library']))  # noqa: E501
        if 'base_uri' in local_var_params:
            query_params.append(('baseURI', local_var_params['base_uri']))  # noqa: E501
        if 'merged_extradata' in local_var_params:
            query_params.append(('mergedExtradata', local_var_params['merged_extradata']))  # noqa: E501
        if 'result' in local_var_params:
            query_params.append(('result', local_var_params['result']))  # noqa: E501
        if 'storage' in local_var_params:
            query_params.append(('storage', local_var_params['storage']))  # noqa: E501
            collection_formats['storage'] = 'multi'  # noqa: E501
        if 'revision' in local_var_params:
            query_params.append(('revision', local_var_params['revision']))  # noqa: E501
        if 'url' in local_var_params:
            query_params.append(('url', local_var_params['url']))  # noqa: E501
        if 'scheme' in local_var_params:
            query_params.append(('scheme', local_var_params['scheme']))  # noqa: E501
        if 'auto_refresh' in local_var_params:
            query_params.append(('autoRefresh', local_var_params['auto_refresh']))  # noqa: E501
        if 'version' in local_var_params:
            query_params.append(('version', local_var_params['version']))  # noqa: E501
        if 'cursor' in local_var_params:
            query_params.append(('cursor', local_var_params['cursor']))  # noqa: E501
        if 'include_values' in local_var_params:
            query_params.append(('includeValues', local_var_params['include_values']))  # noqa: E501
        if 'sample_rate' in local_var_params:
            query_params.append(('sampleRate', local_var_params['sample_rate']))  # noqa: E501
        if 'library_id' in local_var_params:
            query_params.append(('libraryId', local_var_params['library_id']))  # noqa: E501
        if 'count' in local_var_params:
            query_params.append(('count', local_var_params['count']))  # noqa: E501
        if 'save' in local_var_params:
            query_params.append(('save', local_var_params['save']))  # noqa: E501
        if 'noauth_url' in local_var_params:
            query_params.append(('noauth-url', local_var_params['noauth_url']))  # noqa: E501
        if 'update_mode' in local_var_params:
            query_params.append(('updateMode', local_var_params['update_mode']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'text/plain', 'application/xml'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/collection/{collection-id}/item', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ItemListType',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_collection_search_history(self, **kwargs):  # noqa: E501
        """Retrieve the search history  # noqa: E501

        Retrieves a list of searches made by a particular user, include \"Collection search \" and \"Item and collection search\". The results are ordered according to timestamp, with the latest searches being first. Duplicate queries will not be retrieved.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_collection_search_history(async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :key int max_results: The maximum number of searches that will be retrieved.  The value must be between 1 and 50.
        :key str username: The name of the user that has performed the searched.  If not specified, the user performing the request will be selected.
        :key str start: If set, only searches made after this date will be retrieved.
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: SearchHistoryListType.
                 If the method is called asynchronously, returns the request thread.
        :rtype: SearchHistoryListType or multiprocessing.pool.AsyncResult
        """
        kwargs['_return_http_data_only'] = True
        return self.get_collection_search_history_with_http_info(**kwargs)  # noqa: E501

    def get_collection_search_history_with_http_info(self, **kwargs):  # noqa: E501
        """Retrieve the search history  # noqa: E501

        Retrieves a list of searches made by a particular user, include \"Collection search \" and \"Item and collection search\". The results are ordered according to timestamp, with the latest searches being first. Duplicate queries will not be retrieved.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_collection_search_history_with_http_info(async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :key int max_results: The maximum number of searches that will be retrieved.  The value must be between 1 and 50.
        :key str username: The name of the user that has performed the searched.  If not specified, the user performing the request will be selected.
        :key str start: If set, only searches made after this date will be retrieved.
        :key _return_http_data_only: response data without head status code
                                       and headers
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(SearchHistoryListType, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['max_results', 'username', 'start']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_collection_search_history" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'max_results' in local_var_params:
            query_params.append(('maxResults', local_var_params['max_results']))  # noqa: E501
        if 'username' in local_var_params:
            query_params.append(('username', local_var_params['username']))  # noqa: E501
        if 'start' in local_var_params:
            query_params.append(('start', local_var_params['start']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'application/xml'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/collection/history', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SearchHistoryListType',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_collections(self, **kwargs):  # noqa: E501
        """List all collections  # noqa: E501

        Retrieves a list of all known collections.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_collections(async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :key list[str] language: Comma-separated list.   - *language-tag* - Return metadata for specific language, e. g.  `en_US`.  Wildcards may be used, e. g.  `*_CA` for both Canadian French and Canadian English.  - `none` - Return all metadata without language specification.  - `all` (default) - Return all metadata, with or without language specification.
        :key list[str] track: Comma-separated list.   - *track-type* *track-number* - Return metadata for specified track.  Example of track is `A2`.  - *track-type* *t1* `-` *t2* - Return metadata for specified track interval, e. g.  `A2-4`.  - *track-type* `*` - Return metadata for all tracks of specified type, e. g.  `A*`.  - `generic` - Return all non-tracked metadata.  - `all` (default) - All metadata, with or without track specification, are returned.
        :key str conflict: - `yes` (default) - Include all metadata conflicts, unresolved.  - `no` - Return conflicts resolved according to field rules.
        :key str merged_extradata: Any possible extra data.
        :key int first: From the resulting list of items, start return list from specified offset.
        :key list[str] content: Comma-separated list of additional content to retrieve.
        :key list[str] interval: Comma-separated list  - *time-span* - Filter out metadata, return only metadata for specified time span.  - `generic` - Return all non-timed metadata.  - `all` (default) - Return all metadata, same as `interval=generic,-INF-+INF`
        :key str cursor: New in version 4. 16.   - `*` - The initial cursor.  - `string-from-search` - Cursor string returned from the search results.  If set, the cursorMark / search after features from Solr/Elasticsearch would be used to improve the deep paging  performance during a search.  When `cursor` is used, The value of `first` will be ignored.  Only metadata searches in the `generic` interval supports `cursor`.
        :key str merged_permission: The lowest required permission level.
        :key str sample_rate: Convert all outgoing time instants to specified rate.  *NB!* Time codes which cannot be expressed in an integer number of samples will be returned as a decimal number, with risk of losing precision.
        :key bool include_transient_metadata: - `true` (default) - Include transient metadata.  - `false` - Do not include transient metadata in response.
        :key str merged_type: The type of operation to check for.
        :key str terse: - `yes` - Return metadata in terse format.  - `no` (default) - Return metadata in verbose format.
        :key bool default_value: - `true` - For unset fields, return default values.  - `false` (default) - Do not return default values.
        :key int number: The number of entities to fetch.
        :key bool count: - `true` (default) - Return hits in result.  - `false` - Do not return hits in result, in order to produce results faster.
        :key list[str] group: Comma-separated list.   - *group-name* - Return specified group.  - *group-name* `+` - Return specified group and subgroups.  - *group-name* `:` *new-name* - Return specified group, renamed to a new name in return value.  - `-` *group-name* - Exclude specified group.  - (default) - Return all groups.
        :key list[str] field: Comma-separated list.   - *field-name* - Return specified field.  - *field-name* \":\" *new-name* - Return specified field, renamed to a new name in return value.  - \"-\" *field-name* - Exclude specified field.  - (default) - Return all fields.
        :key str include: A list of keys.   Includes additional field specific data.  Additionally, if set to `type` the type definition of the field will be retrieved.
        :key str revision: Specifying what revision of metadata to display.  Only used if requesting a single item or collection.
        :key bool include_values: Return the value enumeration for each metadata field.
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: CollectionListType.
                 If the method is called asynchronously, returns the request thread.
        :rtype: CollectionListType or multiprocessing.pool.AsyncResult
        """
        kwargs['_return_http_data_only'] = True
        return self.get_collections_with_http_info(**kwargs)  # noqa: E501

    def get_collections_with_http_info(self, **kwargs):  # noqa: E501
        """List all collections  # noqa: E501

        Retrieves a list of all known collections.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_collections_with_http_info(async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :key list[str] language: Comma-separated list.   - *language-tag* - Return metadata for specific language, e. g.  `en_US`.  Wildcards may be used, e. g.  `*_CA` for both Canadian French and Canadian English.  - `none` - Return all metadata without language specification.  - `all` (default) - Return all metadata, with or without language specification.
        :key list[str] track: Comma-separated list.   - *track-type* *track-number* - Return metadata for specified track.  Example of track is `A2`.  - *track-type* *t1* `-` *t2* - Return metadata for specified track interval, e. g.  `A2-4`.  - *track-type* `*` - Return metadata for all tracks of specified type, e. g.  `A*`.  - `generic` - Return all non-tracked metadata.  - `all` (default) - All metadata, with or without track specification, are returned.
        :key str conflict: - `yes` (default) - Include all metadata conflicts, unresolved.  - `no` - Return conflicts resolved according to field rules.
        :key str merged_extradata: Any possible extra data.
        :key int first: From the resulting list of items, start return list from specified offset.
        :key list[str] content: Comma-separated list of additional content to retrieve.
        :key list[str] interval: Comma-separated list  - *time-span* - Filter out metadata, return only metadata for specified time span.  - `generic` - Return all non-timed metadata.  - `all` (default) - Return all metadata, same as `interval=generic,-INF-+INF`
        :key str cursor: New in version 4. 16.   - `*` - The initial cursor.  - `string-from-search` - Cursor string returned from the search results.  If set, the cursorMark / search after features from Solr/Elasticsearch would be used to improve the deep paging  performance during a search.  When `cursor` is used, The value of `first` will be ignored.  Only metadata searches in the `generic` interval supports `cursor`.
        :key str merged_permission: The lowest required permission level.
        :key str sample_rate: Convert all outgoing time instants to specified rate.  *NB!* Time codes which cannot be expressed in an integer number of samples will be returned as a decimal number, with risk of losing precision.
        :key bool include_transient_metadata: - `true` (default) - Include transient metadata.  - `false` - Do not include transient metadata in response.
        :key str merged_type: The type of operation to check for.
        :key str terse: - `yes` - Return metadata in terse format.  - `no` (default) - Return metadata in verbose format.
        :key bool default_value: - `true` - For unset fields, return default values.  - `false` (default) - Do not return default values.
        :key int number: The number of entities to fetch.
        :key bool count: - `true` (default) - Return hits in result.  - `false` - Do not return hits in result, in order to produce results faster.
        :key list[str] group: Comma-separated list.   - *group-name* - Return specified group.  - *group-name* `+` - Return specified group and subgroups.  - *group-name* `:` *new-name* - Return specified group, renamed to a new name in return value.  - `-` *group-name* - Exclude specified group.  - (default) - Return all groups.
        :key list[str] field: Comma-separated list.   - *field-name* - Return specified field.  - *field-name* \":\" *new-name* - Return specified field, renamed to a new name in return value.  - \"-\" *field-name* - Exclude specified field.  - (default) - Return all fields.
        :key str include: A list of keys.   Includes additional field specific data.  Additionally, if set to `type` the type definition of the field will be retrieved.
        :key str revision: Specifying what revision of metadata to display.  Only used if requesting a single item or collection.
        :key bool include_values: Return the value enumeration for each metadata field.
        :key _return_http_data_only: response data without head status code
                                       and headers
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(CollectionListType, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['language', 'track', 'conflict', 'merged_extradata', 'first', 'content', 'interval', 'cursor', 'merged_permission', 'sample_rate', 'include_transient_metadata', 'merged_type', 'terse', 'default_value', 'number', 'count', 'group', 'field', 'include', 'revision', 'include_values']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_collections" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'language' in local_var_params:
            query_params.append(('language', local_var_params['language']))  # noqa: E501
            collection_formats['language'] = 'csv'  # noqa: E501
        if 'track' in local_var_params:
            query_params.append(('track', local_var_params['track']))  # noqa: E501
            collection_formats['track'] = 'csv'  # noqa: E501
        if 'conflict' in local_var_params:
            query_params.append(('conflict', local_var_params['conflict']))  # noqa: E501
        if 'merged_extradata' in local_var_params:
            query_params.append(('mergedExtradata', local_var_params['merged_extradata']))  # noqa: E501
        if 'first' in local_var_params:
            query_params.append(('first', local_var_params['first']))  # noqa: E501
        if 'content' in local_var_params:
            query_params.append(('content', local_var_params['content']))  # noqa: E501
            collection_formats['content'] = 'csv'  # noqa: E501
        if 'interval' in local_var_params:
            query_params.append(('interval', local_var_params['interval']))  # noqa: E501
            collection_formats['interval'] = 'csv'  # noqa: E501
        if 'cursor' in local_var_params:
            query_params.append(('cursor', local_var_params['cursor']))  # noqa: E501
        if 'merged_permission' in local_var_params:
            query_params.append(('mergedPermission', local_var_params['merged_permission']))  # noqa: E501
        if 'sample_rate' in local_var_params:
            query_params.append(('sampleRate', local_var_params['sample_rate']))  # noqa: E501
        if 'include_transient_metadata' in local_var_params:
            query_params.append(('includeTransientMetadata', local_var_params['include_transient_metadata']))  # noqa: E501
        if 'merged_type' in local_var_params:
            query_params.append(('mergedType', local_var_params['merged_type']))  # noqa: E501
        if 'terse' in local_var_params:
            query_params.append(('terse', local_var_params['terse']))  # noqa: E501
        if 'default_value' in local_var_params:
            query_params.append(('defaultValue', local_var_params['default_value']))  # noqa: E501
        if 'number' in local_var_params:
            query_params.append(('number', local_var_params['number']))  # noqa: E501
        if 'count' in local_var_params:
            query_params.append(('count', local_var_params['count']))  # noqa: E501
        if 'group' in local_var_params:
            query_params.append(('group', local_var_params['group']))  # noqa: E501
            collection_formats['group'] = 'csv'  # noqa: E501
        if 'field' in local_var_params:
            query_params.append(('field', local_var_params['field']))  # noqa: E501
            collection_formats['field'] = 'csv'  # noqa: E501
        if 'include' in local_var_params:
            query_params.append(('include', local_var_params['include']))  # noqa: E501
        if 'revision' in local_var_params:
            query_params.append(('revision', local_var_params['revision']))  # noqa: E501
        if 'include_values' in local_var_params:
            query_params.append(('includeValues', local_var_params['include_values']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'text/plain', 'application/xml'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/collection', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CollectionListType',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def remove_from_collection(self, collection_id, id, **kwargs):  # noqa: E501
        """Remove an item, library or collection from a collection  # noqa: E501

        Attempts to remove specific content with the id, `id`, from a collection with the id `collection-id`.  Note that the object corresponding to the id is not altered.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.remove_from_collection(collection_id, id, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str collection_id: The collection id. (required)
        :param str id: The id. (required)
        :key str type: - `collection` - The object identified by `id` is a collection.  - `item` (default) - The object identified by `id` is an item.  - `library` - The object identified by `id` is a library.
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None.
                 If the method is called asynchronously, returns the request thread.
        :rtype: None or multiprocessing.pool.AsyncResult
        """
        kwargs['_return_http_data_only'] = True
        return self.remove_from_collection_with_http_info(collection_id, id, **kwargs)  # noqa: E501

    def remove_from_collection_with_http_info(self, collection_id, id, **kwargs):  # noqa: E501
        """Remove an item, library or collection from a collection  # noqa: E501

        Attempts to remove specific content with the id, `id`, from a collection with the id `collection-id`.  Note that the object corresponding to the id is not altered.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.remove_from_collection_with_http_info(collection_id, id, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str collection_id: The collection id. (required)
        :param str id: The id. (required)
        :key str type: - `collection` - The object identified by `id` is a collection.  - `item` (default) - The object identified by `id` is an item.  - `library` - The object identified by `id` is a library.
        :key _return_http_data_only: response data without head status code
                                       and headers
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['collection_id', 'id', 'type']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method remove_from_collection" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'collection_id' is set
        if ('collection_id' not in local_var_params or
                local_var_params['collection_id'] is None):
            raise ApiValueError("Missing the required parameter `collection_id` when calling `remove_from_collection`")  # noqa: E501
        # verify the required parameter 'id' is set
        if ('id' not in local_var_params or
                local_var_params['id'] is None):
            raise ApiValueError("Missing the required parameter `id` when calling `remove_from_collection`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'collection_id' in local_var_params:
            path_params['collection-id'] = local_var_params['collection_id']  # noqa: E501
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []
        if 'type' in local_var_params:
            query_params.append(('type', local_var_params['type']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/collection/{collection-id}/{id}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def reorder_collection_elements(self, collection_id, collection_reorder_type, **kwargs):  # noqa: E501
        """Reorder collection elements  # noqa: E501

        Changes the order of the elements. Note that the reordering elements are parsed and applied in the sequence that they are supplied.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.reorder_collection_elements(collection_id, collection_reorder_type, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str collection_id: The collection id. (required)
        :param CollectionReorderType collection_reorder_type: <em>CollectionReorderDocument</em> containing the changes to the order. (required)
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: CollectionType.
                 If the method is called asynchronously, returns the request thread.
        :rtype: CollectionType or multiprocessing.pool.AsyncResult
        """
        kwargs['_return_http_data_only'] = True
        return self.reorder_collection_elements_with_http_info(collection_id, collection_reorder_type, **kwargs)  # noqa: E501

    def reorder_collection_elements_with_http_info(self, collection_id, collection_reorder_type, **kwargs):  # noqa: E501
        """Reorder collection elements  # noqa: E501

        Changes the order of the elements. Note that the reordering elements are parsed and applied in the sequence that they are supplied.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.reorder_collection_elements_with_http_info(collection_id, collection_reorder_type, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str collection_id: The collection id. (required)
        :param CollectionReorderType collection_reorder_type: <em>CollectionReorderDocument</em> containing the changes to the order. (required)
        :key _return_http_data_only: response data without head status code
                                       and headers
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(CollectionType, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['collection_id', 'collection_reorder_type']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method reorder_collection_elements" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'collection_id' is set
        if ('collection_id' not in local_var_params or
                local_var_params['collection_id'] is None):
            raise ApiValueError("Missing the required parameter `collection_id` when calling `reorder_collection_elements`")  # noqa: E501
        # verify the required parameter 'collection_reorder_type' is set
        if ('collection_reorder_type' not in local_var_params or
                local_var_params['collection_reorder_type'] is None):
            raise ApiValueError("Missing the required parameter `collection_reorder_type` when calling `reorder_collection_elements`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'collection_id' in local_var_params:
            path_params['collection-id'] = local_var_params['collection_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'collection_reorder_type' in local_var_params:
            body_params = local_var_params['collection_reorder_type']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'text/plain', 'application/xml'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'application/xml'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/collection/{collection-id}/order', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CollectionType',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def search_collections(self, item_search_type, **kwargs):  # noqa: E501
        """Search for collections  # noqa: E501

        Searches for collections that matches the query.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.search_collections(item_search_type, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param ItemSearchType item_search_type: (required)
        :key list[str] language: Comma-separated list.   - *language-tag* - Return metadata for specific language, e. g.  `en_US`.  Wildcards may be used, e. g.  `*_CA` for both Canadian French and Canadian English.  - `none` - Return all metadata without language specification.  - `all` (default) - Return all metadata, with or without language specification.
        :key list[str] track: Comma-separated list.   - *track-type* *track-number* - Return metadata for specified track.  Example of track is `A2`.  - *track-type* *t1* `-` *t2* - Return metadata for specified track interval, e. g.  `A2-4`.  - *track-type* `*` - Return metadata for all tracks of specified type, e. g.  `A*`.  - `generic` - Return all non-tracked metadata.  - `all` (default) - All metadata, with or without track specification, are returned.
        :key str conflict: - `yes` (default) - Include all metadata conflicts, unresolved.  - `no` - Return conflicts resolved according to field rules.
        :key str merged_extradata: Any possible extra data.
        :key int first: The index of the first collection.
        :key list[str] content: Comma-separated list of additional content to retrieve.
        :key list[str] interval: Comma-separated list  - *time-span* - Filter out metadata, return only metadata for specified time span.  - `generic` - Return all non-timed metadata.  - `all` (default) - Return all metadata, same as `interval=generic,-INF-+INF`
        :key str cursor: New in version 4. 16.   - `*` - The initial cursor.  - `string-from-search` - Cursor string returned from the search results.  If set, the cursorMark / search after features from Solr/Elasticsearch would be used to improve the deep paging  performance during a search.  When `cursor` is used, The value of `first` will be ignored.  Only metadata searches in the `generic` interval supports `cursor`.
        :key str merged_permission: The lowest required permission level.
        :key str sample_rate: Convert all outgoing time instants to specified rate.  *NB!* Time codes which cannot be expressed in an integer number of samples will be returned as a decimal number, with risk of losing precision.
        :key bool include_transient_metadata: - `true` (default) - Include transient metadata.  - `false` - Do not include transient metadata in response.
        :key str merged_type: The type of operation to check for.
        :key str terse: - `yes` - Return metadata in terse format.  - `no` (default) - Return metadata in verbose format.
        :key bool default_value: - `true` - For unset fields, return default values.  - `false` (default) - Do not return default values.
        :key int number: The number of collections to retrieve.
        :key bool count: - `true` (default) - Return hits in result.  - `false` - Do not return hits in result, in order to produce results faster.
        :key list[str] group: Comma-separated list.   - *group-name* - Return specified group.  - *group-name* `+` - Return specified group and subgroups.  - *group-name* `:` *new-name* - Return specified group, renamed to a new name in return value.  - `-` *group-name* - Exclude specified group.  - (default) - Return all groups.
        :key list[str] field: Comma-separated list.   - *field-name* - Return specified field.  - *field-name* \":\" *new-name* - Return specified field, renamed to a new name in return value.  - \"-\" *field-name* - Exclude specified field.  - (default) - Return all fields.
        :key str include: A list of keys.   Includes additional field specific data.  Additionally, if set to `type` the type definition of the field will be retrieved.
        :key str revision: Specifying what revision of metadata to display.  Only used if requesting a single item or collection.
        :key bool include_values: Return the value enumeration for each metadata field.
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: CollectionListType.
                 If the method is called asynchronously, returns the request thread.
        :rtype: CollectionListType or multiprocessing.pool.AsyncResult
        """
        kwargs['_return_http_data_only'] = True
        return self.search_collections_with_http_info(item_search_type, **kwargs)  # noqa: E501

    def search_collections_with_http_info(self, item_search_type, **kwargs):  # noqa: E501
        """Search for collections  # noqa: E501

        Searches for collections that matches the query.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.search_collections_with_http_info(item_search_type, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param ItemSearchType item_search_type: (required)
        :key list[str] language: Comma-separated list.   - *language-tag* - Return metadata for specific language, e. g.  `en_US`.  Wildcards may be used, e. g.  `*_CA` for both Canadian French and Canadian English.  - `none` - Return all metadata without language specification.  - `all` (default) - Return all metadata, with or without language specification.
        :key list[str] track: Comma-separated list.   - *track-type* *track-number* - Return metadata for specified track.  Example of track is `A2`.  - *track-type* *t1* `-` *t2* - Return metadata for specified track interval, e. g.  `A2-4`.  - *track-type* `*` - Return metadata for all tracks of specified type, e. g.  `A*`.  - `generic` - Return all non-tracked metadata.  - `all` (default) - All metadata, with or without track specification, are returned.
        :key str conflict: - `yes` (default) - Include all metadata conflicts, unresolved.  - `no` - Return conflicts resolved according to field rules.
        :key str merged_extradata: Any possible extra data.
        :key int first: The index of the first collection.
        :key list[str] content: Comma-separated list of additional content to retrieve.
        :key list[str] interval: Comma-separated list  - *time-span* - Filter out metadata, return only metadata for specified time span.  - `generic` - Return all non-timed metadata.  - `all` (default) - Return all metadata, same as `interval=generic,-INF-+INF`
        :key str cursor: New in version 4. 16.   - `*` - The initial cursor.  - `string-from-search` - Cursor string returned from the search results.  If set, the cursorMark / search after features from Solr/Elasticsearch would be used to improve the deep paging  performance during a search.  When `cursor` is used, The value of `first` will be ignored.  Only metadata searches in the `generic` interval supports `cursor`.
        :key str merged_permission: The lowest required permission level.
        :key str sample_rate: Convert all outgoing time instants to specified rate.  *NB!* Time codes which cannot be expressed in an integer number of samples will be returned as a decimal number, with risk of losing precision.
        :key bool include_transient_metadata: - `true` (default) - Include transient metadata.  - `false` - Do not include transient metadata in response.
        :key str merged_type: The type of operation to check for.
        :key str terse: - `yes` - Return metadata in terse format.  - `no` (default) - Return metadata in verbose format.
        :key bool default_value: - `true` - For unset fields, return default values.  - `false` (default) - Do not return default values.
        :key int number: The number of collections to retrieve.
        :key bool count: - `true` (default) - Return hits in result.  - `false` - Do not return hits in result, in order to produce results faster.
        :key list[str] group: Comma-separated list.   - *group-name* - Return specified group.  - *group-name* `+` - Return specified group and subgroups.  - *group-name* `:` *new-name* - Return specified group, renamed to a new name in return value.  - `-` *group-name* - Exclude specified group.  - (default) - Return all groups.
        :key list[str] field: Comma-separated list.   - *field-name* - Return specified field.  - *field-name* \":\" *new-name* - Return specified field, renamed to a new name in return value.  - \"-\" *field-name* - Exclude specified field.  - (default) - Return all fields.
        :key str include: A list of keys.   Includes additional field specific data.  Additionally, if set to `type` the type definition of the field will be retrieved.
        :key str revision: Specifying what revision of metadata to display.  Only used if requesting a single item or collection.
        :key bool include_values: Return the value enumeration for each metadata field.
        :key _return_http_data_only: response data without head status code
                                       and headers
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(CollectionListType, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['item_search_type', 'language', 'track', 'conflict', 'merged_extradata', 'first', 'content', 'interval', 'cursor', 'merged_permission', 'sample_rate', 'include_transient_metadata', 'merged_type', 'terse', 'default_value', 'number', 'count', 'group', 'field', 'include', 'revision', 'include_values']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method search_collections" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'item_search_type' is set
        if ('item_search_type' not in local_var_params or
                local_var_params['item_search_type'] is None):
            raise ApiValueError("Missing the required parameter `item_search_type` when calling `search_collections`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'language' in local_var_params:
            query_params.append(('language', local_var_params['language']))  # noqa: E501
            collection_formats['language'] = 'csv'  # noqa: E501
        if 'track' in local_var_params:
            query_params.append(('track', local_var_params['track']))  # noqa: E501
            collection_formats['track'] = 'csv'  # noqa: E501
        if 'conflict' in local_var_params:
            query_params.append(('conflict', local_var_params['conflict']))  # noqa: E501
        if 'merged_extradata' in local_var_params:
            query_params.append(('mergedExtradata', local_var_params['merged_extradata']))  # noqa: E501
        if 'first' in local_var_params:
            query_params.append(('first', local_var_params['first']))  # noqa: E501
        if 'content' in local_var_params:
            query_params.append(('content', local_var_params['content']))  # noqa: E501
            collection_formats['content'] = 'csv'  # noqa: E501
        if 'interval' in local_var_params:
            query_params.append(('interval', local_var_params['interval']))  # noqa: E501
            collection_formats['interval'] = 'csv'  # noqa: E501
        if 'cursor' in local_var_params:
            query_params.append(('cursor', local_var_params['cursor']))  # noqa: E501
        if 'merged_permission' in local_var_params:
            query_params.append(('mergedPermission', local_var_params['merged_permission']))  # noqa: E501
        if 'sample_rate' in local_var_params:
            query_params.append(('sampleRate', local_var_params['sample_rate']))  # noqa: E501
        if 'include_transient_metadata' in local_var_params:
            query_params.append(('includeTransientMetadata', local_var_params['include_transient_metadata']))  # noqa: E501
        if 'merged_type' in local_var_params:
            query_params.append(('mergedType', local_var_params['merged_type']))  # noqa: E501
        if 'terse' in local_var_params:
            query_params.append(('terse', local_var_params['terse']))  # noqa: E501
        if 'default_value' in local_var_params:
            query_params.append(('defaultValue', local_var_params['default_value']))  # noqa: E501
        if 'number' in local_var_params:
            query_params.append(('number', local_var_params['number']))  # noqa: E501
        if 'count' in local_var_params:
            query_params.append(('count', local_var_params['count']))  # noqa: E501
        if 'group' in local_var_params:
            query_params.append(('group', local_var_params['group']))  # noqa: E501
            collection_formats['group'] = 'csv'  # noqa: E501
        if 'field' in local_var_params:
            query_params.append(('field', local_var_params['field']))  # noqa: E501
            collection_formats['field'] = 'csv'  # noqa: E501
        if 'include' in local_var_params:
            query_params.append(('include', local_var_params['include']))  # noqa: E501
        if 'revision' in local_var_params:
            query_params.append(('revision', local_var_params['revision']))  # noqa: E501
        if 'include_values' in local_var_params:
            query_params.append(('includeValues', local_var_params['include_values']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'item_search_type' in local_var_params:
            body_params = local_var_params['item_search_type']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'application/xml'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'application/xml'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/collection', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CollectionListType',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def search_items_in_collection(self, collection_id, item_search_type, **kwargs):  # noqa: E501
        """Search for items within a collection  # noqa: E501

        Performs a search among the items in the specified collection.  Queries on collection items will now return items in creation order by default. See `indexCollectionItemOrder` on how to revert back to using the insert/custom collection item ordering.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.search_items_in_collection(collection_id, item_search_type, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str collection_id: The collection id. (required)
        :param ItemSearchType item_search_type: (required)
        :key list[str] language: Comma-separated list.   - *language-tag* - Return metadata for specific language, e. g.  `en_US`.  Wildcards may be used, e. g.  `*_CA` for both Canadian French and Canadian English.  - `none` - Return all metadata without language specification.  - `all` (default) - Return all metadata, with or without language specification.
        :key str storage_type: Only return URIs for files from storages of this type.
        :key int first: From the resulting list of items, start return list from specified offset.
        :key bool closed_files: A URI parameter:  - `true` (default) - Return only URIs that point to closed files.  - `false` - Return all URIs.
        :key str terse: - `yes` - Return metadata in terse format.  - `no` (default) - Return metadata in verbose format.
        :key str method_metadata: Metadata used with storage method.
        :key str update_frequency: When creating a library, use this update frequency.  Defaults to no periodic updates.
        :key int number: The number of entities to fetch.
        :key list[str] interval: Comma-separated list  - *time-span* - Filter out metadata, return only metadata for specified time span.  - `generic` - Return all non-timed metadata.  - `all` (default) - Return all metadata, same as `interval=generic,-INF-+INF`
        :key list[str] group: Comma-separated list.   - *group-name* - Return specified group.  - *group-name* `+` - Return specified group and subgroups.  - *group-name* `:` *new-name* - Return specified group, renamed to a new name in return value.  - `-` *group-name* - Exclude specified group.  - (default) - Return all groups.
        :key str merged_permission: The lowest required permission level.
        :key str storage_group: Storage group id.  Return only files from storages specified in the storage group.
        :key list[str] track: Comma-separated list.   - *track-type* *track-number* - Return metadata for specified track.  Example of track is `A2`.  - *track-type* *t1* `-` *t2* - Return metadata for specified track interval, e. g.  `A2-4`.  - *track-type* `*` - Return metadata for all tracks of specified type, e. g.  `A*`.  - `generic` - Return all non-tracked metadata.  - `all` (default) - All metadata, with or without track specification, are returned.
        :key str conflict: - `yes` (default) - Include all metadata conflicts, unresolved.  - `no` - Return conflicts resolved according to field rules.
        :key bool starttc: - `true` - Interval is given relative to start timecode of item.  - `false` (default) - Interval is 0-based.
        :key list[str] content: Comma-separated list of the types of content to retrieve.
        :key list[str] uri_type: Comma-separated list of format types (container format) to return.
        :key bool include_transient_metadata: - `true` (default) - Include transient metadata.  - `false` - Do not include transient metadata in response.
        :key str merged_type: The type of operation to check for.
        :key bool default_value: - `true` - For unset fields, return default values.  - `false` (default) - Do not return default values.
        :key str tag: A URI parameter: Comma-separated list of shape tags to return.
        :key list[str] field: Comma-separated list.   - *field-name* - Return specified field.  - *field-name* \":\" *new-name* - Return specified field, renamed to a new name in return value.  - \"-\" *field-name* - Exclude specified field.  - (default) - Return all fields.
        :key str include: A list of keys.   Includes additional field specific data.  Additionally, if set to `type` the type definition of the field will be retrieved.
        :key str method_type: Access method.   - `AUTO` - Gives an APInoauth URI to the media.  Access to file is tunneled through Vidispine.  - `AZURE_SAS` - If the storage schema is azure:// you can get direct access to the media.  The resulting URI will not tunnel through Vidispine but rather point directly to the media location at the azure storage.
        :key str q: XML/JSON, *ItemSearchDocument*.  Only with GET.
        :key list[str] p: Comma-separated list of paths specifying the content to include.  Overrides the content and filter parameters.
        :key str library: Restricts search to within library, identifier.
        :key str base_uri: Which base URI to use for the thumbnail URLs.
        :key str merged_extradata: Any possible extra data.
        :key str result: - `list` (default) - Return a list of items.  - `library` - Create a library with the matching items.
        :key list[str] storage: List of storage ids.  Return only files from specific storages.  Can be specified multiple times.
        :key str revision: Specifying which metadata revision to display.  Only used if requesting a single item or collection.
        :key bool url: - `true` - Return list of URLs.  - `false` (default) - Return list of ids.
        :key str scheme: URI scheme to return.
        :key bool auto_refresh: When creating a library, make it self-refresh.
        :key str version: Specifying which essence version to return for shapes.  If special value `all`, display all versions.  If special value `latest` (default), display latest version of shapes.
        :key str cursor: New in version 4. 16.   - `*` - The initial cursor.  - `string-from-search` - Cursor string returned from the search results.  If set, the cursorMark / search after features from Solr/Elasticsearch would be used to improve the deep paging  performance during a search.  When `cursor` is used, The value of `first` will be ignored.  Only metadata searches in the `generic` interval supports `cursor`.
        :key bool include_values: Return the value enumeration for each metadata field.
        :key str sample_rate: Convert all outgoing time instants to specified rate.  *NB!* Time codes which cannot be expressed in an integer number of samples will be returned as a decimal number, with risk of losing precision.
        :key str library_id: If set, the library identified by this id will be used instead of creating a new library.
        :key bool count: - `true` (default) - Return hits in result.  - `false` - Do not return hits in result, in order to produce results faster.
        :key bool save: - `true` - Returns a `303 See Other`, with a `Location` header containing an URI to fetch the search result - `false` (default) - Returns a regular search result
        :key bool noauth_url: - `true` Return URIs that do not need authentication.  - `false` (default) Return normal URIs
        :key str update_mode: When creating a library, use this update mode.
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: ItemListType.
                 If the method is called asynchronously, returns the request thread.
        :rtype: ItemListType or multiprocessing.pool.AsyncResult
        """
        kwargs['_return_http_data_only'] = True
        return self.search_items_in_collection_with_http_info(collection_id, item_search_type, **kwargs)  # noqa: E501

    def search_items_in_collection_with_http_info(self, collection_id, item_search_type, **kwargs):  # noqa: E501
        """Search for items within a collection  # noqa: E501

        Performs a search among the items in the specified collection.  Queries on collection items will now return items in creation order by default. See `indexCollectionItemOrder` on how to revert back to using the insert/custom collection item ordering.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.search_items_in_collection_with_http_info(collection_id, item_search_type, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str collection_id: The collection id. (required)
        :param ItemSearchType item_search_type: (required)
        :key list[str] language: Comma-separated list.   - *language-tag* - Return metadata for specific language, e. g.  `en_US`.  Wildcards may be used, e. g.  `*_CA` for both Canadian French and Canadian English.  - `none` - Return all metadata without language specification.  - `all` (default) - Return all metadata, with or without language specification.
        :key str storage_type: Only return URIs for files from storages of this type.
        :key int first: From the resulting list of items, start return list from specified offset.
        :key bool closed_files: A URI parameter:  - `true` (default) - Return only URIs that point to closed files.  - `false` - Return all URIs.
        :key str terse: - `yes` - Return metadata in terse format.  - `no` (default) - Return metadata in verbose format.
        :key str method_metadata: Metadata used with storage method.
        :key str update_frequency: When creating a library, use this update frequency.  Defaults to no periodic updates.
        :key int number: The number of entities to fetch.
        :key list[str] interval: Comma-separated list  - *time-span* - Filter out metadata, return only metadata for specified time span.  - `generic` - Return all non-timed metadata.  - `all` (default) - Return all metadata, same as `interval=generic,-INF-+INF`
        :key list[str] group: Comma-separated list.   - *group-name* - Return specified group.  - *group-name* `+` - Return specified group and subgroups.  - *group-name* `:` *new-name* - Return specified group, renamed to a new name in return value.  - `-` *group-name* - Exclude specified group.  - (default) - Return all groups.
        :key str merged_permission: The lowest required permission level.
        :key str storage_group: Storage group id.  Return only files from storages specified in the storage group.
        :key list[str] track: Comma-separated list.   - *track-type* *track-number* - Return metadata for specified track.  Example of track is `A2`.  - *track-type* *t1* `-` *t2* - Return metadata for specified track interval, e. g.  `A2-4`.  - *track-type* `*` - Return metadata for all tracks of specified type, e. g.  `A*`.  - `generic` - Return all non-tracked metadata.  - `all` (default) - All metadata, with or without track specification, are returned.
        :key str conflict: - `yes` (default) - Include all metadata conflicts, unresolved.  - `no` - Return conflicts resolved according to field rules.
        :key bool starttc: - `true` - Interval is given relative to start timecode of item.  - `false` (default) - Interval is 0-based.
        :key list[str] content: Comma-separated list of the types of content to retrieve.
        :key list[str] uri_type: Comma-separated list of format types (container format) to return.
        :key bool include_transient_metadata: - `true` (default) - Include transient metadata.  - `false` - Do not include transient metadata in response.
        :key str merged_type: The type of operation to check for.
        :key bool default_value: - `true` - For unset fields, return default values.  - `false` (default) - Do not return default values.
        :key str tag: A URI parameter: Comma-separated list of shape tags to return.
        :key list[str] field: Comma-separated list.   - *field-name* - Return specified field.  - *field-name* \":\" *new-name* - Return specified field, renamed to a new name in return value.  - \"-\" *field-name* - Exclude specified field.  - (default) - Return all fields.
        :key str include: A list of keys.   Includes additional field specific data.  Additionally, if set to `type` the type definition of the field will be retrieved.
        :key str method_type: Access method.   - `AUTO` - Gives an APInoauth URI to the media.  Access to file is tunneled through Vidispine.  - `AZURE_SAS` - If the storage schema is azure:// you can get direct access to the media.  The resulting URI will not tunnel through Vidispine but rather point directly to the media location at the azure storage.
        :key str q: XML/JSON, *ItemSearchDocument*.  Only with GET.
        :key list[str] p: Comma-separated list of paths specifying the content to include.  Overrides the content and filter parameters.
        :key str library: Restricts search to within library, identifier.
        :key str base_uri: Which base URI to use for the thumbnail URLs.
        :key str merged_extradata: Any possible extra data.
        :key str result: - `list` (default) - Return a list of items.  - `library` - Create a library with the matching items.
        :key list[str] storage: List of storage ids.  Return only files from specific storages.  Can be specified multiple times.
        :key str revision: Specifying which metadata revision to display.  Only used if requesting a single item or collection.
        :key bool url: - `true` - Return list of URLs.  - `false` (default) - Return list of ids.
        :key str scheme: URI scheme to return.
        :key bool auto_refresh: When creating a library, make it self-refresh.
        :key str version: Specifying which essence version to return for shapes.  If special value `all`, display all versions.  If special value `latest` (default), display latest version of shapes.
        :key str cursor: New in version 4. 16.   - `*` - The initial cursor.  - `string-from-search` - Cursor string returned from the search results.  If set, the cursorMark / search after features from Solr/Elasticsearch would be used to improve the deep paging  performance during a search.  When `cursor` is used, The value of `first` will be ignored.  Only metadata searches in the `generic` interval supports `cursor`.
        :key bool include_values: Return the value enumeration for each metadata field.
        :key str sample_rate: Convert all outgoing time instants to specified rate.  *NB!* Time codes which cannot be expressed in an integer number of samples will be returned as a decimal number, with risk of losing precision.
        :key str library_id: If set, the library identified by this id will be used instead of creating a new library.
        :key bool count: - `true` (default) - Return hits in result.  - `false` - Do not return hits in result, in order to produce results faster.
        :key bool save: - `true` - Returns a `303 See Other`, with a `Location` header containing an URI to fetch the search result - `false` (default) - Returns a regular search result
        :key bool noauth_url: - `true` Return URIs that do not need authentication.  - `false` (default) Return normal URIs
        :key str update_mode: When creating a library, use this update mode.
        :key _return_http_data_only: response data without head status code
                                       and headers
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(ItemListType, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['collection_id', 'item_search_type', 'language', 'storage_type', 'first', 'closed_files', 'terse', 'method_metadata', 'update_frequency', 'number', 'interval', 'group', 'merged_permission', 'storage_group', 'track', 'conflict', 'starttc', 'content', 'uri_type', 'include_transient_metadata', 'merged_type', 'default_value', 'tag', 'field', 'include', 'method_type', 'q', 'p', 'library', 'base_uri', 'merged_extradata', 'result', 'storage', 'revision', 'url', 'scheme', 'auto_refresh', 'version', 'cursor', 'include_values', 'sample_rate', 'library_id', 'count', 'save', 'noauth_url', 'update_mode']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method search_items_in_collection" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'collection_id' is set
        if ('collection_id' not in local_var_params or
                local_var_params['collection_id'] is None):
            raise ApiValueError("Missing the required parameter `collection_id` when calling `search_items_in_collection`")  # noqa: E501
        # verify the required parameter 'item_search_type' is set
        if ('item_search_type' not in local_var_params or
                local_var_params['item_search_type'] is None):
            raise ApiValueError("Missing the required parameter `item_search_type` when calling `search_items_in_collection`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'collection_id' in local_var_params:
            path_params['collection-id'] = local_var_params['collection_id']  # noqa: E501

        query_params = []
        if 'language' in local_var_params:
            query_params.append(('language', local_var_params['language']))  # noqa: E501
            collection_formats['language'] = 'csv'  # noqa: E501
        if 'storage_type' in local_var_params:
            query_params.append(('storageType', local_var_params['storage_type']))  # noqa: E501
        if 'first' in local_var_params:
            query_params.append(('first', local_var_params['first']))  # noqa: E501
        if 'closed_files' in local_var_params:
            query_params.append(('closedFiles', local_var_params['closed_files']))  # noqa: E501
        if 'terse' in local_var_params:
            query_params.append(('terse', local_var_params['terse']))  # noqa: E501
        if 'method_metadata' in local_var_params:
            query_params.append(('methodMetadata', local_var_params['method_metadata']))  # noqa: E501
        if 'update_frequency' in local_var_params:
            query_params.append(('updateFrequency', local_var_params['update_frequency']))  # noqa: E501
        if 'number' in local_var_params:
            query_params.append(('number', local_var_params['number']))  # noqa: E501
        if 'interval' in local_var_params:
            query_params.append(('interval', local_var_params['interval']))  # noqa: E501
            collection_formats['interval'] = 'csv'  # noqa: E501
        if 'group' in local_var_params:
            query_params.append(('group', local_var_params['group']))  # noqa: E501
            collection_formats['group'] = 'csv'  # noqa: E501
        if 'merged_permission' in local_var_params:
            query_params.append(('mergedPermission', local_var_params['merged_permission']))  # noqa: E501
        if 'storage_group' in local_var_params:
            query_params.append(('storageGroup', local_var_params['storage_group']))  # noqa: E501
        if 'track' in local_var_params:
            query_params.append(('track', local_var_params['track']))  # noqa: E501
            collection_formats['track'] = 'csv'  # noqa: E501
        if 'conflict' in local_var_params:
            query_params.append(('conflict', local_var_params['conflict']))  # noqa: E501
        if 'starttc' in local_var_params:
            query_params.append(('starttc', local_var_params['starttc']))  # noqa: E501
        if 'content' in local_var_params:
            query_params.append(('content', local_var_params['content']))  # noqa: E501
            collection_formats['content'] = 'csv'  # noqa: E501
        if 'uri_type' in local_var_params:
            query_params.append(('uriType', local_var_params['uri_type']))  # noqa: E501
            collection_formats['uriType'] = 'csv'  # noqa: E501
        if 'include_transient_metadata' in local_var_params:
            query_params.append(('includeTransientMetadata', local_var_params['include_transient_metadata']))  # noqa: E501
        if 'merged_type' in local_var_params:
            query_params.append(('mergedType', local_var_params['merged_type']))  # noqa: E501
        if 'default_value' in local_var_params:
            query_params.append(('defaultValue', local_var_params['default_value']))  # noqa: E501
        if 'tag' in local_var_params:
            query_params.append(('tag', local_var_params['tag']))  # noqa: E501
        if 'field' in local_var_params:
            query_params.append(('field', local_var_params['field']))  # noqa: E501
            collection_formats['field'] = 'csv'  # noqa: E501
        if 'include' in local_var_params:
            query_params.append(('include', local_var_params['include']))  # noqa: E501
        if 'method_type' in local_var_params:
            query_params.append(('methodType', local_var_params['method_type']))  # noqa: E501
        if 'q' in local_var_params:
            query_params.append(('q', local_var_params['q']))  # noqa: E501
        if 'p' in local_var_params:
            query_params.append(('p', local_var_params['p']))  # noqa: E501
            collection_formats['p'] = 'csv'  # noqa: E501
        if 'library' in local_var_params:
            query_params.append(('library', local_var_params['library']))  # noqa: E501
        if 'base_uri' in local_var_params:
            query_params.append(('baseURI', local_var_params['base_uri']))  # noqa: E501
        if 'merged_extradata' in local_var_params:
            query_params.append(('mergedExtradata', local_var_params['merged_extradata']))  # noqa: E501
        if 'result' in local_var_params:
            query_params.append(('result', local_var_params['result']))  # noqa: E501
        if 'storage' in local_var_params:
            query_params.append(('storage', local_var_params['storage']))  # noqa: E501
            collection_formats['storage'] = 'multi'  # noqa: E501
        if 'revision' in local_var_params:
            query_params.append(('revision', local_var_params['revision']))  # noqa: E501
        if 'url' in local_var_params:
            query_params.append(('url', local_var_params['url']))  # noqa: E501
        if 'scheme' in local_var_params:
            query_params.append(('scheme', local_var_params['scheme']))  # noqa: E501
        if 'auto_refresh' in local_var_params:
            query_params.append(('autoRefresh', local_var_params['auto_refresh']))  # noqa: E501
        if 'version' in local_var_params:
            query_params.append(('version', local_var_params['version']))  # noqa: E501
        if 'cursor' in local_var_params:
            query_params.append(('cursor', local_var_params['cursor']))  # noqa: E501
        if 'include_values' in local_var_params:
            query_params.append(('includeValues', local_var_params['include_values']))  # noqa: E501
        if 'sample_rate' in local_var_params:
            query_params.append(('sampleRate', local_var_params['sample_rate']))  # noqa: E501
        if 'library_id' in local_var_params:
            query_params.append(('libraryId', local_var_params['library_id']))  # noqa: E501
        if 'count' in local_var_params:
            query_params.append(('count', local_var_params['count']))  # noqa: E501
        if 'save' in local_var_params:
            query_params.append(('save', local_var_params['save']))  # noqa: E501
        if 'noauth_url' in local_var_params:
            query_params.append(('noauth-url', local_var_params['noauth_url']))  # noqa: E501
        if 'update_mode' in local_var_params:
            query_params.append(('updateMode', local_var_params['update_mode']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'item_search_type' in local_var_params:
            body_params = local_var_params['item_search_type']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'text/plain', 'application/xml'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'application/xml'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/collection/{collection-id}/item', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ItemListType',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_collection(self, collection_id, collection_type, **kwargs):  # noqa: E501
        """Update a collection  # noqa: E501

        Updates the content of the collection with the id `collection-id` as specified in the document. It is also possible to change the name of the collection  and metadata of the collection-entity relations.  Either all or no entities must have a mode specified. If no entities have a mode specified and the document contains an entity that does not exist in the collection, then the entity will be added.  When no entities have a mode specified the entities will get the same position as they are ordered in the document.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_collection(collection_id, collection_type, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str collection_id: The collection id. (required)
        :param CollectionType collection_type: <em>CollectionDocument</em> that contains the entity ids. (required)
        :key bool clear: - `true` (default) - All entities that are in the collection but not specified in the document will be removed.  Only has any effect when no entities have a mode specified.  - `false` - All entities in the document will be appended to the collection.  If an entity already exist in the collection then the position is determined by the document.  Only has any effect when no entities have a mode specified.
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: CollectionType.
                 If the method is called asynchronously, returns the request thread.
        :rtype: CollectionType or multiprocessing.pool.AsyncResult
        """
        kwargs['_return_http_data_only'] = True
        return self.update_collection_with_http_info(collection_id, collection_type, **kwargs)  # noqa: E501

    def update_collection_with_http_info(self, collection_id, collection_type, **kwargs):  # noqa: E501
        """Update a collection  # noqa: E501

        Updates the content of the collection with the id `collection-id` as specified in the document. It is also possible to change the name of the collection  and metadata of the collection-entity relations.  Either all or no entities must have a mode specified. If no entities have a mode specified and the document contains an entity that does not exist in the collection, then the entity will be added.  When no entities have a mode specified the entities will get the same position as they are ordered in the document.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_collection_with_http_info(collection_id, collection_type, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str collection_id: The collection id. (required)
        :param CollectionType collection_type: <em>CollectionDocument</em> that contains the entity ids. (required)
        :key bool clear: - `true` (default) - All entities that are in the collection but not specified in the document will be removed.  Only has any effect when no entities have a mode specified.  - `false` - All entities in the document will be appended to the collection.  If an entity already exist in the collection then the position is determined by the document.  Only has any effect when no entities have a mode specified.
        :key _return_http_data_only: response data without head status code
                                       and headers
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(CollectionType, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['collection_id', 'collection_type', 'clear']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_collection" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'collection_id' is set
        if ('collection_id' not in local_var_params or
                local_var_params['collection_id'] is None):
            raise ApiValueError("Missing the required parameter `collection_id` when calling `update_collection`")  # noqa: E501
        # verify the required parameter 'collection_type' is set
        if ('collection_type' not in local_var_params or
                local_var_params['collection_type'] is None):
            raise ApiValueError("Missing the required parameter `collection_type` when calling `update_collection`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'collection_id' in local_var_params:
            path_params['collection-id'] = local_var_params['collection_id']  # noqa: E501

        query_params = []
        if 'clear' in local_var_params:
            query_params.append(('clear', local_var_params['clear']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'collection_type' in local_var_params:
            body_params = local_var_params['collection_type']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'application/xml'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'application/xml'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/collection/{collection-id}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CollectionType',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_collection_folder_name(self, name, collection_id, **kwargs):  # noqa: E501
        """Report that the folder name has changed on disk  # noqa: E501

        If the folder name has been changed by a user or an external program, it can be reported to Vidispine with this command. The affected file entities in the database will then be updated with the new path, and the collection name will be changed.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_collection_folder_name(name, collection_id, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str name: The new name of the folder. (required)
        :param str collection_id: The collection id. (required)
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: str.
                 If the method is called asynchronously, returns the request thread.
        :rtype: str or multiprocessing.pool.AsyncResult
        """
        kwargs['_return_http_data_only'] = True
        return self.update_collection_folder_name_with_http_info(name, collection_id, **kwargs)  # noqa: E501

    def update_collection_folder_name_with_http_info(self, name, collection_id, **kwargs):  # noqa: E501
        """Report that the folder name has changed on disk  # noqa: E501

        If the folder name has been changed by a user or an external program, it can be reported to Vidispine with this command. The affected file entities in the database will then be updated with the new path, and the collection name will be changed.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_collection_folder_name_with_http_info(name, collection_id, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str name: The new name of the folder. (required)
        :param str collection_id: The collection id. (required)
        :key _return_http_data_only: response data without head status code
                                       and headers
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(str, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['name', 'collection_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_collection_folder_name" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in local_var_params or
                local_var_params['name'] is None):
            raise ApiValueError("Missing the required parameter `name` when calling `update_collection_folder_name`")  # noqa: E501
        # verify the required parameter 'collection_id' is set
        if ('collection_id' not in local_var_params or
                local_var_params['collection_id'] is None):
            raise ApiValueError("Missing the required parameter `collection_id` when calling `update_collection_folder_name`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'collection_id' in local_var_params:
            path_params['collection-id'] = local_var_params['collection_id']  # noqa: E501

        query_params = []
        if 'name' in local_var_params:
            query_params.append(('name', local_var_params['name']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/collection/{collection-id}/folder-name', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='str',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_collection_name(self, name, collection_id, **kwargs):  # noqa: E501
        """Update collection name  # noqa: E501

        Sets the name of the collection with the identifier `collection-id`.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_collection_name(name, collection_id, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str name: New name of the collection. (required)
        :param str collection_id: The collection id. (required)
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None.
                 If the method is called asynchronously, returns the request thread.
        :rtype: None or multiprocessing.pool.AsyncResult
        """
        kwargs['_return_http_data_only'] = True
        return self.update_collection_name_with_http_info(name, collection_id, **kwargs)  # noqa: E501

    def update_collection_name_with_http_info(self, name, collection_id, **kwargs):  # noqa: E501
        """Update collection name  # noqa: E501

        Sets the name of the collection with the identifier `collection-id`.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_collection_name_with_http_info(name, collection_id, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str name: New name of the collection. (required)
        :param str collection_id: The collection id. (required)
        :key _return_http_data_only: response data without head status code
                                       and headers
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['name', 'collection_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_collection_name" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in local_var_params or
                local_var_params['name'] is None):
            raise ApiValueError("Missing the required parameter `name` when calling `update_collection_name`")  # noqa: E501
        # verify the required parameter 'collection_id' is set
        if ('collection_id' not in local_var_params or
                local_var_params['collection_id'] is None):
            raise ApiValueError("Missing the required parameter `collection_id` when calling `update_collection_name`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'collection_id' in local_var_params:
            path_params['collection-id'] = local_var_params['collection_id']  # noqa: E501

        query_params = []
        if 'name' in local_var_params:
            query_params.append(('name', local_var_params['name']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/collection/{collection-id}/rename', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)
