# coding: utf-8

"""
    Vidispine API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)  # noqa: E501

    The version of the OpenAPI document: 5.x
    Contact: info@vidispine.com
    Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from vidispine.models import *
from vidispine.api_client import ApiClient
from vidispine.exceptions import (
    ApiTypeError,
    ApiValueError
)


class EntitySiteRuleApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def create_entity_site_rule(self, type, entity_id, site_rule_type, **kwargs):  # noqa: E501
        """Create a site rule  # noqa: E501

        Creates a new site rule for an entity.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_entity_site_rule(type, entity_id, site_rule_type, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str type: The type of entity. (required)
        :param str entity_id: The entity id. (required)
        :param SiteRuleType site_rule_type: (required)
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: SiteRuleType.
                 If the method is called asynchronously, returns the request thread.
        :rtype: SiteRuleType or multiprocessing.pool.AsyncResult
        """
        kwargs['_return_http_data_only'] = True
        return self.create_entity_site_rule_with_http_info(type, entity_id, site_rule_type, **kwargs)  # noqa: E501

    def create_entity_site_rule_with_http_info(self, type, entity_id, site_rule_type, **kwargs):  # noqa: E501
        """Create a site rule  # noqa: E501

        Creates a new site rule for an entity.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_entity_site_rule_with_http_info(type, entity_id, site_rule_type, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str type: The type of entity. (required)
        :param str entity_id: The entity id. (required)
        :param SiteRuleType site_rule_type: (required)
        :key _return_http_data_only: response data without head status code
                                       and headers
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(SiteRuleType, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['type', 'entity_id', 'site_rule_type']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_entity_site_rule" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'type' is set
        if ('type' not in local_var_params or
                local_var_params['type'] is None):
            raise ApiValueError("Missing the required parameter `type` when calling `create_entity_site_rule`")  # noqa: E501
        # verify the required parameter 'entity_id' is set
        if ('entity_id' not in local_var_params or
                local_var_params['entity_id'] is None):
            raise ApiValueError("Missing the required parameter `entity_id` when calling `create_entity_site_rule`")  # noqa: E501
        # verify the required parameter 'site_rule_type' is set
        if ('site_rule_type' not in local_var_params or
                local_var_params['site_rule_type'] is None):
            raise ApiValueError("Missing the required parameter `site_rule_type` when calling `create_entity_site_rule`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'type' in local_var_params:
            path_params['type'] = local_var_params['type']  # noqa: E501
        if 'entity_id' in local_var_params:
            path_params['entity-id'] = local_var_params['entity_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'site_rule_type' in local_var_params:
            body_params = local_var_params['site_rule_type']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'application/xml'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'application/xml'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/{type}/{entity-id}/site-rule', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SiteRuleType',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_entity_site_rule(self, type, entity_id, id, **kwargs):  # noqa: E501
        """Delete a site rule  # noqa: E501

        Deletes a site rule.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_entity_site_rule(type, entity_id, id, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str type: The type of entity. (required)
        :param str entity_id: The entity id. (required)
        :param str id: The id. (required)
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None.
                 If the method is called asynchronously, returns the request thread.
        :rtype: None or multiprocessing.pool.AsyncResult
        """
        kwargs['_return_http_data_only'] = True
        return self.delete_entity_site_rule_with_http_info(type, entity_id, id, **kwargs)  # noqa: E501

    def delete_entity_site_rule_with_http_info(self, type, entity_id, id, **kwargs):  # noqa: E501
        """Delete a site rule  # noqa: E501

        Deletes a site rule.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_entity_site_rule_with_http_info(type, entity_id, id, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str type: The type of entity. (required)
        :param str entity_id: The entity id. (required)
        :param str id: The id. (required)
        :key _return_http_data_only: response data without head status code
                                       and headers
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['type', 'entity_id', 'id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_entity_site_rule" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'type' is set
        if ('type' not in local_var_params or
                local_var_params['type'] is None):
            raise ApiValueError("Missing the required parameter `type` when calling `delete_entity_site_rule`")  # noqa: E501
        # verify the required parameter 'entity_id' is set
        if ('entity_id' not in local_var_params or
                local_var_params['entity_id'] is None):
            raise ApiValueError("Missing the required parameter `entity_id` when calling `delete_entity_site_rule`")  # noqa: E501
        # verify the required parameter 'id' is set
        if ('id' not in local_var_params or
                local_var_params['id'] is None):
            raise ApiValueError("Missing the required parameter `id` when calling `delete_entity_site_rule`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'type' in local_var_params:
            path_params['type'] = local_var_params['type']  # noqa: E501
        if 'entity_id' in local_var_params:
            path_params['entity-id'] = local_var_params['entity_id']  # noqa: E501
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/{type}/{entity-id}/site-rule/{id}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_entity_site_rule(self, type, entity_id, id, **kwargs):  # noqa: E501
        """Retrieve a site rule  # noqa: E501

        Retrieves a specific site rule.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_entity_site_rule(type, entity_id, id, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str type: The type of entity. (required)
        :param str entity_id: The entity id. (required)
        :param str id: The id. (required)
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: SiteRuleType.
                 If the method is called asynchronously, returns the request thread.
        :rtype: SiteRuleType or multiprocessing.pool.AsyncResult
        """
        kwargs['_return_http_data_only'] = True
        return self.get_entity_site_rule_with_http_info(type, entity_id, id, **kwargs)  # noqa: E501

    def get_entity_site_rule_with_http_info(self, type, entity_id, id, **kwargs):  # noqa: E501
        """Retrieve a site rule  # noqa: E501

        Retrieves a specific site rule.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_entity_site_rule_with_http_info(type, entity_id, id, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str type: The type of entity. (required)
        :param str entity_id: The entity id. (required)
        :param str id: The id. (required)
        :key _return_http_data_only: response data without head status code
                                       and headers
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(SiteRuleType, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['type', 'entity_id', 'id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_entity_site_rule" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'type' is set
        if ('type' not in local_var_params or
                local_var_params['type'] is None):
            raise ApiValueError("Missing the required parameter `type` when calling `get_entity_site_rule`")  # noqa: E501
        # verify the required parameter 'entity_id' is set
        if ('entity_id' not in local_var_params or
                local_var_params['entity_id'] is None):
            raise ApiValueError("Missing the required parameter `entity_id` when calling `get_entity_site_rule`")  # noqa: E501
        # verify the required parameter 'id' is set
        if ('id' not in local_var_params or
                local_var_params['id'] is None):
            raise ApiValueError("Missing the required parameter `id` when calling `get_entity_site_rule`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'type' in local_var_params:
            path_params['type'] = local_var_params['type']  # noqa: E501
        if 'entity_id' in local_var_params:
            path_params['entity-id'] = local_var_params['entity_id']  # noqa: E501
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'application/xml'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/{type}/{entity-id}/site-rule/{id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SiteRuleType',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_entity_site_rules(self, type, entity_id, **kwargs):  # noqa: E501
        """List all site rules for an entity  # noqa: E501

        Retrieves all site rules for the given entity/entities.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_entity_site_rules(type, entity_id, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str type: The type of entity. (required)
        :param str entity_id: The entity id. (required)
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: SiteRuleListType.
                 If the method is called asynchronously, returns the request thread.
        :rtype: SiteRuleListType or multiprocessing.pool.AsyncResult
        """
        kwargs['_return_http_data_only'] = True
        return self.get_entity_site_rules_with_http_info(type, entity_id, **kwargs)  # noqa: E501

    def get_entity_site_rules_with_http_info(self, type, entity_id, **kwargs):  # noqa: E501
        """List all site rules for an entity  # noqa: E501

        Retrieves all site rules for the given entity/entities.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_entity_site_rules_with_http_info(type, entity_id, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str type: The type of entity. (required)
        :param str entity_id: The entity id. (required)
        :key _return_http_data_only: response data without head status code
                                       and headers
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(SiteRuleListType, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['type', 'entity_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_entity_site_rules" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'type' is set
        if ('type' not in local_var_params or
                local_var_params['type'] is None):
            raise ApiValueError("Missing the required parameter `type` when calling `get_entity_site_rules`")  # noqa: E501
        # verify the required parameter 'entity_id' is set
        if ('entity_id' not in local_var_params or
                local_var_params['entity_id'] is None):
            raise ApiValueError("Missing the required parameter `entity_id` when calling `get_entity_site_rules`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'type' in local_var_params:
            path_params['type'] = local_var_params['type']  # noqa: E501
        if 'entity_id' in local_var_params:
            path_params['entity-id'] = local_var_params['entity_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'application/xml'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/{type}/{entity-id}/site-rule', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SiteRuleListType',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_entity_site_rule(self, type, entity_id, id, site_rule_type, **kwargs):  # noqa: E501
        """Update a site rule  # noqa: E501

        Updates a site rule.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_entity_site_rule(type, entity_id, id, site_rule_type, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str type: The type of entity. (required)
        :param str entity_id: The entity id. (required)
        :param str id: The id. (required)
        :param SiteRuleType site_rule_type: (required)
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: SiteRuleType.
                 If the method is called asynchronously, returns the request thread.
        :rtype: SiteRuleType or multiprocessing.pool.AsyncResult
        """
        kwargs['_return_http_data_only'] = True
        return self.update_entity_site_rule_with_http_info(type, entity_id, id, site_rule_type, **kwargs)  # noqa: E501

    def update_entity_site_rule_with_http_info(self, type, entity_id, id, site_rule_type, **kwargs):  # noqa: E501
        """Update a site rule  # noqa: E501

        Updates a site rule.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_entity_site_rule_with_http_info(type, entity_id, id, site_rule_type, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str type: The type of entity. (required)
        :param str entity_id: The entity id. (required)
        :param str id: The id. (required)
        :param SiteRuleType site_rule_type: (required)
        :key _return_http_data_only: response data without head status code
                                       and headers
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(SiteRuleType, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['type', 'entity_id', 'id', 'site_rule_type']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_entity_site_rule" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'type' is set
        if ('type' not in local_var_params or
                local_var_params['type'] is None):
            raise ApiValueError("Missing the required parameter `type` when calling `update_entity_site_rule`")  # noqa: E501
        # verify the required parameter 'entity_id' is set
        if ('entity_id' not in local_var_params or
                local_var_params['entity_id'] is None):
            raise ApiValueError("Missing the required parameter `entity_id` when calling `update_entity_site_rule`")  # noqa: E501
        # verify the required parameter 'id' is set
        if ('id' not in local_var_params or
                local_var_params['id'] is None):
            raise ApiValueError("Missing the required parameter `id` when calling `update_entity_site_rule`")  # noqa: E501
        # verify the required parameter 'site_rule_type' is set
        if ('site_rule_type' not in local_var_params or
                local_var_params['site_rule_type'] is None):
            raise ApiValueError("Missing the required parameter `site_rule_type` when calling `update_entity_site_rule`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'type' in local_var_params:
            path_params['type'] = local_var_params['type']  # noqa: E501
        if 'entity_id' in local_var_params:
            path_params['entity-id'] = local_var_params['entity_id']  # noqa: E501
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'site_rule_type' in local_var_params:
            body_params = local_var_params['site_rule_type']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'application/xml'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'application/xml'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/{type}/{entity-id}/site-rule/{id}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SiteRuleType',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)
