# coding: utf-8

"""
    Vidispine API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)  # noqa: E501

    The version of the OpenAPI document: 5.x
    Contact: info@vidispine.com
    Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from vidispine.models import *
from vidispine.api_client import ApiClient
from vidispine.exceptions import (
    ApiTypeError,
    ApiValueError
)


class ExternalIdApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def create_entity_external_id(self, type, entity_id, external_id, **kwargs):  # noqa: E501
        """Create a new external id  # noqa: E501

        Creates a new external id for the specified entity.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_entity_external_id(type, entity_id, external_id, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str type: The type of entity. (required)
        :param str entity_id: The entity id. (required)
        :param str external_id: The external id. (required)
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None.
                 If the method is called asynchronously, returns the request thread.
        :rtype: None or multiprocessing.pool.AsyncResult
        """
        kwargs['_return_http_data_only'] = True
        return self.create_entity_external_id_with_http_info(type, entity_id, external_id, **kwargs)  # noqa: E501

    def create_entity_external_id_with_http_info(self, type, entity_id, external_id, **kwargs):  # noqa: E501
        """Create a new external id  # noqa: E501

        Creates a new external id for the specified entity.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_entity_external_id_with_http_info(type, entity_id, external_id, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str type: The type of entity. (required)
        :param str entity_id: The entity id. (required)
        :param str external_id: The external id. (required)
        :key _return_http_data_only: response data without head status code
                                       and headers
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['type', 'entity_id', 'external_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_entity_external_id" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'type' is set
        if ('type' not in local_var_params or
                local_var_params['type'] is None):
            raise ApiValueError("Missing the required parameter `type` when calling `create_entity_external_id`")  # noqa: E501
        # verify the required parameter 'entity_id' is set
        if ('entity_id' not in local_var_params or
                local_var_params['entity_id'] is None):
            raise ApiValueError("Missing the required parameter `entity_id` when calling `create_entity_external_id`")  # noqa: E501
        # verify the required parameter 'external_id' is set
        if ('external_id' not in local_var_params or
                local_var_params['external_id'] is None):
            raise ApiValueError("Missing the required parameter `external_id` when calling `create_entity_external_id`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'type' in local_var_params:
            path_params['type'] = local_var_params['type']  # noqa: E501
        if 'entity_id' in local_var_params:
            path_params['entity-id'] = local_var_params['entity_id']  # noqa: E501
        if 'external_id' in local_var_params:
            path_params['external-id'] = local_var_params['external_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/{type}/{entity-id}/external-id/{external-id}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_entity_external_id(self, type, entity_id, external_id, **kwargs):  # noqa: E501
        """Remove an external id  # noqa: E501

        Removes the external identifier from a specific entity.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_entity_external_id(type, entity_id, external_id, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str type: The type of entity. (required)
        :param str entity_id: The entity id. (required)
        :param str external_id: The external id. (required)
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None.
                 If the method is called asynchronously, returns the request thread.
        :rtype: None or multiprocessing.pool.AsyncResult
        """
        kwargs['_return_http_data_only'] = True
        return self.delete_entity_external_id_with_http_info(type, entity_id, external_id, **kwargs)  # noqa: E501

    def delete_entity_external_id_with_http_info(self, type, entity_id, external_id, **kwargs):  # noqa: E501
        """Remove an external id  # noqa: E501

        Removes the external identifier from a specific entity.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_entity_external_id_with_http_info(type, entity_id, external_id, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str type: The type of entity. (required)
        :param str entity_id: The entity id. (required)
        :param str external_id: The external id. (required)
        :key _return_http_data_only: response data without head status code
                                       and headers
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['type', 'entity_id', 'external_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_entity_external_id" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'type' is set
        if ('type' not in local_var_params or
                local_var_params['type'] is None):
            raise ApiValueError("Missing the required parameter `type` when calling `delete_entity_external_id`")  # noqa: E501
        # verify the required parameter 'entity_id' is set
        if ('entity_id' not in local_var_params or
                local_var_params['entity_id'] is None):
            raise ApiValueError("Missing the required parameter `entity_id` when calling `delete_entity_external_id`")  # noqa: E501
        # verify the required parameter 'external_id' is set
        if ('external_id' not in local_var_params or
                local_var_params['external_id'] is None):
            raise ApiValueError("Missing the required parameter `external_id` when calling `delete_entity_external_id`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'type' in local_var_params:
            path_params['type'] = local_var_params['type']  # noqa: E501
        if 'entity_id' in local_var_params:
            path_params['entity-id'] = local_var_params['entity_id']  # noqa: E501
        if 'external_id' in local_var_params:
            path_params['external-id'] = local_var_params['external_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/{type}/{entity-id}/external-id/{external-id}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_entity_external_ids(self, type, entity_id, **kwargs):  # noqa: E501
        """Clear all external ids for an entity  # noqa: E501

        Clears all external identifiers that are registered with an entity.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_entity_external_ids(type, entity_id, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str type: The type of entity. (required)
        :param str entity_id: The entity id. (required)
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None.
                 If the method is called asynchronously, returns the request thread.
        :rtype: None or multiprocessing.pool.AsyncResult
        """
        kwargs['_return_http_data_only'] = True
        return self.delete_entity_external_ids_with_http_info(type, entity_id, **kwargs)  # noqa: E501

    def delete_entity_external_ids_with_http_info(self, type, entity_id, **kwargs):  # noqa: E501
        """Clear all external ids for an entity  # noqa: E501

        Clears all external identifiers that are registered with an entity.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_entity_external_ids_with_http_info(type, entity_id, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str type: The type of entity. (required)
        :param str entity_id: The entity id. (required)
        :key _return_http_data_only: response data without head status code
                                       and headers
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['type', 'entity_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_entity_external_ids" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'type' is set
        if ('type' not in local_var_params or
                local_var_params['type'] is None):
            raise ApiValueError("Missing the required parameter `type` when calling `delete_entity_external_ids`")  # noqa: E501
        # verify the required parameter 'entity_id' is set
        if ('entity_id' not in local_var_params or
                local_var_params['entity_id'] is None):
            raise ApiValueError("Missing the required parameter `entity_id` when calling `delete_entity_external_ids`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'type' in local_var_params:
            path_params['type'] = local_var_params['type']  # noqa: E501
        if 'entity_id' in local_var_params:
            path_params['entity-id'] = local_var_params['entity_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/{type}/{entity-id}/external-id', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_entity_external_ids(self, type, entity_id, **kwargs):  # noqa: E501
        """Retrieve all external ids for an entity  # noqa: E501

        Retrieves all external ids that are assigned to a particular entity.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_entity_external_ids(type, entity_id, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str type: The type of entity. (required)
        :param str entity_id: The entity id. (required)
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: ExternalIdentifierListType.
                 If the method is called asynchronously, returns the request thread.
        :rtype: ExternalIdentifierListType or multiprocessing.pool.AsyncResult
        """
        kwargs['_return_http_data_only'] = True
        return self.get_entity_external_ids_with_http_info(type, entity_id, **kwargs)  # noqa: E501

    def get_entity_external_ids_with_http_info(self, type, entity_id, **kwargs):  # noqa: E501
        """Retrieve all external ids for an entity  # noqa: E501

        Retrieves all external ids that are assigned to a particular entity.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_entity_external_ids_with_http_info(type, entity_id, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str type: The type of entity. (required)
        :param str entity_id: The entity id. (required)
        :key _return_http_data_only: response data without head status code
                                       and headers
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(ExternalIdentifierListType, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['type', 'entity_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_entity_external_ids" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'type' is set
        if ('type' not in local_var_params or
                local_var_params['type'] is None):
            raise ApiValueError("Missing the required parameter `type` when calling `get_entity_external_ids`")  # noqa: E501
        # verify the required parameter 'entity_id' is set
        if ('entity_id' not in local_var_params or
                local_var_params['entity_id'] is None):
            raise ApiValueError("Missing the required parameter `entity_id` when calling `get_entity_external_ids`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'type' in local_var_params:
            path_params['type'] = local_var_params['type']  # noqa: E501
        if 'entity_id' in local_var_params:
            path_params['entity-id'] = local_var_params['entity_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'application/xml'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/{type}/{entity-id}/external-id', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ExternalIdentifierListType',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)
