# coding: utf-8

"""
    Vidispine API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)  # noqa: E501

    The version of the OpenAPI document: 5.x
    Contact: info@vidispine.com
    Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from vidispine.models import *
from vidispine.api_client import ApiClient
from vidispine.exceptions import (
    ApiTypeError,
    ApiValueError
)


class ExternalIdNamespaceApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def delete_external_id(self, external_id, **kwargs):  # noqa: E501
        """Remove an external id  # noqa: E501

        Removes the external identifier from all entities.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_external_id(external_id, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str external_id: The external id. (required)
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None.
                 If the method is called asynchronously, returns the request thread.
        :rtype: None or multiprocessing.pool.AsyncResult
        """
        kwargs['_return_http_data_only'] = True
        return self.delete_external_id_with_http_info(external_id, **kwargs)  # noqa: E501

    def delete_external_id_with_http_info(self, external_id, **kwargs):  # noqa: E501
        """Remove an external id  # noqa: E501

        Removes the external identifier from all entities.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_external_id_with_http_info(external_id, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str external_id: The external id. (required)
        :key _return_http_data_only: response data without head status code
                                       and headers
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['external_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_external_id" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'external_id' is set
        if ('external_id' not in local_var_params or
                local_var_params['external_id'] is None):
            raise ApiValueError("Missing the required parameter `external_id` when calling `delete_external_id`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'external_id' in local_var_params:
            path_params['external-id'] = local_var_params['external_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/external-id/id/{external-id}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_external_id_namespace(self, namespace_id, **kwargs):  # noqa: E501
        """Delete a namespace and all external ids in that namespace  # noqa: E501

        Deletes the specified namespace together with all *external ids that exist in that namespace*.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_external_id_namespace(namespace_id, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str namespace_id: The namespace id. (required)
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None.
                 If the method is called asynchronously, returns the request thread.
        :rtype: None or multiprocessing.pool.AsyncResult
        """
        kwargs['_return_http_data_only'] = True
        return self.delete_external_id_namespace_with_http_info(namespace_id, **kwargs)  # noqa: E501

    def delete_external_id_namespace_with_http_info(self, namespace_id, **kwargs):  # noqa: E501
        """Delete a namespace and all external ids in that namespace  # noqa: E501

        Deletes the specified namespace together with all *external ids that exist in that namespace*.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_external_id_namespace_with_http_info(namespace_id, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str namespace_id: The namespace id. (required)
        :key _return_http_data_only: response data without head status code
                                       and headers
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['namespace_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_external_id_namespace" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'namespace_id' is set
        if ('namespace_id' not in local_var_params or
                local_var_params['namespace_id'] is None):
            raise ApiValueError("Missing the required parameter `namespace_id` when calling `delete_external_id_namespace`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'namespace_id' in local_var_params:
            path_params['namespace-id'] = local_var_params['namespace_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/external-id/{namespace-id}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_external_id_namespace(self, namespace_id, **kwargs):  # noqa: E501
        """Retrieve a specific namespace  # noqa: E501

        Retrieves the namespace with the specified name.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_external_id_namespace(namespace_id, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str namespace_id: The namespace id. (required)
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: ExternalIdentifierNamespaceType.
                 If the method is called asynchronously, returns the request thread.
        :rtype: ExternalIdentifierNamespaceType or multiprocessing.pool.AsyncResult
        """
        kwargs['_return_http_data_only'] = True
        return self.get_external_id_namespace_with_http_info(namespace_id, **kwargs)  # noqa: E501

    def get_external_id_namespace_with_http_info(self, namespace_id, **kwargs):  # noqa: E501
        """Retrieve a specific namespace  # noqa: E501

        Retrieves the namespace with the specified name.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_external_id_namespace_with_http_info(namespace_id, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str namespace_id: The namespace id. (required)
        :key _return_http_data_only: response data without head status code
                                       and headers
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(ExternalIdentifierNamespaceType, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['namespace_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_external_id_namespace" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'namespace_id' is set
        if ('namespace_id' not in local_var_params or
                local_var_params['namespace_id'] is None):
            raise ApiValueError("Missing the required parameter `namespace_id` when calling `get_external_id_namespace`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'namespace_id' in local_var_params:
            path_params['namespace-id'] = local_var_params['namespace_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'application/xml'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/external-id/{namespace-id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ExternalIdentifierNamespaceType',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_external_id_namespaces(self, **kwargs):  # noqa: E501
        """Retrieve all known namespaces  # noqa: E501

        Retrieves all known external id namespaces.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_external_id_namespaces(async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: ExternalIdentifierNamespaceListType.
                 If the method is called asynchronously, returns the request thread.
        :rtype: ExternalIdentifierNamespaceListType or multiprocessing.pool.AsyncResult
        """
        kwargs['_return_http_data_only'] = True
        return self.get_external_id_namespaces_with_http_info(**kwargs)  # noqa: E501

    def get_external_id_namespaces_with_http_info(self, **kwargs):  # noqa: E501
        """Retrieve all known namespaces  # noqa: E501

        Retrieves all known external id namespaces.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_external_id_namespaces_with_http_info(async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :key _return_http_data_only: response data without head status code
                                       and headers
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(ExternalIdentifierNamespaceListType, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_external_id_namespaces" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'application/xml'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/external-id', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ExternalIdentifierNamespaceListType',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_or_create_external_id_namespace(self, namespace_id, external_identifier_namespace_type, **kwargs):  # noqa: E501
        """Update or create a namespace  # noqa: E501

        Creates or modifies a namespace with the specified name.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_or_create_external_id_namespace(namespace_id, external_identifier_namespace_type, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str namespace_id: The namespace id. (required)
        :param ExternalIdentifierNamespaceType external_identifier_namespace_type: (required)
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None.
                 If the method is called asynchronously, returns the request thread.
        :rtype: None or multiprocessing.pool.AsyncResult
        """
        kwargs['_return_http_data_only'] = True
        return self.update_or_create_external_id_namespace_with_http_info(namespace_id, external_identifier_namespace_type, **kwargs)  # noqa: E501

    def update_or_create_external_id_namespace_with_http_info(self, namespace_id, external_identifier_namespace_type, **kwargs):  # noqa: E501
        """Update or create a namespace  # noqa: E501

        Creates or modifies a namespace with the specified name.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_or_create_external_id_namespace_with_http_info(namespace_id, external_identifier_namespace_type, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str namespace_id: The namespace id. (required)
        :param ExternalIdentifierNamespaceType external_identifier_namespace_type: (required)
        :key _return_http_data_only: response data without head status code
                                       and headers
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['namespace_id', 'external_identifier_namespace_type']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_or_create_external_id_namespace" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'namespace_id' is set
        if ('namespace_id' not in local_var_params or
                local_var_params['namespace_id'] is None):
            raise ApiValueError("Missing the required parameter `namespace_id` when calling `update_or_create_external_id_namespace`")  # noqa: E501
        # verify the required parameter 'external_identifier_namespace_type' is set
        if ('external_identifier_namespace_type' not in local_var_params or
                local_var_params['external_identifier_namespace_type'] is None):
            raise ApiValueError("Missing the required parameter `external_identifier_namespace_type` when calling `update_or_create_external_id_namespace`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'namespace_id' in local_var_params:
            path_params['namespace-id'] = local_var_params['namespace_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'external_identifier_namespace_type' in local_var_params:
            body_params = local_var_params['external_identifier_namespace_type']
        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'application/xml'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/external-id/{namespace-id}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)
