# coding: utf-8

"""
    Vidispine API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)  # noqa: E501

    The version of the OpenAPI document: 5.x
    Contact: info@vidispine.com
    Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from vidispine.models import *
from vidispine.api_client import ApiClient
from vidispine.exceptions import (
    ApiTypeError,
    ApiValueError
)


class FileApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def create_file(self, body, **kwargs):  # noqa: E501
        """Upload a file to a storage  # noqa: E501

        Creates a new file on a specific storage, with the given file data.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_file(body, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param file body: The raw essence data. (required)
        :key str state: The state of the file.
        :key str uri: The absolute file URI (should be relative to the URI of a storage method).
        :key int transfer_priority: An integer between 1 and 1000 that indicates what priority the transfer should be given in relation to other transfers.  A transfer with a high priority value is considered more important than a transfer with a low priority value.
        :key str transfer_id: An id to assign the transfer to be able to refer to it.
        :key str path: The path of the file on the storage.
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: FileType.
                 If the method is called asynchronously, returns the request thread.
        :rtype: FileType or multiprocessing.pool.AsyncResult
        """
        kwargs['_return_http_data_only'] = True
        return self.create_file_with_http_info(body, **kwargs)  # noqa: E501

    def create_file_with_http_info(self, body, **kwargs):  # noqa: E501
        """Upload a file to a storage  # noqa: E501

        Creates a new file on a specific storage, with the given file data.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_file_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param file body: The raw essence data. (required)
        :key str state: The state of the file.
        :key str uri: The absolute file URI (should be relative to the URI of a storage method).
        :key int transfer_priority: An integer between 1 and 1000 that indicates what priority the transfer should be given in relation to other transfers.  A transfer with a high priority value is considered more important than a transfer with a low priority value.
        :key str transfer_id: An id to assign the transfer to be able to refer to it.
        :key str path: The path of the file on the storage.
        :key _return_http_data_only: response data without head status code
                                       and headers
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(FileType, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['body', 'state', 'uri', 'transfer_priority', 'transfer_id', 'path']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_file" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in local_var_params or
                local_var_params['body'] is None):
            raise ApiValueError("Missing the required parameter `body` when calling `create_file`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'state' in local_var_params:
            query_params.append(('state', local_var_params['state']))  # noqa: E501
        if 'uri' in local_var_params:
            query_params.append(('uri', local_var_params['uri']))  # noqa: E501
        if 'transfer_priority' in local_var_params:
            query_params.append(('transferPriority', local_var_params['transfer_priority']))  # noqa: E501
        if 'transfer_id' in local_var_params:
            query_params.append(('transferId', local_var_params['transfer_id']))  # noqa: E501
        if 'path' in local_var_params:
            query_params.append(('path', local_var_params['path']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in local_var_params:
            body_params = local_var_params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'text/plain', 'application/xml'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/octet-stream'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/storage/file/data', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='FileType',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_file_delete_job(self, file_id, **kwargs):  # noqa: E501
        """Delete a file  # noqa: E501

        Starts a delete job for the specified file.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_file_delete_job(file_id, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str file_id: The file id. (required)
        :key list[str] jobmetadata: Additional information for the job task.
        :key str notification_data: Any additional data to include for notifications on this job.
        :key str priority: The priority to assign to the job.
        :key str notification: The placeholder job notification to use for this job.
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: JobType.
                 If the method is called asynchronously, returns the request thread.
        :rtype: JobType or multiprocessing.pool.AsyncResult
        """
        kwargs['_return_http_data_only'] = True
        return self.create_file_delete_job_with_http_info(file_id, **kwargs)  # noqa: E501

    def create_file_delete_job_with_http_info(self, file_id, **kwargs):  # noqa: E501
        """Delete a file  # noqa: E501

        Starts a delete job for the specified file.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_file_delete_job_with_http_info(file_id, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str file_id: The file id. (required)
        :key list[str] jobmetadata: Additional information for the job task.
        :key str notification_data: Any additional data to include for notifications on this job.
        :key str priority: The priority to assign to the job.
        :key str notification: The placeholder job notification to use for this job.
        :key _return_http_data_only: response data without head status code
                                       and headers
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(JobType, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['file_id', 'jobmetadata', 'notification_data', 'priority', 'notification']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_file_delete_job" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'file_id' is set
        if ('file_id' not in local_var_params or
                local_var_params['file_id'] is None):
            raise ApiValueError("Missing the required parameter `file_id` when calling `create_file_delete_job`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'file_id' in local_var_params:
            path_params['file-id'] = local_var_params['file_id']  # noqa: E501

        query_params = []
        if 'jobmetadata' in local_var_params:
            query_params.append(('jobmetadata', local_var_params['jobmetadata']))  # noqa: E501
            collection_formats['jobmetadata'] = 'multi'  # noqa: E501
        if 'notification_data' in local_var_params:
            query_params.append(('notificationData', local_var_params['notification_data']))  # noqa: E501
        if 'priority' in local_var_params:
            query_params.append(('priority', local_var_params['priority']))  # noqa: E501
        if 'notification' in local_var_params:
            query_params.append(('notification', local_var_params['notification']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'application/xml'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/file/{file-id}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='JobType',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_file_entity(self, file_type, **kwargs):  # noqa: E501
        """Register a file  # noqa: E501

        Creates a file entity in the database. Does not create any physical files. Either a storage id and path or an absolute URI may be given.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_file_entity(file_type, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param FileType file_type: <em>FileDocument</em> with the path or URI and file state. (required)
        :key bool create_only: - `true` (default) - Fail if a file with that path already exists.  - `false` - Update the existing file if one exists, else create a new file entity.
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: FileType.
                 If the method is called asynchronously, returns the request thread.
        :rtype: FileType or multiprocessing.pool.AsyncResult
        """
        kwargs['_return_http_data_only'] = True
        return self.create_file_entity_with_http_info(file_type, **kwargs)  # noqa: E501

    def create_file_entity_with_http_info(self, file_type, **kwargs):  # noqa: E501
        """Register a file  # noqa: E501

        Creates a file entity in the database. Does not create any physical files. Either a storage id and path or an absolute URI may be given.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_file_entity_with_http_info(file_type, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param FileType file_type: <em>FileDocument</em> with the path or URI and file state. (required)
        :key bool create_only: - `true` (default) - Fail if a file with that path already exists.  - `false` - Update the existing file if one exists, else create a new file entity.
        :key _return_http_data_only: response data without head status code
                                       and headers
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(FileType, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['file_type', 'create_only']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_file_entity" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'file_type' is set
        if ('file_type' not in local_var_params or
                local_var_params['file_type'] is None):
            raise ApiValueError("Missing the required parameter `file_type` when calling `create_file_entity`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'create_only' in local_var_params:
            query_params.append(('createOnly', local_var_params['create_only']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'file_type' in local_var_params:
            body_params = local_var_params['file_type']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'text/plain', 'application/xml'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'application/xml'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/storage/file', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='FileType',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_file_entity_on_storage(self, storage_id, file_type, **kwargs):  # noqa: E501
        """Register a file  # noqa: E501

        Creates a file entity in the database. Does not create any physical files. Either a storage id and path or an absolute URI may be given.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_file_entity_on_storage(storage_id, file_type, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str storage_id: The storage id. (required)
        :param FileType file_type: <em>FileDocument</em> with the path or URI and file state. (required)
        :key bool create_only: - `true` (default) - Fail if a file with that path already exists.  - `false` - Update the existing file if one exists, else create a new file entity.
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: FileType.
                 If the method is called asynchronously, returns the request thread.
        :rtype: FileType or multiprocessing.pool.AsyncResult
        """
        kwargs['_return_http_data_only'] = True
        return self.create_file_entity_on_storage_with_http_info(storage_id, file_type, **kwargs)  # noqa: E501

    def create_file_entity_on_storage_with_http_info(self, storage_id, file_type, **kwargs):  # noqa: E501
        """Register a file  # noqa: E501

        Creates a file entity in the database. Does not create any physical files. Either a storage id and path or an absolute URI may be given.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_file_entity_on_storage_with_http_info(storage_id, file_type, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str storage_id: The storage id. (required)
        :param FileType file_type: <em>FileDocument</em> with the path or URI and file state. (required)
        :key bool create_only: - `true` (default) - Fail if a file with that path already exists.  - `false` - Update the existing file if one exists, else create a new file entity.
        :key _return_http_data_only: response data without head status code
                                       and headers
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(FileType, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['storage_id', 'file_type', 'create_only']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_file_entity_on_storage" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'storage_id' is set
        if ('storage_id' not in local_var_params or
                local_var_params['storage_id'] is None):
            raise ApiValueError("Missing the required parameter `storage_id` when calling `create_file_entity_on_storage`")  # noqa: E501
        # verify the required parameter 'file_type' is set
        if ('file_type' not in local_var_params or
                local_var_params['file_type'] is None):
            raise ApiValueError("Missing the required parameter `file_type` when calling `create_file_entity_on_storage`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'storage_id' in local_var_params:
            path_params['storage-id'] = local_var_params['storage_id']  # noqa: E501

        query_params = []
        if 'create_only' in local_var_params:
            query_params.append(('createOnly', local_var_params['create_only']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'file_type' in local_var_params:
            body_params = local_var_params['file_type']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'text/plain', 'application/xml'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'application/xml'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/storage/{storage-id}/file', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='FileType',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_file_in_storage(self, storage_id, body, **kwargs):  # noqa: E501
        """Upload a file to a storage  # noqa: E501

        Creates a new file on a specific storage, with the given file data.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_file_in_storage(storage_id, body, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str storage_id: The storage id. (required)
        :param file body: The raw essence data. (required)
        :key str state: The state of the file.
        :key str uri: The absolute file URI (should be relative to the URI of a storage method).
        :key int transfer_priority: An integer between 1 and 1000 that indicates what priority the transfer should be given in relation to other transfers.  A transfer with a high priority value is considered more important than a transfer with a low priority value.
        :key str transfer_id: An id to assign the transfer to be able to refer to it.
        :key str path: The path of the file on the storage.
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: FileType.
                 If the method is called asynchronously, returns the request thread.
        :rtype: FileType or multiprocessing.pool.AsyncResult
        """
        kwargs['_return_http_data_only'] = True
        return self.create_file_in_storage_with_http_info(storage_id, body, **kwargs)  # noqa: E501

    def create_file_in_storage_with_http_info(self, storage_id, body, **kwargs):  # noqa: E501
        """Upload a file to a storage  # noqa: E501

        Creates a new file on a specific storage, with the given file data.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_file_in_storage_with_http_info(storage_id, body, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str storage_id: The storage id. (required)
        :param file body: The raw essence data. (required)
        :key str state: The state of the file.
        :key str uri: The absolute file URI (should be relative to the URI of a storage method).
        :key int transfer_priority: An integer between 1 and 1000 that indicates what priority the transfer should be given in relation to other transfers.  A transfer with a high priority value is considered more important than a transfer with a low priority value.
        :key str transfer_id: An id to assign the transfer to be able to refer to it.
        :key str path: The path of the file on the storage.
        :key _return_http_data_only: response data without head status code
                                       and headers
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(FileType, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['storage_id', 'body', 'state', 'uri', 'transfer_priority', 'transfer_id', 'path']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_file_in_storage" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'storage_id' is set
        if ('storage_id' not in local_var_params or
                local_var_params['storage_id'] is None):
            raise ApiValueError("Missing the required parameter `storage_id` when calling `create_file_in_storage`")  # noqa: E501
        # verify the required parameter 'body' is set
        if ('body' not in local_var_params or
                local_var_params['body'] is None):
            raise ApiValueError("Missing the required parameter `body` when calling `create_file_in_storage`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'storage_id' in local_var_params:
            path_params['storage-id'] = local_var_params['storage_id']  # noqa: E501

        query_params = []
        if 'state' in local_var_params:
            query_params.append(('state', local_var_params['state']))  # noqa: E501
        if 'uri' in local_var_params:
            query_params.append(('uri', local_var_params['uri']))  # noqa: E501
        if 'transfer_priority' in local_var_params:
            query_params.append(('transferPriority', local_var_params['transfer_priority']))  # noqa: E501
        if 'transfer_id' in local_var_params:
            query_params.append(('transferId', local_var_params['transfer_id']))  # noqa: E501
        if 'path' in local_var_params:
            query_params.append(('path', local_var_params['path']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in local_var_params:
            body_params = local_var_params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'text/plain', 'application/xml'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/octet-stream'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/storage/{storage-id}/file/data', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='FileType',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_file_move_or_copy_job(self, file_id, target_storage_id, **kwargs):  # noqa: E501
        """Move/copy a file to another storage  # noqa: E501

        Starts a move or copy job for the specified file.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_file_move_or_copy_job(file_id, target_storage_id, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str file_id: The file id. (required)
        :param str target_storage_id: The target storage id. (required)
        :key list[str] jobmetadata: Additional information for the job task.
        :key str notification_data: Any additional data to include for notifications on this job.
        :key bool move: - `true` - Delete the original file when the copy has finished.  - `false` - Just copy the file, and leave the original.
        :key bool use_original_filename: If set to `true`, the file will keep its original filename if available.
        :key str notification: The placeholder job notification to use for this job.
        :key int time_requirement: Number of seconds the target file is required to exist before being moved due to storage rules etc.
        :key int limit_rate: Throttle the rate at which the transfer takes place (bytes/second).
        :key str filename: The desired target filename.
        :key str priority: The priority to assign to the job.
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: JobType.
                 If the method is called asynchronously, returns the request thread.
        :rtype: JobType or multiprocessing.pool.AsyncResult
        """
        kwargs['_return_http_data_only'] = True
        return self.create_file_move_or_copy_job_with_http_info(file_id, target_storage_id, **kwargs)  # noqa: E501

    def create_file_move_or_copy_job_with_http_info(self, file_id, target_storage_id, **kwargs):  # noqa: E501
        """Move/copy a file to another storage  # noqa: E501

        Starts a move or copy job for the specified file.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_file_move_or_copy_job_with_http_info(file_id, target_storage_id, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str file_id: The file id. (required)
        :param str target_storage_id: The target storage id. (required)
        :key list[str] jobmetadata: Additional information for the job task.
        :key str notification_data: Any additional data to include for notifications on this job.
        :key bool move: - `true` - Delete the original file when the copy has finished.  - `false` - Just copy the file, and leave the original.
        :key bool use_original_filename: If set to `true`, the file will keep its original filename if available.
        :key str notification: The placeholder job notification to use for this job.
        :key int time_requirement: Number of seconds the target file is required to exist before being moved due to storage rules etc.
        :key int limit_rate: Throttle the rate at which the transfer takes place (bytes/second).
        :key str filename: The desired target filename.
        :key str priority: The priority to assign to the job.
        :key _return_http_data_only: response data without head status code
                                       and headers
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(JobType, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['file_id', 'target_storage_id', 'jobmetadata', 'notification_data', 'move', 'use_original_filename', 'notification', 'time_requirement', 'limit_rate', 'filename', 'priority']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_file_move_or_copy_job" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'file_id' is set
        if ('file_id' not in local_var_params or
                local_var_params['file_id'] is None):
            raise ApiValueError("Missing the required parameter `file_id` when calling `create_file_move_or_copy_job`")  # noqa: E501
        # verify the required parameter 'target_storage_id' is set
        if ('target_storage_id' not in local_var_params or
                local_var_params['target_storage_id'] is None):
            raise ApiValueError("Missing the required parameter `target_storage_id` when calling `create_file_move_or_copy_job`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'file_id' in local_var_params:
            path_params['file-id'] = local_var_params['file_id']  # noqa: E501
        if 'target_storage_id' in local_var_params:
            path_params['target-storage-id'] = local_var_params['target_storage_id']  # noqa: E501

        query_params = []
        if 'jobmetadata' in local_var_params:
            query_params.append(('jobmetadata', local_var_params['jobmetadata']))  # noqa: E501
            collection_formats['jobmetadata'] = 'multi'  # noqa: E501
        if 'notification_data' in local_var_params:
            query_params.append(('notificationData', local_var_params['notification_data']))  # noqa: E501
        if 'move' in local_var_params:
            query_params.append(('move', local_var_params['move']))  # noqa: E501
        if 'use_original_filename' in local_var_params:
            query_params.append(('useOriginalFilename', local_var_params['use_original_filename']))  # noqa: E501
        if 'notification' in local_var_params:
            query_params.append(('notification', local_var_params['notification']))  # noqa: E501
        if 'time_requirement' in local_var_params:
            query_params.append(('timeRequirement', local_var_params['time_requirement']))  # noqa: E501
        if 'limit_rate' in local_var_params:
            query_params.append(('limitRate', local_var_params['limit_rate']))  # noqa: E501
        if 'filename' in local_var_params:
            query_params.append(('filename', local_var_params['filename']))  # noqa: E501
        if 'priority' in local_var_params:
            query_params.append(('priority', local_var_params['priority']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'application/xml'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/file/{file-id}/storage/{target-storage-id}', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='JobType',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_file_temp_credentials(self, file_id, **kwargs):  # noqa: E501
        """Generate temporary credentials  # noqa: E501

        Generates temporary access credentials that give either READ or WRITE access directly to the file. By default, if the file is on S3 or Azure, this will try to create a read-only pre-signed URL for the file; if this fail or if the file is on another type of storage, it will try to create a proxy URL (with direct access to the file).  When using the s3 scheme there are certain prerequisites that need to be met regarding policies and trust relationships with the account in use.  The permission policy for the role will only require `s3:GetObject` and `s3:PutObject` permissions to use the basic features. If you intend to use this for multipart uploads you might also want to add the permissions for `s3:ListMultipartUploadParts` and `s3:AbortMultipartUpload`. Finally this role will also need a trust relationship with an account with access to the storage(s) as an intersection is made to decide permissions in the end.  Vidispine will then create a custom policy to limit the credentials to either GET or PUT as requested.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_file_temp_credentials(file_id, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str file_id: The file id. (required)
        :key bool write: Sets permission to either READ or WRITE.   - `true` - Will give credentials with access to write.  This would also enable the optional permissions for `s3:ListMultipartUploadParts` and `s3:AbortMultipartUpload` if used together with the `s3` scheme.  - `false` (default) - Will give credentials with access to read.
        :key str scheme: Determines which type of URL / URI to be returned.   - `s3` Utilize AWS's AssumeRole to generate a temporary URI giving access to only the specific file.  Can be used either by setting the `stsAssumeRole` property to specify which role to assume when generating the credentials OR by leaving this unset which will make Vidispine try to use a role from an EC2 instance profile.  These will also look at the configuration property for `stsRegion` and use that region when making the call to the STS API.  - `https` (default) - Generates a temporary pre-signed HTTPS URL for either S3 or Azure, or a proxy URL (based on the configuration property `apiNoauthUri`) if on another type of storage.  - `http` - Same as `https` but will also allow HTTP URL's to be returned.
        :key int duration: Optional, sets the duration of the temporary credentials in minutes.  Default is set to 15 minutes and the maximum is 720.  Changed in version 4. 17. 7: The minimum duration for pre-signed URLs is 1 minute and when using the S3 scheme the minimum is 15 minutes.
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: URIListType.
                 If the method is called asynchronously, returns the request thread.
        :rtype: URIListType or multiprocessing.pool.AsyncResult
        """
        kwargs['_return_http_data_only'] = True
        return self.create_file_temp_credentials_with_http_info(file_id, **kwargs)  # noqa: E501

    def create_file_temp_credentials_with_http_info(self, file_id, **kwargs):  # noqa: E501
        """Generate temporary credentials  # noqa: E501

        Generates temporary access credentials that give either READ or WRITE access directly to the file. By default, if the file is on S3 or Azure, this will try to create a read-only pre-signed URL for the file; if this fail or if the file is on another type of storage, it will try to create a proxy URL (with direct access to the file).  When using the s3 scheme there are certain prerequisites that need to be met regarding policies and trust relationships with the account in use.  The permission policy for the role will only require `s3:GetObject` and `s3:PutObject` permissions to use the basic features. If you intend to use this for multipart uploads you might also want to add the permissions for `s3:ListMultipartUploadParts` and `s3:AbortMultipartUpload`. Finally this role will also need a trust relationship with an account with access to the storage(s) as an intersection is made to decide permissions in the end.  Vidispine will then create a custom policy to limit the credentials to either GET or PUT as requested.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_file_temp_credentials_with_http_info(file_id, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str file_id: The file id. (required)
        :key bool write: Sets permission to either READ or WRITE.   - `true` - Will give credentials with access to write.  This would also enable the optional permissions for `s3:ListMultipartUploadParts` and `s3:AbortMultipartUpload` if used together with the `s3` scheme.  - `false` (default) - Will give credentials with access to read.
        :key str scheme: Determines which type of URL / URI to be returned.   - `s3` Utilize AWS's AssumeRole to generate a temporary URI giving access to only the specific file.  Can be used either by setting the `stsAssumeRole` property to specify which role to assume when generating the credentials OR by leaving this unset which will make Vidispine try to use a role from an EC2 instance profile.  These will also look at the configuration property for `stsRegion` and use that region when making the call to the STS API.  - `https` (default) - Generates a temporary pre-signed HTTPS URL for either S3 or Azure, or a proxy URL (based on the configuration property `apiNoauthUri`) if on another type of storage.  - `http` - Same as `https` but will also allow HTTP URL's to be returned.
        :key int duration: Optional, sets the duration of the temporary credentials in minutes.  Default is set to 15 minutes and the maximum is 720.  Changed in version 4. 17. 7: The minimum duration for pre-signed URLs is 1 minute and when using the S3 scheme the minimum is 15 minutes.
        :key _return_http_data_only: response data without head status code
                                       and headers
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(URIListType, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['file_id', 'write', 'scheme', 'duration']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_file_temp_credentials" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'file_id' is set
        if ('file_id' not in local_var_params or
                local_var_params['file_id'] is None):
            raise ApiValueError("Missing the required parameter `file_id` when calling `create_file_temp_credentials`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'file_id' in local_var_params:
            path_params['file-id'] = local_var_params['file_id']  # noqa: E501

        query_params = []
        if 'write' in local_var_params:
            query_params.append(('write', local_var_params['write']))  # noqa: E501
        if 'scheme' in local_var_params:
            query_params.append(('scheme', local_var_params['scheme']))  # noqa: E501
        if 'duration' in local_var_params:
            query_params.append(('duration', local_var_params['duration']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'application/xml'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/file/{file-id}/uri', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='URIListType',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_file_entity(self, file_id, **kwargs):  # noqa: E501
        """Unregister a file  # noqa: E501

        Deletes a file entity from the database. Does not touch the physical file.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_file_entity(file_id, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str file_id: The file id. (required)
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None.
                 If the method is called asynchronously, returns the request thread.
        :rtype: None or multiprocessing.pool.AsyncResult
        """
        kwargs['_return_http_data_only'] = True
        return self.delete_file_entity_with_http_info(file_id, **kwargs)  # noqa: E501

    def delete_file_entity_with_http_info(self, file_id, **kwargs):  # noqa: E501
        """Unregister a file  # noqa: E501

        Deletes a file entity from the database. Does not touch the physical file.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_file_entity_with_http_info(file_id, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str file_id: The file id. (required)
        :key _return_http_data_only: response data without head status code
                                       and headers
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['file_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_file_entity" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'file_id' is set
        if ('file_id' not in local_var_params or
                local_var_params['file_id'] is None):
            raise ApiValueError("Missing the required parameter `file_id` when calling `delete_file_entity`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'file_id' in local_var_params:
            path_params['file-id'] = local_var_params['file_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/file/{file-id}/entity', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_file_metadata(self, file_id, **kwargs):  # noqa: E501
        """Delete all key-value pairs  # noqa: E501

        Clears all key-value pairs for the specified entity.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_file_metadata(file_id, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str file_id: The file id. (required)
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None.
                 If the method is called asynchronously, returns the request thread.
        :rtype: None or multiprocessing.pool.AsyncResult
        """
        kwargs['_return_http_data_only'] = True
        return self.delete_file_metadata_with_http_info(file_id, **kwargs)  # noqa: E501

    def delete_file_metadata_with_http_info(self, file_id, **kwargs):  # noqa: E501
        """Delete all key-value pairs  # noqa: E501

        Clears all key-value pairs for the specified entity.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_file_metadata_with_http_info(file_id, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str file_id: The file id. (required)
        :key _return_http_data_only: response data without head status code
                                       and headers
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['file_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_file_metadata" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'file_id' is set
        if ('file_id' not in local_var_params or
                local_var_params['file_id'] is None):
            raise ApiValueError("Missing the required parameter `file_id` when calling `delete_file_metadata`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'file_id' in local_var_params:
            path_params['file-id'] = local_var_params['file_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/file/{file-id}/metadata', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_file_metadata_key(self, file_id, keypath, **kwargs):  # noqa: E501
        """Delete key-value pairs  # noqa: E501

        Deletes the key-value pair with the specified key. If a key path is given, it may include wildcards for deleting multiple keys.  Key paths can also be specified as well as specific keys.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_file_metadata_key(file_id, keypath, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str file_id: The file id. (required)
        :param str keypath: The keypath. (required)
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None.
                 If the method is called asynchronously, returns the request thread.
        :rtype: None or multiprocessing.pool.AsyncResult
        """
        kwargs['_return_http_data_only'] = True
        return self.delete_file_metadata_key_with_http_info(file_id, keypath, **kwargs)  # noqa: E501

    def delete_file_metadata_key_with_http_info(self, file_id, keypath, **kwargs):  # noqa: E501
        """Delete key-value pairs  # noqa: E501

        Deletes the key-value pair with the specified key. If a key path is given, it may include wildcards for deleting multiple keys.  Key paths can also be specified as well as specific keys.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_file_metadata_key_with_http_info(file_id, keypath, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str file_id: The file id. (required)
        :param str keypath: The keypath. (required)
        :key _return_http_data_only: response data without head status code
                                       and headers
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['file_id', 'keypath']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_file_metadata_key" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'file_id' is set
        if ('file_id' not in local_var_params or
                local_var_params['file_id'] is None):
            raise ApiValueError("Missing the required parameter `file_id` when calling `delete_file_metadata_key`")  # noqa: E501
        # verify the required parameter 'keypath' is set
        if ('keypath' not in local_var_params or
                local_var_params['keypath'] is None):
            raise ApiValueError("Missing the required parameter `keypath` when calling `delete_file_metadata_key`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'file_id' in local_var_params:
            path_params['file-id'] = local_var_params['file_id']  # noqa: E501
        if 'keypath' in local_var_params:
            path_params['keypath'] = local_var_params['keypath']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/file/{file-id}/metadata/{keypath}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_file(self, file_id, **kwargs):  # noqa: E501
        """Retrieve a file  # noqa: E501

        Retrieves the information, such as file size, status and checksum, of a specific file.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_file(file_id, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str file_id: The file id. (required)
        :key str storage_type: Only return URIs for files from storages of this type.
        :key str method_type: Return URIs from storage methods with a particular type.  By default, return URLs with empty `methodType`.
        :key list[str] method_metadata: metadata used with storage method.
        :key bool include_item: - `true` - Return associated items, shapes, and components.  - `false` (default) - Do not return any information about associated items, shapes, and components.
        :key str scheme: URI scheme to return.
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: FileType.
                 If the method is called asynchronously, returns the request thread.
        :rtype: FileType or multiprocessing.pool.AsyncResult
        """
        kwargs['_return_http_data_only'] = True
        return self.get_file_with_http_info(file_id, **kwargs)  # noqa: E501

    def get_file_with_http_info(self, file_id, **kwargs):  # noqa: E501
        """Retrieve a file  # noqa: E501

        Retrieves the information, such as file size, status and checksum, of a specific file.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_file_with_http_info(file_id, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str file_id: The file id. (required)
        :key str storage_type: Only return URIs for files from storages of this type.
        :key str method_type: Return URIs from storage methods with a particular type.  By default, return URLs with empty `methodType`.
        :key list[str] method_metadata: metadata used with storage method.
        :key bool include_item: - `true` - Return associated items, shapes, and components.  - `false` (default) - Do not return any information about associated items, shapes, and components.
        :key str scheme: URI scheme to return.
        :key _return_http_data_only: response data without head status code
                                       and headers
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(FileType, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['file_id', 'storage_type', 'method_type', 'method_metadata', 'include_item', 'scheme']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_file" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'file_id' is set
        if ('file_id' not in local_var_params or
                local_var_params['file_id'] is None):
            raise ApiValueError("Missing the required parameter `file_id` when calling `get_file`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'file_id' in local_var_params:
            path_params['file-id'] = local_var_params['file_id']  # noqa: E501

        query_params = []
        if 'storage_type' in local_var_params:
            query_params.append(('storageType', local_var_params['storage_type']))  # noqa: E501
        if 'method_type' in local_var_params:
            query_params.append(('methodType', local_var_params['method_type']))  # noqa: E501
        if 'method_metadata' in local_var_params:
            query_params.append(('methodMetadata', local_var_params['method_metadata']))  # noqa: E501
            collection_formats['methodMetadata'] = 'multi'  # noqa: E501
        if 'include_item' in local_var_params:
            query_params.append(('includeItem', local_var_params['include_item']))  # noqa: E501
        if 'scheme' in local_var_params:
            query_params.append(('scheme', local_var_params['scheme']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'text/plain', 'application/xml'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/file/{file-id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='FileType',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_file_data(self, file_id, **kwargs):  # noqa: E501
        """Retrieve the file data  # noqa: E501

        Retrieves the raw file data.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_file_data(file_id, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str file_id: The file id. (required)
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: file.
                 If the method is called asynchronously, returns the request thread.
        :rtype: file or multiprocessing.pool.AsyncResult
        """
        kwargs['_return_http_data_only'] = True
        return self.get_file_data_with_http_info(file_id, **kwargs)  # noqa: E501

    def get_file_data_with_http_info(self, file_id, **kwargs):  # noqa: E501
        """Retrieve the file data  # noqa: E501

        Retrieves the raw file data.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_file_data_with_http_info(file_id, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str file_id: The file id. (required)
        :key _return_http_data_only: response data without head status code
                                       and headers
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(file, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['file_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_file_data" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'file_id' is set
        if ('file_id' not in local_var_params or
                local_var_params['file_id'] is None):
            raise ApiValueError("Missing the required parameter `file_id` when calling `get_file_data`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'file_id' in local_var_params:
            path_params['file-id'] = local_var_params['file_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/octet-stream'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/file/{file-id}/data', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='file',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_file_metadata(self, file_id, **kwargs):  # noqa: E501
        """Retrieve all metadata  # noqa: E501

        Retrieves all key-value pairs associated with the specified entity.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_file_metadata(file_id, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str file_id: The file id. (required)
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: SimpleMetadataType.
                 If the method is called asynchronously, returns the request thread.
        :rtype: SimpleMetadataType or multiprocessing.pool.AsyncResult
        """
        kwargs['_return_http_data_only'] = True
        return self.get_file_metadata_with_http_info(file_id, **kwargs)  # noqa: E501

    def get_file_metadata_with_http_info(self, file_id, **kwargs):  # noqa: E501
        """Retrieve all metadata  # noqa: E501

        Retrieves all key-value pairs associated with the specified entity.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_file_metadata_with_http_info(file_id, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str file_id: The file id. (required)
        :key _return_http_data_only: response data without head status code
                                       and headers
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(SimpleMetadataType, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['file_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_file_metadata" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'file_id' is set
        if ('file_id' not in local_var_params or
                local_var_params['file_id'] is None):
            raise ApiValueError("Missing the required parameter `file_id` when calling `get_file_metadata`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'file_id' in local_var_params:
            path_params['file-id'] = local_var_params['file_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'application/xml'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/file/{file-id}/metadata', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SimpleMetadataType',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_file_metadata_key(self, file_id, keypath, **kwargs):  # noqa: E501
        """Retrieve the metadata for a specific key  # noqa: E501

        Retrieves the value of a specific key. If a key path is specified, exactly one key-value pair must match the key path, else an error is returned.  Key paths can also be specified as well as specific keys.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_file_metadata_key(file_id, keypath, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str file_id: The file id. (required)
        :param str keypath: The keypath. (required)
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: str.
                 If the method is called asynchronously, returns the request thread.
        :rtype: str or multiprocessing.pool.AsyncResult
        """
        kwargs['_return_http_data_only'] = True
        return self.get_file_metadata_key_with_http_info(file_id, keypath, **kwargs)  # noqa: E501

    def get_file_metadata_key_with_http_info(self, file_id, keypath, **kwargs):  # noqa: E501
        """Retrieve the metadata for a specific key  # noqa: E501

        Retrieves the value of a specific key. If a key path is specified, exactly one key-value pair must match the key path, else an error is returned.  Key paths can also be specified as well as specific keys.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_file_metadata_key_with_http_info(file_id, keypath, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str file_id: The file id. (required)
        :param str keypath: The keypath. (required)
        :key _return_http_data_only: response data without head status code
                                       and headers
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(str, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['file_id', 'keypath']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_file_metadata_key" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'file_id' is set
        if ('file_id' not in local_var_params or
                local_var_params['file_id'] is None):
            raise ApiValueError("Missing the required parameter `file_id` when calling `get_file_metadata_key`")  # noqa: E501
        # verify the required parameter 'keypath' is set
        if ('keypath' not in local_var_params or
                local_var_params['keypath'] is None):
            raise ApiValueError("Missing the required parameter `keypath` when calling `get_file_metadata_key`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'file_id' in local_var_params:
            path_params['file-id'] = local_var_params['file_id']  # noqa: E501
        if 'keypath' in local_var_params:
            path_params['keypath'] = local_var_params['keypath']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/file/{file-id}/metadata/{keypath}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='str',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_files(self, **kwargs):  # noqa: E501
        """List all files in a storage  # noqa: E501

        Retrieves the files for all or a specific storage.  There is a limit on how many files that can be returned for each call to this method. To get all files, iterate the calls.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_files(async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :key str storage_type: Only return URIs for files from storages of this type.
        :key int first: From total list of files, start return list from specified number.
        :key int prefix_first: From total list of prefixes, start return list from specified number.  Note: this parameter has no effect if Elasticsearch is the search backend.
        :key int number: Return a maximum of specified number of files.
        :key str storage_group: Storage group id.  Return only files from storages specified in the storage group
        :key bool ignorecase: - `true` - Search file path case insensitively - `false` - Search file path case sensitively
        :key bool prefix: - `true` - Also include file prefixes that matches the criteria - `false` (default) - Do not include file prefixes
        :key bool exclude_queued: - `true` - Exclude the files that are queued for import - `false` (default) - Do not exclude the files that are queued for import
        :key bool wildcard: - `true` - Allow use of wildcards in path.  - `false` (default) - No wildcard handling of path.
        :key list[str] state: Filter results by file state.  Can be used multiple times to select several states.
        :key str algorithm: Hash algorithm.  Search for hash values used by specified algorithm
        :key str method_type: Return URIs from storage methods with a particular type.  By default, return URLs with empty `methodType`.
        :key int prefix_number: Return a maximum of specified number of prefixes.
        :key list[str] method_metadata: metadata used with storage method.
        :key list[str] storage: List of storage ids.  Return only files from specific storages.  Same as `storage-id` in URL, but can be specified multiple times
        :key str scheme: URI scheme to return.
        :key bool recursive: - `true` (default) - Return all files in tree.  - `false` - Return only files directly under specified path.
        :key str cursor: New in version 4. 16.   - `*` - The initial cursor.  - `string-from-search` - Cursor string returned from the search results.  If set, the cursorMark / search after features from Solr/Elasticsearch would be used to improve the deep paging  performance during a search.  When `cursor` is used, The value of `first` will be ignored.  Only metadata searches in the `generic` interval supports `cursor`.
        :key list[str] id: If multiple `id` query parameters are specified only those files are returned.  If no ids are specified, all files are returned.
        :key bool count: - `true` (default) - Return total number of hits in result - `false` - Do not return total number of hits in result, in order to produce results faster
        :key list[str] sort: Comma-separated list.   - `fileId` [ `asc` (default) | `desc` ] (default) - Order results by file id.  - `size` [ `asc` (default) | `desc` ] - Order results by file size (bytes).  - `state` [ `asc` (default) | `desc` ] - Order results by file state.  - `timestamp` [ `asc` (default) | `desc` ] - Order results by file timestamp.  - `filename` [ `asc` (default) | `desc` ] - Order results by filename.  - `extension` [ `asc` (default) | `desc` ] - Order results by file extension.
        :key list[str] hash: List of hash values.  Only return files with specific hash value.
        :key str filter: - `all` (default) - Return all files - `item` Only return files associated with an item.  - `noitem` Only return files not associated with any item.
        :key bool include_item: - `true` - Return associated items, shapes, and components.  - `false` (default) - Do not return any information about associated items, shapes, and components.
        :key str path: - *path* - Return files under this sub-path to storage.  - `/` (default) - Return all files.
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: FileListType.
                 If the method is called asynchronously, returns the request thread.
        :rtype: FileListType or multiprocessing.pool.AsyncResult
        """
        kwargs['_return_http_data_only'] = True
        return self.get_files_with_http_info(**kwargs)  # noqa: E501

    def get_files_with_http_info(self, **kwargs):  # noqa: E501
        """List all files in a storage  # noqa: E501

        Retrieves the files for all or a specific storage.  There is a limit on how many files that can be returned for each call to this method. To get all files, iterate the calls.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_files_with_http_info(async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :key str storage_type: Only return URIs for files from storages of this type.
        :key int first: From total list of files, start return list from specified number.
        :key int prefix_first: From total list of prefixes, start return list from specified number.  Note: this parameter has no effect if Elasticsearch is the search backend.
        :key int number: Return a maximum of specified number of files.
        :key str storage_group: Storage group id.  Return only files from storages specified in the storage group
        :key bool ignorecase: - `true` - Search file path case insensitively - `false` - Search file path case sensitively
        :key bool prefix: - `true` - Also include file prefixes that matches the criteria - `false` (default) - Do not include file prefixes
        :key bool exclude_queued: - `true` - Exclude the files that are queued for import - `false` (default) - Do not exclude the files that are queued for import
        :key bool wildcard: - `true` - Allow use of wildcards in path.  - `false` (default) - No wildcard handling of path.
        :key list[str] state: Filter results by file state.  Can be used multiple times to select several states.
        :key str algorithm: Hash algorithm.  Search for hash values used by specified algorithm
        :key str method_type: Return URIs from storage methods with a particular type.  By default, return URLs with empty `methodType`.
        :key int prefix_number: Return a maximum of specified number of prefixes.
        :key list[str] method_metadata: metadata used with storage method.
        :key list[str] storage: List of storage ids.  Return only files from specific storages.  Same as `storage-id` in URL, but can be specified multiple times
        :key str scheme: URI scheme to return.
        :key bool recursive: - `true` (default) - Return all files in tree.  - `false` - Return only files directly under specified path.
        :key str cursor: New in version 4. 16.   - `*` - The initial cursor.  - `string-from-search` - Cursor string returned from the search results.  If set, the cursorMark / search after features from Solr/Elasticsearch would be used to improve the deep paging  performance during a search.  When `cursor` is used, The value of `first` will be ignored.  Only metadata searches in the `generic` interval supports `cursor`.
        :key list[str] id: If multiple `id` query parameters are specified only those files are returned.  If no ids are specified, all files are returned.
        :key bool count: - `true` (default) - Return total number of hits in result - `false` - Do not return total number of hits in result, in order to produce results faster
        :key list[str] sort: Comma-separated list.   - `fileId` [ `asc` (default) | `desc` ] (default) - Order results by file id.  - `size` [ `asc` (default) | `desc` ] - Order results by file size (bytes).  - `state` [ `asc` (default) | `desc` ] - Order results by file state.  - `timestamp` [ `asc` (default) | `desc` ] - Order results by file timestamp.  - `filename` [ `asc` (default) | `desc` ] - Order results by filename.  - `extension` [ `asc` (default) | `desc` ] - Order results by file extension.
        :key list[str] hash: List of hash values.  Only return files with specific hash value.
        :key str filter: - `all` (default) - Return all files - `item` Only return files associated with an item.  - `noitem` Only return files not associated with any item.
        :key bool include_item: - `true` - Return associated items, shapes, and components.  - `false` (default) - Do not return any information about associated items, shapes, and components.
        :key str path: - *path* - Return files under this sub-path to storage.  - `/` (default) - Return all files.
        :key _return_http_data_only: response data without head status code
                                       and headers
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(FileListType, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['storage_type', 'first', 'prefix_first', 'number', 'storage_group', 'ignorecase', 'prefix', 'exclude_queued', 'wildcard', 'state', 'algorithm', 'method_type', 'prefix_number', 'method_metadata', 'storage', 'scheme', 'recursive', 'cursor', 'id', 'count', 'sort', 'hash', 'filter', 'include_item', 'path']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_files" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'storage_type' in local_var_params:
            query_params.append(('storageType', local_var_params['storage_type']))  # noqa: E501
        if 'first' in local_var_params:
            query_params.append(('first', local_var_params['first']))  # noqa: E501
        if 'prefix_first' in local_var_params:
            query_params.append(('prefixFirst', local_var_params['prefix_first']))  # noqa: E501
        if 'number' in local_var_params:
            query_params.append(('number', local_var_params['number']))  # noqa: E501
        if 'storage_group' in local_var_params:
            query_params.append(('storageGroup', local_var_params['storage_group']))  # noqa: E501
        if 'ignorecase' in local_var_params:
            query_params.append(('ignorecase', local_var_params['ignorecase']))  # noqa: E501
        if 'prefix' in local_var_params:
            query_params.append(('prefix', local_var_params['prefix']))  # noqa: E501
        if 'exclude_queued' in local_var_params:
            query_params.append(('excludeQueued', local_var_params['exclude_queued']))  # noqa: E501
        if 'wildcard' in local_var_params:
            query_params.append(('wildcard', local_var_params['wildcard']))  # noqa: E501
        if 'state' in local_var_params:
            query_params.append(('state', local_var_params['state']))  # noqa: E501
            collection_formats['state'] = 'multi'  # noqa: E501
        if 'algorithm' in local_var_params:
            query_params.append(('algorithm', local_var_params['algorithm']))  # noqa: E501
        if 'method_type' in local_var_params:
            query_params.append(('methodType', local_var_params['method_type']))  # noqa: E501
        if 'prefix_number' in local_var_params:
            query_params.append(('prefixNumber', local_var_params['prefix_number']))  # noqa: E501
        if 'method_metadata' in local_var_params:
            query_params.append(('methodMetadata', local_var_params['method_metadata']))  # noqa: E501
            collection_formats['methodMetadata'] = 'multi'  # noqa: E501
        if 'storage' in local_var_params:
            query_params.append(('storage', local_var_params['storage']))  # noqa: E501
            collection_formats['storage'] = 'multi'  # noqa: E501
        if 'scheme' in local_var_params:
            query_params.append(('scheme', local_var_params['scheme']))  # noqa: E501
        if 'recursive' in local_var_params:
            query_params.append(('recursive', local_var_params['recursive']))  # noqa: E501
        if 'cursor' in local_var_params:
            query_params.append(('cursor', local_var_params['cursor']))  # noqa: E501
        if 'id' in local_var_params:
            query_params.append(('id', local_var_params['id']))  # noqa: E501
            collection_formats['id'] = 'multi'  # noqa: E501
        if 'count' in local_var_params:
            query_params.append(('count', local_var_params['count']))  # noqa: E501
        if 'sort' in local_var_params:
            query_params.append(('sort', local_var_params['sort']))  # noqa: E501
            collection_formats['sort'] = 'csv'  # noqa: E501
        if 'hash' in local_var_params:
            query_params.append(('hash', local_var_params['hash']))  # noqa: E501
            collection_formats['hash'] = 'multi'  # noqa: E501
        if 'filter' in local_var_params:
            query_params.append(('filter', local_var_params['filter']))  # noqa: E501
        if 'include_item' in local_var_params:
            query_params.append(('includeItem', local_var_params['include_item']))  # noqa: E501
        if 'path' in local_var_params:
            query_params.append(('path', local_var_params['path']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'text/plain', 'application/xml'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/storage/file', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='FileListType',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def register_file_path(self, path, file_id, **kwargs):  # noqa: E501
        """Register a new file path  # noqa: E501

        Registers a new file, with the new path, and change all relevant components to point to the new file instead. The old file is marked for deletion. Hence, caller should first do the physical move, then issue this command.  The path of file entities in Vidispine is immutable. This command is used when a file is moved manually (without Vidispine), and caller wants to register the new path.  Use the `duplicate` parameter to add another file as a duplicate. The file at the new location will be added to all components that the file is already a part of. No file entities will be removed.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.register_file_path(path, file_id, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str path: The new path. (required)
        :param str file_id: The file id. (required)
        :key str state: New state of the file.  (OPEN, CLOSED, etc).
        :key bool duplicate: - `true` - The file at the target path is a duplicate of this file.  The old file entity will NOT be removed.  - `false` (default) - This target path is the new location.  This old file entity will be removed.
        :key str storage: The new storage, if omitted, the same storage.
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: FileType.
                 If the method is called asynchronously, returns the request thread.
        :rtype: FileType or multiprocessing.pool.AsyncResult
        """
        kwargs['_return_http_data_only'] = True
        return self.register_file_path_with_http_info(path, file_id, **kwargs)  # noqa: E501

    def register_file_path_with_http_info(self, path, file_id, **kwargs):  # noqa: E501
        """Register a new file path  # noqa: E501

        Registers a new file, with the new path, and change all relevant components to point to the new file instead. The old file is marked for deletion. Hence, caller should first do the physical move, then issue this command.  The path of file entities in Vidispine is immutable. This command is used when a file is moved manually (without Vidispine), and caller wants to register the new path.  Use the `duplicate` parameter to add another file as a duplicate. The file at the new location will be added to all components that the file is already a part of. No file entities will be removed.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.register_file_path_with_http_info(path, file_id, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str path: The new path. (required)
        :param str file_id: The file id. (required)
        :key str state: New state of the file.  (OPEN, CLOSED, etc).
        :key bool duplicate: - `true` - The file at the target path is a duplicate of this file.  The old file entity will NOT be removed.  - `false` (default) - This target path is the new location.  This old file entity will be removed.
        :key str storage: The new storage, if omitted, the same storage.
        :key _return_http_data_only: response data without head status code
                                       and headers
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(FileType, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['path', 'file_id', 'state', 'duplicate', 'storage']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method register_file_path" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'path' is set
        if ('path' not in local_var_params or
                local_var_params['path'] is None):
            raise ApiValueError("Missing the required parameter `path` when calling `register_file_path`")  # noqa: E501
        # verify the required parameter 'file_id' is set
        if ('file_id' not in local_var_params or
                local_var_params['file_id'] is None):
            raise ApiValueError("Missing the required parameter `file_id` when calling `register_file_path`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'file_id' in local_var_params:
            path_params['file-id'] = local_var_params['file_id']  # noqa: E501

        query_params = []
        if 'state' in local_var_params:
            query_params.append(('state', local_var_params['state']))  # noqa: E501
        if 'duplicate' in local_var_params:
            query_params.append(('duplicate', local_var_params['duplicate']))  # noqa: E501
        if 'storage' in local_var_params:
            query_params.append(('storage', local_var_params['storage']))  # noqa: E501
        if 'path' in local_var_params:
            query_params.append(('path', local_var_params['path']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'text/plain', 'application/xml'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/file/{file-id}/path', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='FileType',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def reindex_file(self, file_id, **kwargs):  # noqa: E501
        """Re-index a file  # noqa: E501

        Queues a single file for re-index.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.reindex_file(file_id, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str file_id: The file id. (required)
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: str.
                 If the method is called asynchronously, returns the request thread.
        :rtype: str or multiprocessing.pool.AsyncResult
        """
        kwargs['_return_http_data_only'] = True
        return self.reindex_file_with_http_info(file_id, **kwargs)  # noqa: E501

    def reindex_file_with_http_info(self, file_id, **kwargs):  # noqa: E501
        """Re-index a file  # noqa: E501

        Queues a single file for re-index.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.reindex_file_with_http_info(file_id, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str file_id: The file id. (required)
        :key _return_http_data_only: response data without head status code
                                       and headers
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(str, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['file_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method reindex_file" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'file_id' is set
        if ('file_id' not in local_var_params or
                local_var_params['file_id'] is None):
            raise ApiValueError("Missing the required parameter `file_id` when calling `reindex_file`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'file_id' in local_var_params:
            path_params['file-id'] = local_var_params['file_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/file/{file-id}/re-index', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='str',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def remove_file_from_item(self, file_id, **kwargs):  # noqa: E501
        """Remove a file from an item  # noqa: E501

        Disassociates (disconnects) the physical file from the item. The shape which the file resided in will still exist, but there is no longer any connection between the file and the shape or item.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.remove_file_from_item(file_id, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str file_id: The file id. (required)
        :key str item: The item from which the file in unassociated
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None.
                 If the method is called asynchronously, returns the request thread.
        :rtype: None or multiprocessing.pool.AsyncResult
        """
        kwargs['_return_http_data_only'] = True
        return self.remove_file_from_item_with_http_info(file_id, **kwargs)  # noqa: E501

    def remove_file_from_item_with_http_info(self, file_id, **kwargs):  # noqa: E501
        """Remove a file from an item  # noqa: E501

        Disassociates (disconnects) the physical file from the item. The shape which the file resided in will still exist, but there is no longer any connection between the file and the shape or item.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.remove_file_from_item_with_http_info(file_id, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str file_id: The file id. (required)
        :key str item: The item from which the file in unassociated
        :key _return_http_data_only: response data without head status code
                                       and headers
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['file_id', 'item']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method remove_file_from_item" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'file_id' is set
        if ('file_id' not in local_var_params or
                local_var_params['file_id'] is None):
            raise ApiValueError("Missing the required parameter `file_id` when calling `remove_file_from_item`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'file_id' in local_var_params:
            path_params['file-id'] = local_var_params['file_id']  # noqa: E501

        query_params = []
        if 'item' in local_var_params:
            query_params.append(('item', local_var_params['item']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/file/{file-id}/abandon', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def restore_file(self, expiration_in_days, file_id, **kwargs):  # noqa: E501
        """Transitioning files From S3 to Glacier  # noqa: E501

        Triggers a request to Glacier to initiate a restore.  Once the restore is complete, the file will be put in CLOSED state, and will be available for direct access.  The `expirationInDays` parameter has to be set and specifies how long the restored files should be available. Once it has expired, it will be removed from direct access and once again end up in the ARCHIVED state.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.restore_file(expiration_in_days, file_id, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param int expiration_in_days: How long the restored files should be available. (required)
        :param str file_id: The file id. (required)
        :key str retrieval_tier: Sets the Glacier retrieval tier to use when restoring the file.
        :key list[str] extra_data: Additional parameters relevant for the restore, in the form of `key=value`.  Specify multiple parameters using multiple query parameters.  <dl><dh>`expirationInDays={number-of-days}`</dh><dd>How long the restored files should be available. </dd></dl> Deprecated since version 4. 9: Use the  `expirationInDays`  query parameter instead.
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: str.
                 If the method is called asynchronously, returns the request thread.
        :rtype: str or multiprocessing.pool.AsyncResult
        """
        kwargs['_return_http_data_only'] = True
        return self.restore_file_with_http_info(expiration_in_days, file_id, **kwargs)  # noqa: E501

    def restore_file_with_http_info(self, expiration_in_days, file_id, **kwargs):  # noqa: E501
        """Transitioning files From S3 to Glacier  # noqa: E501

        Triggers a request to Glacier to initiate a restore.  Once the restore is complete, the file will be put in CLOSED state, and will be available for direct access.  The `expirationInDays` parameter has to be set and specifies how long the restored files should be available. Once it has expired, it will be removed from direct access and once again end up in the ARCHIVED state.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.restore_file_with_http_info(expiration_in_days, file_id, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param int expiration_in_days: How long the restored files should be available. (required)
        :param str file_id: The file id. (required)
        :key str retrieval_tier: Sets the Glacier retrieval tier to use when restoring the file.
        :key list[str] extra_data: Additional parameters relevant for the restore, in the form of `key=value`.  Specify multiple parameters using multiple query parameters.  <dl><dh>`expirationInDays={number-of-days}`</dh><dd>How long the restored files should be available. </dd></dl> Deprecated since version 4. 9: Use the  `expirationInDays`  query parameter instead.
        :key _return_http_data_only: response data without head status code
                                       and headers
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(str, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['expiration_in_days', 'file_id', 'retrieval_tier', 'extra_data']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method restore_file" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'expiration_in_days' is set
        if ('expiration_in_days' not in local_var_params or
                local_var_params['expiration_in_days'] is None):
            raise ApiValueError("Missing the required parameter `expiration_in_days` when calling `restore_file`")  # noqa: E501
        # verify the required parameter 'file_id' is set
        if ('file_id' not in local_var_params or
                local_var_params['file_id'] is None):
            raise ApiValueError("Missing the required parameter `file_id` when calling `restore_file`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'file_id' in local_var_params:
            path_params['file-id'] = local_var_params['file_id']  # noqa: E501

        query_params = []
        if 'retrieval_tier' in local_var_params:
            query_params.append(('retrievalTier', local_var_params['retrieval_tier']))  # noqa: E501
        if 'expiration_in_days' in local_var_params:
            query_params.append(('expirationInDays', local_var_params['expiration_in_days']))  # noqa: E501
        if 'extra_data' in local_var_params:
            query_params.append(('extraData', local_var_params['extra_data']))  # noqa: E501
            collection_formats['extraData'] = 'multi'  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/file/{file-id}/restore', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='str',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_file_data(self, file_id, body, **kwargs):  # noqa: E501
        """Update or create file data  # noqa: E501

        Uploads the file data for a specific file, overwriting any existing file data for the file.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_file_data(file_id, body, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str file_id: The file id. (required)
        :param file body: The raw file data. (required)
        :key int transfer_priority: An integer between 1 and 1000 that indicates what priority the transfer should be given in relation to other transfers.  A transfer with a high priority value is considered more important than a transfer with a low priority value.
        :key str transfer_id: An id to assign the transfer to be able to refer to it.
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: FileType.
                 If the method is called asynchronously, returns the request thread.
        :rtype: FileType or multiprocessing.pool.AsyncResult
        """
        kwargs['_return_http_data_only'] = True
        return self.update_file_data_with_http_info(file_id, body, **kwargs)  # noqa: E501

    def update_file_data_with_http_info(self, file_id, body, **kwargs):  # noqa: E501
        """Update or create file data  # noqa: E501

        Uploads the file data for a specific file, overwriting any existing file data for the file.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_file_data_with_http_info(file_id, body, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str file_id: The file id. (required)
        :param file body: The raw file data. (required)
        :key int transfer_priority: An integer between 1 and 1000 that indicates what priority the transfer should be given in relation to other transfers.  A transfer with a high priority value is considered more important than a transfer with a low priority value.
        :key str transfer_id: An id to assign the transfer to be able to refer to it.
        :key _return_http_data_only: response data without head status code
                                       and headers
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(FileType, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['file_id', 'body', 'transfer_priority', 'transfer_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_file_data" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'file_id' is set
        if ('file_id' not in local_var_params or
                local_var_params['file_id'] is None):
            raise ApiValueError("Missing the required parameter `file_id` when calling `update_file_data`")  # noqa: E501
        # verify the required parameter 'body' is set
        if ('body' not in local_var_params or
                local_var_params['body'] is None):
            raise ApiValueError("Missing the required parameter `body` when calling `update_file_data`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'file_id' in local_var_params:
            path_params['file-id'] = local_var_params['file_id']  # noqa: E501

        query_params = []
        if 'transfer_priority' in local_var_params:
            query_params.append(('transferPriority', local_var_params['transfer_priority']))  # noqa: E501
        if 'transfer_id' in local_var_params:
            query_params.append(('transferId', local_var_params['transfer_id']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in local_var_params:
            body_params = local_var_params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'application/xml'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/octet-stream'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/file/{file-id}/data', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='FileType',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_file_hash(self, file_id, hash, **kwargs):  # noqa: E501
        """Set file hash  # noqa: E501

        Set a new hash value of a file.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_file_hash(file_id, hash, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str file_id: The file id. (required)
        :param str hash: The hash. (required)
        :key str algorithm: Hash algorithm of the new hash.  If omitted, the default SHA-1 hash is set.
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None.
                 If the method is called asynchronously, returns the request thread.
        :rtype: None or multiprocessing.pool.AsyncResult
        """
        kwargs['_return_http_data_only'] = True
        return self.update_file_hash_with_http_info(file_id, hash, **kwargs)  # noqa: E501

    def update_file_hash_with_http_info(self, file_id, hash, **kwargs):  # noqa: E501
        """Set file hash  # noqa: E501

        Set a new hash value of a file.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_file_hash_with_http_info(file_id, hash, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str file_id: The file id. (required)
        :param str hash: The hash. (required)
        :key str algorithm: Hash algorithm of the new hash.  If omitted, the default SHA-1 hash is set.
        :key _return_http_data_only: response data without head status code
                                       and headers
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['file_id', 'hash', 'algorithm']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_file_hash" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'file_id' is set
        if ('file_id' not in local_var_params or
                local_var_params['file_id'] is None):
            raise ApiValueError("Missing the required parameter `file_id` when calling `update_file_hash`")  # noqa: E501
        # verify the required parameter 'hash' is set
        if ('hash' not in local_var_params or
                local_var_params['hash'] is None):
            raise ApiValueError("Missing the required parameter `hash` when calling `update_file_hash`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'file_id' in local_var_params:
            path_params['file-id'] = local_var_params['file_id']  # noqa: E501
        if 'hash' in local_var_params:
            path_params['hash'] = local_var_params['hash']  # noqa: E501

        query_params = []
        if 'algorithm' in local_var_params:
            query_params.append(('algorithm', local_var_params['algorithm']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/file/{file-id}/hash/{hash}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_file_metadata(self, file_id, simple_metadata_type, **kwargs):  # noqa: E501
        """Create multiple key-value pairs  # noqa: E501

        Sets all the specified key-value pairs.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_file_metadata(file_id, simple_metadata_type, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str file_id: The file id. (required)
        :param SimpleMetadataType simple_metadata_type: (required)
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None.
                 If the method is called asynchronously, returns the request thread.
        :rtype: None or multiprocessing.pool.AsyncResult
        """
        kwargs['_return_http_data_only'] = True
        return self.update_file_metadata_with_http_info(file_id, simple_metadata_type, **kwargs)  # noqa: E501

    def update_file_metadata_with_http_info(self, file_id, simple_metadata_type, **kwargs):  # noqa: E501
        """Create multiple key-value pairs  # noqa: E501

        Sets all the specified key-value pairs.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_file_metadata_with_http_info(file_id, simple_metadata_type, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str file_id: The file id. (required)
        :param SimpleMetadataType simple_metadata_type: (required)
        :key _return_http_data_only: response data without head status code
                                       and headers
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['file_id', 'simple_metadata_type']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_file_metadata" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'file_id' is set
        if ('file_id' not in local_var_params or
                local_var_params['file_id'] is None):
            raise ApiValueError("Missing the required parameter `file_id` when calling `update_file_metadata`")  # noqa: E501
        # verify the required parameter 'simple_metadata_type' is set
        if ('simple_metadata_type' not in local_var_params or
                local_var_params['simple_metadata_type'] is None):
            raise ApiValueError("Missing the required parameter `simple_metadata_type` when calling `update_file_metadata`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'file_id' in local_var_params:
            path_params['file-id'] = local_var_params['file_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'simple_metadata_type' in local_var_params:
            body_params = local_var_params['simple_metadata_type']
        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'application/xml'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/file/{file-id}/metadata', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_file_metadata_key(self, file_id, keypath, body, **kwargs):  # noqa: E501
        """Set the value for a specific key  # noqa: E501

        Sets the value for a specific key. The key path may not contain wildcards.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_file_metadata_key(file_id, keypath, body, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str file_id: The file id. (required)
        :param str keypath: The keypath. (required)
        :param str body: The raw string value. (required)
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None.
                 If the method is called asynchronously, returns the request thread.
        :rtype: None or multiprocessing.pool.AsyncResult
        """
        kwargs['_return_http_data_only'] = True
        return self.update_file_metadata_key_with_http_info(file_id, keypath, body, **kwargs)  # noqa: E501

    def update_file_metadata_key_with_http_info(self, file_id, keypath, body, **kwargs):  # noqa: E501
        """Set the value for a specific key  # noqa: E501

        Sets the value for a specific key. The key path may not contain wildcards.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_file_metadata_key_with_http_info(file_id, keypath, body, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str file_id: The file id. (required)
        :param str keypath: The keypath. (required)
        :param str body: The raw string value. (required)
        :key _return_http_data_only: response data without head status code
                                       and headers
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['file_id', 'keypath', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_file_metadata_key" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'file_id' is set
        if ('file_id' not in local_var_params or
                local_var_params['file_id'] is None):
            raise ApiValueError("Missing the required parameter `file_id` when calling `update_file_metadata_key`")  # noqa: E501
        # verify the required parameter 'keypath' is set
        if ('keypath' not in local_var_params or
                local_var_params['keypath'] is None):
            raise ApiValueError("Missing the required parameter `keypath` when calling `update_file_metadata_key`")  # noqa: E501
        # verify the required parameter 'body' is set
        if ('body' not in local_var_params or
                local_var_params['body'] is None):
            raise ApiValueError("Missing the required parameter `body` when calling `update_file_metadata_key`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'file_id' in local_var_params:
            path_params['file-id'] = local_var_params['file_id']  # noqa: E501
        if 'keypath' in local_var_params:
            path_params['keypath'] = local_var_params['keypath']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in local_var_params:
            body_params = local_var_params['body']
        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['text/plain'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/file/{file-id}/metadata/{keypath}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_file_state(self, state, file_id, **kwargs):  # noqa: E501
        """Update the file state  # noqa: E501

        Changes the state of the specified file to the given state.  Can for example be used after writing a file to a storage, to immediately mark it as CLOSED and no longer growing.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_file_state(state, file_id, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str state: The new state of the file. (required)
        :param str file_id: The file id. (required)
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: FileType.
                 If the method is called asynchronously, returns the request thread.
        :rtype: FileType or multiprocessing.pool.AsyncResult
        """
        kwargs['_return_http_data_only'] = True
        return self.update_file_state_with_http_info(state, file_id, **kwargs)  # noqa: E501

    def update_file_state_with_http_info(self, state, file_id, **kwargs):  # noqa: E501
        """Update the file state  # noqa: E501

        Changes the state of the specified file to the given state.  Can for example be used after writing a file to a storage, to immediately mark it as CLOSED and no longer growing.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_file_state_with_http_info(state, file_id, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str state: The new state of the file. (required)
        :param str file_id: The file id. (required)
        :key _return_http_data_only: response data without head status code
                                       and headers
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(FileType, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['state', 'file_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_file_state" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'state' is set
        if ('state' not in local_var_params or
                local_var_params['state'] is None):
            raise ApiValueError("Missing the required parameter `state` when calling `update_file_state`")  # noqa: E501
        # verify the required parameter 'file_id' is set
        if ('file_id' not in local_var_params or
                local_var_params['file_id'] is None):
            raise ApiValueError("Missing the required parameter `file_id` when calling `update_file_state`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'state' in local_var_params:
            path_params['state'] = local_var_params['state']  # noqa: E501
        if 'file_id' in local_var_params:
            path_params['file-id'] = local_var_params['file_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'text/plain', 'application/xml'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/file/{file-id}/state/{state}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='FileType',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)
