# coding: utf-8

"""
    Vidispine API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)  # noqa: E501

    The version of the OpenAPI document: 5.x
    Contact: info@vidispine.com
    Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from vidispine.models import *
from vidispine.api_client import ApiClient
from vidispine.exceptions import (
    ApiTypeError,
    ApiValueError
)


class GlobalMetadataApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def delete_metadata_entry(self, uuid, **kwargs):  # noqa: E501
        """Remove metadata by UUID  # noqa: E501

        Removes the metadata with the specified UUID.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_metadata_entry(uuid, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str uuid: The uuid. (required)
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None.
                 If the method is called asynchronously, returns the request thread.
        :rtype: None or multiprocessing.pool.AsyncResult
        """
        kwargs['_return_http_data_only'] = True
        return self.delete_metadata_entry_with_http_info(uuid, **kwargs)  # noqa: E501

    def delete_metadata_entry_with_http_info(self, uuid, **kwargs):  # noqa: E501
        """Remove metadata by UUID  # noqa: E501

        Removes the metadata with the specified UUID.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_metadata_entry_with_http_info(uuid, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str uuid: The uuid. (required)
        :key _return_http_data_only: response data without head status code
                                       and headers
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['uuid']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_metadata_entry" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'uuid' is set
        if ('uuid' not in local_var_params or
                local_var_params['uuid'] is None):
            raise ApiValueError("Missing the required parameter `uuid` when calling `delete_metadata_entry`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'uuid' in local_var_params:
            path_params['uuid'] = local_var_params['uuid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/metadata/{uuid}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_global_metadata(self, **kwargs):  # noqa: E501
        """Retrieve the global metadata  # noqa: E501

        Retrieves the global metadata.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_global_metadata(async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :key list[str] language: Comma-separated list.   - *language-tag* - Return metadata for specific language, e. g.  `en_US`.  Wildcards may be used, e. g.  `*_CA` for both Canadian French and Canadian English.  - `none` - Return all metadata without language specification.  - `all` (default) - Return all metadata, with or without language specification.
        :key list[str] include_constraint_value: Comma-separated list of fields whose \"display value\" should be retrieved from the metadata dataset.   - `all` (default) - Return the \"display value\" of all fields.  - `none` - No \"display value\" will be returned.  The fields will only have `id` set.  - *comma-separated field names* - Return the \"display value\" of the specified fields.
        :key list[str] track: Comma-separated list.   - *track-type* *track-number* - Return metadata for specified track.  Example of track is `A2`.  - *track-type* *t1* `-` *t2* - Return metadata for specified track interval, e. g.  `A2-4`.  - *track-type* `*` - Return metadata for all tracks of specified type, e. g.  `A*`.  - `generic` - Return all non-tracked metadata.  - `all` (default) - All metadata, with or without track specification, are returned.
        :key str conflict: - `yes` (default) - Include all metadata conflicts, unresolved.  - `no` - Return conflicts resolved according to field rules.
        :key str samplerate: Convert all outgoing time instants to specified rate.  *NB!* Time codes which cannot be expressed in an integer number of samples will be returned as a decimal number, with risk of losing precision.
        :key bool default_value: - `true` - For unset fields, return default values.  - `false` (default) - Do not return default values.
        :key list[str] interval: Comma-separated list  - *time-span* - Filter out metadata, return only metadata for specified time span.  - `generic` - Return all non-timed metadata.  - `all` (default) - Return all metadata, same as `interval=generic,-INF-+INF`
        :key list[str] group: Comma-separated list.   - *group-name* - Return specified group.  - *group-name* `+` - Return specified group and subgroups.  - *group-name* `:` *new-name* - Return specified group, renamed to a new name in return value.  - `-` *group-name* - Exclude specified group.  - (default) - Return all groups.
        :key list[str] field: Comma-separated list.   - *field-name* - Return specified field.  - *field-name* \":\" *new-name* - Return specified field, renamed to a new name in return value.  - \"-\" *field-name* - Exclude specified field.  - (default) - Return all fields.
        :key str include: A list of keys.   Includes additional field specific data.  Additionally, if set to `type` the type definition of the field will be retrieved.
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: MetadataType.
                 If the method is called asynchronously, returns the request thread.
        :rtype: MetadataType or multiprocessing.pool.AsyncResult
        """
        kwargs['_return_http_data_only'] = True
        return self.get_global_metadata_with_http_info(**kwargs)  # noqa: E501

    def get_global_metadata_with_http_info(self, **kwargs):  # noqa: E501
        """Retrieve the global metadata  # noqa: E501

        Retrieves the global metadata.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_global_metadata_with_http_info(async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :key list[str] language: Comma-separated list.   - *language-tag* - Return metadata for specific language, e. g.  `en_US`.  Wildcards may be used, e. g.  `*_CA` for both Canadian French and Canadian English.  - `none` - Return all metadata without language specification.  - `all` (default) - Return all metadata, with or without language specification.
        :key list[str] include_constraint_value: Comma-separated list of fields whose \"display value\" should be retrieved from the metadata dataset.   - `all` (default) - Return the \"display value\" of all fields.  - `none` - No \"display value\" will be returned.  The fields will only have `id` set.  - *comma-separated field names* - Return the \"display value\" of the specified fields.
        :key list[str] track: Comma-separated list.   - *track-type* *track-number* - Return metadata for specified track.  Example of track is `A2`.  - *track-type* *t1* `-` *t2* - Return metadata for specified track interval, e. g.  `A2-4`.  - *track-type* `*` - Return metadata for all tracks of specified type, e. g.  `A*`.  - `generic` - Return all non-tracked metadata.  - `all` (default) - All metadata, with or without track specification, are returned.
        :key str conflict: - `yes` (default) - Include all metadata conflicts, unresolved.  - `no` - Return conflicts resolved according to field rules.
        :key str samplerate: Convert all outgoing time instants to specified rate.  *NB!* Time codes which cannot be expressed in an integer number of samples will be returned as a decimal number, with risk of losing precision.
        :key bool default_value: - `true` - For unset fields, return default values.  - `false` (default) - Do not return default values.
        :key list[str] interval: Comma-separated list  - *time-span* - Filter out metadata, return only metadata for specified time span.  - `generic` - Return all non-timed metadata.  - `all` (default) - Return all metadata, same as `interval=generic,-INF-+INF`
        :key list[str] group: Comma-separated list.   - *group-name* - Return specified group.  - *group-name* `+` - Return specified group and subgroups.  - *group-name* `:` *new-name* - Return specified group, renamed to a new name in return value.  - `-` *group-name* - Exclude specified group.  - (default) - Return all groups.
        :key list[str] field: Comma-separated list.   - *field-name* - Return specified field.  - *field-name* \":\" *new-name* - Return specified field, renamed to a new name in return value.  - \"-\" *field-name* - Exclude specified field.  - (default) - Return all fields.
        :key str include: A list of keys.   Includes additional field specific data.  Additionally, if set to `type` the type definition of the field will be retrieved.
        :key _return_http_data_only: response data without head status code
                                       and headers
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(MetadataType, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['language', 'include_constraint_value', 'track', 'conflict', 'samplerate', 'default_value', 'interval', 'group', 'field', 'include']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_global_metadata" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'language' in local_var_params:
            query_params.append(('language', local_var_params['language']))  # noqa: E501
            collection_formats['language'] = 'csv'  # noqa: E501
        if 'include_constraint_value' in local_var_params:
            query_params.append(('includeConstraintValue', local_var_params['include_constraint_value']))  # noqa: E501
            collection_formats['includeConstraintValue'] = 'csv'  # noqa: E501
        if 'track' in local_var_params:
            query_params.append(('track', local_var_params['track']))  # noqa: E501
            collection_formats['track'] = 'csv'  # noqa: E501
        if 'conflict' in local_var_params:
            query_params.append(('conflict', local_var_params['conflict']))  # noqa: E501
        if 'samplerate' in local_var_params:
            query_params.append(('samplerate', local_var_params['samplerate']))  # noqa: E501
        if 'default_value' in local_var_params:
            query_params.append(('defaultValue', local_var_params['default_value']))  # noqa: E501
        if 'interval' in local_var_params:
            query_params.append(('interval', local_var_params['interval']))  # noqa: E501
            collection_formats['interval'] = 'csv'  # noqa: E501
        if 'group' in local_var_params:
            query_params.append(('group', local_var_params['group']))  # noqa: E501
            collection_formats['group'] = 'csv'  # noqa: E501
        if 'field' in local_var_params:
            query_params.append(('field', local_var_params['field']))  # noqa: E501
            collection_formats['field'] = 'csv'  # noqa: E501
        if 'include' in local_var_params:
            query_params.append(('include', local_var_params['include']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'application/xml'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/metadata', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='MetadataType',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_metadata_entry(self, uuid, **kwargs):  # noqa: E501
        """Retrieve metadata by UUID  # noqa: E501

        Retrieves the metadata entry that matches the UUID.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_metadata_entry(uuid, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str uuid: The uuid. (required)
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: MetadataEntryType.
                 If the method is called asynchronously, returns the request thread.
        :rtype: MetadataEntryType or multiprocessing.pool.AsyncResult
        """
        kwargs['_return_http_data_only'] = True
        return self.get_metadata_entry_with_http_info(uuid, **kwargs)  # noqa: E501

    def get_metadata_entry_with_http_info(self, uuid, **kwargs):  # noqa: E501
        """Retrieve metadata by UUID  # noqa: E501

        Retrieves the metadata entry that matches the UUID.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_metadata_entry_with_http_info(uuid, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str uuid: The uuid. (required)
        :key _return_http_data_only: response data without head status code
                                       and headers
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(MetadataEntryType, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['uuid']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_metadata_entry" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'uuid' is set
        if ('uuid' not in local_var_params or
                local_var_params['uuid'] is None):
            raise ApiValueError("Missing the required parameter `uuid` when calling `get_metadata_entry`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'uuid' in local_var_params:
            path_params['uuid'] = local_var_params['uuid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'application/xml'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/metadata/{uuid}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='MetadataEntryType',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_global_metadata(self, metadata_type, **kwargs):  # noqa: E501
        """Update the global metadata  # noqa: E501

        Modifies the global metadata. This resource shares the same query parameters as the item metadata resource.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_global_metadata(metadata_type, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param MetadataType metadata_type: (required)
        :key str revision: The known revision.  If not specified, the change set will attempt to override existing change sets.
        :key bool only_return_changes: New in version 4. 16. 6.   - `true` - Only return the changed entries.  - `false` (default) - Return the whole global metadata after the update.
        :key bool skip_forbidden: Skip fields or groups that the user doesn't have write access to
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: MetadataType.
                 If the method is called asynchronously, returns the request thread.
        :rtype: MetadataType or multiprocessing.pool.AsyncResult
        """
        kwargs['_return_http_data_only'] = True
        return self.update_global_metadata_with_http_info(metadata_type, **kwargs)  # noqa: E501

    def update_global_metadata_with_http_info(self, metadata_type, **kwargs):  # noqa: E501
        """Update the global metadata  # noqa: E501

        Modifies the global metadata. This resource shares the same query parameters as the item metadata resource.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_global_metadata_with_http_info(metadata_type, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param MetadataType metadata_type: (required)
        :key str revision: The known revision.  If not specified, the change set will attempt to override existing change sets.
        :key bool only_return_changes: New in version 4. 16. 6.   - `true` - Only return the changed entries.  - `false` (default) - Return the whole global metadata after the update.
        :key bool skip_forbidden: Skip fields or groups that the user doesn't have write access to
        :key _return_http_data_only: response data without head status code
                                       and headers
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(MetadataType, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['metadata_type', 'revision', 'only_return_changes', 'skip_forbidden']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_global_metadata" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'metadata_type' is set
        if ('metadata_type' not in local_var_params or
                local_var_params['metadata_type'] is None):
            raise ApiValueError("Missing the required parameter `metadata_type` when calling `update_global_metadata`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'revision' in local_var_params:
            query_params.append(('revision', local_var_params['revision']))  # noqa: E501
        if 'only_return_changes' in local_var_params:
            query_params.append(('onlyReturnChanges', local_var_params['only_return_changes']))  # noqa: E501
        if 'skip_forbidden' in local_var_params:
            query_params.append(('skipForbidden', local_var_params['skip_forbidden']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'metadata_type' in local_var_params:
            body_params = local_var_params['metadata_type']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'application/xml'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'application/xml'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/metadata', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='MetadataType',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)
