# coding: utf-8

"""
    Vidispine API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)  # noqa: E501

    The version of the OpenAPI document: 5.x
    Contact: info@vidispine.com
    Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from vidispine.models import *
from vidispine.api_client import ApiClient
from vidispine.exceptions import (
    ApiTypeError,
    ApiValueError
)


class ImportApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def adopt_file(self, item_id, file_id, **kwargs):  # noqa: E501
        """Adopt stand-alone files  # noqa: E501

        Adopt the file as a component in a placeholder item.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.adopt_file(item_id, file_id, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str item_id: The item id. (required)
        :param str file_id: The file id. (required)
        :key int index: Index (order) of the component.
        :key str shape_id: Shape id for which shape to receive the content.
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None.
                 If the method is called asynchronously, returns the request thread.
        :rtype: None or multiprocessing.pool.AsyncResult
        """
        kwargs['_return_http_data_only'] = True
        return self.adopt_file_with_http_info(item_id, file_id, **kwargs)  # noqa: E501

    def adopt_file_with_http_info(self, item_id, file_id, **kwargs):  # noqa: E501
        """Adopt stand-alone files  # noqa: E501

        Adopt the file as a component in a placeholder item.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.adopt_file_with_http_info(item_id, file_id, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str item_id: The item id. (required)
        :param str file_id: The file id. (required)
        :key int index: Index (order) of the component.
        :key str shape_id: Shape id for which shape to receive the content.
        :key _return_http_data_only: response data without head status code
                                       and headers
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['item_id', 'file_id', 'index', 'shape_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method adopt_file" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'item_id' is set
        if ('item_id' not in local_var_params or
                local_var_params['item_id'] is None):
            raise ApiValueError("Missing the required parameter `item_id` when calling `adopt_file`")  # noqa: E501
        # verify the required parameter 'file_id' is set
        if ('file_id' not in local_var_params or
                local_var_params['file_id'] is None):
            raise ApiValueError("Missing the required parameter `file_id` when calling `adopt_file`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'item_id' in local_var_params:
            path_params['item-id'] = local_var_params['item_id']  # noqa: E501
        if 'file_id' in local_var_params:
            path_params['file-id'] = local_var_params['file_id']  # noqa: E501

        query_params = []
        if 'index' in local_var_params:
            query_params.append(('index', local_var_params['index']))  # noqa: E501
        if 'shape_id' in local_var_params:
            query_params.append(('shapeId', local_var_params['shape_id']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/import/placeholder/{item-id}/[container,audio,video,binary]/adopt/{file-id}', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_placeholder(self, metadata_type, **kwargs):  # noqa: E501
        """Create a placeholder item  # noqa: E501

        Creates an empty item and a shape with components matching the given parameters.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_placeholder(metadata_type, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param MetadataType metadata_type: <em>MetadataDocument</em>, initial metadata that is given to the imported item. (required)
        :key int binary: The number of files that contain binary components.
        :key int audio: The number of files that contain audio components.
        :key str type: - `image-sequence`- Image sequence.  - `dpx` - DPX sequence.  Deprecated since version 4. 6: Import image sequences using URIs with file fragments instead.
        :key str settings: Pre-configured import settings.
        :key int container: The number of files that contain container components.
        :key int video: The number of files that contain video components.
        :key str frame_duration: duration for each image in the sequence.
        :key list[str] import_tag: A list of shape tags that the created shape will be associated with.
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: ItemType.
                 If the method is called asynchronously, returns the request thread.
        :rtype: ItemType or multiprocessing.pool.AsyncResult
        """
        kwargs['_return_http_data_only'] = True
        return self.create_placeholder_with_http_info(metadata_type, **kwargs)  # noqa: E501

    def create_placeholder_with_http_info(self, metadata_type, **kwargs):  # noqa: E501
        """Create a placeholder item  # noqa: E501

        Creates an empty item and a shape with components matching the given parameters.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_placeholder_with_http_info(metadata_type, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param MetadataType metadata_type: <em>MetadataDocument</em>, initial metadata that is given to the imported item. (required)
        :key int binary: The number of files that contain binary components.
        :key int audio: The number of files that contain audio components.
        :key str type: - `image-sequence`- Image sequence.  - `dpx` - DPX sequence.  Deprecated since version 4. 6: Import image sequences using URIs with file fragments instead.
        :key str settings: Pre-configured import settings.
        :key int container: The number of files that contain container components.
        :key int video: The number of files that contain video components.
        :key str frame_duration: duration for each image in the sequence.
        :key list[str] import_tag: A list of shape tags that the created shape will be associated with.
        :key _return_http_data_only: response data without head status code
                                       and headers
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(ItemType, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['metadata_type', 'binary', 'audio', 'type', 'settings', 'container', 'video', 'frame_duration', 'import_tag']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_placeholder" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'metadata_type' is set
        if ('metadata_type' not in local_var_params or
                local_var_params['metadata_type'] is None):
            raise ApiValueError("Missing the required parameter `metadata_type` when calling `create_placeholder`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'binary' in local_var_params:
            query_params.append(('binary', local_var_params['binary']))  # noqa: E501
        if 'audio' in local_var_params:
            query_params.append(('audio', local_var_params['audio']))  # noqa: E501
        if 'type' in local_var_params:
            query_params.append(('type', local_var_params['type']))  # noqa: E501
        if 'settings' in local_var_params:
            query_params.append(('settings', local_var_params['settings']))  # noqa: E501
        if 'container' in local_var_params:
            query_params.append(('container', local_var_params['container']))  # noqa: E501
        if 'video' in local_var_params:
            query_params.append(('video', local_var_params['video']))  # noqa: E501
        if 'frame_duration' in local_var_params:
            query_params.append(('frameDuration', local_var_params['frame_duration']))  # noqa: E501
        if 'import_tag' in local_var_params:
            query_params.append(('importTag', local_var_params['import_tag']))  # noqa: E501
            collection_formats['importTag'] = 'multi'  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'metadata_type' in local_var_params:
            body_params = local_var_params['metadata_type']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'text/plain', 'application/xml'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'application/xml'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/import/placeholder', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ItemType',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_placeholder_import_passkey(self, item_id, **kwargs):  # noqa: E501
        """Create passkey for placeholder item  # noqa: E501

        Creates a new passkey for a specific placeholder item, that can be used to perform imports to this item without requiring authentication.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_placeholder_import_passkey(item_id, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str item_id: The item id. (required)
        :key str shape_id: Shape id for which shape to receive the content.
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: URIListType.
                 If the method is called asynchronously, returns the request thread.
        :rtype: URIListType or multiprocessing.pool.AsyncResult
        """
        kwargs['_return_http_data_only'] = True
        return self.create_placeholder_import_passkey_with_http_info(item_id, **kwargs)  # noqa: E501

    def create_placeholder_import_passkey_with_http_info(self, item_id, **kwargs):  # noqa: E501
        """Create passkey for placeholder item  # noqa: E501

        Creates a new passkey for a specific placeholder item, that can be used to perform imports to this item without requiring authentication.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_placeholder_import_passkey_with_http_info(item_id, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str item_id: The item id. (required)
        :key str shape_id: Shape id for which shape to receive the content.
        :key _return_http_data_only: response data without head status code
                                       and headers
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(URIListType, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['item_id', 'shape_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_placeholder_import_passkey" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'item_id' is set
        if ('item_id' not in local_var_params or
                local_var_params['item_id'] is None):
            raise ApiValueError("Missing the required parameter `item_id` when calling `create_placeholder_import_passkey`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'item_id' in local_var_params:
            path_params['item-id'] = local_var_params['item_id']  # noqa: E501

        query_params = []
        if 'shape_id' in local_var_params:
            query_params.append(('shapeId', local_var_params['shape_id']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'application/xml'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/import/placeholder/{item-id}/raw-passkey', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='URIListType',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_default_access_control_for_group(self, group_name, **kwargs):  # noqa: E501
        """Remove a group from the default access control list  # noqa: E501

        Removes the specified group from the default access control list.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_default_access_control_for_group(group_name, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str group_name: The group name. (required)
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None.
                 If the method is called asynchronously, returns the request thread.
        :rtype: None or multiprocessing.pool.AsyncResult
        """
        kwargs['_return_http_data_only'] = True
        return self.delete_default_access_control_for_group_with_http_info(group_name, **kwargs)  # noqa: E501

    def delete_default_access_control_for_group_with_http_info(self, group_name, **kwargs):  # noqa: E501
        """Remove a group from the default access control list  # noqa: E501

        Removes the specified group from the default access control list.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_default_access_control_for_group_with_http_info(group_name, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str group_name: The group name. (required)
        :key _return_http_data_only: response data without head status code
                                       and headers
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['group_name']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_default_access_control_for_group" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'group_name' is set
        if ('group_name' not in local_var_params or
                local_var_params['group_name'] is None):
            raise ApiValueError("Missing the required parameter `group_name` when calling `delete_default_access_control_for_group`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'group_name' in local_var_params:
            path_params['group-name'] = local_var_params['group_name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/import/access/group/{group-name}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_default_access_controls(self, **kwargs):  # noqa: E501
        """List the default access controls for the current user  # noqa: E501

        Lists the access control list that will be applied on imported items.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_default_access_controls(async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: ImportAccessControlListType.
                 If the method is called asynchronously, returns the request thread.
        :rtype: ImportAccessControlListType or multiprocessing.pool.AsyncResult
        """
        kwargs['_return_http_data_only'] = True
        return self.get_default_access_controls_with_http_info(**kwargs)  # noqa: E501

    def get_default_access_controls_with_http_info(self, **kwargs):  # noqa: E501
        """List the default access controls for the current user  # noqa: E501

        Lists the access control list that will be applied on imported items.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_default_access_controls_with_http_info(async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :key _return_http_data_only: response data without head status code
                                       and headers
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(ImportAccessControlListType, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_default_access_controls" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'application/xml'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/import/access', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ImportAccessControlListType',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_import_storage(self, **kwargs):  # noqa: E501
        """Find destination storage  # noqa: E501

        Find where imported content would be stored according to current storage rules.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_import_storage(async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :key str tag: Shape tag
        :key list[str] jobmetadata: Additional information for the job task.
        :key str item: Item id
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: StorageType.
                 If the method is called asynchronously, returns the request thread.
        :rtype: StorageType or multiprocessing.pool.AsyncResult
        """
        kwargs['_return_http_data_only'] = True
        return self.get_import_storage_with_http_info(**kwargs)  # noqa: E501

    def get_import_storage_with_http_info(self, **kwargs):  # noqa: E501
        """Find destination storage  # noqa: E501

        Find where imported content would be stored according to current storage rules.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_import_storage_with_http_info(async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :key str tag: Shape tag
        :key list[str] jobmetadata: Additional information for the job task.
        :key str item: Item id
        :key _return_http_data_only: response data without head status code
                                       and headers
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(StorageType, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['tag', 'jobmetadata', 'item']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_import_storage" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'tag' in local_var_params:
            query_params.append(('tag', local_var_params['tag']))  # noqa: E501
        if 'jobmetadata' in local_var_params:
            query_params.append(('jobmetadata', local_var_params['jobmetadata']))  # noqa: E501
            collection_formats['jobmetadata'] = 'multi'  # noqa: E501
        if 'item' in local_var_params:
            query_params.append(('item', local_var_params['item']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'application/xml'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/import/storage', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='StorageType',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_importables(self, **kwargs):  # noqa: E501
        """List all files that can be imported  # noqa: E501

        Retrieves a list of files, together with any found metadata, for files that do not belong to any component.  Same query parameters as for `GET {storage-resource}/file`.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_importables(async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :key str storage_type: Only return URIs for files from storages of this type.
        :key int first: From total list of files, start return list from specified number.
        :key int prefix_first: From total list of prefixes, start return list from specified number.  Note: this parameter has no effect if Elasticsearch is the search backend.
        :key int number: Return a maximum of specified number of files.
        :key str storage_group: Storage group id.  Return only files from storages specified in the storage group
        :key bool ignorecase: - `true` - Search file path case insensitively - `false` - Search file path case sensitively
        :key bool prefix: - `true` - Also include file prefixes that matches the criteria - `false` (default) - Do not include file prefixes
        :key bool exclude_queued: - `true` (default) - Exclude the files that are queued for import - `false` - Do not exclude the files that are queued for import
        :key str filter: - `all` (default) - Return all files - `item` Only return files associated with an item.  - `noitem` Only return files not associated with any item.
        :key list[str] state: Filter results by file state.  Can be used multiple times to select several states.
        :key str algorithm: Hash algorithm.  Search for hash values used by specified algorithm
        :key str method_type: Return URIs from storage methods with a particular type.  By default, return URLs with empty `methodType`.
        :key int prefix_number: Return a maximum of specified number of prefixes.
        :key list[str] method_metadata: metadata used with storage method.
        :key list[str] storage: List of storage ids.  Return only files from specific storages.  Same as `storage-id` in URL, but can be specified multiple times
        :key str scheme: URI scheme to return.
        :key bool recursive: - `true` (default) - Return all files in tree.  - `false` - Return only files directly under specified path.
        :key str cursor: New in version 4. 16.   - `*` - The initial cursor.  - `string-from-search` - Cursor string returned from the search results.  If set, the cursorMark / search after features from Solr/Elasticsearch would be used to improve the deep paging  performance during a search.  When `cursor` is used, The value of `first` will be ignored.  Only metadata searches in the `generic` interval supports `cursor`.
        :key bool auto: - `true` - Return files that will be automatically imported due to auto-import rules.  - `false` (default) - Do not return files that will be automatically imported.
        :key list[str] id: If multiple `id` query parameters are specified only those files are returned.  If no ids are specified, all files are returned.
        :key bool count: - `true` (default) - Return total number of hits in result - `false` - Do not return total number of hits in result, in order to produce results faster
        :key list[str] sort: Comma-separated list.   - `fileId` [ `asc` (default) | `desc` ] (default) - Order results by file id.  - `size` [ `asc` (default) | `desc` ] - Order results by file size (bytes).  - `state` [ `asc` (default) | `desc` ] - Order results by file state.  - `timestamp` [ `asc` (default) | `desc` ] - Order results by file timestamp.  - `filename` [ `asc` (default) | `desc` ] - Order results by filename.  - `extension` [ `asc` (default) | `desc` ] - Order results by file extension.
        :key list[str] hash: List of hash values.  Only return files with specific hash value.
        :key bool wildcard: - `true` - Allow use of wildcards in path.  - `false` (default) - No wildcard handling of path.
        :key str path: - *path* - Return files under this sub-path to storage.  - `/` (default) - Return all files.
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: ImportableFileListType.
                 If the method is called asynchronously, returns the request thread.
        :rtype: ImportableFileListType or multiprocessing.pool.AsyncResult
        """
        kwargs['_return_http_data_only'] = True
        return self.get_importables_with_http_info(**kwargs)  # noqa: E501

    def get_importables_with_http_info(self, **kwargs):  # noqa: E501
        """List all files that can be imported  # noqa: E501

        Retrieves a list of files, together with any found metadata, for files that do not belong to any component.  Same query parameters as for `GET {storage-resource}/file`.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_importables_with_http_info(async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :key str storage_type: Only return URIs for files from storages of this type.
        :key int first: From total list of files, start return list from specified number.
        :key int prefix_first: From total list of prefixes, start return list from specified number.  Note: this parameter has no effect if Elasticsearch is the search backend.
        :key int number: Return a maximum of specified number of files.
        :key str storage_group: Storage group id.  Return only files from storages specified in the storage group
        :key bool ignorecase: - `true` - Search file path case insensitively - `false` - Search file path case sensitively
        :key bool prefix: - `true` - Also include file prefixes that matches the criteria - `false` (default) - Do not include file prefixes
        :key bool exclude_queued: - `true` (default) - Exclude the files that are queued for import - `false` - Do not exclude the files that are queued for import
        :key str filter: - `all` (default) - Return all files - `item` Only return files associated with an item.  - `noitem` Only return files not associated with any item.
        :key list[str] state: Filter results by file state.  Can be used multiple times to select several states.
        :key str algorithm: Hash algorithm.  Search for hash values used by specified algorithm
        :key str method_type: Return URIs from storage methods with a particular type.  By default, return URLs with empty `methodType`.
        :key int prefix_number: Return a maximum of specified number of prefixes.
        :key list[str] method_metadata: metadata used with storage method.
        :key list[str] storage: List of storage ids.  Return only files from specific storages.  Same as `storage-id` in URL, but can be specified multiple times
        :key str scheme: URI scheme to return.
        :key bool recursive: - `true` (default) - Return all files in tree.  - `false` - Return only files directly under specified path.
        :key str cursor: New in version 4. 16.   - `*` - The initial cursor.  - `string-from-search` - Cursor string returned from the search results.  If set, the cursorMark / search after features from Solr/Elasticsearch would be used to improve the deep paging  performance during a search.  When `cursor` is used, The value of `first` will be ignored.  Only metadata searches in the `generic` interval supports `cursor`.
        :key bool auto: - `true` - Return files that will be automatically imported due to auto-import rules.  - `false` (default) - Do not return files that will be automatically imported.
        :key list[str] id: If multiple `id` query parameters are specified only those files are returned.  If no ids are specified, all files are returned.
        :key bool count: - `true` (default) - Return total number of hits in result - `false` - Do not return total number of hits in result, in order to produce results faster
        :key list[str] sort: Comma-separated list.   - `fileId` [ `asc` (default) | `desc` ] (default) - Order results by file id.  - `size` [ `asc` (default) | `desc` ] - Order results by file size (bytes).  - `state` [ `asc` (default) | `desc` ] - Order results by file state.  - `timestamp` [ `asc` (default) | `desc` ] - Order results by file timestamp.  - `filename` [ `asc` (default) | `desc` ] - Order results by filename.  - `extension` [ `asc` (default) | `desc` ] - Order results by file extension.
        :key list[str] hash: List of hash values.  Only return files with specific hash value.
        :key bool wildcard: - `true` - Allow use of wildcards in path.  - `false` (default) - No wildcard handling of path.
        :key str path: - *path* - Return files under this sub-path to storage.  - `/` (default) - Return all files.
        :key _return_http_data_only: response data without head status code
                                       and headers
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(ImportableFileListType, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['storage_type', 'first', 'prefix_first', 'number', 'storage_group', 'ignorecase', 'prefix', 'exclude_queued', 'filter', 'state', 'algorithm', 'method_type', 'prefix_number', 'method_metadata', 'storage', 'scheme', 'recursive', 'cursor', 'auto', 'id', 'count', 'sort', 'hash', 'wildcard', 'path']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_importables" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'storage_type' in local_var_params:
            query_params.append(('storageType', local_var_params['storage_type']))  # noqa: E501
        if 'first' in local_var_params:
            query_params.append(('first', local_var_params['first']))  # noqa: E501
        if 'prefix_first' in local_var_params:
            query_params.append(('prefixFirst', local_var_params['prefix_first']))  # noqa: E501
        if 'number' in local_var_params:
            query_params.append(('number', local_var_params['number']))  # noqa: E501
        if 'storage_group' in local_var_params:
            query_params.append(('storageGroup', local_var_params['storage_group']))  # noqa: E501
        if 'ignorecase' in local_var_params:
            query_params.append(('ignorecase', local_var_params['ignorecase']))  # noqa: E501
        if 'prefix' in local_var_params:
            query_params.append(('prefix', local_var_params['prefix']))  # noqa: E501
        if 'exclude_queued' in local_var_params:
            query_params.append(('excludeQueued', local_var_params['exclude_queued']))  # noqa: E501
        if 'filter' in local_var_params:
            query_params.append(('filter', local_var_params['filter']))  # noqa: E501
        if 'state' in local_var_params:
            query_params.append(('state', local_var_params['state']))  # noqa: E501
            collection_formats['state'] = 'multi'  # noqa: E501
        if 'algorithm' in local_var_params:
            query_params.append(('algorithm', local_var_params['algorithm']))  # noqa: E501
        if 'method_type' in local_var_params:
            query_params.append(('methodType', local_var_params['method_type']))  # noqa: E501
        if 'prefix_number' in local_var_params:
            query_params.append(('prefixNumber', local_var_params['prefix_number']))  # noqa: E501
        if 'method_metadata' in local_var_params:
            query_params.append(('methodMetadata', local_var_params['method_metadata']))  # noqa: E501
            collection_formats['methodMetadata'] = 'multi'  # noqa: E501
        if 'storage' in local_var_params:
            query_params.append(('storage', local_var_params['storage']))  # noqa: E501
            collection_formats['storage'] = 'multi'  # noqa: E501
        if 'scheme' in local_var_params:
            query_params.append(('scheme', local_var_params['scheme']))  # noqa: E501
        if 'recursive' in local_var_params:
            query_params.append(('recursive', local_var_params['recursive']))  # noqa: E501
        if 'cursor' in local_var_params:
            query_params.append(('cursor', local_var_params['cursor']))  # noqa: E501
        if 'auto' in local_var_params:
            query_params.append(('auto', local_var_params['auto']))  # noqa: E501
        if 'id' in local_var_params:
            query_params.append(('id', local_var_params['id']))  # noqa: E501
            collection_formats['id'] = 'multi'  # noqa: E501
        if 'count' in local_var_params:
            query_params.append(('count', local_var_params['count']))  # noqa: E501
        if 'sort' in local_var_params:
            query_params.append(('sort', local_var_params['sort']))  # noqa: E501
            collection_formats['sort'] = 'csv'  # noqa: E501
        if 'hash' in local_var_params:
            query_params.append(('hash', local_var_params['hash']))  # noqa: E501
            collection_formats['hash'] = 'multi'  # noqa: E501
        if 'wildcard' in local_var_params:
            query_params.append(('wildcard', local_var_params['wildcard']))  # noqa: E501
        if 'path' in local_var_params:
            query_params.append(('path', local_var_params['path']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'application/xml'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/storage/importable', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ImportableFileListType',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_storage_importables(self, storage_id, **kwargs):  # noqa: E501
        """List all files that can be imported  # noqa: E501

        Retrieves a list of files, together with any found metadata, for files that do not belong to any component.  Same query parameters as for `GET {storage-resource}/file`.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_storage_importables(storage_id, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str storage_id: The storage id. (required)
        :key str storage_type: Only return URIs for files from storages of this type.
        :key int first: From total list of files, start return list from specified number.
        :key int prefix_first: From total list of prefixes, start return list from specified number.  Note: this parameter has no effect if Elasticsearch is the search backend.
        :key int number: Return a maximum of specified number of files.
        :key str storage_group: Storage group id.  Return only files from storages specified in the storage group
        :key bool ignorecase: - `true` - Search file path case insensitively - `false` - Search file path case sensitively
        :key bool prefix: - `true` - Also include file prefixes that matches the criteria - `false` (default) - Do not include file prefixes
        :key bool exclude_queued: - `true` (default) - Exclude the files that are queued for import - `false` - Do not exclude the files that are queued for import
        :key str filter: - `all` (default) - Return all files - `item` Only return files associated with an item.  - `noitem` Only return files not associated with any item.
        :key list[str] state: Filter results by file state.  Can be used multiple times to select several states.
        :key str algorithm: Hash algorithm.  Search for hash values used by specified algorithm
        :key str method_type: Return URIs from storage methods with a particular type.  By default, return URLs with empty `methodType`.
        :key int prefix_number: Return a maximum of specified number of prefixes.
        :key list[str] method_metadata: metadata used with storage method.
        :key list[str] storage: List of storage ids.  Return only files from specific storages.  Same as `storage-id` in URL, but can be specified multiple times
        :key str scheme: URI scheme to return.
        :key bool recursive: - `true` (default) - Return all files in tree.  - `false` - Return only files directly under specified path.
        :key str cursor: New in version 4. 16.   - `*` - The initial cursor.  - `string-from-search` - Cursor string returned from the search results.  If set, the cursorMark / search after features from Solr/Elasticsearch would be used to improve the deep paging  performance during a search.  When `cursor` is used, The value of `first` will be ignored.  Only metadata searches in the `generic` interval supports `cursor`.
        :key bool auto: - `true` - Return files that will be automatically imported due to auto-import rules.  - `false` (default) - Do not return files that will be automatically imported.
        :key list[str] id: If multiple `id` query parameters are specified only those files are returned.  If no ids are specified, all files are returned.
        :key bool count: - `true` (default) - Return total number of hits in result - `false` - Do not return total number of hits in result, in order to produce results faster
        :key list[str] sort: Comma-separated list.   - `fileId` [ `asc` (default) | `desc` ] (default) - Order results by file id.  - `size` [ `asc` (default) | `desc` ] - Order results by file size (bytes).  - `state` [ `asc` (default) | `desc` ] - Order results by file state.  - `timestamp` [ `asc` (default) | `desc` ] - Order results by file timestamp.  - `filename` [ `asc` (default) | `desc` ] - Order results by filename.  - `extension` [ `asc` (default) | `desc` ] - Order results by file extension.
        :key list[str] hash: List of hash values.  Only return files with specific hash value.
        :key bool wildcard: - `true` - Allow use of wildcards in path.  - `false` (default) - No wildcard handling of path.
        :key str path: - *path* - Return files under this sub-path to storage.  - `/` (default) - Return all files.
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: ImportableFileListType.
                 If the method is called asynchronously, returns the request thread.
        :rtype: ImportableFileListType or multiprocessing.pool.AsyncResult
        """
        kwargs['_return_http_data_only'] = True
        return self.get_storage_importables_with_http_info(storage_id, **kwargs)  # noqa: E501

    def get_storage_importables_with_http_info(self, storage_id, **kwargs):  # noqa: E501
        """List all files that can be imported  # noqa: E501

        Retrieves a list of files, together with any found metadata, for files that do not belong to any component.  Same query parameters as for `GET {storage-resource}/file`.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_storage_importables_with_http_info(storage_id, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str storage_id: The storage id. (required)
        :key str storage_type: Only return URIs for files from storages of this type.
        :key int first: From total list of files, start return list from specified number.
        :key int prefix_first: From total list of prefixes, start return list from specified number.  Note: this parameter has no effect if Elasticsearch is the search backend.
        :key int number: Return a maximum of specified number of files.
        :key str storage_group: Storage group id.  Return only files from storages specified in the storage group
        :key bool ignorecase: - `true` - Search file path case insensitively - `false` - Search file path case sensitively
        :key bool prefix: - `true` - Also include file prefixes that matches the criteria - `false` (default) - Do not include file prefixes
        :key bool exclude_queued: - `true` (default) - Exclude the files that are queued for import - `false` - Do not exclude the files that are queued for import
        :key str filter: - `all` (default) - Return all files - `item` Only return files associated with an item.  - `noitem` Only return files not associated with any item.
        :key list[str] state: Filter results by file state.  Can be used multiple times to select several states.
        :key str algorithm: Hash algorithm.  Search for hash values used by specified algorithm
        :key str method_type: Return URIs from storage methods with a particular type.  By default, return URLs with empty `methodType`.
        :key int prefix_number: Return a maximum of specified number of prefixes.
        :key list[str] method_metadata: metadata used with storage method.
        :key list[str] storage: List of storage ids.  Return only files from specific storages.  Same as `storage-id` in URL, but can be specified multiple times
        :key str scheme: URI scheme to return.
        :key bool recursive: - `true` (default) - Return all files in tree.  - `false` - Return only files directly under specified path.
        :key str cursor: New in version 4. 16.   - `*` - The initial cursor.  - `string-from-search` - Cursor string returned from the search results.  If set, the cursorMark / search after features from Solr/Elasticsearch would be used to improve the deep paging  performance during a search.  When `cursor` is used, The value of `first` will be ignored.  Only metadata searches in the `generic` interval supports `cursor`.
        :key bool auto: - `true` - Return files that will be automatically imported due to auto-import rules.  - `false` (default) - Do not return files that will be automatically imported.
        :key list[str] id: If multiple `id` query parameters are specified only those files are returned.  If no ids are specified, all files are returned.
        :key bool count: - `true` (default) - Return total number of hits in result - `false` - Do not return total number of hits in result, in order to produce results faster
        :key list[str] sort: Comma-separated list.   - `fileId` [ `asc` (default) | `desc` ] (default) - Order results by file id.  - `size` [ `asc` (default) | `desc` ] - Order results by file size (bytes).  - `state` [ `asc` (default) | `desc` ] - Order results by file state.  - `timestamp` [ `asc` (default) | `desc` ] - Order results by file timestamp.  - `filename` [ `asc` (default) | `desc` ] - Order results by filename.  - `extension` [ `asc` (default) | `desc` ] - Order results by file extension.
        :key list[str] hash: List of hash values.  Only return files with specific hash value.
        :key bool wildcard: - `true` - Allow use of wildcards in path.  - `false` (default) - No wildcard handling of path.
        :key str path: - *path* - Return files under this sub-path to storage.  - `/` (default) - Return all files.
        :key _return_http_data_only: response data without head status code
                                       and headers
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(ImportableFileListType, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['storage_id', 'storage_type', 'first', 'prefix_first', 'number', 'storage_group', 'ignorecase', 'prefix', 'exclude_queued', 'filter', 'state', 'algorithm', 'method_type', 'prefix_number', 'method_metadata', 'storage', 'scheme', 'recursive', 'cursor', 'auto', 'id', 'count', 'sort', 'hash', 'wildcard', 'path']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_storage_importables" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'storage_id' is set
        if ('storage_id' not in local_var_params or
                local_var_params['storage_id'] is None):
            raise ApiValueError("Missing the required parameter `storage_id` when calling `get_storage_importables`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'storage_id' in local_var_params:
            path_params['storage-id'] = local_var_params['storage_id']  # noqa: E501

        query_params = []
        if 'storage_type' in local_var_params:
            query_params.append(('storageType', local_var_params['storage_type']))  # noqa: E501
        if 'first' in local_var_params:
            query_params.append(('first', local_var_params['first']))  # noqa: E501
        if 'prefix_first' in local_var_params:
            query_params.append(('prefixFirst', local_var_params['prefix_first']))  # noqa: E501
        if 'number' in local_var_params:
            query_params.append(('number', local_var_params['number']))  # noqa: E501
        if 'storage_group' in local_var_params:
            query_params.append(('storageGroup', local_var_params['storage_group']))  # noqa: E501
        if 'ignorecase' in local_var_params:
            query_params.append(('ignorecase', local_var_params['ignorecase']))  # noqa: E501
        if 'prefix' in local_var_params:
            query_params.append(('prefix', local_var_params['prefix']))  # noqa: E501
        if 'exclude_queued' in local_var_params:
            query_params.append(('excludeQueued', local_var_params['exclude_queued']))  # noqa: E501
        if 'filter' in local_var_params:
            query_params.append(('filter', local_var_params['filter']))  # noqa: E501
        if 'state' in local_var_params:
            query_params.append(('state', local_var_params['state']))  # noqa: E501
            collection_formats['state'] = 'multi'  # noqa: E501
        if 'algorithm' in local_var_params:
            query_params.append(('algorithm', local_var_params['algorithm']))  # noqa: E501
        if 'method_type' in local_var_params:
            query_params.append(('methodType', local_var_params['method_type']))  # noqa: E501
        if 'prefix_number' in local_var_params:
            query_params.append(('prefixNumber', local_var_params['prefix_number']))  # noqa: E501
        if 'method_metadata' in local_var_params:
            query_params.append(('methodMetadata', local_var_params['method_metadata']))  # noqa: E501
            collection_formats['methodMetadata'] = 'multi'  # noqa: E501
        if 'storage' in local_var_params:
            query_params.append(('storage', local_var_params['storage']))  # noqa: E501
            collection_formats['storage'] = 'multi'  # noqa: E501
        if 'scheme' in local_var_params:
            query_params.append(('scheme', local_var_params['scheme']))  # noqa: E501
        if 'recursive' in local_var_params:
            query_params.append(('recursive', local_var_params['recursive']))  # noqa: E501
        if 'cursor' in local_var_params:
            query_params.append(('cursor', local_var_params['cursor']))  # noqa: E501
        if 'auto' in local_var_params:
            query_params.append(('auto', local_var_params['auto']))  # noqa: E501
        if 'id' in local_var_params:
            query_params.append(('id', local_var_params['id']))  # noqa: E501
            collection_formats['id'] = 'multi'  # noqa: E501
        if 'count' in local_var_params:
            query_params.append(('count', local_var_params['count']))  # noqa: E501
        if 'sort' in local_var_params:
            query_params.append(('sort', local_var_params['sort']))  # noqa: E501
            collection_formats['sort'] = 'csv'  # noqa: E501
        if 'hash' in local_var_params:
            query_params.append(('hash', local_var_params['hash']))  # noqa: E501
            collection_formats['hash'] = 'multi'  # noqa: E501
        if 'wildcard' in local_var_params:
            query_params.append(('wildcard', local_var_params['wildcard']))  # noqa: E501
        if 'path' in local_var_params:
            query_params.append(('path', local_var_params['path']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'application/xml'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/storage/{storage-id}/importable', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ImportableFileListType',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def import_file(self, file_id, metadata_type, **kwargs):  # noqa: E501
        """Import a file  # noqa: E501

        Starts a an import job that will import the specified file. Only files that do not belong to any components can be imported.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.import_file(file_id, metadata_type, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str file_id: The file id. (required)
        :param MetadataType metadata_type: <em>MetadataDocument</em>, initial metadata that is given to the imported item. (required)
        :key str resource_id: The transcoder resource to use to execute the transcode.
        :key list[str] jobmetadata: Additional information for the job task.
        :key str notification_data: Any additional data to include for notifications on this job.
        :key bool allow_reimport: - `true` - Import the file to this shape even if the file is already importing or is already part of another item.  - `false` (default) Reject the request if the file with the given id has already been imported or is currently importing.
        :key list[str] tag: A list of shape tags to use for transcoding.
        :key bool no_transcode: - `true` - Will disable transcoding even if the `tags` parameter is set.  Rather, the specified tag will be used to determine cropping, scaling etc.  of thumbnails.  - `false` (default) - Normal transcode.
        :key str thumbnail_service: Identifies which thumbnail resource that should be used.
        :key bool require_fast_start: - `true` (default) - Try to put the index tables (header) in front of the file.  - `false` - Put header at end of file.
        :key str notification: The placeholder job notification to use for this job.
        :key str fast_start_length: Estimated duration of the clip in seconds.
        :key list[str] import_tag: A list of shape tags that the created shape will be associated with.
        :key str settings: Pre-configured import settings.
        :key bool create_thumbnails: - `true` (default) - Generate thumbnails as per defined by shape tag.  - `false` - Disable thumbnail generation.
        :key str create_posters: A list of time codes to use for creating posters.
        :key bool override_fast_start: - `true` (default) - Use transcoder's estimate of the duration for allocating header space in MOV files and similar files.  - `false` - Do not use the transcoder's estimate of the duration.
        :key str id: Comma-delimited list of external ids to assign to the item.
        :key str filename: The original filename of the file.
        :key str priority: The priority to assign to the job.
        :key str original: If specified, should be one of the tags specified in the tag parameter.  Specifies that the original shape tag will be reset to the shape created to this tag.
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: JobType.
                 If the method is called asynchronously, returns the request thread.
        :rtype: JobType or multiprocessing.pool.AsyncResult
        """
        kwargs['_return_http_data_only'] = True
        return self.import_file_with_http_info(file_id, metadata_type, **kwargs)  # noqa: E501

    def import_file_with_http_info(self, file_id, metadata_type, **kwargs):  # noqa: E501
        """Import a file  # noqa: E501

        Starts a an import job that will import the specified file. Only files that do not belong to any components can be imported.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.import_file_with_http_info(file_id, metadata_type, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str file_id: The file id. (required)
        :param MetadataType metadata_type: <em>MetadataDocument</em>, initial metadata that is given to the imported item. (required)
        :key str resource_id: The transcoder resource to use to execute the transcode.
        :key list[str] jobmetadata: Additional information for the job task.
        :key str notification_data: Any additional data to include for notifications on this job.
        :key bool allow_reimport: - `true` - Import the file to this shape even if the file is already importing or is already part of another item.  - `false` (default) Reject the request if the file with the given id has already been imported or is currently importing.
        :key list[str] tag: A list of shape tags to use for transcoding.
        :key bool no_transcode: - `true` - Will disable transcoding even if the `tags` parameter is set.  Rather, the specified tag will be used to determine cropping, scaling etc.  of thumbnails.  - `false` (default) - Normal transcode.
        :key str thumbnail_service: Identifies which thumbnail resource that should be used.
        :key bool require_fast_start: - `true` (default) - Try to put the index tables (header) in front of the file.  - `false` - Put header at end of file.
        :key str notification: The placeholder job notification to use for this job.
        :key str fast_start_length: Estimated duration of the clip in seconds.
        :key list[str] import_tag: A list of shape tags that the created shape will be associated with.
        :key str settings: Pre-configured import settings.
        :key bool create_thumbnails: - `true` (default) - Generate thumbnails as per defined by shape tag.  - `false` - Disable thumbnail generation.
        :key str create_posters: A list of time codes to use for creating posters.
        :key bool override_fast_start: - `true` (default) - Use transcoder's estimate of the duration for allocating header space in MOV files and similar files.  - `false` - Do not use the transcoder's estimate of the duration.
        :key str id: Comma-delimited list of external ids to assign to the item.
        :key str filename: The original filename of the file.
        :key str priority: The priority to assign to the job.
        :key str original: If specified, should be one of the tags specified in the tag parameter.  Specifies that the original shape tag will be reset to the shape created to this tag.
        :key _return_http_data_only: response data without head status code
                                       and headers
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(JobType, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['file_id', 'metadata_type', 'resource_id', 'jobmetadata', 'notification_data', 'allow_reimport', 'tag', 'no_transcode', 'thumbnail_service', 'require_fast_start', 'notification', 'fast_start_length', 'import_tag', 'settings', 'create_thumbnails', 'create_posters', 'override_fast_start', 'id', 'filename', 'priority', 'original']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method import_file" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'file_id' is set
        if ('file_id' not in local_var_params or
                local_var_params['file_id'] is None):
            raise ApiValueError("Missing the required parameter `file_id` when calling `import_file`")  # noqa: E501
        # verify the required parameter 'metadata_type' is set
        if ('metadata_type' not in local_var_params or
                local_var_params['metadata_type'] is None):
            raise ApiValueError("Missing the required parameter `metadata_type` when calling `import_file`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'file_id' in local_var_params:
            path_params['file-id'] = local_var_params['file_id']  # noqa: E501

        query_params = []
        if 'resource_id' in local_var_params:
            query_params.append(('resourceId', local_var_params['resource_id']))  # noqa: E501
        if 'jobmetadata' in local_var_params:
            query_params.append(('jobmetadata', local_var_params['jobmetadata']))  # noqa: E501
            collection_formats['jobmetadata'] = 'multi'  # noqa: E501
        if 'notification_data' in local_var_params:
            query_params.append(('notificationData', local_var_params['notification_data']))  # noqa: E501
        if 'allow_reimport' in local_var_params:
            query_params.append(('allowReimport', local_var_params['allow_reimport']))  # noqa: E501
        if 'tag' in local_var_params:
            query_params.append(('tag', local_var_params['tag']))  # noqa: E501
            collection_formats['tag'] = 'multi'  # noqa: E501
        if 'no_transcode' in local_var_params:
            query_params.append(('no-transcode', local_var_params['no_transcode']))  # noqa: E501
        if 'thumbnail_service' in local_var_params:
            query_params.append(('thumbnailService', local_var_params['thumbnail_service']))  # noqa: E501
        if 'require_fast_start' in local_var_params:
            query_params.append(('requireFastStart', local_var_params['require_fast_start']))  # noqa: E501
        if 'notification' in local_var_params:
            query_params.append(('notification', local_var_params['notification']))  # noqa: E501
        if 'fast_start_length' in local_var_params:
            query_params.append(('fastStartLength', local_var_params['fast_start_length']))  # noqa: E501
        if 'import_tag' in local_var_params:
            query_params.append(('importTag', local_var_params['import_tag']))  # noqa: E501
            collection_formats['importTag'] = 'multi'  # noqa: E501
        if 'settings' in local_var_params:
            query_params.append(('settings', local_var_params['settings']))  # noqa: E501
        if 'create_thumbnails' in local_var_params:
            query_params.append(('createThumbnails', local_var_params['create_thumbnails']))  # noqa: E501
        if 'create_posters' in local_var_params:
            query_params.append(('createPosters', local_var_params['create_posters']))  # noqa: E501
        if 'override_fast_start' in local_var_params:
            query_params.append(('overrideFastStart', local_var_params['override_fast_start']))  # noqa: E501
        if 'id' in local_var_params:
            query_params.append(('id', local_var_params['id']))  # noqa: E501
        if 'filename' in local_var_params:
            query_params.append(('filename', local_var_params['filename']))  # noqa: E501
        if 'priority' in local_var_params:
            query_params.append(('priority', local_var_params['priority']))  # noqa: E501
        if 'original' in local_var_params:
            query_params.append(('original', local_var_params['original']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'metadata_type' in local_var_params:
            body_params = local_var_params['metadata_type']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'application/xml'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'application/xml'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/file/{file-id}/import', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='JobType',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def import_file_asset_map(self, file_id, metadata_type, **kwargs):  # noqa: E501
        """Import an IMF package  # noqa: E501

        Starts a an import job that will import an `ASSETMAP` file (SMPTE ST 429-9). Files pointed to by the assetmap (DCP/InterOp or SMPTE) has to be stored in the same directory.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.import_file_asset_map(file_id, metadata_type, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str file_id: The file id. (required)
        :param MetadataType metadata_type: <em>MetadataDocument</em>, initial metadata that is given to the imported item. (required)
        :key list[str] jobmetadata: Additional information for the job task.
        :key str notification_data: Any additional data to include for notifications on this job.
        :key str thumbnail_service: Identifies which thumbnail resource that should be used.
        :key bool no_transcode: - `true` - Will disable transcoding even if the `tags` parameter is set.  Rather, the specified tag will be used to determine cropping, scaling etc.  of thumbnails.  - `false` (default) - Normal transcode.
        :key list[str] tag: A list of shape tags to use for transcoding.
        :key bool require_fast_start: - `true` (default) - Try to put the index tables (header) in front of the file.  - `false` - Put header at end of file.
        :key str notification: The placeholder job notification to use for this job.
        :key bool override_fast_start: - `true` (default) - Use transcoder's estimate of the duration for allocating header space in MOV files and similar files.  - `false` - Do not use the transcoder's estimate of the duration.
        :key str fast_start_length: Estimated duration of the clip in seconds.
        :key list[str] import_tag: A list of shape tags that the created shape will be associated with.
        :key str settings: Pre-configured import settings.
        :key bool create_thumbnails: - `true` (default) - Generate thumbnails as per defined by shape tag.  - `false` - Disable thumbnail generation.
        :key str create_posters: A list of time codes to use for creating posters.
        :key bool allow_reimport: - `true` - Import the file to this shape even if the file is already importing or is already part of another item.  - `false` (default) Reject the request if the file with the given id has already been imported or is currently importing.
        :key str id: Comma-delimited list of external ids to assign to the item.
        :key str priority: The priority to assign to the job.
        :key str original: If specified, should be one of the tags specified in the tag parameter.  Specifies that the original shape tag will be reset to the shape created to this tag.
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: JobType.
                 If the method is called asynchronously, returns the request thread.
        :rtype: JobType or multiprocessing.pool.AsyncResult
        """
        kwargs['_return_http_data_only'] = True
        return self.import_file_asset_map_with_http_info(file_id, metadata_type, **kwargs)  # noqa: E501

    def import_file_asset_map_with_http_info(self, file_id, metadata_type, **kwargs):  # noqa: E501
        """Import an IMF package  # noqa: E501

        Starts a an import job that will import an `ASSETMAP` file (SMPTE ST 429-9). Files pointed to by the assetmap (DCP/InterOp or SMPTE) has to be stored in the same directory.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.import_file_asset_map_with_http_info(file_id, metadata_type, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str file_id: The file id. (required)
        :param MetadataType metadata_type: <em>MetadataDocument</em>, initial metadata that is given to the imported item. (required)
        :key list[str] jobmetadata: Additional information for the job task.
        :key str notification_data: Any additional data to include for notifications on this job.
        :key str thumbnail_service: Identifies which thumbnail resource that should be used.
        :key bool no_transcode: - `true` - Will disable transcoding even if the `tags` parameter is set.  Rather, the specified tag will be used to determine cropping, scaling etc.  of thumbnails.  - `false` (default) - Normal transcode.
        :key list[str] tag: A list of shape tags to use for transcoding.
        :key bool require_fast_start: - `true` (default) - Try to put the index tables (header) in front of the file.  - `false` - Put header at end of file.
        :key str notification: The placeholder job notification to use for this job.
        :key bool override_fast_start: - `true` (default) - Use transcoder's estimate of the duration for allocating header space in MOV files and similar files.  - `false` - Do not use the transcoder's estimate of the duration.
        :key str fast_start_length: Estimated duration of the clip in seconds.
        :key list[str] import_tag: A list of shape tags that the created shape will be associated with.
        :key str settings: Pre-configured import settings.
        :key bool create_thumbnails: - `true` (default) - Generate thumbnails as per defined by shape tag.  - `false` - Disable thumbnail generation.
        :key str create_posters: A list of time codes to use for creating posters.
        :key bool allow_reimport: - `true` - Import the file to this shape even if the file is already importing or is already part of another item.  - `false` (default) Reject the request if the file with the given id has already been imported or is currently importing.
        :key str id: Comma-delimited list of external ids to assign to the item.
        :key str priority: The priority to assign to the job.
        :key str original: If specified, should be one of the tags specified in the tag parameter.  Specifies that the original shape tag will be reset to the shape created to this tag.
        :key _return_http_data_only: response data without head status code
                                       and headers
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(JobType, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['file_id', 'metadata_type', 'jobmetadata', 'notification_data', 'thumbnail_service', 'no_transcode', 'tag', 'require_fast_start', 'notification', 'override_fast_start', 'fast_start_length', 'import_tag', 'settings', 'create_thumbnails', 'create_posters', 'allow_reimport', 'id', 'priority', 'original']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method import_file_asset_map" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'file_id' is set
        if ('file_id' not in local_var_params or
                local_var_params['file_id'] is None):
            raise ApiValueError("Missing the required parameter `file_id` when calling `import_file_asset_map`")  # noqa: E501
        # verify the required parameter 'metadata_type' is set
        if ('metadata_type' not in local_var_params or
                local_var_params['metadata_type'] is None):
            raise ApiValueError("Missing the required parameter `metadata_type` when calling `import_file_asset_map`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'file_id' in local_var_params:
            path_params['file-id'] = local_var_params['file_id']  # noqa: E501

        query_params = []
        if 'jobmetadata' in local_var_params:
            query_params.append(('jobmetadata', local_var_params['jobmetadata']))  # noqa: E501
            collection_formats['jobmetadata'] = 'multi'  # noqa: E501
        if 'notification_data' in local_var_params:
            query_params.append(('notificationData', local_var_params['notification_data']))  # noqa: E501
        if 'thumbnail_service' in local_var_params:
            query_params.append(('thumbnailService', local_var_params['thumbnail_service']))  # noqa: E501
        if 'no_transcode' in local_var_params:
            query_params.append(('no-transcode', local_var_params['no_transcode']))  # noqa: E501
        if 'tag' in local_var_params:
            query_params.append(('tag', local_var_params['tag']))  # noqa: E501
            collection_formats['tag'] = 'multi'  # noqa: E501
        if 'require_fast_start' in local_var_params:
            query_params.append(('requireFastStart', local_var_params['require_fast_start']))  # noqa: E501
        if 'notification' in local_var_params:
            query_params.append(('notification', local_var_params['notification']))  # noqa: E501
        if 'override_fast_start' in local_var_params:
            query_params.append(('overrideFastStart', local_var_params['override_fast_start']))  # noqa: E501
        if 'fast_start_length' in local_var_params:
            query_params.append(('fastStartLength', local_var_params['fast_start_length']))  # noqa: E501
        if 'import_tag' in local_var_params:
            query_params.append(('importTag', local_var_params['import_tag']))  # noqa: E501
            collection_formats['importTag'] = 'multi'  # noqa: E501
        if 'settings' in local_var_params:
            query_params.append(('settings', local_var_params['settings']))  # noqa: E501
        if 'create_thumbnails' in local_var_params:
            query_params.append(('createThumbnails', local_var_params['create_thumbnails']))  # noqa: E501
        if 'create_posters' in local_var_params:
            query_params.append(('createPosters', local_var_params['create_posters']))  # noqa: E501
        if 'allow_reimport' in local_var_params:
            query_params.append(('allowReimport', local_var_params['allow_reimport']))  # noqa: E501
        if 'id' in local_var_params:
            query_params.append(('id', local_var_params['id']))  # noqa: E501
        if 'priority' in local_var_params:
            query_params.append(('priority', local_var_params['priority']))  # noqa: E501
        if 'original' in local_var_params:
            query_params.append(('original', local_var_params['original']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'metadata_type' in local_var_params:
            body_params = local_var_params['metadata_type']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'application/xml'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'application/xml'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/file/{file-id}/import/assetmap', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='JobType',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def import_imf_package(self, uri, metadata_type, **kwargs):  # noqa: E501
        """Import an IMF package using a URI  # noqa: E501

        Starts a job that reads the asset map of an IMP (IMF package), and then imports the IMP. Essence files whose UUID is already managed by Vidispine Server are not copied. For more information about jobs, see /job/job. Note that thumbnails and poster frames are only generated if a transcode takes place.  The **importtag** query parameter either be a list of shapes, or on the format `uuid=tag`. The IMF import job accepts certain special **jobMetadata** parameters:  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.import_imf_package(uri, metadata_type, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str uri: A URI to the asset map that will be imported.  Tracks referenced by the asset map should be located in the same folder. (required)
        :param MetadataType metadata_type: <em>MetadataDocument</em>, initial metadata that is given to the imported item. (required)
        :key bool no_transcode: - `true` - Will disable transcoding even if the `tags` parameter is set.  Rather, the specified tag will be used to determine cropping, scaling etc.  of thumbnails.  - `false` (default) - Normal transcode.
        :key bool no_cp_lreimport: If `true`, do not allow reimport of CPL with same id
        :key str fast_start_length: Estimated duration of the clip in seconds.
        :key bool create_thumbnails: - `true` (default) - Generate thumbnails as per defined by shape tag.  - `false` - Disable thumbnail generation.
        :key str xmpfile: URI to a sidecar XMP metadata file.
        :key str create_posters: A list of time codes to use for creating posters.
        :key list[str] jobmetadata: Additional information for the job task.
        :key str notification_data: Any additional data to include for notifications on this job.
        :key str thumbnail_service: Identifies which thumbnail resource that should be used.
        :key bool require_fast_start: - `true` (default) - Try to put the index tables (header) in front of the file.  - `false` - Put header at end of file.
        :key bool growing: - `true` - Specifies that the input file is still written to, so enables growing file support.  - `false` (default) - No growing file handling of import file.
        :key list[str] tag: A list of shape tags to use for transcoding.
        :key str original: If specified, should be one of the tags specified in the tag parameter.  Specifies that the original shape tag will be reset to the shape created to this tag.
        :key str storage_id: Identifier of storage where essence file is to be stored.
        :key str settings: Pre-configured import settings.
        :key str notification: The placeholder job notification to use for this job.
        :key list[str] import_tag: A list of shape tags that the created shape will be associated with.
        :key str sidecar: URIs or file ids of any sidecar files to import to the item.
        :key str resource_id: The transcoder resource to use to execute the transcode.
        :key str priority: The priority to assign to the job.
        :key bool override_fast_start: - `true` (default) - Use transcoder's estimate of the duration for allocating header space in MOV files and similar files.  - `false` - Do not use the transcoder's estimate of the duration.
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: JobType.
                 If the method is called asynchronously, returns the request thread.
        :rtype: JobType or multiprocessing.pool.AsyncResult
        """
        kwargs['_return_http_data_only'] = True
        return self.import_imf_package_with_http_info(uri, metadata_type, **kwargs)  # noqa: E501

    def import_imf_package_with_http_info(self, uri, metadata_type, **kwargs):  # noqa: E501
        """Import an IMF package using a URI  # noqa: E501

        Starts a job that reads the asset map of an IMP (IMF package), and then imports the IMP. Essence files whose UUID is already managed by Vidispine Server are not copied. For more information about jobs, see /job/job. Note that thumbnails and poster frames are only generated if a transcode takes place.  The **importtag** query parameter either be a list of shapes, or on the format `uuid=tag`. The IMF import job accepts certain special **jobMetadata** parameters:  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.import_imf_package_with_http_info(uri, metadata_type, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str uri: A URI to the asset map that will be imported.  Tracks referenced by the asset map should be located in the same folder. (required)
        :param MetadataType metadata_type: <em>MetadataDocument</em>, initial metadata that is given to the imported item. (required)
        :key bool no_transcode: - `true` - Will disable transcoding even if the `tags` parameter is set.  Rather, the specified tag will be used to determine cropping, scaling etc.  of thumbnails.  - `false` (default) - Normal transcode.
        :key bool no_cp_lreimport: If `true`, do not allow reimport of CPL with same id
        :key str fast_start_length: Estimated duration of the clip in seconds.
        :key bool create_thumbnails: - `true` (default) - Generate thumbnails as per defined by shape tag.  - `false` - Disable thumbnail generation.
        :key str xmpfile: URI to a sidecar XMP metadata file.
        :key str create_posters: A list of time codes to use for creating posters.
        :key list[str] jobmetadata: Additional information for the job task.
        :key str notification_data: Any additional data to include for notifications on this job.
        :key str thumbnail_service: Identifies which thumbnail resource that should be used.
        :key bool require_fast_start: - `true` (default) - Try to put the index tables (header) in front of the file.  - `false` - Put header at end of file.
        :key bool growing: - `true` - Specifies that the input file is still written to, so enables growing file support.  - `false` (default) - No growing file handling of import file.
        :key list[str] tag: A list of shape tags to use for transcoding.
        :key str original: If specified, should be one of the tags specified in the tag parameter.  Specifies that the original shape tag will be reset to the shape created to this tag.
        :key str storage_id: Identifier of storage where essence file is to be stored.
        :key str settings: Pre-configured import settings.
        :key str notification: The placeholder job notification to use for this job.
        :key list[str] import_tag: A list of shape tags that the created shape will be associated with.
        :key str sidecar: URIs or file ids of any sidecar files to import to the item.
        :key str resource_id: The transcoder resource to use to execute the transcode.
        :key str priority: The priority to assign to the job.
        :key bool override_fast_start: - `true` (default) - Use transcoder's estimate of the duration for allocating header space in MOV files and similar files.  - `false` - Do not use the transcoder's estimate of the duration.
        :key _return_http_data_only: response data without head status code
                                       and headers
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(JobType, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['uri', 'metadata_type', 'no_transcode', 'no_cp_lreimport', 'fast_start_length', 'create_thumbnails', 'xmpfile', 'create_posters', 'jobmetadata', 'notification_data', 'thumbnail_service', 'require_fast_start', 'growing', 'tag', 'original', 'storage_id', 'settings', 'notification', 'import_tag', 'sidecar', 'resource_id', 'priority', 'override_fast_start']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method import_imf_package" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'uri' is set
        if ('uri' not in local_var_params or
                local_var_params['uri'] is None):
            raise ApiValueError("Missing the required parameter `uri` when calling `import_imf_package`")  # noqa: E501
        # verify the required parameter 'metadata_type' is set
        if ('metadata_type' not in local_var_params or
                local_var_params['metadata_type'] is None):
            raise ApiValueError("Missing the required parameter `metadata_type` when calling `import_imf_package`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'uri' in local_var_params:
            query_params.append(('uri', local_var_params['uri']))  # noqa: E501
        if 'no_transcode' in local_var_params:
            query_params.append(('no-transcode', local_var_params['no_transcode']))  # noqa: E501
        if 'no_cp_lreimport' in local_var_params:
            query_params.append(('noCPLreimport', local_var_params['no_cp_lreimport']))  # noqa: E501
        if 'fast_start_length' in local_var_params:
            query_params.append(('fastStartLength', local_var_params['fast_start_length']))  # noqa: E501
        if 'create_thumbnails' in local_var_params:
            query_params.append(('createThumbnails', local_var_params['create_thumbnails']))  # noqa: E501
        if 'xmpfile' in local_var_params:
            query_params.append(('xmpfile', local_var_params['xmpfile']))  # noqa: E501
        if 'create_posters' in local_var_params:
            query_params.append(('createPosters', local_var_params['create_posters']))  # noqa: E501
        if 'jobmetadata' in local_var_params:
            query_params.append(('jobmetadata', local_var_params['jobmetadata']))  # noqa: E501
            collection_formats['jobmetadata'] = 'multi'  # noqa: E501
        if 'notification_data' in local_var_params:
            query_params.append(('notificationData', local_var_params['notification_data']))  # noqa: E501
        if 'thumbnail_service' in local_var_params:
            query_params.append(('thumbnailService', local_var_params['thumbnail_service']))  # noqa: E501
        if 'require_fast_start' in local_var_params:
            query_params.append(('requireFastStart', local_var_params['require_fast_start']))  # noqa: E501
        if 'growing' in local_var_params:
            query_params.append(('growing', local_var_params['growing']))  # noqa: E501
        if 'tag' in local_var_params:
            query_params.append(('tag', local_var_params['tag']))  # noqa: E501
            collection_formats['tag'] = 'multi'  # noqa: E501
        if 'original' in local_var_params:
            query_params.append(('original', local_var_params['original']))  # noqa: E501
        if 'storage_id' in local_var_params:
            query_params.append(('storageId', local_var_params['storage_id']))  # noqa: E501
        if 'settings' in local_var_params:
            query_params.append(('settings', local_var_params['settings']))  # noqa: E501
        if 'notification' in local_var_params:
            query_params.append(('notification', local_var_params['notification']))  # noqa: E501
        if 'import_tag' in local_var_params:
            query_params.append(('importTag', local_var_params['import_tag']))  # noqa: E501
            collection_formats['importTag'] = 'multi'  # noqa: E501
        if 'sidecar' in local_var_params:
            query_params.append(('sidecar', local_var_params['sidecar']))  # noqa: E501
        if 'resource_id' in local_var_params:
            query_params.append(('resourceId', local_var_params['resource_id']))  # noqa: E501
        if 'priority' in local_var_params:
            query_params.append(('priority', local_var_params['priority']))  # noqa: E501
        if 'override_fast_start' in local_var_params:
            query_params.append(('overrideFastStart', local_var_params['override_fast_start']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'metadata_type' in local_var_params:
            body_params = local_var_params['metadata_type']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'application/xml'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'application/xml'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/import/imp', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='JobType',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def import_item(self, uri, metadata_type, **kwargs):  # noqa: E501
        """Import using a URI  # noqa: E501

        Starts a job that imports the file, located at the given URI, and creates an item. Note that thumbnails and poster frames are only generated if a transcode takes place.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.import_item(uri, metadata_type, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str uri: A URI to the file that will be imported.  Make sure to percent encode the URI. (required)
        :param MetadataType metadata_type: <em>MetadataDocument</em>, initial metadata that is given to the imported item. (required)
        :key bool no_transcode: - `true` - Will disable transcoding even if the `tags` parameter is set.  Rather, the specified tag will be used to determine cropping, scaling etc.  of thumbnails.  - `false` (default) - Normal transcode.
        :key str url: A URL to the file that will be imported.  (Deprecated since 4. 2. )
        :key str fast_start_length: Estimated duration of the clip in seconds.
        :key bool create_thumbnails: - `true` (default) - Generate thumbnails as per defined by shape tag.  - `false` - Disable thumbnail generation.
        :key str xmpfile: URI to a sidecar XMP metadata file.
        :key str create_posters: A list of time codes to use for creating posters.
        :key list[str] jobmetadata: Additional information for the job task.
        :key str notification_data: Any additional data to include for notifications on this job.
        :key str storage_id: Identifier of storage where essence file is to be stored.
        :key bool require_fast_start: - `true` (default) - Try to put the index tables (header) in front of the file.  - `false` - Put header at end of file.
        :key bool growing: - `true` - Specifies that the input file is still written to, so enables growing file support.  - `false` (default) - No growing file handling of import file.
        :key list[str] tag: A list of shape tags to use for transcoding.
        :key str resource_id: The transcoder resource to use to execute the transcode.
        :key str thumbnail_service: Identifies which thumbnail resource that should be used.
        :key str settings: Pre-configured import settings.
        :key str notification: The placeholder job notification to use for this job.
        :key list[str] import_tag: A list of shape tags that the created shape will be associated with.
        :key str sidecar: URIs or file ids of any sidecar files to import to the item.
        :key str original: If specified, should be one of the tags specified in the tag parameter.  Specifies that the original shape tag will be reset to the shape created to this tag.
        :key str priority: The priority to assign to the job.
        :key bool override_fast_start: - `true` (default) - Use transcoder's estimate of the duration for allocating header space in MOV files and similar files.  - `false` - Do not use the transcoder's estimate of the duration.
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: JobType.
                 If the method is called asynchronously, returns the request thread.
        :rtype: JobType or multiprocessing.pool.AsyncResult
        """
        kwargs['_return_http_data_only'] = True
        return self.import_item_with_http_info(uri, metadata_type, **kwargs)  # noqa: E501

    def import_item_with_http_info(self, uri, metadata_type, **kwargs):  # noqa: E501
        """Import using a URI  # noqa: E501

        Starts a job that imports the file, located at the given URI, and creates an item. Note that thumbnails and poster frames are only generated if a transcode takes place.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.import_item_with_http_info(uri, metadata_type, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str uri: A URI to the file that will be imported.  Make sure to percent encode the URI. (required)
        :param MetadataType metadata_type: <em>MetadataDocument</em>, initial metadata that is given to the imported item. (required)
        :key bool no_transcode: - `true` - Will disable transcoding even if the `tags` parameter is set.  Rather, the specified tag will be used to determine cropping, scaling etc.  of thumbnails.  - `false` (default) - Normal transcode.
        :key str url: A URL to the file that will be imported.  (Deprecated since 4. 2. )
        :key str fast_start_length: Estimated duration of the clip in seconds.
        :key bool create_thumbnails: - `true` (default) - Generate thumbnails as per defined by shape tag.  - `false` - Disable thumbnail generation.
        :key str xmpfile: URI to a sidecar XMP metadata file.
        :key str create_posters: A list of time codes to use for creating posters.
        :key list[str] jobmetadata: Additional information for the job task.
        :key str notification_data: Any additional data to include for notifications on this job.
        :key str storage_id: Identifier of storage where essence file is to be stored.
        :key bool require_fast_start: - `true` (default) - Try to put the index tables (header) in front of the file.  - `false` - Put header at end of file.
        :key bool growing: - `true` - Specifies that the input file is still written to, so enables growing file support.  - `false` (default) - No growing file handling of import file.
        :key list[str] tag: A list of shape tags to use for transcoding.
        :key str resource_id: The transcoder resource to use to execute the transcode.
        :key str thumbnail_service: Identifies which thumbnail resource that should be used.
        :key str settings: Pre-configured import settings.
        :key str notification: The placeholder job notification to use for this job.
        :key list[str] import_tag: A list of shape tags that the created shape will be associated with.
        :key str sidecar: URIs or file ids of any sidecar files to import to the item.
        :key str original: If specified, should be one of the tags specified in the tag parameter.  Specifies that the original shape tag will be reset to the shape created to this tag.
        :key str priority: The priority to assign to the job.
        :key bool override_fast_start: - `true` (default) - Use transcoder's estimate of the duration for allocating header space in MOV files and similar files.  - `false` - Do not use the transcoder's estimate of the duration.
        :key _return_http_data_only: response data without head status code
                                       and headers
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(JobType, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['uri', 'metadata_type', 'no_transcode', 'url', 'fast_start_length', 'create_thumbnails', 'xmpfile', 'create_posters', 'jobmetadata', 'notification_data', 'storage_id', 'require_fast_start', 'growing', 'tag', 'resource_id', 'thumbnail_service', 'settings', 'notification', 'import_tag', 'sidecar', 'original', 'priority', 'override_fast_start']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method import_item" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'uri' is set
        if ('uri' not in local_var_params or
                local_var_params['uri'] is None):
            raise ApiValueError("Missing the required parameter `uri` when calling `import_item`")  # noqa: E501
        # verify the required parameter 'metadata_type' is set
        if ('metadata_type' not in local_var_params or
                local_var_params['metadata_type'] is None):
            raise ApiValueError("Missing the required parameter `metadata_type` when calling `import_item`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'uri' in local_var_params:
            query_params.append(('uri', local_var_params['uri']))  # noqa: E501
        if 'no_transcode' in local_var_params:
            query_params.append(('no-transcode', local_var_params['no_transcode']))  # noqa: E501
        if 'url' in local_var_params:
            query_params.append(('URL', local_var_params['url']))  # noqa: E501
        if 'fast_start_length' in local_var_params:
            query_params.append(('fastStartLength', local_var_params['fast_start_length']))  # noqa: E501
        if 'create_thumbnails' in local_var_params:
            query_params.append(('createThumbnails', local_var_params['create_thumbnails']))  # noqa: E501
        if 'xmpfile' in local_var_params:
            query_params.append(('xmpfile', local_var_params['xmpfile']))  # noqa: E501
        if 'create_posters' in local_var_params:
            query_params.append(('createPosters', local_var_params['create_posters']))  # noqa: E501
        if 'jobmetadata' in local_var_params:
            query_params.append(('jobmetadata', local_var_params['jobmetadata']))  # noqa: E501
            collection_formats['jobmetadata'] = 'multi'  # noqa: E501
        if 'notification_data' in local_var_params:
            query_params.append(('notificationData', local_var_params['notification_data']))  # noqa: E501
        if 'storage_id' in local_var_params:
            query_params.append(('storageId', local_var_params['storage_id']))  # noqa: E501
        if 'require_fast_start' in local_var_params:
            query_params.append(('requireFastStart', local_var_params['require_fast_start']))  # noqa: E501
        if 'growing' in local_var_params:
            query_params.append(('growing', local_var_params['growing']))  # noqa: E501
        if 'tag' in local_var_params:
            query_params.append(('tag', local_var_params['tag']))  # noqa: E501
            collection_formats['tag'] = 'multi'  # noqa: E501
        if 'resource_id' in local_var_params:
            query_params.append(('resourceId', local_var_params['resource_id']))  # noqa: E501
        if 'thumbnail_service' in local_var_params:
            query_params.append(('thumbnailService', local_var_params['thumbnail_service']))  # noqa: E501
        if 'settings' in local_var_params:
            query_params.append(('settings', local_var_params['settings']))  # noqa: E501
        if 'notification' in local_var_params:
            query_params.append(('notification', local_var_params['notification']))  # noqa: E501
        if 'import_tag' in local_var_params:
            query_params.append(('importTag', local_var_params['import_tag']))  # noqa: E501
            collection_formats['importTag'] = 'multi'  # noqa: E501
        if 'sidecar' in local_var_params:
            query_params.append(('sidecar', local_var_params['sidecar']))  # noqa: E501
        if 'original' in local_var_params:
            query_params.append(('original', local_var_params['original']))  # noqa: E501
        if 'priority' in local_var_params:
            query_params.append(('priority', local_var_params['priority']))  # noqa: E501
        if 'override_fast_start' in local_var_params:
            query_params.append(('overrideFastStart', local_var_params['override_fast_start']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'metadata_type' in local_var_params:
            body_params = local_var_params['metadata_type']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'application/xml'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'application/xml'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/import', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='JobType',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def import_item_raw(self, body, **kwargs):  # noqa: E501
        """Import using the request body  # noqa: E501

        Starts a job that reads the raw data from the request body, generates a file, and imports the file.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.import_item_raw(body, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param file body: The raw data. (required)
        :key str resource_id: The transcoder resource to use to execute the transcode.
        :key list[str] jobmetadata: Additional information for the job task.
        :key str notification_data: Any additional data to include for notifications on this job.
        :key int transfer_priority: An integer between 1 and 1000 that indicates what priority the transfer should be given in relation to other transfers.  A transfer with a high priority value is considered more important than a transfer with a low priority value.
        :key str thumbnail_service: Identifies which thumbnail resource that should be used.
        :key str storage_id: Identifier of storage where essence file is to be stored.
        :key str settings: Pre-configured import settings.
        :key bool require_fast_start: - `true` (default) - Try to put the index tables (header) in front of the file.  - `false` - Put header at end of file.
        :key list[str] ids: Comma-separated list of external ids to assign to the item.
        :key str fast_start_length: Estimated duration of the clip in seconds.
        :key list[str] import_tag: A list of shape tags that the created shape will be associated with.
        :key str priority: The priority to assign to the job.
        :key list[str] tag: A list of shape tags to use for transcoding.
        :key bool create_thumbnails: - `true` (default) - Generate thumbnails as per defined by shape tag.  - `false` - Disable thumbnail generation.
        :key str original: If specified, should be one of the tags specified in the tag parameter.  Specifies that the original shape tag will be reset to the shape created to this tag.
        :key str create_posters: A list of time codes to use for creating posters.
        :key bool override_fast_start: - `true` (default) - Use transcoder's estimate of the duration for allocating header space in MOV files and similar files.  - `false` - Do not use the transcoder's estimate of the duration.
        :key str notification: The placeholder job notification to use for this job.
        :key str filename: The filename to be stored as original filename
        :key str transfer_id: An id to assign the transfer to be able to refer to it.
        :key bool no_transcode: - `true` - Will disable transcoding even if the `tags` parameter is set.  Rather, the specified tag will be used to determine cropping, scaling etc.  of thumbnails.  - `false` (default) - Normal transcode.
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: JobType.
                 If the method is called asynchronously, returns the request thread.
        :rtype: JobType or multiprocessing.pool.AsyncResult
        """
        kwargs['_return_http_data_only'] = True
        return self.import_item_raw_with_http_info(body, **kwargs)  # noqa: E501

    def import_item_raw_with_http_info(self, body, **kwargs):  # noqa: E501
        """Import using the request body  # noqa: E501

        Starts a job that reads the raw data from the request body, generates a file, and imports the file.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.import_item_raw_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param file body: The raw data. (required)
        :key str resource_id: The transcoder resource to use to execute the transcode.
        :key list[str] jobmetadata: Additional information for the job task.
        :key str notification_data: Any additional data to include for notifications on this job.
        :key int transfer_priority: An integer between 1 and 1000 that indicates what priority the transfer should be given in relation to other transfers.  A transfer with a high priority value is considered more important than a transfer with a low priority value.
        :key str thumbnail_service: Identifies which thumbnail resource that should be used.
        :key str storage_id: Identifier of storage where essence file is to be stored.
        :key str settings: Pre-configured import settings.
        :key bool require_fast_start: - `true` (default) - Try to put the index tables (header) in front of the file.  - `false` - Put header at end of file.
        :key list[str] ids: Comma-separated list of external ids to assign to the item.
        :key str fast_start_length: Estimated duration of the clip in seconds.
        :key list[str] import_tag: A list of shape tags that the created shape will be associated with.
        :key str priority: The priority to assign to the job.
        :key list[str] tag: A list of shape tags to use for transcoding.
        :key bool create_thumbnails: - `true` (default) - Generate thumbnails as per defined by shape tag.  - `false` - Disable thumbnail generation.
        :key str original: If specified, should be one of the tags specified in the tag parameter.  Specifies that the original shape tag will be reset to the shape created to this tag.
        :key str create_posters: A list of time codes to use for creating posters.
        :key bool override_fast_start: - `true` (default) - Use transcoder's estimate of the duration for allocating header space in MOV files and similar files.  - `false` - Do not use the transcoder's estimate of the duration.
        :key str notification: The placeholder job notification to use for this job.
        :key str filename: The filename to be stored as original filename
        :key str transfer_id: An id to assign the transfer to be able to refer to it.
        :key bool no_transcode: - `true` - Will disable transcoding even if the `tags` parameter is set.  Rather, the specified tag will be used to determine cropping, scaling etc.  of thumbnails.  - `false` (default) - Normal transcode.
        :key _return_http_data_only: response data without head status code
                                       and headers
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(JobType, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['body', 'resource_id', 'jobmetadata', 'notification_data', 'transfer_priority', 'thumbnail_service', 'storage_id', 'settings', 'require_fast_start', 'ids', 'fast_start_length', 'import_tag', 'priority', 'tag', 'create_thumbnails', 'original', 'create_posters', 'override_fast_start', 'notification', 'filename', 'transfer_id', 'no_transcode']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method import_item_raw" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in local_var_params or
                local_var_params['body'] is None):
            raise ApiValueError("Missing the required parameter `body` when calling `import_item_raw`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'resource_id' in local_var_params:
            query_params.append(('resourceId', local_var_params['resource_id']))  # noqa: E501
        if 'jobmetadata' in local_var_params:
            query_params.append(('jobmetadata', local_var_params['jobmetadata']))  # noqa: E501
            collection_formats['jobmetadata'] = 'multi'  # noqa: E501
        if 'notification_data' in local_var_params:
            query_params.append(('notificationData', local_var_params['notification_data']))  # noqa: E501
        if 'transfer_priority' in local_var_params:
            query_params.append(('transferPriority', local_var_params['transfer_priority']))  # noqa: E501
        if 'thumbnail_service' in local_var_params:
            query_params.append(('thumbnailService', local_var_params['thumbnail_service']))  # noqa: E501
        if 'storage_id' in local_var_params:
            query_params.append(('storageId', local_var_params['storage_id']))  # noqa: E501
        if 'settings' in local_var_params:
            query_params.append(('settings', local_var_params['settings']))  # noqa: E501
        if 'require_fast_start' in local_var_params:
            query_params.append(('requireFastStart', local_var_params['require_fast_start']))  # noqa: E501
        if 'ids' in local_var_params:
            query_params.append(('ids', local_var_params['ids']))  # noqa: E501
            collection_formats['ids'] = 'csv'  # noqa: E501
        if 'fast_start_length' in local_var_params:
            query_params.append(('fastStartLength', local_var_params['fast_start_length']))  # noqa: E501
        if 'import_tag' in local_var_params:
            query_params.append(('importTag', local_var_params['import_tag']))  # noqa: E501
            collection_formats['importTag'] = 'multi'  # noqa: E501
        if 'priority' in local_var_params:
            query_params.append(('priority', local_var_params['priority']))  # noqa: E501
        if 'tag' in local_var_params:
            query_params.append(('tag', local_var_params['tag']))  # noqa: E501
            collection_formats['tag'] = 'multi'  # noqa: E501
        if 'create_thumbnails' in local_var_params:
            query_params.append(('createThumbnails', local_var_params['create_thumbnails']))  # noqa: E501
        if 'original' in local_var_params:
            query_params.append(('original', local_var_params['original']))  # noqa: E501
        if 'create_posters' in local_var_params:
            query_params.append(('createPosters', local_var_params['create_posters']))  # noqa: E501
        if 'override_fast_start' in local_var_params:
            query_params.append(('overrideFastStart', local_var_params['override_fast_start']))  # noqa: E501
        if 'notification' in local_var_params:
            query_params.append(('notification', local_var_params['notification']))  # noqa: E501
        if 'filename' in local_var_params:
            query_params.append(('filename', local_var_params['filename']))  # noqa: E501
        if 'transfer_id' in local_var_params:
            query_params.append(('transferId', local_var_params['transfer_id']))  # noqa: E501
        if 'no_transcode' in local_var_params:
            query_params.append(('no-transcode', local_var_params['no_transcode']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in local_var_params:
            body_params = local_var_params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'application/xml'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/octet-stream'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/import/raw', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='JobType',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def import_item_raw_passkey(self, transfer_id, metadata_type, **kwargs):  # noqa: E501
        """Import using a passkey  # noqa: E501

        Create a job and generates a passkey that can later be used to import an item without being authenticated.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.import_item_raw_passkey(transfer_id, metadata_type, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str transfer_id: An id to assign the transfer to be able to refer to it. (required)
        :param MetadataType metadata_type: <em>MetadataDocument</em>, initial metadata that is given to the imported item. (required)
        :key str resource_id: The transcoder resource to use to execute the transcode.
        :key list[str] jobmetadata: Additional information for the job task.
        :key str notification_data: Any additional data to include for notifications on this job.
        :key int transfer_priority: An integer between 1 and 1000 that indicates what priority the transfer should be given in relation to other transfers.  A transfer with a high priority value is considered more important than a transfer with a low priority value.
        :key str thumbnail_service: Identifies which thumbnail resource that should be used.
        :key str storage_id: Identifier of storage where essence file is to be stored.
        :key str settings: Pre-configured import settings.
        :key bool require_fast_start: - `true` (default) - Try to put the index tables (header) in front of the file.  - `false` - Put header at end of file.
        :key list[str] ids: Comma-separated list of external ids to assign to the item.
        :key str fast_start_length: Estimated duration of the clip in seconds.
        :key list[str] import_tag: A list of shape tags that the created shape will be associated with.
        :key str priority: The priority to assign to the job.
        :key list[str] tag: A list of shape tags to use for transcoding.
        :key bool create_thumbnails: - `true` (default) - Generate thumbnails as per defined by shape tag.  - `false` - Disable thumbnail generation.
        :key str original: If specified, should be one of the tags specified in the tag parameter.  Specifies that the original shape tag will be reset to the shape created to this tag.
        :key str create_posters: A list of time codes to use for creating posters.
        :key bool override_fast_start: - `true` (default) - Use transcoder's estimate of the duration for allocating header space in MOV files and similar files.  - `false` - Do not use the transcoder's estimate of the duration.
        :key str notification: The placeholder job notification to use for this job.
        :key str filename: The filename to be stored as original filename
        :key bool no_transcode: - `true` - Will disable transcoding even if the `tags` parameter is set.  Rather, the specified tag will be used to determine cropping, scaling etc.  of thumbnails.  - `false` (default) - Normal transcode.
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: JobType.
                 If the method is called asynchronously, returns the request thread.
        :rtype: JobType or multiprocessing.pool.AsyncResult
        """
        kwargs['_return_http_data_only'] = True
        return self.import_item_raw_passkey_with_http_info(transfer_id, metadata_type, **kwargs)  # noqa: E501

    def import_item_raw_passkey_with_http_info(self, transfer_id, metadata_type, **kwargs):  # noqa: E501
        """Import using a passkey  # noqa: E501

        Create a job and generates a passkey that can later be used to import an item without being authenticated.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.import_item_raw_passkey_with_http_info(transfer_id, metadata_type, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str transfer_id: An id to assign the transfer to be able to refer to it. (required)
        :param MetadataType metadata_type: <em>MetadataDocument</em>, initial metadata that is given to the imported item. (required)
        :key str resource_id: The transcoder resource to use to execute the transcode.
        :key list[str] jobmetadata: Additional information for the job task.
        :key str notification_data: Any additional data to include for notifications on this job.
        :key int transfer_priority: An integer between 1 and 1000 that indicates what priority the transfer should be given in relation to other transfers.  A transfer with a high priority value is considered more important than a transfer with a low priority value.
        :key str thumbnail_service: Identifies which thumbnail resource that should be used.
        :key str storage_id: Identifier of storage where essence file is to be stored.
        :key str settings: Pre-configured import settings.
        :key bool require_fast_start: - `true` (default) - Try to put the index tables (header) in front of the file.  - `false` - Put header at end of file.
        :key list[str] ids: Comma-separated list of external ids to assign to the item.
        :key str fast_start_length: Estimated duration of the clip in seconds.
        :key list[str] import_tag: A list of shape tags that the created shape will be associated with.
        :key str priority: The priority to assign to the job.
        :key list[str] tag: A list of shape tags to use for transcoding.
        :key bool create_thumbnails: - `true` (default) - Generate thumbnails as per defined by shape tag.  - `false` - Disable thumbnail generation.
        :key str original: If specified, should be one of the tags specified in the tag parameter.  Specifies that the original shape tag will be reset to the shape created to this tag.
        :key str create_posters: A list of time codes to use for creating posters.
        :key bool override_fast_start: - `true` (default) - Use transcoder's estimate of the duration for allocating header space in MOV files and similar files.  - `false` - Do not use the transcoder's estimate of the duration.
        :key str notification: The placeholder job notification to use for this job.
        :key str filename: The filename to be stored as original filename
        :key bool no_transcode: - `true` - Will disable transcoding even if the `tags` parameter is set.  Rather, the specified tag will be used to determine cropping, scaling etc.  of thumbnails.  - `false` (default) - Normal transcode.
        :key _return_http_data_only: response data without head status code
                                       and headers
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(JobType, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['transfer_id', 'metadata_type', 'resource_id', 'jobmetadata', 'notification_data', 'transfer_priority', 'thumbnail_service', 'storage_id', 'settings', 'require_fast_start', 'ids', 'fast_start_length', 'import_tag', 'priority', 'tag', 'create_thumbnails', 'original', 'create_posters', 'override_fast_start', 'notification', 'filename', 'no_transcode']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method import_item_raw_passkey" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'transfer_id' is set
        if ('transfer_id' not in local_var_params or
                local_var_params['transfer_id'] is None):
            raise ApiValueError("Missing the required parameter `transfer_id` when calling `import_item_raw_passkey`")  # noqa: E501
        # verify the required parameter 'metadata_type' is set
        if ('metadata_type' not in local_var_params or
                local_var_params['metadata_type'] is None):
            raise ApiValueError("Missing the required parameter `metadata_type` when calling `import_item_raw_passkey`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'resource_id' in local_var_params:
            query_params.append(('resourceId', local_var_params['resource_id']))  # noqa: E501
        if 'jobmetadata' in local_var_params:
            query_params.append(('jobmetadata', local_var_params['jobmetadata']))  # noqa: E501
            collection_formats['jobmetadata'] = 'multi'  # noqa: E501
        if 'notification_data' in local_var_params:
            query_params.append(('notificationData', local_var_params['notification_data']))  # noqa: E501
        if 'transfer_priority' in local_var_params:
            query_params.append(('transferPriority', local_var_params['transfer_priority']))  # noqa: E501
        if 'thumbnail_service' in local_var_params:
            query_params.append(('thumbnailService', local_var_params['thumbnail_service']))  # noqa: E501
        if 'storage_id' in local_var_params:
            query_params.append(('storageId', local_var_params['storage_id']))  # noqa: E501
        if 'settings' in local_var_params:
            query_params.append(('settings', local_var_params['settings']))  # noqa: E501
        if 'require_fast_start' in local_var_params:
            query_params.append(('requireFastStart', local_var_params['require_fast_start']))  # noqa: E501
        if 'ids' in local_var_params:
            query_params.append(('ids', local_var_params['ids']))  # noqa: E501
            collection_formats['ids'] = 'csv'  # noqa: E501
        if 'fast_start_length' in local_var_params:
            query_params.append(('fastStartLength', local_var_params['fast_start_length']))  # noqa: E501
        if 'import_tag' in local_var_params:
            query_params.append(('importTag', local_var_params['import_tag']))  # noqa: E501
            collection_formats['importTag'] = 'multi'  # noqa: E501
        if 'priority' in local_var_params:
            query_params.append(('priority', local_var_params['priority']))  # noqa: E501
        if 'tag' in local_var_params:
            query_params.append(('tag', local_var_params['tag']))  # noqa: E501
            collection_formats['tag'] = 'multi'  # noqa: E501
        if 'create_thumbnails' in local_var_params:
            query_params.append(('createThumbnails', local_var_params['create_thumbnails']))  # noqa: E501
        if 'original' in local_var_params:
            query_params.append(('original', local_var_params['original']))  # noqa: E501
        if 'create_posters' in local_var_params:
            query_params.append(('createPosters', local_var_params['create_posters']))  # noqa: E501
        if 'override_fast_start' in local_var_params:
            query_params.append(('overrideFastStart', local_var_params['override_fast_start']))  # noqa: E501
        if 'notification' in local_var_params:
            query_params.append(('notification', local_var_params['notification']))  # noqa: E501
        if 'filename' in local_var_params:
            query_params.append(('filename', local_var_params['filename']))  # noqa: E501
        if 'transfer_id' in local_var_params:
            query_params.append(('transferId', local_var_params['transfer_id']))  # noqa: E501
        if 'no_transcode' in local_var_params:
            query_params.append(('no-transcode', local_var_params['no_transcode']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'metadata_type' in local_var_params:
            body_params = local_var_params['metadata_type']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'application/xml'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'application/xml'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/import/raw-passkey', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='JobType',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def import_placeholder_bulk(self, item_id, placeholder_import_request_type, **kwargs):  # noqa: E501
        """Import to a placeholder item in bulk  # noqa: E501

        Imports the files and extracts component data based on what type is specified (container, audio, video, binary). No transcoding will take place until all files have been imported.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.import_placeholder_bulk(item_id, placeholder_import_request_type, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str item_id: The item id. (required)
        :param PlaceholderImportRequestType placeholder_import_request_type: A <em>PlaceholderImportRequestDocument</em> describing the files to import. (required)
        :key list[str] jobmetadata: Additional information for the job task.
        :key str notification_data: Any additional data to include for notifications on this job.
        :key list[str] tag: A list of shape tags to use for transcoding.
        :key str storage_id: Identifier of storage where essence file is to be stored.
        :key int index: The component index (track) of new component.
        :key bool require_fast_start: - `true` (default) - Try to put the index tables (header) in front of the file.  - `false` - Put header at end of file.
        :key str notification: The placeholder job notification to use for this job.
        :key str fast_start_length: Estimated duration of the clip in seconds.
        :key list[str] import_tag: A list of shape tags that the created shape will be associated with.
        :key str settings: Pre-configured import settings.
        :key str original: If specified, should be one of the tags specified in the tag parameter.  Specifies that the original shape tag will be reset to the shape created to this tag.
        :key bool growing: - `true` - Specifies that the input file is still written to, so enables growing file support.  - `false` (default) - No growing file handling of import file.
        :key bool override_fast_start: - `true` (default) - Use transcoder's estimate of the duration for allocating header space in MOV files and similar files.  - `false` - Do not use the transcoder's estimate of the duration.
        :key str resource_id: The transcoder resource to use to execute the transcode.
        :key str shape_id: Shape id for which shape to receive the content.
        :key str priority: The priority to assign to the job.
        :key bool no_transcode: - `true` - Will disable transcoding even if the `tags` parameter is set.  Rather, the specified tag will be used to determine cropping, scaling etc.  of thumbnails.  - `false` (default) - Normal transcode.
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: JobType.
                 If the method is called asynchronously, returns the request thread.
        :rtype: JobType or multiprocessing.pool.AsyncResult
        """
        kwargs['_return_http_data_only'] = True
        return self.import_placeholder_bulk_with_http_info(item_id, placeholder_import_request_type, **kwargs)  # noqa: E501

    def import_placeholder_bulk_with_http_info(self, item_id, placeholder_import_request_type, **kwargs):  # noqa: E501
        """Import to a placeholder item in bulk  # noqa: E501

        Imports the files and extracts component data based on what type is specified (container, audio, video, binary). No transcoding will take place until all files have been imported.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.import_placeholder_bulk_with_http_info(item_id, placeholder_import_request_type, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str item_id: The item id. (required)
        :param PlaceholderImportRequestType placeholder_import_request_type: A <em>PlaceholderImportRequestDocument</em> describing the files to import. (required)
        :key list[str] jobmetadata: Additional information for the job task.
        :key str notification_data: Any additional data to include for notifications on this job.
        :key list[str] tag: A list of shape tags to use for transcoding.
        :key str storage_id: Identifier of storage where essence file is to be stored.
        :key int index: The component index (track) of new component.
        :key bool require_fast_start: - `true` (default) - Try to put the index tables (header) in front of the file.  - `false` - Put header at end of file.
        :key str notification: The placeholder job notification to use for this job.
        :key str fast_start_length: Estimated duration of the clip in seconds.
        :key list[str] import_tag: A list of shape tags that the created shape will be associated with.
        :key str settings: Pre-configured import settings.
        :key str original: If specified, should be one of the tags specified in the tag parameter.  Specifies that the original shape tag will be reset to the shape created to this tag.
        :key bool growing: - `true` - Specifies that the input file is still written to, so enables growing file support.  - `false` (default) - No growing file handling of import file.
        :key bool override_fast_start: - `true` (default) - Use transcoder's estimate of the duration for allocating header space in MOV files and similar files.  - `false` - Do not use the transcoder's estimate of the duration.
        :key str resource_id: The transcoder resource to use to execute the transcode.
        :key str shape_id: Shape id for which shape to receive the content.
        :key str priority: The priority to assign to the job.
        :key bool no_transcode: - `true` - Will disable transcoding even if the `tags` parameter is set.  Rather, the specified tag will be used to determine cropping, scaling etc.  of thumbnails.  - `false` (default) - Normal transcode.
        :key _return_http_data_only: response data without head status code
                                       and headers
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(JobType, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['item_id', 'placeholder_import_request_type', 'jobmetadata', 'notification_data', 'tag', 'storage_id', 'index', 'require_fast_start', 'notification', 'fast_start_length', 'import_tag', 'settings', 'original', 'growing', 'override_fast_start', 'resource_id', 'shape_id', 'priority', 'no_transcode']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method import_placeholder_bulk" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'item_id' is set
        if ('item_id' not in local_var_params or
                local_var_params['item_id'] is None):
            raise ApiValueError("Missing the required parameter `item_id` when calling `import_placeholder_bulk`")  # noqa: E501
        # verify the required parameter 'placeholder_import_request_type' is set
        if ('placeholder_import_request_type' not in local_var_params or
                local_var_params['placeholder_import_request_type'] is None):
            raise ApiValueError("Missing the required parameter `placeholder_import_request_type` when calling `import_placeholder_bulk`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'item_id' in local_var_params:
            path_params['item-id'] = local_var_params['item_id']  # noqa: E501

        query_params = []
        if 'jobmetadata' in local_var_params:
            query_params.append(('jobmetadata', local_var_params['jobmetadata']))  # noqa: E501
            collection_formats['jobmetadata'] = 'multi'  # noqa: E501
        if 'notification_data' in local_var_params:
            query_params.append(('notificationData', local_var_params['notification_data']))  # noqa: E501
        if 'tag' in local_var_params:
            query_params.append(('tag', local_var_params['tag']))  # noqa: E501
            collection_formats['tag'] = 'multi'  # noqa: E501
        if 'storage_id' in local_var_params:
            query_params.append(('storageId', local_var_params['storage_id']))  # noqa: E501
        if 'index' in local_var_params:
            query_params.append(('index', local_var_params['index']))  # noqa: E501
        if 'require_fast_start' in local_var_params:
            query_params.append(('requireFastStart', local_var_params['require_fast_start']))  # noqa: E501
        if 'notification' in local_var_params:
            query_params.append(('notification', local_var_params['notification']))  # noqa: E501
        if 'fast_start_length' in local_var_params:
            query_params.append(('fastStartLength', local_var_params['fast_start_length']))  # noqa: E501
        if 'import_tag' in local_var_params:
            query_params.append(('importTag', local_var_params['import_tag']))  # noqa: E501
            collection_formats['importTag'] = 'multi'  # noqa: E501
        if 'settings' in local_var_params:
            query_params.append(('settings', local_var_params['settings']))  # noqa: E501
        if 'original' in local_var_params:
            query_params.append(('original', local_var_params['original']))  # noqa: E501
        if 'growing' in local_var_params:
            query_params.append(('growing', local_var_params['growing']))  # noqa: E501
        if 'override_fast_start' in local_var_params:
            query_params.append(('overrideFastStart', local_var_params['override_fast_start']))  # noqa: E501
        if 'resource_id' in local_var_params:
            query_params.append(('resourceId', local_var_params['resource_id']))  # noqa: E501
        if 'shape_id' in local_var_params:
            query_params.append(('shapeId', local_var_params['shape_id']))  # noqa: E501
        if 'priority' in local_var_params:
            query_params.append(('priority', local_var_params['priority']))  # noqa: E501
        if 'no_transcode' in local_var_params:
            query_params.append(('no-transcode', local_var_params['no_transcode']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'placeholder_import_request_type' in local_var_params:
            body_params = local_var_params['placeholder_import_request_type']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'application/xml'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'application/xml'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/import/placeholder/{item-id}', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='JobType',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def import_placeholder_raw(self, item_id, body, **kwargs):  # noqa: E501
        """Import to a placeholder item using the request body  # noqa: E501

        Imports the file and extracts component data based on what type is specified (container, audio, video, binary). No transcoding will take place until all files have been imported.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.import_placeholder_raw(item_id, body, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str item_id: The item id. (required)
        :param file body: The raw data. (required)
        :key str resource_id: The transcoder resource to use to execute the transcode.
        :key list[str] jobmetadata: Additional information for the job task.
        :key str notification_data: Any additional data to include for notifications on this job.
        :key str thumbnail_service: Identifies which thumbnail resource that should be used.
        :key list[str] tag: A list of shape tags to use for transcoding.
        :key int transfer_priority: An integer between 1 and 1000 that indicates what priority the transfer should be given in relation to other transfers.  A transfer with a high priority value is considered more important than a transfer with a low priority value.
        :key int index: Index (order) of the component.
        :key bool require_fast_start: - `true` (default) - Try to put the index tables (header) in front of the file.  - `false` - Put header at end of file.
        :key str notification: The placeholder job notification to use for this job.
        :key str fast_start_length: Estimated duration of the clip in seconds.
        :key str priority: The priority to assign to the job.
        :key str storage_id: Identifier of storage where essence file is to be stored.
        :key bool create_thumbnails: - `true` (default) - Generate thumbnails as per defined by shape tag.  - `false` - Disable thumbnail generation.
        :key str create_posters: A list of time codes to use for creating posters.
        :key bool override_fast_start: - `true` (default) - Use transcoder's estimate of the duration for allocating header space in MOV files and similar files.  - `false` - Do not use the transcoder's estimate of the duration.
        :key str original: If specified, should be one of the tags specified in the tag parameter.  Specifies that the original shape tag will be reset to the shape created to this tag.
        :key str shape_id: Shape id for which shape to receive the content.
        :key str filename: The filename to be stored as original filename
        :key str transfer_id: An id to assign the transfer to be able to refer to it.
        :key bool no_transcode: - `true` - Will disable transcoding even if the `tags` parameter is set.  Rather, the specified tag will be used to determine cropping, scaling etc.  of thumbnails.  - `false` (default) - Normal transcode.
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: JobType.
                 If the method is called asynchronously, returns the request thread.
        :rtype: JobType or multiprocessing.pool.AsyncResult
        """
        kwargs['_return_http_data_only'] = True
        return self.import_placeholder_raw_with_http_info(item_id, body, **kwargs)  # noqa: E501

    def import_placeholder_raw_with_http_info(self, item_id, body, **kwargs):  # noqa: E501
        """Import to a placeholder item using the request body  # noqa: E501

        Imports the file and extracts component data based on what type is specified (container, audio, video, binary). No transcoding will take place until all files have been imported.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.import_placeholder_raw_with_http_info(item_id, body, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str item_id: The item id. (required)
        :param file body: The raw data. (required)
        :key str resource_id: The transcoder resource to use to execute the transcode.
        :key list[str] jobmetadata: Additional information for the job task.
        :key str notification_data: Any additional data to include for notifications on this job.
        :key str thumbnail_service: Identifies which thumbnail resource that should be used.
        :key list[str] tag: A list of shape tags to use for transcoding.
        :key int transfer_priority: An integer between 1 and 1000 that indicates what priority the transfer should be given in relation to other transfers.  A transfer with a high priority value is considered more important than a transfer with a low priority value.
        :key int index: Index (order) of the component.
        :key bool require_fast_start: - `true` (default) - Try to put the index tables (header) in front of the file.  - `false` - Put header at end of file.
        :key str notification: The placeholder job notification to use for this job.
        :key str fast_start_length: Estimated duration of the clip in seconds.
        :key str priority: The priority to assign to the job.
        :key str storage_id: Identifier of storage where essence file is to be stored.
        :key bool create_thumbnails: - `true` (default) - Generate thumbnails as per defined by shape tag.  - `false` - Disable thumbnail generation.
        :key str create_posters: A list of time codes to use for creating posters.
        :key bool override_fast_start: - `true` (default) - Use transcoder's estimate of the duration for allocating header space in MOV files and similar files.  - `false` - Do not use the transcoder's estimate of the duration.
        :key str original: If specified, should be one of the tags specified in the tag parameter.  Specifies that the original shape tag will be reset to the shape created to this tag.
        :key str shape_id: Shape id for which shape to receive the content.
        :key str filename: The filename to be stored as original filename
        :key str transfer_id: An id to assign the transfer to be able to refer to it.
        :key bool no_transcode: - `true` - Will disable transcoding even if the `tags` parameter is set.  Rather, the specified tag will be used to determine cropping, scaling etc.  of thumbnails.  - `false` (default) - Normal transcode.
        :key _return_http_data_only: response data without head status code
                                       and headers
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(JobType, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['item_id', 'body', 'resource_id', 'jobmetadata', 'notification_data', 'thumbnail_service', 'tag', 'transfer_priority', 'index', 'require_fast_start', 'notification', 'fast_start_length', 'priority', 'storage_id', 'create_thumbnails', 'create_posters', 'override_fast_start', 'original', 'shape_id', 'filename', 'transfer_id', 'no_transcode']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method import_placeholder_raw" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'item_id' is set
        if ('item_id' not in local_var_params or
                local_var_params['item_id'] is None):
            raise ApiValueError("Missing the required parameter `item_id` when calling `import_placeholder_raw`")  # noqa: E501
        # verify the required parameter 'body' is set
        if ('body' not in local_var_params or
                local_var_params['body'] is None):
            raise ApiValueError("Missing the required parameter `body` when calling `import_placeholder_raw`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'item_id' in local_var_params:
            path_params['item-id'] = local_var_params['item_id']  # noqa: E501

        query_params = []
        if 'resource_id' in local_var_params:
            query_params.append(('resourceId', local_var_params['resource_id']))  # noqa: E501
        if 'jobmetadata' in local_var_params:
            query_params.append(('jobmetadata', local_var_params['jobmetadata']))  # noqa: E501
            collection_formats['jobmetadata'] = 'multi'  # noqa: E501
        if 'notification_data' in local_var_params:
            query_params.append(('notificationData', local_var_params['notification_data']))  # noqa: E501
        if 'thumbnail_service' in local_var_params:
            query_params.append(('thumbnailService', local_var_params['thumbnail_service']))  # noqa: E501
        if 'tag' in local_var_params:
            query_params.append(('tag', local_var_params['tag']))  # noqa: E501
            collection_formats['tag'] = 'multi'  # noqa: E501
        if 'transfer_priority' in local_var_params:
            query_params.append(('transferPriority', local_var_params['transfer_priority']))  # noqa: E501
        if 'index' in local_var_params:
            query_params.append(('index', local_var_params['index']))  # noqa: E501
        if 'require_fast_start' in local_var_params:
            query_params.append(('requireFastStart', local_var_params['require_fast_start']))  # noqa: E501
        if 'notification' in local_var_params:
            query_params.append(('notification', local_var_params['notification']))  # noqa: E501
        if 'fast_start_length' in local_var_params:
            query_params.append(('fastStartLength', local_var_params['fast_start_length']))  # noqa: E501
        if 'priority' in local_var_params:
            query_params.append(('priority', local_var_params['priority']))  # noqa: E501
        if 'storage_id' in local_var_params:
            query_params.append(('storageId', local_var_params['storage_id']))  # noqa: E501
        if 'create_thumbnails' in local_var_params:
            query_params.append(('createThumbnails', local_var_params['create_thumbnails']))  # noqa: E501
        if 'create_posters' in local_var_params:
            query_params.append(('createPosters', local_var_params['create_posters']))  # noqa: E501
        if 'override_fast_start' in local_var_params:
            query_params.append(('overrideFastStart', local_var_params['override_fast_start']))  # noqa: E501
        if 'original' in local_var_params:
            query_params.append(('original', local_var_params['original']))  # noqa: E501
        if 'shape_id' in local_var_params:
            query_params.append(('shapeId', local_var_params['shape_id']))  # noqa: E501
        if 'filename' in local_var_params:
            query_params.append(('filename', local_var_params['filename']))  # noqa: E501
        if 'transfer_id' in local_var_params:
            query_params.append(('transferId', local_var_params['transfer_id']))  # noqa: E501
        if 'no_transcode' in local_var_params:
            query_params.append(('no-transcode', local_var_params['no_transcode']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in local_var_params:
            body_params = local_var_params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'application/xml'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/octet-stream'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/import/placeholder/{item-id}/[container,audio,video,binary]/raw', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='JobType',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def import_project(self, essence_mappings_type, **kwargs):  # noqa: E501
        """Import a project  # noqa: E501

        Creates a new project version containing the clips and sequences found in the given project file. Sequences in the file will be created as items having a Vidispine sequence representation.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.import_project(essence_mappings_type, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param EssenceMappingsType essence_mappings_type: (required)
        :key bool assign_id: True if external ids should be created for the items in this project, using the ids from the project.
        :key str collection_id: The id of the project to create a new version for.
        :key str type: The file format.
        :key str uri: The location of the file to import.
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: URIListType.
                 If the method is called asynchronously, returns the request thread.
        :rtype: URIListType or multiprocessing.pool.AsyncResult
        """
        kwargs['_return_http_data_only'] = True
        return self.import_project_with_http_info(essence_mappings_type, **kwargs)  # noqa: E501

    def import_project_with_http_info(self, essence_mappings_type, **kwargs):  # noqa: E501
        """Import a project  # noqa: E501

        Creates a new project version containing the clips and sequences found in the given project file. Sequences in the file will be created as items having a Vidispine sequence representation.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.import_project_with_http_info(essence_mappings_type, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param EssenceMappingsType essence_mappings_type: (required)
        :key bool assign_id: True if external ids should be created for the items in this project, using the ids from the project.
        :key str collection_id: The id of the project to create a new version for.
        :key str type: The file format.
        :key str uri: The location of the file to import.
        :key _return_http_data_only: response data without head status code
                                       and headers
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(URIListType, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['essence_mappings_type', 'assign_id', 'collection_id', 'type', 'uri']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method import_project" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'essence_mappings_type' is set
        if ('essence_mappings_type' not in local_var_params or
                local_var_params['essence_mappings_type'] is None):
            raise ApiValueError("Missing the required parameter `essence_mappings_type` when calling `import_project`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'assign_id' in local_var_params:
            query_params.append(('assignId', local_var_params['assign_id']))  # noqa: E501
        if 'collection_id' in local_var_params:
            query_params.append(('collectionId', local_var_params['collection_id']))  # noqa: E501
        if 'type' in local_var_params:
            query_params.append(('type', local_var_params['type']))  # noqa: E501
        if 'uri' in local_var_params:
            query_params.append(('uri', local_var_params['uri']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'essence_mappings_type' in local_var_params:
            body_params = local_var_params['essence_mappings_type']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'text/plain', 'application/xml'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'application/xml'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/import/project', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='URIListType',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def import_project_sequence(self, essence_mappings_type, **kwargs):  # noqa: E501
        """Import a sequence  # noqa: E501

        Creates a new item with a Vidispine sequence representations of the given file. The file must contain a single sequence.  The item will also have a sequence contain the original data from the file, together with an essence mapping for identifying the items and files referenced by the sequence.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.import_project_sequence(essence_mappings_type, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param EssenceMappingsType essence_mappings_type: (required)
        :key bool assign_id: True if external ids should be created for the items in this project, using the ids from the project.
        :key str type: The file format.
        :key str uri: The location of the file to import.
        :key int pause_frame: When a rendering job is started, this parameter determines which frame the job will pause at.  The job will resume when the sequence is updated.
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: URIListType.
                 If the method is called asynchronously, returns the request thread.
        :rtype: URIListType or multiprocessing.pool.AsyncResult
        """
        kwargs['_return_http_data_only'] = True
        return self.import_project_sequence_with_http_info(essence_mappings_type, **kwargs)  # noqa: E501

    def import_project_sequence_with_http_info(self, essence_mappings_type, **kwargs):  # noqa: E501
        """Import a sequence  # noqa: E501

        Creates a new item with a Vidispine sequence representations of the given file. The file must contain a single sequence.  The item will also have a sequence contain the original data from the file, together with an essence mapping for identifying the items and files referenced by the sequence.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.import_project_sequence_with_http_info(essence_mappings_type, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param EssenceMappingsType essence_mappings_type: (required)
        :key bool assign_id: True if external ids should be created for the items in this project, using the ids from the project.
        :key str type: The file format.
        :key str uri: The location of the file to import.
        :key int pause_frame: When a rendering job is started, this parameter determines which frame the job will pause at.  The job will resume when the sequence is updated.
        :key _return_http_data_only: response data without head status code
                                       and headers
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(URIListType, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['essence_mappings_type', 'assign_id', 'type', 'uri', 'pause_frame']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method import_project_sequence" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'essence_mappings_type' is set
        if ('essence_mappings_type' not in local_var_params or
                local_var_params['essence_mappings_type'] is None):
            raise ApiValueError("Missing the required parameter `essence_mappings_type` when calling `import_project_sequence`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'assign_id' in local_var_params:
            query_params.append(('assignId', local_var_params['assign_id']))  # noqa: E501
        if 'type' in local_var_params:
            query_params.append(('type', local_var_params['type']))  # noqa: E501
        if 'uri' in local_var_params:
            query_params.append(('uri', local_var_params['uri']))  # noqa: E501
        if 'pause_frame' in local_var_params:
            query_params.append(('pauseFrame', local_var_params['pause_frame']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'essence_mappings_type' in local_var_params:
            body_params = local_var_params['essence_mappings_type']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'text/plain', 'application/xml'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'application/xml'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/import/project/sequence', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='URIListType',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def import_sidecar(self, item_id, **kwargs):  # noqa: E501
        """Import a sidecar file  # noqa: E501

        Starts a job that imports the sidecar file, located at the given URL, to the specified item.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.import_sidecar(item_id, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str item_id: The item id. (required)
        :key list[str] jobmetadata: Additional information for the job task.
        :key str notification_data: Any additional data to include for notifications on this job.
        :key str sidecar: Either the id of the sidecar file or a URL for locating it.
        :key str priority: The priority to assign to the job.
        :key str notification: The placeholder job notification to use for this job.
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: JobType.
                 If the method is called asynchronously, returns the request thread.
        :rtype: JobType or multiprocessing.pool.AsyncResult
        """
        kwargs['_return_http_data_only'] = True
        return self.import_sidecar_with_http_info(item_id, **kwargs)  # noqa: E501

    def import_sidecar_with_http_info(self, item_id, **kwargs):  # noqa: E501
        """Import a sidecar file  # noqa: E501

        Starts a job that imports the sidecar file, located at the given URL, to the specified item.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.import_sidecar_with_http_info(item_id, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str item_id: The item id. (required)
        :key list[str] jobmetadata: Additional information for the job task.
        :key str notification_data: Any additional data to include for notifications on this job.
        :key str sidecar: Either the id of the sidecar file or a URL for locating it.
        :key str priority: The priority to assign to the job.
        :key str notification: The placeholder job notification to use for this job.
        :key _return_http_data_only: response data without head status code
                                       and headers
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(JobType, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['item_id', 'jobmetadata', 'notification_data', 'sidecar', 'priority', 'notification']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method import_sidecar" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'item_id' is set
        if ('item_id' not in local_var_params or
                local_var_params['item_id'] is None):
            raise ApiValueError("Missing the required parameter `item_id` when calling `import_sidecar`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'item_id' in local_var_params:
            path_params['item-id'] = local_var_params['item_id']  # noqa: E501

        query_params = []
        if 'jobmetadata' in local_var_params:
            query_params.append(('jobmetadata', local_var_params['jobmetadata']))  # noqa: E501
            collection_formats['jobmetadata'] = 'multi'  # noqa: E501
        if 'notification_data' in local_var_params:
            query_params.append(('notificationData', local_var_params['notification_data']))  # noqa: E501
        if 'sidecar' in local_var_params:
            query_params.append(('sidecar', local_var_params['sidecar']))  # noqa: E501
        if 'priority' in local_var_params:
            query_params.append(('priority', local_var_params['priority']))  # noqa: E501
        if 'notification' in local_var_params:
            query_params.append(('notification', local_var_params['notification']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'application/xml'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/import/sidecar/{item-id}', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='JobType',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def import_sidecar_raw(self, item_id, body, **kwargs):  # noqa: E501
        """Import a sidecar file  # noqa: E501

        Starts a job that imports the sidecar file as HTTP request body. The sidecar file will be saved in one of the Vidispine storages.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.import_sidecar_raw(item_id, body, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str item_id: The item id. (required)
        :param file body: The raw data. (required)
        :key list[str] jobmetadata: Additional information for the job task.
        :key str notification_data: Any additional data to include for notifications on this job.
        :key str storage_id: The id of the storage that the sidecar file will be saved in.
        :key str file_extension: The extension of the file that this sidecar data is from.  Used to identify the sidecar media type.  Example: `srt`.
        :key str notification: The placeholder job notification to use for this job.
        :key str priority: The priority to assign to the job.
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: JobType.
                 If the method is called asynchronously, returns the request thread.
        :rtype: JobType or multiprocessing.pool.AsyncResult
        """
        kwargs['_return_http_data_only'] = True
        return self.import_sidecar_raw_with_http_info(item_id, body, **kwargs)  # noqa: E501

    def import_sidecar_raw_with_http_info(self, item_id, body, **kwargs):  # noqa: E501
        """Import a sidecar file  # noqa: E501

        Starts a job that imports the sidecar file as HTTP request body. The sidecar file will be saved in one of the Vidispine storages.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.import_sidecar_raw_with_http_info(item_id, body, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str item_id: The item id. (required)
        :param file body: The raw data. (required)
        :key list[str] jobmetadata: Additional information for the job task.
        :key str notification_data: Any additional data to include for notifications on this job.
        :key str storage_id: The id of the storage that the sidecar file will be saved in.
        :key str file_extension: The extension of the file that this sidecar data is from.  Used to identify the sidecar media type.  Example: `srt`.
        :key str notification: The placeholder job notification to use for this job.
        :key str priority: The priority to assign to the job.
        :key _return_http_data_only: response data without head status code
                                       and headers
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(JobType, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['item_id', 'body', 'jobmetadata', 'notification_data', 'storage_id', 'file_extension', 'notification', 'priority']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method import_sidecar_raw" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'item_id' is set
        if ('item_id' not in local_var_params or
                local_var_params['item_id'] is None):
            raise ApiValueError("Missing the required parameter `item_id` when calling `import_sidecar_raw`")  # noqa: E501
        # verify the required parameter 'body' is set
        if ('body' not in local_var_params or
                local_var_params['body'] is None):
            raise ApiValueError("Missing the required parameter `body` when calling `import_sidecar_raw`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'item_id' in local_var_params:
            path_params['item-id'] = local_var_params['item_id']  # noqa: E501

        query_params = []
        if 'jobmetadata' in local_var_params:
            query_params.append(('jobmetadata', local_var_params['jobmetadata']))  # noqa: E501
            collection_formats['jobmetadata'] = 'multi'  # noqa: E501
        if 'notification_data' in local_var_params:
            query_params.append(('notificationData', local_var_params['notification_data']))  # noqa: E501
        if 'storage_id' in local_var_params:
            query_params.append(('storageId', local_var_params['storage_id']))  # noqa: E501
        if 'file_extension' in local_var_params:
            query_params.append(('fileExtension', local_var_params['file_extension']))  # noqa: E501
        if 'notification' in local_var_params:
            query_params.append(('notification', local_var_params['notification']))  # noqa: E501
        if 'priority' in local_var_params:
            query_params.append(('priority', local_var_params['priority']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in local_var_params:
            body_params = local_var_params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'application/xml'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/octet-stream'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/import/sidecar/{item-id}/raw', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='JobType',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def import_storage_definition(self, storage_import_type, **kwargs):  # noqa: E501
        """Import a storage definition  # noqa: E501

        Creates a new storage based on the *StorageImportDocument*. A file entity will be created for each entry in the document, if a file with that ID does not already exist. Finally, a storage method will be added, with the path supplied in the call.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.import_storage_definition(storage_import_type, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param StorageImportType storage_import_type: A <em>StorageImportDocument</em> (required)
        :key str path: The file system path to where the files are located.
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None.
                 If the method is called asynchronously, returns the request thread.
        :rtype: None or multiprocessing.pool.AsyncResult
        """
        kwargs['_return_http_data_only'] = True
        return self.import_storage_definition_with_http_info(storage_import_type, **kwargs)  # noqa: E501

    def import_storage_definition_with_http_info(self, storage_import_type, **kwargs):  # noqa: E501
        """Import a storage definition  # noqa: E501

        Creates a new storage based on the *StorageImportDocument*. A file entity will be created for each entry in the document, if a file with that ID does not already exist. Finally, a storage method will be added, with the path supplied in the call.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.import_storage_definition_with_http_info(storage_import_type, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param StorageImportType storage_import_type: A <em>StorageImportDocument</em> (required)
        :key str path: The file system path to where the files are located.
        :key _return_http_data_only: response data without head status code
                                       and headers
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['storage_import_type', 'path']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method import_storage_definition" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'storage_import_type' is set
        if ('storage_import_type' not in local_var_params or
                local_var_params['storage_import_type'] is None):
            raise ApiValueError("Missing the required parameter `storage_import_type` when calling `import_storage_definition`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'path' in local_var_params:
            query_params.append(('path', local_var_params['path']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'storage_import_type' in local_var_params:
            body_params = local_var_params['storage_import_type']
        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'application/xml'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/storage/import', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def import_to_placeholder(self, item_id, **kwargs):  # noqa: E501
        """Import to a placeholder item  # noqa: E501

        Imports the file and extracts component data based on what type is specified (container, audio, video, binary). No transcoding will take place until all files have been imported.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.import_to_placeholder(item_id, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str item_id: The item id. (required)
        :key str uri: A URI to the file that will be imported.  Make sure to percent encode the URI.  Must be specified unless `fileId` is specified.
        :key bool no_transcode: - `true` - Will disable transcoding even if the `tags` parameter is set.  Rather, the specified tag will be used to determine cropping, scaling etc.  of thumbnails.  - `false` (default) - Normal transcode.
        :key str original: If specified, should be one of the tags specified in the tag parameter.  Specifies that the original shape tag will be reset to the shape created to this tag.
        :key str fast_start_length: Estimated duration of the clip in seconds.
        :key bool create_thumbnails: - `true` (default) - Generate thumbnails as per defined by shape tag.  - `false` - Disable thumbnail generation.
        :key str create_posters: A list of time codes to use for creating posters.
        :key list[str] jobmetadata: Additional information for the job task.
        :key str notification_data: Any additional data to include for notifications on this job.
        :key str storage_id: Identifier of storage where essence file is to be stored.
        :key bool require_fast_start: - `true` (default) - Try to put the index tables (header) in front of the file.  - `false` - Put header at end of file.
        :key bool growing: - `true` - Specifies that the input file is still written to, so enables growing file support.  - `false` (default) - No growing file handling of import file.
        :key list[str] tag: A list of shape tags to use for transcoding.
        :key str resource_id: The transcoder resource to use to execute the transcode.
        :key str thumbnail_service: Identifies which thumbnail resource that should be used.
        :key str settings: Pre-configured import settings.
        :key str notification: The placeholder job notification to use for this job.
        :key str file_id: The id of the file that contains the essence.  Must be specified unless `uri` is specified.
        :key str shape_id: Shape id for which shape to receive the content.
        :key bool allow_reimport: - `true` - Import the file to this shape even if the file is already importing or is already part of another item.  - `false` (default) Reject the request if the file with the given id has already been imported or is currently importing.
        :key int index: The component index (track) of new component.
        :key str priority: The priority to assign to the job.
        :key bool override_fast_start: - `true` (default) - Use transcoder's estimate of the duration for allocating header space in MOV files and similar files.  - `false` - Do not use the transcoder's estimate of the duration.
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: JobType.
                 If the method is called asynchronously, returns the request thread.
        :rtype: JobType or multiprocessing.pool.AsyncResult
        """
        kwargs['_return_http_data_only'] = True
        return self.import_to_placeholder_with_http_info(item_id, **kwargs)  # noqa: E501

    def import_to_placeholder_with_http_info(self, item_id, **kwargs):  # noqa: E501
        """Import to a placeholder item  # noqa: E501

        Imports the file and extracts component data based on what type is specified (container, audio, video, binary). No transcoding will take place until all files have been imported.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.import_to_placeholder_with_http_info(item_id, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str item_id: The item id. (required)
        :key str uri: A URI to the file that will be imported.  Make sure to percent encode the URI.  Must be specified unless `fileId` is specified.
        :key bool no_transcode: - `true` - Will disable transcoding even if the `tags` parameter is set.  Rather, the specified tag will be used to determine cropping, scaling etc.  of thumbnails.  - `false` (default) - Normal transcode.
        :key str original: If specified, should be one of the tags specified in the tag parameter.  Specifies that the original shape tag will be reset to the shape created to this tag.
        :key str fast_start_length: Estimated duration of the clip in seconds.
        :key bool create_thumbnails: - `true` (default) - Generate thumbnails as per defined by shape tag.  - `false` - Disable thumbnail generation.
        :key str create_posters: A list of time codes to use for creating posters.
        :key list[str] jobmetadata: Additional information for the job task.
        :key str notification_data: Any additional data to include for notifications on this job.
        :key str storage_id: Identifier of storage where essence file is to be stored.
        :key bool require_fast_start: - `true` (default) - Try to put the index tables (header) in front of the file.  - `false` - Put header at end of file.
        :key bool growing: - `true` - Specifies that the input file is still written to, so enables growing file support.  - `false` (default) - No growing file handling of import file.
        :key list[str] tag: A list of shape tags to use for transcoding.
        :key str resource_id: The transcoder resource to use to execute the transcode.
        :key str thumbnail_service: Identifies which thumbnail resource that should be used.
        :key str settings: Pre-configured import settings.
        :key str notification: The placeholder job notification to use for this job.
        :key str file_id: The id of the file that contains the essence.  Must be specified unless `uri` is specified.
        :key str shape_id: Shape id for which shape to receive the content.
        :key bool allow_reimport: - `true` - Import the file to this shape even if the file is already importing or is already part of another item.  - `false` (default) Reject the request if the file with the given id has already been imported or is currently importing.
        :key int index: The component index (track) of new component.
        :key str priority: The priority to assign to the job.
        :key bool override_fast_start: - `true` (default) - Use transcoder's estimate of the duration for allocating header space in MOV files and similar files.  - `false` - Do not use the transcoder's estimate of the duration.
        :key _return_http_data_only: response data without head status code
                                       and headers
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(JobType, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['item_id', 'uri', 'no_transcode', 'original', 'fast_start_length', 'create_thumbnails', 'create_posters', 'jobmetadata', 'notification_data', 'storage_id', 'require_fast_start', 'growing', 'tag', 'resource_id', 'thumbnail_service', 'settings', 'notification', 'file_id', 'shape_id', 'allow_reimport', 'index', 'priority', 'override_fast_start']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method import_to_placeholder" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'item_id' is set
        if ('item_id' not in local_var_params or
                local_var_params['item_id'] is None):
            raise ApiValueError("Missing the required parameter `item_id` when calling `import_to_placeholder`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'item_id' in local_var_params:
            path_params['item-id'] = local_var_params['item_id']  # noqa: E501

        query_params = []
        if 'uri' in local_var_params:
            query_params.append(('uri', local_var_params['uri']))  # noqa: E501
        if 'no_transcode' in local_var_params:
            query_params.append(('no-transcode', local_var_params['no_transcode']))  # noqa: E501
        if 'original' in local_var_params:
            query_params.append(('original', local_var_params['original']))  # noqa: E501
        if 'fast_start_length' in local_var_params:
            query_params.append(('fastStartLength', local_var_params['fast_start_length']))  # noqa: E501
        if 'create_thumbnails' in local_var_params:
            query_params.append(('createThumbnails', local_var_params['create_thumbnails']))  # noqa: E501
        if 'create_posters' in local_var_params:
            query_params.append(('createPosters', local_var_params['create_posters']))  # noqa: E501
        if 'jobmetadata' in local_var_params:
            query_params.append(('jobmetadata', local_var_params['jobmetadata']))  # noqa: E501
            collection_formats['jobmetadata'] = 'multi'  # noqa: E501
        if 'notification_data' in local_var_params:
            query_params.append(('notificationData', local_var_params['notification_data']))  # noqa: E501
        if 'storage_id' in local_var_params:
            query_params.append(('storageId', local_var_params['storage_id']))  # noqa: E501
        if 'require_fast_start' in local_var_params:
            query_params.append(('requireFastStart', local_var_params['require_fast_start']))  # noqa: E501
        if 'growing' in local_var_params:
            query_params.append(('growing', local_var_params['growing']))  # noqa: E501
        if 'tag' in local_var_params:
            query_params.append(('tag', local_var_params['tag']))  # noqa: E501
            collection_formats['tag'] = 'multi'  # noqa: E501
        if 'resource_id' in local_var_params:
            query_params.append(('resourceId', local_var_params['resource_id']))  # noqa: E501
        if 'thumbnail_service' in local_var_params:
            query_params.append(('thumbnailService', local_var_params['thumbnail_service']))  # noqa: E501
        if 'settings' in local_var_params:
            query_params.append(('settings', local_var_params['settings']))  # noqa: E501
        if 'notification' in local_var_params:
            query_params.append(('notification', local_var_params['notification']))  # noqa: E501
        if 'file_id' in local_var_params:
            query_params.append(('fileId', local_var_params['file_id']))  # noqa: E501
        if 'shape_id' in local_var_params:
            query_params.append(('shapeId', local_var_params['shape_id']))  # noqa: E501
        if 'allow_reimport' in local_var_params:
            query_params.append(('allowReimport', local_var_params['allow_reimport']))  # noqa: E501
        if 'index' in local_var_params:
            query_params.append(('index', local_var_params['index']))  # noqa: E501
        if 'priority' in local_var_params:
            query_params.append(('priority', local_var_params['priority']))  # noqa: E501
        if 'override_fast_start' in local_var_params:
            query_params.append(('overrideFastStart', local_var_params['override_fast_start']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'application/xml'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/import/placeholder/{item-id}/[container,audio,video,binary]', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='JobType',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_default_access_control_for_group(self, permission, group_name, **kwargs):  # noqa: E501
        """Add a group to the default access control list  # noqa: E501

        Sets the permissions for a certain group.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_default_access_control_for_group(permission, group_name, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str permission: The level of permissions to grant the group. (required)
        :param str group_name: The group name. (required)
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None.
                 If the method is called asynchronously, returns the request thread.
        :rtype: None or multiprocessing.pool.AsyncResult
        """
        kwargs['_return_http_data_only'] = True
        return self.update_default_access_control_for_group_with_http_info(permission, group_name, **kwargs)  # noqa: E501

    def update_default_access_control_for_group_with_http_info(self, permission, group_name, **kwargs):  # noqa: E501
        """Add a group to the default access control list  # noqa: E501

        Sets the permissions for a certain group.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_default_access_control_for_group_with_http_info(permission, group_name, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str permission: The level of permissions to grant the group. (required)
        :param str group_name: The group name. (required)
        :key _return_http_data_only: response data without head status code
                                       and headers
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['permission', 'group_name']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_default_access_control_for_group" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'permission' is set
        if ('permission' not in local_var_params or
                local_var_params['permission'] is None):
            raise ApiValueError("Missing the required parameter `permission` when calling `update_default_access_control_for_group`")  # noqa: E501
        # verify the required parameter 'group_name' is set
        if ('group_name' not in local_var_params or
                local_var_params['group_name'] is None):
            raise ApiValueError("Missing the required parameter `group_name` when calling `update_default_access_control_for_group`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'group_name' in local_var_params:
            path_params['group-name'] = local_var_params['group_name']  # noqa: E501

        query_params = []
        if 'permission' in local_var_params:
            query_params.append(('permission', local_var_params['permission']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/import/access/group/{group-name}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)
