# coding: utf-8

"""
    Vidispine API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)  # noqa: E501

    The version of the OpenAPI document: 5.x
    Contact: info@vidispine.com
    Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from vidispine.models import *
from vidispine.api_client import ApiClient
from vidispine.exceptions import (
    ApiTypeError,
    ApiValueError
)


class ItemApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def create_item_export_job(self, item_id, **kwargs):  # noqa: E501
        """Start an export job for a single item  # noqa: E501

        Creates a new export job that will copy a file to a remote location.  A shape tag can be specified to decide which shape that will be exported.  If the URI ends with a \"/\" the URI is assumed to describe a folder and the file will retain its existing filename. Otherwise it is assumed that the URI describes a file and that filename will be used.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_item_export_job(item_id, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str item_id: The item id. (required)
        :key list[str] jobmetadata: Additional information for the job task.
        :key list[str] track: Comma-separated list of item track ids.  Can include wildcards, e. g.  `A*`.  Can also contain component ids.
        :key str notification_data: Any additional data to include for notifications on this job.
        :key bool use_original_filename: If set to `true`, the file(s) will be exported with their original filename if available.
        :key str tag: Finds a shape with the specified tag and uses that for export.  If not specified, the system will attempt to use the original shape.
        :key str projection: Defines the projection to use when exporting the metadata.
        :key str notification: The placeholder job notification to use for this job.
        :key bool use_original_component_filename: If set to `true`, the file(s) will be exported with their original component filename if available.
        :key str start: Defines a start time code for the media.
        :key str end: Defines an end time code for the media.
        :key str priority: The priority to assign to the job.
        :key str version: - *essence-version-id* - Return shapes for a specified version.  - `all` - Return shapes for all versions.  - `latest` (default) - Return shapes for the latest version.  - `latest-per-shapetag` - Return shapes with the highest essence version number per shape tag.
        :key str uri: A URI to the destination of the file.
        :key bool metadata: - `true` - Metadata will also be exported to side-car XML file.  - `false` (default) - No metadata is exported.
        :key str template: export template to use.
        :key str location_name: The name of an export location.
        :key bool allow_missing: - `true` (default) - Job will be started and the missing files will be ignored.  - `false` - Job will fail if there are missing files and the files could not be generated by transcoding.  A shape tag should be specified.
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: JobType.
                 If the method is called asynchronously, returns the request thread.
        :rtype: JobType or multiprocessing.pool.AsyncResult
        """
        kwargs['_return_http_data_only'] = True
        return self.create_item_export_job_with_http_info(item_id, **kwargs)  # noqa: E501

    def create_item_export_job_with_http_info(self, item_id, **kwargs):  # noqa: E501
        """Start an export job for a single item  # noqa: E501

        Creates a new export job that will copy a file to a remote location.  A shape tag can be specified to decide which shape that will be exported.  If the URI ends with a \"/\" the URI is assumed to describe a folder and the file will retain its existing filename. Otherwise it is assumed that the URI describes a file and that filename will be used.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_item_export_job_with_http_info(item_id, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str item_id: The item id. (required)
        :key list[str] jobmetadata: Additional information for the job task.
        :key list[str] track: Comma-separated list of item track ids.  Can include wildcards, e. g.  `A*`.  Can also contain component ids.
        :key str notification_data: Any additional data to include for notifications on this job.
        :key bool use_original_filename: If set to `true`, the file(s) will be exported with their original filename if available.
        :key str tag: Finds a shape with the specified tag and uses that for export.  If not specified, the system will attempt to use the original shape.
        :key str projection: Defines the projection to use when exporting the metadata.
        :key str notification: The placeholder job notification to use for this job.
        :key bool use_original_component_filename: If set to `true`, the file(s) will be exported with their original component filename if available.
        :key str start: Defines a start time code for the media.
        :key str end: Defines an end time code for the media.
        :key str priority: The priority to assign to the job.
        :key str version: - *essence-version-id* - Return shapes for a specified version.  - `all` - Return shapes for all versions.  - `latest` (default) - Return shapes for the latest version.  - `latest-per-shapetag` - Return shapes with the highest essence version number per shape tag.
        :key str uri: A URI to the destination of the file.
        :key bool metadata: - `true` - Metadata will also be exported to side-car XML file.  - `false` (default) - No metadata is exported.
        :key str template: export template to use.
        :key str location_name: The name of an export location.
        :key bool allow_missing: - `true` (default) - Job will be started and the missing files will be ignored.  - `false` - Job will fail if there are missing files and the files could not be generated by transcoding.  A shape tag should be specified.
        :key _return_http_data_only: response data without head status code
                                       and headers
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(JobType, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['item_id', 'jobmetadata', 'track', 'notification_data', 'use_original_filename', 'tag', 'projection', 'notification', 'use_original_component_filename', 'start', 'end', 'priority', 'version', 'uri', 'metadata', 'template', 'location_name', 'allow_missing']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_item_export_job" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'item_id' is set
        if ('item_id' not in local_var_params or
                local_var_params['item_id'] is None):
            raise ApiValueError("Missing the required parameter `item_id` when calling `create_item_export_job`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'item_id' in local_var_params:
            path_params['item-id'] = local_var_params['item_id']  # noqa: E501

        query_params = []
        if 'jobmetadata' in local_var_params:
            query_params.append(('jobmetadata', local_var_params['jobmetadata']))  # noqa: E501
            collection_formats['jobmetadata'] = 'multi'  # noqa: E501
        if 'track' in local_var_params:
            query_params.append(('track', local_var_params['track']))  # noqa: E501
            collection_formats['track'] = 'csv'  # noqa: E501
        if 'notification_data' in local_var_params:
            query_params.append(('notificationData', local_var_params['notification_data']))  # noqa: E501
        if 'use_original_filename' in local_var_params:
            query_params.append(('useOriginalFilename', local_var_params['use_original_filename']))  # noqa: E501
        if 'tag' in local_var_params:
            query_params.append(('tag', local_var_params['tag']))  # noqa: E501
        if 'projection' in local_var_params:
            query_params.append(('projection', local_var_params['projection']))  # noqa: E501
        if 'notification' in local_var_params:
            query_params.append(('notification', local_var_params['notification']))  # noqa: E501
        if 'use_original_component_filename' in local_var_params:
            query_params.append(('useOriginalComponentFilename', local_var_params['use_original_component_filename']))  # noqa: E501
        if 'start' in local_var_params:
            query_params.append(('start', local_var_params['start']))  # noqa: E501
        if 'end' in local_var_params:
            query_params.append(('end', local_var_params['end']))  # noqa: E501
        if 'priority' in local_var_params:
            query_params.append(('priority', local_var_params['priority']))  # noqa: E501
        if 'version' in local_var_params:
            query_params.append(('version', local_var_params['version']))  # noqa: E501
        if 'uri' in local_var_params:
            query_params.append(('uri', local_var_params['uri']))  # noqa: E501
        if 'metadata' in local_var_params:
            query_params.append(('metadata', local_var_params['metadata']))  # noqa: E501
        if 'template' in local_var_params:
            query_params.append(('template', local_var_params['template']))  # noqa: E501
        if 'location_name' in local_var_params:
            query_params.append(('locationName', local_var_params['location_name']))  # noqa: E501
        if 'allow_missing' in local_var_params:
            query_params.append(('allowMissing', local_var_params['allow_missing']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'application/xml'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/item/{item-id}/export', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='JobType',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_item_imf_export_job(self, item_id, **kwargs):  # noqa: E501
        """Start an export job for a single item as an IMF package  # noqa: E501

        Creates a new export job that will create an IMF package as a remote location. URI must end with an \"/\" to denote a folder.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_item_imf_export_job(item_id, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str item_id: The item id. (required)
        :key list[str] jobmetadata: Additional information for the job task.
        :key list[str] track: Comma-separated list of item track ids to include as physical files.  Can include wildcards, e. g.  `A*`.  Can also contain component ids.  Since 4. 17. 8, can also be on the format `{shape}:track`, where shape is identified by shape id or shape tag.  Since Vidispine 5. 0, can also be of syntax: `shape:` {shape-id}:{track}, `cpl:` {CPL UUID}:{track}, `tag:` {shape-tag}:{track}, or `component:` {component-id}.  (The `component:` syntax means the same as with no prefix. )
        :key str notification_data: Any additional data to include for notifications on this job.
        :key bool use_original_filename: If set to `true`, the file(s) will be exported with their original filename if available.
        :key str tag: Finds a shape with the specified tag and uses that for export.  If not specified, the system will attempt to use the original shape.
        :key str uri: A URI to the destination of the file.
        :key str notification: The placeholder job notification to use for this job.
        :key list[str] cpl_track: Comma-separated list of item track ids to include in the CPL.  Can include wildcards, e. g.  `A*`.  Can also contain component ids.  Since 4. 17. 8, can also be on the format `{shape}:track`, where shape is identified by shape id or shape tag.  Default is the same as the track parameter.
        :key str start: Defines a start time_code for the media.
        :key str projection: Defines the projection to use when exporting the metadata.
        :key str end: Defines an end time_code for the media.
        :key bool use_original_component_filename: If set to `true`, the file(s) will be exported with their original component filename if available.
        :key str version: - *essence-version-id* - Return shapes for a specified version.  - `all` - Return shapes for all versions.  - `latest` (default) - Return shapes for the latest version.  - `latest-per-shapetag` - Return shapes with the highest essence version number per shape tag.
        :key bool allow_missing: - `true` (default) - Job will be started and the missing files will be ignored.  - `false` - Job will fail if there are missing files and the files could not be generated by transcoding.  A shape tag should be specified.
        :key bool metadata: - `true` - Metadata will also be exported to side-car XML file.  - `false` (default) - No metadata is exported.
        :key str template: Export template to use (see export-templates).
        :key str priority: The priority to assign to the job.
        :key str location_name: The name of an export location.
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: JobType.
                 If the method is called asynchronously, returns the request thread.
        :rtype: JobType or multiprocessing.pool.AsyncResult
        """
        kwargs['_return_http_data_only'] = True
        return self.create_item_imf_export_job_with_http_info(item_id, **kwargs)  # noqa: E501

    def create_item_imf_export_job_with_http_info(self, item_id, **kwargs):  # noqa: E501
        """Start an export job for a single item as an IMF package  # noqa: E501

        Creates a new export job that will create an IMF package as a remote location. URI must end with an \"/\" to denote a folder.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_item_imf_export_job_with_http_info(item_id, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str item_id: The item id. (required)
        :key list[str] jobmetadata: Additional information for the job task.
        :key list[str] track: Comma-separated list of item track ids to include as physical files.  Can include wildcards, e. g.  `A*`.  Can also contain component ids.  Since 4. 17. 8, can also be on the format `{shape}:track`, where shape is identified by shape id or shape tag.  Since Vidispine 5. 0, can also be of syntax: `shape:` {shape-id}:{track}, `cpl:` {CPL UUID}:{track}, `tag:` {shape-tag}:{track}, or `component:` {component-id}.  (The `component:` syntax means the same as with no prefix. )
        :key str notification_data: Any additional data to include for notifications on this job.
        :key bool use_original_filename: If set to `true`, the file(s) will be exported with their original filename if available.
        :key str tag: Finds a shape with the specified tag and uses that for export.  If not specified, the system will attempt to use the original shape.
        :key str uri: A URI to the destination of the file.
        :key str notification: The placeholder job notification to use for this job.
        :key list[str] cpl_track: Comma-separated list of item track ids to include in the CPL.  Can include wildcards, e. g.  `A*`.  Can also contain component ids.  Since 4. 17. 8, can also be on the format `{shape}:track`, where shape is identified by shape id or shape tag.  Default is the same as the track parameter.
        :key str start: Defines a start time_code for the media.
        :key str projection: Defines the projection to use when exporting the metadata.
        :key str end: Defines an end time_code for the media.
        :key bool use_original_component_filename: If set to `true`, the file(s) will be exported with their original component filename if available.
        :key str version: - *essence-version-id* - Return shapes for a specified version.  - `all` - Return shapes for all versions.  - `latest` (default) - Return shapes for the latest version.  - `latest-per-shapetag` - Return shapes with the highest essence version number per shape tag.
        :key bool allow_missing: - `true` (default) - Job will be started and the missing files will be ignored.  - `false` - Job will fail if there are missing files and the files could not be generated by transcoding.  A shape tag should be specified.
        :key bool metadata: - `true` - Metadata will also be exported to side-car XML file.  - `false` (default) - No metadata is exported.
        :key str template: Export template to use (see export-templates).
        :key str priority: The priority to assign to the job.
        :key str location_name: The name of an export location.
        :key _return_http_data_only: response data without head status code
                                       and headers
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(JobType, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['item_id', 'jobmetadata', 'track', 'notification_data', 'use_original_filename', 'tag', 'uri', 'notification', 'cpl_track', 'start', 'projection', 'end', 'use_original_component_filename', 'version', 'allow_missing', 'metadata', 'template', 'priority', 'location_name']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_item_imf_export_job" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'item_id' is set
        if ('item_id' not in local_var_params or
                local_var_params['item_id'] is None):
            raise ApiValueError("Missing the required parameter `item_id` when calling `create_item_imf_export_job`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'item_id' in local_var_params:
            path_params['item-id'] = local_var_params['item_id']  # noqa: E501

        query_params = []
        if 'jobmetadata' in local_var_params:
            query_params.append(('jobmetadata', local_var_params['jobmetadata']))  # noqa: E501
            collection_formats['jobmetadata'] = 'multi'  # noqa: E501
        if 'track' in local_var_params:
            query_params.append(('track', local_var_params['track']))  # noqa: E501
            collection_formats['track'] = 'csv'  # noqa: E501
        if 'notification_data' in local_var_params:
            query_params.append(('notificationData', local_var_params['notification_data']))  # noqa: E501
        if 'use_original_filename' in local_var_params:
            query_params.append(('useOriginalFilename', local_var_params['use_original_filename']))  # noqa: E501
        if 'tag' in local_var_params:
            query_params.append(('tag', local_var_params['tag']))  # noqa: E501
        if 'uri' in local_var_params:
            query_params.append(('uri', local_var_params['uri']))  # noqa: E501
        if 'notification' in local_var_params:
            query_params.append(('notification', local_var_params['notification']))  # noqa: E501
        if 'cpl_track' in local_var_params:
            query_params.append(('cplTrack', local_var_params['cpl_track']))  # noqa: E501
            collection_formats['cplTrack'] = 'csv'  # noqa: E501
        if 'start' in local_var_params:
            query_params.append(('start', local_var_params['start']))  # noqa: E501
        if 'projection' in local_var_params:
            query_params.append(('projection', local_var_params['projection']))  # noqa: E501
        if 'end' in local_var_params:
            query_params.append(('end', local_var_params['end']))  # noqa: E501
        if 'use_original_component_filename' in local_var_params:
            query_params.append(('useOriginalComponentFilename', local_var_params['use_original_component_filename']))  # noqa: E501
        if 'version' in local_var_params:
            query_params.append(('version', local_var_params['version']))  # noqa: E501
        if 'allow_missing' in local_var_params:
            query_params.append(('allowMissing', local_var_params['allow_missing']))  # noqa: E501
        if 'metadata' in local_var_params:
            query_params.append(('metadata', local_var_params['metadata']))  # noqa: E501
        if 'template' in local_var_params:
            query_params.append(('template', local_var_params['template']))  # noqa: E501
        if 'priority' in local_var_params:
            query_params.append(('priority', local_var_params['priority']))  # noqa: E501
        if 'location_name' in local_var_params:
            query_params.append(('locationName', local_var_params['location_name']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'application/xml'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/item/{item-id}/export/imp', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='JobType',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_item_list_job(self, destination_uri, item_list_type, **kwargs):  # noqa: E501
        """Create an item list job  # noqa: E501

        Starts a new job that goes through all the items available to the user/group and outputs a file to the supplied URI.  If no user and no group is supplied, all items will be retrieved. The output format depends on the specified parameter, if set to XML an *ItemListDocument* will be produced. Furthermore if an XSLT is given the *ItemListDocument* will be transformed.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_item_list_job(destination_uri, item_list_type, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str destination_uri: The URI to output the CSV file to. (required)
        :param ItemListType item_list_type: An optional XSLT capable of transforming <em>ItemListDocument</em>. (required)
        :key list[str] jobmetadata: Additional information for the job task.
        :key list[str] p: Comma-separated list of paths specifying the content to include.  Overrides the field and data parameters.  Only supported for XML output.
        :key str output_format: Specifies the output format.
        :key str data: Specifies any additional data that should be included with the metadata fields.
        :key str notification: The placeholder job notification to use for this job.
        :key str groupname: Filter items according to the access of the specified group.
        :key str username: Filter items according to the access of the specified user.
        :key str notification_data: Any additional data to include for notifications on this job.
        :key list[str] field: Comma-separated list of metadata fields to include in the result.
        :key str priority: The priority to assign to the job.
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: JobType.
                 If the method is called asynchronously, returns the request thread.
        :rtype: JobType or multiprocessing.pool.AsyncResult
        """
        kwargs['_return_http_data_only'] = True
        return self.create_item_list_job_with_http_info(destination_uri, item_list_type, **kwargs)  # noqa: E501

    def create_item_list_job_with_http_info(self, destination_uri, item_list_type, **kwargs):  # noqa: E501
        """Create an item list job  # noqa: E501

        Starts a new job that goes through all the items available to the user/group and outputs a file to the supplied URI.  If no user and no group is supplied, all items will be retrieved. The output format depends on the specified parameter, if set to XML an *ItemListDocument* will be produced. Furthermore if an XSLT is given the *ItemListDocument* will be transformed.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_item_list_job_with_http_info(destination_uri, item_list_type, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str destination_uri: The URI to output the CSV file to. (required)
        :param ItemListType item_list_type: An optional XSLT capable of transforming <em>ItemListDocument</em>. (required)
        :key list[str] jobmetadata: Additional information for the job task.
        :key list[str] p: Comma-separated list of paths specifying the content to include.  Overrides the field and data parameters.  Only supported for XML output.
        :key str output_format: Specifies the output format.
        :key str data: Specifies any additional data that should be included with the metadata fields.
        :key str notification: The placeholder job notification to use for this job.
        :key str groupname: Filter items according to the access of the specified group.
        :key str username: Filter items according to the access of the specified user.
        :key str notification_data: Any additional data to include for notifications on this job.
        :key list[str] field: Comma-separated list of metadata fields to include in the result.
        :key str priority: The priority to assign to the job.
        :key _return_http_data_only: response data without head status code
                                       and headers
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(JobType, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['destination_uri', 'item_list_type', 'jobmetadata', 'p', 'output_format', 'data', 'notification', 'groupname', 'username', 'notification_data', 'field', 'priority']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_item_list_job" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'destination_uri' is set
        if ('destination_uri' not in local_var_params or
                local_var_params['destination_uri'] is None):
            raise ApiValueError("Missing the required parameter `destination_uri` when calling `create_item_list_job`")  # noqa: E501
        # verify the required parameter 'item_list_type' is set
        if ('item_list_type' not in local_var_params or
                local_var_params['item_list_type'] is None):
            raise ApiValueError("Missing the required parameter `item_list_type` when calling `create_item_list_job`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'jobmetadata' in local_var_params:
            query_params.append(('jobmetadata', local_var_params['jobmetadata']))  # noqa: E501
            collection_formats['jobmetadata'] = 'multi'  # noqa: E501
        if 'p' in local_var_params:
            query_params.append(('p', local_var_params['p']))  # noqa: E501
            collection_formats['p'] = 'csv'  # noqa: E501
        if 'output_format' in local_var_params:
            query_params.append(('outputFormat', local_var_params['output_format']))  # noqa: E501
        if 'destination_uri' in local_var_params:
            query_params.append(('destinationUri', local_var_params['destination_uri']))  # noqa: E501
        if 'data' in local_var_params:
            query_params.append(('data', local_var_params['data']))  # noqa: E501
        if 'notification' in local_var_params:
            query_params.append(('notification', local_var_params['notification']))  # noqa: E501
        if 'groupname' in local_var_params:
            query_params.append(('groupname', local_var_params['groupname']))  # noqa: E501
        if 'username' in local_var_params:
            query_params.append(('username', local_var_params['username']))  # noqa: E501
        if 'notification_data' in local_var_params:
            query_params.append(('notificationData', local_var_params['notification_data']))  # noqa: E501
        if 'field' in local_var_params:
            query_params.append(('field', local_var_params['field']))  # noqa: E501
            collection_formats['field'] = 'csv'  # noqa: E501
        if 'priority' in local_var_params:
            query_params.append(('priority', local_var_params['priority']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'item_list_type' in local_var_params:
            body_params = local_var_params['item_list_type']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'application/xml'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/xslt'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/item/list', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='JobType',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_item_thumbnail_job(self, item_id, **kwargs):  # noqa: E501
        """Create a thumbnail job  # noqa: E501

        Creates a new thumbnail job with the specified parameters. Note that a job cannot both create thumbnails at specified intervals and posters. Creating thumbnails according to transcoder rules and creating posters is however allowed.  Changed in version 5.0: For multi-layer PSD/PSB files, only a thumbnail of all layers flattened will be generated by default.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_item_thumbnail_job(item_id, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str item_id: The item id. (required)
        :key int thumbnail_width: The width of the thumbnails.  If `thumbnailWidth` is specified, `thumbnailHeight` must also be specified.
        :key list[str] jobmetadata: Additional information for the job task.
        :key str notification_data: Any additional data to include for notifications on this job.
        :key int version: A version number.  For creating thumbnails for older versions of the item essence.  Default is latest version.
        :key str thumbnail_service: Identifies which thumbnail resource that should be used.
        :key str tag: Include additional video settings from this transcode preset.  Resolution settings in the tag are overridden by query parameters `thumbnailHeight` and `thumbnailWidth`.
        :key str source_tag: Comma-separated shape tags.  The fist valid shape will be chosen as the source of the job.  If non of the tags are valid, the original shape will be used.
        :key str poster_format: - `jpeg` (default) - Creates posters in JPEG format.  - `png` - Creates posters in PNG format.
        :key str notification: The placeholder job notification to use for this job.
        :key int poster_width: The width of the posters.
        :key str priority: The priority to assign to the job.
        :key bool create_thumbnails: - `true` - Creates thumbnails according to default transcoder rules.  - *t1*, . . .  - Thumbnails will be created on the specified, comma-separated, time codes.  - `false` (default) - No thumbnails will be created.
        :key int thumbnail_height: The height of the thumbnails.  If `thumbnailHeight` is specified, `thumbnailWidth` must also be specified.
        :key str create_posters: A list of time codes to use for creating posters.
        :key int poster_height: The height of the posters.
        :key str thumbnail_period: Timecode string specifying the interval of the thumbnails.  It should be a decimal integer when working with multi-page images/PDFs, meaning every N page(s).
        :key str resource_id: The transcoder resource to use to execute the transcode.
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: JobType.
                 If the method is called asynchronously, returns the request thread.
        :rtype: JobType or multiprocessing.pool.AsyncResult
        """
        kwargs['_return_http_data_only'] = True
        return self.create_item_thumbnail_job_with_http_info(item_id, **kwargs)  # noqa: E501

    def create_item_thumbnail_job_with_http_info(self, item_id, **kwargs):  # noqa: E501
        """Create a thumbnail job  # noqa: E501

        Creates a new thumbnail job with the specified parameters. Note that a job cannot both create thumbnails at specified intervals and posters. Creating thumbnails according to transcoder rules and creating posters is however allowed.  Changed in version 5.0: For multi-layer PSD/PSB files, only a thumbnail of all layers flattened will be generated by default.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_item_thumbnail_job_with_http_info(item_id, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str item_id: The item id. (required)
        :key int thumbnail_width: The width of the thumbnails.  If `thumbnailWidth` is specified, `thumbnailHeight` must also be specified.
        :key list[str] jobmetadata: Additional information for the job task.
        :key str notification_data: Any additional data to include for notifications on this job.
        :key int version: A version number.  For creating thumbnails for older versions of the item essence.  Default is latest version.
        :key str thumbnail_service: Identifies which thumbnail resource that should be used.
        :key str tag: Include additional video settings from this transcode preset.  Resolution settings in the tag are overridden by query parameters `thumbnailHeight` and `thumbnailWidth`.
        :key str source_tag: Comma-separated shape tags.  The fist valid shape will be chosen as the source of the job.  If non of the tags are valid, the original shape will be used.
        :key str poster_format: - `jpeg` (default) - Creates posters in JPEG format.  - `png` - Creates posters in PNG format.
        :key str notification: The placeholder job notification to use for this job.
        :key int poster_width: The width of the posters.
        :key str priority: The priority to assign to the job.
        :key bool create_thumbnails: - `true` - Creates thumbnails according to default transcoder rules.  - *t1*, . . .  - Thumbnails will be created on the specified, comma-separated, time codes.  - `false` (default) - No thumbnails will be created.
        :key int thumbnail_height: The height of the thumbnails.  If `thumbnailHeight` is specified, `thumbnailWidth` must also be specified.
        :key str create_posters: A list of time codes to use for creating posters.
        :key int poster_height: The height of the posters.
        :key str thumbnail_period: Timecode string specifying the interval of the thumbnails.  It should be a decimal integer when working with multi-page images/PDFs, meaning every N page(s).
        :key str resource_id: The transcoder resource to use to execute the transcode.
        :key _return_http_data_only: response data without head status code
                                       and headers
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(JobType, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['item_id', 'thumbnail_width', 'jobmetadata', 'notification_data', 'version', 'thumbnail_service', 'tag', 'source_tag', 'poster_format', 'notification', 'poster_width', 'priority', 'create_thumbnails', 'thumbnail_height', 'create_posters', 'poster_height', 'thumbnail_period', 'resource_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_item_thumbnail_job" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'item_id' is set
        if ('item_id' not in local_var_params or
                local_var_params['item_id'] is None):
            raise ApiValueError("Missing the required parameter `item_id` when calling `create_item_thumbnail_job`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'item_id' in local_var_params:
            path_params['item-id'] = local_var_params['item_id']  # noqa: E501

        query_params = []
        if 'thumbnail_width' in local_var_params:
            query_params.append(('thumbnailWidth', local_var_params['thumbnail_width']))  # noqa: E501
        if 'jobmetadata' in local_var_params:
            query_params.append(('jobmetadata', local_var_params['jobmetadata']))  # noqa: E501
            collection_formats['jobmetadata'] = 'multi'  # noqa: E501
        if 'notification_data' in local_var_params:
            query_params.append(('notificationData', local_var_params['notification_data']))  # noqa: E501
        if 'version' in local_var_params:
            query_params.append(('version', local_var_params['version']))  # noqa: E501
        if 'thumbnail_service' in local_var_params:
            query_params.append(('thumbnailService', local_var_params['thumbnail_service']))  # noqa: E501
        if 'tag' in local_var_params:
            query_params.append(('tag', local_var_params['tag']))  # noqa: E501
        if 'source_tag' in local_var_params:
            query_params.append(('sourceTag', local_var_params['source_tag']))  # noqa: E501
        if 'poster_format' in local_var_params:
            query_params.append(('posterFormat', local_var_params['poster_format']))  # noqa: E501
        if 'notification' in local_var_params:
            query_params.append(('notification', local_var_params['notification']))  # noqa: E501
        if 'poster_width' in local_var_params:
            query_params.append(('posterWidth', local_var_params['poster_width']))  # noqa: E501
        if 'priority' in local_var_params:
            query_params.append(('priority', local_var_params['priority']))  # noqa: E501
        if 'create_thumbnails' in local_var_params:
            query_params.append(('createThumbnails', local_var_params['create_thumbnails']))  # noqa: E501
        if 'thumbnail_height' in local_var_params:
            query_params.append(('thumbnailHeight', local_var_params['thumbnail_height']))  # noqa: E501
        if 'create_posters' in local_var_params:
            query_params.append(('createPosters', local_var_params['create_posters']))  # noqa: E501
        if 'poster_height' in local_var_params:
            query_params.append(('posterHeight', local_var_params['poster_height']))  # noqa: E501
        if 'thumbnail_period' in local_var_params:
            query_params.append(('thumbnailPeriod', local_var_params['thumbnail_period']))  # noqa: E501
        if 'resource_id' in local_var_params:
            query_params.append(('resourceId', local_var_params['resource_id']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'application/xml'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/item/{item-id}/thumbnail', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='JobType',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_item_transcode_job(self, item_id, **kwargs):  # noqa: E501
        """Transcode an item  # noqa: E501

        Starts a new job that transcode an item to a number of shapes according to the given shape tags.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_item_transcode_job(item_id, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str item_id: The item id. (required)
        :key list[str] jobmetadata: Additional information for the job task.
        :key str notification_data: Any additional data to include for notifications on this job.
        :key str thumbnail_service: Identifies which thumbnail resource that should be used.
        :key list[str] tag: Comma-separated list of shape tags, that specify the desired output.
        :key str storage_id: Identifier of storage where essence file is to be stored.  New in version 4. 16.
        :key bool require_fast_start: - `true` (default) - Try to put the index tables (header) in front of the file.  - `false` - Put header at end of file.
        :key str notification: The placeholder job notification to use for this job.
        :key str fast_start_length: Estimated duration of the clip in seconds.
        :key bool create_thumbnails: - `true` - Creates thumbnails according to default transcoder rules.  - `false` (default) - No thumbnails will be created.
        :key str destination_item: An item id, to which the new new shape will be associated.
        :key str create_posters: A list of time codes to use for creating posters.
        :key bool override_fast_start: - `true` (default) - Use transcoder's estimate of the duration for allocating header space in MOV files and similar files.  - `false` - Do not use the transcoder's estimate of the duration.
        :key str resource_id: The transcoder resource to use to execute the transcode.
        :key str priority: The priority to assign to the job.
        :key str original: If specified, should be one of the tags specified in the tag parameter.  Specifies that the original shape tag will be reset to the shape created to this tag.
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: JobType.
                 If the method is called asynchronously, returns the request thread.
        :rtype: JobType or multiprocessing.pool.AsyncResult
        """
        kwargs['_return_http_data_only'] = True
        return self.create_item_transcode_job_with_http_info(item_id, **kwargs)  # noqa: E501

    def create_item_transcode_job_with_http_info(self, item_id, **kwargs):  # noqa: E501
        """Transcode an item  # noqa: E501

        Starts a new job that transcode an item to a number of shapes according to the given shape tags.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_item_transcode_job_with_http_info(item_id, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str item_id: The item id. (required)
        :key list[str] jobmetadata: Additional information for the job task.
        :key str notification_data: Any additional data to include for notifications on this job.
        :key str thumbnail_service: Identifies which thumbnail resource that should be used.
        :key list[str] tag: Comma-separated list of shape tags, that specify the desired output.
        :key str storage_id: Identifier of storage where essence file is to be stored.  New in version 4. 16.
        :key bool require_fast_start: - `true` (default) - Try to put the index tables (header) in front of the file.  - `false` - Put header at end of file.
        :key str notification: The placeholder job notification to use for this job.
        :key str fast_start_length: Estimated duration of the clip in seconds.
        :key bool create_thumbnails: - `true` - Creates thumbnails according to default transcoder rules.  - `false` (default) - No thumbnails will be created.
        :key str destination_item: An item id, to which the new new shape will be associated.
        :key str create_posters: A list of time codes to use for creating posters.
        :key bool override_fast_start: - `true` (default) - Use transcoder's estimate of the duration for allocating header space in MOV files and similar files.  - `false` - Do not use the transcoder's estimate of the duration.
        :key str resource_id: The transcoder resource to use to execute the transcode.
        :key str priority: The priority to assign to the job.
        :key str original: If specified, should be one of the tags specified in the tag parameter.  Specifies that the original shape tag will be reset to the shape created to this tag.
        :key _return_http_data_only: response data without head status code
                                       and headers
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(JobType, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['item_id', 'jobmetadata', 'notification_data', 'thumbnail_service', 'tag', 'storage_id', 'require_fast_start', 'notification', 'fast_start_length', 'create_thumbnails', 'destination_item', 'create_posters', 'override_fast_start', 'resource_id', 'priority', 'original']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_item_transcode_job" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'item_id' is set
        if ('item_id' not in local_var_params or
                local_var_params['item_id'] is None):
            raise ApiValueError("Missing the required parameter `item_id` when calling `create_item_transcode_job`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'item_id' in local_var_params:
            path_params['item-id'] = local_var_params['item_id']  # noqa: E501

        query_params = []
        if 'jobmetadata' in local_var_params:
            query_params.append(('jobmetadata', local_var_params['jobmetadata']))  # noqa: E501
            collection_formats['jobmetadata'] = 'multi'  # noqa: E501
        if 'notification_data' in local_var_params:
            query_params.append(('notificationData', local_var_params['notification_data']))  # noqa: E501
        if 'thumbnail_service' in local_var_params:
            query_params.append(('thumbnailService', local_var_params['thumbnail_service']))  # noqa: E501
        if 'tag' in local_var_params:
            query_params.append(('tag', local_var_params['tag']))  # noqa: E501
            collection_formats['tag'] = 'csv'  # noqa: E501
        if 'storage_id' in local_var_params:
            query_params.append(('storageId', local_var_params['storage_id']))  # noqa: E501
        if 'require_fast_start' in local_var_params:
            query_params.append(('requireFastStart', local_var_params['require_fast_start']))  # noqa: E501
        if 'notification' in local_var_params:
            query_params.append(('notification', local_var_params['notification']))  # noqa: E501
        if 'fast_start_length' in local_var_params:
            query_params.append(('fastStartLength', local_var_params['fast_start_length']))  # noqa: E501
        if 'create_thumbnails' in local_var_params:
            query_params.append(('createThumbnails', local_var_params['create_thumbnails']))  # noqa: E501
        if 'destination_item' in local_var_params:
            query_params.append(('destinationItem', local_var_params['destination_item']))  # noqa: E501
        if 'create_posters' in local_var_params:
            query_params.append(('createPosters', local_var_params['create_posters']))  # noqa: E501
        if 'override_fast_start' in local_var_params:
            query_params.append(('overrideFastStart', local_var_params['override_fast_start']))  # noqa: E501
        if 'resource_id' in local_var_params:
            query_params.append(('resourceId', local_var_params['resource_id']))  # noqa: E501
        if 'priority' in local_var_params:
            query_params.append(('priority', local_var_params['priority']))  # noqa: E501
        if 'original' in local_var_params:
            query_params.append(('original', local_var_params['original']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'application/xml'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/item/{item-id}/transcode', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='JobType',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_item(self, item_id, **kwargs):  # noqa: E501
        """Delete an item  # noqa: E501

        Marks the item as being deleted, meaning it will not be returned in search results. The actual removement from the database is done approximately once every minute. Also, all files associated with the item is marked as `TO_BE_DELETED`, meaning they will be deleted by the storage supervisor, but not sooner than all jobs involving the actual file has finished.  By specifying `keepShapeTagMedia` and/or `keepShapeTagStorage`, the files associated with the item is not deleted, but simply unassociated with the item.  If only `keepShapeTagMedia` is given, all files belonging to shapes of the item with any of the given shape tags are preserved.  If only `keepShapeTagStorage` is given, all files belonging to the item residing on the given storages are preserved. If both `keepShapeTagMedia` and `keepShapeTagStorage` is given, all files which *both* belongs to the specified shapes and storages are preserved.  If any of `keepShapeTagMedia` or `keepShapeTagStorage` contains a value `*`, then no files will be removed.  Changed in version 5.0: New _item_write role required.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_item(item_id, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str item_id: The item id. (required)
        :key list[str] keep_shape_tag_storage: Comma-separated list of storage ids whose files will not be deleted.
        :key list[str] keep_shape_tag_media: Comma-separated list of shape tags whose files will not be deleted.
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None.
                 If the method is called asynchronously, returns the request thread.
        :rtype: None or multiprocessing.pool.AsyncResult
        """
        kwargs['_return_http_data_only'] = True
        return self.delete_item_with_http_info(item_id, **kwargs)  # noqa: E501

    def delete_item_with_http_info(self, item_id, **kwargs):  # noqa: E501
        """Delete an item  # noqa: E501

        Marks the item as being deleted, meaning it will not be returned in search results. The actual removement from the database is done approximately once every minute. Also, all files associated with the item is marked as `TO_BE_DELETED`, meaning they will be deleted by the storage supervisor, but not sooner than all jobs involving the actual file has finished.  By specifying `keepShapeTagMedia` and/or `keepShapeTagStorage`, the files associated with the item is not deleted, but simply unassociated with the item.  If only `keepShapeTagMedia` is given, all files belonging to shapes of the item with any of the given shape tags are preserved.  If only `keepShapeTagStorage` is given, all files belonging to the item residing on the given storages are preserved. If both `keepShapeTagMedia` and `keepShapeTagStorage` is given, all files which *both* belongs to the specified shapes and storages are preserved.  If any of `keepShapeTagMedia` or `keepShapeTagStorage` contains a value `*`, then no files will be removed.  Changed in version 5.0: New _item_write role required.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_item_with_http_info(item_id, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str item_id: The item id. (required)
        :key list[str] keep_shape_tag_storage: Comma-separated list of storage ids whose files will not be deleted.
        :key list[str] keep_shape_tag_media: Comma-separated list of shape tags whose files will not be deleted.
        :key _return_http_data_only: response data without head status code
                                       and headers
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['item_id', 'keep_shape_tag_storage', 'keep_shape_tag_media']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_item" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'item_id' is set
        if ('item_id' not in local_var_params or
                local_var_params['item_id'] is None):
            raise ApiValueError("Missing the required parameter `item_id` when calling `delete_item`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'item_id' in local_var_params:
            path_params['item-id'] = local_var_params['item_id']  # noqa: E501

        query_params = []
        if 'keep_shape_tag_storage' in local_var_params:
            query_params.append(('keepShapeTagStorage', local_var_params['keep_shape_tag_storage']))  # noqa: E501
            collection_formats['keepShapeTagStorage'] = 'csv'  # noqa: E501
        if 'keep_shape_tag_media' in local_var_params:
            query_params.append(('keepShapeTagMedia', local_var_params['keep_shape_tag_media']))  # noqa: E501
            collection_formats['keepShapeTagMedia'] = 'csv'  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/item/{item-id}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_items(self, **kwargs):  # noqa: E501
        """Delete multiple items  # noqa: E501

        Marks multiple items as being deleted, meaning they will not be returned in search results.  Changed in version 5.0: New _item_write role required.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_items(async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :key list[str] keep_shape_tag_storage: Comma-separated list of storage ids whose files will not be deleted.
        :key list[str] keep_shape_tag_media: Comma-separated list of shape tags whose files will not be deleted.
        :key list[str] id: Comma-separated list of item ids or external ids.  Must not be empty.
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None.
                 If the method is called asynchronously, returns the request thread.
        :rtype: None or multiprocessing.pool.AsyncResult
        """
        kwargs['_return_http_data_only'] = True
        return self.delete_items_with_http_info(**kwargs)  # noqa: E501

    def delete_items_with_http_info(self, **kwargs):  # noqa: E501
        """Delete multiple items  # noqa: E501

        Marks multiple items as being deleted, meaning they will not be returned in search results.  Changed in version 5.0: New _item_write role required.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_items_with_http_info(async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :key list[str] keep_shape_tag_storage: Comma-separated list of storage ids whose files will not be deleted.
        :key list[str] keep_shape_tag_media: Comma-separated list of shape tags whose files will not be deleted.
        :key list[str] id: Comma-separated list of item ids or external ids.  Must not be empty.
        :key _return_http_data_only: response data without head status code
                                       and headers
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['keep_shape_tag_storage', 'keep_shape_tag_media', 'id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_items" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'keep_shape_tag_storage' in local_var_params:
            query_params.append(('keepShapeTagStorage', local_var_params['keep_shape_tag_storage']))  # noqa: E501
            collection_formats['keepShapeTagStorage'] = 'csv'  # noqa: E501
        if 'keep_shape_tag_media' in local_var_params:
            query_params.append(('keepShapeTagMedia', local_var_params['keep_shape_tag_media']))  # noqa: E501
            collection_formats['keepShapeTagMedia'] = 'csv'  # noqa: E501
        if 'id' in local_var_params:
            query_params.append(('id', local_var_params['id']))  # noqa: E501
            collection_formats['id'] = 'csv'  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/item', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_collections_containing_item(self, item_id, **kwargs):  # noqa: E501
        """List collections that contain an item  # noqa: E501

        Retrieves the ids of all collections that includes the item, and that the calling user has read access to.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_collections_containing_item(item_id, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str item_id: The item id. (required)
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: URIListType.
                 If the method is called asynchronously, returns the request thread.
        :rtype: URIListType or multiprocessing.pool.AsyncResult
        """
        kwargs['_return_http_data_only'] = True
        return self.get_collections_containing_item_with_http_info(item_id, **kwargs)  # noqa: E501

    def get_collections_containing_item_with_http_info(self, item_id, **kwargs):  # noqa: E501
        """List collections that contain an item  # noqa: E501

        Retrieves the ids of all collections that includes the item, and that the calling user has read access to.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_collections_containing_item_with_http_info(item_id, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str item_id: The item id. (required)
        :key _return_http_data_only: response data without head status code
                                       and headers
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(URIListType, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['item_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_collections_containing_item" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'item_id' is set
        if ('item_id' not in local_var_params or
                local_var_params['item_id'] is None):
            raise ApiValueError("Missing the required parameter `item_id` when calling `get_collections_containing_item`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'item_id' in local_var_params:
            path_params['item-id'] = local_var_params['item_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'text/plain', 'application/xml'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/item/{item-id}/collections', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='URIListType',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_item(self, item_id, **kwargs):  # noqa: E501
        """Retrieve an item  # noqa: E501

        Returns information about a single item.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_item(item_id, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str item_id: The item id. (required)
        :key list[str] language: Comma-separated list.   - *language-tag* - Return metadata for specific language, e. g.  `en_US`.  Wildcards may be used, e. g.  `*_CA` for both Canadian French and Canadian English.  - `none` - Return all metadata without language specification.  - `all` (default) - Return all metadata, with or without language specification.
        :key str storage_type: Only return URIs for files from storages of this type.
        :key str tag: A URI parameter: Comma-separated list of shape tags to return.
        :key bool closed_files: A URI parameter:  - `true` (default) - Return only URIs that point to closed files.  - `false` - Return all URIs.
        :key str terse: - `yes` - Return metadata in terse format.  - `no` (default) - Return metadata in verbose format.
        :key str method_metadata: Metadata used with storage method.
        :key list[str] interval: Comma-separated list  - *time-span* - Filter out metadata, return only metadata for specified time span.  - `generic` - Return all non-timed metadata.  - `all` (default) - Return all metadata, same as `interval=generic,-INF-+INF`
        :key list[str] group: Comma-separated list.   - *group-name* - Return specified group.  - *group-name* `+` - Return specified group and subgroups.  - *group-name* `:` *new-name* - Return specified group, renamed to a new name in return value.  - `-` *group-name* - Exclude specified group.  - (default) - Return all groups.
        :key bool include_values: Return the value enumeration for each metadata field.
        :key str storage_group: Storage group id.  Return only files from storages specified in the storage group.
        :key list[str] track: Comma-separated list.   - *track-type* *track-number* - Return metadata for specified track.  Example of track is `A2`.  - *track-type* *t1* `-` *t2* - Return metadata for specified track interval, e. g.  `A2-4`.  - *track-type* `*` - Return metadata for all tracks of specified type, e. g.  `A*`.  - `generic` - Return all non-tracked metadata.  - `all` (default) - All metadata, with or without track specification, are returned.
        :key str conflict: - `yes` (default) - Include all metadata conflicts, unresolved.  - `no` - Return conflicts resolved according to field rules.
        :key bool starttc: - `true` - Interval is given relative to start timecode of item.  - `false` (default) - Interval is 0-based.
        :key list[str] content: Comma-separated list of the types of content to retrieve.
        :key str merged_extradata: Any possible extra data.
        :key bool include_transient_metadata: - `true` (default) - Include transient metadata.  - `false` - Do not include transient metadata in response.
        :key str merged_type: The type of operation to check for.
        :key bool default_value: - `true` - For unset fields, return default values.  - `false` (default) - Do not return default values.
        :key list[str] field: Comma-separated list.   - *field-name* - Return specified field.  - *field-name* \":\" *new-name* - Return specified field, renamed to a new name in return value.  - \"-\" *field-name* - Exclude specified field.  - (default) - Return all fields.
        :key str include: A list of keys.   Includes additional field specific data.  Additionally, if set to `type` the type definition of the field will be retrieved.
        :key str method_type: Access method.   - `AUTO` - Gives an APInoauth URI to the media.  Access to file is tunneled through Vidispine.  - `AZURE_SAS` - If the storage schema is azure:// you can get direct access to the media.  The resulting URI will not tunnel through Vidispine but rather point directly to the media location at the azure storage.
        :key list[str] p: Comma-separated list of paths specifying the content to include.  Overrides the content and filter parameters.
        :key str base_uri: Which base URI to use for the thumbnail URLs.
        :key list[str] uri_type: Comma-separated list of format types (container format) to return.
        :key list[str] storage: List of storage ids.  Return only files from specific storages.  Can be specified multiple times.
        :key str revision: Specifying which metadata revision to display.  Only used if requesting a single item or collection.
        :key str scheme: URI scheme to return.
        :key str version: Specifying which essence version to return for shapes.  If special value `all`, display all versions.  If special value `latest` (default), display latest version of shapes.
        :key str merged_permission: The lowest required permission level.
        :key str sample_rate: Convert all outgoing time instants to specified rate.  *NB!* Time codes which cannot be expressed in an integer number of samples will be returned as a decimal number, with risk of losing precision.
        :key bool noauth_url: - `true` Return URIs that do not need authentication.  - `false` (default) Return normal URIs
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: ItemType.
                 If the method is called asynchronously, returns the request thread.
        :rtype: ItemType or multiprocessing.pool.AsyncResult
        """
        kwargs['_return_http_data_only'] = True
        return self.get_item_with_http_info(item_id, **kwargs)  # noqa: E501

    def get_item_with_http_info(self, item_id, **kwargs):  # noqa: E501
        """Retrieve an item  # noqa: E501

        Returns information about a single item.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_item_with_http_info(item_id, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str item_id: The item id. (required)
        :key list[str] language: Comma-separated list.   - *language-tag* - Return metadata for specific language, e. g.  `en_US`.  Wildcards may be used, e. g.  `*_CA` for both Canadian French and Canadian English.  - `none` - Return all metadata without language specification.  - `all` (default) - Return all metadata, with or without language specification.
        :key str storage_type: Only return URIs for files from storages of this type.
        :key str tag: A URI parameter: Comma-separated list of shape tags to return.
        :key bool closed_files: A URI parameter:  - `true` (default) - Return only URIs that point to closed files.  - `false` - Return all URIs.
        :key str terse: - `yes` - Return metadata in terse format.  - `no` (default) - Return metadata in verbose format.
        :key str method_metadata: Metadata used with storage method.
        :key list[str] interval: Comma-separated list  - *time-span* - Filter out metadata, return only metadata for specified time span.  - `generic` - Return all non-timed metadata.  - `all` (default) - Return all metadata, same as `interval=generic,-INF-+INF`
        :key list[str] group: Comma-separated list.   - *group-name* - Return specified group.  - *group-name* `+` - Return specified group and subgroups.  - *group-name* `:` *new-name* - Return specified group, renamed to a new name in return value.  - `-` *group-name* - Exclude specified group.  - (default) - Return all groups.
        :key bool include_values: Return the value enumeration for each metadata field.
        :key str storage_group: Storage group id.  Return only files from storages specified in the storage group.
        :key list[str] track: Comma-separated list.   - *track-type* *track-number* - Return metadata for specified track.  Example of track is `A2`.  - *track-type* *t1* `-` *t2* - Return metadata for specified track interval, e. g.  `A2-4`.  - *track-type* `*` - Return metadata for all tracks of specified type, e. g.  `A*`.  - `generic` - Return all non-tracked metadata.  - `all` (default) - All metadata, with or without track specification, are returned.
        :key str conflict: - `yes` (default) - Include all metadata conflicts, unresolved.  - `no` - Return conflicts resolved according to field rules.
        :key bool starttc: - `true` - Interval is given relative to start timecode of item.  - `false` (default) - Interval is 0-based.
        :key list[str] content: Comma-separated list of the types of content to retrieve.
        :key str merged_extradata: Any possible extra data.
        :key bool include_transient_metadata: - `true` (default) - Include transient metadata.  - `false` - Do not include transient metadata in response.
        :key str merged_type: The type of operation to check for.
        :key bool default_value: - `true` - For unset fields, return default values.  - `false` (default) - Do not return default values.
        :key list[str] field: Comma-separated list.   - *field-name* - Return specified field.  - *field-name* \":\" *new-name* - Return specified field, renamed to a new name in return value.  - \"-\" *field-name* - Exclude specified field.  - (default) - Return all fields.
        :key str include: A list of keys.   Includes additional field specific data.  Additionally, if set to `type` the type definition of the field will be retrieved.
        :key str method_type: Access method.   - `AUTO` - Gives an APInoauth URI to the media.  Access to file is tunneled through Vidispine.  - `AZURE_SAS` - If the storage schema is azure:// you can get direct access to the media.  The resulting URI will not tunnel through Vidispine but rather point directly to the media location at the azure storage.
        :key list[str] p: Comma-separated list of paths specifying the content to include.  Overrides the content and filter parameters.
        :key str base_uri: Which base URI to use for the thumbnail URLs.
        :key list[str] uri_type: Comma-separated list of format types (container format) to return.
        :key list[str] storage: List of storage ids.  Return only files from specific storages.  Can be specified multiple times.
        :key str revision: Specifying which metadata revision to display.  Only used if requesting a single item or collection.
        :key str scheme: URI scheme to return.
        :key str version: Specifying which essence version to return for shapes.  If special value `all`, display all versions.  If special value `latest` (default), display latest version of shapes.
        :key str merged_permission: The lowest required permission level.
        :key str sample_rate: Convert all outgoing time instants to specified rate.  *NB!* Time codes which cannot be expressed in an integer number of samples will be returned as a decimal number, with risk of losing precision.
        :key bool noauth_url: - `true` Return URIs that do not need authentication.  - `false` (default) Return normal URIs
        :key _return_http_data_only: response data without head status code
                                       and headers
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(ItemType, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['item_id', 'language', 'storage_type', 'tag', 'closed_files', 'terse', 'method_metadata', 'interval', 'group', 'include_values', 'storage_group', 'track', 'conflict', 'starttc', 'content', 'merged_extradata', 'include_transient_metadata', 'merged_type', 'default_value', 'field', 'include', 'method_type', 'p', 'base_uri', 'uri_type', 'storage', 'revision', 'scheme', 'version', 'merged_permission', 'sample_rate', 'noauth_url']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_item" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'item_id' is set
        if ('item_id' not in local_var_params or
                local_var_params['item_id'] is None):
            raise ApiValueError("Missing the required parameter `item_id` when calling `get_item`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'item_id' in local_var_params:
            path_params['item-id'] = local_var_params['item_id']  # noqa: E501

        query_params = []
        if 'language' in local_var_params:
            query_params.append(('language', local_var_params['language']))  # noqa: E501
            collection_formats['language'] = 'csv'  # noqa: E501
        if 'storage_type' in local_var_params:
            query_params.append(('storageType', local_var_params['storage_type']))  # noqa: E501
        if 'tag' in local_var_params:
            query_params.append(('tag', local_var_params['tag']))  # noqa: E501
        if 'closed_files' in local_var_params:
            query_params.append(('closedFiles', local_var_params['closed_files']))  # noqa: E501
        if 'terse' in local_var_params:
            query_params.append(('terse', local_var_params['terse']))  # noqa: E501
        if 'method_metadata' in local_var_params:
            query_params.append(('methodMetadata', local_var_params['method_metadata']))  # noqa: E501
        if 'interval' in local_var_params:
            query_params.append(('interval', local_var_params['interval']))  # noqa: E501
            collection_formats['interval'] = 'csv'  # noqa: E501
        if 'group' in local_var_params:
            query_params.append(('group', local_var_params['group']))  # noqa: E501
            collection_formats['group'] = 'csv'  # noqa: E501
        if 'include_values' in local_var_params:
            query_params.append(('includeValues', local_var_params['include_values']))  # noqa: E501
        if 'storage_group' in local_var_params:
            query_params.append(('storageGroup', local_var_params['storage_group']))  # noqa: E501
        if 'track' in local_var_params:
            query_params.append(('track', local_var_params['track']))  # noqa: E501
            collection_formats['track'] = 'csv'  # noqa: E501
        if 'conflict' in local_var_params:
            query_params.append(('conflict', local_var_params['conflict']))  # noqa: E501
        if 'starttc' in local_var_params:
            query_params.append(('starttc', local_var_params['starttc']))  # noqa: E501
        if 'content' in local_var_params:
            query_params.append(('content', local_var_params['content']))  # noqa: E501
            collection_formats['content'] = 'csv'  # noqa: E501
        if 'merged_extradata' in local_var_params:
            query_params.append(('mergedExtradata', local_var_params['merged_extradata']))  # noqa: E501
        if 'include_transient_metadata' in local_var_params:
            query_params.append(('includeTransientMetadata', local_var_params['include_transient_metadata']))  # noqa: E501
        if 'merged_type' in local_var_params:
            query_params.append(('mergedType', local_var_params['merged_type']))  # noqa: E501
        if 'default_value' in local_var_params:
            query_params.append(('defaultValue', local_var_params['default_value']))  # noqa: E501
        if 'field' in local_var_params:
            query_params.append(('field', local_var_params['field']))  # noqa: E501
            collection_formats['field'] = 'csv'  # noqa: E501
        if 'include' in local_var_params:
            query_params.append(('include', local_var_params['include']))  # noqa: E501
        if 'method_type' in local_var_params:
            query_params.append(('methodType', local_var_params['method_type']))  # noqa: E501
        if 'p' in local_var_params:
            query_params.append(('p', local_var_params['p']))  # noqa: E501
            collection_formats['p'] = 'csv'  # noqa: E501
        if 'base_uri' in local_var_params:
            query_params.append(('baseURI', local_var_params['base_uri']))  # noqa: E501
        if 'uri_type' in local_var_params:
            query_params.append(('uriType', local_var_params['uri_type']))  # noqa: E501
            collection_formats['uriType'] = 'csv'  # noqa: E501
        if 'storage' in local_var_params:
            query_params.append(('storage', local_var_params['storage']))  # noqa: E501
            collection_formats['storage'] = 'multi'  # noqa: E501
        if 'revision' in local_var_params:
            query_params.append(('revision', local_var_params['revision']))  # noqa: E501
        if 'scheme' in local_var_params:
            query_params.append(('scheme', local_var_params['scheme']))  # noqa: E501
        if 'version' in local_var_params:
            query_params.append(('version', local_var_params['version']))  # noqa: E501
        if 'merged_permission' in local_var_params:
            query_params.append(('mergedPermission', local_var_params['merged_permission']))  # noqa: E501
        if 'sample_rate' in local_var_params:
            query_params.append(('sampleRate', local_var_params['sample_rate']))  # noqa: E501
        if 'noauth_url' in local_var_params:
            query_params.append(('noauth-url', local_var_params['noauth_url']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'application/xml'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/item/{item-id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ItemType',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_item_poster_resources(self, item_id, **kwargs):  # noqa: E501
        """List thumbnail resources for an item  # noqa: E501

        Return one or more poster resource URIs which can be used to manage the posters for a specific item.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_item_poster_resources(item_id, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str item_id: The item id. (required)
        :key int version: Return posters from this essence version.  By default posters for the latest version will be returned.
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: URIListType.
                 If the method is called asynchronously, returns the request thread.
        :rtype: URIListType or multiprocessing.pool.AsyncResult
        """
        kwargs['_return_http_data_only'] = True
        return self.get_item_poster_resources_with_http_info(item_id, **kwargs)  # noqa: E501

    def get_item_poster_resources_with_http_info(self, item_id, **kwargs):  # noqa: E501
        """List thumbnail resources for an item  # noqa: E501

        Return one or more poster resource URIs which can be used to manage the posters for a specific item.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_item_poster_resources_with_http_info(item_id, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str item_id: The item id. (required)
        :key int version: Return posters from this essence version.  By default posters for the latest version will be returned.
        :key _return_http_data_only: response data without head status code
                                       and headers
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(URIListType, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['item_id', 'version']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_item_poster_resources" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'item_id' is set
        if ('item_id' not in local_var_params or
                local_var_params['item_id'] is None):
            raise ApiValueError("Missing the required parameter `item_id` when calling `get_item_poster_resources`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'item_id' in local_var_params:
            path_params['item-id'] = local_var_params['item_id']  # noqa: E501

        query_params = []
        if 'version' in local_var_params:
            query_params.append(('version', local_var_params['version']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'text/plain', 'application/xml'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/item/{item-id}/posterresource', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='URIListType',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_item_search_history(self, **kwargs):  # noqa: E501
        """Retrieve search history  # noqa: E501

        Retrieves a list of searches made by a particular user, including \"item search\" and \"Item and collection search\". The results are ordered according to timestamp, with the latest searches being first. Duplicate queries will not be retrieved.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_item_search_history(async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :key int max_results: The maximum number of searches that will be retrieved.  The value must be between `1` and `50`.
        :key str username: The name of the user that has performed the searched.  If not specified, the user performing the request will be selected.
        :key str start: An ISO 8601 date.  If set, only searches made after this date will be retrieved.
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: SearchHistoryListType.
                 If the method is called asynchronously, returns the request thread.
        :rtype: SearchHistoryListType or multiprocessing.pool.AsyncResult
        """
        kwargs['_return_http_data_only'] = True
        return self.get_item_search_history_with_http_info(**kwargs)  # noqa: E501

    def get_item_search_history_with_http_info(self, **kwargs):  # noqa: E501
        """Retrieve search history  # noqa: E501

        Retrieves a list of searches made by a particular user, including \"item search\" and \"Item and collection search\". The results are ordered according to timestamp, with the latest searches being first. Duplicate queries will not be retrieved.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_item_search_history_with_http_info(async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :key int max_results: The maximum number of searches that will be retrieved.  The value must be between `1` and `50`.
        :key str username: The name of the user that has performed the searched.  If not specified, the user performing the request will be selected.
        :key str start: An ISO 8601 date.  If set, only searches made after this date will be retrieved.
        :key _return_http_data_only: response data without head status code
                                       and headers
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(SearchHistoryListType, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['max_results', 'username', 'start']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_item_search_history" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'max_results' in local_var_params:
            query_params.append(('maxResults', local_var_params['max_results']))  # noqa: E501
        if 'username' in local_var_params:
            query_params.append(('username', local_var_params['username']))  # noqa: E501
        if 'start' in local_var_params:
            query_params.append(('start', local_var_params['start']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'application/xml'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/item/history', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SearchHistoryListType',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_item_thumbnail_resources(self, item_id, **kwargs):  # noqa: E501
        """List thumbnail resources for an item  # noqa: E501

        Return one or more poster resource URIs which can be used to manage the thumbnails for a specific item.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_item_thumbnail_resources(item_id, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str item_id: The item id. (required)
        :key int version: Return thumbnails from this essence version.  By default thumbnails for the latest version will be returned.
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: URIListType.
                 If the method is called asynchronously, returns the request thread.
        :rtype: URIListType or multiprocessing.pool.AsyncResult
        """
        kwargs['_return_http_data_only'] = True
        return self.get_item_thumbnail_resources_with_http_info(item_id, **kwargs)  # noqa: E501

    def get_item_thumbnail_resources_with_http_info(self, item_id, **kwargs):  # noqa: E501
        """List thumbnail resources for an item  # noqa: E501

        Return one or more poster resource URIs which can be used to manage the thumbnails for a specific item.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_item_thumbnail_resources_with_http_info(item_id, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str item_id: The item id. (required)
        :key int version: Return thumbnails from this essence version.  By default thumbnails for the latest version will be returned.
        :key _return_http_data_only: response data without head status code
                                       and headers
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(URIListType, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['item_id', 'version']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_item_thumbnail_resources" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'item_id' is set
        if ('item_id' not in local_var_params or
                local_var_params['item_id'] is None):
            raise ApiValueError("Missing the required parameter `item_id` when calling `get_item_thumbnail_resources`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'item_id' in local_var_params:
            path_params['item-id'] = local_var_params['item_id']  # noqa: E501

        query_params = []
        if 'version' in local_var_params:
            query_params.append(('version', local_var_params['version']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'text/plain', 'application/xml'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/item/{item-id}/thumbnailresource', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='URIListType',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_item_ur_is(self, item_id, **kwargs):  # noqa: E501
        """Get item URI  # noqa: E501

        Retrieves the URI to any container contained in the item that matches the specified type or the files contained in a shape that matches the given tags.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_item_ur_is(item_id, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str item_id: The item id. (required)
        :key str storage_type: Only return URIs for files from storages of this type.
        :key list[str] tag: Comma-separated list of shape tags to return.
        :key list[str] type: Comma-separated list of format types (container format) to return.
        :key bool closed_files: - `true` (default) - Return only URIs that point to closed files.  - `false` - Return all URIs.
        :key str method_metadata: Metadata used with storage method.
        :key str scheme: URI scheme to return, e. g.  `ftp`.
        :key str method_type: Access method.   - `AUTO` - Gives an APInoauth URI to the media.  Access to file is tunneled through Vidispine.  - `AZURE_SAS` - If the storage schema is azure:// you can get direct access to the media.  The resulting URI will not tunnel through Vidispine but rather point directly to the media location at the azure storage.
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: URIListType.
                 If the method is called asynchronously, returns the request thread.
        :rtype: URIListType or multiprocessing.pool.AsyncResult
        """
        kwargs['_return_http_data_only'] = True
        return self.get_item_ur_is_with_http_info(item_id, **kwargs)  # noqa: E501

    def get_item_ur_is_with_http_info(self, item_id, **kwargs):  # noqa: E501
        """Get item URI  # noqa: E501

        Retrieves the URI to any container contained in the item that matches the specified type or the files contained in a shape that matches the given tags.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_item_ur_is_with_http_info(item_id, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str item_id: The item id. (required)
        :key str storage_type: Only return URIs for files from storages of this type.
        :key list[str] tag: Comma-separated list of shape tags to return.
        :key list[str] type: Comma-separated list of format types (container format) to return.
        :key bool closed_files: - `true` (default) - Return only URIs that point to closed files.  - `false` - Return all URIs.
        :key str method_metadata: Metadata used with storage method.
        :key str scheme: URI scheme to return, e. g.  `ftp`.
        :key str method_type: Access method.   - `AUTO` - Gives an APInoauth URI to the media.  Access to file is tunneled through Vidispine.  - `AZURE_SAS` - If the storage schema is azure:// you can get direct access to the media.  The resulting URI will not tunnel through Vidispine but rather point directly to the media location at the azure storage.
        :key _return_http_data_only: response data without head status code
                                       and headers
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(URIListType, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['item_id', 'storage_type', 'tag', 'type', 'closed_files', 'method_metadata', 'scheme', 'method_type']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_item_ur_is" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'item_id' is set
        if ('item_id' not in local_var_params or
                local_var_params['item_id'] is None):
            raise ApiValueError("Missing the required parameter `item_id` when calling `get_item_ur_is`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'item_id' in local_var_params:
            path_params['item-id'] = local_var_params['item_id']  # noqa: E501

        query_params = []
        if 'storage_type' in local_var_params:
            query_params.append(('storageType', local_var_params['storage_type']))  # noqa: E501
        if 'tag' in local_var_params:
            query_params.append(('tag', local_var_params['tag']))  # noqa: E501
            collection_formats['tag'] = 'csv'  # noqa: E501
        if 'type' in local_var_params:
            query_params.append(('type', local_var_params['type']))  # noqa: E501
            collection_formats['type'] = 'csv'  # noqa: E501
        if 'closed_files' in local_var_params:
            query_params.append(('closedFiles', local_var_params['closed_files']))  # noqa: E501
        if 'method_metadata' in local_var_params:
            query_params.append(('methodMetadata', local_var_params['method_metadata']))  # noqa: E501
        if 'scheme' in local_var_params:
            query_params.append(('scheme', local_var_params['scheme']))  # noqa: E501
        if 'method_type' in local_var_params:
            query_params.append(('methodType', local_var_params['method_type']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'application/xml'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/item/{item-id}/uri', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='URIListType',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_items(self, **kwargs):  # noqa: E501
        """List all items  # noqa: E501

        Returns a list of all items. This request is the same as performing an empty search.  Note that searching can also be performed by using the HTTP method PUT using the same syntax, except for the parameter `q` is omitted and the *ItemSearchDocument* is sent in the body of the request.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_items(async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :key list[str] language: Comma-separated list.   - *language-tag* - Return metadata for specific language, e. g.  `en_US`.  Wildcards may be used, e. g.  `*_CA` for both Canadian French and Canadian English.  - `none` - Return all metadata without language specification.  - `all` (default) - Return all metadata, with or without language specification.
        :key str storage_type: Only return URIs for files from storages of this type.
        :key int first: From the resulting list of items, start return list from specified offset.
        :key bool closed_files: A URI parameter:  - `true` (default) - Return only URIs that point to closed files.  - `false` - Return all URIs.
        :key str terse: - `yes` - Return metadata in terse format.  - `no` (default) - Return metadata in verbose format.
        :key str method_metadata: Metadata used with storage method.
        :key str update_frequency: When creating a library, use this update frequency.  Defaults to no periodic updates.
        :key int number: The number of entities to fetch.
        :key list[str] interval: Comma-separated list  - *time-span* - Filter out metadata, return only metadata for specified time span.  - `generic` - Return all non-timed metadata.  - `all` (default) - Return all metadata, same as `interval=generic,-INF-+INF`
        :key list[str] group: Comma-separated list.   - *group-name* - Return specified group.  - *group-name* `+` - Return specified group and subgroups.  - *group-name* `:` *new-name* - Return specified group, renamed to a new name in return value.  - `-` *group-name* - Exclude specified group.  - (default) - Return all groups.
        :key str merged_permission: The lowest required permission level.
        :key str storage_group: Storage group id.  Return only files from storages specified in the storage group.
        :key list[str] track: Comma-separated list.   - *track-type* *track-number* - Return metadata for specified track.  Example of track is `A2`.  - *track-type* *t1* `-` *t2* - Return metadata for specified track interval, e. g.  `A2-4`.  - *track-type* `*` - Return metadata for all tracks of specified type, e. g.  `A*`.  - `generic` - Return all non-tracked metadata.  - `all` (default) - All metadata, with or without track specification, are returned.
        :key str conflict: - `yes` (default) - Include all metadata conflicts, unresolved.  - `no` - Return conflicts resolved according to field rules.
        :key bool starttc: - `true` - Interval is given relative to start timecode of item.  - `false` (default) - Interval is 0-based.
        :key list[str] content: Comma-separated list of the types of content to retrieve.
        :key list[str] uri_type: Comma-separated list of format types (container format) to return.
        :key bool include_transient_metadata: - `true` (default) - Include transient metadata.  - `false` - Do not include transient metadata in response.
        :key str merged_type: The type of operation to check for.
        :key bool default_value: - `true` - For unset fields, return default values.  - `false` (default) - Do not return default values.
        :key str tag: A URI parameter: Comma-separated list of shape tags to return.
        :key list[str] field: Comma-separated list.   - *field-name* - Return specified field.  - *field-name* \":\" *new-name* - Return specified field, renamed to a new name in return value.  - \"-\" *field-name* - Exclude specified field.  - (default) - Return all fields.
        :key str include: A list of keys.   Includes additional field specific data.  Additionally, if set to `type` the type definition of the field will be retrieved.
        :key str method_type: Access method.   - `AUTO` - Gives an APInoauth URI to the media.  Access to file is tunneled through Vidispine.  - `AZURE_SAS` - If the storage schema is azure:// you can get direct access to the media.  The resulting URI will not tunnel through Vidispine but rather point directly to the media location at the azure storage.
        :key str q: XML/JSON, *ItemSearchDocument*.  Only with GET.
        :key list[str] p: Comma-separated list of paths specifying the content to include.  Overrides the content and filter parameters.
        :key str library: Restricts search to within library, identifier.
        :key str base_uri: Which base URI to use for the thumbnail URLs.
        :key str merged_extradata: Any possible extra data.
        :key str result: - `list` (default) - Return a list of items.  - `library` - Create a library with the matching items.
        :key list[str] storage: List of storage ids.  Return only files from specific storages.  Can be specified multiple times.
        :key str revision: Specifying which metadata revision to display.  Only used if requesting a single item or collection.
        :key bool url: - `true` - Return list of URLs.  - `false` (default) - Return list of ids.
        :key str scheme: URI scheme to return.
        :key bool auto_refresh: When creating a library, make it self-refresh.
        :key str version: Specifying which essence version to return for shapes.  If special value `all`, display all versions.  If special value `latest` (default), display latest version of shapes.
        :key str cursor: New in version 4. 16.   - `*` - The initial cursor.  - `string-from-search` - Cursor string returned from the search results.  If set, the cursorMark / search after features from Solr/Elasticsearch would be used to improve the deep paging  performance during a search.  When `cursor` is used, The value of `first` will be ignored.  Only metadata searches in the `generic` interval supports `cursor`.
        :key bool include_values: Return the value enumeration for each metadata field.
        :key str sample_rate: Convert all outgoing time instants to specified rate.  *NB!* Time codes which cannot be expressed in an integer number of samples will be returned as a decimal number, with risk of losing precision.
        :key str library_id: If set, the library identified by this id will be used instead of creating a new library.
        :key bool count: - `true` (default) - Return hits in result.  - `false` - Do not return hits in result, in order to produce results faster.
        :key bool save: - `true` - Returns a `303 See Other`, with a `Location` header containing an URI to fetch the search result - `false` (default) - Returns a regular search result
        :key bool noauth_url: - `true` Return URIs that do not need authentication.  - `false` (default) Return normal URIs
        :key str update_mode: When creating a library, use this update mode.
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: ItemListType.
                 If the method is called asynchronously, returns the request thread.
        :rtype: ItemListType or multiprocessing.pool.AsyncResult
        """
        kwargs['_return_http_data_only'] = True
        return self.get_items_with_http_info(**kwargs)  # noqa: E501

    def get_items_with_http_info(self, **kwargs):  # noqa: E501
        """List all items  # noqa: E501

        Returns a list of all items. This request is the same as performing an empty search.  Note that searching can also be performed by using the HTTP method PUT using the same syntax, except for the parameter `q` is omitted and the *ItemSearchDocument* is sent in the body of the request.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_items_with_http_info(async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :key list[str] language: Comma-separated list.   - *language-tag* - Return metadata for specific language, e. g.  `en_US`.  Wildcards may be used, e. g.  `*_CA` for both Canadian French and Canadian English.  - `none` - Return all metadata without language specification.  - `all` (default) - Return all metadata, with or without language specification.
        :key str storage_type: Only return URIs for files from storages of this type.
        :key int first: From the resulting list of items, start return list from specified offset.
        :key bool closed_files: A URI parameter:  - `true` (default) - Return only URIs that point to closed files.  - `false` - Return all URIs.
        :key str terse: - `yes` - Return metadata in terse format.  - `no` (default) - Return metadata in verbose format.
        :key str method_metadata: Metadata used with storage method.
        :key str update_frequency: When creating a library, use this update frequency.  Defaults to no periodic updates.
        :key int number: The number of entities to fetch.
        :key list[str] interval: Comma-separated list  - *time-span* - Filter out metadata, return only metadata for specified time span.  - `generic` - Return all non-timed metadata.  - `all` (default) - Return all metadata, same as `interval=generic,-INF-+INF`
        :key list[str] group: Comma-separated list.   - *group-name* - Return specified group.  - *group-name* `+` - Return specified group and subgroups.  - *group-name* `:` *new-name* - Return specified group, renamed to a new name in return value.  - `-` *group-name* - Exclude specified group.  - (default) - Return all groups.
        :key str merged_permission: The lowest required permission level.
        :key str storage_group: Storage group id.  Return only files from storages specified in the storage group.
        :key list[str] track: Comma-separated list.   - *track-type* *track-number* - Return metadata for specified track.  Example of track is `A2`.  - *track-type* *t1* `-` *t2* - Return metadata for specified track interval, e. g.  `A2-4`.  - *track-type* `*` - Return metadata for all tracks of specified type, e. g.  `A*`.  - `generic` - Return all non-tracked metadata.  - `all` (default) - All metadata, with or without track specification, are returned.
        :key str conflict: - `yes` (default) - Include all metadata conflicts, unresolved.  - `no` - Return conflicts resolved according to field rules.
        :key bool starttc: - `true` - Interval is given relative to start timecode of item.  - `false` (default) - Interval is 0-based.
        :key list[str] content: Comma-separated list of the types of content to retrieve.
        :key list[str] uri_type: Comma-separated list of format types (container format) to return.
        :key bool include_transient_metadata: - `true` (default) - Include transient metadata.  - `false` - Do not include transient metadata in response.
        :key str merged_type: The type of operation to check for.
        :key bool default_value: - `true` - For unset fields, return default values.  - `false` (default) - Do not return default values.
        :key str tag: A URI parameter: Comma-separated list of shape tags to return.
        :key list[str] field: Comma-separated list.   - *field-name* - Return specified field.  - *field-name* \":\" *new-name* - Return specified field, renamed to a new name in return value.  - \"-\" *field-name* - Exclude specified field.  - (default) - Return all fields.
        :key str include: A list of keys.   Includes additional field specific data.  Additionally, if set to `type` the type definition of the field will be retrieved.
        :key str method_type: Access method.   - `AUTO` - Gives an APInoauth URI to the media.  Access to file is tunneled through Vidispine.  - `AZURE_SAS` - If the storage schema is azure:// you can get direct access to the media.  The resulting URI will not tunnel through Vidispine but rather point directly to the media location at the azure storage.
        :key str q: XML/JSON, *ItemSearchDocument*.  Only with GET.
        :key list[str] p: Comma-separated list of paths specifying the content to include.  Overrides the content and filter parameters.
        :key str library: Restricts search to within library, identifier.
        :key str base_uri: Which base URI to use for the thumbnail URLs.
        :key str merged_extradata: Any possible extra data.
        :key str result: - `list` (default) - Return a list of items.  - `library` - Create a library with the matching items.
        :key list[str] storage: List of storage ids.  Return only files from specific storages.  Can be specified multiple times.
        :key str revision: Specifying which metadata revision to display.  Only used if requesting a single item or collection.
        :key bool url: - `true` - Return list of URLs.  - `false` (default) - Return list of ids.
        :key str scheme: URI scheme to return.
        :key bool auto_refresh: When creating a library, make it self-refresh.
        :key str version: Specifying which essence version to return for shapes.  If special value `all`, display all versions.  If special value `latest` (default), display latest version of shapes.
        :key str cursor: New in version 4. 16.   - `*` - The initial cursor.  - `string-from-search` - Cursor string returned from the search results.  If set, the cursorMark / search after features from Solr/Elasticsearch would be used to improve the deep paging  performance during a search.  When `cursor` is used, The value of `first` will be ignored.  Only metadata searches in the `generic` interval supports `cursor`.
        :key bool include_values: Return the value enumeration for each metadata field.
        :key str sample_rate: Convert all outgoing time instants to specified rate.  *NB!* Time codes which cannot be expressed in an integer number of samples will be returned as a decimal number, with risk of losing precision.
        :key str library_id: If set, the library identified by this id will be used instead of creating a new library.
        :key bool count: - `true` (default) - Return hits in result.  - `false` - Do not return hits in result, in order to produce results faster.
        :key bool save: - `true` - Returns a `303 See Other`, with a `Location` header containing an URI to fetch the search result - `false` (default) - Returns a regular search result
        :key bool noauth_url: - `true` Return URIs that do not need authentication.  - `false` (default) Return normal URIs
        :key str update_mode: When creating a library, use this update mode.
        :key _return_http_data_only: response data without head status code
                                       and headers
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(ItemListType, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['language', 'storage_type', 'first', 'closed_files', 'terse', 'method_metadata', 'update_frequency', 'number', 'interval', 'group', 'merged_permission', 'storage_group', 'track', 'conflict', 'starttc', 'content', 'uri_type', 'include_transient_metadata', 'merged_type', 'default_value', 'tag', 'field', 'include', 'method_type', 'q', 'p', 'library', 'base_uri', 'merged_extradata', 'result', 'storage', 'revision', 'url', 'scheme', 'auto_refresh', 'version', 'cursor', 'include_values', 'sample_rate', 'library_id', 'count', 'save', 'noauth_url', 'update_mode']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_items" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'language' in local_var_params:
            query_params.append(('language', local_var_params['language']))  # noqa: E501
            collection_formats['language'] = 'csv'  # noqa: E501
        if 'storage_type' in local_var_params:
            query_params.append(('storageType', local_var_params['storage_type']))  # noqa: E501
        if 'first' in local_var_params:
            query_params.append(('first', local_var_params['first']))  # noqa: E501
        if 'closed_files' in local_var_params:
            query_params.append(('closedFiles', local_var_params['closed_files']))  # noqa: E501
        if 'terse' in local_var_params:
            query_params.append(('terse', local_var_params['terse']))  # noqa: E501
        if 'method_metadata' in local_var_params:
            query_params.append(('methodMetadata', local_var_params['method_metadata']))  # noqa: E501
        if 'update_frequency' in local_var_params:
            query_params.append(('updateFrequency', local_var_params['update_frequency']))  # noqa: E501
        if 'number' in local_var_params:
            query_params.append(('number', local_var_params['number']))  # noqa: E501
        if 'interval' in local_var_params:
            query_params.append(('interval', local_var_params['interval']))  # noqa: E501
            collection_formats['interval'] = 'csv'  # noqa: E501
        if 'group' in local_var_params:
            query_params.append(('group', local_var_params['group']))  # noqa: E501
            collection_formats['group'] = 'csv'  # noqa: E501
        if 'merged_permission' in local_var_params:
            query_params.append(('mergedPermission', local_var_params['merged_permission']))  # noqa: E501
        if 'storage_group' in local_var_params:
            query_params.append(('storageGroup', local_var_params['storage_group']))  # noqa: E501
        if 'track' in local_var_params:
            query_params.append(('track', local_var_params['track']))  # noqa: E501
            collection_formats['track'] = 'csv'  # noqa: E501
        if 'conflict' in local_var_params:
            query_params.append(('conflict', local_var_params['conflict']))  # noqa: E501
        if 'starttc' in local_var_params:
            query_params.append(('starttc', local_var_params['starttc']))  # noqa: E501
        if 'content' in local_var_params:
            query_params.append(('content', local_var_params['content']))  # noqa: E501
            collection_formats['content'] = 'csv'  # noqa: E501
        if 'uri_type' in local_var_params:
            query_params.append(('uriType', local_var_params['uri_type']))  # noqa: E501
            collection_formats['uriType'] = 'csv'  # noqa: E501
        if 'include_transient_metadata' in local_var_params:
            query_params.append(('includeTransientMetadata', local_var_params['include_transient_metadata']))  # noqa: E501
        if 'merged_type' in local_var_params:
            query_params.append(('mergedType', local_var_params['merged_type']))  # noqa: E501
        if 'default_value' in local_var_params:
            query_params.append(('defaultValue', local_var_params['default_value']))  # noqa: E501
        if 'tag' in local_var_params:
            query_params.append(('tag', local_var_params['tag']))  # noqa: E501
        if 'field' in local_var_params:
            query_params.append(('field', local_var_params['field']))  # noqa: E501
            collection_formats['field'] = 'csv'  # noqa: E501
        if 'include' in local_var_params:
            query_params.append(('include', local_var_params['include']))  # noqa: E501
        if 'method_type' in local_var_params:
            query_params.append(('methodType', local_var_params['method_type']))  # noqa: E501
        if 'q' in local_var_params:
            query_params.append(('q', local_var_params['q']))  # noqa: E501
        if 'p' in local_var_params:
            query_params.append(('p', local_var_params['p']))  # noqa: E501
            collection_formats['p'] = 'csv'  # noqa: E501
        if 'library' in local_var_params:
            query_params.append(('library', local_var_params['library']))  # noqa: E501
        if 'base_uri' in local_var_params:
            query_params.append(('baseURI', local_var_params['base_uri']))  # noqa: E501
        if 'merged_extradata' in local_var_params:
            query_params.append(('mergedExtradata', local_var_params['merged_extradata']))  # noqa: E501
        if 'result' in local_var_params:
            query_params.append(('result', local_var_params['result']))  # noqa: E501
        if 'storage' in local_var_params:
            query_params.append(('storage', local_var_params['storage']))  # noqa: E501
            collection_formats['storage'] = 'multi'  # noqa: E501
        if 'revision' in local_var_params:
            query_params.append(('revision', local_var_params['revision']))  # noqa: E501
        if 'url' in local_var_params:
            query_params.append(('url', local_var_params['url']))  # noqa: E501
        if 'scheme' in local_var_params:
            query_params.append(('scheme', local_var_params['scheme']))  # noqa: E501
        if 'auto_refresh' in local_var_params:
            query_params.append(('autoRefresh', local_var_params['auto_refresh']))  # noqa: E501
        if 'version' in local_var_params:
            query_params.append(('version', local_var_params['version']))  # noqa: E501
        if 'cursor' in local_var_params:
            query_params.append(('cursor', local_var_params['cursor']))  # noqa: E501
        if 'include_values' in local_var_params:
            query_params.append(('includeValues', local_var_params['include_values']))  # noqa: E501
        if 'sample_rate' in local_var_params:
            query_params.append(('sampleRate', local_var_params['sample_rate']))  # noqa: E501
        if 'library_id' in local_var_params:
            query_params.append(('libraryId', local_var_params['library_id']))  # noqa: E501
        if 'count' in local_var_params:
            query_params.append(('count', local_var_params['count']))  # noqa: E501
        if 'save' in local_var_params:
            query_params.append(('save', local_var_params['save']))  # noqa: E501
        if 'noauth_url' in local_var_params:
            query_params.append(('noauth-url', local_var_params['noauth_url']))  # noqa: E501
        if 'update_mode' in local_var_params:
            query_params.append(('updateMode', local_var_params['update_mode']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'text/plain', 'application/xml'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/item', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ItemListType',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_libraries_containing_item(self, item_id, **kwargs):  # noqa: E501
        """List libraries that contain an item  # noqa: E501

        Retrieves the ids of all libraries that includes the item, and that the calling user has read access to.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_libraries_containing_item(item_id, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str item_id: The item id. (required)
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: URIListType.
                 If the method is called asynchronously, returns the request thread.
        :rtype: URIListType or multiprocessing.pool.AsyncResult
        """
        kwargs['_return_http_data_only'] = True
        return self.get_libraries_containing_item_with_http_info(item_id, **kwargs)  # noqa: E501

    def get_libraries_containing_item_with_http_info(self, item_id, **kwargs):  # noqa: E501
        """List libraries that contain an item  # noqa: E501

        Retrieves the ids of all libraries that includes the item, and that the calling user has read access to.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_libraries_containing_item_with_http_info(item_id, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str item_id: The item id. (required)
        :key _return_http_data_only: response data without head status code
                                       and headers
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(URIListType, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['item_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_libraries_containing_item" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'item_id' is set
        if ('item_id' not in local_var_params or
                local_var_params['item_id'] is None):
            raise ApiValueError("Missing the required parameter `item_id` when calling `get_libraries_containing_item`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'item_id' in local_var_params:
            path_params['item-id'] = local_var_params['item_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'text/plain', 'application/xml'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/item/{item-id}/library', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='URIListType',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def reindex_item(self, item_id, **kwargs):  # noqa: E501
        """Re-index item  # noqa: E501

        Queues a single item for re-index.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.reindex_item(item_id, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str item_id: The item id. (required)
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: str.
                 If the method is called asynchronously, returns the request thread.
        :rtype: str or multiprocessing.pool.AsyncResult
        """
        kwargs['_return_http_data_only'] = True
        return self.reindex_item_with_http_info(item_id, **kwargs)  # noqa: E501

    def reindex_item_with_http_info(self, item_id, **kwargs):  # noqa: E501
        """Re-index item  # noqa: E501

        Queues a single item for re-index.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.reindex_item_with_http_info(item_id, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str item_id: The item id. (required)
        :key _return_http_data_only: response data without head status code
                                       and headers
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(str, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['item_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method reindex_item" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'item_id' is set
        if ('item_id' not in local_var_params or
                local_var_params['item_id'] is None):
            raise ApiValueError("Missing the required parameter `item_id` when calling `reindex_item`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'item_id' in local_var_params:
            path_params['item-id'] = local_var_params['item_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/item/{item-id}/re-index', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='str',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def search_items(self, item_search_type, **kwargs):  # noqa: E501
        """Search items  # noqa: E501

        Performs an item search. If the `result` query parameter is set to `library` a new library is created, which can be used to further refine the search, using the `library` parameter.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.search_items(item_search_type, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param ItemSearchType item_search_type: (required)
        :key list[str] language: Comma-separated list.   - *language-tag* - Return metadata for specific language, e. g.  `en_US`.  Wildcards may be used, e. g.  `*_CA` for both Canadian French and Canadian English.  - `none` - Return all metadata without language specification.  - `all` (default) - Return all metadata, with or without language specification.
        :key str storage_type: Only return URIs for files from storages of this type.
        :key int first: From the resulting list of items, start return list from specified offset.
        :key bool closed_files: A URI parameter:  - `true` (default) - Return only URIs that point to closed files.  - `false` - Return all URIs.
        :key str terse: - `yes` - Return metadata in terse format.  - `no` (default) - Return metadata in verbose format.
        :key str method_metadata: Metadata used with storage method.
        :key str update_frequency: When creating a library, use this update frequency.  Defaults to no periodic updates.
        :key int number: The number of entities to fetch.
        :key list[str] interval: Comma-separated list  - *time-span* - Filter out metadata, return only metadata for specified time span.  - `generic` - Return all non-timed metadata.  - `all` (default) - Return all metadata, same as `interval=generic,-INF-+INF`
        :key list[str] group: Comma-separated list.   - *group-name* - Return specified group.  - *group-name* `+` - Return specified group and subgroups.  - *group-name* `:` *new-name* - Return specified group, renamed to a new name in return value.  - `-` *group-name* - Exclude specified group.  - (default) - Return all groups.
        :key str merged_permission: The lowest required permission level.
        :key str storage_group: Storage group id.  Return only files from storages specified in the storage group.
        :key list[str] track: Comma-separated list.   - *track-type* *track-number* - Return metadata for specified track.  Example of track is `A2`.  - *track-type* *t1* `-` *t2* - Return metadata for specified track interval, e. g.  `A2-4`.  - *track-type* `*` - Return metadata for all tracks of specified type, e. g.  `A*`.  - `generic` - Return all non-tracked metadata.  - `all` (default) - All metadata, with or without track specification, are returned.
        :key str conflict: - `yes` (default) - Include all metadata conflicts, unresolved.  - `no` - Return conflicts resolved according to field rules.
        :key bool starttc: - `true` - Interval is given relative to start timecode of item.  - `false` (default) - Interval is 0-based.
        :key list[str] content: Comma-separated list of the types of content to retrieve.
        :key list[str] uri_type: Comma-separated list of format types (container format) to return.
        :key bool include_transient_metadata: - `true` (default) - Include transient metadata.  - `false` - Do not include transient metadata in response.
        :key str merged_type: The type of operation to check for.
        :key bool default_value: - `true` - For unset fields, return default values.  - `false` (default) - Do not return default values.
        :key str tag: A URI parameter: Comma-separated list of shape tags to return.
        :key list[str] field: Comma-separated list.   - *field-name* - Return specified field.  - *field-name* \":\" *new-name* - Return specified field, renamed to a new name in return value.  - \"-\" *field-name* - Exclude specified field.  - (default) - Return all fields.
        :key str include: A list of keys.   Includes additional field specific data.  Additionally, if set to `type` the type definition of the field will be retrieved.
        :key str method_type: Access method.   - `AUTO` - Gives an APInoauth URI to the media.  Access to file is tunneled through Vidispine.  - `AZURE_SAS` - If the storage schema is azure:// you can get direct access to the media.  The resulting URI will not tunnel through Vidispine but rather point directly to the media location at the azure storage.
        :key str q: XML/JSON, *ItemSearchDocument*.  Only with GET.
        :key list[str] p: Comma-separated list of paths specifying the content to include.  Overrides the content and filter parameters.
        :key str library: Restricts search to within library, identifier.
        :key str base_uri: Which base URI to use for the thumbnail URLs.
        :key str merged_extradata: Any possible extra data.
        :key str result: - `list` (default) - Return a list of items.  - `library` - Create a library with the matching items.
        :key list[str] storage: List of storage ids.  Return only files from specific storages.  Can be specified multiple times.
        :key str revision: Specifying which metadata revision to display.  Only used if requesting a single item or collection.
        :key bool url: - `true` - Return list of URLs.  - `false` (default) - Return list of ids.
        :key str scheme: URI scheme to return.
        :key bool auto_refresh: When creating a library, make it self-refresh.
        :key str version: Specifying which essence version to return for shapes.  If special value `all`, display all versions.  If special value `latest` (default), display latest version of shapes.
        :key str cursor: New in version 4. 16.   - `*` - The initial cursor.  - `string-from-search` - Cursor string returned from the search results.  If set, the cursorMark / search after features from Solr/Elasticsearch would be used to improve the deep paging  performance during a search.  When `cursor` is used, The value of `first` will be ignored.  Only metadata searches in the `generic` interval supports `cursor`.
        :key bool include_values: Return the value enumeration for each metadata field.
        :key str sample_rate: Convert all outgoing time instants to specified rate.  *NB!* Time codes which cannot be expressed in an integer number of samples will be returned as a decimal number, with risk of losing precision.
        :key str library_id: If set, the library identified by this id will be used instead of creating a new library.
        :key bool count: - `true` (default) - Return hits in result.  - `false` - Do not return hits in result, in order to produce results faster.
        :key bool save: - `true` - Returns a `303 See Other`, with a `Location` header containing an URI to fetch the search result - `false` (default) - Returns a regular search result
        :key bool noauth_url: - `true` Return URIs that do not need authentication.  - `false` (default) Return normal URIs
        :key str update_mode: When creating a library, use this update mode.
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: ItemListType.
                 If the method is called asynchronously, returns the request thread.
        :rtype: ItemListType or multiprocessing.pool.AsyncResult
        """
        kwargs['_return_http_data_only'] = True
        return self.search_items_with_http_info(item_search_type, **kwargs)  # noqa: E501

    def search_items_with_http_info(self, item_search_type, **kwargs):  # noqa: E501
        """Search items  # noqa: E501

        Performs an item search. If the `result` query parameter is set to `library` a new library is created, which can be used to further refine the search, using the `library` parameter.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.search_items_with_http_info(item_search_type, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param ItemSearchType item_search_type: (required)
        :key list[str] language: Comma-separated list.   - *language-tag* - Return metadata for specific language, e. g.  `en_US`.  Wildcards may be used, e. g.  `*_CA` for both Canadian French and Canadian English.  - `none` - Return all metadata without language specification.  - `all` (default) - Return all metadata, with or without language specification.
        :key str storage_type: Only return URIs for files from storages of this type.
        :key int first: From the resulting list of items, start return list from specified offset.
        :key bool closed_files: A URI parameter:  - `true` (default) - Return only URIs that point to closed files.  - `false` - Return all URIs.
        :key str terse: - `yes` - Return metadata in terse format.  - `no` (default) - Return metadata in verbose format.
        :key str method_metadata: Metadata used with storage method.
        :key str update_frequency: When creating a library, use this update frequency.  Defaults to no periodic updates.
        :key int number: The number of entities to fetch.
        :key list[str] interval: Comma-separated list  - *time-span* - Filter out metadata, return only metadata for specified time span.  - `generic` - Return all non-timed metadata.  - `all` (default) - Return all metadata, same as `interval=generic,-INF-+INF`
        :key list[str] group: Comma-separated list.   - *group-name* - Return specified group.  - *group-name* `+` - Return specified group and subgroups.  - *group-name* `:` *new-name* - Return specified group, renamed to a new name in return value.  - `-` *group-name* - Exclude specified group.  - (default) - Return all groups.
        :key str merged_permission: The lowest required permission level.
        :key str storage_group: Storage group id.  Return only files from storages specified in the storage group.
        :key list[str] track: Comma-separated list.   - *track-type* *track-number* - Return metadata for specified track.  Example of track is `A2`.  - *track-type* *t1* `-` *t2* - Return metadata for specified track interval, e. g.  `A2-4`.  - *track-type* `*` - Return metadata for all tracks of specified type, e. g.  `A*`.  - `generic` - Return all non-tracked metadata.  - `all` (default) - All metadata, with or without track specification, are returned.
        :key str conflict: - `yes` (default) - Include all metadata conflicts, unresolved.  - `no` - Return conflicts resolved according to field rules.
        :key bool starttc: - `true` - Interval is given relative to start timecode of item.  - `false` (default) - Interval is 0-based.
        :key list[str] content: Comma-separated list of the types of content to retrieve.
        :key list[str] uri_type: Comma-separated list of format types (container format) to return.
        :key bool include_transient_metadata: - `true` (default) - Include transient metadata.  - `false` - Do not include transient metadata in response.
        :key str merged_type: The type of operation to check for.
        :key bool default_value: - `true` - For unset fields, return default values.  - `false` (default) - Do not return default values.
        :key str tag: A URI parameter: Comma-separated list of shape tags to return.
        :key list[str] field: Comma-separated list.   - *field-name* - Return specified field.  - *field-name* \":\" *new-name* - Return specified field, renamed to a new name in return value.  - \"-\" *field-name* - Exclude specified field.  - (default) - Return all fields.
        :key str include: A list of keys.   Includes additional field specific data.  Additionally, if set to `type` the type definition of the field will be retrieved.
        :key str method_type: Access method.   - `AUTO` - Gives an APInoauth URI to the media.  Access to file is tunneled through Vidispine.  - `AZURE_SAS` - If the storage schema is azure:// you can get direct access to the media.  The resulting URI will not tunnel through Vidispine but rather point directly to the media location at the azure storage.
        :key str q: XML/JSON, *ItemSearchDocument*.  Only with GET.
        :key list[str] p: Comma-separated list of paths specifying the content to include.  Overrides the content and filter parameters.
        :key str library: Restricts search to within library, identifier.
        :key str base_uri: Which base URI to use for the thumbnail URLs.
        :key str merged_extradata: Any possible extra data.
        :key str result: - `list` (default) - Return a list of items.  - `library` - Create a library with the matching items.
        :key list[str] storage: List of storage ids.  Return only files from specific storages.  Can be specified multiple times.
        :key str revision: Specifying which metadata revision to display.  Only used if requesting a single item or collection.
        :key bool url: - `true` - Return list of URLs.  - `false` (default) - Return list of ids.
        :key str scheme: URI scheme to return.
        :key bool auto_refresh: When creating a library, make it self-refresh.
        :key str version: Specifying which essence version to return for shapes.  If special value `all`, display all versions.  If special value `latest` (default), display latest version of shapes.
        :key str cursor: New in version 4. 16.   - `*` - The initial cursor.  - `string-from-search` - Cursor string returned from the search results.  If set, the cursorMark / search after features from Solr/Elasticsearch would be used to improve the deep paging  performance during a search.  When `cursor` is used, The value of `first` will be ignored.  Only metadata searches in the `generic` interval supports `cursor`.
        :key bool include_values: Return the value enumeration for each metadata field.
        :key str sample_rate: Convert all outgoing time instants to specified rate.  *NB!* Time codes which cannot be expressed in an integer number of samples will be returned as a decimal number, with risk of losing precision.
        :key str library_id: If set, the library identified by this id will be used instead of creating a new library.
        :key bool count: - `true` (default) - Return hits in result.  - `false` - Do not return hits in result, in order to produce results faster.
        :key bool save: - `true` - Returns a `303 See Other`, with a `Location` header containing an URI to fetch the search result - `false` (default) - Returns a regular search result
        :key bool noauth_url: - `true` Return URIs that do not need authentication.  - `false` (default) Return normal URIs
        :key str update_mode: When creating a library, use this update mode.
        :key _return_http_data_only: response data without head status code
                                       and headers
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(ItemListType, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['item_search_type', 'language', 'storage_type', 'first', 'closed_files', 'terse', 'method_metadata', 'update_frequency', 'number', 'interval', 'group', 'merged_permission', 'storage_group', 'track', 'conflict', 'starttc', 'content', 'uri_type', 'include_transient_metadata', 'merged_type', 'default_value', 'tag', 'field', 'include', 'method_type', 'q', 'p', 'library', 'base_uri', 'merged_extradata', 'result', 'storage', 'revision', 'url', 'scheme', 'auto_refresh', 'version', 'cursor', 'include_values', 'sample_rate', 'library_id', 'count', 'save', 'noauth_url', 'update_mode']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method search_items" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'item_search_type' is set
        if ('item_search_type' not in local_var_params or
                local_var_params['item_search_type'] is None):
            raise ApiValueError("Missing the required parameter `item_search_type` when calling `search_items`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'language' in local_var_params:
            query_params.append(('language', local_var_params['language']))  # noqa: E501
            collection_formats['language'] = 'csv'  # noqa: E501
        if 'storage_type' in local_var_params:
            query_params.append(('storageType', local_var_params['storage_type']))  # noqa: E501
        if 'first' in local_var_params:
            query_params.append(('first', local_var_params['first']))  # noqa: E501
        if 'closed_files' in local_var_params:
            query_params.append(('closedFiles', local_var_params['closed_files']))  # noqa: E501
        if 'terse' in local_var_params:
            query_params.append(('terse', local_var_params['terse']))  # noqa: E501
        if 'method_metadata' in local_var_params:
            query_params.append(('methodMetadata', local_var_params['method_metadata']))  # noqa: E501
        if 'update_frequency' in local_var_params:
            query_params.append(('updateFrequency', local_var_params['update_frequency']))  # noqa: E501
        if 'number' in local_var_params:
            query_params.append(('number', local_var_params['number']))  # noqa: E501
        if 'interval' in local_var_params:
            query_params.append(('interval', local_var_params['interval']))  # noqa: E501
            collection_formats['interval'] = 'csv'  # noqa: E501
        if 'group' in local_var_params:
            query_params.append(('group', local_var_params['group']))  # noqa: E501
            collection_formats['group'] = 'csv'  # noqa: E501
        if 'merged_permission' in local_var_params:
            query_params.append(('mergedPermission', local_var_params['merged_permission']))  # noqa: E501
        if 'storage_group' in local_var_params:
            query_params.append(('storageGroup', local_var_params['storage_group']))  # noqa: E501
        if 'track' in local_var_params:
            query_params.append(('track', local_var_params['track']))  # noqa: E501
            collection_formats['track'] = 'csv'  # noqa: E501
        if 'conflict' in local_var_params:
            query_params.append(('conflict', local_var_params['conflict']))  # noqa: E501
        if 'starttc' in local_var_params:
            query_params.append(('starttc', local_var_params['starttc']))  # noqa: E501
        if 'content' in local_var_params:
            query_params.append(('content', local_var_params['content']))  # noqa: E501
            collection_formats['content'] = 'csv'  # noqa: E501
        if 'uri_type' in local_var_params:
            query_params.append(('uriType', local_var_params['uri_type']))  # noqa: E501
            collection_formats['uriType'] = 'csv'  # noqa: E501
        if 'include_transient_metadata' in local_var_params:
            query_params.append(('includeTransientMetadata', local_var_params['include_transient_metadata']))  # noqa: E501
        if 'merged_type' in local_var_params:
            query_params.append(('mergedType', local_var_params['merged_type']))  # noqa: E501
        if 'default_value' in local_var_params:
            query_params.append(('defaultValue', local_var_params['default_value']))  # noqa: E501
        if 'tag' in local_var_params:
            query_params.append(('tag', local_var_params['tag']))  # noqa: E501
        if 'field' in local_var_params:
            query_params.append(('field', local_var_params['field']))  # noqa: E501
            collection_formats['field'] = 'csv'  # noqa: E501
        if 'include' in local_var_params:
            query_params.append(('include', local_var_params['include']))  # noqa: E501
        if 'method_type' in local_var_params:
            query_params.append(('methodType', local_var_params['method_type']))  # noqa: E501
        if 'q' in local_var_params:
            query_params.append(('q', local_var_params['q']))  # noqa: E501
        if 'p' in local_var_params:
            query_params.append(('p', local_var_params['p']))  # noqa: E501
            collection_formats['p'] = 'csv'  # noqa: E501
        if 'library' in local_var_params:
            query_params.append(('library', local_var_params['library']))  # noqa: E501
        if 'base_uri' in local_var_params:
            query_params.append(('baseURI', local_var_params['base_uri']))  # noqa: E501
        if 'merged_extradata' in local_var_params:
            query_params.append(('mergedExtradata', local_var_params['merged_extradata']))  # noqa: E501
        if 'result' in local_var_params:
            query_params.append(('result', local_var_params['result']))  # noqa: E501
        if 'storage' in local_var_params:
            query_params.append(('storage', local_var_params['storage']))  # noqa: E501
            collection_formats['storage'] = 'multi'  # noqa: E501
        if 'revision' in local_var_params:
            query_params.append(('revision', local_var_params['revision']))  # noqa: E501
        if 'url' in local_var_params:
            query_params.append(('url', local_var_params['url']))  # noqa: E501
        if 'scheme' in local_var_params:
            query_params.append(('scheme', local_var_params['scheme']))  # noqa: E501
        if 'auto_refresh' in local_var_params:
            query_params.append(('autoRefresh', local_var_params['auto_refresh']))  # noqa: E501
        if 'version' in local_var_params:
            query_params.append(('version', local_var_params['version']))  # noqa: E501
        if 'cursor' in local_var_params:
            query_params.append(('cursor', local_var_params['cursor']))  # noqa: E501
        if 'include_values' in local_var_params:
            query_params.append(('includeValues', local_var_params['include_values']))  # noqa: E501
        if 'sample_rate' in local_var_params:
            query_params.append(('sampleRate', local_var_params['sample_rate']))  # noqa: E501
        if 'library_id' in local_var_params:
            query_params.append(('libraryId', local_var_params['library_id']))  # noqa: E501
        if 'count' in local_var_params:
            query_params.append(('count', local_var_params['count']))  # noqa: E501
        if 'save' in local_var_params:
            query_params.append(('save', local_var_params['save']))  # noqa: E501
        if 'noauth_url' in local_var_params:
            query_params.append(('noauth-url', local_var_params['noauth_url']))  # noqa: E501
        if 'update_mode' in local_var_params:
            query_params.append(('updateMode', local_var_params['update_mode']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'item_search_type' in local_var_params:
            body_params = local_var_params['item_search_type']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'text/plain', 'application/xml'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'application/xml'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/item', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ItemListType',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_or_create_item_poster_resource(self, item_id, **kwargs):  # noqa: E501
        """Update or create a thumbnail resource for an item  # noqa: E501

        If no poster resources are defined for an item, create a resource and return it.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_or_create_item_poster_resource(item_id, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str item_id: The item id. (required)
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: URIListType.
                 If the method is called asynchronously, returns the request thread.
        :rtype: URIListType or multiprocessing.pool.AsyncResult
        """
        kwargs['_return_http_data_only'] = True
        return self.update_or_create_item_poster_resource_with_http_info(item_id, **kwargs)  # noqa: E501

    def update_or_create_item_poster_resource_with_http_info(self, item_id, **kwargs):  # noqa: E501
        """Update or create a thumbnail resource for an item  # noqa: E501

        If no poster resources are defined for an item, create a resource and return it.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_or_create_item_poster_resource_with_http_info(item_id, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str item_id: The item id. (required)
        :key _return_http_data_only: response data without head status code
                                       and headers
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(URIListType, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['item_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_or_create_item_poster_resource" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'item_id' is set
        if ('item_id' not in local_var_params or
                local_var_params['item_id'] is None):
            raise ApiValueError("Missing the required parameter `item_id` when calling `update_or_create_item_poster_resource`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'item_id' in local_var_params:
            path_params['item-id'] = local_var_params['item_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'text/plain', 'application/xml'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/item/{item-id}/posterresource', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='URIListType',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_or_create_item_thumbnail_resource(self, item_id, **kwargs):  # noqa: E501
        """Update or create a thumbnail resource for an item  # noqa: E501

        If no thumbnail resources are defined for an item, create a resource and return it.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_or_create_item_thumbnail_resource(item_id, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str item_id: The item id. (required)
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: URIListType.
                 If the method is called asynchronously, returns the request thread.
        :rtype: URIListType or multiprocessing.pool.AsyncResult
        """
        kwargs['_return_http_data_only'] = True
        return self.update_or_create_item_thumbnail_resource_with_http_info(item_id, **kwargs)  # noqa: E501

    def update_or_create_item_thumbnail_resource_with_http_info(self, item_id, **kwargs):  # noqa: E501
        """Update or create a thumbnail resource for an item  # noqa: E501

        If no thumbnail resources are defined for an item, create a resource and return it.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_or_create_item_thumbnail_resource_with_http_info(item_id, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str item_id: The item id. (required)
        :key _return_http_data_only: response data without head status code
                                       and headers
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(URIListType, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['item_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_or_create_item_thumbnail_resource" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'item_id' is set
        if ('item_id' not in local_var_params or
                local_var_params['item_id'] is None):
            raise ApiValueError("Missing the required parameter `item_id` when calling `update_or_create_item_thumbnail_resource`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'item_id' in local_var_params:
            path_params['item-id'] = local_var_params['item_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'text/plain', 'application/xml'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/item/{item-id}/thumbnailresource', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='URIListType',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)
