# coding: utf-8

"""
    Vidispine API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)  # noqa: E501

    The version of the OpenAPI document: 5.x
    Contact: info@vidispine.com
    Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from vidispine.models import *
from vidispine.api_client import ApiClient
from vidispine.exceptions import (
    ApiTypeError,
    ApiValueError
)


class JobApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def abort_job(self, job_id, **kwargs):  # noqa: E501
        """Abort a job  # noqa: E501

        Does not delete the job, but aborts it.  To delete one or more jobs, use `DELETE /job`.  The job is marked for abortion, but the call may return before all tasks have been killed. Hence, the status return by this call is likely to be ABORT_PENDING rather than ABORTED. Caller should poll the status of the job or use job notifications to find out when job has been fully aborted.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.abort_job(job_id, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str job_id: The job id. (required)
        :key str reason: Reason for cancellation.
        :key bool cleanup: - `true` (default) - Run cleanup steps before aborting.  - `false` - Skip the cleanup steps, unless the job is already running.  For READY jobs this means that the job will immediately be marked as ABORTED.
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None.
                 If the method is called asynchronously, returns the request thread.
        :rtype: None or multiprocessing.pool.AsyncResult
        """
        kwargs['_return_http_data_only'] = True
        return self.abort_job_with_http_info(job_id, **kwargs)  # noqa: E501

    def abort_job_with_http_info(self, job_id, **kwargs):  # noqa: E501
        """Abort a job  # noqa: E501

        Does not delete the job, but aborts it.  To delete one or more jobs, use `DELETE /job`.  The job is marked for abortion, but the call may return before all tasks have been killed. Hence, the status return by this call is likely to be ABORT_PENDING rather than ABORTED. Caller should poll the status of the job or use job notifications to find out when job has been fully aborted.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.abort_job_with_http_info(job_id, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str job_id: The job id. (required)
        :key str reason: Reason for cancellation.
        :key bool cleanup: - `true` (default) - Run cleanup steps before aborting.  - `false` - Skip the cleanup steps, unless the job is already running.  For READY jobs this means that the job will immediately be marked as ABORTED.
        :key _return_http_data_only: response data without head status code
                                       and headers
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['job_id', 'reason', 'cleanup']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method abort_job" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'job_id' is set
        if ('job_id' not in local_var_params or
                local_var_params['job_id'] is None):
            raise ApiValueError("Missing the required parameter `job_id` when calling `abort_job`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'job_id' in local_var_params:
            path_params['job-id'] = local_var_params['job_id']  # noqa: E501

        query_params = []
        if 'reason' in local_var_params:
            query_params.append(('reason', local_var_params['reason']))  # noqa: E501
        if 'cleanup' in local_var_params:
            query_params.append(('cleanup', local_var_params['cleanup']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/job/{job-id}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_custom_job(self, type, simple_metadata_type, **kwargs):  # noqa: E501
        """Start a job with custom type  # noqa: E501

        Starts a new job, of the type specified in the `type` parameter.  Changed in version 5.0.  Additional job metadata can also be added using an *optional* *SimpleMetadataDocument*. If any `jobmetadata` keys would collide between the query parameters and the *SimpleMetadataDocument*, the key and value from the *SimpleMetadataDocument* would have precedence over the query parameter.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_custom_job(type, simple_metadata_type, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str type: The job type name. (required)
        :param SimpleMetadataType simple_metadata_type: (required)
        :key list[str] jobmetadata: Additional information for the job task.
        :key str notification_data: Any additional data to include for notifications on this job.
        :key str priority: The priority to assign to the job.
        :key str notification: The placeholder job notification to use for this job.
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: JobType.
                 If the method is called asynchronously, returns the request thread.
        :rtype: JobType or multiprocessing.pool.AsyncResult
        """
        kwargs['_return_http_data_only'] = True
        return self.create_custom_job_with_http_info(type, simple_metadata_type, **kwargs)  # noqa: E501

    def create_custom_job_with_http_info(self, type, simple_metadata_type, **kwargs):  # noqa: E501
        """Start a job with custom type  # noqa: E501

        Starts a new job, of the type specified in the `type` parameter.  Changed in version 5.0.  Additional job metadata can also be added using an *optional* *SimpleMetadataDocument*. If any `jobmetadata` keys would collide between the query parameters and the *SimpleMetadataDocument*, the key and value from the *SimpleMetadataDocument* would have precedence over the query parameter.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_custom_job_with_http_info(type, simple_metadata_type, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str type: The job type name. (required)
        :param SimpleMetadataType simple_metadata_type: (required)
        :key list[str] jobmetadata: Additional information for the job task.
        :key str notification_data: Any additional data to include for notifications on this job.
        :key str priority: The priority to assign to the job.
        :key str notification: The placeholder job notification to use for this job.
        :key _return_http_data_only: response data without head status code
                                       and headers
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(JobType, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['type', 'simple_metadata_type', 'jobmetadata', 'notification_data', 'priority', 'notification']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_custom_job" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'type' is set
        if ('type' not in local_var_params or
                local_var_params['type'] is None):
            raise ApiValueError("Missing the required parameter `type` when calling `create_custom_job`")  # noqa: E501
        # verify the required parameter 'simple_metadata_type' is set
        if ('simple_metadata_type' not in local_var_params or
                local_var_params['simple_metadata_type'] is None):
            raise ApiValueError("Missing the required parameter `simple_metadata_type` when calling `create_custom_job`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'jobmetadata' in local_var_params:
            query_params.append(('jobmetadata', local_var_params['jobmetadata']))  # noqa: E501
            collection_formats['jobmetadata'] = 'multi'  # noqa: E501
        if 'type' in local_var_params:
            query_params.append(('type', local_var_params['type']))  # noqa: E501
        if 'notification_data' in local_var_params:
            query_params.append(('notificationData', local_var_params['notification_data']))  # noqa: E501
        if 'priority' in local_var_params:
            query_params.append(('priority', local_var_params['priority']))  # noqa: E501
        if 'notification' in local_var_params:
            query_params.append(('notification', local_var_params['notification']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'simple_metadata_type' in local_var_params:
            body_params = local_var_params['simple_metadata_type']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'application/xml'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'application/xml'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/job', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='JobType',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_duplicate_job(self, job_id, **kwargs):  # noqa: E501
        """Create a duplicate job  # noqa: E501

        Retrieves an existing job, duplicates it and starts the duplicated version.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_duplicate_job(job_id, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str job_id: The job id. (required)
        :key str priority: The priority of the new job.  If no priority is specified then the priority of the existing job will be used.
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: JobType.
                 If the method is called asynchronously, returns the request thread.
        :rtype: JobType or multiprocessing.pool.AsyncResult
        """
        kwargs['_return_http_data_only'] = True
        return self.create_duplicate_job_with_http_info(job_id, **kwargs)  # noqa: E501

    def create_duplicate_job_with_http_info(self, job_id, **kwargs):  # noqa: E501
        """Create a duplicate job  # noqa: E501

        Retrieves an existing job, duplicates it and starts the duplicated version.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_duplicate_job_with_http_info(job_id, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str job_id: The job id. (required)
        :key str priority: The priority of the new job.  If no priority is specified then the priority of the existing job will be used.
        :key _return_http_data_only: response data without head status code
                                       and headers
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(JobType, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['job_id', 'priority']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_duplicate_job" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'job_id' is set
        if ('job_id' not in local_var_params or
                local_var_params['job_id'] is None):
            raise ApiValueError("Missing the required parameter `job_id` when calling `create_duplicate_job`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'job_id' in local_var_params:
            path_params['job-id'] = local_var_params['job_id']  # noqa: E501

        query_params = []
        if 'priority' in local_var_params:
            query_params.append(('priority', local_var_params['priority']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'application/xml'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/job/{job-id}/re-run', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='JobType',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_jobs(self, id, **kwargs):  # noqa: E501
        """Delete one or several jobs  # noqa: E501

        Deletes a job and every related database entry.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_jobs(id, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param list[str] id: Comma-separated list of job ids. (required)
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None.
                 If the method is called asynchronously, returns the request thread.
        :rtype: None or multiprocessing.pool.AsyncResult
        """
        kwargs['_return_http_data_only'] = True
        return self.delete_jobs_with_http_info(id, **kwargs)  # noqa: E501

    def delete_jobs_with_http_info(self, id, **kwargs):  # noqa: E501
        """Delete one or several jobs  # noqa: E501

        Deletes a job and every related database entry.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_jobs_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param list[str] id: Comma-separated list of job ids. (required)
        :key _return_http_data_only: response data without head status code
                                       and headers
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_jobs" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in local_var_params or
                local_var_params['id'] is None):
            raise ApiValueError("Missing the required parameter `id` when calling `delete_jobs`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'id' in local_var_params:
            query_params.append(('id', local_var_params['id']))  # noqa: E501
            collection_formats['id'] = 'csv'  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/job', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_all_job_problems(self, **kwargs):  # noqa: E501
        """List all job problems  # noqa: E501

        Returns a list of unresolved problems, together with what jobs are waiting for them to be resolved.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_all_job_problems(async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: JobProblemListType.
                 If the method is called asynchronously, returns the request thread.
        :rtype: JobProblemListType or multiprocessing.pool.AsyncResult
        """
        kwargs['_return_http_data_only'] = True
        return self.get_all_job_problems_with_http_info(**kwargs)  # noqa: E501

    def get_all_job_problems_with_http_info(self, **kwargs):  # noqa: E501
        """List all job problems  # noqa: E501

        Returns a list of unresolved problems, together with what jobs are waiting for them to be resolved.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_all_job_problems_with_http_info(async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :key _return_http_data_only: response data without head status code
                                       and headers
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(JobProblemListType, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_all_job_problems" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'application/xml'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/job/problem', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='JobProblemListType',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_job(self, job_id, **kwargs):  # noqa: E501
        """Retrieve a job  # noqa: E501

        Return information about specified job.  When returning in format `text/plain`, only a string representation of the state is returned.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_job(job_id, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str job_id: The job id. (required)
        :key list[str] field: Comma-separated list of fields to include in the result metadata.
        :key bool metadata: - `true` - Include job metadata with all jobs.  - `false` (default) - Do not include job metadata with all jobs.
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: JobType.
                 If the method is called asynchronously, returns the request thread.
        :rtype: JobType or multiprocessing.pool.AsyncResult
        """
        kwargs['_return_http_data_only'] = True
        return self.get_job_with_http_info(job_id, **kwargs)  # noqa: E501

    def get_job_with_http_info(self, job_id, **kwargs):  # noqa: E501
        """Retrieve a job  # noqa: E501

        Return information about specified job.  When returning in format `text/plain`, only a string representation of the state is returned.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_job_with_http_info(job_id, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str job_id: The job id. (required)
        :key list[str] field: Comma-separated list of fields to include in the result metadata.
        :key bool metadata: - `true` - Include job metadata with all jobs.  - `false` (default) - Do not include job metadata with all jobs.
        :key _return_http_data_only: response data without head status code
                                       and headers
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(JobType, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['job_id', 'field', 'metadata']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_job" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'job_id' is set
        if ('job_id' not in local_var_params or
                local_var_params['job_id'] is None):
            raise ApiValueError("Missing the required parameter `job_id` when calling `get_job`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'job_id' in local_var_params:
            path_params['job-id'] = local_var_params['job_id']  # noqa: E501

        query_params = []
        if 'field' in local_var_params:
            query_params.append(('field', local_var_params['field']))  # noqa: E501
            collection_formats['field'] = 'csv'  # noqa: E501
        if 'metadata' in local_var_params:
            query_params.append(('metadata', local_var_params['metadata']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'text/plain', 'application/xml'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/job/{job-id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='JobType',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_job_problems(self, job_id, **kwargs):  # noqa: E501
        """List all problems for a job  # noqa: E501

        Retrieves a list of problems that affects the specified job.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_job_problems(job_id, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str job_id: The job id. (required)
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: JobProblemListType.
                 If the method is called asynchronously, returns the request thread.
        :rtype: JobProblemListType or multiprocessing.pool.AsyncResult
        """
        kwargs['_return_http_data_only'] = True
        return self.get_job_problems_with_http_info(job_id, **kwargs)  # noqa: E501

    def get_job_problems_with_http_info(self, job_id, **kwargs):  # noqa: E501
        """List all problems for a job  # noqa: E501

        Retrieves a list of problems that affects the specified job.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_job_problems_with_http_info(job_id, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str job_id: The job id. (required)
        :key _return_http_data_only: response data without head status code
                                       and headers
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(JobProblemListType, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['job_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_job_problems" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'job_id' is set
        if ('job_id' not in local_var_params or
                local_var_params['job_id'] is None):
            raise ApiValueError("Missing the required parameter `job_id` when calling `get_job_problems`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'job_id' in local_var_params:
            path_params['job-id'] = local_var_params['job_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'application/xml'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/job/{job-id}/problem', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='JobProblemListType',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_job_types(self, **kwargs):  # noqa: E501
        """List all job types  # noqa: E501

        Get list of job types  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_job_types(async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: URIListType.
                 If the method is called asynchronously, returns the request thread.
        :rtype: URIListType or multiprocessing.pool.AsyncResult
        """
        kwargs['_return_http_data_only'] = True
        return self.get_job_types_with_http_info(**kwargs)  # noqa: E501

    def get_job_types_with_http_info(self, **kwargs):  # noqa: E501
        """List all job types  # noqa: E501

        Get list of job types  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_job_types_with_http_info(async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :key _return_http_data_only: response data without head status code
                                       and headers
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(URIListType, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_job_types" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'text/plain', 'application/xml'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/jobtype', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='URIListType',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_jobs(self, **kwargs):  # noqa: E501
        """List all jobs  # noqa: E501

        Return jobs matching the criteria given.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_jobs(async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :key list[str] jobmetadata: Multiple query parameters can be specified.  If no query parameters are specified, all jobs are returned.   - *key* `=` *value* - Filter out only the jobs that has job metadata according to the filter criteria.  Note that `=` is part of the query parameter, and has to be encoded (`%3d`).
        :key list[str] field: Comma-separated list of fields to include in the result metadata.
        :key str starttime_to: ISO 8601 timestamp.  Return only jobs started before and at the given timestamp.
        :key bool user: - `true` (default) - Include only jobs created by current user - `false` - Include all jobs
        :key int first: Return jobs from that number in the list of sorted jobs.
        :key list[str] type: Comma-separated list of job types.
        :key str starttime_from: ISO 8601 timestamp.  Return only jobs started after and at the given timestamp.
        :key bool step: - `true` - Include step information in the job listing.  - `false` (default) - Do not include step information in the job listing.
        :key bool idonly: - `true` - Only return a list of ids - `false` (default) - Return job information such as job status
        :key int number: Return at most that number of jobs.  Default returns the first 100 jobs.
        :key list[str] state: Comma-separated list of job states.
        :key str sort: List of form `field (asc|desc)[, . . . ]`.  Sort by specific fields.   - `jobId` - `type` - `state` - `user` - `startTime` - `priority`
        :key bool metadata: - `true` - Include job metadata with all jobs.  - `false` (default) - Do not include job metadata with all jobs.
        :key str finishtime_from: ISO 8601 timestamp.  Return only jobs finished after and at the given timestamp.
        :key str finishtime_to: ISO 8601 timestamp.  Return only jobs finished before and at the given timestamp.
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: JobListType.
                 If the method is called asynchronously, returns the request thread.
        :rtype: JobListType or multiprocessing.pool.AsyncResult
        """
        kwargs['_return_http_data_only'] = True
        return self.get_jobs_with_http_info(**kwargs)  # noqa: E501

    def get_jobs_with_http_info(self, **kwargs):  # noqa: E501
        """List all jobs  # noqa: E501

        Return jobs matching the criteria given.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_jobs_with_http_info(async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :key list[str] jobmetadata: Multiple query parameters can be specified.  If no query parameters are specified, all jobs are returned.   - *key* `=` *value* - Filter out only the jobs that has job metadata according to the filter criteria.  Note that `=` is part of the query parameter, and has to be encoded (`%3d`).
        :key list[str] field: Comma-separated list of fields to include in the result metadata.
        :key str starttime_to: ISO 8601 timestamp.  Return only jobs started before and at the given timestamp.
        :key bool user: - `true` (default) - Include only jobs created by current user - `false` - Include all jobs
        :key int first: Return jobs from that number in the list of sorted jobs.
        :key list[str] type: Comma-separated list of job types.
        :key str starttime_from: ISO 8601 timestamp.  Return only jobs started after and at the given timestamp.
        :key bool step: - `true` - Include step information in the job listing.  - `false` (default) - Do not include step information in the job listing.
        :key bool idonly: - `true` - Only return a list of ids - `false` (default) - Return job information such as job status
        :key int number: Return at most that number of jobs.  Default returns the first 100 jobs.
        :key list[str] state: Comma-separated list of job states.
        :key str sort: List of form `field (asc|desc)[, . . . ]`.  Sort by specific fields.   - `jobId` - `type` - `state` - `user` - `startTime` - `priority`
        :key bool metadata: - `true` - Include job metadata with all jobs.  - `false` (default) - Do not include job metadata with all jobs.
        :key str finishtime_from: ISO 8601 timestamp.  Return only jobs finished after and at the given timestamp.
        :key str finishtime_to: ISO 8601 timestamp.  Return only jobs finished before and at the given timestamp.
        :key _return_http_data_only: response data without head status code
                                       and headers
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(JobListType, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['jobmetadata', 'field', 'starttime_to', 'user', 'first', 'type', 'starttime_from', 'step', 'idonly', 'number', 'state', 'sort', 'metadata', 'finishtime_from', 'finishtime_to']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_jobs" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'jobmetadata' in local_var_params:
            query_params.append(('jobmetadata', local_var_params['jobmetadata']))  # noqa: E501
            collection_formats['jobmetadata'] = 'multi'  # noqa: E501
        if 'field' in local_var_params:
            query_params.append(('field', local_var_params['field']))  # noqa: E501
            collection_formats['field'] = 'csv'  # noqa: E501
        if 'starttime_to' in local_var_params:
            query_params.append(('starttime-to', local_var_params['starttime_to']))  # noqa: E501
        if 'user' in local_var_params:
            query_params.append(('user', local_var_params['user']))  # noqa: E501
        if 'first' in local_var_params:
            query_params.append(('first', local_var_params['first']))  # noqa: E501
        if 'type' in local_var_params:
            query_params.append(('type', local_var_params['type']))  # noqa: E501
            collection_formats['type'] = 'csv'  # noqa: E501
        if 'starttime_from' in local_var_params:
            query_params.append(('starttime-from', local_var_params['starttime_from']))  # noqa: E501
        if 'step' in local_var_params:
            query_params.append(('step', local_var_params['step']))  # noqa: E501
        if 'idonly' in local_var_params:
            query_params.append(('idonly', local_var_params['idonly']))  # noqa: E501
        if 'number' in local_var_params:
            query_params.append(('number', local_var_params['number']))  # noqa: E501
        if 'state' in local_var_params:
            query_params.append(('state', local_var_params['state']))  # noqa: E501
            collection_formats['state'] = 'csv'  # noqa: E501
        if 'sort' in local_var_params:
            query_params.append(('sort', local_var_params['sort']))  # noqa: E501
        if 'metadata' in local_var_params:
            query_params.append(('metadata', local_var_params['metadata']))  # noqa: E501
        if 'finishtime_from' in local_var_params:
            query_params.append(('finishtime-from', local_var_params['finishtime_from']))  # noqa: E501
        if 'finishtime_to' in local_var_params:
            query_params.append(('finishtime-to', local_var_params['finishtime_to']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'text/plain', 'application/xml'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/job', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='JobListType',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_job(self, job_id, **kwargs):  # noqa: E501
        """Modify a job  # noqa: E501

        Updates the job by setting job priority  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_job(job_id, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str job_id: The job id. (required)
        :key str priority: Change the job priority
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None.
                 If the method is called asynchronously, returns the request thread.
        :rtype: None or multiprocessing.pool.AsyncResult
        """
        kwargs['_return_http_data_only'] = True
        return self.update_job_with_http_info(job_id, **kwargs)  # noqa: E501

    def update_job_with_http_info(self, job_id, **kwargs):  # noqa: E501
        """Modify a job  # noqa: E501

        Updates the job by setting job priority  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_job_with_http_info(job_id, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str job_id: The job id. (required)
        :key str priority: Change the job priority
        :key _return_http_data_only: response data without head status code
                                       and headers
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['job_id', 'priority']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_job" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'job_id' is set
        if ('job_id' not in local_var_params or
                local_var_params['job_id'] is None):
            raise ApiValueError("Missing the required parameter `job_id` when calling `update_job`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'job_id' in local_var_params:
            path_params['job-id'] = local_var_params['job_id']  # noqa: E501

        query_params = []
        if 'priority' in local_var_params:
            query_params.append(('priority', local_var_params['priority']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/job/{job-id}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)
