# coding: utf-8

"""
    Vidispine API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)  # noqa: E501

    The version of the OpenAPI document: 5.x
    Contact: info@vidispine.com
    Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from vidispine.models import *
from vidispine.api_client import ApiClient
from vidispine.exceptions import (
    ApiTypeError,
    ApiValueError
)


class LibraryApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def add_item_to_library(self, library_id, item_id, **kwargs):  # noqa: E501
        """Add an item to a library  # noqa: E501

        Adds the specified item to the library.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.add_item_to_library(library_id, item_id, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str library_id: The library id. (required)
        :param str item_id: The item id. (required)
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None.
                 If the method is called asynchronously, returns the request thread.
        :rtype: None or multiprocessing.pool.AsyncResult
        """
        kwargs['_return_http_data_only'] = True
        return self.add_item_to_library_with_http_info(library_id, item_id, **kwargs)  # noqa: E501

    def add_item_to_library_with_http_info(self, library_id, item_id, **kwargs):  # noqa: E501
        """Add an item to a library  # noqa: E501

        Adds the specified item to the library.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_item_to_library_with_http_info(library_id, item_id, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str library_id: The library id. (required)
        :param str item_id: The item id. (required)
        :key _return_http_data_only: response data without head status code
                                       and headers
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['library_id', 'item_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method add_item_to_library" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'library_id' is set
        if ('library_id' not in local_var_params or
                local_var_params['library_id'] is None):
            raise ApiValueError("Missing the required parameter `library_id` when calling `add_item_to_library`")  # noqa: E501
        # verify the required parameter 'item_id' is set
        if ('item_id' not in local_var_params or
                local_var_params['item_id'] is None):
            raise ApiValueError("Missing the required parameter `item_id` when calling `add_item_to_library`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'library_id' in local_var_params:
            path_params['library-id'] = local_var_params['library_id']  # noqa: E501
        if 'item_id' in local_var_params:
            path_params['item-id'] = local_var_params['item_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/library/{library-id}/{item-id}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_library(self, item_list_type, **kwargs):  # noqa: E501
        """Create a library  # noqa: E501

        Creates a library and returns the id of the created library.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_library(item_list_type, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param ItemListType item_list_type: <em>ItemListDocument</em> that contains the ids of any items that should be added to the library (required)
        :key str external_id: An external identifier to assign to the library.
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: URIListType.
                 If the method is called asynchronously, returns the request thread.
        :rtype: URIListType or multiprocessing.pool.AsyncResult
        """
        kwargs['_return_http_data_only'] = True
        return self.create_library_with_http_info(item_list_type, **kwargs)  # noqa: E501

    def create_library_with_http_info(self, item_list_type, **kwargs):  # noqa: E501
        """Create a library  # noqa: E501

        Creates a library and returns the id of the created library.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_library_with_http_info(item_list_type, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param ItemListType item_list_type: <em>ItemListDocument</em> that contains the ids of any items that should be added to the library (required)
        :key str external_id: An external identifier to assign to the library.
        :key _return_http_data_only: response data without head status code
                                       and headers
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(URIListType, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['item_list_type', 'external_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_library" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'item_list_type' is set
        if ('item_list_type' not in local_var_params or
                local_var_params['item_list_type'] is None):
            raise ApiValueError("Missing the required parameter `item_list_type` when calling `create_library`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'external_id' in local_var_params:
            query_params.append(('externalId', local_var_params['external_id']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'item_list_type' in local_var_params:
            body_params = local_var_params['item_list_type']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'text/plain', 'application/xml'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'application/xml'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/library', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='URIListType',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_library_export_job(self, library_id, **kwargs):  # noqa: E501
        """Start an export job for a collection or a library  # noqa: E501

        Creates a new export job that will copy all matching files in the collection/library to a remote location.  A shape tag can be specified to decide which shapes that will be exported. The files will retain their original names and the URI should therefore point to the folder where the files should be placed.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_library_export_job(library_id, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str library_id: The library id. (required)
        :key list[str] jobmetadata: Additional information for the job task.
        :key list[str] track: Comma-separated list of item track ids.  Can include wildcards, e. g.  `A*`.  Can also contain component ids.
        :key str notification_data: Any additional data to include for notifications on this job.
        :key bool use_original_filename: If set to `true`, the file(s) will be exported with their original filename if available.
        :key str tag: Finds a shape with the specified tag and uses that for export.  If not specified, the system will attempt to use the original shape.
        :key bool all: - `true` (default) - Fail the job if not all files from the selected shapes could be exported.  - `false` - Don't export lost or unavailable files.
        :key str projection: Defines the projection to use when exporting the metadata.
        :key bool use_original_component_filename: If set to `true`, the file(s) will be exported with their original component filename if available.
        :key str notification: The placeholder job notification to use for this job.
        :key str priority: The priority to assign to the job.
        :key str version: - *essence-version-id* - Return shapes for a specified version.  - `all` - Return shapes for all versions.  - `latest` (default) - Return shapes for the latest version.  - `latest-per-shapetag` - Return shapes with the highest essence version number per shape tag.
        :key str uri: A URI to the destination of the file.
        :key bool metadata: - `true` - Metadata will also be exported to side-car XML file.  - `false` (default) - No metadata is exported.
        :key str template: export template to use.
        :key str location_name: The name of an export location.
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: JobType.
                 If the method is called asynchronously, returns the request thread.
        :rtype: JobType or multiprocessing.pool.AsyncResult
        """
        kwargs['_return_http_data_only'] = True
        return self.create_library_export_job_with_http_info(library_id, **kwargs)  # noqa: E501

    def create_library_export_job_with_http_info(self, library_id, **kwargs):  # noqa: E501
        """Start an export job for a collection or a library  # noqa: E501

        Creates a new export job that will copy all matching files in the collection/library to a remote location.  A shape tag can be specified to decide which shapes that will be exported. The files will retain their original names and the URI should therefore point to the folder where the files should be placed.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_library_export_job_with_http_info(library_id, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str library_id: The library id. (required)
        :key list[str] jobmetadata: Additional information for the job task.
        :key list[str] track: Comma-separated list of item track ids.  Can include wildcards, e. g.  `A*`.  Can also contain component ids.
        :key str notification_data: Any additional data to include for notifications on this job.
        :key bool use_original_filename: If set to `true`, the file(s) will be exported with their original filename if available.
        :key str tag: Finds a shape with the specified tag and uses that for export.  If not specified, the system will attempt to use the original shape.
        :key bool all: - `true` (default) - Fail the job if not all files from the selected shapes could be exported.  - `false` - Don't export lost or unavailable files.
        :key str projection: Defines the projection to use when exporting the metadata.
        :key bool use_original_component_filename: If set to `true`, the file(s) will be exported with their original component filename if available.
        :key str notification: The placeholder job notification to use for this job.
        :key str priority: The priority to assign to the job.
        :key str version: - *essence-version-id* - Return shapes for a specified version.  - `all` - Return shapes for all versions.  - `latest` (default) - Return shapes for the latest version.  - `latest-per-shapetag` - Return shapes with the highest essence version number per shape tag.
        :key str uri: A URI to the destination of the file.
        :key bool metadata: - `true` - Metadata will also be exported to side-car XML file.  - `false` (default) - No metadata is exported.
        :key str template: export template to use.
        :key str location_name: The name of an export location.
        :key _return_http_data_only: response data without head status code
                                       and headers
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(JobType, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['library_id', 'jobmetadata', 'track', 'notification_data', 'use_original_filename', 'tag', 'all', 'projection', 'use_original_component_filename', 'notification', 'priority', 'version', 'uri', 'metadata', 'template', 'location_name']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_library_export_job" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'library_id' is set
        if ('library_id' not in local_var_params or
                local_var_params['library_id'] is None):
            raise ApiValueError("Missing the required parameter `library_id` when calling `create_library_export_job`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'library_id' in local_var_params:
            path_params['library-id'] = local_var_params['library_id']  # noqa: E501

        query_params = []
        if 'jobmetadata' in local_var_params:
            query_params.append(('jobmetadata', local_var_params['jobmetadata']))  # noqa: E501
            collection_formats['jobmetadata'] = 'multi'  # noqa: E501
        if 'track' in local_var_params:
            query_params.append(('track', local_var_params['track']))  # noqa: E501
            collection_formats['track'] = 'csv'  # noqa: E501
        if 'notification_data' in local_var_params:
            query_params.append(('notificationData', local_var_params['notification_data']))  # noqa: E501
        if 'use_original_filename' in local_var_params:
            query_params.append(('useOriginalFilename', local_var_params['use_original_filename']))  # noqa: E501
        if 'tag' in local_var_params:
            query_params.append(('tag', local_var_params['tag']))  # noqa: E501
        if 'all' in local_var_params:
            query_params.append(('all', local_var_params['all']))  # noqa: E501
        if 'projection' in local_var_params:
            query_params.append(('projection', local_var_params['projection']))  # noqa: E501
        if 'use_original_component_filename' in local_var_params:
            query_params.append(('useOriginalComponentFilename', local_var_params['use_original_component_filename']))  # noqa: E501
        if 'notification' in local_var_params:
            query_params.append(('notification', local_var_params['notification']))  # noqa: E501
        if 'priority' in local_var_params:
            query_params.append(('priority', local_var_params['priority']))  # noqa: E501
        if 'version' in local_var_params:
            query_params.append(('version', local_var_params['version']))  # noqa: E501
        if 'uri' in local_var_params:
            query_params.append(('uri', local_var_params['uri']))  # noqa: E501
        if 'metadata' in local_var_params:
            query_params.append(('metadata', local_var_params['metadata']))  # noqa: E501
        if 'template' in local_var_params:
            query_params.append(('template', local_var_params['template']))  # noqa: E501
        if 'location_name' in local_var_params:
            query_params.append(('locationName', local_var_params['location_name']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'application/xml'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/library/{library-id}/export', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='JobType',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_library_item_listing_job(self, destination_uri, library_id, item_list_type, **kwargs):  # noqa: E501
        """Creating an item list job  # noqa: E501

        Starts a new job that goes through all the items in the specific library and outputs a file to the supplied URI.  The output format depends on the specified parameter, if set to XML an *ItemListDocument* will be produced. Furthermore if an XSLT is given the *ItemListDocument* will be transformed.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_library_item_listing_job(destination_uri, library_id, item_list_type, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str destination_uri: The URI to output the CSV file to. (required)
        :param str library_id: The library id. (required)
        :param ItemListType item_list_type: An optional XSLT capable of transforming <em>ItemListDocument</em>. (required)
        :key list[str] jobmetadata: Additional information for the job task.
        :key list[str] p: Comma-separated list of paths specifying the content to include.  Overrides the field and data parameters.  Only supported for XML output.
        :key str output_format: Specifies the output format.
        :key str data: Specifies any additional data that should be included with the metadata fields.
        :key str notification: The placeholder job notification to use for this job.
        :key str notification_data: Any additional data to include for notifications on this job.
        :key list[str] field: Comma-separated list of metadata fields to include in the result.
        :key str priority: The priority to assign to the job.
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: JobType.
                 If the method is called asynchronously, returns the request thread.
        :rtype: JobType or multiprocessing.pool.AsyncResult
        """
        kwargs['_return_http_data_only'] = True
        return self.create_library_item_listing_job_with_http_info(destination_uri, library_id, item_list_type, **kwargs)  # noqa: E501

    def create_library_item_listing_job_with_http_info(self, destination_uri, library_id, item_list_type, **kwargs):  # noqa: E501
        """Creating an item list job  # noqa: E501

        Starts a new job that goes through all the items in the specific library and outputs a file to the supplied URI.  The output format depends on the specified parameter, if set to XML an *ItemListDocument* will be produced. Furthermore if an XSLT is given the *ItemListDocument* will be transformed.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_library_item_listing_job_with_http_info(destination_uri, library_id, item_list_type, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str destination_uri: The URI to output the CSV file to. (required)
        :param str library_id: The library id. (required)
        :param ItemListType item_list_type: An optional XSLT capable of transforming <em>ItemListDocument</em>. (required)
        :key list[str] jobmetadata: Additional information for the job task.
        :key list[str] p: Comma-separated list of paths specifying the content to include.  Overrides the field and data parameters.  Only supported for XML output.
        :key str output_format: Specifies the output format.
        :key str data: Specifies any additional data that should be included with the metadata fields.
        :key str notification: The placeholder job notification to use for this job.
        :key str notification_data: Any additional data to include for notifications on this job.
        :key list[str] field: Comma-separated list of metadata fields to include in the result.
        :key str priority: The priority to assign to the job.
        :key _return_http_data_only: response data without head status code
                                       and headers
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(JobType, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['destination_uri', 'library_id', 'item_list_type', 'jobmetadata', 'p', 'output_format', 'data', 'notification', 'notification_data', 'field', 'priority']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_library_item_listing_job" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'destination_uri' is set
        if ('destination_uri' not in local_var_params or
                local_var_params['destination_uri'] is None):
            raise ApiValueError("Missing the required parameter `destination_uri` when calling `create_library_item_listing_job`")  # noqa: E501
        # verify the required parameter 'library_id' is set
        if ('library_id' not in local_var_params or
                local_var_params['library_id'] is None):
            raise ApiValueError("Missing the required parameter `library_id` when calling `create_library_item_listing_job`")  # noqa: E501
        # verify the required parameter 'item_list_type' is set
        if ('item_list_type' not in local_var_params or
                local_var_params['item_list_type'] is None):
            raise ApiValueError("Missing the required parameter `item_list_type` when calling `create_library_item_listing_job`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'library_id' in local_var_params:
            path_params['library-id'] = local_var_params['library_id']  # noqa: E501

        query_params = []
        if 'jobmetadata' in local_var_params:
            query_params.append(('jobmetadata', local_var_params['jobmetadata']))  # noqa: E501
            collection_formats['jobmetadata'] = 'multi'  # noqa: E501
        if 'p' in local_var_params:
            query_params.append(('p', local_var_params['p']))  # noqa: E501
            collection_formats['p'] = 'csv'  # noqa: E501
        if 'output_format' in local_var_params:
            query_params.append(('outputFormat', local_var_params['output_format']))  # noqa: E501
        if 'data' in local_var_params:
            query_params.append(('data', local_var_params['data']))  # noqa: E501
        if 'notification' in local_var_params:
            query_params.append(('notification', local_var_params['notification']))  # noqa: E501
        if 'notification_data' in local_var_params:
            query_params.append(('notificationData', local_var_params['notification_data']))  # noqa: E501
        if 'destination_uri' in local_var_params:
            query_params.append(('destinationUri', local_var_params['destination_uri']))  # noqa: E501
        if 'field' in local_var_params:
            query_params.append(('field', local_var_params['field']))  # noqa: E501
            collection_formats['field'] = 'csv'  # noqa: E501
        if 'priority' in local_var_params:
            query_params.append(('priority', local_var_params['priority']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'item_list_type' in local_var_params:
            body_params = local_var_params['item_list_type']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'application/xml'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/xslt'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/library/{library-id}/list', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='JobType',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_item_from_library(self, library_id, item_id, **kwargs):  # noqa: E501
        """Remove an item from a library  # noqa: E501

        Removes the specified item from the library.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_item_from_library(library_id, item_id, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str library_id: The library id. (required)
        :param str item_id: The item id. (required)
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None.
                 If the method is called asynchronously, returns the request thread.
        :rtype: None or multiprocessing.pool.AsyncResult
        """
        kwargs['_return_http_data_only'] = True
        return self.delete_item_from_library_with_http_info(library_id, item_id, **kwargs)  # noqa: E501

    def delete_item_from_library_with_http_info(self, library_id, item_id, **kwargs):  # noqa: E501
        """Remove an item from a library  # noqa: E501

        Removes the specified item from the library.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_item_from_library_with_http_info(library_id, item_id, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str library_id: The library id. (required)
        :param str item_id: The item id. (required)
        :key _return_http_data_only: response data without head status code
                                       and headers
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['library_id', 'item_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_item_from_library" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'library_id' is set
        if ('library_id' not in local_var_params or
                local_var_params['library_id'] is None):
            raise ApiValueError("Missing the required parameter `library_id` when calling `delete_item_from_library`")  # noqa: E501
        # verify the required parameter 'item_id' is set
        if ('item_id' not in local_var_params or
                local_var_params['item_id'] is None):
            raise ApiValueError("Missing the required parameter `item_id` when calling `delete_item_from_library`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'library_id' in local_var_params:
            path_params['library-id'] = local_var_params['library_id']  # noqa: E501
        if 'item_id' in local_var_params:
            path_params['item-id'] = local_var_params['item_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/library/{library-id}/{item-id}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_libraries(self, id, **kwargs):  # noqa: E501
        """Delete multiple libraries  # noqa: E501

        Deletes the libraries with the specified ids.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_libraries(id, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param list[str] id: Comma-separated list of library ids or external ids. (required)
        :key list[str] jobmetadata: Additional information for the job task.
        :key str notification_data: Any additional data to include for notifications on this job.
        :key bool async: - `true` - Start a DELETE_LIBRARY job that removes the libraries.  - `false` (default) - Remove the libraries immediately.
        :key str notification: The placeholder job notification to use for this job.
        :key str priority: The priority to assign to the job.
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: JobType.
                 If the method is called asynchronously, returns the request thread.
        :rtype: JobType or multiprocessing.pool.AsyncResult
        """
        kwargs['_return_http_data_only'] = True
        return self.delete_libraries_with_http_info(id, **kwargs)  # noqa: E501

    def delete_libraries_with_http_info(self, id, **kwargs):  # noqa: E501
        """Delete multiple libraries  # noqa: E501

        Deletes the libraries with the specified ids.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_libraries_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param list[str] id: Comma-separated list of library ids or external ids. (required)
        :key list[str] jobmetadata: Additional information for the job task.
        :key str notification_data: Any additional data to include for notifications on this job.
        :key bool async: - `true` - Start a DELETE_LIBRARY job that removes the libraries.  - `false` (default) - Remove the libraries immediately.
        :key str notification: The placeholder job notification to use for this job.
        :key str priority: The priority to assign to the job.
        :key _return_http_data_only: response data without head status code
                                       and headers
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(JobType, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['id', 'jobmetadata', 'notification_data', 'async', 'notification', 'priority']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_libraries" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in local_var_params or
                local_var_params['id'] is None):
            raise ApiValueError("Missing the required parameter `id` when calling `delete_libraries`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'jobmetadata' in local_var_params:
            query_params.append(('jobmetadata', local_var_params['jobmetadata']))  # noqa: E501
            collection_formats['jobmetadata'] = 'multi'  # noqa: E501
        if 'notification_data' in local_var_params:
            query_params.append(('notificationData', local_var_params['notification_data']))  # noqa: E501
        if 'async' in local_var_params:
            query_params.append(('async', local_var_params['async']))  # noqa: E501
        if 'notification' in local_var_params:
            query_params.append(('notification', local_var_params['notification']))  # noqa: E501
        if 'id' in local_var_params:
            query_params.append(('id', local_var_params['id']))  # noqa: E501
            collection_formats['id'] = 'csv'  # noqa: E501
        if 'priority' in local_var_params:
            query_params.append(('priority', local_var_params['priority']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'application/xml'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/library', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='JobType',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_library(self, library_id, **kwargs):  # noqa: E501
        """Delete a library  # noqa: E501

        Deletes the library with the specified id.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_library(library_id, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str library_id: The library id. (required)
        :key list[str] jobmetadata: Additional information for the job task.
        :key str notification_data: Any additional data to include for notifications on this job.
        :key bool async: - `true` - Start a DELETE_LIBRARY job that removes the library.  - `false` (default) - Remove the library immediately.
        :key str priority: The priority to assign to the job.
        :key str notification: The placeholder job notification to use for this job.
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: JobType.
                 If the method is called asynchronously, returns the request thread.
        :rtype: JobType or multiprocessing.pool.AsyncResult
        """
        kwargs['_return_http_data_only'] = True
        return self.delete_library_with_http_info(library_id, **kwargs)  # noqa: E501

    def delete_library_with_http_info(self, library_id, **kwargs):  # noqa: E501
        """Delete a library  # noqa: E501

        Deletes the library with the specified id.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_library_with_http_info(library_id, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str library_id: The library id. (required)
        :key list[str] jobmetadata: Additional information for the job task.
        :key str notification_data: Any additional data to include for notifications on this job.
        :key bool async: - `true` - Start a DELETE_LIBRARY job that removes the library.  - `false` (default) - Remove the library immediately.
        :key str priority: The priority to assign to the job.
        :key str notification: The placeholder job notification to use for this job.
        :key _return_http_data_only: response data without head status code
                                       and headers
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(JobType, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['library_id', 'jobmetadata', 'notification_data', 'async', 'priority', 'notification']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_library" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'library_id' is set
        if ('library_id' not in local_var_params or
                local_var_params['library_id'] is None):
            raise ApiValueError("Missing the required parameter `library_id` when calling `delete_library`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'library_id' in local_var_params:
            path_params['library-id'] = local_var_params['library_id']  # noqa: E501

        query_params = []
        if 'jobmetadata' in local_var_params:
            query_params.append(('jobmetadata', local_var_params['jobmetadata']))  # noqa: E501
            collection_formats['jobmetadata'] = 'multi'  # noqa: E501
        if 'notification_data' in local_var_params:
            query_params.append(('notificationData', local_var_params['notification_data']))  # noqa: E501
        if 'async' in local_var_params:
            query_params.append(('async', local_var_params['async']))  # noqa: E501
        if 'priority' in local_var_params:
            query_params.append(('priority', local_var_params['priority']))  # noqa: E501
        if 'notification' in local_var_params:
            query_params.append(('notification', local_var_params['notification']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'application/xml'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/library/{library-id}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='JobType',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_library_metadata(self, library_id, **kwargs):  # noqa: E501
        """Delete all key-value pairs  # noqa: E501

        Clears all key-value pairs for the specified entity.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_library_metadata(library_id, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str library_id: The library id. (required)
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None.
                 If the method is called asynchronously, returns the request thread.
        :rtype: None or multiprocessing.pool.AsyncResult
        """
        kwargs['_return_http_data_only'] = True
        return self.delete_library_metadata_with_http_info(library_id, **kwargs)  # noqa: E501

    def delete_library_metadata_with_http_info(self, library_id, **kwargs):  # noqa: E501
        """Delete all key-value pairs  # noqa: E501

        Clears all key-value pairs for the specified entity.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_library_metadata_with_http_info(library_id, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str library_id: The library id. (required)
        :key _return_http_data_only: response data without head status code
                                       and headers
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['library_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_library_metadata" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'library_id' is set
        if ('library_id' not in local_var_params or
                local_var_params['library_id'] is None):
            raise ApiValueError("Missing the required parameter `library_id` when calling `delete_library_metadata`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'library_id' in local_var_params:
            path_params['library-id'] = local_var_params['library_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/library/{library-id}/metadata', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_library_metadata_key(self, library_id, keypath, **kwargs):  # noqa: E501
        """Delete key-value pairs  # noqa: E501

        Deletes the key-value pair with the specified key. If a key path is given, it may include wildcards for deleting multiple keys.  Key paths can also be specified as well as specific keys.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_library_metadata_key(library_id, keypath, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str library_id: The library id. (required)
        :param str keypath: The keypath. (required)
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None.
                 If the method is called asynchronously, returns the request thread.
        :rtype: None or multiprocessing.pool.AsyncResult
        """
        kwargs['_return_http_data_only'] = True
        return self.delete_library_metadata_key_with_http_info(library_id, keypath, **kwargs)  # noqa: E501

    def delete_library_metadata_key_with_http_info(self, library_id, keypath, **kwargs):  # noqa: E501
        """Delete key-value pairs  # noqa: E501

        Deletes the key-value pair with the specified key. If a key path is given, it may include wildcards for deleting multiple keys.  Key paths can also be specified as well as specific keys.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_library_metadata_key_with_http_info(library_id, keypath, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str library_id: The library id. (required)
        :param str keypath: The keypath. (required)
        :key _return_http_data_only: response data without head status code
                                       and headers
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['library_id', 'keypath']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_library_metadata_key" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'library_id' is set
        if ('library_id' not in local_var_params or
                local_var_params['library_id'] is None):
            raise ApiValueError("Missing the required parameter `library_id` when calling `delete_library_metadata_key`")  # noqa: E501
        # verify the required parameter 'keypath' is set
        if ('keypath' not in local_var_params or
                local_var_params['keypath'] is None):
            raise ApiValueError("Missing the required parameter `keypath` when calling `delete_library_metadata_key`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'library_id' in local_var_params:
            path_params['library-id'] = local_var_params['library_id']  # noqa: E501
        if 'keypath' in local_var_params:
            path_params['keypath'] = local_var_params['keypath']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/library/{library-id}/metadata/{keypath}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_libraries(self, **kwargs):  # noqa: E501
        """List all libraries  # noqa: E501

        Retrieves a list of the ids of all known libraries.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_libraries(async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :key bool auto_refresh: Only list libraries with the specified auto refresh status.
        :key int frequency_from: Only list libraries whose update frequency is greater than it.
        :key int first: From the resulting list of items, start return list from specified offset.
        :key int frequency_to: Only list libraries whose update frequency is less than it.
        :key int number: The number of entities to fetch.
        :key str update_mode: Only list libraries with the specified update mode.
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: URIListType.
                 If the method is called asynchronously, returns the request thread.
        :rtype: URIListType or multiprocessing.pool.AsyncResult
        """
        kwargs['_return_http_data_only'] = True
        return self.get_libraries_with_http_info(**kwargs)  # noqa: E501

    def get_libraries_with_http_info(self, **kwargs):  # noqa: E501
        """List all libraries  # noqa: E501

        Retrieves a list of the ids of all known libraries.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_libraries_with_http_info(async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :key bool auto_refresh: Only list libraries with the specified auto refresh status.
        :key int frequency_from: Only list libraries whose update frequency is greater than it.
        :key int first: From the resulting list of items, start return list from specified offset.
        :key int frequency_to: Only list libraries whose update frequency is less than it.
        :key int number: The number of entities to fetch.
        :key str update_mode: Only list libraries with the specified update mode.
        :key _return_http_data_only: response data without head status code
                                       and headers
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(URIListType, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['auto_refresh', 'frequency_from', 'first', 'frequency_to', 'number', 'update_mode']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_libraries" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'auto_refresh' in local_var_params:
            query_params.append(('autoRefresh', local_var_params['auto_refresh']))  # noqa: E501
        if 'frequency_from' in local_var_params:
            query_params.append(('frequencyFrom', local_var_params['frequency_from']))  # noqa: E501
        if 'first' in local_var_params:
            query_params.append(('first', local_var_params['first']))  # noqa: E501
        if 'frequency_to' in local_var_params:
            query_params.append(('frequencyTo', local_var_params['frequency_to']))  # noqa: E501
        if 'number' in local_var_params:
            query_params.append(('number', local_var_params['number']))  # noqa: E501
        if 'update_mode' in local_var_params:
            query_params.append(('updateMode', local_var_params['update_mode']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'text/plain', 'application/xml'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/library', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='URIListType',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_library(self, library_id, **kwargs):  # noqa: E501
        """Retrieve library content  # noqa: E501

        Returns the items together with any requested data.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_library(library_id, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str library_id: The library id. (required)
        :key list[str] language: Comma-separated list.   - *language-tag* - Return metadata for specific language, e. g.  `en_US`.  Wildcards may be used, e. g.  `*_CA` for both Canadian French and Canadian English.  - `none` - Return all metadata without language specification.  - `all` (default) - Return all metadata, with or without language specification.
        :key str storage_type: Only return URIs for files from storages of this type.
        :key int first: From the resulting list of items, start return list from specified offset.
        :key bool closed_files: A URI parameter:  - `true` (default) - Return only URIs that point to closed files.  - `false` - Return all URIs.
        :key str terse: - `yes` - Return metadata in terse format.  - `no` (default) - Return metadata in verbose format.
        :key str method_metadata: Metadata used with storage method.
        :key int number: The number of entities to fetch.
        :key list[str] interval: Comma-separated list  - *time-span* - Filter out metadata, return only metadata for specified time span.  - `generic` - Return all non-timed metadata.  - `all` (default) - Return all metadata, same as `interval=generic,-INF-+INF`
        :key list[str] group: Comma-separated list.   - *group-name* - Return specified group.  - *group-name* `+` - Return specified group and subgroups.  - *group-name* `:` *new-name* - Return specified group, renamed to a new name in return value.  - `-` *group-name* - Exclude specified group.  - (default) - Return all groups.
        :key str merged_permission: The lowest required permission level.
        :key str storage_group: Storage group id.  Return only files from storages specified in the storage group.
        :key list[str] track: Comma-separated list.   - *track-type* *track-number* - Return metadata for specified track.  Example of track is `A2`.  - *track-type* *t1* `-` *t2* - Return metadata for specified track interval, e. g.  `A2-4`.  - *track-type* `*` - Return metadata for all tracks of specified type, e. g.  `A*`.  - `generic` - Return all non-tracked metadata.  - `all` (default) - All metadata, with or without track specification, are returned.
        :key str conflict: - `yes` (default) - Include all metadata conflicts, unresolved.  - `no` - Return conflicts resolved according to field rules.
        :key bool starttc: - `true` - Interval is given relative to start timecode of item.  - `false` (default) - Interval is 0-based.
        :key list[str] content: Comma-separated list of the types of content to retrieve.
        :key list[str] uri_type: Comma-separated list of format types (container format) to return.
        :key bool include_transient_metadata: - `true` (default) - Include transient metadata.  - `false` - Do not include transient metadata in response.
        :key str merged_type: The type of operation to check for.
        :key bool default_value: - `true` - For unset fields, return default values.  - `false` (default) - Do not return default values.
        :key str tag: A URI parameter: Comma-separated list of shape tags to return.
        :key list[str] field: Comma-separated list.   - *field-name* - Return specified field.  - *field-name* \":\" *new-name* - Return specified field, renamed to a new name in return value.  - \"-\" *field-name* - Exclude specified field.  - (default) - Return all fields.
        :key str include: A list of keys.   Includes additional field specific data.  Additionally, if set to `type` the type definition of the field will be retrieved.
        :key str method_type: Access method.   - `AUTO` - Gives an APInoauth URI to the media.  Access to file is tunneled through Vidispine.  - `AZURE_SAS` - If the storage schema is azure:// you can get direct access to the media.  The resulting URI will not tunnel through Vidispine but rather point directly to the media location at the azure storage.
        :key list[str] p: Comma-separated list of paths specifying the content to include.  Overrides the content and filter parameters.
        :key str base_uri: Which base URI to use for the thumbnail URLs.
        :key str merged_extradata: Any possible extra data.
        :key list[str] storage: List of storage ids.  Return only files from specific storages.  Can be specified multiple times.
        :key str revision: Specifying which metadata revision to display.  Only used if requesting a single item or collection.
        :key str scheme: URI scheme to return.
        :key str version: Specifying which essence version to return for shapes.  If special value `all`, display all versions.  If special value `latest` (default), display latest version of shapes.
        :key bool include_values: Return the value enumeration for each metadata field.
        :key str sample_rate: Convert all outgoing time instants to specified rate.  *NB!* Time codes which cannot be expressed in an integer number of samples will be returned as a decimal number, with risk of losing precision.
        :key bool count: - `true` (default) - Return hits in result.  - `false` - Do not return hits in result, in order to produce results faster.
        :key bool noauth_url: - `true` Return URIs that do not need authentication.  - `false` (default) Return normal URIs
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: ItemListType.
                 If the method is called asynchronously, returns the request thread.
        :rtype: ItemListType or multiprocessing.pool.AsyncResult
        """
        kwargs['_return_http_data_only'] = True
        return self.get_library_with_http_info(library_id, **kwargs)  # noqa: E501

    def get_library_with_http_info(self, library_id, **kwargs):  # noqa: E501
        """Retrieve library content  # noqa: E501

        Returns the items together with any requested data.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_library_with_http_info(library_id, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str library_id: The library id. (required)
        :key list[str] language: Comma-separated list.   - *language-tag* - Return metadata for specific language, e. g.  `en_US`.  Wildcards may be used, e. g.  `*_CA` for both Canadian French and Canadian English.  - `none` - Return all metadata without language specification.  - `all` (default) - Return all metadata, with or without language specification.
        :key str storage_type: Only return URIs for files from storages of this type.
        :key int first: From the resulting list of items, start return list from specified offset.
        :key bool closed_files: A URI parameter:  - `true` (default) - Return only URIs that point to closed files.  - `false` - Return all URIs.
        :key str terse: - `yes` - Return metadata in terse format.  - `no` (default) - Return metadata in verbose format.
        :key str method_metadata: Metadata used with storage method.
        :key int number: The number of entities to fetch.
        :key list[str] interval: Comma-separated list  - *time-span* - Filter out metadata, return only metadata for specified time span.  - `generic` - Return all non-timed metadata.  - `all` (default) - Return all metadata, same as `interval=generic,-INF-+INF`
        :key list[str] group: Comma-separated list.   - *group-name* - Return specified group.  - *group-name* `+` - Return specified group and subgroups.  - *group-name* `:` *new-name* - Return specified group, renamed to a new name in return value.  - `-` *group-name* - Exclude specified group.  - (default) - Return all groups.
        :key str merged_permission: The lowest required permission level.
        :key str storage_group: Storage group id.  Return only files from storages specified in the storage group.
        :key list[str] track: Comma-separated list.   - *track-type* *track-number* - Return metadata for specified track.  Example of track is `A2`.  - *track-type* *t1* `-` *t2* - Return metadata for specified track interval, e. g.  `A2-4`.  - *track-type* `*` - Return metadata for all tracks of specified type, e. g.  `A*`.  - `generic` - Return all non-tracked metadata.  - `all` (default) - All metadata, with or without track specification, are returned.
        :key str conflict: - `yes` (default) - Include all metadata conflicts, unresolved.  - `no` - Return conflicts resolved according to field rules.
        :key bool starttc: - `true` - Interval is given relative to start timecode of item.  - `false` (default) - Interval is 0-based.
        :key list[str] content: Comma-separated list of the types of content to retrieve.
        :key list[str] uri_type: Comma-separated list of format types (container format) to return.
        :key bool include_transient_metadata: - `true` (default) - Include transient metadata.  - `false` - Do not include transient metadata in response.
        :key str merged_type: The type of operation to check for.
        :key bool default_value: - `true` - For unset fields, return default values.  - `false` (default) - Do not return default values.
        :key str tag: A URI parameter: Comma-separated list of shape tags to return.
        :key list[str] field: Comma-separated list.   - *field-name* - Return specified field.  - *field-name* \":\" *new-name* - Return specified field, renamed to a new name in return value.  - \"-\" *field-name* - Exclude specified field.  - (default) - Return all fields.
        :key str include: A list of keys.   Includes additional field specific data.  Additionally, if set to `type` the type definition of the field will be retrieved.
        :key str method_type: Access method.   - `AUTO` - Gives an APInoauth URI to the media.  Access to file is tunneled through Vidispine.  - `AZURE_SAS` - If the storage schema is azure:// you can get direct access to the media.  The resulting URI will not tunnel through Vidispine but rather point directly to the media location at the azure storage.
        :key list[str] p: Comma-separated list of paths specifying the content to include.  Overrides the content and filter parameters.
        :key str base_uri: Which base URI to use for the thumbnail URLs.
        :key str merged_extradata: Any possible extra data.
        :key list[str] storage: List of storage ids.  Return only files from specific storages.  Can be specified multiple times.
        :key str revision: Specifying which metadata revision to display.  Only used if requesting a single item or collection.
        :key str scheme: URI scheme to return.
        :key str version: Specifying which essence version to return for shapes.  If special value `all`, display all versions.  If special value `latest` (default), display latest version of shapes.
        :key bool include_values: Return the value enumeration for each metadata field.
        :key str sample_rate: Convert all outgoing time instants to specified rate.  *NB!* Time codes which cannot be expressed in an integer number of samples will be returned as a decimal number, with risk of losing precision.
        :key bool count: - `true` (default) - Return hits in result.  - `false` - Do not return hits in result, in order to produce results faster.
        :key bool noauth_url: - `true` Return URIs that do not need authentication.  - `false` (default) Return normal URIs
        :key _return_http_data_only: response data without head status code
                                       and headers
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(ItemListType, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['library_id', 'language', 'storage_type', 'first', 'closed_files', 'terse', 'method_metadata', 'number', 'interval', 'group', 'merged_permission', 'storage_group', 'track', 'conflict', 'starttc', 'content', 'uri_type', 'include_transient_metadata', 'merged_type', 'default_value', 'tag', 'field', 'include', 'method_type', 'p', 'base_uri', 'merged_extradata', 'storage', 'revision', 'scheme', 'version', 'include_values', 'sample_rate', 'count', 'noauth_url']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_library" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'library_id' is set
        if ('library_id' not in local_var_params or
                local_var_params['library_id'] is None):
            raise ApiValueError("Missing the required parameter `library_id` when calling `get_library`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'library_id' in local_var_params:
            path_params['library-id'] = local_var_params['library_id']  # noqa: E501

        query_params = []
        if 'language' in local_var_params:
            query_params.append(('language', local_var_params['language']))  # noqa: E501
            collection_formats['language'] = 'csv'  # noqa: E501
        if 'storage_type' in local_var_params:
            query_params.append(('storageType', local_var_params['storage_type']))  # noqa: E501
        if 'first' in local_var_params:
            query_params.append(('first', local_var_params['first']))  # noqa: E501
        if 'closed_files' in local_var_params:
            query_params.append(('closedFiles', local_var_params['closed_files']))  # noqa: E501
        if 'terse' in local_var_params:
            query_params.append(('terse', local_var_params['terse']))  # noqa: E501
        if 'method_metadata' in local_var_params:
            query_params.append(('methodMetadata', local_var_params['method_metadata']))  # noqa: E501
        if 'number' in local_var_params:
            query_params.append(('number', local_var_params['number']))  # noqa: E501
        if 'interval' in local_var_params:
            query_params.append(('interval', local_var_params['interval']))  # noqa: E501
            collection_formats['interval'] = 'csv'  # noqa: E501
        if 'group' in local_var_params:
            query_params.append(('group', local_var_params['group']))  # noqa: E501
            collection_formats['group'] = 'csv'  # noqa: E501
        if 'merged_permission' in local_var_params:
            query_params.append(('mergedPermission', local_var_params['merged_permission']))  # noqa: E501
        if 'storage_group' in local_var_params:
            query_params.append(('storageGroup', local_var_params['storage_group']))  # noqa: E501
        if 'track' in local_var_params:
            query_params.append(('track', local_var_params['track']))  # noqa: E501
            collection_formats['track'] = 'csv'  # noqa: E501
        if 'conflict' in local_var_params:
            query_params.append(('conflict', local_var_params['conflict']))  # noqa: E501
        if 'starttc' in local_var_params:
            query_params.append(('starttc', local_var_params['starttc']))  # noqa: E501
        if 'content' in local_var_params:
            query_params.append(('content', local_var_params['content']))  # noqa: E501
            collection_formats['content'] = 'csv'  # noqa: E501
        if 'uri_type' in local_var_params:
            query_params.append(('uriType', local_var_params['uri_type']))  # noqa: E501
            collection_formats['uriType'] = 'csv'  # noqa: E501
        if 'include_transient_metadata' in local_var_params:
            query_params.append(('includeTransientMetadata', local_var_params['include_transient_metadata']))  # noqa: E501
        if 'merged_type' in local_var_params:
            query_params.append(('mergedType', local_var_params['merged_type']))  # noqa: E501
        if 'default_value' in local_var_params:
            query_params.append(('defaultValue', local_var_params['default_value']))  # noqa: E501
        if 'tag' in local_var_params:
            query_params.append(('tag', local_var_params['tag']))  # noqa: E501
        if 'field' in local_var_params:
            query_params.append(('field', local_var_params['field']))  # noqa: E501
            collection_formats['field'] = 'csv'  # noqa: E501
        if 'include' in local_var_params:
            query_params.append(('include', local_var_params['include']))  # noqa: E501
        if 'method_type' in local_var_params:
            query_params.append(('methodType', local_var_params['method_type']))  # noqa: E501
        if 'p' in local_var_params:
            query_params.append(('p', local_var_params['p']))  # noqa: E501
            collection_formats['p'] = 'csv'  # noqa: E501
        if 'base_uri' in local_var_params:
            query_params.append(('baseURI', local_var_params['base_uri']))  # noqa: E501
        if 'merged_extradata' in local_var_params:
            query_params.append(('mergedExtradata', local_var_params['merged_extradata']))  # noqa: E501
        if 'storage' in local_var_params:
            query_params.append(('storage', local_var_params['storage']))  # noqa: E501
            collection_formats['storage'] = 'multi'  # noqa: E501
        if 'revision' in local_var_params:
            query_params.append(('revision', local_var_params['revision']))  # noqa: E501
        if 'scheme' in local_var_params:
            query_params.append(('scheme', local_var_params['scheme']))  # noqa: E501
        if 'version' in local_var_params:
            query_params.append(('version', local_var_params['version']))  # noqa: E501
        if 'include_values' in local_var_params:
            query_params.append(('includeValues', local_var_params['include_values']))  # noqa: E501
        if 'sample_rate' in local_var_params:
            query_params.append(('sampleRate', local_var_params['sample_rate']))  # noqa: E501
        if 'count' in local_var_params:
            query_params.append(('count', local_var_params['count']))  # noqa: E501
        if 'noauth_url' in local_var_params:
            query_params.append(('noauth-url', local_var_params['noauth_url']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'application/xml'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/library/{library-id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ItemListType',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_library_metadata(self, library_id, **kwargs):  # noqa: E501
        """Retrieve all metadata  # noqa: E501

        Retrieves all key-value pairs associated with the specified entity.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_library_metadata(library_id, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str library_id: The library id. (required)
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: SimpleMetadataType.
                 If the method is called asynchronously, returns the request thread.
        :rtype: SimpleMetadataType or multiprocessing.pool.AsyncResult
        """
        kwargs['_return_http_data_only'] = True
        return self.get_library_metadata_with_http_info(library_id, **kwargs)  # noqa: E501

    def get_library_metadata_with_http_info(self, library_id, **kwargs):  # noqa: E501
        """Retrieve all metadata  # noqa: E501

        Retrieves all key-value pairs associated with the specified entity.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_library_metadata_with_http_info(library_id, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str library_id: The library id. (required)
        :key _return_http_data_only: response data without head status code
                                       and headers
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(SimpleMetadataType, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['library_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_library_metadata" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'library_id' is set
        if ('library_id' not in local_var_params or
                local_var_params['library_id'] is None):
            raise ApiValueError("Missing the required parameter `library_id` when calling `get_library_metadata`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'library_id' in local_var_params:
            path_params['library-id'] = local_var_params['library_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'application/xml'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/library/{library-id}/metadata', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SimpleMetadataType',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_library_metadata_key(self, library_id, keypath, **kwargs):  # noqa: E501
        """Retrieve the metadata for a specific key  # noqa: E501

        Retrieves the value of a specific key. If a key path is specified, exactly one key-value pair must match the key path, else an error is returned.  Key paths can also be specified as well as specific keys.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_library_metadata_key(library_id, keypath, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str library_id: The library id. (required)
        :param str keypath: The keypath. (required)
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: str.
                 If the method is called asynchronously, returns the request thread.
        :rtype: str or multiprocessing.pool.AsyncResult
        """
        kwargs['_return_http_data_only'] = True
        return self.get_library_metadata_key_with_http_info(library_id, keypath, **kwargs)  # noqa: E501

    def get_library_metadata_key_with_http_info(self, library_id, keypath, **kwargs):  # noqa: E501
        """Retrieve the metadata for a specific key  # noqa: E501

        Retrieves the value of a specific key. If a key path is specified, exactly one key-value pair must match the key path, else an error is returned.  Key paths can also be specified as well as specific keys.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_library_metadata_key_with_http_info(library_id, keypath, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str library_id: The library id. (required)
        :param str keypath: The keypath. (required)
        :key _return_http_data_only: response data without head status code
                                       and headers
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(str, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['library_id', 'keypath']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_library_metadata_key" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'library_id' is set
        if ('library_id' not in local_var_params or
                local_var_params['library_id'] is None):
            raise ApiValueError("Missing the required parameter `library_id` when calling `get_library_metadata_key`")  # noqa: E501
        # verify the required parameter 'keypath' is set
        if ('keypath' not in local_var_params or
                local_var_params['keypath'] is None):
            raise ApiValueError("Missing the required parameter `keypath` when calling `get_library_metadata_key`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'library_id' in local_var_params:
            path_params['library-id'] = local_var_params['library_id']  # noqa: E501
        if 'keypath' in local_var_params:
            path_params['keypath'] = local_var_params['keypath']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/library/{library-id}/metadata/{keypath}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='str',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_library_settings(self, library_id, **kwargs):  # noqa: E501
        """Retrieve library settings  # noqa: E501

        Retrieves the settings and status of a library.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_library_settings(library_id, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str library_id: The library id. (required)
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: LibrarySettingsType.
                 If the method is called asynchronously, returns the request thread.
        :rtype: LibrarySettingsType or multiprocessing.pool.AsyncResult
        """
        kwargs['_return_http_data_only'] = True
        return self.get_library_settings_with_http_info(library_id, **kwargs)  # noqa: E501

    def get_library_settings_with_http_info(self, library_id, **kwargs):  # noqa: E501
        """Retrieve library settings  # noqa: E501

        Retrieves the settings and status of a library.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_library_settings_with_http_info(library_id, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str library_id: The library id. (required)
        :key _return_http_data_only: response data without head status code
                                       and headers
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(LibrarySettingsType, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['library_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_library_settings" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'library_id' is set
        if ('library_id' not in local_var_params or
                local_var_params['library_id'] is None):
            raise ApiValueError("Missing the required parameter `library_id` when calling `get_library_settings`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'library_id' in local_var_params:
            path_params['library-id'] = local_var_params['library_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'application/xml'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/library/{library-id}/settings', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='LibrarySettingsType',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_library_content(self, library_id, item_list_type, **kwargs):  # noqa: E501
        """Add multiple items to a library  # noqa: E501

        Adds all the items specified in the document to the library.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_library_content(library_id, item_list_type, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str library_id: The library id. (required)
        :param ItemListType item_list_type: <em>ItemListDocument</em> that contains the item ids. (required)
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None.
                 If the method is called asynchronously, returns the request thread.
        :rtype: None or multiprocessing.pool.AsyncResult
        """
        kwargs['_return_http_data_only'] = True
        return self.update_library_content_with_http_info(library_id, item_list_type, **kwargs)  # noqa: E501

    def update_library_content_with_http_info(self, library_id, item_list_type, **kwargs):  # noqa: E501
        """Add multiple items to a library  # noqa: E501

        Adds all the items specified in the document to the library.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_library_content_with_http_info(library_id, item_list_type, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str library_id: The library id. (required)
        :param ItemListType item_list_type: <em>ItemListDocument</em> that contains the item ids. (required)
        :key _return_http_data_only: response data without head status code
                                       and headers
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['library_id', 'item_list_type']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_library_content" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'library_id' is set
        if ('library_id' not in local_var_params or
                local_var_params['library_id'] is None):
            raise ApiValueError("Missing the required parameter `library_id` when calling `update_library_content`")  # noqa: E501
        # verify the required parameter 'item_list_type' is set
        if ('item_list_type' not in local_var_params or
                local_var_params['item_list_type'] is None):
            raise ApiValueError("Missing the required parameter `item_list_type` when calling `update_library_content`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'library_id' in local_var_params:
            path_params['library-id'] = local_var_params['library_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'item_list_type' in local_var_params:
            body_params = local_var_params['item_list_type']
        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'application/xml'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/library/{library-id}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_library_item_metadata(self, library_id, metadata_type, **kwargs):  # noqa: E501
        """Modify metadata of the items in a specific library  # noqa: E501

        Modify metadata of the items in a specific library  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_library_item_metadata(library_id, metadata_type, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str library_id: The library id. (required)
        :param MetadataType metadata_type: <em>MetadataDocument</em> the metadata to apply to the items. (required)
        :key list[str] jobmetadata: Additional information for the job task.
        :key str notification_data: Any additional data to include for notifications on this job.
        :key str priority: The priority to assign to the job.
        :key str notification: The placeholder job notification to use for this job.
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: JobType.
                 If the method is called asynchronously, returns the request thread.
        :rtype: JobType or multiprocessing.pool.AsyncResult
        """
        kwargs['_return_http_data_only'] = True
        return self.update_library_item_metadata_with_http_info(library_id, metadata_type, **kwargs)  # noqa: E501

    def update_library_item_metadata_with_http_info(self, library_id, metadata_type, **kwargs):  # noqa: E501
        """Modify metadata of the items in a specific library  # noqa: E501

        Modify metadata of the items in a specific library  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_library_item_metadata_with_http_info(library_id, metadata_type, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str library_id: The library id. (required)
        :param MetadataType metadata_type: <em>MetadataDocument</em> the metadata to apply to the items. (required)
        :key list[str] jobmetadata: Additional information for the job task.
        :key str notification_data: Any additional data to include for notifications on this job.
        :key str priority: The priority to assign to the job.
        :key str notification: The placeholder job notification to use for this job.
        :key _return_http_data_only: response data without head status code
                                       and headers
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(JobType, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['library_id', 'metadata_type', 'jobmetadata', 'notification_data', 'priority', 'notification']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_library_item_metadata" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'library_id' is set
        if ('library_id' not in local_var_params or
                local_var_params['library_id'] is None):
            raise ApiValueError("Missing the required parameter `library_id` when calling `update_library_item_metadata`")  # noqa: E501
        # verify the required parameter 'metadata_type' is set
        if ('metadata_type' not in local_var_params or
                local_var_params['metadata_type'] is None):
            raise ApiValueError("Missing the required parameter `metadata_type` when calling `update_library_item_metadata`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'library_id' in local_var_params:
            path_params['library-id'] = local_var_params['library_id']  # noqa: E501

        query_params = []
        if 'jobmetadata' in local_var_params:
            query_params.append(('jobmetadata', local_var_params['jobmetadata']))  # noqa: E501
            collection_formats['jobmetadata'] = 'multi'  # noqa: E501
        if 'notification_data' in local_var_params:
            query_params.append(('notificationData', local_var_params['notification_data']))  # noqa: E501
        if 'priority' in local_var_params:
            query_params.append(('priority', local_var_params['priority']))  # noqa: E501
        if 'notification' in local_var_params:
            query_params.append(('notification', local_var_params['notification']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'metadata_type' in local_var_params:
            body_params = local_var_params['metadata_type']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'application/xml'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'application/xml'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/library/{library-id}/item-metadata', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='JobType',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_library_metadata(self, library_id, simple_metadata_type, **kwargs):  # noqa: E501
        """Create multiple key-value pairs  # noqa: E501

        Sets all the specified key-value pairs.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_library_metadata(library_id, simple_metadata_type, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str library_id: The library id. (required)
        :param SimpleMetadataType simple_metadata_type: (required)
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None.
                 If the method is called asynchronously, returns the request thread.
        :rtype: None or multiprocessing.pool.AsyncResult
        """
        kwargs['_return_http_data_only'] = True
        return self.update_library_metadata_with_http_info(library_id, simple_metadata_type, **kwargs)  # noqa: E501

    def update_library_metadata_with_http_info(self, library_id, simple_metadata_type, **kwargs):  # noqa: E501
        """Create multiple key-value pairs  # noqa: E501

        Sets all the specified key-value pairs.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_library_metadata_with_http_info(library_id, simple_metadata_type, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str library_id: The library id. (required)
        :param SimpleMetadataType simple_metadata_type: (required)
        :key _return_http_data_only: response data without head status code
                                       and headers
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['library_id', 'simple_metadata_type']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_library_metadata" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'library_id' is set
        if ('library_id' not in local_var_params or
                local_var_params['library_id'] is None):
            raise ApiValueError("Missing the required parameter `library_id` when calling `update_library_metadata`")  # noqa: E501
        # verify the required parameter 'simple_metadata_type' is set
        if ('simple_metadata_type' not in local_var_params or
                local_var_params['simple_metadata_type'] is None):
            raise ApiValueError("Missing the required parameter `simple_metadata_type` when calling `update_library_metadata`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'library_id' in local_var_params:
            path_params['library-id'] = local_var_params['library_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'simple_metadata_type' in local_var_params:
            body_params = local_var_params['simple_metadata_type']
        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'application/xml'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/library/{library-id}/metadata', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_library_metadata_key(self, library_id, keypath, body, **kwargs):  # noqa: E501
        """Set the value for a specific key  # noqa: E501

        Sets the value for a specific key. The key path may not contain wildcards.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_library_metadata_key(library_id, keypath, body, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str library_id: The library id. (required)
        :param str keypath: The keypath. (required)
        :param str body: The raw string value. (required)
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None.
                 If the method is called asynchronously, returns the request thread.
        :rtype: None or multiprocessing.pool.AsyncResult
        """
        kwargs['_return_http_data_only'] = True
        return self.update_library_metadata_key_with_http_info(library_id, keypath, body, **kwargs)  # noqa: E501

    def update_library_metadata_key_with_http_info(self, library_id, keypath, body, **kwargs):  # noqa: E501
        """Set the value for a specific key  # noqa: E501

        Sets the value for a specific key. The key path may not contain wildcards.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_library_metadata_key_with_http_info(library_id, keypath, body, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str library_id: The library id. (required)
        :param str keypath: The keypath. (required)
        :param str body: The raw string value. (required)
        :key _return_http_data_only: response data without head status code
                                       and headers
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['library_id', 'keypath', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_library_metadata_key" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'library_id' is set
        if ('library_id' not in local_var_params or
                local_var_params['library_id'] is None):
            raise ApiValueError("Missing the required parameter `library_id` when calling `update_library_metadata_key`")  # noqa: E501
        # verify the required parameter 'keypath' is set
        if ('keypath' not in local_var_params or
                local_var_params['keypath'] is None):
            raise ApiValueError("Missing the required parameter `keypath` when calling `update_library_metadata_key`")  # noqa: E501
        # verify the required parameter 'body' is set
        if ('body' not in local_var_params or
                local_var_params['body'] is None):
            raise ApiValueError("Missing the required parameter `body` when calling `update_library_metadata_key`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'library_id' in local_var_params:
            path_params['library-id'] = local_var_params['library_id']  # noqa: E501
        if 'keypath' in local_var_params:
            path_params['keypath'] = local_var_params['keypath']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in local_var_params:
            body_params = local_var_params['body']
        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['text/plain'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/library/{library-id}/metadata/{keypath}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_library_settings(self, library_id, library_settings_type, **kwargs):  # noqa: E501
        """Update library settings  # noqa: E501

        Update the settings of a library.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_library_settings(library_id, library_settings_type, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str library_id: The library id. (required)
        :param LibrarySettingsType library_settings_type: (required)
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None.
                 If the method is called asynchronously, returns the request thread.
        :rtype: None or multiprocessing.pool.AsyncResult
        """
        kwargs['_return_http_data_only'] = True
        return self.update_library_settings_with_http_info(library_id, library_settings_type, **kwargs)  # noqa: E501

    def update_library_settings_with_http_info(self, library_id, library_settings_type, **kwargs):  # noqa: E501
        """Update library settings  # noqa: E501

        Update the settings of a library.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_library_settings_with_http_info(library_id, library_settings_type, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str library_id: The library id. (required)
        :param LibrarySettingsType library_settings_type: (required)
        :key _return_http_data_only: response data without head status code
                                       and headers
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['library_id', 'library_settings_type']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_library_settings" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'library_id' is set
        if ('library_id' not in local_var_params or
                local_var_params['library_id'] is None):
            raise ApiValueError("Missing the required parameter `library_id` when calling `update_library_settings`")  # noqa: E501
        # verify the required parameter 'library_settings_type' is set
        if ('library_settings_type' not in local_var_params or
                local_var_params['library_settings_type'] is None):
            raise ApiValueError("Missing the required parameter `library_settings_type` when calling `update_library_settings`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'library_id' in local_var_params:
            path_params['library-id'] = local_var_params['library_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'library_settings_type' in local_var_params:
            body_params = local_var_params['library_settings_type']
        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'application/xml'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/library/{library-id}/settings', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)
