# coding: utf-8

"""
    Vidispine API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)  # noqa: E501

    The version of the OpenAPI document: 5.x
    Contact: info@vidispine.com
    Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from vidispine.models import *
from vidispine.api_client import ApiClient
from vidispine.exceptions import (
    ApiTypeError,
    ApiValueError
)


class MetadataFieldGroupsApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def add_metadata_field_group_to_field_group(self, parent_group_name, child_group_name, **kwargs):  # noqa: E501
        """Add a group to a group  # noqa: E501

        Adds the group with the specified name to the group. If the group is already contained within the group this operation does nothing.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.add_metadata_field_group_to_field_group(parent_group_name, child_group_name, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str parent_group_name: The parent group name. (required)
        :param str child_group_name: The child group name. (required)
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None.
                 If the method is called asynchronously, returns the request thread.
        :rtype: None or multiprocessing.pool.AsyncResult
        """
        kwargs['_return_http_data_only'] = True
        return self.add_metadata_field_group_to_field_group_with_http_info(parent_group_name, child_group_name, **kwargs)  # noqa: E501

    def add_metadata_field_group_to_field_group_with_http_info(self, parent_group_name, child_group_name, **kwargs):  # noqa: E501
        """Add a group to a group  # noqa: E501

        Adds the group with the specified name to the group. If the group is already contained within the group this operation does nothing.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_metadata_field_group_to_field_group_with_http_info(parent_group_name, child_group_name, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str parent_group_name: The parent group name. (required)
        :param str child_group_name: The child group name. (required)
        :key _return_http_data_only: response data without head status code
                                       and headers
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['parent_group_name', 'child_group_name']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method add_metadata_field_group_to_field_group" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'parent_group_name' is set
        if ('parent_group_name' not in local_var_params or
                local_var_params['parent_group_name'] is None):
            raise ApiValueError("Missing the required parameter `parent_group_name` when calling `add_metadata_field_group_to_field_group`")  # noqa: E501
        # verify the required parameter 'child_group_name' is set
        if ('child_group_name' not in local_var_params or
                local_var_params['child_group_name'] is None):
            raise ApiValueError("Missing the required parameter `child_group_name` when calling `add_metadata_field_group_to_field_group`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'parent_group_name' in local_var_params:
            path_params['parent-group-name'] = local_var_params['parent_group_name']  # noqa: E501
        if 'child_group_name' in local_var_params:
            path_params['child-group-name'] = local_var_params['child_group_name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/metadata-field/field-group/{parent-group-name}/group/{child-group-name}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_metadata_field_group(self, group_name, **kwargs):  # noqa: E501
        """Delete a field group  # noqa: E501

        Deletes the group with the given name.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_metadata_field_group(group_name, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str group_name: The group name. (required)
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None.
                 If the method is called asynchronously, returns the request thread.
        :rtype: None or multiprocessing.pool.AsyncResult
        """
        kwargs['_return_http_data_only'] = True
        return self.delete_metadata_field_group_with_http_info(group_name, **kwargs)  # noqa: E501

    def delete_metadata_field_group_with_http_info(self, group_name, **kwargs):  # noqa: E501
        """Delete a field group  # noqa: E501

        Deletes the group with the given name.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_metadata_field_group_with_http_info(group_name, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str group_name: The group name. (required)
        :key _return_http_data_only: response data without head status code
                                       and headers
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['group_name']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_metadata_field_group" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'group_name' is set
        if ('group_name' not in local_var_params or
                local_var_params['group_name'] is None):
            raise ApiValueError("Missing the required parameter `group_name` when calling `delete_metadata_field_group`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'group_name' in local_var_params:
            path_params['group-name'] = local_var_params['group_name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/metadata-field/field-group/{group-name}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_metadata_field_group_field(self, group_name, field_name, **kwargs):  # noqa: E501
        """Remove a field from a group  # noqa: E501

        Removes the field with the specified name from the group.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_metadata_field_group_field(group_name, field_name, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str group_name: The group name. (required)
        :param str field_name: The field name. (required)
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None.
                 If the method is called asynchronously, returns the request thread.
        :rtype: None or multiprocessing.pool.AsyncResult
        """
        kwargs['_return_http_data_only'] = True
        return self.delete_metadata_field_group_field_with_http_info(group_name, field_name, **kwargs)  # noqa: E501

    def delete_metadata_field_group_field_with_http_info(self, group_name, field_name, **kwargs):  # noqa: E501
        """Remove a field from a group  # noqa: E501

        Removes the field with the specified name from the group.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_metadata_field_group_field_with_http_info(group_name, field_name, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str group_name: The group name. (required)
        :param str field_name: The field name. (required)
        :key _return_http_data_only: response data without head status code
                                       and headers
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['group_name', 'field_name']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_metadata_field_group_field" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'group_name' is set
        if ('group_name' not in local_var_params or
                local_var_params['group_name'] is None):
            raise ApiValueError("Missing the required parameter `group_name` when calling `delete_metadata_field_group_field`")  # noqa: E501
        # verify the required parameter 'field_name' is set
        if ('field_name' not in local_var_params or
                local_var_params['field_name'] is None):
            raise ApiValueError("Missing the required parameter `field_name` when calling `delete_metadata_field_group_field`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'group_name' in local_var_params:
            path_params['group-name'] = local_var_params['group_name']  # noqa: E501
        if 'field_name' in local_var_params:
            path_params['field-name'] = local_var_params['field_name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/metadata-field/field-group/{group-name}/{field-name}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_metadata_field_group_from_field_group(self, parent_group_name, child_group_name, **kwargs):  # noqa: E501
        """Remove a group from a group  # noqa: E501

        Removes the group with the specified name from the group.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_metadata_field_group_from_field_group(parent_group_name, child_group_name, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str parent_group_name: The parent group name. (required)
        :param str child_group_name: The child group name. (required)
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None.
                 If the method is called asynchronously, returns the request thread.
        :rtype: None or multiprocessing.pool.AsyncResult
        """
        kwargs['_return_http_data_only'] = True
        return self.delete_metadata_field_group_from_field_group_with_http_info(parent_group_name, child_group_name, **kwargs)  # noqa: E501

    def delete_metadata_field_group_from_field_group_with_http_info(self, parent_group_name, child_group_name, **kwargs):  # noqa: E501
        """Remove a group from a group  # noqa: E501

        Removes the group with the specified name from the group.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_metadata_field_group_from_field_group_with_http_info(parent_group_name, child_group_name, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str parent_group_name: The parent group name. (required)
        :param str child_group_name: The child group name. (required)
        :key _return_http_data_only: response data without head status code
                                       and headers
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['parent_group_name', 'child_group_name']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_metadata_field_group_from_field_group" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'parent_group_name' is set
        if ('parent_group_name' not in local_var_params or
                local_var_params['parent_group_name'] is None):
            raise ApiValueError("Missing the required parameter `parent_group_name` when calling `delete_metadata_field_group_from_field_group`")  # noqa: E501
        # verify the required parameter 'child_group_name' is set
        if ('child_group_name' not in local_var_params or
                local_var_params['child_group_name'] is None):
            raise ApiValueError("Missing the required parameter `child_group_name` when calling `delete_metadata_field_group_from_field_group`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'parent_group_name' in local_var_params:
            path_params['parent-group-name'] = local_var_params['parent_group_name']  # noqa: E501
        if 'child_group_name' in local_var_params:
            path_params['child-group-name'] = local_var_params['child_group_name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/metadata-field/field-group/{parent-group-name}/group/{child-group-name}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_metadata_field_group_metadata(self, group_name, **kwargs):  # noqa: E501
        """Delete all key-value pairs  # noqa: E501

        Clears all key-value pairs for the specified entity.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_metadata_field_group_metadata(group_name, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str group_name: The group name. (required)
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None.
                 If the method is called asynchronously, returns the request thread.
        :rtype: None or multiprocessing.pool.AsyncResult
        """
        kwargs['_return_http_data_only'] = True
        return self.delete_metadata_field_group_metadata_with_http_info(group_name, **kwargs)  # noqa: E501

    def delete_metadata_field_group_metadata_with_http_info(self, group_name, **kwargs):  # noqa: E501
        """Delete all key-value pairs  # noqa: E501

        Clears all key-value pairs for the specified entity.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_metadata_field_group_metadata_with_http_info(group_name, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str group_name: The group name. (required)
        :key _return_http_data_only: response data without head status code
                                       and headers
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['group_name']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_metadata_field_group_metadata" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'group_name' is set
        if ('group_name' not in local_var_params or
                local_var_params['group_name'] is None):
            raise ApiValueError("Missing the required parameter `group_name` when calling `delete_metadata_field_group_metadata`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'group_name' in local_var_params:
            path_params['group-name'] = local_var_params['group_name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/metadata-field/field-group/{group-name}/metadata', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_metadata_field_group_metadata_key(self, group_name, keypath, **kwargs):  # noqa: E501
        """Delete key-value pairs  # noqa: E501

        Deletes the key-value pair with the specified key. If a key path is given, it may include wildcards for deleting multiple keys.  Key paths can also be specified as well as specific keys.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_metadata_field_group_metadata_key(group_name, keypath, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str group_name: The group name. (required)
        :param str keypath: The keypath. (required)
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None.
                 If the method is called asynchronously, returns the request thread.
        :rtype: None or multiprocessing.pool.AsyncResult
        """
        kwargs['_return_http_data_only'] = True
        return self.delete_metadata_field_group_metadata_key_with_http_info(group_name, keypath, **kwargs)  # noqa: E501

    def delete_metadata_field_group_metadata_key_with_http_info(self, group_name, keypath, **kwargs):  # noqa: E501
        """Delete key-value pairs  # noqa: E501

        Deletes the key-value pair with the specified key. If a key path is given, it may include wildcards for deleting multiple keys.  Key paths can also be specified as well as specific keys.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_metadata_field_group_metadata_key_with_http_info(group_name, keypath, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str group_name: The group name. (required)
        :param str keypath: The keypath. (required)
        :key _return_http_data_only: response data without head status code
                                       and headers
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['group_name', 'keypath']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_metadata_field_group_metadata_key" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'group_name' is set
        if ('group_name' not in local_var_params or
                local_var_params['group_name'] is None):
            raise ApiValueError("Missing the required parameter `group_name` when calling `delete_metadata_field_group_metadata_key`")  # noqa: E501
        # verify the required parameter 'keypath' is set
        if ('keypath' not in local_var_params or
                local_var_params['keypath'] is None):
            raise ApiValueError("Missing the required parameter `keypath` when calling `delete_metadata_field_group_metadata_key`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'group_name' in local_var_params:
            path_params['group-name'] = local_var_params['group_name']  # noqa: E501
        if 'keypath' in local_var_params:
            path_params['keypath'] = local_var_params['keypath']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/metadata-field/field-group/{group-name}/metadata/{keypath}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_metadata_field_group(self, group_name, **kwargs):  # noqa: E501
        """List all fields of a group  # noqa: E501

        Retrieves the specified field group.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_metadata_field_group(group_name, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str group_name: The group name. (required)
        :key list[str] data: Comma-separated list of any additional data to include.   - accepts wildcard characters.  e. g.   `*`, `myapp_*`,  `*_version`.  (New in 4. 17. )
        :key bool traverse: - `true` - Traverse any sub-groups in order to retrieve the entire hierarchy.  - `false` (default) - Only retrieves the names of the members.
        :key bool include_values: Return the value enumeration for each field
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: MetadataFieldGroupType.
                 If the method is called asynchronously, returns the request thread.
        :rtype: MetadataFieldGroupType or multiprocessing.pool.AsyncResult
        """
        kwargs['_return_http_data_only'] = True
        return self.get_metadata_field_group_with_http_info(group_name, **kwargs)  # noqa: E501

    def get_metadata_field_group_with_http_info(self, group_name, **kwargs):  # noqa: E501
        """List all fields of a group  # noqa: E501

        Retrieves the specified field group.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_metadata_field_group_with_http_info(group_name, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str group_name: The group name. (required)
        :key list[str] data: Comma-separated list of any additional data to include.   - accepts wildcard characters.  e. g.   `*`, `myapp_*`,  `*_version`.  (New in 4. 17. )
        :key bool traverse: - `true` - Traverse any sub-groups in order to retrieve the entire hierarchy.  - `false` (default) - Only retrieves the names of the members.
        :key bool include_values: Return the value enumeration for each field
        :key _return_http_data_only: response data without head status code
                                       and headers
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(MetadataFieldGroupType, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['group_name', 'data', 'traverse', 'include_values']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_metadata_field_group" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'group_name' is set
        if ('group_name' not in local_var_params or
                local_var_params['group_name'] is None):
            raise ApiValueError("Missing the required parameter `group_name` when calling `get_metadata_field_group`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'group_name' in local_var_params:
            path_params['group-name'] = local_var_params['group_name']  # noqa: E501

        query_params = []
        if 'data' in local_var_params:
            query_params.append(('data', local_var_params['data']))  # noqa: E501
            collection_formats['data'] = 'csv'  # noqa: E501
        if 'traverse' in local_var_params:
            query_params.append(('traverse', local_var_params['traverse']))  # noqa: E501
        if 'include_values' in local_var_params:
            query_params.append(('includeValues', local_var_params['include_values']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'application/xml'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/metadata-field/field-group/{group-name}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='MetadataFieldGroupType',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_metadata_field_group_merged_access(self, group_name, **kwargs):  # noqa: E501
        """Retrieve user access to field group  # noqa: E501

        Retrieves the permission for a specific user to a field group and the field groups and fields part of that group.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_metadata_field_group_merged_access(group_name, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str group_name: The group name. (required)
        :key str username: The name of the user to check.
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: AccessControlMergedType.
                 If the method is called asynchronously, returns the request thread.
        :rtype: AccessControlMergedType or multiprocessing.pool.AsyncResult
        """
        kwargs['_return_http_data_only'] = True
        return self.get_metadata_field_group_merged_access_with_http_info(group_name, **kwargs)  # noqa: E501

    def get_metadata_field_group_merged_access_with_http_info(self, group_name, **kwargs):  # noqa: E501
        """Retrieve user access to field group  # noqa: E501

        Retrieves the permission for a specific user to a field group and the field groups and fields part of that group.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_metadata_field_group_merged_access_with_http_info(group_name, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str group_name: The group name. (required)
        :key str username: The name of the user to check.
        :key _return_http_data_only: response data without head status code
                                       and headers
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(AccessControlMergedType, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['group_name', 'username']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_metadata_field_group_merged_access" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'group_name' is set
        if ('group_name' not in local_var_params or
                local_var_params['group_name'] is None):
            raise ApiValueError("Missing the required parameter `group_name` when calling `get_metadata_field_group_merged_access`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'group_name' in local_var_params:
            path_params['group-name'] = local_var_params['group_name']  # noqa: E501

        query_params = []
        if 'username' in local_var_params:
            query_params.append(('username', local_var_params['username']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'application/xml'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/metadata-field/field-group/{group-name}/merged-access/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AccessControlMergedType',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_metadata_field_group_metadata(self, group_name, **kwargs):  # noqa: E501
        """Retrieve all metadata  # noqa: E501

        Retrieves all key-value pairs associated with the specified entity.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_metadata_field_group_metadata(group_name, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str group_name: The group name. (required)
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: SimpleMetadataType.
                 If the method is called asynchronously, returns the request thread.
        :rtype: SimpleMetadataType or multiprocessing.pool.AsyncResult
        """
        kwargs['_return_http_data_only'] = True
        return self.get_metadata_field_group_metadata_with_http_info(group_name, **kwargs)  # noqa: E501

    def get_metadata_field_group_metadata_with_http_info(self, group_name, **kwargs):  # noqa: E501
        """Retrieve all metadata  # noqa: E501

        Retrieves all key-value pairs associated with the specified entity.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_metadata_field_group_metadata_with_http_info(group_name, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str group_name: The group name. (required)
        :key _return_http_data_only: response data without head status code
                                       and headers
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(SimpleMetadataType, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['group_name']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_metadata_field_group_metadata" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'group_name' is set
        if ('group_name' not in local_var_params or
                local_var_params['group_name'] is None):
            raise ApiValueError("Missing the required parameter `group_name` when calling `get_metadata_field_group_metadata`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'group_name' in local_var_params:
            path_params['group-name'] = local_var_params['group_name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'application/xml'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/metadata-field/field-group/{group-name}/metadata', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SimpleMetadataType',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_metadata_field_group_metadata_key(self, group_name, keypath, **kwargs):  # noqa: E501
        """Retrieve the metadata for a specific key  # noqa: E501

        Retrieves the value of a specific key. If a key path is specified, exactly one key-value pair must match the key path, else an error is returned.  Key paths can also be specified as well as specific keys.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_metadata_field_group_metadata_key(group_name, keypath, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str group_name: The group name. (required)
        :param str keypath: The keypath. (required)
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: str.
                 If the method is called asynchronously, returns the request thread.
        :rtype: str or multiprocessing.pool.AsyncResult
        """
        kwargs['_return_http_data_only'] = True
        return self.get_metadata_field_group_metadata_key_with_http_info(group_name, keypath, **kwargs)  # noqa: E501

    def get_metadata_field_group_metadata_key_with_http_info(self, group_name, keypath, **kwargs):  # noqa: E501
        """Retrieve the metadata for a specific key  # noqa: E501

        Retrieves the value of a specific key. If a key path is specified, exactly one key-value pair must match the key path, else an error is returned.  Key paths can also be specified as well as specific keys.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_metadata_field_group_metadata_key_with_http_info(group_name, keypath, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str group_name: The group name. (required)
        :param str keypath: The keypath. (required)
        :key _return_http_data_only: response data without head status code
                                       and headers
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(str, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['group_name', 'keypath']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_metadata_field_group_metadata_key" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'group_name' is set
        if ('group_name' not in local_var_params or
                local_var_params['group_name'] is None):
            raise ApiValueError("Missing the required parameter `group_name` when calling `get_metadata_field_group_metadata_key`")  # noqa: E501
        # verify the required parameter 'keypath' is set
        if ('keypath' not in local_var_params or
                local_var_params['keypath'] is None):
            raise ApiValueError("Missing the required parameter `keypath` when calling `get_metadata_field_group_metadata_key`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'group_name' in local_var_params:
            path_params['group-name'] = local_var_params['group_name']  # noqa: E501
        if 'keypath' in local_var_params:
            path_params['keypath'] = local_var_params['keypath']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/metadata-field/field-group/{group-name}/metadata/{keypath}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='str',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_metadata_field_groups(self, **kwargs):  # noqa: E501
        """List all field groups  # noqa: E501

        Retrieves all metadata field groups known by the system.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_metadata_field_groups(async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :key list[str] data: Comma-separated list of any additional data to include.   - accepts wildcard characters.  e. g.   `*`, `myapp_*`,  `*_version`.  (New in 4. 17. )
        :key bool content: - `true` - Return the groups and their members.  - `false` (default) - Return the group names only.
        :key bool traverse: - `true` - Traverse any sub-groups in order to retrieve the entire hierarchy.  - `false` (default) - Only retrieves the names of the members.
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: MetadataFieldGroupListType.
                 If the method is called asynchronously, returns the request thread.
        :rtype: MetadataFieldGroupListType or multiprocessing.pool.AsyncResult
        """
        kwargs['_return_http_data_only'] = True
        return self.get_metadata_field_groups_with_http_info(**kwargs)  # noqa: E501

    def get_metadata_field_groups_with_http_info(self, **kwargs):  # noqa: E501
        """List all field groups  # noqa: E501

        Retrieves all metadata field groups known by the system.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_metadata_field_groups_with_http_info(async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :key list[str] data: Comma-separated list of any additional data to include.   - accepts wildcard characters.  e. g.   `*`, `myapp_*`,  `*_version`.  (New in 4. 17. )
        :key bool content: - `true` - Return the groups and their members.  - `false` (default) - Return the group names only.
        :key bool traverse: - `true` - Traverse any sub-groups in order to retrieve the entire hierarchy.  - `false` (default) - Only retrieves the names of the members.
        :key _return_http_data_only: response data without head status code
                                       and headers
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(MetadataFieldGroupListType, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['data', 'content', 'traverse']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_metadata_field_groups" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'data' in local_var_params:
            query_params.append(('data', local_var_params['data']))  # noqa: E501
            collection_formats['data'] = 'csv'  # noqa: E501
        if 'content' in local_var_params:
            query_params.append(('content', local_var_params['content']))  # noqa: E501
        if 'traverse' in local_var_params:
            query_params.append(('traverse', local_var_params['traverse']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'text/plain', 'application/xml'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/metadata-field/field-group', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='MetadataFieldGroupListType',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_metadata_field_groups_merged_access(self, **kwargs):  # noqa: E501
        """Retrieve user access to all field groups  # noqa: E501

        Retrieves the permission for a specific user to all field groups and the field groups and fields part of those groups.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_metadata_field_groups_merged_access(async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :key str username: The name of the user to check.
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: AccessControlMergedType.
                 If the method is called asynchronously, returns the request thread.
        :rtype: AccessControlMergedType or multiprocessing.pool.AsyncResult
        """
        kwargs['_return_http_data_only'] = True
        return self.get_metadata_field_groups_merged_access_with_http_info(**kwargs)  # noqa: E501

    def get_metadata_field_groups_merged_access_with_http_info(self, **kwargs):  # noqa: E501
        """Retrieve user access to all field groups  # noqa: E501

        Retrieves the permission for a specific user to all field groups and the field groups and fields part of those groups.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_metadata_field_groups_merged_access_with_http_info(async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :key str username: The name of the user to check.
        :key _return_http_data_only: response data without head status code
                                       and headers
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(AccessControlMergedType, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['username']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_metadata_field_groups_merged_access" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'username' in local_var_params:
            query_params.append(('username', local_var_params['username']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'application/xml'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/metadata-field/field-group/merged-access/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AccessControlMergedType',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def search_metadata_field_groups(self, item_search_type, **kwargs):  # noqa: E501
        """Search for groups used in metadata  # noqa: E501

        Much like searching for items, specific fields can be used when searching. The result is a list of used metadata groups that matches the query. Optionally the definition of the group and the value of the group can be retrieved.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.search_metadata_field_groups(item_search_type, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param ItemSearchType item_search_type: (required)
        :key str source: - `item` - Only search for groups in item metadata.  - `collection` - Only search for groups in collection metadata.  - `global` - Only search for groups in the global metadata.  - `document` - Only search for groups in the document metadata.
        :key int first: From the resulting list of items, start return list from specified offset.
        :key list[str] data: Comma-separated list of any additional data to include.   - accepts wildcard characters.  e. g.   `*`, `myapp_*`,  `*_version`.  (New in 4. 17. )
        :key int number: The number of entities to fetch.
        :key bool include_source: - `true` - Information about which entity that contains the matching metadata group is included in the result.  - `false` (default) - Entity information is not included.
        :key bool traverse: - `true` - Traverse any sub-groups in order to retrieve the entire hierarchy.  - `false` (default) - Only retrieves the names of the members.
        :key bool include_value: - `true` - The value is included in the result.  I. e. , how the group is specified in the metadata.  - `false` (default) - The value is not included.
        :key bool include_definition: - `true` - The definition of the group is included in the result.  - `false` (default) - The definition is not included.
        :key list[str] group: Comma-separated list of group names to restrict search in.
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: MetadataFieldResultType.
                 If the method is called asynchronously, returns the request thread.
        :rtype: MetadataFieldResultType or multiprocessing.pool.AsyncResult
        """
        kwargs['_return_http_data_only'] = True
        return self.search_metadata_field_groups_with_http_info(item_search_type, **kwargs)  # noqa: E501

    def search_metadata_field_groups_with_http_info(self, item_search_type, **kwargs):  # noqa: E501
        """Search for groups used in metadata  # noqa: E501

        Much like searching for items, specific fields can be used when searching. The result is a list of used metadata groups that matches the query. Optionally the definition of the group and the value of the group can be retrieved.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.search_metadata_field_groups_with_http_info(item_search_type, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param ItemSearchType item_search_type: (required)
        :key str source: - `item` - Only search for groups in item metadata.  - `collection` - Only search for groups in collection metadata.  - `global` - Only search for groups in the global metadata.  - `document` - Only search for groups in the document metadata.
        :key int first: From the resulting list of items, start return list from specified offset.
        :key list[str] data: Comma-separated list of any additional data to include.   - accepts wildcard characters.  e. g.   `*`, `myapp_*`,  `*_version`.  (New in 4. 17. )
        :key int number: The number of entities to fetch.
        :key bool include_source: - `true` - Information about which entity that contains the matching metadata group is included in the result.  - `false` (default) - Entity information is not included.
        :key bool traverse: - `true` - Traverse any sub-groups in order to retrieve the entire hierarchy.  - `false` (default) - Only retrieves the names of the members.
        :key bool include_value: - `true` - The value is included in the result.  I. e. , how the group is specified in the metadata.  - `false` (default) - The value is not included.
        :key bool include_definition: - `true` - The definition of the group is included in the result.  - `false` (default) - The definition is not included.
        :key list[str] group: Comma-separated list of group names to restrict search in.
        :key _return_http_data_only: response data without head status code
                                       and headers
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(MetadataFieldResultType, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['item_search_type', 'source', 'first', 'data', 'number', 'include_source', 'traverse', 'include_value', 'include_definition', 'group']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method search_metadata_field_groups" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'item_search_type' is set
        if ('item_search_type' not in local_var_params or
                local_var_params['item_search_type'] is None):
            raise ApiValueError("Missing the required parameter `item_search_type` when calling `search_metadata_field_groups`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'source' in local_var_params:
            query_params.append(('source', local_var_params['source']))  # noqa: E501
        if 'first' in local_var_params:
            query_params.append(('first', local_var_params['first']))  # noqa: E501
        if 'data' in local_var_params:
            query_params.append(('data', local_var_params['data']))  # noqa: E501
            collection_formats['data'] = 'csv'  # noqa: E501
        if 'number' in local_var_params:
            query_params.append(('number', local_var_params['number']))  # noqa: E501
        if 'include_source' in local_var_params:
            query_params.append(('includeSource', local_var_params['include_source']))  # noqa: E501
        if 'traverse' in local_var_params:
            query_params.append(('traverse', local_var_params['traverse']))  # noqa: E501
        if 'include_value' in local_var_params:
            query_params.append(('includeValue', local_var_params['include_value']))  # noqa: E501
        if 'include_definition' in local_var_params:
            query_params.append(('includeDefinition', local_var_params['include_definition']))  # noqa: E501
        if 'group' in local_var_params:
            query_params.append(('group', local_var_params['group']))  # noqa: E501
            collection_formats['group'] = 'csv'  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'item_search_type' in local_var_params:
            body_params = local_var_params['item_search_type']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'application/xml'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'application/xml'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/metadata-field/field-group', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='MetadataFieldResultType',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_metadata_field_group(self, group_name, field_name, **kwargs):  # noqa: E501
        """Add a field to a group  # noqa: E501

        Adds the field with the specified name to the group. If the field is already contained within the group this operation does nothing.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_metadata_field_group(group_name, field_name, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str group_name: The group name. (required)
        :param str field_name: The field name. (required)
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None.
                 If the method is called asynchronously, returns the request thread.
        :rtype: None or multiprocessing.pool.AsyncResult
        """
        kwargs['_return_http_data_only'] = True
        return self.update_metadata_field_group_with_http_info(group_name, field_name, **kwargs)  # noqa: E501

    def update_metadata_field_group_with_http_info(self, group_name, field_name, **kwargs):  # noqa: E501
        """Add a field to a group  # noqa: E501

        Adds the field with the specified name to the group. If the field is already contained within the group this operation does nothing.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_metadata_field_group_with_http_info(group_name, field_name, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str group_name: The group name. (required)
        :param str field_name: The field name. (required)
        :key _return_http_data_only: response data without head status code
                                       and headers
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['group_name', 'field_name']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_metadata_field_group" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'group_name' is set
        if ('group_name' not in local_var_params or
                local_var_params['group_name'] is None):
            raise ApiValueError("Missing the required parameter `group_name` when calling `update_metadata_field_group`")  # noqa: E501
        # verify the required parameter 'field_name' is set
        if ('field_name' not in local_var_params or
                local_var_params['field_name'] is None):
            raise ApiValueError("Missing the required parameter `field_name` when calling `update_metadata_field_group`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'group_name' in local_var_params:
            path_params['group-name'] = local_var_params['group_name']  # noqa: E501
        if 'field_name' in local_var_params:
            path_params['field-name'] = local_var_params['field_name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/metadata-field/field-group/{group-name}/{field-name}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_metadata_field_group_metadata(self, group_name, simple_metadata_type, **kwargs):  # noqa: E501
        """Create multiple key-value pairs  # noqa: E501

        Sets all the specified key-value pairs.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_metadata_field_group_metadata(group_name, simple_metadata_type, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str group_name: The group name. (required)
        :param SimpleMetadataType simple_metadata_type: (required)
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None.
                 If the method is called asynchronously, returns the request thread.
        :rtype: None or multiprocessing.pool.AsyncResult
        """
        kwargs['_return_http_data_only'] = True
        return self.update_metadata_field_group_metadata_with_http_info(group_name, simple_metadata_type, **kwargs)  # noqa: E501

    def update_metadata_field_group_metadata_with_http_info(self, group_name, simple_metadata_type, **kwargs):  # noqa: E501
        """Create multiple key-value pairs  # noqa: E501

        Sets all the specified key-value pairs.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_metadata_field_group_metadata_with_http_info(group_name, simple_metadata_type, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str group_name: The group name. (required)
        :param SimpleMetadataType simple_metadata_type: (required)
        :key _return_http_data_only: response data without head status code
                                       and headers
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['group_name', 'simple_metadata_type']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_metadata_field_group_metadata" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'group_name' is set
        if ('group_name' not in local_var_params or
                local_var_params['group_name'] is None):
            raise ApiValueError("Missing the required parameter `group_name` when calling `update_metadata_field_group_metadata`")  # noqa: E501
        # verify the required parameter 'simple_metadata_type' is set
        if ('simple_metadata_type' not in local_var_params or
                local_var_params['simple_metadata_type'] is None):
            raise ApiValueError("Missing the required parameter `simple_metadata_type` when calling `update_metadata_field_group_metadata`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'group_name' in local_var_params:
            path_params['group-name'] = local_var_params['group_name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'simple_metadata_type' in local_var_params:
            body_params = local_var_params['simple_metadata_type']
        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'application/xml'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/metadata-field/field-group/{group-name}/metadata', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_metadata_field_group_metadata_key(self, group_name, keypath, body, **kwargs):  # noqa: E501
        """Set the value for a specific key  # noqa: E501

        Sets the value for a specific key. The key path may not contain wildcards.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_metadata_field_group_metadata_key(group_name, keypath, body, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str group_name: The group name. (required)
        :param str keypath: The keypath. (required)
        :param str body: The raw string value. (required)
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None.
                 If the method is called asynchronously, returns the request thread.
        :rtype: None or multiprocessing.pool.AsyncResult
        """
        kwargs['_return_http_data_only'] = True
        return self.update_metadata_field_group_metadata_key_with_http_info(group_name, keypath, body, **kwargs)  # noqa: E501

    def update_metadata_field_group_metadata_key_with_http_info(self, group_name, keypath, body, **kwargs):  # noqa: E501
        """Set the value for a specific key  # noqa: E501

        Sets the value for a specific key. The key path may not contain wildcards.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_metadata_field_group_metadata_key_with_http_info(group_name, keypath, body, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str group_name: The group name. (required)
        :param str keypath: The keypath. (required)
        :param str body: The raw string value. (required)
        :key _return_http_data_only: response data without head status code
                                       and headers
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['group_name', 'keypath', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_metadata_field_group_metadata_key" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'group_name' is set
        if ('group_name' not in local_var_params or
                local_var_params['group_name'] is None):
            raise ApiValueError("Missing the required parameter `group_name` when calling `update_metadata_field_group_metadata_key`")  # noqa: E501
        # verify the required parameter 'keypath' is set
        if ('keypath' not in local_var_params or
                local_var_params['keypath'] is None):
            raise ApiValueError("Missing the required parameter `keypath` when calling `update_metadata_field_group_metadata_key`")  # noqa: E501
        # verify the required parameter 'body' is set
        if ('body' not in local_var_params or
                local_var_params['body'] is None):
            raise ApiValueError("Missing the required parameter `body` when calling `update_metadata_field_group_metadata_key`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'group_name' in local_var_params:
            path_params['group-name'] = local_var_params['group_name']  # noqa: E501
        if 'keypath' in local_var_params:
            path_params['keypath'] = local_var_params['keypath']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in local_var_params:
            body_params = local_var_params['body']
        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['text/plain'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/metadata-field/field-group/{group-name}/metadata/{keypath}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_or_create_metadata_field_group(self, group_name, metadata_field_group_type, **kwargs):  # noqa: E501
        """Update or create a field group  # noqa: E501

        Creates a new group with the given name, if it does not already exists, and adds any specified fields and access control entries to it. If the fields does not exist, they will be created. Furthermore any additional data for the fields will be set as well.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_or_create_metadata_field_group(group_name, metadata_field_group_type, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str group_name: The group name. (required)
        :param MetadataFieldGroupType metadata_field_group_type: (required)
        :key bool clear: - `true` - If the group already exists, clear all content from it before updating.  - `false` (default) - If the group already exists, append child groups/fields from the input document.
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None.
                 If the method is called asynchronously, returns the request thread.
        :rtype: None or multiprocessing.pool.AsyncResult
        """
        kwargs['_return_http_data_only'] = True
        return self.update_or_create_metadata_field_group_with_http_info(group_name, metadata_field_group_type, **kwargs)  # noqa: E501

    def update_or_create_metadata_field_group_with_http_info(self, group_name, metadata_field_group_type, **kwargs):  # noqa: E501
        """Update or create a field group  # noqa: E501

        Creates a new group with the given name, if it does not already exists, and adds any specified fields and access control entries to it. If the fields does not exist, they will be created. Furthermore any additional data for the fields will be set as well.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_or_create_metadata_field_group_with_http_info(group_name, metadata_field_group_type, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str group_name: The group name. (required)
        :param MetadataFieldGroupType metadata_field_group_type: (required)
        :key bool clear: - `true` - If the group already exists, clear all content from it before updating.  - `false` (default) - If the group already exists, append child groups/fields from the input document.
        :key _return_http_data_only: response data without head status code
                                       and headers
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['group_name', 'metadata_field_group_type', 'clear']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_or_create_metadata_field_group" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'group_name' is set
        if ('group_name' not in local_var_params or
                local_var_params['group_name'] is None):
            raise ApiValueError("Missing the required parameter `group_name` when calling `update_or_create_metadata_field_group`")  # noqa: E501
        # verify the required parameter 'metadata_field_group_type' is set
        if ('metadata_field_group_type' not in local_var_params or
                local_var_params['metadata_field_group_type'] is None):
            raise ApiValueError("Missing the required parameter `metadata_field_group_type` when calling `update_or_create_metadata_field_group`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'group_name' in local_var_params:
            path_params['group-name'] = local_var_params['group_name']  # noqa: E501

        query_params = []
        if 'clear' in local_var_params:
            query_params.append(('clear', local_var_params['clear']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'metadata_field_group_type' in local_var_params:
            body_params = local_var_params['metadata_field_group_type']
        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'application/xml'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/metadata-field/field-group/{group-name}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)
