# coding: utf-8

"""
    Vidispine API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)  # noqa: E501

    The version of the OpenAPI document: 5.x
    Contact: info@vidispine.com
    Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from vidispine.models import *
from vidispine.api_client import ApiClient
from vidispine.exceptions import (
    ApiTypeError,
    ApiValueError
)


class ProjectVersionApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def create_project_version(self, id, project_version_type, **kwargs):  # noqa: E501
        """Create a project version collection  # noqa: E501

        Creates a new project version collection for a specific project.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_project_version(id, project_version_type, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str id: The id. (required)
        :param ProjectVersionType project_version_type: (required)
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: URIListType.
                 If the method is called asynchronously, returns the request thread.
        :rtype: URIListType or multiprocessing.pool.AsyncResult
        """
        kwargs['_return_http_data_only'] = True
        return self.create_project_version_with_http_info(id, project_version_type, **kwargs)  # noqa: E501

    def create_project_version_with_http_info(self, id, project_version_type, **kwargs):  # noqa: E501
        """Create a project version collection  # noqa: E501

        Creates a new project version collection for a specific project.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_project_version_with_http_info(id, project_version_type, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str id: The id. (required)
        :param ProjectVersionType project_version_type: (required)
        :key _return_http_data_only: response data without head status code
                                       and headers
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(URIListType, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['id', 'project_version_type']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_project_version" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in local_var_params or
                local_var_params['id'] is None):
            raise ApiValueError("Missing the required parameter `id` when calling `create_project_version`")  # noqa: E501
        # verify the required parameter 'project_version_type' is set
        if ('project_version_type' not in local_var_params or
                local_var_params['project_version_type'] is None):
            raise ApiValueError("Missing the required parameter `project_version_type` when calling `create_project_version`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'project_version_type' in local_var_params:
            body_params = local_var_params['project_version_type']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'text/plain', 'application/xml'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'application/xml'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/collection/{id}/version', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='URIListType',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_project_version_asset_document(self, id, format, **kwargs):  # noqa: E501
        """Delete the asset definition  # noqa: E501

        Deletes an asset document for a specific project version definition.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_project_version_asset_document(id, format, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str id: The id. (required)
        :param str format: The format. (required)
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None.
                 If the method is called asynchronously, returns the request thread.
        :rtype: None or multiprocessing.pool.AsyncResult
        """
        kwargs['_return_http_data_only'] = True
        return self.delete_project_version_asset_document_with_http_info(id, format, **kwargs)  # noqa: E501

    def delete_project_version_asset_document_with_http_info(self, id, format, **kwargs):  # noqa: E501
        """Delete the asset definition  # noqa: E501

        Deletes an asset document for a specific project version definition.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_project_version_asset_document_with_http_info(id, format, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str id: The id. (required)
        :param str format: The format. (required)
        :key _return_http_data_only: response data without head status code
                                       and headers
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['id', 'format']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_project_version_asset_document" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in local_var_params or
                local_var_params['id'] is None):
            raise ApiValueError("Missing the required parameter `id` when calling `delete_project_version_asset_document`")  # noqa: E501
        # verify the required parameter 'format' is set
        if ('format' not in local_var_params or
                local_var_params['format'] is None):
            raise ApiValueError("Missing the required parameter `format` when calling `delete_project_version_asset_document`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501
        if 'format' in local_var_params:
            path_params['format'] = local_var_params['format']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/collection/{id}/definition/{format}/asset', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_project_version_binary(self, id, format, **kwargs):  # noqa: E501
        """Delete a project version definition  # noqa: E501

        Deletes a binary representation of the project version.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_project_version_binary(id, format, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str id: The id. (required)
        :param str format: The format. (required)
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None.
                 If the method is called asynchronously, returns the request thread.
        :rtype: None or multiprocessing.pool.AsyncResult
        """
        kwargs['_return_http_data_only'] = True
        return self.delete_project_version_binary_with_http_info(id, format, **kwargs)  # noqa: E501

    def delete_project_version_binary_with_http_info(self, id, format, **kwargs):  # noqa: E501
        """Delete a project version definition  # noqa: E501

        Deletes a binary representation of the project version.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_project_version_binary_with_http_info(id, format, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str id: The id. (required)
        :param str format: The format. (required)
        :key _return_http_data_only: response data without head status code
                                       and headers
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['id', 'format']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_project_version_binary" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in local_var_params or
                local_var_params['id'] is None):
            raise ApiValueError("Missing the required parameter `id` when calling `delete_project_version_binary`")  # noqa: E501
        # verify the required parameter 'format' is set
        if ('format' not in local_var_params or
                local_var_params['format'] is None):
            raise ApiValueError("Missing the required parameter `format` when calling `delete_project_version_binary`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501
        if 'format' in local_var_params:
            path_params['format'] = local_var_params['format']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/collection/{id}/definition/{format}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_project_version_extra_data(self, id, format, **kwargs):  # noqa: E501
        """Delete the extradata  # noqa: E501

        Deletes the extradata for a specific project version definition.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_project_version_extra_data(id, format, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str id: The id. (required)
        :param str format: The format. (required)
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None.
                 If the method is called asynchronously, returns the request thread.
        :rtype: None or multiprocessing.pool.AsyncResult
        """
        kwargs['_return_http_data_only'] = True
        return self.delete_project_version_extra_data_with_http_info(id, format, **kwargs)  # noqa: E501

    def delete_project_version_extra_data_with_http_info(self, id, format, **kwargs):  # noqa: E501
        """Delete the extradata  # noqa: E501

        Deletes the extradata for a specific project version definition.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_project_version_extra_data_with_http_info(id, format, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str id: The id. (required)
        :param str format: The format. (required)
        :key _return_http_data_only: response data without head status code
                                       and headers
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['id', 'format']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_project_version_extra_data" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in local_var_params or
                local_var_params['id'] is None):
            raise ApiValueError("Missing the required parameter `id` when calling `delete_project_version_extra_data`")  # noqa: E501
        # verify the required parameter 'format' is set
        if ('format' not in local_var_params or
                local_var_params['format'] is None):
            raise ApiValueError("Missing the required parameter `format` when calling `delete_project_version_extra_data`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501
        if 'format' in local_var_params:
            path_params['format'] = local_var_params['format']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/collection/{id}/definition/{format}/extradata', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def export_project(self, id, export_request_type, **kwargs):  # noqa: E501
        """Export a project or sequence  # noqa: E501

        Exports the sequence or project to the requested output format and saves the result at the given location.  For POST /sequence/export the sequence must be specified in the request document.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.export_project(id, export_request_type, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str id: The id. (required)
        :param ExportRequestType export_request_type: <em>ExportRequestDocument</em> with details on the export. (required)
        :key str format: Comma separated list of formats specifying which shapes to reference in the output.  If both tag and format is given, then both must match.
        :key bool to_sequence: Export as a sequence with an item, instead of as a standalone item
        :key bool dry_run: When set to `true`, any export problems will be returned and no file will be written
        :key str tag: Comma separated list of shape tags specifying which shapes to reference in the output.
        :key str type: The output format.
        :key str uri: The destination URI.
        :key list[str] content: Comma-separated list of content to include in the output.
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: str.
                 If the method is called asynchronously, returns the request thread.
        :rtype: str or multiprocessing.pool.AsyncResult
        """
        kwargs['_return_http_data_only'] = True
        return self.export_project_with_http_info(id, export_request_type, **kwargs)  # noqa: E501

    def export_project_with_http_info(self, id, export_request_type, **kwargs):  # noqa: E501
        """Export a project or sequence  # noqa: E501

        Exports the sequence or project to the requested output format and saves the result at the given location.  For POST /sequence/export the sequence must be specified in the request document.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.export_project_with_http_info(id, export_request_type, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str id: The id. (required)
        :param ExportRequestType export_request_type: <em>ExportRequestDocument</em> with details on the export. (required)
        :key str format: Comma separated list of formats specifying which shapes to reference in the output.  If both tag and format is given, then both must match.
        :key bool to_sequence: Export as a sequence with an item, instead of as a standalone item
        :key bool dry_run: When set to `true`, any export problems will be returned and no file will be written
        :key str tag: Comma separated list of shape tags specifying which shapes to reference in the output.
        :key str type: The output format.
        :key str uri: The destination URI.
        :key list[str] content: Comma-separated list of content to include in the output.
        :key _return_http_data_only: response data without head status code
                                       and headers
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(str, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['id', 'export_request_type', 'format', 'to_sequence', 'dry_run', 'tag', 'type', 'uri', 'content']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method export_project" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in local_var_params or
                local_var_params['id'] is None):
            raise ApiValueError("Missing the required parameter `id` when calling `export_project`")  # noqa: E501
        # verify the required parameter 'export_request_type' is set
        if ('export_request_type' not in local_var_params or
                local_var_params['export_request_type'] is None):
            raise ApiValueError("Missing the required parameter `export_request_type` when calling `export_project`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []
        if 'format' in local_var_params:
            query_params.append(('format', local_var_params['format']))  # noqa: E501
        if 'to_sequence' in local_var_params:
            query_params.append(('toSequence', local_var_params['to_sequence']))  # noqa: E501
        if 'dry_run' in local_var_params:
            query_params.append(('dryRun', local_var_params['dry_run']))  # noqa: E501
        if 'tag' in local_var_params:
            query_params.append(('tag', local_var_params['tag']))  # noqa: E501
        if 'type' in local_var_params:
            query_params.append(('type', local_var_params['type']))  # noqa: E501
        if 'uri' in local_var_params:
            query_params.append(('uri', local_var_params['uri']))  # noqa: E501
        if 'content' in local_var_params:
            query_params.append(('content', local_var_params['content']))  # noqa: E501
            collection_formats['content'] = 'csv'  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'export_request_type' in local_var_params:
            body_params = local_var_params['export_request_type']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['multipart/mixed', 'application/json', 'application/xml'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'application/xml'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/collection/{id}/version/export', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='str',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_project_definitions(self, id, **kwargs):  # noqa: E501
        """List all project version definitions  # noqa: E501

        Returns the format of the definitions that have been stored for a specific project version.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_project_definitions(id, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str id: The id. (required)
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: str.
                 If the method is called asynchronously, returns the request thread.
        :rtype: str or multiprocessing.pool.AsyncResult
        """
        kwargs['_return_http_data_only'] = True
        return self.get_project_definitions_with_http_info(id, **kwargs)  # noqa: E501

    def get_project_definitions_with_http_info(self, id, **kwargs):  # noqa: E501
        """List all project version definitions  # noqa: E501

        Returns the format of the definitions that have been stored for a specific project version.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_project_definitions_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str id: The id. (required)
        :key _return_http_data_only: response data without head status code
                                       and headers
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(str, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_project_definitions" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in local_var_params or
                local_var_params['id'] is None):
            raise ApiValueError("Missing the required parameter `id` when calling `get_project_definitions`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/collection/{id}/definition', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='str',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_project_in_format(self, id, **kwargs):  # noqa: E501
        """Export a project or sequence  # noqa: E501

        Exports the sequence or project to the requested output format and saves the result at the given location.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_project_in_format(id, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str id: The id. (required)
        :key str format: Comma separated list of formats specifying which shapes to reference in the output.  If both tag and format is given, then both must match.
        :key bool to_sequence: Export as a sequence with an item, instead of as a standalone item
        :key list[str] storage: Comma-separated list of item paths in format `storageId=path`.
        :key bool dry_run: When set to `true`, any export problems will be returned and no file will be written
        :key str tag: Comma separated list of shape tags specifying which shapes to reference in the output.
        :key str type: The output format.
        :key list[str] item: Comma-separated list of item paths in format `itemId=path`.
        :key list[str] content: Comma-separated list of content to include in the output.
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: str.
                 If the method is called asynchronously, returns the request thread.
        :rtype: str or multiprocessing.pool.AsyncResult
        """
        kwargs['_return_http_data_only'] = True
        return self.get_project_in_format_with_http_info(id, **kwargs)  # noqa: E501

    def get_project_in_format_with_http_info(self, id, **kwargs):  # noqa: E501
        """Export a project or sequence  # noqa: E501

        Exports the sequence or project to the requested output format and saves the result at the given location.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_project_in_format_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str id: The id. (required)
        :key str format: Comma separated list of formats specifying which shapes to reference in the output.  If both tag and format is given, then both must match.
        :key bool to_sequence: Export as a sequence with an item, instead of as a standalone item
        :key list[str] storage: Comma-separated list of item paths in format `storageId=path`.
        :key bool dry_run: When set to `true`, any export problems will be returned and no file will be written
        :key str tag: Comma separated list of shape tags specifying which shapes to reference in the output.
        :key str type: The output format.
        :key list[str] item: Comma-separated list of item paths in format `itemId=path`.
        :key list[str] content: Comma-separated list of content to include in the output.
        :key _return_http_data_only: response data without head status code
                                       and headers
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(str, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['id', 'format', 'to_sequence', 'storage', 'dry_run', 'tag', 'type', 'item', 'content']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_project_in_format" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in local_var_params or
                local_var_params['id'] is None):
            raise ApiValueError("Missing the required parameter `id` when calling `get_project_in_format`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []
        if 'format' in local_var_params:
            query_params.append(('format', local_var_params['format']))  # noqa: E501
        if 'to_sequence' in local_var_params:
            query_params.append(('toSequence', local_var_params['to_sequence']))  # noqa: E501
        if 'storage' in local_var_params:
            query_params.append(('storage', local_var_params['storage']))  # noqa: E501
            collection_formats['storage'] = 'csv'  # noqa: E501
        if 'dry_run' in local_var_params:
            query_params.append(('dryRun', local_var_params['dry_run']))  # noqa: E501
        if 'tag' in local_var_params:
            query_params.append(('tag', local_var_params['tag']))  # noqa: E501
        if 'type' in local_var_params:
            query_params.append(('type', local_var_params['type']))  # noqa: E501
        if 'item' in local_var_params:
            query_params.append(('item', local_var_params['item']))  # noqa: E501
            collection_formats['item'] = 'csv'  # noqa: E501
        if 'content' in local_var_params:
            query_params.append(('content', local_var_params['content']))  # noqa: E501
            collection_formats['content'] = 'csv'  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*', 'application/json', 'application/xml'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/collection/{id}/version/export', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='str',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_project_version_asset_document(self, id, format, **kwargs):  # noqa: E501
        """Retrieve the asset definition  # noqa: E501

        Returns the asset document that has been stored for a specific project version definition.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_project_version_asset_document(id, format, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str id: The id. (required)
        :param str format: The format. (required)
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: EssenceMappingsType.
                 If the method is called asynchronously, returns the request thread.
        :rtype: EssenceMappingsType or multiprocessing.pool.AsyncResult
        """
        kwargs['_return_http_data_only'] = True
        return self.get_project_version_asset_document_with_http_info(id, format, **kwargs)  # noqa: E501

    def get_project_version_asset_document_with_http_info(self, id, format, **kwargs):  # noqa: E501
        """Retrieve the asset definition  # noqa: E501

        Returns the asset document that has been stored for a specific project version definition.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_project_version_asset_document_with_http_info(id, format, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str id: The id. (required)
        :param str format: The format. (required)
        :key _return_http_data_only: response data without head status code
                                       and headers
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(EssenceMappingsType, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['id', 'format']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_project_version_asset_document" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in local_var_params or
                local_var_params['id'] is None):
            raise ApiValueError("Missing the required parameter `id` when calling `get_project_version_asset_document`")  # noqa: E501
        # verify the required parameter 'format' is set
        if ('format' not in local_var_params or
                local_var_params['format'] is None):
            raise ApiValueError("Missing the required parameter `format` when calling `get_project_version_asset_document`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501
        if 'format' in local_var_params:
            path_params['format'] = local_var_params['format']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'application/xml'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/collection/{id}/definition/{format}/asset', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='EssenceMappingsType',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_project_version_binary(self, id, format, **kwargs):  # noqa: E501
        """Retrieve a project version definition  # noqa: E501

        Retrieves a binary representation of the project version.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_project_version_binary(id, format, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str id: The id. (required)
        :param str format: The format. (required)
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: file.
                 If the method is called asynchronously, returns the request thread.
        :rtype: file or multiprocessing.pool.AsyncResult
        """
        kwargs['_return_http_data_only'] = True
        return self.get_project_version_binary_with_http_info(id, format, **kwargs)  # noqa: E501

    def get_project_version_binary_with_http_info(self, id, format, **kwargs):  # noqa: E501
        """Retrieve a project version definition  # noqa: E501

        Retrieves a binary representation of the project version.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_project_version_binary_with_http_info(id, format, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str id: The id. (required)
        :param str format: The format. (required)
        :key _return_http_data_only: response data without head status code
                                       and headers
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(file, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['id', 'format']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_project_version_binary" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in local_var_params or
                local_var_params['id'] is None):
            raise ApiValueError("Missing the required parameter `id` when calling `get_project_version_binary`")  # noqa: E501
        # verify the required parameter 'format' is set
        if ('format' not in local_var_params or
                local_var_params['format'] is None):
            raise ApiValueError("Missing the required parameter `format` when calling `get_project_version_binary`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501
        if 'format' in local_var_params:
            path_params['format'] = local_var_params['format']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/octet-stream'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/collection/{id}/definition/{format}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='file',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_project_version_extra_data(self, id, format, **kwargs):  # noqa: E501
        """Retrieve the extradata  # noqa: E501

        Returns the extradata that has been stored for a specific project version definition.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_project_version_extra_data(id, format, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str id: The id. (required)
        :param str format: The format. (required)
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: file.
                 If the method is called asynchronously, returns the request thread.
        :rtype: file or multiprocessing.pool.AsyncResult
        """
        kwargs['_return_http_data_only'] = True
        return self.get_project_version_extra_data_with_http_info(id, format, **kwargs)  # noqa: E501

    def get_project_version_extra_data_with_http_info(self, id, format, **kwargs):  # noqa: E501
        """Retrieve the extradata  # noqa: E501

        Returns the extradata that has been stored for a specific project version definition.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_project_version_extra_data_with_http_info(id, format, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str id: The id. (required)
        :param str format: The format. (required)
        :key _return_http_data_only: response data without head status code
                                       and headers
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(file, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['id', 'format']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_project_version_extra_data" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in local_var_params or
                local_var_params['id'] is None):
            raise ApiValueError("Missing the required parameter `id` when calling `get_project_version_extra_data`")  # noqa: E501
        # verify the required parameter 'format' is set
        if ('format' not in local_var_params or
                local_var_params['format'] is None):
            raise ApiValueError("Missing the required parameter `format` when calling `get_project_version_extra_data`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501
        if 'format' in local_var_params:
            path_params['format'] = local_var_params['format']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/octet-stream'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/collection/{id}/definition/{format}/extradata', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='file',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_project_definition(self, id, format, body, **kwargs):  # noqa: E501
        """Update a project version definition  # noqa: E501

        Updates a binary representation of the project version. The collection must be a project version collection.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_project_definition(id, format, body, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str id: The id. (required)
        :param str format: The format. (required)
        :param file body: The binary version definition (required)
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None.
                 If the method is called asynchronously, returns the request thread.
        :rtype: None or multiprocessing.pool.AsyncResult
        """
        kwargs['_return_http_data_only'] = True
        return self.update_project_definition_with_http_info(id, format, body, **kwargs)  # noqa: E501

    def update_project_definition_with_http_info(self, id, format, body, **kwargs):  # noqa: E501
        """Update a project version definition  # noqa: E501

        Updates a binary representation of the project version. The collection must be a project version collection.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_project_definition_with_http_info(id, format, body, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str id: The id. (required)
        :param str format: The format. (required)
        :param file body: The binary version definition (required)
        :key _return_http_data_only: response data without head status code
                                       and headers
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['id', 'format', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_project_definition" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in local_var_params or
                local_var_params['id'] is None):
            raise ApiValueError("Missing the required parameter `id` when calling `update_project_definition`")  # noqa: E501
        # verify the required parameter 'format' is set
        if ('format' not in local_var_params or
                local_var_params['format'] is None):
            raise ApiValueError("Missing the required parameter `format` when calling `update_project_definition`")  # noqa: E501
        # verify the required parameter 'body' is set
        if ('body' not in local_var_params or
                local_var_params['body'] is None):
            raise ApiValueError("Missing the required parameter `body` when calling `update_project_definition`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501
        if 'format' in local_var_params:
            path_params['format'] = local_var_params['format']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in local_var_params:
            body_params = local_var_params['body']
        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/octet-stream'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/collection/{id}/definition/{format}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_project_version_asset_document(self, id, format, essence_mappings_type, **kwargs):  # noqa: E501
        """Update the asset definition  # noqa: E501

        Stores an asset document for a specific project version definition. The document should identify the items and files referenced by the definition.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_project_version_asset_document(id, format, essence_mappings_type, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str id: The id. (required)
        :param str format: The format. (required)
        :param EssenceMappingsType essence_mappings_type: (required)
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None.
                 If the method is called asynchronously, returns the request thread.
        :rtype: None or multiprocessing.pool.AsyncResult
        """
        kwargs['_return_http_data_only'] = True
        return self.update_project_version_asset_document_with_http_info(id, format, essence_mappings_type, **kwargs)  # noqa: E501

    def update_project_version_asset_document_with_http_info(self, id, format, essence_mappings_type, **kwargs):  # noqa: E501
        """Update the asset definition  # noqa: E501

        Stores an asset document for a specific project version definition. The document should identify the items and files referenced by the definition.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_project_version_asset_document_with_http_info(id, format, essence_mappings_type, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str id: The id. (required)
        :param str format: The format. (required)
        :param EssenceMappingsType essence_mappings_type: (required)
        :key _return_http_data_only: response data without head status code
                                       and headers
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['id', 'format', 'essence_mappings_type']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_project_version_asset_document" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in local_var_params or
                local_var_params['id'] is None):
            raise ApiValueError("Missing the required parameter `id` when calling `update_project_version_asset_document`")  # noqa: E501
        # verify the required parameter 'format' is set
        if ('format' not in local_var_params or
                local_var_params['format'] is None):
            raise ApiValueError("Missing the required parameter `format` when calling `update_project_version_asset_document`")  # noqa: E501
        # verify the required parameter 'essence_mappings_type' is set
        if ('essence_mappings_type' not in local_var_params or
                local_var_params['essence_mappings_type'] is None):
            raise ApiValueError("Missing the required parameter `essence_mappings_type` when calling `update_project_version_asset_document`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501
        if 'format' in local_var_params:
            path_params['format'] = local_var_params['format']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'essence_mappings_type' in local_var_params:
            body_params = local_var_params['essence_mappings_type']
        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'application/xml'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/collection/{id}/definition/{format}/asset', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_project_version_extra_data(self, id, format, body, **kwargs):  # noqa: E501
        """Update the extradata  # noqa: E501

        Stores extradata for a specific project version definition.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_project_version_extra_data(id, format, body, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str id: The id. (required)
        :param str format: The format. (required)
        :param file body: The binary extradata. (required)
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None.
                 If the method is called asynchronously, returns the request thread.
        :rtype: None or multiprocessing.pool.AsyncResult
        """
        kwargs['_return_http_data_only'] = True
        return self.update_project_version_extra_data_with_http_info(id, format, body, **kwargs)  # noqa: E501

    def update_project_version_extra_data_with_http_info(self, id, format, body, **kwargs):  # noqa: E501
        """Update the extradata  # noqa: E501

        Stores extradata for a specific project version definition.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_project_version_extra_data_with_http_info(id, format, body, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str id: The id. (required)
        :param str format: The format. (required)
        :param file body: The binary extradata. (required)
        :key _return_http_data_only: response data without head status code
                                       and headers
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['id', 'format', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_project_version_extra_data" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in local_var_params or
                local_var_params['id'] is None):
            raise ApiValueError("Missing the required parameter `id` when calling `update_project_version_extra_data`")  # noqa: E501
        # verify the required parameter 'format' is set
        if ('format' not in local_var_params or
                local_var_params['format'] is None):
            raise ApiValueError("Missing the required parameter `format` when calling `update_project_version_extra_data`")  # noqa: E501
        # verify the required parameter 'body' is set
        if ('body' not in local_var_params or
                local_var_params['body'] is None):
            raise ApiValueError("Missing the required parameter `body` when calling `update_project_version_extra_data`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501
        if 'format' in local_var_params:
            path_params['format'] = local_var_params['format']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in local_var_params:
            body_params = local_var_params['body']
        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/octet-stream'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/collection/{id}/definition/{format}/extradata', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)
