# coding: utf-8

"""
    Vidispine API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)  # noqa: E501

    The version of the OpenAPI document: 5.x
    Contact: info@vidispine.com
    Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from vidispine.models import *
from vidispine.api_client import ApiClient
from vidispine.exceptions import (
    ApiTypeError,
    ApiValueError
)


class RelationApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def create_item_relation(self, direction, id1, id2, **kwargs):  # noqa: E501
        """Create an item relation  # noqa: E501

        Generates a new relation between the two items with the given ids, `id1` and `id2`, with the given parameters.  In addition, extra query parameters of the form `key=value` can be added, to set metadata of the item-to-item relation.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_item_relation(direction, id1, id2, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str direction: - `U` - Set the direction of the relation as undirectional.  - `S` - Set the direction as `id1` being the source and `id2` being the target.  - `T` - Set the direction as `id2` being the source and `id1` being the target. (required)
        :param str id1: The id1. (required)
        :param str id2: The id2. (required)
        :key bool allow_duplicate: - `true` (default) - Allow duplicate relations.  - `false` - Avoid adding duplicate relations.
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: ItemRelationType.
                 If the method is called asynchronously, returns the request thread.
        :rtype: ItemRelationType or multiprocessing.pool.AsyncResult
        """
        kwargs['_return_http_data_only'] = True
        return self.create_item_relation_with_http_info(direction, id1, id2, **kwargs)  # noqa: E501

    def create_item_relation_with_http_info(self, direction, id1, id2, **kwargs):  # noqa: E501
        """Create an item relation  # noqa: E501

        Generates a new relation between the two items with the given ids, `id1` and `id2`, with the given parameters.  In addition, extra query parameters of the form `key=value` can be added, to set metadata of the item-to-item relation.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_item_relation_with_http_info(direction, id1, id2, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str direction: - `U` - Set the direction of the relation as undirectional.  - `S` - Set the direction as `id1` being the source and `id2` being the target.  - `T` - Set the direction as `id2` being the source and `id1` being the target. (required)
        :param str id1: The id1. (required)
        :param str id2: The id2. (required)
        :key bool allow_duplicate: - `true` (default) - Allow duplicate relations.  - `false` - Avoid adding duplicate relations.
        :key _return_http_data_only: response data without head status code
                                       and headers
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(ItemRelationType, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['direction', 'id1', 'id2', 'allow_duplicate']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_item_relation" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'direction' is set
        if ('direction' not in local_var_params or
                local_var_params['direction'] is None):
            raise ApiValueError("Missing the required parameter `direction` when calling `create_item_relation`")  # noqa: E501
        # verify the required parameter 'id1' is set
        if ('id1' not in local_var_params or
                local_var_params['id1'] is None):
            raise ApiValueError("Missing the required parameter `id1` when calling `create_item_relation`")  # noqa: E501
        # verify the required parameter 'id2' is set
        if ('id2' not in local_var_params or
                local_var_params['id2'] is None):
            raise ApiValueError("Missing the required parameter `id2` when calling `create_item_relation`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id1' in local_var_params:
            path_params['id1'] = local_var_params['id1']  # noqa: E501
        if 'id2' in local_var_params:
            path_params['id2'] = local_var_params['id2']  # noqa: E501

        query_params = []
        if 'allow_duplicate' in local_var_params:
            query_params.append(('allowDuplicate', local_var_params['allow_duplicate']))  # noqa: E501
        if 'direction' in local_var_params:
            query_params.append(('direction', local_var_params['direction']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'application/xml'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/item/{id1}/relation/{id2}', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ItemRelationType',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_item_relations(self, item_relation_list_type, **kwargs):  # noqa: E501
        """Create multiple item relations  # noqa: E501

        Generates multiple relations at once. Each relation has a `source` and a `target`, and the direction can take the value `U`, if not set it generates a directional relation from `source` to `target`.  For example:  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_item_relations(item_relation_list_type, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param ItemRelationListType item_relation_list_type: (required)
        :key bool allow_duplicate: - `true` (default) - Allow duplicate relations.  - `false` - Avoid adding duplicate relations.
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: ItemRelationListType.
                 If the method is called asynchronously, returns the request thread.
        :rtype: ItemRelationListType or multiprocessing.pool.AsyncResult
        """
        kwargs['_return_http_data_only'] = True
        return self.create_item_relations_with_http_info(item_relation_list_type, **kwargs)  # noqa: E501

    def create_item_relations_with_http_info(self, item_relation_list_type, **kwargs):  # noqa: E501
        """Create multiple item relations  # noqa: E501

        Generates multiple relations at once. Each relation has a `source` and a `target`, and the direction can take the value `U`, if not set it generates a directional relation from `source` to `target`.  For example:  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_item_relations_with_http_info(item_relation_list_type, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param ItemRelationListType item_relation_list_type: (required)
        :key bool allow_duplicate: - `true` (default) - Allow duplicate relations.  - `false` - Avoid adding duplicate relations.
        :key _return_http_data_only: response data without head status code
                                       and headers
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(ItemRelationListType, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['item_relation_list_type', 'allow_duplicate']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_item_relations" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'item_relation_list_type' is set
        if ('item_relation_list_type' not in local_var_params or
                local_var_params['item_relation_list_type'] is None):
            raise ApiValueError("Missing the required parameter `item_relation_list_type` when calling `create_item_relations`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'allow_duplicate' in local_var_params:
            query_params.append(('allowDuplicate', local_var_params['allow_duplicate']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'item_relation_list_type' in local_var_params:
            body_params = local_var_params['item_relation_list_type']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'application/xml'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'application/xml'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/relation', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ItemRelationListType',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_item_relation(self, relation_id, **kwargs):  # noqa: E501
        """Delete an item relation  # noqa: E501

        Deletes the relation with the id `relation-id`.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_item_relation(relation_id, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str relation_id: The relation id. (required)
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None.
                 If the method is called asynchronously, returns the request thread.
        :rtype: None or multiprocessing.pool.AsyncResult
        """
        kwargs['_return_http_data_only'] = True
        return self.delete_item_relation_with_http_info(relation_id, **kwargs)  # noqa: E501

    def delete_item_relation_with_http_info(self, relation_id, **kwargs):  # noqa: E501
        """Delete an item relation  # noqa: E501

        Deletes the relation with the id `relation-id`.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_item_relation_with_http_info(relation_id, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str relation_id: The relation id. (required)
        :key _return_http_data_only: response data without head status code
                                       and headers
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['relation_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_item_relation" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'relation_id' is set
        if ('relation_id' not in local_var_params or
                local_var_params['relation_id'] is None):
            raise ApiValueError("Missing the required parameter `relation_id` when calling `delete_item_relation`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'relation_id' in local_var_params:
            path_params['relation-id'] = local_var_params['relation_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/relation/{relation-id}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_item_relations(self, id, **kwargs):  # noqa: E501
        """Delete all item relations  # noqa: E501

        Deletes the relations with the specified direction or all relations.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_item_relations(id, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str id: The id. (required)
        :key str direction: - `A` - This is the default value.  Deletes all relations `id1` is involved in.  - `U` - Deletes only the relations with the direction as undirectional.  - `S` - Deletes only the relations where `id1` is the source and `id2` is the target.  - `T` - Deletes only the relations where `id2` is the source and `id1` is the target.
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None.
                 If the method is called asynchronously, returns the request thread.
        :rtype: None or multiprocessing.pool.AsyncResult
        """
        kwargs['_return_http_data_only'] = True
        return self.delete_item_relations_with_http_info(id, **kwargs)  # noqa: E501

    def delete_item_relations_with_http_info(self, id, **kwargs):  # noqa: E501
        """Delete all item relations  # noqa: E501

        Deletes the relations with the specified direction or all relations.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_item_relations_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str id: The id. (required)
        :key str direction: - `A` - This is the default value.  Deletes all relations `id1` is involved in.  - `U` - Deletes only the relations with the direction as undirectional.  - `S` - Deletes only the relations where `id1` is the source and `id2` is the target.  - `T` - Deletes only the relations where `id2` is the source and `id1` is the target.
        :key _return_http_data_only: response data without head status code
                                       and headers
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['id', 'direction']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_item_relations" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in local_var_params or
                local_var_params['id'] is None):
            raise ApiValueError("Missing the required parameter `id` when calling `delete_item_relations`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []
        if 'direction' in local_var_params:
            query_params.append(('direction', local_var_params['direction']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/item/{id}/relation', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_item_to_item_relation(self, id1, id2, **kwargs):  # noqa: E501
        """Delete all relations between two items  # noqa: E501

        Deletes the relations with the specified direction or all relations between `id1` and `id2`.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_item_to_item_relation(id1, id2, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str id1: The id1. (required)
        :param str id2: The id2. (required)
        :key str direction: - `A` - This is the default value.  Deletes all relations between `id1` and `id2`.  - `U` - Deletes only the relations with the direction as undirectional.  - `S` - Deletes only the relations where `id1` is the source and `id2` is the target.  - `T` - Deletes only the relations where `id2` is the source and `id1` is the target.
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None.
                 If the method is called asynchronously, returns the request thread.
        :rtype: None or multiprocessing.pool.AsyncResult
        """
        kwargs['_return_http_data_only'] = True
        return self.delete_item_to_item_relation_with_http_info(id1, id2, **kwargs)  # noqa: E501

    def delete_item_to_item_relation_with_http_info(self, id1, id2, **kwargs):  # noqa: E501
        """Delete all relations between two items  # noqa: E501

        Deletes the relations with the specified direction or all relations between `id1` and `id2`.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_item_to_item_relation_with_http_info(id1, id2, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str id1: The id1. (required)
        :param str id2: The id2. (required)
        :key str direction: - `A` - This is the default value.  Deletes all relations between `id1` and `id2`.  - `U` - Deletes only the relations with the direction as undirectional.  - `S` - Deletes only the relations where `id1` is the source and `id2` is the target.  - `T` - Deletes only the relations where `id2` is the source and `id1` is the target.
        :key _return_http_data_only: response data without head status code
                                       and headers
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['id1', 'id2', 'direction']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_item_to_item_relation" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id1' is set
        if ('id1' not in local_var_params or
                local_var_params['id1'] is None):
            raise ApiValueError("Missing the required parameter `id1` when calling `delete_item_to_item_relation`")  # noqa: E501
        # verify the required parameter 'id2' is set
        if ('id2' not in local_var_params or
                local_var_params['id2'] is None):
            raise ApiValueError("Missing the required parameter `id2` when calling `delete_item_to_item_relation`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id1' in local_var_params:
            path_params['id1'] = local_var_params['id1']  # noqa: E501
        if 'id2' in local_var_params:
            path_params['id2'] = local_var_params['id2']  # noqa: E501

        query_params = []
        if 'direction' in local_var_params:
            query_params.append(('direction', local_var_params['direction']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/item/{id1}/relation/{id2}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_item_relation(self, relation_id, **kwargs):  # noqa: E501
        """Retrieve an item relation  # noqa: E501

        Retrieves the relation with the id `relation-id`.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_item_relation(relation_id, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str relation_id: The relation id. (required)
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: ItemRelationType.
                 If the method is called asynchronously, returns the request thread.
        :rtype: ItemRelationType or multiprocessing.pool.AsyncResult
        """
        kwargs['_return_http_data_only'] = True
        return self.get_item_relation_with_http_info(relation_id, **kwargs)  # noqa: E501

    def get_item_relation_with_http_info(self, relation_id, **kwargs):  # noqa: E501
        """Retrieve an item relation  # noqa: E501

        Retrieves the relation with the id `relation-id`.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_item_relation_with_http_info(relation_id, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str relation_id: The relation id. (required)
        :key _return_http_data_only: response data without head status code
                                       and headers
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(ItemRelationType, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['relation_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_item_relation" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'relation_id' is set
        if ('relation_id' not in local_var_params or
                local_var_params['relation_id'] is None):
            raise ApiValueError("Missing the required parameter `relation_id` when calling `get_item_relation`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'relation_id' in local_var_params:
            path_params['relation-id'] = local_var_params['relation_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'application/xml'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/relation/{relation-id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ItemRelationType',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_item_relations(self, id, **kwargs):  # noqa: E501
        """List all item relations  # noqa: E501

        Returns a list of relations that matches the search criteria. Item id can be an identifier, that is libraries can be used.  In addition, extra query parameters of the form `key=value` can be added, to only return relations that matches the key-value pair(s).  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_item_relations(id, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str id: The id. (required)
        :key str direction: - `U` - Only return undirectional relations where `id` is part of.  - `S` - Only return directional relations where `id` is the source item.  - `T` - Only return directional relations where `id` is the target item.  - `D` - Only return directional relations where `id` is the source or target item.  - `A` (default) - Return all relations that `id` is a part of.
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: ItemRelationListType.
                 If the method is called asynchronously, returns the request thread.
        :rtype: ItemRelationListType or multiprocessing.pool.AsyncResult
        """
        kwargs['_return_http_data_only'] = True
        return self.get_item_relations_with_http_info(id, **kwargs)  # noqa: E501

    def get_item_relations_with_http_info(self, id, **kwargs):  # noqa: E501
        """List all item relations  # noqa: E501

        Returns a list of relations that matches the search criteria. Item id can be an identifier, that is libraries can be used.  In addition, extra query parameters of the form `key=value` can be added, to only return relations that matches the key-value pair(s).  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_item_relations_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str id: The id. (required)
        :key str direction: - `U` - Only return undirectional relations where `id` is part of.  - `S` - Only return directional relations where `id` is the source item.  - `T` - Only return directional relations where `id` is the target item.  - `D` - Only return directional relations where `id` is the source or target item.  - `A` (default) - Return all relations that `id` is a part of.
        :key _return_http_data_only: response data without head status code
                                       and headers
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(ItemRelationListType, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['id', 'direction']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_item_relations" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in local_var_params or
                local_var_params['id'] is None):
            raise ApiValueError("Missing the required parameter `id` when calling `get_item_relations`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []
        if 'direction' in local_var_params:
            query_params.append(('direction', local_var_params['direction']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'text/plain', 'application/xml'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/item/{id}/relation', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ItemRelationListType',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_item_relation(self, relation_id, **kwargs):  # noqa: E501
        """Update an item relation  # noqa: E501

        Updates the relation metadata for a relation with the id `relation-id`.  Query parameters of the form `key=value` are used to modify the metadata of the relation.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_item_relation(relation_id, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str relation_id: The relation id. (required)
        :key str direction: - `U` - Set the direction of the relation as undirectional.  - `S` - Set the direction as `id1` being the source and `id2` being the target.  - `T` - Set the direction as `id2` being the source and `id1` being the target.
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: ItemRelationType.
                 If the method is called asynchronously, returns the request thread.
        :rtype: ItemRelationType or multiprocessing.pool.AsyncResult
        """
        kwargs['_return_http_data_only'] = True
        return self.update_item_relation_with_http_info(relation_id, **kwargs)  # noqa: E501

    def update_item_relation_with_http_info(self, relation_id, **kwargs):  # noqa: E501
        """Update an item relation  # noqa: E501

        Updates the relation metadata for a relation with the id `relation-id`.  Query parameters of the form `key=value` are used to modify the metadata of the relation.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_item_relation_with_http_info(relation_id, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str relation_id: The relation id. (required)
        :key str direction: - `U` - Set the direction of the relation as undirectional.  - `S` - Set the direction as `id1` being the source and `id2` being the target.  - `T` - Set the direction as `id2` being the source and `id1` being the target.
        :key _return_http_data_only: response data without head status code
                                       and headers
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(ItemRelationType, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['relation_id', 'direction']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_item_relation" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'relation_id' is set
        if ('relation_id' not in local_var_params or
                local_var_params['relation_id'] is None):
            raise ApiValueError("Missing the required parameter `relation_id` when calling `update_item_relation`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'relation_id' in local_var_params:
            path_params['relation-id'] = local_var_params['relation_id']  # noqa: E501

        query_params = []
        if 'direction' in local_var_params:
            query_params.append(('direction', local_var_params['direction']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'application/xml'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/relation/{relation-id}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ItemRelationType',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)
