# coding: utf-8

"""
    Vidispine API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)  # noqa: E501

    The version of the OpenAPI document: 5.x
    Contact: info@vidispine.com
    Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from vidispine.models import *
from vidispine.api_client import ApiClient
from vidispine.exceptions import (
    ApiTypeError,
    ApiValueError
)


class SearchApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def optimize_search_index(self, **kwargs):  # noqa: E501
        """Optimize the search index  # noqa: E501

        Submits an optimize request to Solr.  This request can be made to block until the optimize request has completed using the `blocking` parameter.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.optimize_search_index(async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :key bool blocking: - `true` - The request will block until the Solr optimize request has finished.  - `false` (default) - Optimize will be scheduled and the request will return immediately.
        :key int timeout: Block for maximum number of specified milliseconds.
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None.
                 If the method is called asynchronously, returns the request thread.
        :rtype: None or multiprocessing.pool.AsyncResult
        """
        kwargs['_return_http_data_only'] = True
        return self.optimize_search_index_with_http_info(**kwargs)  # noqa: E501

    def optimize_search_index_with_http_info(self, **kwargs):  # noqa: E501
        """Optimize the search index  # noqa: E501

        Submits an optimize request to Solr.  This request can be made to block until the optimize request has completed using the `blocking` parameter.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.optimize_search_index_with_http_info(async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :key bool blocking: - `true` - The request will block until the Solr optimize request has finished.  - `false` (default) - Optimize will be scheduled and the request will return immediately.
        :key int timeout: Block for maximum number of specified milliseconds.
        :key _return_http_data_only: response data without head status code
                                       and headers
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['blocking', 'timeout']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method optimize_search_index" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'blocking' in local_var_params:
            query_params.append(('blocking', local_var_params['blocking']))  # noqa: E501
        if 'timeout' in local_var_params:
            query_params.append(('timeout', local_var_params['timeout']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/search/optimize', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def search(self, item_search_type, **kwargs):  # noqa: E501
        """Search items and collections  # noqa: E501

        Searches items and collections with a shared search query.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.search(item_search_type, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param ItemSearchType item_search_type: (required)
        :key list[str] language: Comma-separated list.   - *language-tag* - Return metadata for specific language, e. g.  `en_US`.  Wildcards may be used, e. g.  `*_CA` for both Canadian French and Canadian English.  - `none` - Return all metadata without language specification.  - `all` (default) - Return all metadata, with or without language specification.
        :key str storage_type: Only return URIs for files from storages of this type.
        :key int first: From the resulting list of items, start return list from specified offset.
        :key bool closed_files: A URI parameter:  - `true` (default) - Return only URIs that point to closed files.  - `false` - Return all URIs.
        :key str terse: - `yes` - Return metadata in terse format.  - `no` (default) - Return metadata in verbose format.
        :key str method_metadata: Metadata used with storage method.
        :key int number: The number of entities to fetch.
        :key list[str] interval: Comma-separated list  - *time-span* - Filter out metadata, return only metadata for specified time span.  - `generic` - Return all non-timed metadata.  - `all` (default) - Return all metadata, same as `interval=generic,-INF-+INF`
        :key list[str] group: Comma-separated list.   - *group-name* - Return specified group.  - *group-name* `+` - Return specified group and subgroups.  - *group-name* `:` *new-name* - Return specified group, renamed to a new name in return value.  - `-` *group-name* - Exclude specified group.  - (default) - Return all groups.
        :key bool include_values: Return the value enumeration for each metadata field.
        :key str storage_group: Storage group id.  Return only files from storages specified in the storage group.
        :key list[str] track: Comma-separated list.   - *track-type* *track-number* - Return metadata for specified track.  Example of track is `A2`.  - *track-type* *t1* `-` *t2* - Return metadata for specified track interval, e. g.  `A2-4`.  - *track-type* `*` - Return metadata for all tracks of specified type, e. g.  `A*`.  - `generic` - Return all non-tracked metadata.  - `all` (default) - All metadata, with or without track specification, are returned.
        :key str conflict: - `yes` (default) - Include all metadata conflicts, unresolved.  - `no` - Return conflicts resolved according to field rules.
        :key list[str] content: Comma-separated list of the types of content to retrieve.
        :key str merged_extradata: Any possible extra data.
        :key bool include_transient_metadata: - `true` (default) - Include transient metadata.  - `false` - Do not include transient metadata in response.
        :key str merged_type: The type of operation to check for.
        :key bool default_value: - `true` - For unset fields, return default values.  - `false` (default) - Do not return default values.
        :key str tag: A URI parameter: Comma-separated list of shape tags to return.
        :key list[str] field: Comma-separated list.   - *field-name* - Return specified field.  - *field-name* \":\" *new-name* - Return specified field, renamed to a new name in return value.  - \"-\" *field-name* - Exclude specified field.  - (default) - Return all fields.
        :key str include: A list of keys.   Includes additional field specific data.  Additionally, if set to `type` the type definition of the field will be retrieved.
        :key str method_type: Access method.   - `AUTO` - Gives an APInoauth URI to the media.  Access to file is tunneled through Vidispine.  - `AZURE_SAS` - If the storage schema is azure:// you can get direct access to the media.  The resulting URI will not tunnel through Vidispine but rather point directly to the media location at the azure storage.
        :key list[str] p: Comma-separated list of paths specifying the content to include.  Overrides the content and filter parameters.
        :key str base_uri: Which base URI to use for the thumbnail URLs.
        :key list[str] uri_type: Comma-separated list of format types (container format) to return.
        :key list[str] storage: List of storage ids.  Return only files from specific storages.  Can be specified multiple times.
        :key str revision: Specifying which metadata revision to display.  Only used if requesting a single item or collection.
        :key str scheme: URI scheme to return.
        :key str version: Specifying which essence version to return for shapes.  If special value `all`, display all versions.  If special value `latest` (default), display latest version of shapes.
        :key str merged_permission: The lowest required permission level.
        :key str sample_rate: Convert all outgoing time instants to specified rate.  *NB!* Time codes which cannot be expressed in an integer number of samples will be returned as a decimal number, with risk of losing precision.
        :key bool count: - `true` (default) - Return hits in result.  - `false` - Do not return hits in result, in order to produce results faster.
        :key bool save: - `true` - Returns a `303 See Other`, with a `Location` header containing an URI to fetch the search result - `false` (default) - Returns a regular search result
        :key bool noauth_url: - `true` Return URIs that do not need authentication.  - `false` (default) Return normal URIs
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: SearchResultType.
                 If the method is called asynchronously, returns the request thread.
        :rtype: SearchResultType or multiprocessing.pool.AsyncResult
        """
        kwargs['_return_http_data_only'] = True
        return self.search_with_http_info(item_search_type, **kwargs)  # noqa: E501

    def search_with_http_info(self, item_search_type, **kwargs):  # noqa: E501
        """Search items and collections  # noqa: E501

        Searches items and collections with a shared search query.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.search_with_http_info(item_search_type, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param ItemSearchType item_search_type: (required)
        :key list[str] language: Comma-separated list.   - *language-tag* - Return metadata for specific language, e. g.  `en_US`.  Wildcards may be used, e. g.  `*_CA` for both Canadian French and Canadian English.  - `none` - Return all metadata without language specification.  - `all` (default) - Return all metadata, with or without language specification.
        :key str storage_type: Only return URIs for files from storages of this type.
        :key int first: From the resulting list of items, start return list from specified offset.
        :key bool closed_files: A URI parameter:  - `true` (default) - Return only URIs that point to closed files.  - `false` - Return all URIs.
        :key str terse: - `yes` - Return metadata in terse format.  - `no` (default) - Return metadata in verbose format.
        :key str method_metadata: Metadata used with storage method.
        :key int number: The number of entities to fetch.
        :key list[str] interval: Comma-separated list  - *time-span* - Filter out metadata, return only metadata for specified time span.  - `generic` - Return all non-timed metadata.  - `all` (default) - Return all metadata, same as `interval=generic,-INF-+INF`
        :key list[str] group: Comma-separated list.   - *group-name* - Return specified group.  - *group-name* `+` - Return specified group and subgroups.  - *group-name* `:` *new-name* - Return specified group, renamed to a new name in return value.  - `-` *group-name* - Exclude specified group.  - (default) - Return all groups.
        :key bool include_values: Return the value enumeration for each metadata field.
        :key str storage_group: Storage group id.  Return only files from storages specified in the storage group.
        :key list[str] track: Comma-separated list.   - *track-type* *track-number* - Return metadata for specified track.  Example of track is `A2`.  - *track-type* *t1* `-` *t2* - Return metadata for specified track interval, e. g.  `A2-4`.  - *track-type* `*` - Return metadata for all tracks of specified type, e. g.  `A*`.  - `generic` - Return all non-tracked metadata.  - `all` (default) - All metadata, with or without track specification, are returned.
        :key str conflict: - `yes` (default) - Include all metadata conflicts, unresolved.  - `no` - Return conflicts resolved according to field rules.
        :key list[str] content: Comma-separated list of the types of content to retrieve.
        :key str merged_extradata: Any possible extra data.
        :key bool include_transient_metadata: - `true` (default) - Include transient metadata.  - `false` - Do not include transient metadata in response.
        :key str merged_type: The type of operation to check for.
        :key bool default_value: - `true` - For unset fields, return default values.  - `false` (default) - Do not return default values.
        :key str tag: A URI parameter: Comma-separated list of shape tags to return.
        :key list[str] field: Comma-separated list.   - *field-name* - Return specified field.  - *field-name* \":\" *new-name* - Return specified field, renamed to a new name in return value.  - \"-\" *field-name* - Exclude specified field.  - (default) - Return all fields.
        :key str include: A list of keys.   Includes additional field specific data.  Additionally, if set to `type` the type definition of the field will be retrieved.
        :key str method_type: Access method.   - `AUTO` - Gives an APInoauth URI to the media.  Access to file is tunneled through Vidispine.  - `AZURE_SAS` - If the storage schema is azure:// you can get direct access to the media.  The resulting URI will not tunnel through Vidispine but rather point directly to the media location at the azure storage.
        :key list[str] p: Comma-separated list of paths specifying the content to include.  Overrides the content and filter parameters.
        :key str base_uri: Which base URI to use for the thumbnail URLs.
        :key list[str] uri_type: Comma-separated list of format types (container format) to return.
        :key list[str] storage: List of storage ids.  Return only files from specific storages.  Can be specified multiple times.
        :key str revision: Specifying which metadata revision to display.  Only used if requesting a single item or collection.
        :key str scheme: URI scheme to return.
        :key str version: Specifying which essence version to return for shapes.  If special value `all`, display all versions.  If special value `latest` (default), display latest version of shapes.
        :key str merged_permission: The lowest required permission level.
        :key str sample_rate: Convert all outgoing time instants to specified rate.  *NB!* Time codes which cannot be expressed in an integer number of samples will be returned as a decimal number, with risk of losing precision.
        :key bool count: - `true` (default) - Return hits in result.  - `false` - Do not return hits in result, in order to produce results faster.
        :key bool save: - `true` - Returns a `303 See Other`, with a `Location` header containing an URI to fetch the search result - `false` (default) - Returns a regular search result
        :key bool noauth_url: - `true` Return URIs that do not need authentication.  - `false` (default) Return normal URIs
        :key _return_http_data_only: response data without head status code
                                       and headers
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(SearchResultType, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['item_search_type', 'language', 'storage_type', 'first', 'closed_files', 'terse', 'method_metadata', 'number', 'interval', 'group', 'include_values', 'storage_group', 'track', 'conflict', 'content', 'merged_extradata', 'include_transient_metadata', 'merged_type', 'default_value', 'tag', 'field', 'include', 'method_type', 'p', 'base_uri', 'uri_type', 'storage', 'revision', 'scheme', 'version', 'merged_permission', 'sample_rate', 'count', 'save', 'noauth_url']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method search" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'item_search_type' is set
        if ('item_search_type' not in local_var_params or
                local_var_params['item_search_type'] is None):
            raise ApiValueError("Missing the required parameter `item_search_type` when calling `search`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'language' in local_var_params:
            query_params.append(('language', local_var_params['language']))  # noqa: E501
            collection_formats['language'] = 'csv'  # noqa: E501
        if 'storage_type' in local_var_params:
            query_params.append(('storageType', local_var_params['storage_type']))  # noqa: E501
        if 'first' in local_var_params:
            query_params.append(('first', local_var_params['first']))  # noqa: E501
        if 'closed_files' in local_var_params:
            query_params.append(('closedFiles', local_var_params['closed_files']))  # noqa: E501
        if 'terse' in local_var_params:
            query_params.append(('terse', local_var_params['terse']))  # noqa: E501
        if 'method_metadata' in local_var_params:
            query_params.append(('methodMetadata', local_var_params['method_metadata']))  # noqa: E501
        if 'number' in local_var_params:
            query_params.append(('number', local_var_params['number']))  # noqa: E501
        if 'interval' in local_var_params:
            query_params.append(('interval', local_var_params['interval']))  # noqa: E501
            collection_formats['interval'] = 'csv'  # noqa: E501
        if 'group' in local_var_params:
            query_params.append(('group', local_var_params['group']))  # noqa: E501
            collection_formats['group'] = 'csv'  # noqa: E501
        if 'include_values' in local_var_params:
            query_params.append(('includeValues', local_var_params['include_values']))  # noqa: E501
        if 'storage_group' in local_var_params:
            query_params.append(('storageGroup', local_var_params['storage_group']))  # noqa: E501
        if 'track' in local_var_params:
            query_params.append(('track', local_var_params['track']))  # noqa: E501
            collection_formats['track'] = 'csv'  # noqa: E501
        if 'conflict' in local_var_params:
            query_params.append(('conflict', local_var_params['conflict']))  # noqa: E501
        if 'content' in local_var_params:
            query_params.append(('content', local_var_params['content']))  # noqa: E501
            collection_formats['content'] = 'csv'  # noqa: E501
        if 'merged_extradata' in local_var_params:
            query_params.append(('mergedExtradata', local_var_params['merged_extradata']))  # noqa: E501
        if 'include_transient_metadata' in local_var_params:
            query_params.append(('includeTransientMetadata', local_var_params['include_transient_metadata']))  # noqa: E501
        if 'merged_type' in local_var_params:
            query_params.append(('mergedType', local_var_params['merged_type']))  # noqa: E501
        if 'default_value' in local_var_params:
            query_params.append(('defaultValue', local_var_params['default_value']))  # noqa: E501
        if 'tag' in local_var_params:
            query_params.append(('tag', local_var_params['tag']))  # noqa: E501
        if 'field' in local_var_params:
            query_params.append(('field', local_var_params['field']))  # noqa: E501
            collection_formats['field'] = 'csv'  # noqa: E501
        if 'include' in local_var_params:
            query_params.append(('include', local_var_params['include']))  # noqa: E501
        if 'method_type' in local_var_params:
            query_params.append(('methodType', local_var_params['method_type']))  # noqa: E501
        if 'p' in local_var_params:
            query_params.append(('p', local_var_params['p']))  # noqa: E501
            collection_formats['p'] = 'csv'  # noqa: E501
        if 'base_uri' in local_var_params:
            query_params.append(('baseURI', local_var_params['base_uri']))  # noqa: E501
        if 'uri_type' in local_var_params:
            query_params.append(('uriType', local_var_params['uri_type']))  # noqa: E501
            collection_formats['uriType'] = 'csv'  # noqa: E501
        if 'storage' in local_var_params:
            query_params.append(('storage', local_var_params['storage']))  # noqa: E501
            collection_formats['storage'] = 'multi'  # noqa: E501
        if 'revision' in local_var_params:
            query_params.append(('revision', local_var_params['revision']))  # noqa: E501
        if 'scheme' in local_var_params:
            query_params.append(('scheme', local_var_params['scheme']))  # noqa: E501
        if 'version' in local_var_params:
            query_params.append(('version', local_var_params['version']))  # noqa: E501
        if 'merged_permission' in local_var_params:
            query_params.append(('mergedPermission', local_var_params['merged_permission']))  # noqa: E501
        if 'sample_rate' in local_var_params:
            query_params.append(('sampleRate', local_var_params['sample_rate']))  # noqa: E501
        if 'count' in local_var_params:
            query_params.append(('count', local_var_params['count']))  # noqa: E501
        if 'save' in local_var_params:
            query_params.append(('save', local_var_params['save']))  # noqa: E501
        if 'noauth_url' in local_var_params:
            query_params.append(('noauth-url', local_var_params['noauth_url']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'item_search_type' in local_var_params:
            body_params = local_var_params['item_search_type']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'application/xml'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'application/xml'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/search', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SearchResultType',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def search_files(self, file_search_type, **kwargs):  # noqa: E501
        """Search files  # noqa: E501

        Searches files. Using GET is identical as performing a search with an empty search document.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.search_files(file_search_type, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param FileSearchType file_search_type: (required)
        :key str storage_type: Only return URIs for files from storages of this type.
        :key int first: From the resulting list of items, start return list from specified offset.
        :key list[str] method_metadata: metadata used with storage method.
        :key bool save: - `true` - Returns a `303 See Other`, with a `Location` header containing an URI to fetch the search result - `false` (default) - Returns a regular search result
        :key bool count: - `true` (default) - Return hits in result.  - `false` - Do not return hits in result, in order to produce results faster.
        :key int number: The number of entities to fetch.
        :key str scheme: URI scheme to return.
        :key str method_type: Return URIs from storage methods with a particular type.  By default, return URLs with empty `methodType`.
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: FileListType.
                 If the method is called asynchronously, returns the request thread.
        :rtype: FileListType or multiprocessing.pool.AsyncResult
        """
        kwargs['_return_http_data_only'] = True
        return self.search_files_with_http_info(file_search_type, **kwargs)  # noqa: E501

    def search_files_with_http_info(self, file_search_type, **kwargs):  # noqa: E501
        """Search files  # noqa: E501

        Searches files. Using GET is identical as performing a search with an empty search document.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.search_files_with_http_info(file_search_type, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param FileSearchType file_search_type: (required)
        :key str storage_type: Only return URIs for files from storages of this type.
        :key int first: From the resulting list of items, start return list from specified offset.
        :key list[str] method_metadata: metadata used with storage method.
        :key bool save: - `true` - Returns a `303 See Other`, with a `Location` header containing an URI to fetch the search result - `false` (default) - Returns a regular search result
        :key bool count: - `true` (default) - Return hits in result.  - `false` - Do not return hits in result, in order to produce results faster.
        :key int number: The number of entities to fetch.
        :key str scheme: URI scheme to return.
        :key str method_type: Return URIs from storage methods with a particular type.  By default, return URLs with empty `methodType`.
        :key _return_http_data_only: response data without head status code
                                       and headers
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(FileListType, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['file_search_type', 'storage_type', 'first', 'method_metadata', 'save', 'count', 'number', 'scheme', 'method_type']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method search_files" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'file_search_type' is set
        if ('file_search_type' not in local_var_params or
                local_var_params['file_search_type'] is None):
            raise ApiValueError("Missing the required parameter `file_search_type` when calling `search_files`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'storage_type' in local_var_params:
            query_params.append(('storageType', local_var_params['storage_type']))  # noqa: E501
        if 'first' in local_var_params:
            query_params.append(('first', local_var_params['first']))  # noqa: E501
        if 'method_metadata' in local_var_params:
            query_params.append(('methodMetadata', local_var_params['method_metadata']))  # noqa: E501
            collection_formats['methodMetadata'] = 'multi'  # noqa: E501
        if 'save' in local_var_params:
            query_params.append(('save', local_var_params['save']))  # noqa: E501
        if 'count' in local_var_params:
            query_params.append(('count', local_var_params['count']))  # noqa: E501
        if 'number' in local_var_params:
            query_params.append(('number', local_var_params['number']))  # noqa: E501
        if 'scheme' in local_var_params:
            query_params.append(('scheme', local_var_params['scheme']))  # noqa: E501
        if 'method_type' in local_var_params:
            query_params.append(('methodType', local_var_params['method_type']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'file_search_type' in local_var_params:
            body_params = local_var_params['file_search_type']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'application/xml'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'application/xml'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/search/file', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='FileListType',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def search_shapes(self, shape_search_type, **kwargs):  # noqa: E501
        """Search shapes  # noqa: E501

        Searches shapes. Using GET is identical as performing a search with an empty search document.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.search_shapes(shape_search_type, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param ShapeSearchType shape_search_type: (required)
        :key str storage_type: Only return URIs for files from storages of this type.
        :key int first: From the resulting list of items, start return list from specified offset.
        :key list[str] content: Comma-separated list of the types of content to retrieve.
        :key int number: The number of entities to fetch.
        :key str scheme: URI scheme to return.
        :key bool count: - `true` (default) - Return hits in result.  - `false` - Do not return hits in result, in order to produce results faster.
        :key bool save: - `true` - Returns a `303 See Other`, with a `Location` header containing an URI to fetch the search result - `false` (default) - Returns a regular search result
        :key list[str] method_metadata: metadata used with storage method.
        :key str method_type: Return URIs from storage methods with a particular type.  By default, return URLs with empty `methodType`.
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: ShapeListType.
                 If the method is called asynchronously, returns the request thread.
        :rtype: ShapeListType or multiprocessing.pool.AsyncResult
        """
        kwargs['_return_http_data_only'] = True
        return self.search_shapes_with_http_info(shape_search_type, **kwargs)  # noqa: E501

    def search_shapes_with_http_info(self, shape_search_type, **kwargs):  # noqa: E501
        """Search shapes  # noqa: E501

        Searches shapes. Using GET is identical as performing a search with an empty search document.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.search_shapes_with_http_info(shape_search_type, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param ShapeSearchType shape_search_type: (required)
        :key str storage_type: Only return URIs for files from storages of this type.
        :key int first: From the resulting list of items, start return list from specified offset.
        :key list[str] content: Comma-separated list of the types of content to retrieve.
        :key int number: The number of entities to fetch.
        :key str scheme: URI scheme to return.
        :key bool count: - `true` (default) - Return hits in result.  - `false` - Do not return hits in result, in order to produce results faster.
        :key bool save: - `true` - Returns a `303 See Other`, with a `Location` header containing an URI to fetch the search result - `false` (default) - Returns a regular search result
        :key list[str] method_metadata: metadata used with storage method.
        :key str method_type: Return URIs from storage methods with a particular type.  By default, return URLs with empty `methodType`.
        :key _return_http_data_only: response data without head status code
                                       and headers
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(ShapeListType, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['shape_search_type', 'storage_type', 'first', 'content', 'number', 'scheme', 'count', 'save', 'method_metadata', 'method_type']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method search_shapes" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'shape_search_type' is set
        if ('shape_search_type' not in local_var_params or
                local_var_params['shape_search_type'] is None):
            raise ApiValueError("Missing the required parameter `shape_search_type` when calling `search_shapes`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'storage_type' in local_var_params:
            query_params.append(('storageType', local_var_params['storage_type']))  # noqa: E501
        if 'first' in local_var_params:
            query_params.append(('first', local_var_params['first']))  # noqa: E501
        if 'content' in local_var_params:
            query_params.append(('content', local_var_params['content']))  # noqa: E501
            collection_formats['content'] = 'csv'  # noqa: E501
        if 'number' in local_var_params:
            query_params.append(('number', local_var_params['number']))  # noqa: E501
        if 'scheme' in local_var_params:
            query_params.append(('scheme', local_var_params['scheme']))  # noqa: E501
        if 'count' in local_var_params:
            query_params.append(('count', local_var_params['count']))  # noqa: E501
        if 'save' in local_var_params:
            query_params.append(('save', local_var_params['save']))  # noqa: E501
        if 'method_metadata' in local_var_params:
            query_params.append(('methodMetadata', local_var_params['method_metadata']))  # noqa: E501
            collection_formats['methodMetadata'] = 'multi'  # noqa: E501
        if 'method_type' in local_var_params:
            query_params.append(('methodType', local_var_params['method_type']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'shape_search_type' in local_var_params:
            body_params = local_var_params['shape_search_type']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'application/xml'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'application/xml'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/search/shape', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ShapeListType',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)
