# coding: utf-8

"""
    Vidispine API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)  # noqa: E501

    The version of the OpenAPI document: 5.x
    Contact: info@vidispine.com
    Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from vidispine.models import *
from vidispine.api_client import ApiClient
from vidispine.exceptions import (
    ApiTypeError,
    ApiValueError
)


class SequenceApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def create_item_sequence_render_job(self, id, **kwargs):  # noqa: E501
        """Render a sequence  # noqa: E501

        Creates a new job that renders the sequence for the given item. The item will contain a new shape with the rendered result once the job is finished.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_item_sequence_render_job(id, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str id: The id. (required)
        :key list[str] source_tag: The shape tag specifying the shapes to use as input.
        :key list[str] jobmetadata: Additional information for the job task.
        :key str notification_data: Any additional data to include for notifications on this job.
        :key list[str] tag: The shape tag specifying the format of the rendered sequence.
        :key str notification: The placeholder job notification to use for this job.
        :key str subtitle_language: The language code specifying the subtitle language to use.
        :key str destination_item: An item id, to which the new new shape will be associated.
        :key str resource_id: The transcoder resource to use to execute the transcode.  New in version 4. 16.
        :key str priority: The priority to assign to the job.
        :key str original: If specified, should be one of the tags specified in the tag parameter.  Specifies that the original shape tag will be reset to the shape created to this tag.
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: JobType.
                 If the method is called asynchronously, returns the request thread.
        :rtype: JobType or multiprocessing.pool.AsyncResult
        """
        kwargs['_return_http_data_only'] = True
        return self.create_item_sequence_render_job_with_http_info(id, **kwargs)  # noqa: E501

    def create_item_sequence_render_job_with_http_info(self, id, **kwargs):  # noqa: E501
        """Render a sequence  # noqa: E501

        Creates a new job that renders the sequence for the given item. The item will contain a new shape with the rendered result once the job is finished.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_item_sequence_render_job_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str id: The id. (required)
        :key list[str] source_tag: The shape tag specifying the shapes to use as input.
        :key list[str] jobmetadata: Additional information for the job task.
        :key str notification_data: Any additional data to include for notifications on this job.
        :key list[str] tag: The shape tag specifying the format of the rendered sequence.
        :key str notification: The placeholder job notification to use for this job.
        :key str subtitle_language: The language code specifying the subtitle language to use.
        :key str destination_item: An item id, to which the new new shape will be associated.
        :key str resource_id: The transcoder resource to use to execute the transcode.  New in version 4. 16.
        :key str priority: The priority to assign to the job.
        :key str original: If specified, should be one of the tags specified in the tag parameter.  Specifies that the original shape tag will be reset to the shape created to this tag.
        :key _return_http_data_only: response data without head status code
                                       and headers
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(JobType, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['id', 'source_tag', 'jobmetadata', 'notification_data', 'tag', 'notification', 'subtitle_language', 'destination_item', 'resource_id', 'priority', 'original']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_item_sequence_render_job" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in local_var_params or
                local_var_params['id'] is None):
            raise ApiValueError("Missing the required parameter `id` when calling `create_item_sequence_render_job`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []
        if 'source_tag' in local_var_params:
            query_params.append(('sourceTag', local_var_params['source_tag']))  # noqa: E501
            collection_formats['sourceTag'] = 'multi'  # noqa: E501
        if 'jobmetadata' in local_var_params:
            query_params.append(('jobmetadata', local_var_params['jobmetadata']))  # noqa: E501
            collection_formats['jobmetadata'] = 'multi'  # noqa: E501
        if 'notification_data' in local_var_params:
            query_params.append(('notificationData', local_var_params['notification_data']))  # noqa: E501
        if 'tag' in local_var_params:
            query_params.append(('tag', local_var_params['tag']))  # noqa: E501
            collection_formats['tag'] = 'multi'  # noqa: E501
        if 'notification' in local_var_params:
            query_params.append(('notification', local_var_params['notification']))  # noqa: E501
        if 'subtitle_language' in local_var_params:
            query_params.append(('subtitleLanguage', local_var_params['subtitle_language']))  # noqa: E501
        if 'destination_item' in local_var_params:
            query_params.append(('destinationItem', local_var_params['destination_item']))  # noqa: E501
        if 'resource_id' in local_var_params:
            query_params.append(('resourceId', local_var_params['resource_id']))  # noqa: E501
        if 'priority' in local_var_params:
            query_params.append(('priority', local_var_params['priority']))  # noqa: E501
        if 'original' in local_var_params:
            query_params.append(('original', local_var_params['original']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'application/xml'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/item/{id}/sequence/render', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='JobType',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_sequence_render_job(self, sequence_render_request_type, **kwargs):  # noqa: E501
        """Render a standalone sequence  # noqa: E501

        Creates a new job that renders the given sequence. A new item will be created containing a shape with the rendered result once the job is finished.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_sequence_render_job(sequence_render_request_type, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param SequenceRenderRequestType sequence_render_request_type: (required)
        :key list[str] source_tag: The shape tag specifying the shapes to use as input.
        :key list[str] jobmetadata: Additional information for the job task.
        :key str notification_data: Any additional data to include for notifications on this job.
        :key list[str] tag: The shape tag specifying the format of the rendered sequence.
        :key str notification: The placeholder job notification to use for this job.
        :key str destination_item: An item id, to which the new new shape will be associated.
        :key str resource_id: The transcoder resource to use to execute the transcode.  New in version 4. 16.
        :key str priority: The priority to assign to the job.
        :key str original: If specified, should be one of the tags specified in the tag parameter.  Specifies that the original shape tag will be reset to the shape created to this tag.
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: JobType.
                 If the method is called asynchronously, returns the request thread.
        :rtype: JobType or multiprocessing.pool.AsyncResult
        """
        kwargs['_return_http_data_only'] = True
        return self.create_sequence_render_job_with_http_info(sequence_render_request_type, **kwargs)  # noqa: E501

    def create_sequence_render_job_with_http_info(self, sequence_render_request_type, **kwargs):  # noqa: E501
        """Render a standalone sequence  # noqa: E501

        Creates a new job that renders the given sequence. A new item will be created containing a shape with the rendered result once the job is finished.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_sequence_render_job_with_http_info(sequence_render_request_type, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param SequenceRenderRequestType sequence_render_request_type: (required)
        :key list[str] source_tag: The shape tag specifying the shapes to use as input.
        :key list[str] jobmetadata: Additional information for the job task.
        :key str notification_data: Any additional data to include for notifications on this job.
        :key list[str] tag: The shape tag specifying the format of the rendered sequence.
        :key str notification: The placeholder job notification to use for this job.
        :key str destination_item: An item id, to which the new new shape will be associated.
        :key str resource_id: The transcoder resource to use to execute the transcode.  New in version 4. 16.
        :key str priority: The priority to assign to the job.
        :key str original: If specified, should be one of the tags specified in the tag parameter.  Specifies that the original shape tag will be reset to the shape created to this tag.
        :key _return_http_data_only: response data without head status code
                                       and headers
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(JobType, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['sequence_render_request_type', 'source_tag', 'jobmetadata', 'notification_data', 'tag', 'notification', 'destination_item', 'resource_id', 'priority', 'original']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_sequence_render_job" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'sequence_render_request_type' is set
        if ('sequence_render_request_type' not in local_var_params or
                local_var_params['sequence_render_request_type'] is None):
            raise ApiValueError("Missing the required parameter `sequence_render_request_type` when calling `create_sequence_render_job`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'source_tag' in local_var_params:
            query_params.append(('sourceTag', local_var_params['source_tag']))  # noqa: E501
            collection_formats['sourceTag'] = 'multi'  # noqa: E501
        if 'jobmetadata' in local_var_params:
            query_params.append(('jobmetadata', local_var_params['jobmetadata']))  # noqa: E501
            collection_formats['jobmetadata'] = 'multi'  # noqa: E501
        if 'notification_data' in local_var_params:
            query_params.append(('notificationData', local_var_params['notification_data']))  # noqa: E501
        if 'tag' in local_var_params:
            query_params.append(('tag', local_var_params['tag']))  # noqa: E501
            collection_formats['tag'] = 'multi'  # noqa: E501
        if 'notification' in local_var_params:
            query_params.append(('notification', local_var_params['notification']))  # noqa: E501
        if 'destination_item' in local_var_params:
            query_params.append(('destinationItem', local_var_params['destination_item']))  # noqa: E501
        if 'resource_id' in local_var_params:
            query_params.append(('resourceId', local_var_params['resource_id']))  # noqa: E501
        if 'priority' in local_var_params:
            query_params.append(('priority', local_var_params['priority']))  # noqa: E501
        if 'original' in local_var_params:
            query_params.append(('original', local_var_params['original']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'sequence_render_request_type' in local_var_params:
            body_params = local_var_params['sequence_render_request_type']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'application/xml'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'application/xml'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/sequence/render', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='JobType',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_item_sequence(self, id, format, **kwargs):  # noqa: E501
        """Delete a sequence  # noqa: E501

        Removes a specific sequence from an item.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_item_sequence(id, format, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str id: The id. (required)
        :param str format: The format. (required)
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None.
                 If the method is called asynchronously, returns the request thread.
        :rtype: None or multiprocessing.pool.AsyncResult
        """
        kwargs['_return_http_data_only'] = True
        return self.delete_item_sequence_with_http_info(id, format, **kwargs)  # noqa: E501

    def delete_item_sequence_with_http_info(self, id, format, **kwargs):  # noqa: E501
        """Delete a sequence  # noqa: E501

        Removes a specific sequence from an item.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_item_sequence_with_http_info(id, format, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str id: The id. (required)
        :param str format: The format. (required)
        :key _return_http_data_only: response data without head status code
                                       and headers
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['id', 'format']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_item_sequence" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in local_var_params or
                local_var_params['id'] is None):
            raise ApiValueError("Missing the required parameter `id` when calling `delete_item_sequence`")  # noqa: E501
        # verify the required parameter 'format' is set
        if ('format' not in local_var_params or
                local_var_params['format'] is None):
            raise ApiValueError("Missing the required parameter `format` when calling `delete_item_sequence`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501
        if 'format' in local_var_params:
            path_params['format'] = local_var_params['format']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/item/{id}/sequence/{format}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def export_item_sequence(self, id, export_request_type, **kwargs):  # noqa: E501
        """Export a project or sequence  # noqa: E501

        Exports the sequence or project to the requested output format and saves the result at the given location.  For POST /sequence/export the sequence must be specified in the request document.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.export_item_sequence(id, export_request_type, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str id: The id. (required)
        :param ExportRequestType export_request_type: <em>ExportRequestDocument</em> with details on the export. (required)
        :key str format: Comma separated list of formats specifying which shapes to reference in the output.  If both tag and format is given, then both must match.
        :key bool to_sequence: Export as a sequence with an item, instead of as a standalone item
        :key bool dry_run: When set to `true`, any export problems will be returned and no file will be written
        :key str tag: Comma separated list of shape tags specifying which shapes to reference in the output.
        :key str type: The output format.
        :key str uri: The destination URI.
        :key list[str] content: Comma-separated list of content to include in the output.
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: str.
                 If the method is called asynchronously, returns the request thread.
        :rtype: str or multiprocessing.pool.AsyncResult
        """
        kwargs['_return_http_data_only'] = True
        return self.export_item_sequence_with_http_info(id, export_request_type, **kwargs)  # noqa: E501

    def export_item_sequence_with_http_info(self, id, export_request_type, **kwargs):  # noqa: E501
        """Export a project or sequence  # noqa: E501

        Exports the sequence or project to the requested output format and saves the result at the given location.  For POST /sequence/export the sequence must be specified in the request document.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.export_item_sequence_with_http_info(id, export_request_type, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str id: The id. (required)
        :param ExportRequestType export_request_type: <em>ExportRequestDocument</em> with details on the export. (required)
        :key str format: Comma separated list of formats specifying which shapes to reference in the output.  If both tag and format is given, then both must match.
        :key bool to_sequence: Export as a sequence with an item, instead of as a standalone item
        :key bool dry_run: When set to `true`, any export problems will be returned and no file will be written
        :key str tag: Comma separated list of shape tags specifying which shapes to reference in the output.
        :key str type: The output format.
        :key str uri: The destination URI.
        :key list[str] content: Comma-separated list of content to include in the output.
        :key _return_http_data_only: response data without head status code
                                       and headers
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(str, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['id', 'export_request_type', 'format', 'to_sequence', 'dry_run', 'tag', 'type', 'uri', 'content']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method export_item_sequence" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in local_var_params or
                local_var_params['id'] is None):
            raise ApiValueError("Missing the required parameter `id` when calling `export_item_sequence`")  # noqa: E501
        # verify the required parameter 'export_request_type' is set
        if ('export_request_type' not in local_var_params or
                local_var_params['export_request_type'] is None):
            raise ApiValueError("Missing the required parameter `export_request_type` when calling `export_item_sequence`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []
        if 'format' in local_var_params:
            query_params.append(('format', local_var_params['format']))  # noqa: E501
        if 'to_sequence' in local_var_params:
            query_params.append(('toSequence', local_var_params['to_sequence']))  # noqa: E501
        if 'dry_run' in local_var_params:
            query_params.append(('dryRun', local_var_params['dry_run']))  # noqa: E501
        if 'tag' in local_var_params:
            query_params.append(('tag', local_var_params['tag']))  # noqa: E501
        if 'type' in local_var_params:
            query_params.append(('type', local_var_params['type']))  # noqa: E501
        if 'uri' in local_var_params:
            query_params.append(('uri', local_var_params['uri']))  # noqa: E501
        if 'content' in local_var_params:
            query_params.append(('content', local_var_params['content']))  # noqa: E501
            collection_formats['content'] = 'csv'  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'export_request_type' in local_var_params:
            body_params = local_var_params['export_request_type']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['multipart/mixed', 'application/json', 'application/xml'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'application/xml'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/item/{id}/sequence/export', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='str',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def export_sequence(self, export_request_type, **kwargs):  # noqa: E501
        """Export a project or sequence  # noqa: E501

        Exports the sequence or project to the requested output format and saves the result at the given location.  For POST /sequence/export the sequence must be specified in the request document.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.export_sequence(export_request_type, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param ExportRequestType export_request_type: <em>ExportRequestDocument</em> with details on the export. (required)
        :key str format: Comma separated list of formats specifying which shapes to reference in the output.  If both tag and format is given, then both must match.
        :key bool to_sequence: Export as a sequence with an item, instead of as a standalone item
        :key bool dry_run: When set to `true`, any export problems will be returned and no file will be written
        :key str tag: Comma separated list of shape tags specifying which shapes to reference in the output.
        :key str type: The output format.
        :key str uri: The destination URI.
        :key list[str] content: Comma-separated list of content to include in the output.
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: str.
                 If the method is called asynchronously, returns the request thread.
        :rtype: str or multiprocessing.pool.AsyncResult
        """
        kwargs['_return_http_data_only'] = True
        return self.export_sequence_with_http_info(export_request_type, **kwargs)  # noqa: E501

    def export_sequence_with_http_info(self, export_request_type, **kwargs):  # noqa: E501
        """Export a project or sequence  # noqa: E501

        Exports the sequence or project to the requested output format and saves the result at the given location.  For POST /sequence/export the sequence must be specified in the request document.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.export_sequence_with_http_info(export_request_type, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param ExportRequestType export_request_type: <em>ExportRequestDocument</em> with details on the export. (required)
        :key str format: Comma separated list of formats specifying which shapes to reference in the output.  If both tag and format is given, then both must match.
        :key bool to_sequence: Export as a sequence with an item, instead of as a standalone item
        :key bool dry_run: When set to `true`, any export problems will be returned and no file will be written
        :key str tag: Comma separated list of shape tags specifying which shapes to reference in the output.
        :key str type: The output format.
        :key str uri: The destination URI.
        :key list[str] content: Comma-separated list of content to include in the output.
        :key _return_http_data_only: response data without head status code
                                       and headers
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(str, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['export_request_type', 'format', 'to_sequence', 'dry_run', 'tag', 'type', 'uri', 'content']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method export_sequence" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'export_request_type' is set
        if ('export_request_type' not in local_var_params or
                local_var_params['export_request_type'] is None):
            raise ApiValueError("Missing the required parameter `export_request_type` when calling `export_sequence`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'format' in local_var_params:
            query_params.append(('format', local_var_params['format']))  # noqa: E501
        if 'to_sequence' in local_var_params:
            query_params.append(('toSequence', local_var_params['to_sequence']))  # noqa: E501
        if 'dry_run' in local_var_params:
            query_params.append(('dryRun', local_var_params['dry_run']))  # noqa: E501
        if 'tag' in local_var_params:
            query_params.append(('tag', local_var_params['tag']))  # noqa: E501
        if 'type' in local_var_params:
            query_params.append(('type', local_var_params['type']))  # noqa: E501
        if 'uri' in local_var_params:
            query_params.append(('uri', local_var_params['uri']))  # noqa: E501
        if 'content' in local_var_params:
            query_params.append(('content', local_var_params['content']))  # noqa: E501
            collection_formats['content'] = 'csv'  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'export_request_type' in local_var_params:
            body_params = local_var_params['export_request_type']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['multipart/mixed', 'application/json', 'application/xml'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'application/xml'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/sequence/export', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='str',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_item_sequence(self, id, format, **kwargs):  # noqa: E501
        """Retrieve a sequence  # noqa: E501

        Retrieves the definition of the sequence in the given format.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_item_sequence(id, format, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str id: The id. (required)
        :param str format: The format. (required)
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: str.
                 If the method is called asynchronously, returns the request thread.
        :rtype: str or multiprocessing.pool.AsyncResult
        """
        kwargs['_return_http_data_only'] = True
        return self.get_item_sequence_with_http_info(id, format, **kwargs)  # noqa: E501

    def get_item_sequence_with_http_info(self, id, format, **kwargs):  # noqa: E501
        """Retrieve a sequence  # noqa: E501

        Retrieves the definition of the sequence in the given format.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_item_sequence_with_http_info(id, format, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str id: The id. (required)
        :param str format: The format. (required)
        :key _return_http_data_only: response data without head status code
                                       and headers
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(str, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['id', 'format']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_item_sequence" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in local_var_params or
                local_var_params['id'] is None):
            raise ApiValueError("Missing the required parameter `id` when calling `get_item_sequence`")  # noqa: E501
        # verify the required parameter 'format' is set
        if ('format' not in local_var_params or
                local_var_params['format'] is None):
            raise ApiValueError("Missing the required parameter `format` when calling `get_item_sequence`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501
        if 'format' in local_var_params:
            path_params['format'] = local_var_params['format']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/item/{id}/sequence/{format}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='str',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_item_sequence_in_format(self, id, **kwargs):  # noqa: E501
        """Export a project or sequence  # noqa: E501

        Exports the sequence or project to the requested output format and saves the result at the given location.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_item_sequence_in_format(id, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str id: The id. (required)
        :key str format: Comma separated list of formats specifying which shapes to reference in the output.  If both tag and format is given, then both must match.
        :key bool to_sequence: Export as a sequence with an item, instead of as a standalone item
        :key list[str] storage: Comma-separated list of item paths in format `storageId=path`.
        :key bool dry_run: When set to `true`, any export problems will be returned and no file will be written
        :key str tag: Comma separated list of shape tags specifying which shapes to reference in the output.
        :key str type: The output format.
        :key list[str] item: Comma-separated list of item paths in format `itemId=path`.
        :key list[str] content: Comma-separated list of content to include in the output.
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: str.
                 If the method is called asynchronously, returns the request thread.
        :rtype: str or multiprocessing.pool.AsyncResult
        """
        kwargs['_return_http_data_only'] = True
        return self.get_item_sequence_in_format_with_http_info(id, **kwargs)  # noqa: E501

    def get_item_sequence_in_format_with_http_info(self, id, **kwargs):  # noqa: E501
        """Export a project or sequence  # noqa: E501

        Exports the sequence or project to the requested output format and saves the result at the given location.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_item_sequence_in_format_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str id: The id. (required)
        :key str format: Comma separated list of formats specifying which shapes to reference in the output.  If both tag and format is given, then both must match.
        :key bool to_sequence: Export as a sequence with an item, instead of as a standalone item
        :key list[str] storage: Comma-separated list of item paths in format `storageId=path`.
        :key bool dry_run: When set to `true`, any export problems will be returned and no file will be written
        :key str tag: Comma separated list of shape tags specifying which shapes to reference in the output.
        :key str type: The output format.
        :key list[str] item: Comma-separated list of item paths in format `itemId=path`.
        :key list[str] content: Comma-separated list of content to include in the output.
        :key _return_http_data_only: response data without head status code
                                       and headers
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(str, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['id', 'format', 'to_sequence', 'storage', 'dry_run', 'tag', 'type', 'item', 'content']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_item_sequence_in_format" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in local_var_params or
                local_var_params['id'] is None):
            raise ApiValueError("Missing the required parameter `id` when calling `get_item_sequence_in_format`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []
        if 'format' in local_var_params:
            query_params.append(('format', local_var_params['format']))  # noqa: E501
        if 'to_sequence' in local_var_params:
            query_params.append(('toSequence', local_var_params['to_sequence']))  # noqa: E501
        if 'storage' in local_var_params:
            query_params.append(('storage', local_var_params['storage']))  # noqa: E501
            collection_formats['storage'] = 'csv'  # noqa: E501
        if 'dry_run' in local_var_params:
            query_params.append(('dryRun', local_var_params['dry_run']))  # noqa: E501
        if 'tag' in local_var_params:
            query_params.append(('tag', local_var_params['tag']))  # noqa: E501
        if 'type' in local_var_params:
            query_params.append(('type', local_var_params['type']))  # noqa: E501
        if 'item' in local_var_params:
            query_params.append(('item', local_var_params['item']))  # noqa: E501
            collection_formats['item'] = 'csv'  # noqa: E501
        if 'content' in local_var_params:
            query_params.append(('content', local_var_params['content']))  # noqa: E501
            collection_formats['content'] = 'csv'  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*', 'application/json', 'application/xml'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/item/{id}/sequence/export', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='str',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_item_sequences(self, id, **kwargs):  # noqa: E501
        """List all sequences  # noqa: E501

        Retrieves the sequences that have been stored for a specific item.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_item_sequences(id, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str id: The id. (required)
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: SequenceListType.
                 If the method is called asynchronously, returns the request thread.
        :rtype: SequenceListType or multiprocessing.pool.AsyncResult
        """
        kwargs['_return_http_data_only'] = True
        return self.get_item_sequences_with_http_info(id, **kwargs)  # noqa: E501

    def get_item_sequences_with_http_info(self, id, **kwargs):  # noqa: E501
        """List all sequences  # noqa: E501

        Retrieves the sequences that have been stored for a specific item.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_item_sequences_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str id: The id. (required)
        :key _return_http_data_only: response data without head status code
                                       and headers
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(SequenceListType, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_item_sequences" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in local_var_params or
                local_var_params['id'] is None):
            raise ApiValueError("Missing the required parameter `id` when calling `get_item_sequences`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'application/xml'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/item/{id}/sequence', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SequenceListType',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_item_metadata_from_sequence(self, id, **kwargs):  # noqa: E501
        """Conform metadata  # noqa: E501

        Updates the item metadata with the metadata from the items listed in the sequence. The metadata will be selected based on the intervals.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_item_metadata_from_sequence(id, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str id: The id. (required)
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None.
                 If the method is called asynchronously, returns the request thread.
        :rtype: None or multiprocessing.pool.AsyncResult
        """
        kwargs['_return_http_data_only'] = True
        return self.update_item_metadata_from_sequence_with_http_info(id, **kwargs)  # noqa: E501

    def update_item_metadata_from_sequence_with_http_info(self, id, **kwargs):  # noqa: E501
        """Conform metadata  # noqa: E501

        Updates the item metadata with the metadata from the items listed in the sequence. The metadata will be selected based on the intervals.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_item_metadata_from_sequence_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str id: The id. (required)
        :key _return_http_data_only: response data without head status code
                                       and headers
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_item_metadata_from_sequence" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in local_var_params or
                local_var_params['id'] is None):
            raise ApiValueError("Missing the required parameter `id` when calling `update_item_metadata_from_sequence`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/item/{id}/sequence/conform-metadata', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_or_create_item_sequence(self, id, format, body, **kwargs):  # noqa: E501
        """Update or create a sequence  # noqa: E501

        Creates or updates the sequence in the given format.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_or_create_item_sequence(id, format, body, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str id: The id. (required)
        :param str format: The format. (required)
        :param file body: The sequence definition (required)
        :key int pause_frame: When a rendering job is started, this parameter determines which frame the job will pause at.  The job will resume when the sequence is updated.
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: ItemType.
                 If the method is called asynchronously, returns the request thread.
        :rtype: ItemType or multiprocessing.pool.AsyncResult
        """
        kwargs['_return_http_data_only'] = True
        return self.update_or_create_item_sequence_with_http_info(id, format, body, **kwargs)  # noqa: E501

    def update_or_create_item_sequence_with_http_info(self, id, format, body, **kwargs):  # noqa: E501
        """Update or create a sequence  # noqa: E501

        Creates or updates the sequence in the given format.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_or_create_item_sequence_with_http_info(id, format, body, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str id: The id. (required)
        :param str format: The format. (required)
        :param file body: The sequence definition (required)
        :key int pause_frame: When a rendering job is started, this parameter determines which frame the job will pause at.  The job will resume when the sequence is updated.
        :key _return_http_data_only: response data without head status code
                                       and headers
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(ItemType, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['id', 'format', 'body', 'pause_frame']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_or_create_item_sequence" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in local_var_params or
                local_var_params['id'] is None):
            raise ApiValueError("Missing the required parameter `id` when calling `update_or_create_item_sequence`")  # noqa: E501
        # verify the required parameter 'format' is set
        if ('format' not in local_var_params or
                local_var_params['format'] is None):
            raise ApiValueError("Missing the required parameter `format` when calling `update_or_create_item_sequence`")  # noqa: E501
        # verify the required parameter 'body' is set
        if ('body' not in local_var_params or
                local_var_params['body'] is None):
            raise ApiValueError("Missing the required parameter `body` when calling `update_or_create_item_sequence`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501
        if 'format' in local_var_params:
            path_params['format'] = local_var_params['format']  # noqa: E501

        query_params = []
        if 'pause_frame' in local_var_params:
            query_params.append(('pauseFrame', local_var_params['pause_frame']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in local_var_params:
            body_params = local_var_params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'application/xml'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/octet-stream'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/item/{id}/sequence/{format}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ItemType',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)
