# coding: utf-8

"""
    Vidispine API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)  # noqa: E501

    The version of the OpenAPI document: 5.x
    Contact: info@vidispine.com
    Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from vidispine.models import *
from vidispine.api_client import ApiClient
from vidispine.exceptions import (
    ApiTypeError,
    ApiValueError
)


class ShapeApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def add_file_to_component(self, id, shape_id, component_id, file_id, **kwargs):  # noqa: E501
        """Associate a file with a component  # noqa: E501

        Attaches the specified file to the specified component  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.add_file_to_component(id, shape_id, component_id, file_id, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str id: The id. (required)
        :param str shape_id: The shape id. (required)
        :param str component_id: The component id. (required)
        :param str file_id: The file id. (required)
        :key bool allow_reimport: - `true` - Associate the file regardless of whether it already belongs to a component.  - `false` (default) - Only files that do not already belong to a component can be associated.
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: ComponentType.
                 If the method is called asynchronously, returns the request thread.
        :rtype: ComponentType or multiprocessing.pool.AsyncResult
        """
        kwargs['_return_http_data_only'] = True
        return self.add_file_to_component_with_http_info(id, shape_id, component_id, file_id, **kwargs)  # noqa: E501

    def add_file_to_component_with_http_info(self, id, shape_id, component_id, file_id, **kwargs):  # noqa: E501
        """Associate a file with a component  # noqa: E501

        Attaches the specified file to the specified component  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_file_to_component_with_http_info(id, shape_id, component_id, file_id, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str id: The id. (required)
        :param str shape_id: The shape id. (required)
        :param str component_id: The component id. (required)
        :param str file_id: The file id. (required)
        :key bool allow_reimport: - `true` - Associate the file regardless of whether it already belongs to a component.  - `false` (default) - Only files that do not already belong to a component can be associated.
        :key _return_http_data_only: response data without head status code
                                       and headers
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(ComponentType, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['id', 'shape_id', 'component_id', 'file_id', 'allow_reimport']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method add_file_to_component" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in local_var_params or
                local_var_params['id'] is None):
            raise ApiValueError("Missing the required parameter `id` when calling `add_file_to_component`")  # noqa: E501
        # verify the required parameter 'shape_id' is set
        if ('shape_id' not in local_var_params or
                local_var_params['shape_id'] is None):
            raise ApiValueError("Missing the required parameter `shape_id` when calling `add_file_to_component`")  # noqa: E501
        # verify the required parameter 'component_id' is set
        if ('component_id' not in local_var_params or
                local_var_params['component_id'] is None):
            raise ApiValueError("Missing the required parameter `component_id` when calling `add_file_to_component`")  # noqa: E501
        # verify the required parameter 'file_id' is set
        if ('file_id' not in local_var_params or
                local_var_params['file_id'] is None):
            raise ApiValueError("Missing the required parameter `file_id` when calling `add_file_to_component`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501
        if 'shape_id' in local_var_params:
            path_params['shape-id'] = local_var_params['shape_id']  # noqa: E501
        if 'component_id' in local_var_params:
            path_params['component-id'] = local_var_params['component_id']  # noqa: E501
        if 'file_id' in local_var_params:
            path_params['file-id'] = local_var_params['file_id']  # noqa: E501

        query_params = []
        if 'allow_reimport' in local_var_params:
            query_params.append(('allowReimport', local_var_params['allow_reimport']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'application/xml'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/item/{id}/shape/{shape-id}/component/{component-id}/file/{file-id}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ComponentType',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def add_shape_mime_type(self, id, shape_id, mime_type, **kwargs):  # noqa: E501
        """Add a mime type to a shape  # noqa: E501

        Adds a new mime type to the shape. This operation does nothing if the shape already has the mime-type.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.add_shape_mime_type(id, shape_id, mime_type, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str id: The id. (required)
        :param str shape_id: The shape id. (required)
        :param str mime_type: The mime type. (required)
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None.
                 If the method is called asynchronously, returns the request thread.
        :rtype: None or multiprocessing.pool.AsyncResult
        """
        kwargs['_return_http_data_only'] = True
        return self.add_shape_mime_type_with_http_info(id, shape_id, mime_type, **kwargs)  # noqa: E501

    def add_shape_mime_type_with_http_info(self, id, shape_id, mime_type, **kwargs):  # noqa: E501
        """Add a mime type to a shape  # noqa: E501

        Adds a new mime type to the shape. This operation does nothing if the shape already has the mime-type.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_shape_mime_type_with_http_info(id, shape_id, mime_type, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str id: The id. (required)
        :param str shape_id: The shape id. (required)
        :param str mime_type: The mime type. (required)
        :key _return_http_data_only: response data without head status code
                                       and headers
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['id', 'shape_id', 'mime_type']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method add_shape_mime_type" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in local_var_params or
                local_var_params['id'] is None):
            raise ApiValueError("Missing the required parameter `id` when calling `add_shape_mime_type`")  # noqa: E501
        # verify the required parameter 'shape_id' is set
        if ('shape_id' not in local_var_params or
                local_var_params['shape_id'] is None):
            raise ApiValueError("Missing the required parameter `shape_id` when calling `add_shape_mime_type`")  # noqa: E501
        # verify the required parameter 'mime_type' is set
        if ('mime_type' not in local_var_params or
                local_var_params['mime_type'] is None):
            raise ApiValueError("Missing the required parameter `mime_type` when calling `add_shape_mime_type`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501
        if 'shape_id' in local_var_params:
            path_params['shape-id'] = local_var_params['shape_id']  # noqa: E501
        if 'mime_type' in local_var_params:
            path_params['mime-type'] = local_var_params['mime_type']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/item/{id}/shape/{shape-id}/mime/{mime-type}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def add_shape_tag(self, item_id, shape_id, tag_name, **kwargs):  # noqa: E501
        """Add a tag to a shape  # noqa: E501

        Adds shape tag with the given name to the specified shape. If the shape already has that tag, this operation does nothing.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.add_shape_tag(item_id, shape_id, tag_name, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str item_id: The item id. (required)
        :param str shape_id: The shape id. (required)
        :param str tag_name: The tag name. (required)
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None.
                 If the method is called asynchronously, returns the request thread.
        :rtype: None or multiprocessing.pool.AsyncResult
        """
        kwargs['_return_http_data_only'] = True
        return self.add_shape_tag_with_http_info(item_id, shape_id, tag_name, **kwargs)  # noqa: E501

    def add_shape_tag_with_http_info(self, item_id, shape_id, tag_name, **kwargs):  # noqa: E501
        """Add a tag to a shape  # noqa: E501

        Adds shape tag with the given name to the specified shape. If the shape already has that tag, this operation does nothing.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_shape_tag_with_http_info(item_id, shape_id, tag_name, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str item_id: The item id. (required)
        :param str shape_id: The shape id. (required)
        :param str tag_name: The tag name. (required)
        :key _return_http_data_only: response data without head status code
                                       and headers
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['item_id', 'shape_id', 'tag_name']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method add_shape_tag" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'item_id' is set
        if ('item_id' not in local_var_params or
                local_var_params['item_id'] is None):
            raise ApiValueError("Missing the required parameter `item_id` when calling `add_shape_tag`")  # noqa: E501
        # verify the required parameter 'shape_id' is set
        if ('shape_id' not in local_var_params or
                local_var_params['shape_id'] is None):
            raise ApiValueError("Missing the required parameter `shape_id` when calling `add_shape_tag`")  # noqa: E501
        # verify the required parameter 'tag_name' is set
        if ('tag_name' not in local_var_params or
                local_var_params['tag_name'] is None):
            raise ApiValueError("Missing the required parameter `tag_name` when calling `add_shape_tag`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'item_id' in local_var_params:
            path_params['item-id'] = local_var_params['item_id']  # noqa: E501
        if 'shape_id' in local_var_params:
            path_params['shape-id'] = local_var_params['shape_id']  # noqa: E501
        if 'tag_name' in local_var_params:
            path_params['tag-name'] = local_var_params['tag_name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/item/{item-id}/shape/{shape-id}/tag/{tag-name}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def copy_component_to_component(self, id, shape_id, component_id, target_id, target_shape_id, target_component_id, **kwargs):  # noqa: E501
        """Copy a component to another shape/component  # noqa: E501

        Copy this component to another shape, replacing a specific component by id.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.copy_component_to_component(id, shape_id, component_id, target_id, target_shape_id, target_component_id, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str id: The id. (required)
        :param str shape_id: The shape id. (required)
        :param str component_id: The component id. (required)
        :param str target_id: The target id. (required)
        :param str target_shape_id: The target shape id. (required)
        :param str target_component_id: The target component id. (required)
        :key int index: The component index (track) of component.  If the target shape has a component with this index, then it will be replaced/removed.
        :key bool keep_metadata: - `true` - Preserve the metadata from the replaced component.  - `false` (default) - Discard any metadata from the replaced component.
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: ShapeType.
                 If the method is called asynchronously, returns the request thread.
        :rtype: ShapeType or multiprocessing.pool.AsyncResult
        """
        kwargs['_return_http_data_only'] = True
        return self.copy_component_to_component_with_http_info(id, shape_id, component_id, target_id, target_shape_id, target_component_id, **kwargs)  # noqa: E501

    def copy_component_to_component_with_http_info(self, id, shape_id, component_id, target_id, target_shape_id, target_component_id, **kwargs):  # noqa: E501
        """Copy a component to another shape/component  # noqa: E501

        Copy this component to another shape, replacing a specific component by id.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.copy_component_to_component_with_http_info(id, shape_id, component_id, target_id, target_shape_id, target_component_id, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str id: The id. (required)
        :param str shape_id: The shape id. (required)
        :param str component_id: The component id. (required)
        :param str target_id: The target id. (required)
        :param str target_shape_id: The target shape id. (required)
        :param str target_component_id: The target component id. (required)
        :key int index: The component index (track) of component.  If the target shape has a component with this index, then it will be replaced/removed.
        :key bool keep_metadata: - `true` - Preserve the metadata from the replaced component.  - `false` (default) - Discard any metadata from the replaced component.
        :key _return_http_data_only: response data without head status code
                                       and headers
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(ShapeType, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['id', 'shape_id', 'component_id', 'target_id', 'target_shape_id', 'target_component_id', 'index', 'keep_metadata']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method copy_component_to_component" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in local_var_params or
                local_var_params['id'] is None):
            raise ApiValueError("Missing the required parameter `id` when calling `copy_component_to_component`")  # noqa: E501
        # verify the required parameter 'shape_id' is set
        if ('shape_id' not in local_var_params or
                local_var_params['shape_id'] is None):
            raise ApiValueError("Missing the required parameter `shape_id` when calling `copy_component_to_component`")  # noqa: E501
        # verify the required parameter 'component_id' is set
        if ('component_id' not in local_var_params or
                local_var_params['component_id'] is None):
            raise ApiValueError("Missing the required parameter `component_id` when calling `copy_component_to_component`")  # noqa: E501
        # verify the required parameter 'target_id' is set
        if ('target_id' not in local_var_params or
                local_var_params['target_id'] is None):
            raise ApiValueError("Missing the required parameter `target_id` when calling `copy_component_to_component`")  # noqa: E501
        # verify the required parameter 'target_shape_id' is set
        if ('target_shape_id' not in local_var_params or
                local_var_params['target_shape_id'] is None):
            raise ApiValueError("Missing the required parameter `target_shape_id` when calling `copy_component_to_component`")  # noqa: E501
        # verify the required parameter 'target_component_id' is set
        if ('target_component_id' not in local_var_params or
                local_var_params['target_component_id'] is None):
            raise ApiValueError("Missing the required parameter `target_component_id` when calling `copy_component_to_component`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501
        if 'shape_id' in local_var_params:
            path_params['shape-id'] = local_var_params['shape_id']  # noqa: E501
        if 'component_id' in local_var_params:
            path_params['component-id'] = local_var_params['component_id']  # noqa: E501
        if 'target_id' in local_var_params:
            path_params['target-id'] = local_var_params['target_id']  # noqa: E501
        if 'target_shape_id' in local_var_params:
            path_params['target-shape-id'] = local_var_params['target_shape_id']  # noqa: E501
        if 'target_component_id' in local_var_params:
            path_params['target-component-id'] = local_var_params['target_component_id']  # noqa: E501

        query_params = []
        if 'index' in local_var_params:
            query_params.append(('index', local_var_params['index']))  # noqa: E501
        if 'keep_metadata' in local_var_params:
            query_params.append(('keepMetadata', local_var_params['keep_metadata']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'application/xml'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/item/{id}/shape/{shape-id}/component/{component-id}/copy/item/{target-id}/shape/{target-shape-id}/component/{target-component-id}', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ShapeType',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def copy_component_to_shape(self, id, shape_id, component_id, target_id, target_shape_id, **kwargs):  # noqa: E501
        """Copy a component to another shape  # noqa: E501

        Copy this component to another shape.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.copy_component_to_shape(id, shape_id, component_id, target_id, target_shape_id, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str id: The id. (required)
        :param str shape_id: The shape id. (required)
        :param str component_id: The component id. (required)
        :param str target_id: The target id. (required)
        :param str target_shape_id: The target shape id. (required)
        :key int index: The component index (track) of component.  If the target shape has a component with this index, then it will be replaced/removed.
        :key bool keep_metadata: - `true` - Preserve the metadata from the replaced component.  - `false` (default) - Discard any metadata from the replaced component.
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: ShapeType.
                 If the method is called asynchronously, returns the request thread.
        :rtype: ShapeType or multiprocessing.pool.AsyncResult
        """
        kwargs['_return_http_data_only'] = True
        return self.copy_component_to_shape_with_http_info(id, shape_id, component_id, target_id, target_shape_id, **kwargs)  # noqa: E501

    def copy_component_to_shape_with_http_info(self, id, shape_id, component_id, target_id, target_shape_id, **kwargs):  # noqa: E501
        """Copy a component to another shape  # noqa: E501

        Copy this component to another shape.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.copy_component_to_shape_with_http_info(id, shape_id, component_id, target_id, target_shape_id, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str id: The id. (required)
        :param str shape_id: The shape id. (required)
        :param str component_id: The component id. (required)
        :param str target_id: The target id. (required)
        :param str target_shape_id: The target shape id. (required)
        :key int index: The component index (track) of component.  If the target shape has a component with this index, then it will be replaced/removed.
        :key bool keep_metadata: - `true` - Preserve the metadata from the replaced component.  - `false` (default) - Discard any metadata from the replaced component.
        :key _return_http_data_only: response data without head status code
                                       and headers
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(ShapeType, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['id', 'shape_id', 'component_id', 'target_id', 'target_shape_id', 'index', 'keep_metadata']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method copy_component_to_shape" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in local_var_params or
                local_var_params['id'] is None):
            raise ApiValueError("Missing the required parameter `id` when calling `copy_component_to_shape`")  # noqa: E501
        # verify the required parameter 'shape_id' is set
        if ('shape_id' not in local_var_params or
                local_var_params['shape_id'] is None):
            raise ApiValueError("Missing the required parameter `shape_id` when calling `copy_component_to_shape`")  # noqa: E501
        # verify the required parameter 'component_id' is set
        if ('component_id' not in local_var_params or
                local_var_params['component_id'] is None):
            raise ApiValueError("Missing the required parameter `component_id` when calling `copy_component_to_shape`")  # noqa: E501
        # verify the required parameter 'target_id' is set
        if ('target_id' not in local_var_params or
                local_var_params['target_id'] is None):
            raise ApiValueError("Missing the required parameter `target_id` when calling `copy_component_to_shape`")  # noqa: E501
        # verify the required parameter 'target_shape_id' is set
        if ('target_shape_id' not in local_var_params or
                local_var_params['target_shape_id'] is None):
            raise ApiValueError("Missing the required parameter `target_shape_id` when calling `copy_component_to_shape`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501
        if 'shape_id' in local_var_params:
            path_params['shape-id'] = local_var_params['shape_id']  # noqa: E501
        if 'component_id' in local_var_params:
            path_params['component-id'] = local_var_params['component_id']  # noqa: E501
        if 'target_id' in local_var_params:
            path_params['target-id'] = local_var_params['target_id']  # noqa: E501
        if 'target_shape_id' in local_var_params:
            path_params['target-shape-id'] = local_var_params['target_shape_id']  # noqa: E501

        query_params = []
        if 'index' in local_var_params:
            query_params.append(('index', local_var_params['index']))  # noqa: E501
        if 'keep_metadata' in local_var_params:
            query_params.append(('keepMetadata', local_var_params['keep_metadata']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'application/xml'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/item/{id}/shape/{shape-id}/component/{component-id}/copy/item/{target-id}/shape/{target-shape-id}', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ShapeType',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def copy_shape_essence_version(self, id, shape_id, **kwargs):  # noqa: E501
        """Copy an essence version of a shape to a new version  # noqa: E501

        Copies the specified shape to a new shape, with the new latest essence version number.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.copy_shape_essence_version(id, shape_id, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str id: The id. (required)
        :param str shape_id: The shape id. (required)
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: ShapeType.
                 If the method is called asynchronously, returns the request thread.
        :rtype: ShapeType or multiprocessing.pool.AsyncResult
        """
        kwargs['_return_http_data_only'] = True
        return self.copy_shape_essence_version_with_http_info(id, shape_id, **kwargs)  # noqa: E501

    def copy_shape_essence_version_with_http_info(self, id, shape_id, **kwargs):  # noqa: E501
        """Copy an essence version of a shape to a new version  # noqa: E501

        Copies the specified shape to a new shape, with the new latest essence version number.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.copy_shape_essence_version_with_http_info(id, shape_id, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str id: The id. (required)
        :param str shape_id: The shape id. (required)
        :key _return_http_data_only: response data without head status code
                                       and headers
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(ShapeType, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['id', 'shape_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method copy_shape_essence_version" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in local_var_params or
                local_var_params['id'] is None):
            raise ApiValueError("Missing the required parameter `id` when calling `copy_shape_essence_version`")  # noqa: E501
        # verify the required parameter 'shape_id' is set
        if ('shape_id' not in local_var_params or
                local_var_params['shape_id'] is None):
            raise ApiValueError("Missing the required parameter `shape_id` when calling `copy_shape_essence_version`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501
        if 'shape_id' in local_var_params:
            path_params['shape-id'] = local_var_params['shape_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'application/xml'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/item/{id}/shape/{shape-id}/version', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ShapeType',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def copy_shape_essence_version_to_version(self, id, shape_id, new_version, **kwargs):  # noqa: E501
        """Copy an essence version of a shape to a specific version  # noqa: E501

        Copies the specified shape to a new shape, with the given essence version number.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.copy_shape_essence_version_to_version(id, shape_id, new_version, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str id: The id. (required)
        :param str shape_id: The shape id. (required)
        :param str new_version: The new version. (required)
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: ShapeType.
                 If the method is called asynchronously, returns the request thread.
        :rtype: ShapeType or multiprocessing.pool.AsyncResult
        """
        kwargs['_return_http_data_only'] = True
        return self.copy_shape_essence_version_to_version_with_http_info(id, shape_id, new_version, **kwargs)  # noqa: E501

    def copy_shape_essence_version_to_version_with_http_info(self, id, shape_id, new_version, **kwargs):  # noqa: E501
        """Copy an essence version of a shape to a specific version  # noqa: E501

        Copies the specified shape to a new shape, with the given essence version number.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.copy_shape_essence_version_to_version_with_http_info(id, shape_id, new_version, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str id: The id. (required)
        :param str shape_id: The shape id. (required)
        :param str new_version: The new version. (required)
        :key _return_http_data_only: response data without head status code
                                       and headers
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(ShapeType, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['id', 'shape_id', 'new_version']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method copy_shape_essence_version_to_version" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in local_var_params or
                local_var_params['id'] is None):
            raise ApiValueError("Missing the required parameter `id` when calling `copy_shape_essence_version_to_version`")  # noqa: E501
        # verify the required parameter 'shape_id' is set
        if ('shape_id' not in local_var_params or
                local_var_params['shape_id'] is None):
            raise ApiValueError("Missing the required parameter `shape_id` when calling `copy_shape_essence_version_to_version`")  # noqa: E501
        # verify the required parameter 'new_version' is set
        if ('new_version' not in local_var_params or
                local_var_params['new_version'] is None):
            raise ApiValueError("Missing the required parameter `new_version` when calling `copy_shape_essence_version_to_version`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501
        if 'shape_id' in local_var_params:
            path_params['shape-id'] = local_var_params['shape_id']  # noqa: E501
        if 'new_version' in local_var_params:
            path_params['new-version'] = local_var_params['new_version']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'application/xml'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/item/{id}/shape/{shape-id}/version/{new-version}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ShapeType',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_placeholder_component(self, type, id, shape_id, **kwargs):  # noqa: E501
        """Create a placeholder component  # noqa: E501

        Creates an new placeholder component for a specific shape.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_placeholder_component(type, id, shape_id, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str type: The type of component. (required)
        :param str id: The id. (required)
        :param str shape_id: The shape id. (required)
        :key int index: The component index (track) of new component.
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: ComponentType.
                 If the method is called asynchronously, returns the request thread.
        :rtype: ComponentType or multiprocessing.pool.AsyncResult
        """
        kwargs['_return_http_data_only'] = True
        return self.create_placeholder_component_with_http_info(type, id, shape_id, **kwargs)  # noqa: E501

    def create_placeholder_component_with_http_info(self, type, id, shape_id, **kwargs):  # noqa: E501
        """Create a placeholder component  # noqa: E501

        Creates an new placeholder component for a specific shape.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_placeholder_component_with_http_info(type, id, shape_id, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str type: The type of component. (required)
        :param str id: The id. (required)
        :param str shape_id: The shape id. (required)
        :key int index: The component index (track) of new component.
        :key _return_http_data_only: response data without head status code
                                       and headers
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(ComponentType, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['type', 'id', 'shape_id', 'index']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_placeholder_component" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'type' is set
        if ('type' not in local_var_params or
                local_var_params['type'] is None):
            raise ApiValueError("Missing the required parameter `type` when calling `create_placeholder_component`")  # noqa: E501
        # verify the required parameter 'id' is set
        if ('id' not in local_var_params or
                local_var_params['id'] is None):
            raise ApiValueError("Missing the required parameter `id` when calling `create_placeholder_component`")  # noqa: E501
        # verify the required parameter 'shape_id' is set
        if ('shape_id' not in local_var_params or
                local_var_params['shape_id'] is None):
            raise ApiValueError("Missing the required parameter `shape_id` when calling `create_placeholder_component`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501
        if 'shape_id' in local_var_params:
            path_params['shape-id'] = local_var_params['shape_id']  # noqa: E501

        query_params = []
        if 'type' in local_var_params:
            query_params.append(('type', local_var_params['type']))  # noqa: E501
        if 'index' in local_var_params:
            query_params.append(('index', local_var_params['index']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'application/xml'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/item/{id}/shape/{shape-id}/component/placeholder', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ComponentType',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_shape_deduction_job(self, item_id, shape_id, **kwargs):  # noqa: E501
        """Re-run a shape deduction on an existing shape  # noqa: E501

        Starts a new shape deduction job for the specified shape.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_shape_deduction_job(item_id, shape_id, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str item_id: The item id. (required)
        :param str shape_id: The shape id. (required)
        :key list[str] jobmetadata: Additional information for the job task.
        :key str notification_data: Any additional data to include for notifications on this job.
        :key str priority: The priority to assign to the job.
        :key str notification: The placeholder job notification to use for this job.
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: JobType.
                 If the method is called asynchronously, returns the request thread.
        :rtype: JobType or multiprocessing.pool.AsyncResult
        """
        kwargs['_return_http_data_only'] = True
        return self.create_shape_deduction_job_with_http_info(item_id, shape_id, **kwargs)  # noqa: E501

    def create_shape_deduction_job_with_http_info(self, item_id, shape_id, **kwargs):  # noqa: E501
        """Re-run a shape deduction on an existing shape  # noqa: E501

        Starts a new shape deduction job for the specified shape.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_shape_deduction_job_with_http_info(item_id, shape_id, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str item_id: The item id. (required)
        :param str shape_id: The shape id. (required)
        :key list[str] jobmetadata: Additional information for the job task.
        :key str notification_data: Any additional data to include for notifications on this job.
        :key str priority: The priority to assign to the job.
        :key str notification: The placeholder job notification to use for this job.
        :key _return_http_data_only: response data without head status code
                                       and headers
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(JobType, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['item_id', 'shape_id', 'jobmetadata', 'notification_data', 'priority', 'notification']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_shape_deduction_job" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'item_id' is set
        if ('item_id' not in local_var_params or
                local_var_params['item_id'] is None):
            raise ApiValueError("Missing the required parameter `item_id` when calling `create_shape_deduction_job`")  # noqa: E501
        # verify the required parameter 'shape_id' is set
        if ('shape_id' not in local_var_params or
                local_var_params['shape_id'] is None):
            raise ApiValueError("Missing the required parameter `shape_id` when calling `create_shape_deduction_job`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'item_id' in local_var_params:
            path_params['item-id'] = local_var_params['item_id']  # noqa: E501
        if 'shape_id' in local_var_params:
            path_params['shape-id'] = local_var_params['shape_id']  # noqa: E501

        query_params = []
        if 'jobmetadata' in local_var_params:
            query_params.append(('jobmetadata', local_var_params['jobmetadata']))  # noqa: E501
            collection_formats['jobmetadata'] = 'multi'  # noqa: E501
        if 'notification_data' in local_var_params:
            query_params.append(('notificationData', local_var_params['notification_data']))  # noqa: E501
        if 'priority' in local_var_params:
            query_params.append(('priority', local_var_params['priority']))  # noqa: E501
        if 'notification' in local_var_params:
            query_params.append(('notification', local_var_params['notification']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'application/xml'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/item/{item-id}/shape/{shape-id}/update', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='JobType',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_shape_export_job(self, item_id, shape_id, **kwargs):  # noqa: E501
        """Start an export job for a single shape  # noqa: E501

        Creates a new export job that will copy a file from the specified shape to a remote location.  If the URI ends with a \"/\" the URI is assumed to describe a folder and the file will retain its existing filename. Otherwise it is assumed that the URI describes a file and that filename will be used.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_shape_export_job(item_id, shape_id, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str item_id: The item id. (required)
        :param str shape_id: The shape id. (required)
        :key list[str] jobmetadata: Additional information for the job task.
        :key list[str] track: Comma-separated list of item track ids.  Can include wildcards, e. g.  `A*`.  Can also contain component ids.
        :key str notification_data: Any additional data to include for notifications on this job.
        :key bool use_original_filename: If set to `true`, the file(s) will be exported with their original filename if available.
        :key str projection: Defines the projection to use when exporting the metadata.
        :key str notification: The placeholder job notification to use for this job.
        :key bool use_original_component_filename: If set to `true`, the file(s) will be exported with their original component filename if available.
        :key str start: Defines a start time code for the media.
        :key str end: Defines an end time code for the media.
        :key str priority: The priority to assign to the job.
        :key bool allow_missing: - `true` (default) - Job will be started and the missing files will be ignored.  - `false` - Job won't be started if there are missing files.
        :key str uri: A URI to the destination of the file.
        :key bool metadata: - `true` - Metadata will also be exported to side-car XML file.  - `false` (default) - No metadata is exported.
        :key str location_name: The name of an export location.
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: JobType.
                 If the method is called asynchronously, returns the request thread.
        :rtype: JobType or multiprocessing.pool.AsyncResult
        """
        kwargs['_return_http_data_only'] = True
        return self.create_shape_export_job_with_http_info(item_id, shape_id, **kwargs)  # noqa: E501

    def create_shape_export_job_with_http_info(self, item_id, shape_id, **kwargs):  # noqa: E501
        """Start an export job for a single shape  # noqa: E501

        Creates a new export job that will copy a file from the specified shape to a remote location.  If the URI ends with a \"/\" the URI is assumed to describe a folder and the file will retain its existing filename. Otherwise it is assumed that the URI describes a file and that filename will be used.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_shape_export_job_with_http_info(item_id, shape_id, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str item_id: The item id. (required)
        :param str shape_id: The shape id. (required)
        :key list[str] jobmetadata: Additional information for the job task.
        :key list[str] track: Comma-separated list of item track ids.  Can include wildcards, e. g.  `A*`.  Can also contain component ids.
        :key str notification_data: Any additional data to include for notifications on this job.
        :key bool use_original_filename: If set to `true`, the file(s) will be exported with their original filename if available.
        :key str projection: Defines the projection to use when exporting the metadata.
        :key str notification: The placeholder job notification to use for this job.
        :key bool use_original_component_filename: If set to `true`, the file(s) will be exported with their original component filename if available.
        :key str start: Defines a start time code for the media.
        :key str end: Defines an end time code for the media.
        :key str priority: The priority to assign to the job.
        :key bool allow_missing: - `true` (default) - Job will be started and the missing files will be ignored.  - `false` - Job won't be started if there are missing files.
        :key str uri: A URI to the destination of the file.
        :key bool metadata: - `true` - Metadata will also be exported to side-car XML file.  - `false` (default) - No metadata is exported.
        :key str location_name: The name of an export location.
        :key _return_http_data_only: response data without head status code
                                       and headers
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(JobType, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['item_id', 'shape_id', 'jobmetadata', 'track', 'notification_data', 'use_original_filename', 'projection', 'notification', 'use_original_component_filename', 'start', 'end', 'priority', 'allow_missing', 'uri', 'metadata', 'location_name']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_shape_export_job" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'item_id' is set
        if ('item_id' not in local_var_params or
                local_var_params['item_id'] is None):
            raise ApiValueError("Missing the required parameter `item_id` when calling `create_shape_export_job`")  # noqa: E501
        # verify the required parameter 'shape_id' is set
        if ('shape_id' not in local_var_params or
                local_var_params['shape_id'] is None):
            raise ApiValueError("Missing the required parameter `shape_id` when calling `create_shape_export_job`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'item_id' in local_var_params:
            path_params['item-id'] = local_var_params['item_id']  # noqa: E501
        if 'shape_id' in local_var_params:
            path_params['shape-id'] = local_var_params['shape_id']  # noqa: E501

        query_params = []
        if 'jobmetadata' in local_var_params:
            query_params.append(('jobmetadata', local_var_params['jobmetadata']))  # noqa: E501
            collection_formats['jobmetadata'] = 'multi'  # noqa: E501
        if 'track' in local_var_params:
            query_params.append(('track', local_var_params['track']))  # noqa: E501
            collection_formats['track'] = 'csv'  # noqa: E501
        if 'notification_data' in local_var_params:
            query_params.append(('notificationData', local_var_params['notification_data']))  # noqa: E501
        if 'use_original_filename' in local_var_params:
            query_params.append(('useOriginalFilename', local_var_params['use_original_filename']))  # noqa: E501
        if 'projection' in local_var_params:
            query_params.append(('projection', local_var_params['projection']))  # noqa: E501
        if 'notification' in local_var_params:
            query_params.append(('notification', local_var_params['notification']))  # noqa: E501
        if 'use_original_component_filename' in local_var_params:
            query_params.append(('useOriginalComponentFilename', local_var_params['use_original_component_filename']))  # noqa: E501
        if 'start' in local_var_params:
            query_params.append(('start', local_var_params['start']))  # noqa: E501
        if 'end' in local_var_params:
            query_params.append(('end', local_var_params['end']))  # noqa: E501
        if 'priority' in local_var_params:
            query_params.append(('priority', local_var_params['priority']))  # noqa: E501
        if 'allow_missing' in local_var_params:
            query_params.append(('allowMissing', local_var_params['allow_missing']))  # noqa: E501
        if 'uri' in local_var_params:
            query_params.append(('uri', local_var_params['uri']))  # noqa: E501
        if 'metadata' in local_var_params:
            query_params.append(('metadata', local_var_params['metadata']))  # noqa: E501
        if 'location_name' in local_var_params:
            query_params.append(('locationName', local_var_params['location_name']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'application/xml'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/item/{item-id}/shape/{shape-id}/export', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='JobType',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_shape_imf_export_job(self, item_id, shape_id, **kwargs):  # noqa: E501
        """Start an export job of an shape to an IMF package  # noqa: E501

        Creates a new export job that will create an IMF package as a remote location. URI must end with an \"/\" to denote a folder.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_shape_imf_export_job(item_id, shape_id, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str item_id: The item id. (required)
        :param str shape_id: The shape id. (required)
        :key list[str] jobmetadata: Additional information for the job task.
        :key list[str] track: Comma-separated list of item track ids.  Can include wildcards, e. g.  `A*`.  Can also contain component ids.
        :key str notification_data: Any additional data to include for notifications on this job.
        :key bool use_original_filename: If set to `true`, the file(s) will be exported with their original filename if available.
        :key str priority: The priority to assign to the job.
        :key str uri: A URI to the destination of the file.
        :key str notification: The placeholder job notification to use for this job.
        :key list[str] cpl_track: Comma-separated list of item track ids to include in the CPL.  Can include wildcards, e. g.  `A*`.  Can also contain component ids.  Default is the same as the track parameter.
        :key str start: Defines a start time_code for the media.
        :key str projection: Defines the projection to use when exporting the metadata.
        :key str end: Defines an end time_code for the media.
        :key bool use_original_component_filename: If set to `true`, the file(s) will be exported with their original component filename if available.
        :key bool allow_missing: - `true` (default) - Job will be started and the missing files will be ignored.  - `false` - Job won't be started if there are missing files.
        :key bool metadata: - `true` - Metadata will also be exported to side-car XML file.  - `false` (default) - No metadata is exported.
        :key str location_name: The name of an export location.
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: JobType.
                 If the method is called asynchronously, returns the request thread.
        :rtype: JobType or multiprocessing.pool.AsyncResult
        """
        kwargs['_return_http_data_only'] = True
        return self.create_shape_imf_export_job_with_http_info(item_id, shape_id, **kwargs)  # noqa: E501

    def create_shape_imf_export_job_with_http_info(self, item_id, shape_id, **kwargs):  # noqa: E501
        """Start an export job of an shape to an IMF package  # noqa: E501

        Creates a new export job that will create an IMF package as a remote location. URI must end with an \"/\" to denote a folder.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_shape_imf_export_job_with_http_info(item_id, shape_id, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str item_id: The item id. (required)
        :param str shape_id: The shape id. (required)
        :key list[str] jobmetadata: Additional information for the job task.
        :key list[str] track: Comma-separated list of item track ids.  Can include wildcards, e. g.  `A*`.  Can also contain component ids.
        :key str notification_data: Any additional data to include for notifications on this job.
        :key bool use_original_filename: If set to `true`, the file(s) will be exported with their original filename if available.
        :key str priority: The priority to assign to the job.
        :key str uri: A URI to the destination of the file.
        :key str notification: The placeholder job notification to use for this job.
        :key list[str] cpl_track: Comma-separated list of item track ids to include in the CPL.  Can include wildcards, e. g.  `A*`.  Can also contain component ids.  Default is the same as the track parameter.
        :key str start: Defines a start time_code for the media.
        :key str projection: Defines the projection to use when exporting the metadata.
        :key str end: Defines an end time_code for the media.
        :key bool use_original_component_filename: If set to `true`, the file(s) will be exported with their original component filename if available.
        :key bool allow_missing: - `true` (default) - Job will be started and the missing files will be ignored.  - `false` - Job won't be started if there are missing files.
        :key bool metadata: - `true` - Metadata will also be exported to side-car XML file.  - `false` (default) - No metadata is exported.
        :key str location_name: The name of an export location.
        :key _return_http_data_only: response data without head status code
                                       and headers
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(JobType, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['item_id', 'shape_id', 'jobmetadata', 'track', 'notification_data', 'use_original_filename', 'priority', 'uri', 'notification', 'cpl_track', 'start', 'projection', 'end', 'use_original_component_filename', 'allow_missing', 'metadata', 'location_name']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_shape_imf_export_job" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'item_id' is set
        if ('item_id' not in local_var_params or
                local_var_params['item_id'] is None):
            raise ApiValueError("Missing the required parameter `item_id` when calling `create_shape_imf_export_job`")  # noqa: E501
        # verify the required parameter 'shape_id' is set
        if ('shape_id' not in local_var_params or
                local_var_params['shape_id'] is None):
            raise ApiValueError("Missing the required parameter `shape_id` when calling `create_shape_imf_export_job`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'item_id' in local_var_params:
            path_params['item-id'] = local_var_params['item_id']  # noqa: E501
        if 'shape_id' in local_var_params:
            path_params['shape-id'] = local_var_params['shape_id']  # noqa: E501

        query_params = []
        if 'jobmetadata' in local_var_params:
            query_params.append(('jobmetadata', local_var_params['jobmetadata']))  # noqa: E501
            collection_formats['jobmetadata'] = 'multi'  # noqa: E501
        if 'track' in local_var_params:
            query_params.append(('track', local_var_params['track']))  # noqa: E501
            collection_formats['track'] = 'csv'  # noqa: E501
        if 'notification_data' in local_var_params:
            query_params.append(('notificationData', local_var_params['notification_data']))  # noqa: E501
        if 'use_original_filename' in local_var_params:
            query_params.append(('useOriginalFilename', local_var_params['use_original_filename']))  # noqa: E501
        if 'priority' in local_var_params:
            query_params.append(('priority', local_var_params['priority']))  # noqa: E501
        if 'uri' in local_var_params:
            query_params.append(('uri', local_var_params['uri']))  # noqa: E501
        if 'notification' in local_var_params:
            query_params.append(('notification', local_var_params['notification']))  # noqa: E501
        if 'cpl_track' in local_var_params:
            query_params.append(('cplTrack', local_var_params['cpl_track']))  # noqa: E501
            collection_formats['cplTrack'] = 'csv'  # noqa: E501
        if 'start' in local_var_params:
            query_params.append(('start', local_var_params['start']))  # noqa: E501
        if 'projection' in local_var_params:
            query_params.append(('projection', local_var_params['projection']))  # noqa: E501
        if 'end' in local_var_params:
            query_params.append(('end', local_var_params['end']))  # noqa: E501
        if 'use_original_component_filename' in local_var_params:
            query_params.append(('useOriginalComponentFilename', local_var_params['use_original_component_filename']))  # noqa: E501
        if 'allow_missing' in local_var_params:
            query_params.append(('allowMissing', local_var_params['allow_missing']))  # noqa: E501
        if 'metadata' in local_var_params:
            query_params.append(('metadata', local_var_params['metadata']))  # noqa: E501
        if 'location_name' in local_var_params:
            query_params.append(('locationName', local_var_params['location_name']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'application/xml'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/item/{item-id}/shape/{shape-id}/export/imp', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='JobType',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_shape_placeholder(self, id, simple_metadata_type, **kwargs):  # noqa: E501
        """Create a placeholder shape  # noqa: E501

        Creates an new placeholder shape for a specific item.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_shape_placeholder(id, simple_metadata_type, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str id: The id. (required)
        :param SimpleMetadataType simple_metadata_type: (required)
        :key int binary: The number of binary components
        :key int audio: The number of audio components
        :key str tag: Comma-separated shape tags to be added to the shape.
        :key int container: The number of container components
        :key int video: The number of video components
        :key str frame_duration: duration for each image in the sequence.
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: str.
                 If the method is called asynchronously, returns the request thread.
        :rtype: str or multiprocessing.pool.AsyncResult
        """
        kwargs['_return_http_data_only'] = True
        return self.create_shape_placeholder_with_http_info(id, simple_metadata_type, **kwargs)  # noqa: E501

    def create_shape_placeholder_with_http_info(self, id, simple_metadata_type, **kwargs):  # noqa: E501
        """Create a placeholder shape  # noqa: E501

        Creates an new placeholder shape for a specific item.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_shape_placeholder_with_http_info(id, simple_metadata_type, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str id: The id. (required)
        :param SimpleMetadataType simple_metadata_type: (required)
        :key int binary: The number of binary components
        :key int audio: The number of audio components
        :key str tag: Comma-separated shape tags to be added to the shape.
        :key int container: The number of container components
        :key int video: The number of video components
        :key str frame_duration: duration for each image in the sequence.
        :key _return_http_data_only: response data without head status code
                                       and headers
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(str, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['id', 'simple_metadata_type', 'binary', 'audio', 'tag', 'container', 'video', 'frame_duration']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_shape_placeholder" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in local_var_params or
                local_var_params['id'] is None):
            raise ApiValueError("Missing the required parameter `id` when calling `create_shape_placeholder`")  # noqa: E501
        # verify the required parameter 'simple_metadata_type' is set
        if ('simple_metadata_type' not in local_var_params or
                local_var_params['simple_metadata_type'] is None):
            raise ApiValueError("Missing the required parameter `simple_metadata_type` when calling `create_shape_placeholder`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []
        if 'binary' in local_var_params:
            query_params.append(('binary', local_var_params['binary']))  # noqa: E501
        if 'audio' in local_var_params:
            query_params.append(('audio', local_var_params['audio']))  # noqa: E501
        if 'tag' in local_var_params:
            query_params.append(('tag', local_var_params['tag']))  # noqa: E501
        if 'container' in local_var_params:
            query_params.append(('container', local_var_params['container']))  # noqa: E501
        if 'video' in local_var_params:
            query_params.append(('video', local_var_params['video']))  # noqa: E501
        if 'frame_duration' in local_var_params:
            query_params.append(('frameDuration', local_var_params['frame_duration']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'simple_metadata_type' in local_var_params:
            body_params = local_var_params['simple_metadata_type']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'application/xml'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/item/{id}/shape/placeholder', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='str',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_shape_thumbnail_job(self, item_id, shape_id, **kwargs):  # noqa: E501
        """Start a thumbnail job  # noqa: E501

        Creates a new thumbnail job with the specified parameters. Note that a job cannot both create thumbnails at specified intervals and posters. Creating thumbnails according to transcoder rules and creating posters is however allowed.  Changed in version 5.0: For multi-layer PSD/PSB files, only a thumbnail of all layers flattened will be generated by default.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_shape_thumbnail_job(item_id, shape_id, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str item_id: The item id. (required)
        :param str shape_id: The shape id. (required)
        :key int thumbnail_width: The width of the thumbnails.  If `thumbnailWidth` is specified, `thumbnailHeight` must also be specified.
        :key list[str] jobmetadata: Additional information for the job task.
        :key str notification_data: Any additional data to include for notifications on this job.
        :key str thumbnail_service: Identifies which thumbnail resource that should be used.
        :key str tag: Include additional video settings from this transcode preset.  Resolution settings in the tag are overridden by query parameters `thumbnailHeight` and `thumbnailWidth`.
        :key str poster_format: - `jpeg` (default) - Creates posters in JPEG format.  - `png` - Creates posters in PNG format.
        :key str notification: The placeholder job notification to use for this job.
        :key int poster_width: The width of the posters.
        :key str priority: The priority to assign to the job.
        :key bool create_thumbnails: - `true` - Creates thumbnails according to default transcoder rules.  - *t1*, . . .  - Thumbnails will be created on the specified, comma-separated, time codes.  - `false` (default) - No thumbnails will be created.
        :key int thumbnail_height: The height of the thumbnails.  If `thumbnailHeight` is specified, `thumbnailWidth` must also be specified.
        :key str create_posters: A list of time codes to use for creating posters.
        :key int poster_height: The height of the posters.
        :key str thumbnail_period: Timecode string specifying the interval of the thumbnails.  It should be a decimal integer when working with multi-page images/PDFs, meaning every N page(s).
        :key str resource_id: The transcoder resource to use to execute the transcode.
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: JobType.
                 If the method is called asynchronously, returns the request thread.
        :rtype: JobType or multiprocessing.pool.AsyncResult
        """
        kwargs['_return_http_data_only'] = True
        return self.create_shape_thumbnail_job_with_http_info(item_id, shape_id, **kwargs)  # noqa: E501

    def create_shape_thumbnail_job_with_http_info(self, item_id, shape_id, **kwargs):  # noqa: E501
        """Start a thumbnail job  # noqa: E501

        Creates a new thumbnail job with the specified parameters. Note that a job cannot both create thumbnails at specified intervals and posters. Creating thumbnails according to transcoder rules and creating posters is however allowed.  Changed in version 5.0: For multi-layer PSD/PSB files, only a thumbnail of all layers flattened will be generated by default.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_shape_thumbnail_job_with_http_info(item_id, shape_id, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str item_id: The item id. (required)
        :param str shape_id: The shape id. (required)
        :key int thumbnail_width: The width of the thumbnails.  If `thumbnailWidth` is specified, `thumbnailHeight` must also be specified.
        :key list[str] jobmetadata: Additional information for the job task.
        :key str notification_data: Any additional data to include for notifications on this job.
        :key str thumbnail_service: Identifies which thumbnail resource that should be used.
        :key str tag: Include additional video settings from this transcode preset.  Resolution settings in the tag are overridden by query parameters `thumbnailHeight` and `thumbnailWidth`.
        :key str poster_format: - `jpeg` (default) - Creates posters in JPEG format.  - `png` - Creates posters in PNG format.
        :key str notification: The placeholder job notification to use for this job.
        :key int poster_width: The width of the posters.
        :key str priority: The priority to assign to the job.
        :key bool create_thumbnails: - `true` - Creates thumbnails according to default transcoder rules.  - *t1*, . . .  - Thumbnails will be created on the specified, comma-separated, time codes.  - `false` (default) - No thumbnails will be created.
        :key int thumbnail_height: The height of the thumbnails.  If `thumbnailHeight` is specified, `thumbnailWidth` must also be specified.
        :key str create_posters: A list of time codes to use for creating posters.
        :key int poster_height: The height of the posters.
        :key str thumbnail_period: Timecode string specifying the interval of the thumbnails.  It should be a decimal integer when working with multi-page images/PDFs, meaning every N page(s).
        :key str resource_id: The transcoder resource to use to execute the transcode.
        :key _return_http_data_only: response data without head status code
                                       and headers
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(JobType, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['item_id', 'shape_id', 'thumbnail_width', 'jobmetadata', 'notification_data', 'thumbnail_service', 'tag', 'poster_format', 'notification', 'poster_width', 'priority', 'create_thumbnails', 'thumbnail_height', 'create_posters', 'poster_height', 'thumbnail_period', 'resource_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_shape_thumbnail_job" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'item_id' is set
        if ('item_id' not in local_var_params or
                local_var_params['item_id'] is None):
            raise ApiValueError("Missing the required parameter `item_id` when calling `create_shape_thumbnail_job`")  # noqa: E501
        # verify the required parameter 'shape_id' is set
        if ('shape_id' not in local_var_params or
                local_var_params['shape_id'] is None):
            raise ApiValueError("Missing the required parameter `shape_id` when calling `create_shape_thumbnail_job`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'item_id' in local_var_params:
            path_params['item-id'] = local_var_params['item_id']  # noqa: E501
        if 'shape_id' in local_var_params:
            path_params['shape-id'] = local_var_params['shape_id']  # noqa: E501

        query_params = []
        if 'thumbnail_width' in local_var_params:
            query_params.append(('thumbnailWidth', local_var_params['thumbnail_width']))  # noqa: E501
        if 'jobmetadata' in local_var_params:
            query_params.append(('jobmetadata', local_var_params['jobmetadata']))  # noqa: E501
            collection_formats['jobmetadata'] = 'multi'  # noqa: E501
        if 'notification_data' in local_var_params:
            query_params.append(('notificationData', local_var_params['notification_data']))  # noqa: E501
        if 'thumbnail_service' in local_var_params:
            query_params.append(('thumbnailService', local_var_params['thumbnail_service']))  # noqa: E501
        if 'tag' in local_var_params:
            query_params.append(('tag', local_var_params['tag']))  # noqa: E501
        if 'poster_format' in local_var_params:
            query_params.append(('posterFormat', local_var_params['poster_format']))  # noqa: E501
        if 'notification' in local_var_params:
            query_params.append(('notification', local_var_params['notification']))  # noqa: E501
        if 'poster_width' in local_var_params:
            query_params.append(('posterWidth', local_var_params['poster_width']))  # noqa: E501
        if 'priority' in local_var_params:
            query_params.append(('priority', local_var_params['priority']))  # noqa: E501
        if 'create_thumbnails' in local_var_params:
            query_params.append(('createThumbnails', local_var_params['create_thumbnails']))  # noqa: E501
        if 'thumbnail_height' in local_var_params:
            query_params.append(('thumbnailHeight', local_var_params['thumbnail_height']))  # noqa: E501
        if 'create_posters' in local_var_params:
            query_params.append(('createPosters', local_var_params['create_posters']))  # noqa: E501
        if 'poster_height' in local_var_params:
            query_params.append(('posterHeight', local_var_params['poster_height']))  # noqa: E501
        if 'thumbnail_period' in local_var_params:
            query_params.append(('thumbnailPeriod', local_var_params['thumbnail_period']))  # noqa: E501
        if 'resource_id' in local_var_params:
            query_params.append(('resourceId', local_var_params['resource_id']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'application/xml'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/item/{item-id}/shape/{shape-id}/thumbnail', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='JobType',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_shape_transcode_job(self, item_id, shape_id, **kwargs):  # noqa: E501
        """Transcode a specific shape  # noqa: E501

        Starts a new job that transcode a specific shape on an item to a number of shapes according to the given shape tags.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_shape_transcode_job(item_id, shape_id, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str item_id: The item id. (required)
        :param str shape_id: The shape id. (required)
        :key list[str] jobmetadata: Additional information for the job task.
        :key str notification_data: Any additional data to include for notifications on this job.
        :key str thumbnail_service: Identifies which thumbnail resource that should be used.
        :key list[str] tag: Comma-separated list of shape tags, that specify the desired output.
        :key str storage_id: Identifier of storage where essence file is to be stored.  New in version 4. 16.
        :key bool require_fast_start: - `true` (default) - Try to put the index tables (header) in front of the file.  - `false` - Put header at end of file.
        :key str notification: The placeholder job notification to use for this job.
        :key str fast_start_length: Estimated duration of the clip in seconds.
        :key bool create_thumbnails: - `true` - Creates thumbnails according to default transcoder rules.  - `false` (default) - No thumbnails will be created.
        :key str destination_item: An item id, to which the new new shape will be associated.
        :key str create_posters: A list of time codes to use for creating posters.
        :key bool override_fast_start: - `true` (default) - Use transcoder's estimate of the duration for allocating header space in MOV files and similar files.  - `false` - Do not use the transcoder's estimate of the duration.
        :key str resource_id: The transcoder resource to use to execute the transcode.
        :key str priority: The priority to assign to the job.
        :key str original: If specified, should be one of the tags specified in the tag parameter.  Specifies that the original shape tag will be reset to the shape created to this tag.
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: JobType.
                 If the method is called asynchronously, returns the request thread.
        :rtype: JobType or multiprocessing.pool.AsyncResult
        """
        kwargs['_return_http_data_only'] = True
        return self.create_shape_transcode_job_with_http_info(item_id, shape_id, **kwargs)  # noqa: E501

    def create_shape_transcode_job_with_http_info(self, item_id, shape_id, **kwargs):  # noqa: E501
        """Transcode a specific shape  # noqa: E501

        Starts a new job that transcode a specific shape on an item to a number of shapes according to the given shape tags.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_shape_transcode_job_with_http_info(item_id, shape_id, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str item_id: The item id. (required)
        :param str shape_id: The shape id. (required)
        :key list[str] jobmetadata: Additional information for the job task.
        :key str notification_data: Any additional data to include for notifications on this job.
        :key str thumbnail_service: Identifies which thumbnail resource that should be used.
        :key list[str] tag: Comma-separated list of shape tags, that specify the desired output.
        :key str storage_id: Identifier of storage where essence file is to be stored.  New in version 4. 16.
        :key bool require_fast_start: - `true` (default) - Try to put the index tables (header) in front of the file.  - `false` - Put header at end of file.
        :key str notification: The placeholder job notification to use for this job.
        :key str fast_start_length: Estimated duration of the clip in seconds.
        :key bool create_thumbnails: - `true` - Creates thumbnails according to default transcoder rules.  - `false` (default) - No thumbnails will be created.
        :key str destination_item: An item id, to which the new new shape will be associated.
        :key str create_posters: A list of time codes to use for creating posters.
        :key bool override_fast_start: - `true` (default) - Use transcoder's estimate of the duration for allocating header space in MOV files and similar files.  - `false` - Do not use the transcoder's estimate of the duration.
        :key str resource_id: The transcoder resource to use to execute the transcode.
        :key str priority: The priority to assign to the job.
        :key str original: If specified, should be one of the tags specified in the tag parameter.  Specifies that the original shape tag will be reset to the shape created to this tag.
        :key _return_http_data_only: response data without head status code
                                       and headers
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(JobType, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['item_id', 'shape_id', 'jobmetadata', 'notification_data', 'thumbnail_service', 'tag', 'storage_id', 'require_fast_start', 'notification', 'fast_start_length', 'create_thumbnails', 'destination_item', 'create_posters', 'override_fast_start', 'resource_id', 'priority', 'original']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_shape_transcode_job" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'item_id' is set
        if ('item_id' not in local_var_params or
                local_var_params['item_id'] is None):
            raise ApiValueError("Missing the required parameter `item_id` when calling `create_shape_transcode_job`")  # noqa: E501
        # verify the required parameter 'shape_id' is set
        if ('shape_id' not in local_var_params or
                local_var_params['shape_id'] is None):
            raise ApiValueError("Missing the required parameter `shape_id` when calling `create_shape_transcode_job`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'item_id' in local_var_params:
            path_params['item-id'] = local_var_params['item_id']  # noqa: E501
        if 'shape_id' in local_var_params:
            path_params['shape-id'] = local_var_params['shape_id']  # noqa: E501

        query_params = []
        if 'jobmetadata' in local_var_params:
            query_params.append(('jobmetadata', local_var_params['jobmetadata']))  # noqa: E501
            collection_formats['jobmetadata'] = 'multi'  # noqa: E501
        if 'notification_data' in local_var_params:
            query_params.append(('notificationData', local_var_params['notification_data']))  # noqa: E501
        if 'thumbnail_service' in local_var_params:
            query_params.append(('thumbnailService', local_var_params['thumbnail_service']))  # noqa: E501
        if 'tag' in local_var_params:
            query_params.append(('tag', local_var_params['tag']))  # noqa: E501
            collection_formats['tag'] = 'csv'  # noqa: E501
        if 'storage_id' in local_var_params:
            query_params.append(('storageId', local_var_params['storage_id']))  # noqa: E501
        if 'require_fast_start' in local_var_params:
            query_params.append(('requireFastStart', local_var_params['require_fast_start']))  # noqa: E501
        if 'notification' in local_var_params:
            query_params.append(('notification', local_var_params['notification']))  # noqa: E501
        if 'fast_start_length' in local_var_params:
            query_params.append(('fastStartLength', local_var_params['fast_start_length']))  # noqa: E501
        if 'create_thumbnails' in local_var_params:
            query_params.append(('createThumbnails', local_var_params['create_thumbnails']))  # noqa: E501
        if 'destination_item' in local_var_params:
            query_params.append(('destinationItem', local_var_params['destination_item']))  # noqa: E501
        if 'create_posters' in local_var_params:
            query_params.append(('createPosters', local_var_params['create_posters']))  # noqa: E501
        if 'override_fast_start' in local_var_params:
            query_params.append(('overrideFastStart', local_var_params['override_fast_start']))  # noqa: E501
        if 'resource_id' in local_var_params:
            query_params.append(('resourceId', local_var_params['resource_id']))  # noqa: E501
        if 'priority' in local_var_params:
            query_params.append(('priority', local_var_params['priority']))  # noqa: E501
        if 'original' in local_var_params:
            query_params.append(('original', local_var_params['original']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'application/xml'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/item/{item-id}/shape/{shape-id}/transcode', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='JobType',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_component(self, id, shape_id, component_id, **kwargs):  # noqa: E501
        """Delete a component  # noqa: E501

        Removes the component from the shape. Any files belonging to the component is not Copy this component to another shape, replacing a specific component by id.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_component(id, shape_id, component_id, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str id: The id. (required)
        :param str shape_id: The shape id. (required)
        :param str component_id: The component id. (required)
        :key bool keep_files: - `true` - Keep the files belong to this shape.  - `false` (default) - Remove the files belong to this shape.
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None.
                 If the method is called asynchronously, returns the request thread.
        :rtype: None or multiprocessing.pool.AsyncResult
        """
        kwargs['_return_http_data_only'] = True
        return self.delete_component_with_http_info(id, shape_id, component_id, **kwargs)  # noqa: E501

    def delete_component_with_http_info(self, id, shape_id, component_id, **kwargs):  # noqa: E501
        """Delete a component  # noqa: E501

        Removes the component from the shape. Any files belonging to the component is not Copy this component to another shape, replacing a specific component by id.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_component_with_http_info(id, shape_id, component_id, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str id: The id. (required)
        :param str shape_id: The shape id. (required)
        :param str component_id: The component id. (required)
        :key bool keep_files: - `true` - Keep the files belong to this shape.  - `false` (default) - Remove the files belong to this shape.
        :key _return_http_data_only: response data without head status code
                                       and headers
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['id', 'shape_id', 'component_id', 'keep_files']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_component" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in local_var_params or
                local_var_params['id'] is None):
            raise ApiValueError("Missing the required parameter `id` when calling `delete_component`")  # noqa: E501
        # verify the required parameter 'shape_id' is set
        if ('shape_id' not in local_var_params or
                local_var_params['shape_id'] is None):
            raise ApiValueError("Missing the required parameter `shape_id` when calling `delete_component`")  # noqa: E501
        # verify the required parameter 'component_id' is set
        if ('component_id' not in local_var_params or
                local_var_params['component_id'] is None):
            raise ApiValueError("Missing the required parameter `component_id` when calling `delete_component`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501
        if 'shape_id' in local_var_params:
            path_params['shape-id'] = local_var_params['shape_id']  # noqa: E501
        if 'component_id' in local_var_params:
            path_params['component-id'] = local_var_params['component_id']  # noqa: E501

        query_params = []
        if 'keep_files' in local_var_params:
            query_params.append(('keepFiles', local_var_params['keep_files']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/item/{id}/shape/{shape-id}/component/{component-id}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_component_metadata(self, item_id, shape_id, component_id, **kwargs):  # noqa: E501
        """Delete all key-value pairs  # noqa: E501

        Clears all key-value pairs for the specified entity.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_component_metadata(item_id, shape_id, component_id, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str item_id: The item id. (required)
        :param str shape_id: The shape id. (required)
        :param str component_id: The component id. (required)
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None.
                 If the method is called asynchronously, returns the request thread.
        :rtype: None or multiprocessing.pool.AsyncResult
        """
        kwargs['_return_http_data_only'] = True
        return self.delete_component_metadata_with_http_info(item_id, shape_id, component_id, **kwargs)  # noqa: E501

    def delete_component_metadata_with_http_info(self, item_id, shape_id, component_id, **kwargs):  # noqa: E501
        """Delete all key-value pairs  # noqa: E501

        Clears all key-value pairs for the specified entity.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_component_metadata_with_http_info(item_id, shape_id, component_id, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str item_id: The item id. (required)
        :param str shape_id: The shape id. (required)
        :param str component_id: The component id. (required)
        :key _return_http_data_only: response data without head status code
                                       and headers
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['item_id', 'shape_id', 'component_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_component_metadata" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'item_id' is set
        if ('item_id' not in local_var_params or
                local_var_params['item_id'] is None):
            raise ApiValueError("Missing the required parameter `item_id` when calling `delete_component_metadata`")  # noqa: E501
        # verify the required parameter 'shape_id' is set
        if ('shape_id' not in local_var_params or
                local_var_params['shape_id'] is None):
            raise ApiValueError("Missing the required parameter `shape_id` when calling `delete_component_metadata`")  # noqa: E501
        # verify the required parameter 'component_id' is set
        if ('component_id' not in local_var_params or
                local_var_params['component_id'] is None):
            raise ApiValueError("Missing the required parameter `component_id` when calling `delete_component_metadata`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'item_id' in local_var_params:
            path_params['item-id'] = local_var_params['item_id']  # noqa: E501
        if 'shape_id' in local_var_params:
            path_params['shape-id'] = local_var_params['shape_id']  # noqa: E501
        if 'component_id' in local_var_params:
            path_params['component-id'] = local_var_params['component_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/item/{item-id}/shape/{shape-id}/component/{component-id}/metadata', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_component_metadata_key(self, item_id, shape_id, component_id, keypath, **kwargs):  # noqa: E501
        """Delete key-value pairs  # noqa: E501

        Deletes the key-value pair with the specified key. If a key path is given, it may include wildcards for deleting multiple keys.  Key paths can also be specified as well as specific keys.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_component_metadata_key(item_id, shape_id, component_id, keypath, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str item_id: The item id. (required)
        :param str shape_id: The shape id. (required)
        :param str component_id: The component id. (required)
        :param str keypath: The keypath. (required)
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None.
                 If the method is called asynchronously, returns the request thread.
        :rtype: None or multiprocessing.pool.AsyncResult
        """
        kwargs['_return_http_data_only'] = True
        return self.delete_component_metadata_key_with_http_info(item_id, shape_id, component_id, keypath, **kwargs)  # noqa: E501

    def delete_component_metadata_key_with_http_info(self, item_id, shape_id, component_id, keypath, **kwargs):  # noqa: E501
        """Delete key-value pairs  # noqa: E501

        Deletes the key-value pair with the specified key. If a key path is given, it may include wildcards for deleting multiple keys.  Key paths can also be specified as well as specific keys.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_component_metadata_key_with_http_info(item_id, shape_id, component_id, keypath, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str item_id: The item id. (required)
        :param str shape_id: The shape id. (required)
        :param str component_id: The component id. (required)
        :param str keypath: The keypath. (required)
        :key _return_http_data_only: response data without head status code
                                       and headers
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['item_id', 'shape_id', 'component_id', 'keypath']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_component_metadata_key" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'item_id' is set
        if ('item_id' not in local_var_params or
                local_var_params['item_id'] is None):
            raise ApiValueError("Missing the required parameter `item_id` when calling `delete_component_metadata_key`")  # noqa: E501
        # verify the required parameter 'shape_id' is set
        if ('shape_id' not in local_var_params or
                local_var_params['shape_id'] is None):
            raise ApiValueError("Missing the required parameter `shape_id` when calling `delete_component_metadata_key`")  # noqa: E501
        # verify the required parameter 'component_id' is set
        if ('component_id' not in local_var_params or
                local_var_params['component_id'] is None):
            raise ApiValueError("Missing the required parameter `component_id` when calling `delete_component_metadata_key`")  # noqa: E501
        # verify the required parameter 'keypath' is set
        if ('keypath' not in local_var_params or
                local_var_params['keypath'] is None):
            raise ApiValueError("Missing the required parameter `keypath` when calling `delete_component_metadata_key`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'item_id' in local_var_params:
            path_params['item-id'] = local_var_params['item_id']  # noqa: E501
        if 'shape_id' in local_var_params:
            path_params['shape-id'] = local_var_params['shape_id']  # noqa: E501
        if 'component_id' in local_var_params:
            path_params['component-id'] = local_var_params['component_id']  # noqa: E501
        if 'keypath' in local_var_params:
            path_params['keypath'] = local_var_params['keypath']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/item/{item-id}/shape/{shape-id}/component/{component-id}/metadata/{keypath}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_shape(self, id, shape_id, **kwargs):  # noqa: E501
        """Delete a shape  # noqa: E501

        Removes the specified shape. This will remove all components and and mark files for deletion, unless files are used in other shapes.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_shape(id, shape_id, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str id: The id. (required)
        :param str shape_id: The shape id. (required)
        :key bool keep_files: - `true` - Keep the files belong to this shape.  - `false` (default) - Remove the files belong to this shape.
        :key bool url: - `true` - Instead of shape ids, return the full paths of the shapes in the response document.  - `false` (default) - Only return the ids of the remaining shapes.
        :key bool update_metadata: - `true` - Remove the item metadata that is generate from this shape - `false` (default) - Keep the item metadata that is generate from this shape
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: URIListType.
                 If the method is called asynchronously, returns the request thread.
        :rtype: URIListType or multiprocessing.pool.AsyncResult
        """
        kwargs['_return_http_data_only'] = True
        return self.delete_shape_with_http_info(id, shape_id, **kwargs)  # noqa: E501

    def delete_shape_with_http_info(self, id, shape_id, **kwargs):  # noqa: E501
        """Delete a shape  # noqa: E501

        Removes the specified shape. This will remove all components and and mark files for deletion, unless files are used in other shapes.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_shape_with_http_info(id, shape_id, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str id: The id. (required)
        :param str shape_id: The shape id. (required)
        :key bool keep_files: - `true` - Keep the files belong to this shape.  - `false` (default) - Remove the files belong to this shape.
        :key bool url: - `true` - Instead of shape ids, return the full paths of the shapes in the response document.  - `false` (default) - Only return the ids of the remaining shapes.
        :key bool update_metadata: - `true` - Remove the item metadata that is generate from this shape - `false` (default) - Keep the item metadata that is generate from this shape
        :key _return_http_data_only: response data without head status code
                                       and headers
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(URIListType, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['id', 'shape_id', 'keep_files', 'url', 'update_metadata']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_shape" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in local_var_params or
                local_var_params['id'] is None):
            raise ApiValueError("Missing the required parameter `id` when calling `delete_shape`")  # noqa: E501
        # verify the required parameter 'shape_id' is set
        if ('shape_id' not in local_var_params or
                local_var_params['shape_id'] is None):
            raise ApiValueError("Missing the required parameter `shape_id` when calling `delete_shape`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501
        if 'shape_id' in local_var_params:
            path_params['shape-id'] = local_var_params['shape_id']  # noqa: E501

        query_params = []
        if 'keep_files' in local_var_params:
            query_params.append(('keepFiles', local_var_params['keep_files']))  # noqa: E501
        if 'url' in local_var_params:
            query_params.append(('url', local_var_params['url']))  # noqa: E501
        if 'update_metadata' in local_var_params:
            query_params.append(('updateMetadata', local_var_params['update_metadata']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'text/plain', 'application/xml'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/item/{id}/shape/{shape-id}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='URIListType',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_shape_essence_version(self, id, version, **kwargs):  # noqa: E501
        """Delete an essence version  # noqa: E501

        Deletes all shapes associated with the specified version. Thumbnails connected to the version will also be deleted.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_shape_essence_version(id, version, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str id: The id. (required)
        :param str version: The version. (required)
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None.
                 If the method is called asynchronously, returns the request thread.
        :rtype: None or multiprocessing.pool.AsyncResult
        """
        kwargs['_return_http_data_only'] = True
        return self.delete_shape_essence_version_with_http_info(id, version, **kwargs)  # noqa: E501

    def delete_shape_essence_version_with_http_info(self, id, version, **kwargs):  # noqa: E501
        """Delete an essence version  # noqa: E501

        Deletes all shapes associated with the specified version. Thumbnails connected to the version will also be deleted.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_shape_essence_version_with_http_info(id, version, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str id: The id. (required)
        :param str version: The version. (required)
        :key _return_http_data_only: response data without head status code
                                       and headers
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['id', 'version']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_shape_essence_version" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in local_var_params or
                local_var_params['id'] is None):
            raise ApiValueError("Missing the required parameter `id` when calling `delete_shape_essence_version`")  # noqa: E501
        # verify the required parameter 'version' is set
        if ('version' not in local_var_params or
                local_var_params['version'] is None):
            raise ApiValueError("Missing the required parameter `version` when calling `delete_shape_essence_version`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501
        if 'version' in local_var_params:
            path_params['version'] = local_var_params['version']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/item/{id}/shape/version/{version}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_shape_metadata(self, item_id, shape_id, **kwargs):  # noqa: E501
        """Delete all key-value pairs  # noqa: E501

        Clears all key-value pairs for the specified entity.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_shape_metadata(item_id, shape_id, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str item_id: The item id. (required)
        :param str shape_id: The shape id. (required)
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None.
                 If the method is called asynchronously, returns the request thread.
        :rtype: None or multiprocessing.pool.AsyncResult
        """
        kwargs['_return_http_data_only'] = True
        return self.delete_shape_metadata_with_http_info(item_id, shape_id, **kwargs)  # noqa: E501

    def delete_shape_metadata_with_http_info(self, item_id, shape_id, **kwargs):  # noqa: E501
        """Delete all key-value pairs  # noqa: E501

        Clears all key-value pairs for the specified entity.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_shape_metadata_with_http_info(item_id, shape_id, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str item_id: The item id. (required)
        :param str shape_id: The shape id. (required)
        :key _return_http_data_only: response data without head status code
                                       and headers
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['item_id', 'shape_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_shape_metadata" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'item_id' is set
        if ('item_id' not in local_var_params or
                local_var_params['item_id'] is None):
            raise ApiValueError("Missing the required parameter `item_id` when calling `delete_shape_metadata`")  # noqa: E501
        # verify the required parameter 'shape_id' is set
        if ('shape_id' not in local_var_params or
                local_var_params['shape_id'] is None):
            raise ApiValueError("Missing the required parameter `shape_id` when calling `delete_shape_metadata`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'item_id' in local_var_params:
            path_params['item-id'] = local_var_params['item_id']  # noqa: E501
        if 'shape_id' in local_var_params:
            path_params['shape-id'] = local_var_params['shape_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/item/{item-id}/shape/{shape-id}/metadata', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_shape_metadata_key(self, item_id, shape_id, keypath, **kwargs):  # noqa: E501
        """Delete key-value pairs  # noqa: E501

        Deletes the key-value pair with the specified key. If a key path is given, it may include wildcards for deleting multiple keys.  Key paths can also be specified as well as specific keys.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_shape_metadata_key(item_id, shape_id, keypath, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str item_id: The item id. (required)
        :param str shape_id: The shape id. (required)
        :param str keypath: The keypath. (required)
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None.
                 If the method is called asynchronously, returns the request thread.
        :rtype: None or multiprocessing.pool.AsyncResult
        """
        kwargs['_return_http_data_only'] = True
        return self.delete_shape_metadata_key_with_http_info(item_id, shape_id, keypath, **kwargs)  # noqa: E501

    def delete_shape_metadata_key_with_http_info(self, item_id, shape_id, keypath, **kwargs):  # noqa: E501
        """Delete key-value pairs  # noqa: E501

        Deletes the key-value pair with the specified key. If a key path is given, it may include wildcards for deleting multiple keys.  Key paths can also be specified as well as specific keys.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_shape_metadata_key_with_http_info(item_id, shape_id, keypath, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str item_id: The item id. (required)
        :param str shape_id: The shape id. (required)
        :param str keypath: The keypath. (required)
        :key _return_http_data_only: response data without head status code
                                       and headers
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['item_id', 'shape_id', 'keypath']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_shape_metadata_key" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'item_id' is set
        if ('item_id' not in local_var_params or
                local_var_params['item_id'] is None):
            raise ApiValueError("Missing the required parameter `item_id` when calling `delete_shape_metadata_key`")  # noqa: E501
        # verify the required parameter 'shape_id' is set
        if ('shape_id' not in local_var_params or
                local_var_params['shape_id'] is None):
            raise ApiValueError("Missing the required parameter `shape_id` when calling `delete_shape_metadata_key`")  # noqa: E501
        # verify the required parameter 'keypath' is set
        if ('keypath' not in local_var_params or
                local_var_params['keypath'] is None):
            raise ApiValueError("Missing the required parameter `keypath` when calling `delete_shape_metadata_key`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'item_id' in local_var_params:
            path_params['item-id'] = local_var_params['item_id']  # noqa: E501
        if 'shape_id' in local_var_params:
            path_params['shape-id'] = local_var_params['shape_id']  # noqa: E501
        if 'keypath' in local_var_params:
            path_params['keypath'] = local_var_params['keypath']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/item/{item-id}/shape/{shape-id}/metadata/{keypath}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_shape_mime_type(self, id, shape_id, mime_type, **kwargs):  # noqa: E501
        """Remove a mime type from a shape  # noqa: E501

        Removes a mime type from the shape.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_shape_mime_type(id, shape_id, mime_type, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str id: The id. (required)
        :param str shape_id: The shape id. (required)
        :param str mime_type: The mime type. (required)
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None.
                 If the method is called asynchronously, returns the request thread.
        :rtype: None or multiprocessing.pool.AsyncResult
        """
        kwargs['_return_http_data_only'] = True
        return self.delete_shape_mime_type_with_http_info(id, shape_id, mime_type, **kwargs)  # noqa: E501

    def delete_shape_mime_type_with_http_info(self, id, shape_id, mime_type, **kwargs):  # noqa: E501
        """Remove a mime type from a shape  # noqa: E501

        Removes a mime type from the shape.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_shape_mime_type_with_http_info(id, shape_id, mime_type, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str id: The id. (required)
        :param str shape_id: The shape id. (required)
        :param str mime_type: The mime type. (required)
        :key _return_http_data_only: response data without head status code
                                       and headers
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['id', 'shape_id', 'mime_type']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_shape_mime_type" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in local_var_params or
                local_var_params['id'] is None):
            raise ApiValueError("Missing the required parameter `id` when calling `delete_shape_mime_type`")  # noqa: E501
        # verify the required parameter 'shape_id' is set
        if ('shape_id' not in local_var_params or
                local_var_params['shape_id'] is None):
            raise ApiValueError("Missing the required parameter `shape_id` when calling `delete_shape_mime_type`")  # noqa: E501
        # verify the required parameter 'mime_type' is set
        if ('mime_type' not in local_var_params or
                local_var_params['mime_type'] is None):
            raise ApiValueError("Missing the required parameter `mime_type` when calling `delete_shape_mime_type`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501
        if 'shape_id' in local_var_params:
            path_params['shape-id'] = local_var_params['shape_id']  # noqa: E501
        if 'mime_type' in local_var_params:
            path_params['mime-type'] = local_var_params['mime_type']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/item/{id}/shape/{shape-id}/mime/{mime-type}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_shapes(self, id, **kwargs):  # noqa: E501
        """Delete all shapes  # noqa: E501

        Removes all shapes, regardless of essence version, for the specified item. This will remove all components and mark files for deletion, unless files are used in other shapes.  To delete all shapes for a specific essence version, see `DELETE /item/(id)/shape/version/(version)`.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_shapes(id, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str id: The id. (required)
        :key bool keep_files: - `true` - Keep the files belong to the shapes.  - `false` (default) - Remove the files belong to the shapes.
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None.
                 If the method is called asynchronously, returns the request thread.
        :rtype: None or multiprocessing.pool.AsyncResult
        """
        kwargs['_return_http_data_only'] = True
        return self.delete_shapes_with_http_info(id, **kwargs)  # noqa: E501

    def delete_shapes_with_http_info(self, id, **kwargs):  # noqa: E501
        """Delete all shapes  # noqa: E501

        Removes all shapes, regardless of essence version, for the specified item. This will remove all components and mark files for deletion, unless files are used in other shapes.  To delete all shapes for a specific essence version, see `DELETE /item/(id)/shape/version/(version)`.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_shapes_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str id: The id. (required)
        :key bool keep_files: - `true` - Keep the files belong to the shapes.  - `false` (default) - Remove the files belong to the shapes.
        :key _return_http_data_only: response data without head status code
                                       and headers
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['id', 'keep_files']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_shapes" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in local_var_params or
                local_var_params['id'] is None):
            raise ApiValueError("Missing the required parameter `id` when calling `delete_shapes`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []
        if 'keep_files' in local_var_params:
            query_params.append(('keepFiles', local_var_params['keep_files']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/item/{id}/shape/', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_component(self, id, shape_id, component_id, **kwargs):  # noqa: E501
        """Retrieve a component  # noqa: E501

        Returns all files, or the complete component information, for a specified component.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_component(id, shape_id, component_id, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str id: The id. (required)
        :param str shape_id: The shape id. (required)
        :param str component_id: The component id. (required)
        :key bool full: - `true` - Return the component information.  - `false` (default) - Return all files.
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: ComponentType.
                 If the method is called asynchronously, returns the request thread.
        :rtype: ComponentType or multiprocessing.pool.AsyncResult
        """
        kwargs['_return_http_data_only'] = True
        return self.get_component_with_http_info(id, shape_id, component_id, **kwargs)  # noqa: E501

    def get_component_with_http_info(self, id, shape_id, component_id, **kwargs):  # noqa: E501
        """Retrieve a component  # noqa: E501

        Returns all files, or the complete component information, for a specified component.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_component_with_http_info(id, shape_id, component_id, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str id: The id. (required)
        :param str shape_id: The shape id. (required)
        :param str component_id: The component id. (required)
        :key bool full: - `true` - Return the component information.  - `false` (default) - Return all files.
        :key _return_http_data_only: response data without head status code
                                       and headers
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(ComponentType, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['id', 'shape_id', 'component_id', 'full']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_component" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in local_var_params or
                local_var_params['id'] is None):
            raise ApiValueError("Missing the required parameter `id` when calling `get_component`")  # noqa: E501
        # verify the required parameter 'shape_id' is set
        if ('shape_id' not in local_var_params or
                local_var_params['shape_id'] is None):
            raise ApiValueError("Missing the required parameter `shape_id` when calling `get_component`")  # noqa: E501
        # verify the required parameter 'component_id' is set
        if ('component_id' not in local_var_params or
                local_var_params['component_id'] is None):
            raise ApiValueError("Missing the required parameter `component_id` when calling `get_component`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501
        if 'shape_id' in local_var_params:
            path_params['shape-id'] = local_var_params['shape_id']  # noqa: E501
        if 'component_id' in local_var_params:
            path_params['component-id'] = local_var_params['component_id']  # noqa: E501

        query_params = []
        if 'full' in local_var_params:
            query_params.append(('full', local_var_params['full']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'text/plain', 'application/xml'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/item/{id}/shape/{shape-id}/component/{component-id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ComponentType',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_component_metadata(self, item_id, shape_id, component_id, **kwargs):  # noqa: E501
        """Retrieve all metadata  # noqa: E501

        Retrieves all key-value pairs associated with the specified entity.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_component_metadata(item_id, shape_id, component_id, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str item_id: The item id. (required)
        :param str shape_id: The shape id. (required)
        :param str component_id: The component id. (required)
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: SimpleMetadataType.
                 If the method is called asynchronously, returns the request thread.
        :rtype: SimpleMetadataType or multiprocessing.pool.AsyncResult
        """
        kwargs['_return_http_data_only'] = True
        return self.get_component_metadata_with_http_info(item_id, shape_id, component_id, **kwargs)  # noqa: E501

    def get_component_metadata_with_http_info(self, item_id, shape_id, component_id, **kwargs):  # noqa: E501
        """Retrieve all metadata  # noqa: E501

        Retrieves all key-value pairs associated with the specified entity.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_component_metadata_with_http_info(item_id, shape_id, component_id, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str item_id: The item id. (required)
        :param str shape_id: The shape id. (required)
        :param str component_id: The component id. (required)
        :key _return_http_data_only: response data without head status code
                                       and headers
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(SimpleMetadataType, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['item_id', 'shape_id', 'component_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_component_metadata" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'item_id' is set
        if ('item_id' not in local_var_params or
                local_var_params['item_id'] is None):
            raise ApiValueError("Missing the required parameter `item_id` when calling `get_component_metadata`")  # noqa: E501
        # verify the required parameter 'shape_id' is set
        if ('shape_id' not in local_var_params or
                local_var_params['shape_id'] is None):
            raise ApiValueError("Missing the required parameter `shape_id` when calling `get_component_metadata`")  # noqa: E501
        # verify the required parameter 'component_id' is set
        if ('component_id' not in local_var_params or
                local_var_params['component_id'] is None):
            raise ApiValueError("Missing the required parameter `component_id` when calling `get_component_metadata`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'item_id' in local_var_params:
            path_params['item-id'] = local_var_params['item_id']  # noqa: E501
        if 'shape_id' in local_var_params:
            path_params['shape-id'] = local_var_params['shape_id']  # noqa: E501
        if 'component_id' in local_var_params:
            path_params['component-id'] = local_var_params['component_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'application/xml'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/item/{item-id}/shape/{shape-id}/component/{component-id}/metadata', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SimpleMetadataType',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_component_metadata_key(self, item_id, shape_id, component_id, keypath, **kwargs):  # noqa: E501
        """Retrieve the metadata for a specific key  # noqa: E501

        Retrieves the value of a specific key. If a key path is specified, exactly one key-value pair must match the key path, else an error is returned.  Key paths can also be specified as well as specific keys.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_component_metadata_key(item_id, shape_id, component_id, keypath, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str item_id: The item id. (required)
        :param str shape_id: The shape id. (required)
        :param str component_id: The component id. (required)
        :param str keypath: The keypath. (required)
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: str.
                 If the method is called asynchronously, returns the request thread.
        :rtype: str or multiprocessing.pool.AsyncResult
        """
        kwargs['_return_http_data_only'] = True
        return self.get_component_metadata_key_with_http_info(item_id, shape_id, component_id, keypath, **kwargs)  # noqa: E501

    def get_component_metadata_key_with_http_info(self, item_id, shape_id, component_id, keypath, **kwargs):  # noqa: E501
        """Retrieve the metadata for a specific key  # noqa: E501

        Retrieves the value of a specific key. If a key path is specified, exactly one key-value pair must match the key path, else an error is returned.  Key paths can also be specified as well as specific keys.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_component_metadata_key_with_http_info(item_id, shape_id, component_id, keypath, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str item_id: The item id. (required)
        :param str shape_id: The shape id. (required)
        :param str component_id: The component id. (required)
        :param str keypath: The keypath. (required)
        :key _return_http_data_only: response data without head status code
                                       and headers
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(str, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['item_id', 'shape_id', 'component_id', 'keypath']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_component_metadata_key" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'item_id' is set
        if ('item_id' not in local_var_params or
                local_var_params['item_id'] is None):
            raise ApiValueError("Missing the required parameter `item_id` when calling `get_component_metadata_key`")  # noqa: E501
        # verify the required parameter 'shape_id' is set
        if ('shape_id' not in local_var_params or
                local_var_params['shape_id'] is None):
            raise ApiValueError("Missing the required parameter `shape_id` when calling `get_component_metadata_key`")  # noqa: E501
        # verify the required parameter 'component_id' is set
        if ('component_id' not in local_var_params or
                local_var_params['component_id'] is None):
            raise ApiValueError("Missing the required parameter `component_id` when calling `get_component_metadata_key`")  # noqa: E501
        # verify the required parameter 'keypath' is set
        if ('keypath' not in local_var_params or
                local_var_params['keypath'] is None):
            raise ApiValueError("Missing the required parameter `keypath` when calling `get_component_metadata_key`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'item_id' in local_var_params:
            path_params['item-id'] = local_var_params['item_id']  # noqa: E501
        if 'shape_id' in local_var_params:
            path_params['shape-id'] = local_var_params['shape_id']  # noqa: E501
        if 'component_id' in local_var_params:
            path_params['component-id'] = local_var_params['component_id']  # noqa: E501
        if 'keypath' in local_var_params:
            path_params['keypath'] = local_var_params['keypath']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/item/{item-id}/shape/{shape-id}/component/{component-id}/metadata/{keypath}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='str',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_components(self, id, shape_id, **kwargs):  # noqa: E501
        """List all components for a shape  # noqa: E501

        Returns all components for a specified shape. Currently, this call returns the same information as the return shape, but is available for orthogonality.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_components(id, shape_id, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str id: The id. (required)
        :param str shape_id: The shape id. (required)
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: ComponentListType.
                 If the method is called asynchronously, returns the request thread.
        :rtype: ComponentListType or multiprocessing.pool.AsyncResult
        """
        kwargs['_return_http_data_only'] = True
        return self.get_components_with_http_info(id, shape_id, **kwargs)  # noqa: E501

    def get_components_with_http_info(self, id, shape_id, **kwargs):  # noqa: E501
        """List all components for a shape  # noqa: E501

        Returns all components for a specified shape. Currently, this call returns the same information as the return shape, but is available for orthogonality.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_components_with_http_info(id, shape_id, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str id: The id. (required)
        :param str shape_id: The shape id. (required)
        :key _return_http_data_only: response data without head status code
                                       and headers
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(ComponentListType, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['id', 'shape_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_components" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in local_var_params or
                local_var_params['id'] is None):
            raise ApiValueError("Missing the required parameter `id` when calling `get_components`")  # noqa: E501
        # verify the required parameter 'shape_id' is set
        if ('shape_id' not in local_var_params or
                local_var_params['shape_id'] is None):
            raise ApiValueError("Missing the required parameter `shape_id` when calling `get_components`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501
        if 'shape_id' in local_var_params:
            path_params['shape-id'] = local_var_params['shape_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'application/xml'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/item/{id}/shape/{shape-id}/component', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ComponentListType',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_shape(self, id, shape_id, **kwargs):  # noqa: E501
        """Retrieve a shape  # noqa: E501

        Returns a shape for a specified item.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_shape(id, shape_id, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str id: The id. (required)
        :param str shape_id: The shape id. (required)
        :key str storage_type: Only return URIs for files from storages of this type.
        :key bool include_placeholder: - `true` - Include expected but not yet imported components in the shape.  - `false` (default) - Do not include placeholder components.
        :key list[str] method_metadata: metadata used with storage method.
        :key bool transient: - `true` - Return the shape by inspecting the file on disk.  Use with growing files to get an as up-to-date shape as possible.  - `false` (default) - Return the shape that was last read from the file.
        :key str scheme: URI scheme to return.
        :key str method_type: Return URIs from storage methods with a particular type.  By default, return URLs with empty `methodType`.
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: ShapeType.
                 If the method is called asynchronously, returns the request thread.
        :rtype: ShapeType or multiprocessing.pool.AsyncResult
        """
        kwargs['_return_http_data_only'] = True
        return self.get_shape_with_http_info(id, shape_id, **kwargs)  # noqa: E501

    def get_shape_with_http_info(self, id, shape_id, **kwargs):  # noqa: E501
        """Retrieve a shape  # noqa: E501

        Returns a shape for a specified item.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_shape_with_http_info(id, shape_id, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str id: The id. (required)
        :param str shape_id: The shape id. (required)
        :key str storage_type: Only return URIs for files from storages of this type.
        :key bool include_placeholder: - `true` - Include expected but not yet imported components in the shape.  - `false` (default) - Do not include placeholder components.
        :key list[str] method_metadata: metadata used with storage method.
        :key bool transient: - `true` - Return the shape by inspecting the file on disk.  Use with growing files to get an as up-to-date shape as possible.  - `false` (default) - Return the shape that was last read from the file.
        :key str scheme: URI scheme to return.
        :key str method_type: Return URIs from storage methods with a particular type.  By default, return URLs with empty `methodType`.
        :key _return_http_data_only: response data without head status code
                                       and headers
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(ShapeType, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['id', 'shape_id', 'storage_type', 'include_placeholder', 'method_metadata', 'transient', 'scheme', 'method_type']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_shape" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in local_var_params or
                local_var_params['id'] is None):
            raise ApiValueError("Missing the required parameter `id` when calling `get_shape`")  # noqa: E501
        # verify the required parameter 'shape_id' is set
        if ('shape_id' not in local_var_params or
                local_var_params['shape_id'] is None):
            raise ApiValueError("Missing the required parameter `shape_id` when calling `get_shape`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501
        if 'shape_id' in local_var_params:
            path_params['shape-id'] = local_var_params['shape_id']  # noqa: E501

        query_params = []
        if 'storage_type' in local_var_params:
            query_params.append(('storageType', local_var_params['storage_type']))  # noqa: E501
        if 'include_placeholder' in local_var_params:
            query_params.append(('includePlaceholder', local_var_params['include_placeholder']))  # noqa: E501
        if 'method_metadata' in local_var_params:
            query_params.append(('methodMetadata', local_var_params['method_metadata']))  # noqa: E501
            collection_formats['methodMetadata'] = 'multi'  # noqa: E501
        if 'transient' in local_var_params:
            query_params.append(('transient', local_var_params['transient']))  # noqa: E501
        if 'scheme' in local_var_params:
            query_params.append(('scheme', local_var_params['scheme']))  # noqa: E501
        if 'method_type' in local_var_params:
            query_params.append(('methodType', local_var_params['method_type']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'application/xml'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/item/{id}/shape/{shape-id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ShapeType',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_shape_cpl(self, id, shape_id, **kwargs):  # noqa: E501
        """Retrieve a shape as an IMF CPL  # noqa: E501

        Returns component information as CPL.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_shape_cpl(id, shape_id, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str id: The id. (required)
        :param str shape_id: The shape id. (required)
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: str.
                 If the method is called asynchronously, returns the request thread.
        :rtype: str or multiprocessing.pool.AsyncResult
        """
        kwargs['_return_http_data_only'] = True
        return self.get_shape_cpl_with_http_info(id, shape_id, **kwargs)  # noqa: E501

    def get_shape_cpl_with_http_info(self, id, shape_id, **kwargs):  # noqa: E501
        """Retrieve a shape as an IMF CPL  # noqa: E501

        Returns component information as CPL.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_shape_cpl_with_http_info(id, shape_id, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str id: The id. (required)
        :param str shape_id: The shape id. (required)
        :key _return_http_data_only: response data without head status code
                                       and headers
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(str, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['id', 'shape_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_shape_cpl" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in local_var_params or
                local_var_params['id'] is None):
            raise ApiValueError("Missing the required parameter `id` when calling `get_shape_cpl`")  # noqa: E501
        # verify the required parameter 'shape_id' is set
        if ('shape_id' not in local_var_params or
                local_var_params['shape_id'] is None):
            raise ApiValueError("Missing the required parameter `shape_id` when calling `get_shape_cpl`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501
        if 'shape_id' in local_var_params:
            path_params['shape-id'] = local_var_params['shape_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/xml'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/item/{id}/shape/{shape-id}/cpl', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='str',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_shape_essence_version(self, id, version, **kwargs):  # noqa: E501
        """Retrieve an essence version  # noqa: E501

        Returns a list of shapes from the specified version.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_shape_essence_version(id, version, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str id: The id. (required)
        :param str version: The version. (required)
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: EssenceVersionType.
                 If the method is called asynchronously, returns the request thread.
        :rtype: EssenceVersionType or multiprocessing.pool.AsyncResult
        """
        kwargs['_return_http_data_only'] = True
        return self.get_shape_essence_version_with_http_info(id, version, **kwargs)  # noqa: E501

    def get_shape_essence_version_with_http_info(self, id, version, **kwargs):  # noqa: E501
        """Retrieve an essence version  # noqa: E501

        Returns a list of shapes from the specified version.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_shape_essence_version_with_http_info(id, version, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str id: The id. (required)
        :param str version: The version. (required)
        :key _return_http_data_only: response data without head status code
                                       and headers
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(EssenceVersionType, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['id', 'version']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_shape_essence_version" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in local_var_params or
                local_var_params['id'] is None):
            raise ApiValueError("Missing the required parameter `id` when calling `get_shape_essence_version`")  # noqa: E501
        # verify the required parameter 'version' is set
        if ('version' not in local_var_params or
                local_var_params['version'] is None):
            raise ApiValueError("Missing the required parameter `version` when calling `get_shape_essence_version`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501
        if 'version' in local_var_params:
            path_params['version'] = local_var_params['version']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'application/xml'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/item/{id}/shape/version/{version}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='EssenceVersionType',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_shape_files(self, id, shape_id, **kwargs):  # noqa: E501
        """List all files for a shape  # noqa: E501

        Returns all files that are associated with the specified shape.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_shape_files(id, shape_id, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str id: The id. (required)
        :param str shape_id: The shape id. (required)
        :key str storage_type: Only return URIs for files from storages of this type.
        :key list[str] method_metadata: metadata used with storage method.
        :key bool closed_files: - `true` (default) - Return only files that are closed.  - `false` - Return all files.
        :key str scheme: URI scheme to return.
        :key bool include_item: - `true` - Return associated items, shapes, and components.  - `false` (default) - Do not return any information about associated items, shapes, and components.
        :key str method_type: Return URIs from storage methods with a particular type.  By default, return URLs with empty `methodType`.
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: FileListType.
                 If the method is called asynchronously, returns the request thread.
        :rtype: FileListType or multiprocessing.pool.AsyncResult
        """
        kwargs['_return_http_data_only'] = True
        return self.get_shape_files_with_http_info(id, shape_id, **kwargs)  # noqa: E501

    def get_shape_files_with_http_info(self, id, shape_id, **kwargs):  # noqa: E501
        """List all files for a shape  # noqa: E501

        Returns all files that are associated with the specified shape.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_shape_files_with_http_info(id, shape_id, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str id: The id. (required)
        :param str shape_id: The shape id. (required)
        :key str storage_type: Only return URIs for files from storages of this type.
        :key list[str] method_metadata: metadata used with storage method.
        :key bool closed_files: - `true` (default) - Return only files that are closed.  - `false` - Return all files.
        :key str scheme: URI scheme to return.
        :key bool include_item: - `true` - Return associated items, shapes, and components.  - `false` (default) - Do not return any information about associated items, shapes, and components.
        :key str method_type: Return URIs from storage methods with a particular type.  By default, return URLs with empty `methodType`.
        :key _return_http_data_only: response data without head status code
                                       and headers
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(FileListType, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['id', 'shape_id', 'storage_type', 'method_metadata', 'closed_files', 'scheme', 'include_item', 'method_type']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_shape_files" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in local_var_params or
                local_var_params['id'] is None):
            raise ApiValueError("Missing the required parameter `id` when calling `get_shape_files`")  # noqa: E501
        # verify the required parameter 'shape_id' is set
        if ('shape_id' not in local_var_params or
                local_var_params['shape_id'] is None):
            raise ApiValueError("Missing the required parameter `shape_id` when calling `get_shape_files`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501
        if 'shape_id' in local_var_params:
            path_params['shape-id'] = local_var_params['shape_id']  # noqa: E501

        query_params = []
        if 'storage_type' in local_var_params:
            query_params.append(('storageType', local_var_params['storage_type']))  # noqa: E501
        if 'method_metadata' in local_var_params:
            query_params.append(('methodMetadata', local_var_params['method_metadata']))  # noqa: E501
            collection_formats['methodMetadata'] = 'multi'  # noqa: E501
        if 'closed_files' in local_var_params:
            query_params.append(('closedFiles', local_var_params['closed_files']))  # noqa: E501
        if 'scheme' in local_var_params:
            query_params.append(('scheme', local_var_params['scheme']))  # noqa: E501
        if 'include_item' in local_var_params:
            query_params.append(('includeItem', local_var_params['include_item']))  # noqa: E501
        if 'method_type' in local_var_params:
            query_params.append(('methodType', local_var_params['method_type']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'application/xml'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/item/{id}/shape/{shape-id}/file', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='FileListType',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_shape_graph(self, id, shape_id, **kwargs):  # noqa: E501
        """Retrieve a graphical representation of a shape  # noqa: E501

        Shows components and tracks in a graphical format.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_shape_graph(id, shape_id, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str id: The id. (required)
        :param str shape_id: The shape id. (required)
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: file.
                 If the method is called asynchronously, returns the request thread.
        :rtype: file or multiprocessing.pool.AsyncResult
        """
        kwargs['_return_http_data_only'] = True
        return self.get_shape_graph_with_http_info(id, shape_id, **kwargs)  # noqa: E501

    def get_shape_graph_with_http_info(self, id, shape_id, **kwargs):  # noqa: E501
        """Retrieve a graphical representation of a shape  # noqa: E501

        Shows components and tracks in a graphical format.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_shape_graph_with_http_info(id, shape_id, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str id: The id. (required)
        :param str shape_id: The shape id. (required)
        :key _return_http_data_only: response data without head status code
                                       and headers
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(file, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['id', 'shape_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_shape_graph" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in local_var_params or
                local_var_params['id'] is None):
            raise ApiValueError("Missing the required parameter `id` when calling `get_shape_graph`")  # noqa: E501
        # verify the required parameter 'shape_id' is set
        if ('shape_id' not in local_var_params or
                local_var_params['shape_id'] is None):
            raise ApiValueError("Missing the required parameter `shape_id` when calling `get_shape_graph`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501
        if 'shape_id' in local_var_params:
            path_params['shape-id'] = local_var_params['shape_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['image/png'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/item/{id}/shape/{shape-id}/graph', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='file',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_shape_graph_dot(self, id, shape_id, **kwargs):  # noqa: E501
        """Retrieve a shape as a dot file  # noqa: E501

        Shows components and tracks in a graphical format in dot format, for further processing.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_shape_graph_dot(id, shape_id, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str id: The id. (required)
        :param str shape_id: The shape id. (required)
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: str.
                 If the method is called asynchronously, returns the request thread.
        :rtype: str or multiprocessing.pool.AsyncResult
        """
        kwargs['_return_http_data_only'] = True
        return self.get_shape_graph_dot_with_http_info(id, shape_id, **kwargs)  # noqa: E501

    def get_shape_graph_dot_with_http_info(self, id, shape_id, **kwargs):  # noqa: E501
        """Retrieve a shape as a dot file  # noqa: E501

        Shows components and tracks in a graphical format in dot format, for further processing.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_shape_graph_dot_with_http_info(id, shape_id, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str id: The id. (required)
        :param str shape_id: The shape id. (required)
        :key _return_http_data_only: response data without head status code
                                       and headers
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(str, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['id', 'shape_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_shape_graph_dot" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in local_var_params or
                local_var_params['id'] is None):
            raise ApiValueError("Missing the required parameter `id` when calling `get_shape_graph_dot`")  # noqa: E501
        # verify the required parameter 'shape_id' is set
        if ('shape_id' not in local_var_params or
                local_var_params['shape_id'] is None):
            raise ApiValueError("Missing the required parameter `shape_id` when calling `get_shape_graph_dot`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501
        if 'shape_id' in local_var_params:
            path_params['shape-id'] = local_var_params['shape_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/item/{id}/shape/{shape-id}/graph/dot', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='str',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_shape_metadata(self, item_id, shape_id, **kwargs):  # noqa: E501
        """Retrieve all metadata  # noqa: E501

        Retrieves all key-value pairs associated with the specified entity.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_shape_metadata(item_id, shape_id, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str item_id: The item id. (required)
        :param str shape_id: The shape id. (required)
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: SimpleMetadataType.
                 If the method is called asynchronously, returns the request thread.
        :rtype: SimpleMetadataType or multiprocessing.pool.AsyncResult
        """
        kwargs['_return_http_data_only'] = True
        return self.get_shape_metadata_with_http_info(item_id, shape_id, **kwargs)  # noqa: E501

    def get_shape_metadata_with_http_info(self, item_id, shape_id, **kwargs):  # noqa: E501
        """Retrieve all metadata  # noqa: E501

        Retrieves all key-value pairs associated with the specified entity.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_shape_metadata_with_http_info(item_id, shape_id, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str item_id: The item id. (required)
        :param str shape_id: The shape id. (required)
        :key _return_http_data_only: response data without head status code
                                       and headers
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(SimpleMetadataType, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['item_id', 'shape_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_shape_metadata" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'item_id' is set
        if ('item_id' not in local_var_params or
                local_var_params['item_id'] is None):
            raise ApiValueError("Missing the required parameter `item_id` when calling `get_shape_metadata`")  # noqa: E501
        # verify the required parameter 'shape_id' is set
        if ('shape_id' not in local_var_params or
                local_var_params['shape_id'] is None):
            raise ApiValueError("Missing the required parameter `shape_id` when calling `get_shape_metadata`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'item_id' in local_var_params:
            path_params['item-id'] = local_var_params['item_id']  # noqa: E501
        if 'shape_id' in local_var_params:
            path_params['shape-id'] = local_var_params['shape_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'application/xml'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/item/{item-id}/shape/{shape-id}/metadata', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SimpleMetadataType',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_shape_metadata_key(self, item_id, shape_id, keypath, **kwargs):  # noqa: E501
        """Retrieve the metadata for a specific key  # noqa: E501

        Retrieves the value of a specific key. If a key path is specified, exactly one key-value pair must match the key path, else an error is returned.  Key paths can also be specified as well as specific keys.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_shape_metadata_key(item_id, shape_id, keypath, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str item_id: The item id. (required)
        :param str shape_id: The shape id. (required)
        :param str keypath: The keypath. (required)
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: str.
                 If the method is called asynchronously, returns the request thread.
        :rtype: str or multiprocessing.pool.AsyncResult
        """
        kwargs['_return_http_data_only'] = True
        return self.get_shape_metadata_key_with_http_info(item_id, shape_id, keypath, **kwargs)  # noqa: E501

    def get_shape_metadata_key_with_http_info(self, item_id, shape_id, keypath, **kwargs):  # noqa: E501
        """Retrieve the metadata for a specific key  # noqa: E501

        Retrieves the value of a specific key. If a key path is specified, exactly one key-value pair must match the key path, else an error is returned.  Key paths can also be specified as well as specific keys.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_shape_metadata_key_with_http_info(item_id, shape_id, keypath, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str item_id: The item id. (required)
        :param str shape_id: The shape id. (required)
        :param str keypath: The keypath. (required)
        :key _return_http_data_only: response data without head status code
                                       and headers
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(str, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['item_id', 'shape_id', 'keypath']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_shape_metadata_key" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'item_id' is set
        if ('item_id' not in local_var_params or
                local_var_params['item_id'] is None):
            raise ApiValueError("Missing the required parameter `item_id` when calling `get_shape_metadata_key`")  # noqa: E501
        # verify the required parameter 'shape_id' is set
        if ('shape_id' not in local_var_params or
                local_var_params['shape_id'] is None):
            raise ApiValueError("Missing the required parameter `shape_id` when calling `get_shape_metadata_key`")  # noqa: E501
        # verify the required parameter 'keypath' is set
        if ('keypath' not in local_var_params or
                local_var_params['keypath'] is None):
            raise ApiValueError("Missing the required parameter `keypath` when calling `get_shape_metadata_key`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'item_id' in local_var_params:
            path_params['item-id'] = local_var_params['item_id']  # noqa: E501
        if 'shape_id' in local_var_params:
            path_params['shape-id'] = local_var_params['shape_id']  # noqa: E501
        if 'keypath' in local_var_params:
            path_params['keypath'] = local_var_params['keypath']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/item/{item-id}/shape/{shape-id}/metadata/{keypath}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='str',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_shape_mime_types(self, id, shape_id, **kwargs):  # noqa: E501
        """List all mime types for a shape  # noqa: E501

        Lists all mime types that are set on the shape. These can also be seen the *ShapeDocument* of the shape.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_shape_mime_types(id, shape_id, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str id: The id. (required)
        :param str shape_id: The shape id. (required)
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: URIListType.
                 If the method is called asynchronously, returns the request thread.
        :rtype: URIListType or multiprocessing.pool.AsyncResult
        """
        kwargs['_return_http_data_only'] = True
        return self.get_shape_mime_types_with_http_info(id, shape_id, **kwargs)  # noqa: E501

    def get_shape_mime_types_with_http_info(self, id, shape_id, **kwargs):  # noqa: E501
        """List all mime types for a shape  # noqa: E501

        Lists all mime types that are set on the shape. These can also be seen the *ShapeDocument* of the shape.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_shape_mime_types_with_http_info(id, shape_id, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str id: The id. (required)
        :param str shape_id: The shape id. (required)
        :key _return_http_data_only: response data without head status code
                                       and headers
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(URIListType, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['id', 'shape_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_shape_mime_types" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in local_var_params or
                local_var_params['id'] is None):
            raise ApiValueError("Missing the required parameter `id` when calling `get_shape_mime_types`")  # noqa: E501
        # verify the required parameter 'shape_id' is set
        if ('shape_id' not in local_var_params or
                local_var_params['shape_id'] is None):
            raise ApiValueError("Missing the required parameter `shape_id` when calling `get_shape_mime_types`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501
        if 'shape_id' in local_var_params:
            path_params['shape-id'] = local_var_params['shape_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'text/plain', 'application/xml'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/item/{id}/shape/{shape-id}/mime/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='URIListType',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_shape_storage_rules(self, item_id, shape_id, **kwargs):  # noqa: E501
        """List all storage rules that applies to a certain shape  # noqa: E501

        Retrieves the storage rules that applies to a certain shape in a sorted manner. The rules are sorted according to priority, with the most important rule being first and the least important rule being last.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_shape_storage_rules(item_id, shape_id, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str item_id: The item id. (required)
        :param str shape_id: The shape id. (required)
        :key bool all: - `true` - Return all rules, regardless whether another rule overwrites it or not.  - `false` (default) - Return only rules that are in effect.
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: StorageRulesType.
                 If the method is called asynchronously, returns the request thread.
        :rtype: StorageRulesType or multiprocessing.pool.AsyncResult
        """
        kwargs['_return_http_data_only'] = True
        return self.get_shape_storage_rules_with_http_info(item_id, shape_id, **kwargs)  # noqa: E501

    def get_shape_storage_rules_with_http_info(self, item_id, shape_id, **kwargs):  # noqa: E501
        """List all storage rules that applies to a certain shape  # noqa: E501

        Retrieves the storage rules that applies to a certain shape in a sorted manner. The rules are sorted according to priority, with the most important rule being first and the least important rule being last.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_shape_storage_rules_with_http_info(item_id, shape_id, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str item_id: The item id. (required)
        :param str shape_id: The shape id. (required)
        :key bool all: - `true` - Return all rules, regardless whether another rule overwrites it or not.  - `false` (default) - Return only rules that are in effect.
        :key _return_http_data_only: response data without head status code
                                       and headers
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(StorageRulesType, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['item_id', 'shape_id', 'all']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_shape_storage_rules" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'item_id' is set
        if ('item_id' not in local_var_params or
                local_var_params['item_id'] is None):
            raise ApiValueError("Missing the required parameter `item_id` when calling `get_shape_storage_rules`")  # noqa: E501
        # verify the required parameter 'shape_id' is set
        if ('shape_id' not in local_var_params or
                local_var_params['shape_id'] is None):
            raise ApiValueError("Missing the required parameter `shape_id` when calling `get_shape_storage_rules`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'item_id' in local_var_params:
            path_params['item-id'] = local_var_params['item_id']  # noqa: E501
        if 'shape_id' in local_var_params:
            path_params['shape-id'] = local_var_params['shape_id']  # noqa: E501

        query_params = []
        if 'all' in local_var_params:
            query_params.append(('all', local_var_params['all']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'application/xml'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/item/{item-id}/shape/{shape-id}/storage-rule', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='StorageRulesType',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_shape_tags(self, item_id, shape_id, **kwargs):  # noqa: E501
        """List all tags for a shape  # noqa: E501

        Retrieves all shape tags associated with a certain shape.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_shape_tags(item_id, shape_id, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str item_id: The item id. (required)
        :param str shape_id: The shape id. (required)
        :key bool url: - `true` - Return list of URLs.  - `false` (default) - Return list of ids.
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: URIListType.
                 If the method is called asynchronously, returns the request thread.
        :rtype: URIListType or multiprocessing.pool.AsyncResult
        """
        kwargs['_return_http_data_only'] = True
        return self.get_shape_tags_with_http_info(item_id, shape_id, **kwargs)  # noqa: E501

    def get_shape_tags_with_http_info(self, item_id, shape_id, **kwargs):  # noqa: E501
        """List all tags for a shape  # noqa: E501

        Retrieves all shape tags associated with a certain shape.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_shape_tags_with_http_info(item_id, shape_id, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str item_id: The item id. (required)
        :param str shape_id: The shape id. (required)
        :key bool url: - `true` - Return list of URLs.  - `false` (default) - Return list of ids.
        :key _return_http_data_only: response data without head status code
                                       and headers
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(URIListType, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['item_id', 'shape_id', 'url']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_shape_tags" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'item_id' is set
        if ('item_id' not in local_var_params or
                local_var_params['item_id'] is None):
            raise ApiValueError("Missing the required parameter `item_id` when calling `get_shape_tags`")  # noqa: E501
        # verify the required parameter 'shape_id' is set
        if ('shape_id' not in local_var_params or
                local_var_params['shape_id'] is None):
            raise ApiValueError("Missing the required parameter `shape_id` when calling `get_shape_tags`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'item_id' in local_var_params:
            path_params['item-id'] = local_var_params['item_id']  # noqa: E501
        if 'shape_id' in local_var_params:
            path_params['shape-id'] = local_var_params['shape_id']  # noqa: E501

        query_params = []
        if 'url' in local_var_params:
            query_params.append(('url', local_var_params['url']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'text/plain', 'application/xml'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/item/{item-id}/shape/{shape-id}/tag/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='URIListType',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_shape_versions(self, id, **kwargs):  # noqa: E501
        """List all essence versions  # noqa: E501

        Returns a list containing URLs to all essence versions of the item.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_shape_versions(id, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str id: The id. (required)
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: EssenceVersionListType.
                 If the method is called asynchronously, returns the request thread.
        :rtype: EssenceVersionListType or multiprocessing.pool.AsyncResult
        """
        kwargs['_return_http_data_only'] = True
        return self.get_shape_versions_with_http_info(id, **kwargs)  # noqa: E501

    def get_shape_versions_with_http_info(self, id, **kwargs):  # noqa: E501
        """List all essence versions  # noqa: E501

        Returns a list containing URLs to all essence versions of the item.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_shape_versions_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str id: The id. (required)
        :key _return_http_data_only: response data without head status code
                                       and headers
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(EssenceVersionListType, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_shape_versions" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in local_var_params or
                local_var_params['id'] is None):
            raise ApiValueError("Missing the required parameter `id` when calling `get_shape_versions`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'application/xml'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/item/{id}/shape/version', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='EssenceVersionListType',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_shapes(self, id, **kwargs):  # noqa: E501
        """List all shapes  # noqa: E501

        Returns all existing shapes for a specified item.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_shapes(id, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str id: The id. (required)
        :key str version: - *essence-version-id* - Return shapes for a specified version.  - `all` - Return shapes for all versions.  - `latest` (default) - Return shapes for the latest version.  - `latest-per-shapetag` - Return shapes with the highest essence version number per shape tag.
        :key str placeholder: - `true` - Only return placeholder shapes.  - `false` (default) - Only return non-placeholder shapes.  - `all` - Return all shapes.
        :key bool url: - `true` - Return list of URLs.  - `false` (default) - Return list of ids.
        :key list[str] tag: Comma-separated list.  Only return shapes with these tags.
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: URIListType.
                 If the method is called asynchronously, returns the request thread.
        :rtype: URIListType or multiprocessing.pool.AsyncResult
        """
        kwargs['_return_http_data_only'] = True
        return self.get_shapes_with_http_info(id, **kwargs)  # noqa: E501

    def get_shapes_with_http_info(self, id, **kwargs):  # noqa: E501
        """List all shapes  # noqa: E501

        Returns all existing shapes for a specified item.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_shapes_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str id: The id. (required)
        :key str version: - *essence-version-id* - Return shapes for a specified version.  - `all` - Return shapes for all versions.  - `latest` (default) - Return shapes for the latest version.  - `latest-per-shapetag` - Return shapes with the highest essence version number per shape tag.
        :key str placeholder: - `true` - Only return placeholder shapes.  - `false` (default) - Only return non-placeholder shapes.  - `all` - Return all shapes.
        :key bool url: - `true` - Return list of URLs.  - `false` (default) - Return list of ids.
        :key list[str] tag: Comma-separated list.  Only return shapes with these tags.
        :key _return_http_data_only: response data without head status code
                                       and headers
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(URIListType, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['id', 'version', 'placeholder', 'url', 'tag']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_shapes" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in local_var_params or
                local_var_params['id'] is None):
            raise ApiValueError("Missing the required parameter `id` when calling `get_shapes`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []
        if 'version' in local_var_params:
            query_params.append(('version', local_var_params['version']))  # noqa: E501
        if 'placeholder' in local_var_params:
            query_params.append(('placeholder', local_var_params['placeholder']))  # noqa: E501
        if 'url' in local_var_params:
            query_params.append(('url', local_var_params['url']))  # noqa: E501
        if 'tag' in local_var_params:
            query_params.append(('tag', local_var_params['tag']))  # noqa: E501
            collection_formats['tag'] = 'csv'  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'text/plain', 'application/xml'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/item/{id}/shape', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='URIListType',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def import_component(self, id, shape_id, **kwargs):  # noqa: E501
        """Import a component using a URI or an existing file  # noqa: E501

        Starts a job that imports a component to an existing shape. The shape must be a media shape and must not be a placeholder.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.import_component(id, shape_id, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str id: The id. (required)
        :param str shape_id: The shape id. (required)
        :key list[str] jobmetadata: Additional information for the job task.
        :key str notification_data: Any additional data to include for notifications on this job.
        :key str uri: The URI to the file containing the new shape.
        :key str notification: The placeholder job notification to use for this job.
        :key bool allow_reimport: - `true` - Import the file to this shape even if the file is already importing or is already part of another item.  - `false` (default) Reject the request if the file with the given id has already been imported or is currently importing.
        :key str file_id: The id of the file that contains the new shape.
        :key str priority: The priority to assign to the job.
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: JobType.
                 If the method is called asynchronously, returns the request thread.
        :rtype: JobType or multiprocessing.pool.AsyncResult
        """
        kwargs['_return_http_data_only'] = True
        return self.import_component_with_http_info(id, shape_id, **kwargs)  # noqa: E501

    def import_component_with_http_info(self, id, shape_id, **kwargs):  # noqa: E501
        """Import a component using a URI or an existing file  # noqa: E501

        Starts a job that imports a component to an existing shape. The shape must be a media shape and must not be a placeholder.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.import_component_with_http_info(id, shape_id, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str id: The id. (required)
        :param str shape_id: The shape id. (required)
        :key list[str] jobmetadata: Additional information for the job task.
        :key str notification_data: Any additional data to include for notifications on this job.
        :key str uri: The URI to the file containing the new shape.
        :key str notification: The placeholder job notification to use for this job.
        :key bool allow_reimport: - `true` - Import the file to this shape even if the file is already importing or is already part of another item.  - `false` (default) Reject the request if the file with the given id has already been imported or is currently importing.
        :key str file_id: The id of the file that contains the new shape.
        :key str priority: The priority to assign to the job.
        :key _return_http_data_only: response data without head status code
                                       and headers
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(JobType, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['id', 'shape_id', 'jobmetadata', 'notification_data', 'uri', 'notification', 'allow_reimport', 'file_id', 'priority']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method import_component" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in local_var_params or
                local_var_params['id'] is None):
            raise ApiValueError("Missing the required parameter `id` when calling `import_component`")  # noqa: E501
        # verify the required parameter 'shape_id' is set
        if ('shape_id' not in local_var_params or
                local_var_params['shape_id'] is None):
            raise ApiValueError("Missing the required parameter `shape_id` when calling `import_component`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501
        if 'shape_id' in local_var_params:
            path_params['shape-id'] = local_var_params['shape_id']  # noqa: E501

        query_params = []
        if 'jobmetadata' in local_var_params:
            query_params.append(('jobmetadata', local_var_params['jobmetadata']))  # noqa: E501
            collection_formats['jobmetadata'] = 'multi'  # noqa: E501
        if 'notification_data' in local_var_params:
            query_params.append(('notificationData', local_var_params['notification_data']))  # noqa: E501
        if 'uri' in local_var_params:
            query_params.append(('uri', local_var_params['uri']))  # noqa: E501
        if 'notification' in local_var_params:
            query_params.append(('notification', local_var_params['notification']))  # noqa: E501
        if 'allow_reimport' in local_var_params:
            query_params.append(('allowReimport', local_var_params['allow_reimport']))  # noqa: E501
        if 'file_id' in local_var_params:
            query_params.append(('fileId', local_var_params['file_id']))  # noqa: E501
        if 'priority' in local_var_params:
            query_params.append(('priority', local_var_params['priority']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'application/xml'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/item/{id}/shape/{shape-id}/component', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='JobType',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def import_shape(self, id, **kwargs):  # noqa: E501
        """Import a shape using a URI or an existing file  # noqa: E501

        Starts a new shape import job using either a URI or a file id.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.import_shape(id, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str id: The id. (required)
        :key list[str] jobmetadata: Additional information for the job task.
        :key str notification_data: Any additional data to include for notifications on this job.
        :key str storage_id: Identifier of storage where essence file is to be stored.
        :key str tag: The tags to assign to the new shape.
        :key str uri: A URI to the file that will be imported.  Make sure to percent encode the URI.  Must be specified unless `fileId` is specified.
        :key str notification: The placeholder job notification to use for this job.
        :key bool allow_reimport: - `true` - Import the file to this shape even if the file is already importing or is already part of another item.  - `false` (default) Reject the request if the file with the given id has already been imported or is currently importing.
        :key str file_id: The id of the file that contains the essence.  Must be specified unless `uri` is specified.
        :key str priority: The priority to assign to the job.
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: JobType.
                 If the method is called asynchronously, returns the request thread.
        :rtype: JobType or multiprocessing.pool.AsyncResult
        """
        kwargs['_return_http_data_only'] = True
        return self.import_shape_with_http_info(id, **kwargs)  # noqa: E501

    def import_shape_with_http_info(self, id, **kwargs):  # noqa: E501
        """Import a shape using a URI or an existing file  # noqa: E501

        Starts a new shape import job using either a URI or a file id.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.import_shape_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str id: The id. (required)
        :key list[str] jobmetadata: Additional information for the job task.
        :key str notification_data: Any additional data to include for notifications on this job.
        :key str storage_id: Identifier of storage where essence file is to be stored.
        :key str tag: The tags to assign to the new shape.
        :key str uri: A URI to the file that will be imported.  Make sure to percent encode the URI.  Must be specified unless `fileId` is specified.
        :key str notification: The placeholder job notification to use for this job.
        :key bool allow_reimport: - `true` - Import the file to this shape even if the file is already importing or is already part of another item.  - `false` (default) Reject the request if the file with the given id has already been imported or is currently importing.
        :key str file_id: The id of the file that contains the essence.  Must be specified unless `uri` is specified.
        :key str priority: The priority to assign to the job.
        :key _return_http_data_only: response data without head status code
                                       and headers
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(JobType, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['id', 'jobmetadata', 'notification_data', 'storage_id', 'tag', 'uri', 'notification', 'allow_reimport', 'file_id', 'priority']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method import_shape" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in local_var_params or
                local_var_params['id'] is None):
            raise ApiValueError("Missing the required parameter `id` when calling `import_shape`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []
        if 'jobmetadata' in local_var_params:
            query_params.append(('jobmetadata', local_var_params['jobmetadata']))  # noqa: E501
            collection_formats['jobmetadata'] = 'multi'  # noqa: E501
        if 'notification_data' in local_var_params:
            query_params.append(('notificationData', local_var_params['notification_data']))  # noqa: E501
        if 'storage_id' in local_var_params:
            query_params.append(('storageId', local_var_params['storage_id']))  # noqa: E501
        if 'tag' in local_var_params:
            query_params.append(('tag', local_var_params['tag']))  # noqa: E501
        if 'uri' in local_var_params:
            query_params.append(('uri', local_var_params['uri']))  # noqa: E501
        if 'notification' in local_var_params:
            query_params.append(('notification', local_var_params['notification']))  # noqa: E501
        if 'allow_reimport' in local_var_params:
            query_params.append(('allowReimport', local_var_params['allow_reimport']))  # noqa: E501
        if 'file_id' in local_var_params:
            query_params.append(('fileId', local_var_params['file_id']))  # noqa: E501
        if 'priority' in local_var_params:
            query_params.append(('priority', local_var_params['priority']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'application/xml'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/item/{id}/shape', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='JobType',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def import_shape_create(self, id, shape_type, **kwargs):  # noqa: E501
        """Create a shape using shape technical information  # noqa: E501

        Creates a new shape using the supplied information.  Changed in version 4.17.2: If the shape document has components that reference files (by id), then these files will be associated with the corresponding component.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.import_shape_create(id, shape_type, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str id: The id. (required)
        :param ShapeType shape_type: (required)
        :key str tag: The tags to assign to the new shape.
        :key bool update_item_metadata: If the shape is tagged `original` and this query parameter is `true`, the item's system metadata (e. g.  `durationSeconds`) is updated.
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: ShapeType.
                 If the method is called asynchronously, returns the request thread.
        :rtype: ShapeType or multiprocessing.pool.AsyncResult
        """
        kwargs['_return_http_data_only'] = True
        return self.import_shape_create_with_http_info(id, shape_type, **kwargs)  # noqa: E501

    def import_shape_create_with_http_info(self, id, shape_type, **kwargs):  # noqa: E501
        """Create a shape using shape technical information  # noqa: E501

        Creates a new shape using the supplied information.  Changed in version 4.17.2: If the shape document has components that reference files (by id), then these files will be associated with the corresponding component.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.import_shape_create_with_http_info(id, shape_type, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str id: The id. (required)
        :param ShapeType shape_type: (required)
        :key str tag: The tags to assign to the new shape.
        :key bool update_item_metadata: If the shape is tagged `original` and this query parameter is `true`, the item's system metadata (e. g.  `durationSeconds`) is updated.
        :key _return_http_data_only: response data without head status code
                                       and headers
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(ShapeType, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['id', 'shape_type', 'tag', 'update_item_metadata']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method import_shape_create" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in local_var_params or
                local_var_params['id'] is None):
            raise ApiValueError("Missing the required parameter `id` when calling `import_shape_create`")  # noqa: E501
        # verify the required parameter 'shape_type' is set
        if ('shape_type' not in local_var_params or
                local_var_params['shape_type'] is None):
            raise ApiValueError("Missing the required parameter `shape_type` when calling `import_shape_create`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []
        if 'tag' in local_var_params:
            query_params.append(('tag', local_var_params['tag']))  # noqa: E501
        if 'update_item_metadata' in local_var_params:
            query_params.append(('updateItemMetadata', local_var_params['update_item_metadata']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'shape_type' in local_var_params:
            body_params = local_var_params['shape_type']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'application/xml'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'application/xml'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/item/{id}/shape/create', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ShapeType',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def import_shape_essence(self, id, **kwargs):  # noqa: E501
        """Import an essence version using a URI or an existing file  # noqa: E501

        Starts a new essence import job using either a URI or a file id.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.import_shape_essence(id, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str id: The id. (required)
        :key list[str] jobmetadata: Additional information for the job task.
        :key str notification_data: Any additional data to include for notifications on this job.
        :key str storage_id: Identifier of storage where essence file is to be stored.
        :key str tag: The tags to assign to the new shape.
        :key str uri: A URI to the file that will be imported.  Make sure to percent encode the URI.  Must be specified unless `fileId` is specified.
        :key str notification: The placeholder job notification to use for this job.
        :key bool allow_reimport: - `true` - Import the file to this shape even if the file is already importing or is already part of another item.  - `false` (default) Reject the request if the file with the given id has already been imported or is currently importing.
        :key str file_id: The id of the file that contains the essence.  Must be specified unless `uri` is specified.
        :key str priority: The priority to assign to the job.
        :key str resource_id: The transcoder resource to use to execute the transcode.
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: JobType.
                 If the method is called asynchronously, returns the request thread.
        :rtype: JobType or multiprocessing.pool.AsyncResult
        """
        kwargs['_return_http_data_only'] = True
        return self.import_shape_essence_with_http_info(id, **kwargs)  # noqa: E501

    def import_shape_essence_with_http_info(self, id, **kwargs):  # noqa: E501
        """Import an essence version using a URI or an existing file  # noqa: E501

        Starts a new essence import job using either a URI or a file id.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.import_shape_essence_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str id: The id. (required)
        :key list[str] jobmetadata: Additional information for the job task.
        :key str notification_data: Any additional data to include for notifications on this job.
        :key str storage_id: Identifier of storage where essence file is to be stored.
        :key str tag: The tags to assign to the new shape.
        :key str uri: A URI to the file that will be imported.  Make sure to percent encode the URI.  Must be specified unless `fileId` is specified.
        :key str notification: The placeholder job notification to use for this job.
        :key bool allow_reimport: - `true` - Import the file to this shape even if the file is already importing or is already part of another item.  - `false` (default) Reject the request if the file with the given id has already been imported or is currently importing.
        :key str file_id: The id of the file that contains the essence.  Must be specified unless `uri` is specified.
        :key str priority: The priority to assign to the job.
        :key str resource_id: The transcoder resource to use to execute the transcode.
        :key _return_http_data_only: response data without head status code
                                       and headers
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(JobType, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['id', 'jobmetadata', 'notification_data', 'storage_id', 'tag', 'uri', 'notification', 'allow_reimport', 'file_id', 'priority', 'resource_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method import_shape_essence" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in local_var_params or
                local_var_params['id'] is None):
            raise ApiValueError("Missing the required parameter `id` when calling `import_shape_essence`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []
        if 'jobmetadata' in local_var_params:
            query_params.append(('jobmetadata', local_var_params['jobmetadata']))  # noqa: E501
            collection_formats['jobmetadata'] = 'multi'  # noqa: E501
        if 'notification_data' in local_var_params:
            query_params.append(('notificationData', local_var_params['notification_data']))  # noqa: E501
        if 'storage_id' in local_var_params:
            query_params.append(('storageId', local_var_params['storage_id']))  # noqa: E501
        if 'tag' in local_var_params:
            query_params.append(('tag', local_var_params['tag']))  # noqa: E501
        if 'uri' in local_var_params:
            query_params.append(('uri', local_var_params['uri']))  # noqa: E501
        if 'notification' in local_var_params:
            query_params.append(('notification', local_var_params['notification']))  # noqa: E501
        if 'allow_reimport' in local_var_params:
            query_params.append(('allowReimport', local_var_params['allow_reimport']))  # noqa: E501
        if 'file_id' in local_var_params:
            query_params.append(('fileId', local_var_params['file_id']))  # noqa: E501
        if 'priority' in local_var_params:
            query_params.append(('priority', local_var_params['priority']))  # noqa: E501
        if 'resource_id' in local_var_params:
            query_params.append(('resourceId', local_var_params['resource_id']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'application/xml'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/item/{id}/shape/essence', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='JobType',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def import_shape_essence_raw(self, id, body, **kwargs):  # noqa: E501
        """Import an essence version using the request body  # noqa: E501

        Starts a new essence import job using the data in the request data.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.import_shape_essence_raw(id, body, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str id: The id. (required)
        :param file body: The raw essence data. (required)
        :key list[str] jobmetadata: Additional information for the job task.
        :key str notification_data: Any additional data to include for notifications on this job.
        :key str storage_id: Identifier of storage where essence file is to be stored.
        :key str tag: The tags to assign to the new shape.
        :key int transfer_priority: An integer between 1 and 1000 that indicates what priority the transfer should be given in relation to other transfers.  A transfer with a high priority value is considered more important than a transfer with a low priority value.
        :key str notification: The placeholder job notification to use for this job.
        :key str priority: The priority to assign to the job.
        :key str filename: The filename to be stored as original filename
        :key str transfer_id: An id to assign the transfer to be able to refer to it.
        :key str resource_id: The transcoder resource to use to execute the transcode.
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: JobType.
                 If the method is called asynchronously, returns the request thread.
        :rtype: JobType or multiprocessing.pool.AsyncResult
        """
        kwargs['_return_http_data_only'] = True
        return self.import_shape_essence_raw_with_http_info(id, body, **kwargs)  # noqa: E501

    def import_shape_essence_raw_with_http_info(self, id, body, **kwargs):  # noqa: E501
        """Import an essence version using the request body  # noqa: E501

        Starts a new essence import job using the data in the request data.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.import_shape_essence_raw_with_http_info(id, body, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str id: The id. (required)
        :param file body: The raw essence data. (required)
        :key list[str] jobmetadata: Additional information for the job task.
        :key str notification_data: Any additional data to include for notifications on this job.
        :key str storage_id: Identifier of storage where essence file is to be stored.
        :key str tag: The tags to assign to the new shape.
        :key int transfer_priority: An integer between 1 and 1000 that indicates what priority the transfer should be given in relation to other transfers.  A transfer with a high priority value is considered more important than a transfer with a low priority value.
        :key str notification: The placeholder job notification to use for this job.
        :key str priority: The priority to assign to the job.
        :key str filename: The filename to be stored as original filename
        :key str transfer_id: An id to assign the transfer to be able to refer to it.
        :key str resource_id: The transcoder resource to use to execute the transcode.
        :key _return_http_data_only: response data without head status code
                                       and headers
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(JobType, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['id', 'body', 'jobmetadata', 'notification_data', 'storage_id', 'tag', 'transfer_priority', 'notification', 'priority', 'filename', 'transfer_id', 'resource_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method import_shape_essence_raw" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in local_var_params or
                local_var_params['id'] is None):
            raise ApiValueError("Missing the required parameter `id` when calling `import_shape_essence_raw`")  # noqa: E501
        # verify the required parameter 'body' is set
        if ('body' not in local_var_params or
                local_var_params['body'] is None):
            raise ApiValueError("Missing the required parameter `body` when calling `import_shape_essence_raw`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []
        if 'jobmetadata' in local_var_params:
            query_params.append(('jobmetadata', local_var_params['jobmetadata']))  # noqa: E501
            collection_formats['jobmetadata'] = 'multi'  # noqa: E501
        if 'notification_data' in local_var_params:
            query_params.append(('notificationData', local_var_params['notification_data']))  # noqa: E501
        if 'storage_id' in local_var_params:
            query_params.append(('storageId', local_var_params['storage_id']))  # noqa: E501
        if 'tag' in local_var_params:
            query_params.append(('tag', local_var_params['tag']))  # noqa: E501
        if 'transfer_priority' in local_var_params:
            query_params.append(('transferPriority', local_var_params['transfer_priority']))  # noqa: E501
        if 'notification' in local_var_params:
            query_params.append(('notification', local_var_params['notification']))  # noqa: E501
        if 'priority' in local_var_params:
            query_params.append(('priority', local_var_params['priority']))  # noqa: E501
        if 'filename' in local_var_params:
            query_params.append(('filename', local_var_params['filename']))  # noqa: E501
        if 'transfer_id' in local_var_params:
            query_params.append(('transferId', local_var_params['transfer_id']))  # noqa: E501
        if 'resource_id' in local_var_params:
            query_params.append(('resourceId', local_var_params['resource_id']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in local_var_params:
            body_params = local_var_params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'application/xml'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/octet-stream'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/item/{id}/shape/essence/raw', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='JobType',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def import_shape_imf_package(self, id, **kwargs):  # noqa: E501
        """Import a shape from an IMF package  # noqa: E501

        Starts a new shape import job using a URI of an IMF asset map  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.import_shape_imf_package(id, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str id: The id. (required)
        :key bool remove_old_essence_files: - `true` - Remove files associated with shapes with same tags and lower essence version.  - `false` (default) - Keep the files belong to the shapes.
        :key str notification_data: Any additional data to include for notifications on this job.
        :key str storage_id: Identifier of storage where essence file is to be stored.
        :key str tag: The tags to assign to the new shape.
        :key str uri: The URI of the asset map
        :key str notification: The placeholder job notification to use for this job.
        :key list[str] jobmetadata: Additional information for the job task.
        :key list[str] import_tag: A list of shape tags that the created shape will be associated with.
        :key str priority: The priority to assign to the job.
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: JobType.
                 If the method is called asynchronously, returns the request thread.
        :rtype: JobType or multiprocessing.pool.AsyncResult
        """
        kwargs['_return_http_data_only'] = True
        return self.import_shape_imf_package_with_http_info(id, **kwargs)  # noqa: E501

    def import_shape_imf_package_with_http_info(self, id, **kwargs):  # noqa: E501
        """Import a shape from an IMF package  # noqa: E501

        Starts a new shape import job using a URI of an IMF asset map  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.import_shape_imf_package_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str id: The id. (required)
        :key bool remove_old_essence_files: - `true` - Remove files associated with shapes with same tags and lower essence version.  - `false` (default) - Keep the files belong to the shapes.
        :key str notification_data: Any additional data to include for notifications on this job.
        :key str storage_id: Identifier of storage where essence file is to be stored.
        :key str tag: The tags to assign to the new shape.
        :key str uri: The URI of the asset map
        :key str notification: The placeholder job notification to use for this job.
        :key list[str] jobmetadata: Additional information for the job task.
        :key list[str] import_tag: A list of shape tags that the created shape will be associated with.
        :key str priority: The priority to assign to the job.
        :key _return_http_data_only: response data without head status code
                                       and headers
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(JobType, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['id', 'remove_old_essence_files', 'notification_data', 'storage_id', 'tag', 'uri', 'notification', 'jobmetadata', 'import_tag', 'priority']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method import_shape_imf_package" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in local_var_params or
                local_var_params['id'] is None):
            raise ApiValueError("Missing the required parameter `id` when calling `import_shape_imf_package`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []
        if 'remove_old_essence_files' in local_var_params:
            query_params.append(('removeOldEssenceFiles', local_var_params['remove_old_essence_files']))  # noqa: E501
        if 'notification_data' in local_var_params:
            query_params.append(('notificationData', local_var_params['notification_data']))  # noqa: E501
        if 'storage_id' in local_var_params:
            query_params.append(('storageId', local_var_params['storage_id']))  # noqa: E501
        if 'tag' in local_var_params:
            query_params.append(('tag', local_var_params['tag']))  # noqa: E501
        if 'uri' in local_var_params:
            query_params.append(('uri', local_var_params['uri']))  # noqa: E501
        if 'notification' in local_var_params:
            query_params.append(('notification', local_var_params['notification']))  # noqa: E501
        if 'jobmetadata' in local_var_params:
            query_params.append(('jobmetadata', local_var_params['jobmetadata']))  # noqa: E501
            collection_formats['jobmetadata'] = 'multi'  # noqa: E501
        if 'import_tag' in local_var_params:
            query_params.append(('importTag', local_var_params['import_tag']))  # noqa: E501
            collection_formats['importTag'] = 'multi'  # noqa: E501
        if 'priority' in local_var_params:
            query_params.append(('priority', local_var_params['priority']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'application/xml'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/item/{id}/shape/imp', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='JobType',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def import_shape_raw(self, id, body, **kwargs):  # noqa: E501
        """Import a shape using the request body  # noqa: E501

        Starts a new shape import job using the data in the request data.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.import_shape_raw(id, body, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str id: The id. (required)
        :param file body: The raw essence data. (required)
        :key list[str] jobmetadata: Additional information for the job task.
        :key str notification_data: Any additional data to include for notifications on this job.
        :key str storage_id: Identifier of storage where essence file is to be stored.
        :key str tag: The tags to assign to the new shape.
        :key int transfer_priority: An integer between 1 and 1000 that indicates what priority the transfer should be given in relation to other transfers.  A transfer with a high priority value is considered more important than a transfer with a low priority value.
        :key str notification: The placeholder job notification to use for this job.
        :key str priority: The priority to assign to the job.
        :key str filename: The filename to be stored as original filename
        :key str transfer_id: An id to assign the transfer to be able to refer to it.
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: JobType.
                 If the method is called asynchronously, returns the request thread.
        :rtype: JobType or multiprocessing.pool.AsyncResult
        """
        kwargs['_return_http_data_only'] = True
        return self.import_shape_raw_with_http_info(id, body, **kwargs)  # noqa: E501

    def import_shape_raw_with_http_info(self, id, body, **kwargs):  # noqa: E501
        """Import a shape using the request body  # noqa: E501

        Starts a new shape import job using the data in the request data.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.import_shape_raw_with_http_info(id, body, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str id: The id. (required)
        :param file body: The raw essence data. (required)
        :key list[str] jobmetadata: Additional information for the job task.
        :key str notification_data: Any additional data to include for notifications on this job.
        :key str storage_id: Identifier of storage where essence file is to be stored.
        :key str tag: The tags to assign to the new shape.
        :key int transfer_priority: An integer between 1 and 1000 that indicates what priority the transfer should be given in relation to other transfers.  A transfer with a high priority value is considered more important than a transfer with a low priority value.
        :key str notification: The placeholder job notification to use for this job.
        :key str priority: The priority to assign to the job.
        :key str filename: The filename to be stored as original filename
        :key str transfer_id: An id to assign the transfer to be able to refer to it.
        :key _return_http_data_only: response data without head status code
                                       and headers
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(JobType, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['id', 'body', 'jobmetadata', 'notification_data', 'storage_id', 'tag', 'transfer_priority', 'notification', 'priority', 'filename', 'transfer_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method import_shape_raw" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in local_var_params or
                local_var_params['id'] is None):
            raise ApiValueError("Missing the required parameter `id` when calling `import_shape_raw`")  # noqa: E501
        # verify the required parameter 'body' is set
        if ('body' not in local_var_params or
                local_var_params['body'] is None):
            raise ApiValueError("Missing the required parameter `body` when calling `import_shape_raw`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []
        if 'jobmetadata' in local_var_params:
            query_params.append(('jobmetadata', local_var_params['jobmetadata']))  # noqa: E501
            collection_formats['jobmetadata'] = 'multi'  # noqa: E501
        if 'notification_data' in local_var_params:
            query_params.append(('notificationData', local_var_params['notification_data']))  # noqa: E501
        if 'storage_id' in local_var_params:
            query_params.append(('storageId', local_var_params['storage_id']))  # noqa: E501
        if 'tag' in local_var_params:
            query_params.append(('tag', local_var_params['tag']))  # noqa: E501
        if 'transfer_priority' in local_var_params:
            query_params.append(('transferPriority', local_var_params['transfer_priority']))  # noqa: E501
        if 'notification' in local_var_params:
            query_params.append(('notification', local_var_params['notification']))  # noqa: E501
        if 'priority' in local_var_params:
            query_params.append(('priority', local_var_params['priority']))  # noqa: E501
        if 'filename' in local_var_params:
            query_params.append(('filename', local_var_params['filename']))  # noqa: E501
        if 'transfer_id' in local_var_params:
            query_params.append(('transferId', local_var_params['transfer_id']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in local_var_params:
            body_params = local_var_params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'application/xml'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/octet-stream'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/item/{id}/shape/raw', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='JobType',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def move_component_to_component(self, id, shape_id, component_id, target_id, target_shape_id, target_component_id, **kwargs):  # noqa: E501
        """Move a component to another shape/component  # noqa: E501

        Move this component to another shape, replacing a specific component by id.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.move_component_to_component(id, shape_id, component_id, target_id, target_shape_id, target_component_id, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str id: The id. (required)
        :param str shape_id: The shape id. (required)
        :param str component_id: The component id. (required)
        :param str target_id: The target id. (required)
        :param str target_shape_id: The target shape id. (required)
        :param str target_component_id: The target component id. (required)
        :key int index: The component index (track) of component.  If the target shape has a component with this index, then it will be replaced/removed.
        :key bool keep_metadata: - `true` - Preserve the metadata from the replaced component.  - `false` (default) - Discard any metadata from the replaced component.
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: ShapeType.
                 If the method is called asynchronously, returns the request thread.
        :rtype: ShapeType or multiprocessing.pool.AsyncResult
        """
        kwargs['_return_http_data_only'] = True
        return self.move_component_to_component_with_http_info(id, shape_id, component_id, target_id, target_shape_id, target_component_id, **kwargs)  # noqa: E501

    def move_component_to_component_with_http_info(self, id, shape_id, component_id, target_id, target_shape_id, target_component_id, **kwargs):  # noqa: E501
        """Move a component to another shape/component  # noqa: E501

        Move this component to another shape, replacing a specific component by id.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.move_component_to_component_with_http_info(id, shape_id, component_id, target_id, target_shape_id, target_component_id, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str id: The id. (required)
        :param str shape_id: The shape id. (required)
        :param str component_id: The component id. (required)
        :param str target_id: The target id. (required)
        :param str target_shape_id: The target shape id. (required)
        :param str target_component_id: The target component id. (required)
        :key int index: The component index (track) of component.  If the target shape has a component with this index, then it will be replaced/removed.
        :key bool keep_metadata: - `true` - Preserve the metadata from the replaced component.  - `false` (default) - Discard any metadata from the replaced component.
        :key _return_http_data_only: response data without head status code
                                       and headers
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(ShapeType, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['id', 'shape_id', 'component_id', 'target_id', 'target_shape_id', 'target_component_id', 'index', 'keep_metadata']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method move_component_to_component" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in local_var_params or
                local_var_params['id'] is None):
            raise ApiValueError("Missing the required parameter `id` when calling `move_component_to_component`")  # noqa: E501
        # verify the required parameter 'shape_id' is set
        if ('shape_id' not in local_var_params or
                local_var_params['shape_id'] is None):
            raise ApiValueError("Missing the required parameter `shape_id` when calling `move_component_to_component`")  # noqa: E501
        # verify the required parameter 'component_id' is set
        if ('component_id' not in local_var_params or
                local_var_params['component_id'] is None):
            raise ApiValueError("Missing the required parameter `component_id` when calling `move_component_to_component`")  # noqa: E501
        # verify the required parameter 'target_id' is set
        if ('target_id' not in local_var_params or
                local_var_params['target_id'] is None):
            raise ApiValueError("Missing the required parameter `target_id` when calling `move_component_to_component`")  # noqa: E501
        # verify the required parameter 'target_shape_id' is set
        if ('target_shape_id' not in local_var_params or
                local_var_params['target_shape_id'] is None):
            raise ApiValueError("Missing the required parameter `target_shape_id` when calling `move_component_to_component`")  # noqa: E501
        # verify the required parameter 'target_component_id' is set
        if ('target_component_id' not in local_var_params or
                local_var_params['target_component_id'] is None):
            raise ApiValueError("Missing the required parameter `target_component_id` when calling `move_component_to_component`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501
        if 'shape_id' in local_var_params:
            path_params['shape-id'] = local_var_params['shape_id']  # noqa: E501
        if 'component_id' in local_var_params:
            path_params['component-id'] = local_var_params['component_id']  # noqa: E501
        if 'target_id' in local_var_params:
            path_params['target-id'] = local_var_params['target_id']  # noqa: E501
        if 'target_shape_id' in local_var_params:
            path_params['target-shape-id'] = local_var_params['target_shape_id']  # noqa: E501
        if 'target_component_id' in local_var_params:
            path_params['target-component-id'] = local_var_params['target_component_id']  # noqa: E501

        query_params = []
        if 'index' in local_var_params:
            query_params.append(('index', local_var_params['index']))  # noqa: E501
        if 'keep_metadata' in local_var_params:
            query_params.append(('keepMetadata', local_var_params['keep_metadata']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'application/xml'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/item/{id}/shape/{shape-id}/component/{component-id}/move/item/{target-id}/shape/{target-shape-id}/component/{target-component-id}', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ShapeType',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def move_component_to_shape(self, id, shape_id, component_id, target_id, target_shape_id, **kwargs):  # noqa: E501
        """Move a component to another shape  # noqa: E501

        Move this component to another shape.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.move_component_to_shape(id, shape_id, component_id, target_id, target_shape_id, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str id: The id. (required)
        :param str shape_id: The shape id. (required)
        :param str component_id: The component id. (required)
        :param str target_id: The target id. (required)
        :param str target_shape_id: The target shape id. (required)
        :key int index: The component index (track) of component.  If the target shape has a component with this index, then it will be replaced/removed.
        :key bool keep_metadata: - `true` - Preserve the metadata from the replaced component.  - `false` (default) - Discard any metadata from the replaced component.
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: ShapeType.
                 If the method is called asynchronously, returns the request thread.
        :rtype: ShapeType or multiprocessing.pool.AsyncResult
        """
        kwargs['_return_http_data_only'] = True
        return self.move_component_to_shape_with_http_info(id, shape_id, component_id, target_id, target_shape_id, **kwargs)  # noqa: E501

    def move_component_to_shape_with_http_info(self, id, shape_id, component_id, target_id, target_shape_id, **kwargs):  # noqa: E501
        """Move a component to another shape  # noqa: E501

        Move this component to another shape.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.move_component_to_shape_with_http_info(id, shape_id, component_id, target_id, target_shape_id, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str id: The id. (required)
        :param str shape_id: The shape id. (required)
        :param str component_id: The component id. (required)
        :param str target_id: The target id. (required)
        :param str target_shape_id: The target shape id. (required)
        :key int index: The component index (track) of component.  If the target shape has a component with this index, then it will be replaced/removed.
        :key bool keep_metadata: - `true` - Preserve the metadata from the replaced component.  - `false` (default) - Discard any metadata from the replaced component.
        :key _return_http_data_only: response data without head status code
                                       and headers
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(ShapeType, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['id', 'shape_id', 'component_id', 'target_id', 'target_shape_id', 'index', 'keep_metadata']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method move_component_to_shape" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in local_var_params or
                local_var_params['id'] is None):
            raise ApiValueError("Missing the required parameter `id` when calling `move_component_to_shape`")  # noqa: E501
        # verify the required parameter 'shape_id' is set
        if ('shape_id' not in local_var_params or
                local_var_params['shape_id'] is None):
            raise ApiValueError("Missing the required parameter `shape_id` when calling `move_component_to_shape`")  # noqa: E501
        # verify the required parameter 'component_id' is set
        if ('component_id' not in local_var_params or
                local_var_params['component_id'] is None):
            raise ApiValueError("Missing the required parameter `component_id` when calling `move_component_to_shape`")  # noqa: E501
        # verify the required parameter 'target_id' is set
        if ('target_id' not in local_var_params or
                local_var_params['target_id'] is None):
            raise ApiValueError("Missing the required parameter `target_id` when calling `move_component_to_shape`")  # noqa: E501
        # verify the required parameter 'target_shape_id' is set
        if ('target_shape_id' not in local_var_params or
                local_var_params['target_shape_id'] is None):
            raise ApiValueError("Missing the required parameter `target_shape_id` when calling `move_component_to_shape`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501
        if 'shape_id' in local_var_params:
            path_params['shape-id'] = local_var_params['shape_id']  # noqa: E501
        if 'component_id' in local_var_params:
            path_params['component-id'] = local_var_params['component_id']  # noqa: E501
        if 'target_id' in local_var_params:
            path_params['target-id'] = local_var_params['target_id']  # noqa: E501
        if 'target_shape_id' in local_var_params:
            path_params['target-shape-id'] = local_var_params['target_shape_id']  # noqa: E501

        query_params = []
        if 'index' in local_var_params:
            query_params.append(('index', local_var_params['index']))  # noqa: E501
        if 'keep_metadata' in local_var_params:
            query_params.append(('keepMetadata', local_var_params['keep_metadata']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'application/xml'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/item/{id}/shape/{shape-id}/component/{component-id}/move/item/{target-id}/shape/{target-shape-id}', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ShapeType',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def remove_file_from_component(self, id, shape_id, component_id, file_id, **kwargs):  # noqa: E501
        """Remove a file from a component  # noqa: E501

        Removes the specified file from the specified component  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.remove_file_from_component(id, shape_id, component_id, file_id, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str id: The id. (required)
        :param str shape_id: The shape id. (required)
        :param str component_id: The component id. (required)
        :param str file_id: The file id. (required)
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None.
                 If the method is called asynchronously, returns the request thread.
        :rtype: None or multiprocessing.pool.AsyncResult
        """
        kwargs['_return_http_data_only'] = True
        return self.remove_file_from_component_with_http_info(id, shape_id, component_id, file_id, **kwargs)  # noqa: E501

    def remove_file_from_component_with_http_info(self, id, shape_id, component_id, file_id, **kwargs):  # noqa: E501
        """Remove a file from a component  # noqa: E501

        Removes the specified file from the specified component  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.remove_file_from_component_with_http_info(id, shape_id, component_id, file_id, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str id: The id. (required)
        :param str shape_id: The shape id. (required)
        :param str component_id: The component id. (required)
        :param str file_id: The file id. (required)
        :key _return_http_data_only: response data without head status code
                                       and headers
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['id', 'shape_id', 'component_id', 'file_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method remove_file_from_component" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in local_var_params or
                local_var_params['id'] is None):
            raise ApiValueError("Missing the required parameter `id` when calling `remove_file_from_component`")  # noqa: E501
        # verify the required parameter 'shape_id' is set
        if ('shape_id' not in local_var_params or
                local_var_params['shape_id'] is None):
            raise ApiValueError("Missing the required parameter `shape_id` when calling `remove_file_from_component`")  # noqa: E501
        # verify the required parameter 'component_id' is set
        if ('component_id' not in local_var_params or
                local_var_params['component_id'] is None):
            raise ApiValueError("Missing the required parameter `component_id` when calling `remove_file_from_component`")  # noqa: E501
        # verify the required parameter 'file_id' is set
        if ('file_id' not in local_var_params or
                local_var_params['file_id'] is None):
            raise ApiValueError("Missing the required parameter `file_id` when calling `remove_file_from_component`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501
        if 'shape_id' in local_var_params:
            path_params['shape-id'] = local_var_params['shape_id']  # noqa: E501
        if 'component_id' in local_var_params:
            path_params['component-id'] = local_var_params['component_id']  # noqa: E501
        if 'file_id' in local_var_params:
            path_params['file-id'] = local_var_params['file_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/item/{id}/shape/{shape-id}/component/{component-id}/file/{file-id}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def remove_shape_tag(self, item_id, shape_id, tag_name, **kwargs):  # noqa: E501
        """Remove a tag from a shape  # noqa: E501

        Removes a tag with the given name from the specified shape.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.remove_shape_tag(item_id, shape_id, tag_name, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str item_id: The item id. (required)
        :param str shape_id: The shape id. (required)
        :param str tag_name: The tag name. (required)
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None.
                 If the method is called asynchronously, returns the request thread.
        :rtype: None or multiprocessing.pool.AsyncResult
        """
        kwargs['_return_http_data_only'] = True
        return self.remove_shape_tag_with_http_info(item_id, shape_id, tag_name, **kwargs)  # noqa: E501

    def remove_shape_tag_with_http_info(self, item_id, shape_id, tag_name, **kwargs):  # noqa: E501
        """Remove a tag from a shape  # noqa: E501

        Removes a tag with the given name from the specified shape.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.remove_shape_tag_with_http_info(item_id, shape_id, tag_name, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str item_id: The item id. (required)
        :param str shape_id: The shape id. (required)
        :param str tag_name: The tag name. (required)
        :key _return_http_data_only: response data without head status code
                                       and headers
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['item_id', 'shape_id', 'tag_name']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method remove_shape_tag" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'item_id' is set
        if ('item_id' not in local_var_params or
                local_var_params['item_id'] is None):
            raise ApiValueError("Missing the required parameter `item_id` when calling `remove_shape_tag`")  # noqa: E501
        # verify the required parameter 'shape_id' is set
        if ('shape_id' not in local_var_params or
                local_var_params['shape_id'] is None):
            raise ApiValueError("Missing the required parameter `shape_id` when calling `remove_shape_tag`")  # noqa: E501
        # verify the required parameter 'tag_name' is set
        if ('tag_name' not in local_var_params or
                local_var_params['tag_name'] is None):
            raise ApiValueError("Missing the required parameter `tag_name` when calling `remove_shape_tag`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'item_id' in local_var_params:
            path_params['item-id'] = local_var_params['item_id']  # noqa: E501
        if 'shape_id' in local_var_params:
            path_params['shape-id'] = local_var_params['shape_id']  # noqa: E501
        if 'tag_name' in local_var_params:
            path_params['tag-name'] = local_var_params['tag_name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/item/{item-id}/shape/{shape-id}/tag/{tag-name}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_component_metadata(self, item_id, shape_id, component_id, simple_metadata_type, **kwargs):  # noqa: E501
        """Create multiple key-value pairs  # noqa: E501

        Sets all the specified key-value pairs.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_component_metadata(item_id, shape_id, component_id, simple_metadata_type, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str item_id: The item id. (required)
        :param str shape_id: The shape id. (required)
        :param str component_id: The component id. (required)
        :param SimpleMetadataType simple_metadata_type: (required)
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None.
                 If the method is called asynchronously, returns the request thread.
        :rtype: None or multiprocessing.pool.AsyncResult
        """
        kwargs['_return_http_data_only'] = True
        return self.update_component_metadata_with_http_info(item_id, shape_id, component_id, simple_metadata_type, **kwargs)  # noqa: E501

    def update_component_metadata_with_http_info(self, item_id, shape_id, component_id, simple_metadata_type, **kwargs):  # noqa: E501
        """Create multiple key-value pairs  # noqa: E501

        Sets all the specified key-value pairs.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_component_metadata_with_http_info(item_id, shape_id, component_id, simple_metadata_type, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str item_id: The item id. (required)
        :param str shape_id: The shape id. (required)
        :param str component_id: The component id. (required)
        :param SimpleMetadataType simple_metadata_type: (required)
        :key _return_http_data_only: response data without head status code
                                       and headers
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['item_id', 'shape_id', 'component_id', 'simple_metadata_type']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_component_metadata" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'item_id' is set
        if ('item_id' not in local_var_params or
                local_var_params['item_id'] is None):
            raise ApiValueError("Missing the required parameter `item_id` when calling `update_component_metadata`")  # noqa: E501
        # verify the required parameter 'shape_id' is set
        if ('shape_id' not in local_var_params or
                local_var_params['shape_id'] is None):
            raise ApiValueError("Missing the required parameter `shape_id` when calling `update_component_metadata`")  # noqa: E501
        # verify the required parameter 'component_id' is set
        if ('component_id' not in local_var_params or
                local_var_params['component_id'] is None):
            raise ApiValueError("Missing the required parameter `component_id` when calling `update_component_metadata`")  # noqa: E501
        # verify the required parameter 'simple_metadata_type' is set
        if ('simple_metadata_type' not in local_var_params or
                local_var_params['simple_metadata_type'] is None):
            raise ApiValueError("Missing the required parameter `simple_metadata_type` when calling `update_component_metadata`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'item_id' in local_var_params:
            path_params['item-id'] = local_var_params['item_id']  # noqa: E501
        if 'shape_id' in local_var_params:
            path_params['shape-id'] = local_var_params['shape_id']  # noqa: E501
        if 'component_id' in local_var_params:
            path_params['component-id'] = local_var_params['component_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'simple_metadata_type' in local_var_params:
            body_params = local_var_params['simple_metadata_type']
        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'application/xml'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/item/{item-id}/shape/{shape-id}/component/{component-id}/metadata', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_component_metadata_key(self, item_id, shape_id, component_id, keypath, body, **kwargs):  # noqa: E501
        """Set the value for a specific key  # noqa: E501

        Sets the value for a specific key. The key path may not contain wildcards.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_component_metadata_key(item_id, shape_id, component_id, keypath, body, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str item_id: The item id. (required)
        :param str shape_id: The shape id. (required)
        :param str component_id: The component id. (required)
        :param str keypath: The keypath. (required)
        :param str body: The raw string value. (required)
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None.
                 If the method is called asynchronously, returns the request thread.
        :rtype: None or multiprocessing.pool.AsyncResult
        """
        kwargs['_return_http_data_only'] = True
        return self.update_component_metadata_key_with_http_info(item_id, shape_id, component_id, keypath, body, **kwargs)  # noqa: E501

    def update_component_metadata_key_with_http_info(self, item_id, shape_id, component_id, keypath, body, **kwargs):  # noqa: E501
        """Set the value for a specific key  # noqa: E501

        Sets the value for a specific key. The key path may not contain wildcards.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_component_metadata_key_with_http_info(item_id, shape_id, component_id, keypath, body, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str item_id: The item id. (required)
        :param str shape_id: The shape id. (required)
        :param str component_id: The component id. (required)
        :param str keypath: The keypath. (required)
        :param str body: The raw string value. (required)
        :key _return_http_data_only: response data without head status code
                                       and headers
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['item_id', 'shape_id', 'component_id', 'keypath', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_component_metadata_key" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'item_id' is set
        if ('item_id' not in local_var_params or
                local_var_params['item_id'] is None):
            raise ApiValueError("Missing the required parameter `item_id` when calling `update_component_metadata_key`")  # noqa: E501
        # verify the required parameter 'shape_id' is set
        if ('shape_id' not in local_var_params or
                local_var_params['shape_id'] is None):
            raise ApiValueError("Missing the required parameter `shape_id` when calling `update_component_metadata_key`")  # noqa: E501
        # verify the required parameter 'component_id' is set
        if ('component_id' not in local_var_params or
                local_var_params['component_id'] is None):
            raise ApiValueError("Missing the required parameter `component_id` when calling `update_component_metadata_key`")  # noqa: E501
        # verify the required parameter 'keypath' is set
        if ('keypath' not in local_var_params or
                local_var_params['keypath'] is None):
            raise ApiValueError("Missing the required parameter `keypath` when calling `update_component_metadata_key`")  # noqa: E501
        # verify the required parameter 'body' is set
        if ('body' not in local_var_params or
                local_var_params['body'] is None):
            raise ApiValueError("Missing the required parameter `body` when calling `update_component_metadata_key`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'item_id' in local_var_params:
            path_params['item-id'] = local_var_params['item_id']  # noqa: E501
        if 'shape_id' in local_var_params:
            path_params['shape-id'] = local_var_params['shape_id']  # noqa: E501
        if 'component_id' in local_var_params:
            path_params['component-id'] = local_var_params['component_id']  # noqa: E501
        if 'keypath' in local_var_params:
            path_params['keypath'] = local_var_params['keypath']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in local_var_params:
            body_params = local_var_params['body']
        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['text/plain'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/item/{item-id}/shape/{shape-id}/component/{component-id}/metadata/{keypath}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_shape_metadata(self, item_id, shape_id, simple_metadata_type, **kwargs):  # noqa: E501
        """Create multiple key-value pairs  # noqa: E501

        Sets all the specified key-value pairs.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_shape_metadata(item_id, shape_id, simple_metadata_type, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str item_id: The item id. (required)
        :param str shape_id: The shape id. (required)
        :param SimpleMetadataType simple_metadata_type: (required)
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None.
                 If the method is called asynchronously, returns the request thread.
        :rtype: None or multiprocessing.pool.AsyncResult
        """
        kwargs['_return_http_data_only'] = True
        return self.update_shape_metadata_with_http_info(item_id, shape_id, simple_metadata_type, **kwargs)  # noqa: E501

    def update_shape_metadata_with_http_info(self, item_id, shape_id, simple_metadata_type, **kwargs):  # noqa: E501
        """Create multiple key-value pairs  # noqa: E501

        Sets all the specified key-value pairs.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_shape_metadata_with_http_info(item_id, shape_id, simple_metadata_type, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str item_id: The item id. (required)
        :param str shape_id: The shape id. (required)
        :param SimpleMetadataType simple_metadata_type: (required)
        :key _return_http_data_only: response data without head status code
                                       and headers
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['item_id', 'shape_id', 'simple_metadata_type']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_shape_metadata" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'item_id' is set
        if ('item_id' not in local_var_params or
                local_var_params['item_id'] is None):
            raise ApiValueError("Missing the required parameter `item_id` when calling `update_shape_metadata`")  # noqa: E501
        # verify the required parameter 'shape_id' is set
        if ('shape_id' not in local_var_params or
                local_var_params['shape_id'] is None):
            raise ApiValueError("Missing the required parameter `shape_id` when calling `update_shape_metadata`")  # noqa: E501
        # verify the required parameter 'simple_metadata_type' is set
        if ('simple_metadata_type' not in local_var_params or
                local_var_params['simple_metadata_type'] is None):
            raise ApiValueError("Missing the required parameter `simple_metadata_type` when calling `update_shape_metadata`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'item_id' in local_var_params:
            path_params['item-id'] = local_var_params['item_id']  # noqa: E501
        if 'shape_id' in local_var_params:
            path_params['shape-id'] = local_var_params['shape_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'simple_metadata_type' in local_var_params:
            body_params = local_var_params['simple_metadata_type']
        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'application/xml'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/item/{item-id}/shape/{shape-id}/metadata', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_shape_metadata_key(self, item_id, shape_id, keypath, body, **kwargs):  # noqa: E501
        """Set the value for a specific key  # noqa: E501

        Sets the value for a specific key. The key path may not contain wildcards.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_shape_metadata_key(item_id, shape_id, keypath, body, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str item_id: The item id. (required)
        :param str shape_id: The shape id. (required)
        :param str keypath: The keypath. (required)
        :param str body: The raw string value. (required)
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None.
                 If the method is called asynchronously, returns the request thread.
        :rtype: None or multiprocessing.pool.AsyncResult
        """
        kwargs['_return_http_data_only'] = True
        return self.update_shape_metadata_key_with_http_info(item_id, shape_id, keypath, body, **kwargs)  # noqa: E501

    def update_shape_metadata_key_with_http_info(self, item_id, shape_id, keypath, body, **kwargs):  # noqa: E501
        """Set the value for a specific key  # noqa: E501

        Sets the value for a specific key. The key path may not contain wildcards.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_shape_metadata_key_with_http_info(item_id, shape_id, keypath, body, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str item_id: The item id. (required)
        :param str shape_id: The shape id. (required)
        :param str keypath: The keypath. (required)
        :param str body: The raw string value. (required)
        :key _return_http_data_only: response data without head status code
                                       and headers
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['item_id', 'shape_id', 'keypath', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_shape_metadata_key" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'item_id' is set
        if ('item_id' not in local_var_params or
                local_var_params['item_id'] is None):
            raise ApiValueError("Missing the required parameter `item_id` when calling `update_shape_metadata_key`")  # noqa: E501
        # verify the required parameter 'shape_id' is set
        if ('shape_id' not in local_var_params or
                local_var_params['shape_id'] is None):
            raise ApiValueError("Missing the required parameter `shape_id` when calling `update_shape_metadata_key`")  # noqa: E501
        # verify the required parameter 'keypath' is set
        if ('keypath' not in local_var_params or
                local_var_params['keypath'] is None):
            raise ApiValueError("Missing the required parameter `keypath` when calling `update_shape_metadata_key`")  # noqa: E501
        # verify the required parameter 'body' is set
        if ('body' not in local_var_params or
                local_var_params['body'] is None):
            raise ApiValueError("Missing the required parameter `body` when calling `update_shape_metadata_key`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'item_id' in local_var_params:
            path_params['item-id'] = local_var_params['item_id']  # noqa: E501
        if 'shape_id' in local_var_params:
            path_params['shape-id'] = local_var_params['shape_id']  # noqa: E501
        if 'keypath' in local_var_params:
            path_params['keypath'] = local_var_params['keypath']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in local_var_params:
            body_params = local_var_params['body']
        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['text/plain'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/item/{item-id}/shape/{shape-id}/metadata/{keypath}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_shape_placeholder(self, id, shape_id, simple_metadata_type, **kwargs):  # noqa: E501
        """Update a placeholder shape  # noqa: E501

        Updates the expected number of container, video, audio and binary components for a specific placeholder shape.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_shape_placeholder(id, shape_id, simple_metadata_type, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str id: The id. (required)
        :param str shape_id: The shape id. (required)
        :param SimpleMetadataType simple_metadata_type: (required)
        :key str tag: Comma-separated shape tags to be added to the shape.
        :key int video: The number of video components
        :key int binary: The number of binary components
        :key int audio: The number of audio components
        :key int container: The number of container components
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None.
                 If the method is called asynchronously, returns the request thread.
        :rtype: None or multiprocessing.pool.AsyncResult
        """
        kwargs['_return_http_data_only'] = True
        return self.update_shape_placeholder_with_http_info(id, shape_id, simple_metadata_type, **kwargs)  # noqa: E501

    def update_shape_placeholder_with_http_info(self, id, shape_id, simple_metadata_type, **kwargs):  # noqa: E501
        """Update a placeholder shape  # noqa: E501

        Updates the expected number of container, video, audio and binary components for a specific placeholder shape.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_shape_placeholder_with_http_info(id, shape_id, simple_metadata_type, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str id: The id. (required)
        :param str shape_id: The shape id. (required)
        :param SimpleMetadataType simple_metadata_type: (required)
        :key str tag: Comma-separated shape tags to be added to the shape.
        :key int video: The number of video components
        :key int binary: The number of binary components
        :key int audio: The number of audio components
        :key int container: The number of container components
        :key _return_http_data_only: response data without head status code
                                       and headers
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['id', 'shape_id', 'simple_metadata_type', 'tag', 'video', 'binary', 'audio', 'container']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_shape_placeholder" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in local_var_params or
                local_var_params['id'] is None):
            raise ApiValueError("Missing the required parameter `id` when calling `update_shape_placeholder`")  # noqa: E501
        # verify the required parameter 'shape_id' is set
        if ('shape_id' not in local_var_params or
                local_var_params['shape_id'] is None):
            raise ApiValueError("Missing the required parameter `shape_id` when calling `update_shape_placeholder`")  # noqa: E501
        # verify the required parameter 'simple_metadata_type' is set
        if ('simple_metadata_type' not in local_var_params or
                local_var_params['simple_metadata_type'] is None):
            raise ApiValueError("Missing the required parameter `simple_metadata_type` when calling `update_shape_placeholder`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501
        if 'shape_id' in local_var_params:
            path_params['shape-id'] = local_var_params['shape_id']  # noqa: E501

        query_params = []
        if 'tag' in local_var_params:
            query_params.append(('tag', local_var_params['tag']))  # noqa: E501
        if 'video' in local_var_params:
            query_params.append(('video', local_var_params['video']))  # noqa: E501
        if 'binary' in local_var_params:
            query_params.append(('binary', local_var_params['binary']))  # noqa: E501
        if 'audio' in local_var_params:
            query_params.append(('audio', local_var_params['audio']))  # noqa: E501
        if 'container' in local_var_params:
            query_params.append(('container', local_var_params['container']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'simple_metadata_type' in local_var_params:
            body_params = local_var_params['simple_metadata_type']
        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'application/xml'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/item/{id}/shape/{shape-id}/placeholder', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)
