# coding: utf-8

"""
    Vidispine API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)  # noqa: E501

    The version of the OpenAPI document: 5.x
    Contact: info@vidispine.com
    Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from vidispine.models import *
from vidispine.api_client import ApiClient
from vidispine.exceptions import (
    ApiTypeError,
    ApiValueError
)


class ShapeTagApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def delete_shape_tag(self, tag_name, **kwargs):  # noqa: E501
        """Delete a shape tag  # noqa: E501

        Deletes a shape tag with the given tag name.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_shape_tag(tag_name, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str tag_name: The tag name. (required)
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None.
                 If the method is called asynchronously, returns the request thread.
        :rtype: None or multiprocessing.pool.AsyncResult
        """
        kwargs['_return_http_data_only'] = True
        return self.delete_shape_tag_with_http_info(tag_name, **kwargs)  # noqa: E501

    def delete_shape_tag_with_http_info(self, tag_name, **kwargs):  # noqa: E501
        """Delete a shape tag  # noqa: E501

        Deletes a shape tag with the given tag name.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_shape_tag_with_http_info(tag_name, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str tag_name: The tag name. (required)
        :key _return_http_data_only: response data without head status code
                                       and headers
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['tag_name']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_shape_tag" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'tag_name' is set
        if ('tag_name' not in local_var_params or
                local_var_params['tag_name'] is None):
            raise ApiValueError("Missing the required parameter `tag_name` when calling `delete_shape_tag`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'tag_name' in local_var_params:
            path_params['tag-name'] = local_var_params['tag_name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/shape-tag/{tag-name}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_shape_tag_metadata(self, tag_name, **kwargs):  # noqa: E501
        """Delete all key-value pairs  # noqa: E501

        Clears all key-value pairs for the specified entity.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_shape_tag_metadata(tag_name, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str tag_name: The tag name. (required)
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None.
                 If the method is called asynchronously, returns the request thread.
        :rtype: None or multiprocessing.pool.AsyncResult
        """
        kwargs['_return_http_data_only'] = True
        return self.delete_shape_tag_metadata_with_http_info(tag_name, **kwargs)  # noqa: E501

    def delete_shape_tag_metadata_with_http_info(self, tag_name, **kwargs):  # noqa: E501
        """Delete all key-value pairs  # noqa: E501

        Clears all key-value pairs for the specified entity.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_shape_tag_metadata_with_http_info(tag_name, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str tag_name: The tag name. (required)
        :key _return_http_data_only: response data without head status code
                                       and headers
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['tag_name']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_shape_tag_metadata" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'tag_name' is set
        if ('tag_name' not in local_var_params or
                local_var_params['tag_name'] is None):
            raise ApiValueError("Missing the required parameter `tag_name` when calling `delete_shape_tag_metadata`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'tag_name' in local_var_params:
            path_params['tag-name'] = local_var_params['tag_name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/shape-tag/{tag-name}/metadata', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_shape_tag_metadata_key(self, tag_name, keypath, **kwargs):  # noqa: E501
        """Delete key-value pairs  # noqa: E501

        Deletes the key-value pair with the specified key. If a key path is given, it may include wildcards for deleting multiple keys.  Key paths can also be specified as well as specific keys.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_shape_tag_metadata_key(tag_name, keypath, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str tag_name: The tag name. (required)
        :param str keypath: The keypath. (required)
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None.
                 If the method is called asynchronously, returns the request thread.
        :rtype: None or multiprocessing.pool.AsyncResult
        """
        kwargs['_return_http_data_only'] = True
        return self.delete_shape_tag_metadata_key_with_http_info(tag_name, keypath, **kwargs)  # noqa: E501

    def delete_shape_tag_metadata_key_with_http_info(self, tag_name, keypath, **kwargs):  # noqa: E501
        """Delete key-value pairs  # noqa: E501

        Deletes the key-value pair with the specified key. If a key path is given, it may include wildcards for deleting multiple keys.  Key paths can also be specified as well as specific keys.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_shape_tag_metadata_key_with_http_info(tag_name, keypath, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str tag_name: The tag name. (required)
        :param str keypath: The keypath. (required)
        :key _return_http_data_only: response data without head status code
                                       and headers
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['tag_name', 'keypath']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_shape_tag_metadata_key" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'tag_name' is set
        if ('tag_name' not in local_var_params or
                local_var_params['tag_name'] is None):
            raise ApiValueError("Missing the required parameter `tag_name` when calling `delete_shape_tag_metadata_key`")  # noqa: E501
        # verify the required parameter 'keypath' is set
        if ('keypath' not in local_var_params or
                local_var_params['keypath'] is None):
            raise ApiValueError("Missing the required parameter `keypath` when calling `delete_shape_tag_metadata_key`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'tag_name' in local_var_params:
            path_params['tag-name'] = local_var_params['tag_name']  # noqa: E501
        if 'keypath' in local_var_params:
            path_params['keypath'] = local_var_params['keypath']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/shape-tag/{tag-name}/metadata/{keypath}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_shape_tag_script(self, tag_name, **kwargs):  # noqa: E501
        """Remove the script for a shape tag  # noqa: E501

        Unsets the script for the shape tag.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_shape_tag_script(tag_name, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str tag_name: The tag name. (required)
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None.
                 If the method is called asynchronously, returns the request thread.
        :rtype: None or multiprocessing.pool.AsyncResult
        """
        kwargs['_return_http_data_only'] = True
        return self.delete_shape_tag_script_with_http_info(tag_name, **kwargs)  # noqa: E501

    def delete_shape_tag_script_with_http_info(self, tag_name, **kwargs):  # noqa: E501
        """Remove the script for a shape tag  # noqa: E501

        Unsets the script for the shape tag.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_shape_tag_script_with_http_info(tag_name, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str tag_name: The tag name. (required)
        :key _return_http_data_only: response data without head status code
                                       and headers
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['tag_name']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_shape_tag_script" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'tag_name' is set
        if ('tag_name' not in local_var_params or
                local_var_params['tag_name'] is None):
            raise ApiValueError("Missing the required parameter `tag_name` when calling `delete_shape_tag_script`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'tag_name' in local_var_params:
            path_params['tag-name'] = local_var_params['tag_name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/shape-tag/{tag-name}/script', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_all_shape_tags(self, **kwargs):  # noqa: E501
        """List all shape tags  # noqa: E501

        Retrieves all shape tags known by the system.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_all_shape_tags(async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :key bool url: - `true` - Return list of URLs.  - `false` (default) - Return list of ids.
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: URIListType.
                 If the method is called asynchronously, returns the request thread.
        :rtype: URIListType or multiprocessing.pool.AsyncResult
        """
        kwargs['_return_http_data_only'] = True
        return self.get_all_shape_tags_with_http_info(**kwargs)  # noqa: E501

    def get_all_shape_tags_with_http_info(self, **kwargs):  # noqa: E501
        """List all shape tags  # noqa: E501

        Retrieves all shape tags known by the system.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_all_shape_tags_with_http_info(async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :key bool url: - `true` - Return list of URLs.  - `false` (default) - Return list of ids.
        :key _return_http_data_only: response data without head status code
                                       and headers
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(URIListType, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['url']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_all_shape_tags" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'url' in local_var_params:
            query_params.append(('url', local_var_params['url']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'text/plain', 'application/xml'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/shape-tag/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='URIListType',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_shape_tag(self, tag_name, **kwargs):  # noqa: E501
        """Retrieve a shape tag  # noqa: E501

        Retrieves the transcode preset of shape tag with the given tag name.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_shape_tag(tag_name, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str tag_name: The tag name. (required)
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: TranscodePresetType.
                 If the method is called asynchronously, returns the request thread.
        :rtype: TranscodePresetType or multiprocessing.pool.AsyncResult
        """
        kwargs['_return_http_data_only'] = True
        return self.get_shape_tag_with_http_info(tag_name, **kwargs)  # noqa: E501

    def get_shape_tag_with_http_info(self, tag_name, **kwargs):  # noqa: E501
        """Retrieve a shape tag  # noqa: E501

        Retrieves the transcode preset of shape tag with the given tag name.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_shape_tag_with_http_info(tag_name, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str tag_name: The tag name. (required)
        :key _return_http_data_only: response data without head status code
                                       and headers
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(TranscodePresetType, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['tag_name']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_shape_tag" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'tag_name' is set
        if ('tag_name' not in local_var_params or
                local_var_params['tag_name'] is None):
            raise ApiValueError("Missing the required parameter `tag_name` when calling `get_shape_tag`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'tag_name' in local_var_params:
            path_params['tag-name'] = local_var_params['tag_name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'application/xml'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/shape-tag/{tag-name}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='TranscodePresetType',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_shape_tag_metadata(self, tag_name, **kwargs):  # noqa: E501
        """Retrieve all metadata  # noqa: E501

        Retrieves all key-value pairs associated with the specified entity.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_shape_tag_metadata(tag_name, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str tag_name: The tag name. (required)
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: SimpleMetadataType.
                 If the method is called asynchronously, returns the request thread.
        :rtype: SimpleMetadataType or multiprocessing.pool.AsyncResult
        """
        kwargs['_return_http_data_only'] = True
        return self.get_shape_tag_metadata_with_http_info(tag_name, **kwargs)  # noqa: E501

    def get_shape_tag_metadata_with_http_info(self, tag_name, **kwargs):  # noqa: E501
        """Retrieve all metadata  # noqa: E501

        Retrieves all key-value pairs associated with the specified entity.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_shape_tag_metadata_with_http_info(tag_name, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str tag_name: The tag name. (required)
        :key _return_http_data_only: response data without head status code
                                       and headers
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(SimpleMetadataType, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['tag_name']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_shape_tag_metadata" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'tag_name' is set
        if ('tag_name' not in local_var_params or
                local_var_params['tag_name'] is None):
            raise ApiValueError("Missing the required parameter `tag_name` when calling `get_shape_tag_metadata`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'tag_name' in local_var_params:
            path_params['tag-name'] = local_var_params['tag_name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'application/xml'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/shape-tag/{tag-name}/metadata', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SimpleMetadataType',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_shape_tag_metadata_key(self, tag_name, keypath, **kwargs):  # noqa: E501
        """Retrieve the metadata for a specific key  # noqa: E501

        Retrieves the value of a specific key. If a key path is specified, exactly one key-value pair must match the key path, else an error is returned.  Key paths can also be specified as well as specific keys.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_shape_tag_metadata_key(tag_name, keypath, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str tag_name: The tag name. (required)
        :param str keypath: The keypath. (required)
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: str.
                 If the method is called asynchronously, returns the request thread.
        :rtype: str or multiprocessing.pool.AsyncResult
        """
        kwargs['_return_http_data_only'] = True
        return self.get_shape_tag_metadata_key_with_http_info(tag_name, keypath, **kwargs)  # noqa: E501

    def get_shape_tag_metadata_key_with_http_info(self, tag_name, keypath, **kwargs):  # noqa: E501
        """Retrieve the metadata for a specific key  # noqa: E501

        Retrieves the value of a specific key. If a key path is specified, exactly one key-value pair must match the key path, else an error is returned.  Key paths can also be specified as well as specific keys.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_shape_tag_metadata_key_with_http_info(tag_name, keypath, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str tag_name: The tag name. (required)
        :param str keypath: The keypath. (required)
        :key _return_http_data_only: response data without head status code
                                       and headers
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(str, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['tag_name', 'keypath']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_shape_tag_metadata_key" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'tag_name' is set
        if ('tag_name' not in local_var_params or
                local_var_params['tag_name'] is None):
            raise ApiValueError("Missing the required parameter `tag_name` when calling `get_shape_tag_metadata_key`")  # noqa: E501
        # verify the required parameter 'keypath' is set
        if ('keypath' not in local_var_params or
                local_var_params['keypath'] is None):
            raise ApiValueError("Missing the required parameter `keypath` when calling `get_shape_tag_metadata_key`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'tag_name' in local_var_params:
            path_params['tag-name'] = local_var_params['tag_name']  # noqa: E501
        if 'keypath' in local_var_params:
            path_params['keypath'] = local_var_params['keypath']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/shape-tag/{tag-name}/metadata/{keypath}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='str',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_shape_tag_script(self, tag_name, **kwargs):  # noqa: E501
        """Retrieve the script for a shape tag  # noqa: E501

        Retrieves the script of the shape tag.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_shape_tag_script(tag_name, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str tag_name: The tag name. (required)
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: str.
                 If the method is called asynchronously, returns the request thread.
        :rtype: str or multiprocessing.pool.AsyncResult
        """
        kwargs['_return_http_data_only'] = True
        return self.get_shape_tag_script_with_http_info(tag_name, **kwargs)  # noqa: E501

    def get_shape_tag_script_with_http_info(self, tag_name, **kwargs):  # noqa: E501
        """Retrieve the script for a shape tag  # noqa: E501

        Retrieves the script of the shape tag.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_shape_tag_script_with_http_info(tag_name, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str tag_name: The tag name. (required)
        :key _return_http_data_only: response data without head status code
                                       and headers
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(str, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['tag_name']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_shape_tag_script" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'tag_name' is set
        if ('tag_name' not in local_var_params or
                local_var_params['tag_name'] is None):
            raise ApiValueError("Missing the required parameter `tag_name` when calling `get_shape_tag_script`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'tag_name' in local_var_params:
            path_params['tag-name'] = local_var_params['tag_name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/javascript'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/shape-tag/{tag-name}/script', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='str',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def test_shape_tag_script(self, tag_name, item_id, shape_id, **kwargs):  # noqa: E501
        """Test a script  # noqa: E501

        Tests the script of the shape tag with the specified shape as input and returns the resulting preset.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.test_shape_tag_script(tag_name, item_id, shape_id, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str tag_name: The tag name. (required)
        :param str item_id: The item id. (required)
        :param str shape_id: The shape id. (required)
        :key str job: The id of a job to retrieve job metadata from.
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: TranscodePresetType.
                 If the method is called asynchronously, returns the request thread.
        :rtype: TranscodePresetType or multiprocessing.pool.AsyncResult
        """
        kwargs['_return_http_data_only'] = True
        return self.test_shape_tag_script_with_http_info(tag_name, item_id, shape_id, **kwargs)  # noqa: E501

    def test_shape_tag_script_with_http_info(self, tag_name, item_id, shape_id, **kwargs):  # noqa: E501
        """Test a script  # noqa: E501

        Tests the script of the shape tag with the specified shape as input and returns the resulting preset.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.test_shape_tag_script_with_http_info(tag_name, item_id, shape_id, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str tag_name: The tag name. (required)
        :param str item_id: The item id. (required)
        :param str shape_id: The shape id. (required)
        :key str job: The id of a job to retrieve job metadata from.
        :key _return_http_data_only: response data without head status code
                                       and headers
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(TranscodePresetType, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['tag_name', 'item_id', 'shape_id', 'job']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method test_shape_tag_script" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'tag_name' is set
        if ('tag_name' not in local_var_params or
                local_var_params['tag_name'] is None):
            raise ApiValueError("Missing the required parameter `tag_name` when calling `test_shape_tag_script`")  # noqa: E501
        # verify the required parameter 'item_id' is set
        if ('item_id' not in local_var_params or
                local_var_params['item_id'] is None):
            raise ApiValueError("Missing the required parameter `item_id` when calling `test_shape_tag_script`")  # noqa: E501
        # verify the required parameter 'shape_id' is set
        if ('shape_id' not in local_var_params or
                local_var_params['shape_id'] is None):
            raise ApiValueError("Missing the required parameter `shape_id` when calling `test_shape_tag_script`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'tag_name' in local_var_params:
            path_params['tag-name'] = local_var_params['tag_name']  # noqa: E501
        if 'item_id' in local_var_params:
            path_params['item-id'] = local_var_params['item_id']  # noqa: E501
        if 'shape_id' in local_var_params:
            path_params['shape-id'] = local_var_params['shape_id']  # noqa: E501

        query_params = []
        if 'job' in local_var_params:
            query_params.append(('job', local_var_params['job']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'application/xml'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/shape-tag/{tag-name}/item/{item-id}/shape/{shape-id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='TranscodePresetType',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_or_create_shape_tag(self, tag_name, transcode_preset_type, **kwargs):  # noqa: E501
        """Update or create a shape tag  # noqa: E501

        Creates a new shape tag with the given tag name. If the tag already exists, its transcode preset will be updated.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_or_create_shape_tag(tag_name, transcode_preset_type, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str tag_name: The tag name. (required)
        :param TranscodePresetType transcode_preset_type: (required)
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None.
                 If the method is called asynchronously, returns the request thread.
        :rtype: None or multiprocessing.pool.AsyncResult
        """
        kwargs['_return_http_data_only'] = True
        return self.update_or_create_shape_tag_with_http_info(tag_name, transcode_preset_type, **kwargs)  # noqa: E501

    def update_or_create_shape_tag_with_http_info(self, tag_name, transcode_preset_type, **kwargs):  # noqa: E501
        """Update or create a shape tag  # noqa: E501

        Creates a new shape tag with the given tag name. If the tag already exists, its transcode preset will be updated.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_or_create_shape_tag_with_http_info(tag_name, transcode_preset_type, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str tag_name: The tag name. (required)
        :param TranscodePresetType transcode_preset_type: (required)
        :key _return_http_data_only: response data without head status code
                                       and headers
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['tag_name', 'transcode_preset_type']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_or_create_shape_tag" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'tag_name' is set
        if ('tag_name' not in local_var_params or
                local_var_params['tag_name'] is None):
            raise ApiValueError("Missing the required parameter `tag_name` when calling `update_or_create_shape_tag`")  # noqa: E501
        # verify the required parameter 'transcode_preset_type' is set
        if ('transcode_preset_type' not in local_var_params or
                local_var_params['transcode_preset_type'] is None):
            raise ApiValueError("Missing the required parameter `transcode_preset_type` when calling `update_or_create_shape_tag`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'tag_name' in local_var_params:
            path_params['tag-name'] = local_var_params['tag_name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'transcode_preset_type' in local_var_params:
            body_params = local_var_params['transcode_preset_type']
        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'application/xml'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/shape-tag/{tag-name}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_or_create_shape_tag_script(self, tag_name, body, **kwargs):  # noqa: E501
        """Update or create the script for a shape tag  # noqa: E501

        Sets a script for the shape tag.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_or_create_shape_tag_script(tag_name, body, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str tag_name: The tag name. (required)
        :param str body: A JavaScript (required)
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None.
                 If the method is called asynchronously, returns the request thread.
        :rtype: None or multiprocessing.pool.AsyncResult
        """
        kwargs['_return_http_data_only'] = True
        return self.update_or_create_shape_tag_script_with_http_info(tag_name, body, **kwargs)  # noqa: E501

    def update_or_create_shape_tag_script_with_http_info(self, tag_name, body, **kwargs):  # noqa: E501
        """Update or create the script for a shape tag  # noqa: E501

        Sets a script for the shape tag.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_or_create_shape_tag_script_with_http_info(tag_name, body, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str tag_name: The tag name. (required)
        :param str body: A JavaScript (required)
        :key _return_http_data_only: response data without head status code
                                       and headers
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['tag_name', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_or_create_shape_tag_script" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'tag_name' is set
        if ('tag_name' not in local_var_params or
                local_var_params['tag_name'] is None):
            raise ApiValueError("Missing the required parameter `tag_name` when calling `update_or_create_shape_tag_script`")  # noqa: E501
        # verify the required parameter 'body' is set
        if ('body' not in local_var_params or
                local_var_params['body'] is None):
            raise ApiValueError("Missing the required parameter `body` when calling `update_or_create_shape_tag_script`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'tag_name' in local_var_params:
            path_params['tag-name'] = local_var_params['tag_name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in local_var_params:
            body_params = local_var_params['body']
        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/javascript'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/shape-tag/{tag-name}/script', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_shape_tag_metadata(self, tag_name, simple_metadata_type, **kwargs):  # noqa: E501
        """Create multiple key-value pairs  # noqa: E501

        Sets all the specified key-value pairs.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_shape_tag_metadata(tag_name, simple_metadata_type, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str tag_name: The tag name. (required)
        :param SimpleMetadataType simple_metadata_type: (required)
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None.
                 If the method is called asynchronously, returns the request thread.
        :rtype: None or multiprocessing.pool.AsyncResult
        """
        kwargs['_return_http_data_only'] = True
        return self.update_shape_tag_metadata_with_http_info(tag_name, simple_metadata_type, **kwargs)  # noqa: E501

    def update_shape_tag_metadata_with_http_info(self, tag_name, simple_metadata_type, **kwargs):  # noqa: E501
        """Create multiple key-value pairs  # noqa: E501

        Sets all the specified key-value pairs.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_shape_tag_metadata_with_http_info(tag_name, simple_metadata_type, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str tag_name: The tag name. (required)
        :param SimpleMetadataType simple_metadata_type: (required)
        :key _return_http_data_only: response data without head status code
                                       and headers
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['tag_name', 'simple_metadata_type']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_shape_tag_metadata" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'tag_name' is set
        if ('tag_name' not in local_var_params or
                local_var_params['tag_name'] is None):
            raise ApiValueError("Missing the required parameter `tag_name` when calling `update_shape_tag_metadata`")  # noqa: E501
        # verify the required parameter 'simple_metadata_type' is set
        if ('simple_metadata_type' not in local_var_params or
                local_var_params['simple_metadata_type'] is None):
            raise ApiValueError("Missing the required parameter `simple_metadata_type` when calling `update_shape_tag_metadata`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'tag_name' in local_var_params:
            path_params['tag-name'] = local_var_params['tag_name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'simple_metadata_type' in local_var_params:
            body_params = local_var_params['simple_metadata_type']
        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'application/xml'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/shape-tag/{tag-name}/metadata', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_shape_tag_metadata_key(self, tag_name, keypath, body, **kwargs):  # noqa: E501
        """Set the value for a specific key  # noqa: E501

        Sets the value for a specific key. The key path may not contain wildcards.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_shape_tag_metadata_key(tag_name, keypath, body, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str tag_name: The tag name. (required)
        :param str keypath: The keypath. (required)
        :param str body: The raw string value. (required)
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None.
                 If the method is called asynchronously, returns the request thread.
        :rtype: None or multiprocessing.pool.AsyncResult
        """
        kwargs['_return_http_data_only'] = True
        return self.update_shape_tag_metadata_key_with_http_info(tag_name, keypath, body, **kwargs)  # noqa: E501

    def update_shape_tag_metadata_key_with_http_info(self, tag_name, keypath, body, **kwargs):  # noqa: E501
        """Set the value for a specific key  # noqa: E501

        Sets the value for a specific key. The key path may not contain wildcards.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_shape_tag_metadata_key_with_http_info(tag_name, keypath, body, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str tag_name: The tag name. (required)
        :param str keypath: The keypath. (required)
        :param str body: The raw string value. (required)
        :key _return_http_data_only: response data without head status code
                                       and headers
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['tag_name', 'keypath', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_shape_tag_metadata_key" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'tag_name' is set
        if ('tag_name' not in local_var_params or
                local_var_params['tag_name'] is None):
            raise ApiValueError("Missing the required parameter `tag_name` when calling `update_shape_tag_metadata_key`")  # noqa: E501
        # verify the required parameter 'keypath' is set
        if ('keypath' not in local_var_params or
                local_var_params['keypath'] is None):
            raise ApiValueError("Missing the required parameter `keypath` when calling `update_shape_tag_metadata_key`")  # noqa: E501
        # verify the required parameter 'body' is set
        if ('body' not in local_var_params or
                local_var_params['body'] is None):
            raise ApiValueError("Missing the required parameter `body` when calling `update_shape_tag_metadata_key`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'tag_name' in local_var_params:
            path_params['tag-name'] = local_var_params['tag_name']  # noqa: E501
        if 'keypath' in local_var_params:
            path_params['keypath'] = local_var_params['keypath']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in local_var_params:
            body_params = local_var_params['body']
        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['text/plain'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/shape-tag/{tag-name}/metadata/{keypath}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)
