# coding: utf-8

"""
    Vidispine API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)  # noqa: E501

    The version of the OpenAPI document: 5.x
    Contact: info@vidispine.com
    Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from vidispine.models import *
from vidispine.api_client import ApiClient
from vidispine.exceptions import (
    ApiTypeError,
    ApiValueError
)


class StorageMethodApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def delete_storage_method(self, storage_id, method_id, **kwargs):  # noqa: E501
        """Delete a storage method  # noqa: E501

        Removes an access method from a storage.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_storage_method(storage_id, method_id, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str storage_id: The storage id. (required)
        :param str method_id: The method id. (required)
        :key str url: Method is accessed through this URL
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None.
                 If the method is called asynchronously, returns the request thread.
        :rtype: None or multiprocessing.pool.AsyncResult
        """
        kwargs['_return_http_data_only'] = True
        return self.delete_storage_method_with_http_info(storage_id, method_id, **kwargs)  # noqa: E501

    def delete_storage_method_with_http_info(self, storage_id, method_id, **kwargs):  # noqa: E501
        """Delete a storage method  # noqa: E501

        Removes an access method from a storage.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_storage_method_with_http_info(storage_id, method_id, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str storage_id: The storage id. (required)
        :param str method_id: The method id. (required)
        :key str url: Method is accessed through this URL
        :key _return_http_data_only: response data without head status code
                                       and headers
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['storage_id', 'method_id', 'url']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_storage_method" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'storage_id' is set
        if ('storage_id' not in local_var_params or
                local_var_params['storage_id'] is None):
            raise ApiValueError("Missing the required parameter `storage_id` when calling `delete_storage_method`")  # noqa: E501
        # verify the required parameter 'method_id' is set
        if ('method_id' not in local_var_params or
                local_var_params['method_id'] is None):
            raise ApiValueError("Missing the required parameter `method_id` when calling `delete_storage_method`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'storage_id' in local_var_params:
            path_params['storage-id'] = local_var_params['storage_id']  # noqa: E501
        if 'method_id' in local_var_params:
            path_params['method-id'] = local_var_params['method_id']  # noqa: E501

        query_params = []
        if 'url' in local_var_params:
            query_params.append(('url', local_var_params['url']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/storage/{storage-id}/method/{method-id}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_storage_method_metadata(self, storage_id, method_id, **kwargs):  # noqa: E501
        """Delete all key-value pairs  # noqa: E501

        Clears all key-value pairs for the specified entity.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_storage_method_metadata(storage_id, method_id, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str storage_id: The storage id. (required)
        :param str method_id: The method id. (required)
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None.
                 If the method is called asynchronously, returns the request thread.
        :rtype: None or multiprocessing.pool.AsyncResult
        """
        kwargs['_return_http_data_only'] = True
        return self.delete_storage_method_metadata_with_http_info(storage_id, method_id, **kwargs)  # noqa: E501

    def delete_storage_method_metadata_with_http_info(self, storage_id, method_id, **kwargs):  # noqa: E501
        """Delete all key-value pairs  # noqa: E501

        Clears all key-value pairs for the specified entity.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_storage_method_metadata_with_http_info(storage_id, method_id, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str storage_id: The storage id. (required)
        :param str method_id: The method id. (required)
        :key _return_http_data_only: response data without head status code
                                       and headers
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['storage_id', 'method_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_storage_method_metadata" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'storage_id' is set
        if ('storage_id' not in local_var_params or
                local_var_params['storage_id'] is None):
            raise ApiValueError("Missing the required parameter `storage_id` when calling `delete_storage_method_metadata`")  # noqa: E501
        # verify the required parameter 'method_id' is set
        if ('method_id' not in local_var_params or
                local_var_params['method_id'] is None):
            raise ApiValueError("Missing the required parameter `method_id` when calling `delete_storage_method_metadata`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'storage_id' in local_var_params:
            path_params['storage-id'] = local_var_params['storage_id']  # noqa: E501
        if 'method_id' in local_var_params:
            path_params['method-id'] = local_var_params['method_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/storage/{storage-id}/method/{method-id}/metadata', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_storage_method_metadata_key(self, storage_id, method_id, keypath, **kwargs):  # noqa: E501
        """Delete key-value pairs  # noqa: E501

        Deletes the key-value pair with the specified key. If a key path is given, it may include wildcards for deleting multiple keys.  Key paths can also be specified as well as specific keys.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_storage_method_metadata_key(storage_id, method_id, keypath, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str storage_id: The storage id. (required)
        :param str method_id: The method id. (required)
        :param str keypath: The keypath. (required)
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None.
                 If the method is called asynchronously, returns the request thread.
        :rtype: None or multiprocessing.pool.AsyncResult
        """
        kwargs['_return_http_data_only'] = True
        return self.delete_storage_method_metadata_key_with_http_info(storage_id, method_id, keypath, **kwargs)  # noqa: E501

    def delete_storage_method_metadata_key_with_http_info(self, storage_id, method_id, keypath, **kwargs):  # noqa: E501
        """Delete key-value pairs  # noqa: E501

        Deletes the key-value pair with the specified key. If a key path is given, it may include wildcards for deleting multiple keys.  Key paths can also be specified as well as specific keys.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_storage_method_metadata_key_with_http_info(storage_id, method_id, keypath, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str storage_id: The storage id. (required)
        :param str method_id: The method id. (required)
        :param str keypath: The keypath. (required)
        :key _return_http_data_only: response data without head status code
                                       and headers
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['storage_id', 'method_id', 'keypath']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_storage_method_metadata_key" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'storage_id' is set
        if ('storage_id' not in local_var_params or
                local_var_params['storage_id'] is None):
            raise ApiValueError("Missing the required parameter `storage_id` when calling `delete_storage_method_metadata_key`")  # noqa: E501
        # verify the required parameter 'method_id' is set
        if ('method_id' not in local_var_params or
                local_var_params['method_id'] is None):
            raise ApiValueError("Missing the required parameter `method_id` when calling `delete_storage_method_metadata_key`")  # noqa: E501
        # verify the required parameter 'keypath' is set
        if ('keypath' not in local_var_params or
                local_var_params['keypath'] is None):
            raise ApiValueError("Missing the required parameter `keypath` when calling `delete_storage_method_metadata_key`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'storage_id' in local_var_params:
            path_params['storage-id'] = local_var_params['storage_id']  # noqa: E501
        if 'method_id' in local_var_params:
            path_params['method-id'] = local_var_params['method_id']  # noqa: E501
        if 'keypath' in local_var_params:
            path_params['keypath'] = local_var_params['keypath']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/storage/{storage-id}/method/{method-id}/metadata/{keypath}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_storage_method(self, storage_id, method_id, **kwargs):  # noqa: E501
        """Retrieve a storage method  # noqa: E501

        Retrieves a specific access method to storage.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_storage_method(storage_id, method_id, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str storage_id: The storage id. (required)
        :param str method_id: The method id. (required)
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: StorageMethodListType.
                 If the method is called asynchronously, returns the request thread.
        :rtype: StorageMethodListType or multiprocessing.pool.AsyncResult
        """
        kwargs['_return_http_data_only'] = True
        return self.get_storage_method_with_http_info(storage_id, method_id, **kwargs)  # noqa: E501

    def get_storage_method_with_http_info(self, storage_id, method_id, **kwargs):  # noqa: E501
        """Retrieve a storage method  # noqa: E501

        Retrieves a specific access method to storage.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_storage_method_with_http_info(storage_id, method_id, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str storage_id: The storage id. (required)
        :param str method_id: The method id. (required)
        :key _return_http_data_only: response data without head status code
                                       and headers
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(StorageMethodListType, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['storage_id', 'method_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_storage_method" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'storage_id' is set
        if ('storage_id' not in local_var_params or
                local_var_params['storage_id'] is None):
            raise ApiValueError("Missing the required parameter `storage_id` when calling `get_storage_method`")  # noqa: E501
        # verify the required parameter 'method_id' is set
        if ('method_id' not in local_var_params or
                local_var_params['method_id'] is None):
            raise ApiValueError("Missing the required parameter `method_id` when calling `get_storage_method`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'storage_id' in local_var_params:
            path_params['storage-id'] = local_var_params['storage_id']  # noqa: E501
        if 'method_id' in local_var_params:
            path_params['method-id'] = local_var_params['method_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'application/xml'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/storage/{storage-id}/method/{method-id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='StorageMethodListType',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_storage_method_metadata(self, storage_id, method_id, **kwargs):  # noqa: E501
        """Retrieve all metadata  # noqa: E501

        Retrieves all key-value pairs associated with the specified entity.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_storage_method_metadata(storage_id, method_id, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str storage_id: The storage id. (required)
        :param str method_id: The method id. (required)
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: SimpleMetadataType.
                 If the method is called asynchronously, returns the request thread.
        :rtype: SimpleMetadataType or multiprocessing.pool.AsyncResult
        """
        kwargs['_return_http_data_only'] = True
        return self.get_storage_method_metadata_with_http_info(storage_id, method_id, **kwargs)  # noqa: E501

    def get_storage_method_metadata_with_http_info(self, storage_id, method_id, **kwargs):  # noqa: E501
        """Retrieve all metadata  # noqa: E501

        Retrieves all key-value pairs associated with the specified entity.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_storage_method_metadata_with_http_info(storage_id, method_id, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str storage_id: The storage id. (required)
        :param str method_id: The method id. (required)
        :key _return_http_data_only: response data without head status code
                                       and headers
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(SimpleMetadataType, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['storage_id', 'method_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_storage_method_metadata" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'storage_id' is set
        if ('storage_id' not in local_var_params or
                local_var_params['storage_id'] is None):
            raise ApiValueError("Missing the required parameter `storage_id` when calling `get_storage_method_metadata`")  # noqa: E501
        # verify the required parameter 'method_id' is set
        if ('method_id' not in local_var_params or
                local_var_params['method_id'] is None):
            raise ApiValueError("Missing the required parameter `method_id` when calling `get_storage_method_metadata`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'storage_id' in local_var_params:
            path_params['storage-id'] = local_var_params['storage_id']  # noqa: E501
        if 'method_id' in local_var_params:
            path_params['method-id'] = local_var_params['method_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'application/xml'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/storage/{storage-id}/method/{method-id}/metadata', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SimpleMetadataType',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_storage_method_metadata_key(self, storage_id, method_id, keypath, **kwargs):  # noqa: E501
        """Retrieve the metadata for a specific key  # noqa: E501

        Retrieves the value of a specific key. If a key path is specified, exactly one key-value pair must match the key path, else an error is returned.  Key paths can also be specified as well as specific keys.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_storage_method_metadata_key(storage_id, method_id, keypath, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str storage_id: The storage id. (required)
        :param str method_id: The method id. (required)
        :param str keypath: The keypath. (required)
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: str.
                 If the method is called asynchronously, returns the request thread.
        :rtype: str or multiprocessing.pool.AsyncResult
        """
        kwargs['_return_http_data_only'] = True
        return self.get_storage_method_metadata_key_with_http_info(storage_id, method_id, keypath, **kwargs)  # noqa: E501

    def get_storage_method_metadata_key_with_http_info(self, storage_id, method_id, keypath, **kwargs):  # noqa: E501
        """Retrieve the metadata for a specific key  # noqa: E501

        Retrieves the value of a specific key. If a key path is specified, exactly one key-value pair must match the key path, else an error is returned.  Key paths can also be specified as well as specific keys.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_storage_method_metadata_key_with_http_info(storage_id, method_id, keypath, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str storage_id: The storage id. (required)
        :param str method_id: The method id. (required)
        :param str keypath: The keypath. (required)
        :key _return_http_data_only: response data without head status code
                                       and headers
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(str, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['storage_id', 'method_id', 'keypath']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_storage_method_metadata_key" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'storage_id' is set
        if ('storage_id' not in local_var_params or
                local_var_params['storage_id'] is None):
            raise ApiValueError("Missing the required parameter `storage_id` when calling `get_storage_method_metadata_key`")  # noqa: E501
        # verify the required parameter 'method_id' is set
        if ('method_id' not in local_var_params or
                local_var_params['method_id'] is None):
            raise ApiValueError("Missing the required parameter `method_id` when calling `get_storage_method_metadata_key`")  # noqa: E501
        # verify the required parameter 'keypath' is set
        if ('keypath' not in local_var_params or
                local_var_params['keypath'] is None):
            raise ApiValueError("Missing the required parameter `keypath` when calling `get_storage_method_metadata_key`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'storage_id' in local_var_params:
            path_params['storage-id'] = local_var_params['storage_id']  # noqa: E501
        if 'method_id' in local_var_params:
            path_params['method-id'] = local_var_params['method_id']  # noqa: E501
        if 'keypath' in local_var_params:
            path_params['keypath'] = local_var_params['keypath']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/storage/{storage-id}/method/{method-id}/metadata/{keypath}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='str',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_storage_methods(self, storage_id, **kwargs):  # noqa: E501
        """List storage methods  # noqa: E501

        Retrieves the access methods configured on a specific storage.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_storage_methods(storage_id, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str storage_id: The storage id. (required)
        :key bool browse: - `true` - Only return methods which have file browse capability.  - `false` (default) - Return methods regardless of file browse capability.
        :key bool write: - `true` - Only return methods which have file write capability.  - `false` (default) - Return methods regardless of file write capability.
        :key str url: Only return methods with this URL.  Wildcards (`?`, `*`) can be used, for example `http:*`.
        :key bool read: - `true` - Only return methods which have file read capability.  - `false` (default) - Return methods regardless of file read capability.
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: StorageMethodListType.
                 If the method is called asynchronously, returns the request thread.
        :rtype: StorageMethodListType or multiprocessing.pool.AsyncResult
        """
        kwargs['_return_http_data_only'] = True
        return self.get_storage_methods_with_http_info(storage_id, **kwargs)  # noqa: E501

    def get_storage_methods_with_http_info(self, storage_id, **kwargs):  # noqa: E501
        """List storage methods  # noqa: E501

        Retrieves the access methods configured on a specific storage.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_storage_methods_with_http_info(storage_id, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str storage_id: The storage id. (required)
        :key bool browse: - `true` - Only return methods which have file browse capability.  - `false` (default) - Return methods regardless of file browse capability.
        :key bool write: - `true` - Only return methods which have file write capability.  - `false` (default) - Return methods regardless of file write capability.
        :key str url: Only return methods with this URL.  Wildcards (`?`, `*`) can be used, for example `http:*`.
        :key bool read: - `true` - Only return methods which have file read capability.  - `false` (default) - Return methods regardless of file read capability.
        :key _return_http_data_only: response data without head status code
                                       and headers
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(StorageMethodListType, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['storage_id', 'browse', 'write', 'url', 'read']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_storage_methods" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'storage_id' is set
        if ('storage_id' not in local_var_params or
                local_var_params['storage_id'] is None):
            raise ApiValueError("Missing the required parameter `storage_id` when calling `get_storage_methods`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'storage_id' in local_var_params:
            path_params['storage-id'] = local_var_params['storage_id']  # noqa: E501

        query_params = []
        if 'browse' in local_var_params:
            query_params.append(('browse', local_var_params['browse']))  # noqa: E501
        if 'write' in local_var_params:
            query_params.append(('write', local_var_params['write']))  # noqa: E501
        if 'url' in local_var_params:
            query_params.append(('url', local_var_params['url']))  # noqa: E501
        if 'read' in local_var_params:
            query_params.append(('read', local_var_params['read']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'application/xml'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/storage/{storage-id}/method', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='StorageMethodListType',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_or_create_storage_method(self, url, storage_id, **kwargs):  # noqa: E501
        """Update or create a storage method  # noqa: E501

        Adds a new access method to the storage. If URL matches an existing method, a new method is not created, instead the existing one is updated.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_or_create_storage_method(url, storage_id, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str url: Method is accessed through this URL (required)
        :param str storage_id: The storage id. (required)
        :key bool read: - `true` (default) - Method has file read capability - `false` - Method does not have file read capability
        :key str type: method type.  Default is empty.
        :key bool browse: - `true` (default) - Method has file browse capability - `false` - Method does not have file browse capability
        :key int bandwidth: The bandwidth of this method in bytes per second.  Default `0`.
        :key bool write: - `true` (default) - Method has file write capability - `false` - Method does not have file write capability
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: str.
                 If the method is called asynchronously, returns the request thread.
        :rtype: str or multiprocessing.pool.AsyncResult
        """
        kwargs['_return_http_data_only'] = True
        return self.update_or_create_storage_method_with_http_info(url, storage_id, **kwargs)  # noqa: E501

    def update_or_create_storage_method_with_http_info(self, url, storage_id, **kwargs):  # noqa: E501
        """Update or create a storage method  # noqa: E501

        Adds a new access method to the storage. If URL matches an existing method, a new method is not created, instead the existing one is updated.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_or_create_storage_method_with_http_info(url, storage_id, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str url: Method is accessed through this URL (required)
        :param str storage_id: The storage id. (required)
        :key bool read: - `true` (default) - Method has file read capability - `false` - Method does not have file read capability
        :key str type: method type.  Default is empty.
        :key bool browse: - `true` (default) - Method has file browse capability - `false` - Method does not have file browse capability
        :key int bandwidth: The bandwidth of this method in bytes per second.  Default `0`.
        :key bool write: - `true` (default) - Method has file write capability - `false` - Method does not have file write capability
        :key _return_http_data_only: response data without head status code
                                       and headers
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(str, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['url', 'storage_id', 'read', 'type', 'browse', 'bandwidth', 'write']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_or_create_storage_method" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'url' is set
        if ('url' not in local_var_params or
                local_var_params['url'] is None):
            raise ApiValueError("Missing the required parameter `url` when calling `update_or_create_storage_method`")  # noqa: E501
        # verify the required parameter 'storage_id' is set
        if ('storage_id' not in local_var_params or
                local_var_params['storage_id'] is None):
            raise ApiValueError("Missing the required parameter `storage_id` when calling `update_or_create_storage_method`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'storage_id' in local_var_params:
            path_params['storage-id'] = local_var_params['storage_id']  # noqa: E501

        query_params = []
        if 'read' in local_var_params:
            query_params.append(('read', local_var_params['read']))  # noqa: E501
        if 'type' in local_var_params:
            query_params.append(('type', local_var_params['type']))  # noqa: E501
        if 'browse' in local_var_params:
            query_params.append(('browse', local_var_params['browse']))  # noqa: E501
        if 'url' in local_var_params:
            query_params.append(('url', local_var_params['url']))  # noqa: E501
        if 'bandwidth' in local_var_params:
            query_params.append(('bandwidth', local_var_params['bandwidth']))  # noqa: E501
        if 'write' in local_var_params:
            query_params.append(('write', local_var_params['write']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/storage/{storage-id}/method', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='str',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_storage_method(self, url, storage_id, method_id, **kwargs):  # noqa: E501
        """Create/update a storage method  # noqa: E501

        Updates access method to the storage.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_storage_method(url, storage_id, method_id, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str url: Method is accessed through this URL (required)
        :param str storage_id: The storage id. (required)
        :param str method_id: The method id. (required)
        :key bool read: - `true` - Method has file read capability.  - `false` - Method does not have file read capability.
        :key str type: method type.
        :key bool browse: - `true` - Method has file browse capability.  - `false` - Method does not have file browse capability.
        :key int bandwidth: The bandwidth of this method in bytes per second.  Default `0`.
        :key bool write: - `true` - Method has file write capability.  - `false` - Method does not have file write capability.
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: str.
                 If the method is called asynchronously, returns the request thread.
        :rtype: str or multiprocessing.pool.AsyncResult
        """
        kwargs['_return_http_data_only'] = True
        return self.update_storage_method_with_http_info(url, storage_id, method_id, **kwargs)  # noqa: E501

    def update_storage_method_with_http_info(self, url, storage_id, method_id, **kwargs):  # noqa: E501
        """Create/update a storage method  # noqa: E501

        Updates access method to the storage.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_storage_method_with_http_info(url, storage_id, method_id, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str url: Method is accessed through this URL (required)
        :param str storage_id: The storage id. (required)
        :param str method_id: The method id. (required)
        :key bool read: - `true` - Method has file read capability.  - `false` - Method does not have file read capability.
        :key str type: method type.
        :key bool browse: - `true` - Method has file browse capability.  - `false` - Method does not have file browse capability.
        :key int bandwidth: The bandwidth of this method in bytes per second.  Default `0`.
        :key bool write: - `true` - Method has file write capability.  - `false` - Method does not have file write capability.
        :key _return_http_data_only: response data without head status code
                                       and headers
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(str, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['url', 'storage_id', 'method_id', 'read', 'type', 'browse', 'bandwidth', 'write']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_storage_method" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'url' is set
        if ('url' not in local_var_params or
                local_var_params['url'] is None):
            raise ApiValueError("Missing the required parameter `url` when calling `update_storage_method`")  # noqa: E501
        # verify the required parameter 'storage_id' is set
        if ('storage_id' not in local_var_params or
                local_var_params['storage_id'] is None):
            raise ApiValueError("Missing the required parameter `storage_id` when calling `update_storage_method`")  # noqa: E501
        # verify the required parameter 'method_id' is set
        if ('method_id' not in local_var_params or
                local_var_params['method_id'] is None):
            raise ApiValueError("Missing the required parameter `method_id` when calling `update_storage_method`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'storage_id' in local_var_params:
            path_params['storage-id'] = local_var_params['storage_id']  # noqa: E501
        if 'method_id' in local_var_params:
            path_params['method-id'] = local_var_params['method_id']  # noqa: E501

        query_params = []
        if 'read' in local_var_params:
            query_params.append(('read', local_var_params['read']))  # noqa: E501
        if 'type' in local_var_params:
            query_params.append(('type', local_var_params['type']))  # noqa: E501
        if 'browse' in local_var_params:
            query_params.append(('browse', local_var_params['browse']))  # noqa: E501
        if 'url' in local_var_params:
            query_params.append(('url', local_var_params['url']))  # noqa: E501
        if 'bandwidth' in local_var_params:
            query_params.append(('bandwidth', local_var_params['bandwidth']))  # noqa: E501
        if 'write' in local_var_params:
            query_params.append(('write', local_var_params['write']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/storage/{storage-id}/method/{method-id}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='str',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_storage_method_metadata(self, storage_id, method_id, simple_metadata_type, **kwargs):  # noqa: E501
        """Create multiple key-value pairs  # noqa: E501

        Sets all the specified key-value pairs.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_storage_method_metadata(storage_id, method_id, simple_metadata_type, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str storage_id: The storage id. (required)
        :param str method_id: The method id. (required)
        :param SimpleMetadataType simple_metadata_type: (required)
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None.
                 If the method is called asynchronously, returns the request thread.
        :rtype: None or multiprocessing.pool.AsyncResult
        """
        kwargs['_return_http_data_only'] = True
        return self.update_storage_method_metadata_with_http_info(storage_id, method_id, simple_metadata_type, **kwargs)  # noqa: E501

    def update_storage_method_metadata_with_http_info(self, storage_id, method_id, simple_metadata_type, **kwargs):  # noqa: E501
        """Create multiple key-value pairs  # noqa: E501

        Sets all the specified key-value pairs.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_storage_method_metadata_with_http_info(storage_id, method_id, simple_metadata_type, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str storage_id: The storage id. (required)
        :param str method_id: The method id. (required)
        :param SimpleMetadataType simple_metadata_type: (required)
        :key _return_http_data_only: response data without head status code
                                       and headers
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['storage_id', 'method_id', 'simple_metadata_type']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_storage_method_metadata" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'storage_id' is set
        if ('storage_id' not in local_var_params or
                local_var_params['storage_id'] is None):
            raise ApiValueError("Missing the required parameter `storage_id` when calling `update_storage_method_metadata`")  # noqa: E501
        # verify the required parameter 'method_id' is set
        if ('method_id' not in local_var_params or
                local_var_params['method_id'] is None):
            raise ApiValueError("Missing the required parameter `method_id` when calling `update_storage_method_metadata`")  # noqa: E501
        # verify the required parameter 'simple_metadata_type' is set
        if ('simple_metadata_type' not in local_var_params or
                local_var_params['simple_metadata_type'] is None):
            raise ApiValueError("Missing the required parameter `simple_metadata_type` when calling `update_storage_method_metadata`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'storage_id' in local_var_params:
            path_params['storage-id'] = local_var_params['storage_id']  # noqa: E501
        if 'method_id' in local_var_params:
            path_params['method-id'] = local_var_params['method_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'simple_metadata_type' in local_var_params:
            body_params = local_var_params['simple_metadata_type']
        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'application/xml'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/storage/{storage-id}/method/{method-id}/metadata', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_storage_method_metadata_key(self, storage_id, method_id, keypath, body, **kwargs):  # noqa: E501
        """Set the value for a specific key  # noqa: E501

        Sets the value for a specific key. The key path may not contain wildcards.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_storage_method_metadata_key(storage_id, method_id, keypath, body, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str storage_id: The storage id. (required)
        :param str method_id: The method id. (required)
        :param str keypath: The keypath. (required)
        :param str body: The raw string value. (required)
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None.
                 If the method is called asynchronously, returns the request thread.
        :rtype: None or multiprocessing.pool.AsyncResult
        """
        kwargs['_return_http_data_only'] = True
        return self.update_storage_method_metadata_key_with_http_info(storage_id, method_id, keypath, body, **kwargs)  # noqa: E501

    def update_storage_method_metadata_key_with_http_info(self, storage_id, method_id, keypath, body, **kwargs):  # noqa: E501
        """Set the value for a specific key  # noqa: E501

        Sets the value for a specific key. The key path may not contain wildcards.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_storage_method_metadata_key_with_http_info(storage_id, method_id, keypath, body, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str storage_id: The storage id. (required)
        :param str method_id: The method id. (required)
        :param str keypath: The keypath. (required)
        :param str body: The raw string value. (required)
        :key _return_http_data_only: response data without head status code
                                       and headers
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['storage_id', 'method_id', 'keypath', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_storage_method_metadata_key" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'storage_id' is set
        if ('storage_id' not in local_var_params or
                local_var_params['storage_id'] is None):
            raise ApiValueError("Missing the required parameter `storage_id` when calling `update_storage_method_metadata_key`")  # noqa: E501
        # verify the required parameter 'method_id' is set
        if ('method_id' not in local_var_params or
                local_var_params['method_id'] is None):
            raise ApiValueError("Missing the required parameter `method_id` when calling `update_storage_method_metadata_key`")  # noqa: E501
        # verify the required parameter 'keypath' is set
        if ('keypath' not in local_var_params or
                local_var_params['keypath'] is None):
            raise ApiValueError("Missing the required parameter `keypath` when calling `update_storage_method_metadata_key`")  # noqa: E501
        # verify the required parameter 'body' is set
        if ('body' not in local_var_params or
                local_var_params['body'] is None):
            raise ApiValueError("Missing the required parameter `body` when calling `update_storage_method_metadata_key`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'storage_id' in local_var_params:
            path_params['storage-id'] = local_var_params['storage_id']  # noqa: E501
        if 'method_id' in local_var_params:
            path_params['method-id'] = local_var_params['method_id']  # noqa: E501
        if 'keypath' in local_var_params:
            path_params['keypath'] = local_var_params['keypath']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in local_var_params:
            body_params = local_var_params['body']
        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['text/plain'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/storage/{storage-id}/method/{method-id}/metadata/{keypath}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)
