# coding: utf-8

"""
    Vidispine API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)  # noqa: E501

    The version of the OpenAPI document: 5.x
    Contact: info@vidispine.com
    Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from vidispine.models import *
from vidispine.api_client import ApiClient
from vidispine.exceptions import (
    ApiTypeError,
    ApiValueError
)


class StorageNameRuleApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def create_shape_storage_name_rule(self, filename, item_id, shape_id, storage_id, **kwargs):  # noqa: E501
        """Create a new storage name rule  # noqa: E501

        Creates a new storage name rule that attempts enforce the filename on a certain storage. This operation does not rename the file, it merely creates a rule for it. The file will then be renamed at a later time, if the file is located on that storage.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_shape_storage_name_rule(filename, item_id, shape_id, storage_id, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str filename: The desired filename of the file. (required)
        :param str item_id: The item id. (required)
        :param str shape_id: The shape id. (required)
        :param str storage_id: The storage id. (required)
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None.
                 If the method is called asynchronously, returns the request thread.
        :rtype: None or multiprocessing.pool.AsyncResult
        """
        kwargs['_return_http_data_only'] = True
        return self.create_shape_storage_name_rule_with_http_info(filename, item_id, shape_id, storage_id, **kwargs)  # noqa: E501

    def create_shape_storage_name_rule_with_http_info(self, filename, item_id, shape_id, storage_id, **kwargs):  # noqa: E501
        """Create a new storage name rule  # noqa: E501

        Creates a new storage name rule that attempts enforce the filename on a certain storage. This operation does not rename the file, it merely creates a rule for it. The file will then be renamed at a later time, if the file is located on that storage.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_shape_storage_name_rule_with_http_info(filename, item_id, shape_id, storage_id, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str filename: The desired filename of the file. (required)
        :param str item_id: The item id. (required)
        :param str shape_id: The shape id. (required)
        :param str storage_id: The storage id. (required)
        :key _return_http_data_only: response data without head status code
                                       and headers
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['filename', 'item_id', 'shape_id', 'storage_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_shape_storage_name_rule" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'filename' is set
        if ('filename' not in local_var_params or
                local_var_params['filename'] is None):
            raise ApiValueError("Missing the required parameter `filename` when calling `create_shape_storage_name_rule`")  # noqa: E501
        # verify the required parameter 'item_id' is set
        if ('item_id' not in local_var_params or
                local_var_params['item_id'] is None):
            raise ApiValueError("Missing the required parameter `item_id` when calling `create_shape_storage_name_rule`")  # noqa: E501
        # verify the required parameter 'shape_id' is set
        if ('shape_id' not in local_var_params or
                local_var_params['shape_id'] is None):
            raise ApiValueError("Missing the required parameter `shape_id` when calling `create_shape_storage_name_rule`")  # noqa: E501
        # verify the required parameter 'storage_id' is set
        if ('storage_id' not in local_var_params or
                local_var_params['storage_id'] is None):
            raise ApiValueError("Missing the required parameter `storage_id` when calling `create_shape_storage_name_rule`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'item_id' in local_var_params:
            path_params['item-id'] = local_var_params['item_id']  # noqa: E501
        if 'shape_id' in local_var_params:
            path_params['shape-id'] = local_var_params['shape_id']  # noqa: E501
        if 'storage_id' in local_var_params:
            path_params['storage-id'] = local_var_params['storage_id']  # noqa: E501

        query_params = []
        if 'filename' in local_var_params:
            query_params.append(('filename', local_var_params['filename']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/item/{item-id}/shape/{shape-id}/filename/{storage-id}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_shape_storage_name_rule(self, filename, item_id, shape_id, storage_id, **kwargs):  # noqa: E501
        """Delete a storage name rule  # noqa: E501

        Deletes a storage name rule that matches the (item id, shape id, storage id, filename) quadruple. Note that this does not change any existing filenames a file might have.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_shape_storage_name_rule(filename, item_id, shape_id, storage_id, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str filename: The filename of the rule. (required)
        :param str item_id: The item id. (required)
        :param str shape_id: The shape id. (required)
        :param str storage_id: The storage id. (required)
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None.
                 If the method is called asynchronously, returns the request thread.
        :rtype: None or multiprocessing.pool.AsyncResult
        """
        kwargs['_return_http_data_only'] = True
        return self.delete_shape_storage_name_rule_with_http_info(filename, item_id, shape_id, storage_id, **kwargs)  # noqa: E501

    def delete_shape_storage_name_rule_with_http_info(self, filename, item_id, shape_id, storage_id, **kwargs):  # noqa: E501
        """Delete a storage name rule  # noqa: E501

        Deletes a storage name rule that matches the (item id, shape id, storage id, filename) quadruple. Note that this does not change any existing filenames a file might have.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_shape_storage_name_rule_with_http_info(filename, item_id, shape_id, storage_id, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str filename: The filename of the rule. (required)
        :param str item_id: The item id. (required)
        :param str shape_id: The shape id. (required)
        :param str storage_id: The storage id. (required)
        :key _return_http_data_only: response data without head status code
                                       and headers
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['filename', 'item_id', 'shape_id', 'storage_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_shape_storage_name_rule" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'filename' is set
        if ('filename' not in local_var_params or
                local_var_params['filename'] is None):
            raise ApiValueError("Missing the required parameter `filename` when calling `delete_shape_storage_name_rule`")  # noqa: E501
        # verify the required parameter 'item_id' is set
        if ('item_id' not in local_var_params or
                local_var_params['item_id'] is None):
            raise ApiValueError("Missing the required parameter `item_id` when calling `delete_shape_storage_name_rule`")  # noqa: E501
        # verify the required parameter 'shape_id' is set
        if ('shape_id' not in local_var_params or
                local_var_params['shape_id'] is None):
            raise ApiValueError("Missing the required parameter `shape_id` when calling `delete_shape_storage_name_rule`")  # noqa: E501
        # verify the required parameter 'storage_id' is set
        if ('storage_id' not in local_var_params or
                local_var_params['storage_id'] is None):
            raise ApiValueError("Missing the required parameter `storage_id` when calling `delete_shape_storage_name_rule`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'item_id' in local_var_params:
            path_params['item-id'] = local_var_params['item_id']  # noqa: E501
        if 'shape_id' in local_var_params:
            path_params['shape-id'] = local_var_params['shape_id']  # noqa: E501
        if 'storage_id' in local_var_params:
            path_params['storage-id'] = local_var_params['storage_id']  # noqa: E501

        query_params = []
        if 'filename' in local_var_params:
            query_params.append(('filename', local_var_params['filename']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/item/{item-id}/shape/{shape-id}/filename/{storage-id}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_shape_storage_name_rules(self, item_id, shape_id, **kwargs):  # noqa: E501
        """List all storage name rules applied on a shape  # noqa: E501

        Retrieves a list of URIs to all storage name rules that are contained within a shape.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_shape_storage_name_rules(item_id, shape_id, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str item_id: The item id. (required)
        :param str shape_id: The shape id. (required)
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: URIListType.
                 If the method is called asynchronously, returns the request thread.
        :rtype: URIListType or multiprocessing.pool.AsyncResult
        """
        kwargs['_return_http_data_only'] = True
        return self.get_shape_storage_name_rules_with_http_info(item_id, shape_id, **kwargs)  # noqa: E501

    def get_shape_storage_name_rules_with_http_info(self, item_id, shape_id, **kwargs):  # noqa: E501
        """List all storage name rules applied on a shape  # noqa: E501

        Retrieves a list of URIs to all storage name rules that are contained within a shape.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_shape_storage_name_rules_with_http_info(item_id, shape_id, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str item_id: The item id. (required)
        :param str shape_id: The shape id. (required)
        :key _return_http_data_only: response data without head status code
                                       and headers
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(URIListType, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['item_id', 'shape_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_shape_storage_name_rules" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'item_id' is set
        if ('item_id' not in local_var_params or
                local_var_params['item_id'] is None):
            raise ApiValueError("Missing the required parameter `item_id` when calling `get_shape_storage_name_rules`")  # noqa: E501
        # verify the required parameter 'shape_id' is set
        if ('shape_id' not in local_var_params or
                local_var_params['shape_id'] is None):
            raise ApiValueError("Missing the required parameter `shape_id` when calling `get_shape_storage_name_rules`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'item_id' in local_var_params:
            path_params['item-id'] = local_var_params['item_id']  # noqa: E501
        if 'shape_id' in local_var_params:
            path_params['shape-id'] = local_var_params['shape_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'text/plain', 'application/xml'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/item/{item-id}/shape/{shape-id}/filename', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='URIListType',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)
