# coding: utf-8

"""
    Vidispine API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)  # noqa: E501

    The version of the OpenAPI document: 5.x
    Contact: info@vidispine.com
    Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from vidispine.models import *
from vidispine.api_client import ApiClient
from vidispine.exceptions import (
    ApiTypeError,
    ApiValueError
)


class TaskDefinitionApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def create_custom_job_type(self, id, type, **kwargs):  # noqa: E501
        """Create a new custom job type  # noqa: E501

        Creates a new job type with the specified name. The recommended format of the `type` path parameter is `{VENDOR_PREFIX}_{JOB_TYPE}`.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_custom_job_type(id, type, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param int id: An integer between 20000 and 30000, must be unique among job types. (required)
        :param str type: The type. (required)
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: TaskDefinitionListType.
                 If the method is called asynchronously, returns the request thread.
        :rtype: TaskDefinitionListType or multiprocessing.pool.AsyncResult
        """
        kwargs['_return_http_data_only'] = True
        return self.create_custom_job_type_with_http_info(id, type, **kwargs)  # noqa: E501

    def create_custom_job_type_with_http_info(self, id, type, **kwargs):  # noqa: E501
        """Create a new custom job type  # noqa: E501

        Creates a new job type with the specified name. The recommended format of the `type` path parameter is `{VENDOR_PREFIX}_{JOB_TYPE}`.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_custom_job_type_with_http_info(id, type, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param int id: An integer between 20000 and 30000, must be unique among job types. (required)
        :param str type: The type. (required)
        :key _return_http_data_only: response data without head status code
                                       and headers
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(TaskDefinitionListType, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['id', 'type']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_custom_job_type" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in local_var_params or
                local_var_params['id'] is None):
            raise ApiValueError("Missing the required parameter `id` when calling `create_custom_job_type`")  # noqa: E501
        # verify the required parameter 'type' is set
        if ('type' not in local_var_params or
                local_var_params['type'] is None):
            raise ApiValueError("Missing the required parameter `type` when calling `create_custom_job_type`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'type' in local_var_params:
            path_params['type'] = local_var_params['type']  # noqa: E501

        query_params = []
        if 'id' in local_var_params:
            query_params.append(('id', local_var_params['id']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'application/xml'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/task-definition/jobtype/{type}', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='TaskDefinitionListType',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_task_definitions(self, task_definition_list_type, **kwargs):  # noqa: E501
        """Define new task  # noqa: E501

        Defines one or more new tasks.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_task_definitions(task_definition_list_type, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param TaskDefinitionListType task_definition_list_type: (required)
        :key bool url: - `true` - Return list of URLs.  - `false` (default) - Return list of ids.
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: URIListType.
                 If the method is called asynchronously, returns the request thread.
        :rtype: URIListType or multiprocessing.pool.AsyncResult
        """
        kwargs['_return_http_data_only'] = True
        return self.create_task_definitions_with_http_info(task_definition_list_type, **kwargs)  # noqa: E501

    def create_task_definitions_with_http_info(self, task_definition_list_type, **kwargs):  # noqa: E501
        """Define new task  # noqa: E501

        Defines one or more new tasks.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_task_definitions_with_http_info(task_definition_list_type, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param TaskDefinitionListType task_definition_list_type: (required)
        :key bool url: - `true` - Return list of URLs.  - `false` (default) - Return list of ids.
        :key _return_http_data_only: response data without head status code
                                       and headers
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(URIListType, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['task_definition_list_type', 'url']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_task_definitions" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'task_definition_list_type' is set
        if ('task_definition_list_type' not in local_var_params or
                local_var_params['task_definition_list_type'] is None):
            raise ApiValueError("Missing the required parameter `task_definition_list_type` when calling `create_task_definitions`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'url' in local_var_params:
            query_params.append(('url', local_var_params['url']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'task_definition_list_type' in local_var_params:
            body_params = local_var_params['task_definition_list_type']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'application/xml'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'application/xml'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/task-definition', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='URIListType',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_custom_job_type(self, type, **kwargs):  # noqa: E501
        """Delete a custom job type  # noqa: E501

        Deletes the job type with the specified name. This will only work for custom job types. System defined job types cannot be deleted.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_custom_job_type(type, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str type: The type. (required)
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None.
                 If the method is called asynchronously, returns the request thread.
        :rtype: None or multiprocessing.pool.AsyncResult
        """
        kwargs['_return_http_data_only'] = True
        return self.delete_custom_job_type_with_http_info(type, **kwargs)  # noqa: E501

    def delete_custom_job_type_with_http_info(self, type, **kwargs):  # noqa: E501
        """Delete a custom job type  # noqa: E501

        Deletes the job type with the specified name. This will only work for custom job types. System defined job types cannot be deleted.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_custom_job_type_with_http_info(type, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str type: The type. (required)
        :key _return_http_data_only: response data without head status code
                                       and headers
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['type']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_custom_job_type" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'type' is set
        if ('type' not in local_var_params or
                local_var_params['type'] is None):
            raise ApiValueError("Missing the required parameter `type` when calling `delete_custom_job_type`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'type' in local_var_params:
            path_params['type'] = local_var_params['type']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/task-definition/jobtype/{type}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_job_step_task_definition(self, type, step, **kwargs):  # noqa: E501
        """Delete a task  # noqa: E501

        Deletes the task.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_job_step_task_definition(type, step, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str type: The type. (required)
        :param str step: The step. (required)
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None.
                 If the method is called asynchronously, returns the request thread.
        :rtype: None or multiprocessing.pool.AsyncResult
        """
        kwargs['_return_http_data_only'] = True
        return self.delete_job_step_task_definition_with_http_info(type, step, **kwargs)  # noqa: E501

    def delete_job_step_task_definition_with_http_info(self, type, step, **kwargs):  # noqa: E501
        """Delete a task  # noqa: E501

        Deletes the task.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_job_step_task_definition_with_http_info(type, step, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str type: The type. (required)
        :param str step: The step. (required)
        :key _return_http_data_only: response data without head status code
                                       and headers
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['type', 'step']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_job_step_task_definition" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'type' is set
        if ('type' not in local_var_params or
                local_var_params['type'] is None):
            raise ApiValueError("Missing the required parameter `type` when calling `delete_job_step_task_definition`")  # noqa: E501
        # verify the required parameter 'step' is set
        if ('step' not in local_var_params or
                local_var_params['step'] is None):
            raise ApiValueError("Missing the required parameter `step` when calling `delete_job_step_task_definition`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'type' in local_var_params:
            path_params['type'] = local_var_params['type']  # noqa: E501
        if 'step' in local_var_params:
            path_params['step'] = local_var_params['step']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/task-definition/jobtype/{type}/step/{step}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_job_step_task_definition_metadata(self, type, step, **kwargs):  # noqa: E501
        """Delete all key-value pairs  # noqa: E501

        Clears all key-value pairs for the specified entity.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_job_step_task_definition_metadata(type, step, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str type: The type. (required)
        :param str step: The step. (required)
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None.
                 If the method is called asynchronously, returns the request thread.
        :rtype: None or multiprocessing.pool.AsyncResult
        """
        kwargs['_return_http_data_only'] = True
        return self.delete_job_step_task_definition_metadata_with_http_info(type, step, **kwargs)  # noqa: E501

    def delete_job_step_task_definition_metadata_with_http_info(self, type, step, **kwargs):  # noqa: E501
        """Delete all key-value pairs  # noqa: E501

        Clears all key-value pairs for the specified entity.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_job_step_task_definition_metadata_with_http_info(type, step, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str type: The type. (required)
        :param str step: The step. (required)
        :key _return_http_data_only: response data without head status code
                                       and headers
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['type', 'step']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_job_step_task_definition_metadata" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'type' is set
        if ('type' not in local_var_params or
                local_var_params['type'] is None):
            raise ApiValueError("Missing the required parameter `type` when calling `delete_job_step_task_definition_metadata`")  # noqa: E501
        # verify the required parameter 'step' is set
        if ('step' not in local_var_params or
                local_var_params['step'] is None):
            raise ApiValueError("Missing the required parameter `step` when calling `delete_job_step_task_definition_metadata`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'type' in local_var_params:
            path_params['type'] = local_var_params['type']  # noqa: E501
        if 'step' in local_var_params:
            path_params['step'] = local_var_params['step']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/task-definition/jobtype/{type}/step/{step}/metadata', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_job_step_task_definition_metadata_key(self, type, step, keypath, **kwargs):  # noqa: E501
        """Delete key-value pairs  # noqa: E501

        Deletes the key-value pair with the specified key. If a key path is given, it may include wildcards for deleting multiple keys.  Key paths can also be specified as well as specific keys.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_job_step_task_definition_metadata_key(type, step, keypath, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str type: The type. (required)
        :param str step: The step. (required)
        :param str keypath: The keypath. (required)
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None.
                 If the method is called asynchronously, returns the request thread.
        :rtype: None or multiprocessing.pool.AsyncResult
        """
        kwargs['_return_http_data_only'] = True
        return self.delete_job_step_task_definition_metadata_key_with_http_info(type, step, keypath, **kwargs)  # noqa: E501

    def delete_job_step_task_definition_metadata_key_with_http_info(self, type, step, keypath, **kwargs):  # noqa: E501
        """Delete key-value pairs  # noqa: E501

        Deletes the key-value pair with the specified key. If a key path is given, it may include wildcards for deleting multiple keys.  Key paths can also be specified as well as specific keys.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_job_step_task_definition_metadata_key_with_http_info(type, step, keypath, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str type: The type. (required)
        :param str step: The step. (required)
        :param str keypath: The keypath. (required)
        :key _return_http_data_only: response data without head status code
                                       and headers
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['type', 'step', 'keypath']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_job_step_task_definition_metadata_key" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'type' is set
        if ('type' not in local_var_params or
                local_var_params['type'] is None):
            raise ApiValueError("Missing the required parameter `type` when calling `delete_job_step_task_definition_metadata_key`")  # noqa: E501
        # verify the required parameter 'step' is set
        if ('step' not in local_var_params or
                local_var_params['step'] is None):
            raise ApiValueError("Missing the required parameter `step` when calling `delete_job_step_task_definition_metadata_key`")  # noqa: E501
        # verify the required parameter 'keypath' is set
        if ('keypath' not in local_var_params or
                local_var_params['keypath'] is None):
            raise ApiValueError("Missing the required parameter `keypath` when calling `delete_job_step_task_definition_metadata_key`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'type' in local_var_params:
            path_params['type'] = local_var_params['type']  # noqa: E501
        if 'step' in local_var_params:
            path_params['step'] = local_var_params['step']  # noqa: E501
        if 'keypath' in local_var_params:
            path_params['keypath'] = local_var_params['keypath']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/task-definition/jobtype/{type}/step/{step}/metadata/{keypath}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_task_definition(self, task_id, **kwargs):  # noqa: E501
        """Delete a task  # noqa: E501

        Deletes the task.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_task_definition(task_id, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str task_id: The task id. (required)
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None.
                 If the method is called asynchronously, returns the request thread.
        :rtype: None or multiprocessing.pool.AsyncResult
        """
        kwargs['_return_http_data_only'] = True
        return self.delete_task_definition_with_http_info(task_id, **kwargs)  # noqa: E501

    def delete_task_definition_with_http_info(self, task_id, **kwargs):  # noqa: E501
        """Delete a task  # noqa: E501

        Deletes the task.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_task_definition_with_http_info(task_id, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str task_id: The task id. (required)
        :key _return_http_data_only: response data without head status code
                                       and headers
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['task_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_task_definition" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'task_id' is set
        if ('task_id' not in local_var_params or
                local_var_params['task_id'] is None):
            raise ApiValueError("Missing the required parameter `task_id` when calling `delete_task_definition`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'task_id' in local_var_params:
            path_params['task-id'] = local_var_params['task_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/task-definition/{task-id}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_task_definition_metadata(self, task_id, **kwargs):  # noqa: E501
        """Delete all key-value pairs  # noqa: E501

        Clears all key-value pairs for the specified entity.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_task_definition_metadata(task_id, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str task_id: The task id. (required)
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None.
                 If the method is called asynchronously, returns the request thread.
        :rtype: None or multiprocessing.pool.AsyncResult
        """
        kwargs['_return_http_data_only'] = True
        return self.delete_task_definition_metadata_with_http_info(task_id, **kwargs)  # noqa: E501

    def delete_task_definition_metadata_with_http_info(self, task_id, **kwargs):  # noqa: E501
        """Delete all key-value pairs  # noqa: E501

        Clears all key-value pairs for the specified entity.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_task_definition_metadata_with_http_info(task_id, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str task_id: The task id. (required)
        :key _return_http_data_only: response data without head status code
                                       and headers
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['task_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_task_definition_metadata" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'task_id' is set
        if ('task_id' not in local_var_params or
                local_var_params['task_id'] is None):
            raise ApiValueError("Missing the required parameter `task_id` when calling `delete_task_definition_metadata`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'task_id' in local_var_params:
            path_params['task-id'] = local_var_params['task_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/task-definition/{task-id}/metadata', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_task_definition_metadata_key(self, task_id, keypath, **kwargs):  # noqa: E501
        """Delete key-value pairs  # noqa: E501

        Deletes the key-value pair with the specified key. If a key path is given, it may include wildcards for deleting multiple keys.  Key paths can also be specified as well as specific keys.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_task_definition_metadata_key(task_id, keypath, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str task_id: The task id. (required)
        :param str keypath: The keypath. (required)
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None.
                 If the method is called asynchronously, returns the request thread.
        :rtype: None or multiprocessing.pool.AsyncResult
        """
        kwargs['_return_http_data_only'] = True
        return self.delete_task_definition_metadata_key_with_http_info(task_id, keypath, **kwargs)  # noqa: E501

    def delete_task_definition_metadata_key_with_http_info(self, task_id, keypath, **kwargs):  # noqa: E501
        """Delete key-value pairs  # noqa: E501

        Deletes the key-value pair with the specified key. If a key path is given, it may include wildcards for deleting multiple keys.  Key paths can also be specified as well as specific keys.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_task_definition_metadata_key_with_http_info(task_id, keypath, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str task_id: The task id. (required)
        :param str keypath: The keypath. (required)
        :key _return_http_data_only: response data without head status code
                                       and headers
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['task_id', 'keypath']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_task_definition_metadata_key" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'task_id' is set
        if ('task_id' not in local_var_params or
                local_var_params['task_id'] is None):
            raise ApiValueError("Missing the required parameter `task_id` when calling `delete_task_definition_metadata_key`")  # noqa: E501
        # verify the required parameter 'keypath' is set
        if ('keypath' not in local_var_params or
                local_var_params['keypath'] is None):
            raise ApiValueError("Missing the required parameter `keypath` when calling `delete_task_definition_metadata_key`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'task_id' in local_var_params:
            path_params['task-id'] = local_var_params['task_id']  # noqa: E501
        if 'keypath' in local_var_params:
            path_params['keypath'] = local_var_params['keypath']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/task-definition/{task-id}/metadata/{keypath}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_job_step_task_definition(self, type, step, **kwargs):  # noqa: E501
        """Retrieve a task  # noqa: E501

        Retrieves the definition document for a task with a specific id.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_job_step_task_definition(type, step, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str type: The type. (required)
        :param str step: The step. (required)
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: TaskDefinitionType.
                 If the method is called asynchronously, returns the request thread.
        :rtype: TaskDefinitionType or multiprocessing.pool.AsyncResult
        """
        kwargs['_return_http_data_only'] = True
        return self.get_job_step_task_definition_with_http_info(type, step, **kwargs)  # noqa: E501

    def get_job_step_task_definition_with_http_info(self, type, step, **kwargs):  # noqa: E501
        """Retrieve a task  # noqa: E501

        Retrieves the definition document for a task with a specific id.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_job_step_task_definition_with_http_info(type, step, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str type: The type. (required)
        :param str step: The step. (required)
        :key _return_http_data_only: response data without head status code
                                       and headers
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(TaskDefinitionType, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['type', 'step']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_job_step_task_definition" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'type' is set
        if ('type' not in local_var_params or
                local_var_params['type'] is None):
            raise ApiValueError("Missing the required parameter `type` when calling `get_job_step_task_definition`")  # noqa: E501
        # verify the required parameter 'step' is set
        if ('step' not in local_var_params or
                local_var_params['step'] is None):
            raise ApiValueError("Missing the required parameter `step` when calling `get_job_step_task_definition`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'type' in local_var_params:
            path_params['type'] = local_var_params['type']  # noqa: E501
        if 'step' in local_var_params:
            path_params['step'] = local_var_params['step']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'application/xml'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/task-definition/jobtype/{type}/step/{step}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='TaskDefinitionType',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_job_step_task_definition_metadata(self, type, step, **kwargs):  # noqa: E501
        """Retrieve all metadata  # noqa: E501

        Retrieves all key-value pairs associated with the specified entity.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_job_step_task_definition_metadata(type, step, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str type: The type. (required)
        :param str step: The step. (required)
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: SimpleMetadataType.
                 If the method is called asynchronously, returns the request thread.
        :rtype: SimpleMetadataType or multiprocessing.pool.AsyncResult
        """
        kwargs['_return_http_data_only'] = True
        return self.get_job_step_task_definition_metadata_with_http_info(type, step, **kwargs)  # noqa: E501

    def get_job_step_task_definition_metadata_with_http_info(self, type, step, **kwargs):  # noqa: E501
        """Retrieve all metadata  # noqa: E501

        Retrieves all key-value pairs associated with the specified entity.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_job_step_task_definition_metadata_with_http_info(type, step, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str type: The type. (required)
        :param str step: The step. (required)
        :key _return_http_data_only: response data without head status code
                                       and headers
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(SimpleMetadataType, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['type', 'step']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_job_step_task_definition_metadata" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'type' is set
        if ('type' not in local_var_params or
                local_var_params['type'] is None):
            raise ApiValueError("Missing the required parameter `type` when calling `get_job_step_task_definition_metadata`")  # noqa: E501
        # verify the required parameter 'step' is set
        if ('step' not in local_var_params or
                local_var_params['step'] is None):
            raise ApiValueError("Missing the required parameter `step` when calling `get_job_step_task_definition_metadata`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'type' in local_var_params:
            path_params['type'] = local_var_params['type']  # noqa: E501
        if 'step' in local_var_params:
            path_params['step'] = local_var_params['step']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'application/xml'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/task-definition/jobtype/{type}/step/{step}/metadata', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SimpleMetadataType',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_job_step_task_definition_metadata_key(self, type, step, keypath, **kwargs):  # noqa: E501
        """Retrieve the metadata for a specific key  # noqa: E501

        Retrieves the value of a specific key. If a key path is specified, exactly one key-value pair must match the key path, else an error is returned.  Key paths can also be specified as well as specific keys.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_job_step_task_definition_metadata_key(type, step, keypath, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str type: The type. (required)
        :param str step: The step. (required)
        :param str keypath: The keypath. (required)
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: str.
                 If the method is called asynchronously, returns the request thread.
        :rtype: str or multiprocessing.pool.AsyncResult
        """
        kwargs['_return_http_data_only'] = True
        return self.get_job_step_task_definition_metadata_key_with_http_info(type, step, keypath, **kwargs)  # noqa: E501

    def get_job_step_task_definition_metadata_key_with_http_info(self, type, step, keypath, **kwargs):  # noqa: E501
        """Retrieve the metadata for a specific key  # noqa: E501

        Retrieves the value of a specific key. If a key path is specified, exactly one key-value pair must match the key path, else an error is returned.  Key paths can also be specified as well as specific keys.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_job_step_task_definition_metadata_key_with_http_info(type, step, keypath, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str type: The type. (required)
        :param str step: The step. (required)
        :param str keypath: The keypath. (required)
        :key _return_http_data_only: response data without head status code
                                       and headers
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(str, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['type', 'step', 'keypath']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_job_step_task_definition_metadata_key" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'type' is set
        if ('type' not in local_var_params or
                local_var_params['type'] is None):
            raise ApiValueError("Missing the required parameter `type` when calling `get_job_step_task_definition_metadata_key`")  # noqa: E501
        # verify the required parameter 'step' is set
        if ('step' not in local_var_params or
                local_var_params['step'] is None):
            raise ApiValueError("Missing the required parameter `step` when calling `get_job_step_task_definition_metadata_key`")  # noqa: E501
        # verify the required parameter 'keypath' is set
        if ('keypath' not in local_var_params or
                local_var_params['keypath'] is None):
            raise ApiValueError("Missing the required parameter `keypath` when calling `get_job_step_task_definition_metadata_key`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'type' in local_var_params:
            path_params['type'] = local_var_params['type']  # noqa: E501
        if 'step' in local_var_params:
            path_params['step'] = local_var_params['step']  # noqa: E501
        if 'keypath' in local_var_params:
            path_params['keypath'] = local_var_params['keypath']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/task-definition/jobtype/{type}/step/{step}/metadata/{keypath}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='str',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_job_step_task_definition_script(self, type, step, **kwargs):  # noqa: E501
        """Retrieve the script for a task definition  # noqa: E501

        Retrieves the script of the task definition.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_job_step_task_definition_script(type, step, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str type: The type. (required)
        :param str step: The step. (required)
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: str.
                 If the method is called asynchronously, returns the request thread.
        :rtype: str or multiprocessing.pool.AsyncResult
        """
        kwargs['_return_http_data_only'] = True
        return self.get_job_step_task_definition_script_with_http_info(type, step, **kwargs)  # noqa: E501

    def get_job_step_task_definition_script_with_http_info(self, type, step, **kwargs):  # noqa: E501
        """Retrieve the script for a task definition  # noqa: E501

        Retrieves the script of the task definition.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_job_step_task_definition_script_with_http_info(type, step, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str type: The type. (required)
        :param str step: The step. (required)
        :key _return_http_data_only: response data without head status code
                                       and headers
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(str, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['type', 'step']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_job_step_task_definition_script" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'type' is set
        if ('type' not in local_var_params or
                local_var_params['type'] is None):
            raise ApiValueError("Missing the required parameter `type` when calling `get_job_step_task_definition_script`")  # noqa: E501
        # verify the required parameter 'step' is set
        if ('step' not in local_var_params or
                local_var_params['step'] is None):
            raise ApiValueError("Missing the required parameter `step` when calling `get_job_step_task_definition_script`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'type' in local_var_params:
            path_params['type'] = local_var_params['type']  # noqa: E501
        if 'step' in local_var_params:
            path_params['step'] = local_var_params['step']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/javascript'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/task-definition/jobtype/{type}/step/{step}/script', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='str',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_job_type_task_definitions(self, type, **kwargs):  # noqa: E501
        """Retrieve task definitions by type  # noqa: E501

        Retrieves the tasks that have been defined for a specific job type.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_job_type_task_definitions(type, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str type: The type. (required)
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: TaskDefinitionListType.
                 If the method is called asynchronously, returns the request thread.
        :rtype: TaskDefinitionListType or multiprocessing.pool.AsyncResult
        """
        kwargs['_return_http_data_only'] = True
        return self.get_job_type_task_definitions_with_http_info(type, **kwargs)  # noqa: E501

    def get_job_type_task_definitions_with_http_info(self, type, **kwargs):  # noqa: E501
        """Retrieve task definitions by type  # noqa: E501

        Retrieves the tasks that have been defined for a specific job type.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_job_type_task_definitions_with_http_info(type, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str type: The type. (required)
        :key _return_http_data_only: response data without head status code
                                       and headers
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(TaskDefinitionListType, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['type']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_job_type_task_definitions" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'type' is set
        if ('type' not in local_var_params or
                local_var_params['type'] is None):
            raise ApiValueError("Missing the required parameter `type` when calling `get_job_type_task_definitions`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'type' in local_var_params:
            path_params['type'] = local_var_params['type']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'application/xml'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/task-definition/jobtype/{type}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='TaskDefinitionListType',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_task_definition(self, task_id, **kwargs):  # noqa: E501
        """Retrieve a task  # noqa: E501

        Retrieves the definition document for a task with a specific id.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_task_definition(task_id, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str task_id: The task id. (required)
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: TaskDefinitionType.
                 If the method is called asynchronously, returns the request thread.
        :rtype: TaskDefinitionType or multiprocessing.pool.AsyncResult
        """
        kwargs['_return_http_data_only'] = True
        return self.get_task_definition_with_http_info(task_id, **kwargs)  # noqa: E501

    def get_task_definition_with_http_info(self, task_id, **kwargs):  # noqa: E501
        """Retrieve a task  # noqa: E501

        Retrieves the definition document for a task with a specific id.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_task_definition_with_http_info(task_id, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str task_id: The task id. (required)
        :key _return_http_data_only: response data without head status code
                                       and headers
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(TaskDefinitionType, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['task_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_task_definition" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'task_id' is set
        if ('task_id' not in local_var_params or
                local_var_params['task_id'] is None):
            raise ApiValueError("Missing the required parameter `task_id` when calling `get_task_definition`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'task_id' in local_var_params:
            path_params['task-id'] = local_var_params['task_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'application/xml'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/task-definition/{task-id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='TaskDefinitionType',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_task_definition_job_graph(self, type, **kwargs):  # noqa: E501
        """Get job graph  # noqa: E501

        Shows the dependencies of the tasks of a specified job type.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_task_definition_job_graph(type, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str type: The type. (required)
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: file.
                 If the method is called asynchronously, returns the request thread.
        :rtype: file or multiprocessing.pool.AsyncResult
        """
        kwargs['_return_http_data_only'] = True
        return self.get_task_definition_job_graph_with_http_info(type, **kwargs)  # noqa: E501

    def get_task_definition_job_graph_with_http_info(self, type, **kwargs):  # noqa: E501
        """Get job graph  # noqa: E501

        Shows the dependencies of the tasks of a specified job type.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_task_definition_job_graph_with_http_info(type, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str type: The type. (required)
        :key _return_http_data_only: response data without head status code
                                       and headers
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(file, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['type']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_task_definition_job_graph" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'type' is set
        if ('type' not in local_var_params or
                local_var_params['type'] is None):
            raise ApiValueError("Missing the required parameter `type` when calling `get_task_definition_job_graph`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'type' in local_var_params:
            path_params['type'] = local_var_params['type']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['image/png'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/task-definition/jobtype/{type}/graph', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='file',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_task_definition_job_graph_dot(self, type, **kwargs):  # noqa: E501
        """Get job graph as DOT file  # noqa: E501

        Shows the dependencies of the tasks of a specified job type in DOT format, for further processing.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_task_definition_job_graph_dot(type, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str type: The type. (required)
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: str.
                 If the method is called asynchronously, returns the request thread.
        :rtype: str or multiprocessing.pool.AsyncResult
        """
        kwargs['_return_http_data_only'] = True
        return self.get_task_definition_job_graph_dot_with_http_info(type, **kwargs)  # noqa: E501

    def get_task_definition_job_graph_dot_with_http_info(self, type, **kwargs):  # noqa: E501
        """Get job graph as DOT file  # noqa: E501

        Shows the dependencies of the tasks of a specified job type in DOT format, for further processing.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_task_definition_job_graph_dot_with_http_info(type, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str type: The type. (required)
        :key _return_http_data_only: response data without head status code
                                       and headers
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(str, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['type']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_task_definition_job_graph_dot" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'type' is set
        if ('type' not in local_var_params or
                local_var_params['type'] is None):
            raise ApiValueError("Missing the required parameter `type` when calling `get_task_definition_job_graph_dot`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'type' in local_var_params:
            path_params['type'] = local_var_params['type']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/vnd.graphviz', 'text/plain'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/task-definition/jobtype/{type}/graph/dot', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='str',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_task_definition_metadata(self, task_id, **kwargs):  # noqa: E501
        """Retrieve all metadata  # noqa: E501

        Retrieves all key-value pairs associated with the specified entity.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_task_definition_metadata(task_id, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str task_id: The task id. (required)
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: SimpleMetadataType.
                 If the method is called asynchronously, returns the request thread.
        :rtype: SimpleMetadataType or multiprocessing.pool.AsyncResult
        """
        kwargs['_return_http_data_only'] = True
        return self.get_task_definition_metadata_with_http_info(task_id, **kwargs)  # noqa: E501

    def get_task_definition_metadata_with_http_info(self, task_id, **kwargs):  # noqa: E501
        """Retrieve all metadata  # noqa: E501

        Retrieves all key-value pairs associated with the specified entity.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_task_definition_metadata_with_http_info(task_id, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str task_id: The task id. (required)
        :key _return_http_data_only: response data without head status code
                                       and headers
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(SimpleMetadataType, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['task_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_task_definition_metadata" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'task_id' is set
        if ('task_id' not in local_var_params or
                local_var_params['task_id'] is None):
            raise ApiValueError("Missing the required parameter `task_id` when calling `get_task_definition_metadata`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'task_id' in local_var_params:
            path_params['task-id'] = local_var_params['task_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'application/xml'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/task-definition/{task-id}/metadata', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SimpleMetadataType',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_task_definition_metadata_key(self, task_id, keypath, **kwargs):  # noqa: E501
        """Retrieve the metadata for a specific key  # noqa: E501

        Retrieves the value of a specific key. If a key path is specified, exactly one key-value pair must match the key path, else an error is returned.  Key paths can also be specified as well as specific keys.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_task_definition_metadata_key(task_id, keypath, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str task_id: The task id. (required)
        :param str keypath: The keypath. (required)
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: str.
                 If the method is called asynchronously, returns the request thread.
        :rtype: str or multiprocessing.pool.AsyncResult
        """
        kwargs['_return_http_data_only'] = True
        return self.get_task_definition_metadata_key_with_http_info(task_id, keypath, **kwargs)  # noqa: E501

    def get_task_definition_metadata_key_with_http_info(self, task_id, keypath, **kwargs):  # noqa: E501
        """Retrieve the metadata for a specific key  # noqa: E501

        Retrieves the value of a specific key. If a key path is specified, exactly one key-value pair must match the key path, else an error is returned.  Key paths can also be specified as well as specific keys.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_task_definition_metadata_key_with_http_info(task_id, keypath, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str task_id: The task id. (required)
        :param str keypath: The keypath. (required)
        :key _return_http_data_only: response data without head status code
                                       and headers
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(str, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['task_id', 'keypath']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_task_definition_metadata_key" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'task_id' is set
        if ('task_id' not in local_var_params or
                local_var_params['task_id'] is None):
            raise ApiValueError("Missing the required parameter `task_id` when calling `get_task_definition_metadata_key`")  # noqa: E501
        # verify the required parameter 'keypath' is set
        if ('keypath' not in local_var_params or
                local_var_params['keypath'] is None):
            raise ApiValueError("Missing the required parameter `keypath` when calling `get_task_definition_metadata_key`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'task_id' in local_var_params:
            path_params['task-id'] = local_var_params['task_id']  # noqa: E501
        if 'keypath' in local_var_params:
            path_params['keypath'] = local_var_params['keypath']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/task-definition/{task-id}/metadata/{keypath}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='str',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_task_definition_script(self, task_id, **kwargs):  # noqa: E501
        """Retrieve the script for a task definition  # noqa: E501

        Retrieves the script of the task definition.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_task_definition_script(task_id, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str task_id: The task id. (required)
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: str.
                 If the method is called asynchronously, returns the request thread.
        :rtype: str or multiprocessing.pool.AsyncResult
        """
        kwargs['_return_http_data_only'] = True
        return self.get_task_definition_script_with_http_info(task_id, **kwargs)  # noqa: E501

    def get_task_definition_script_with_http_info(self, task_id, **kwargs):  # noqa: E501
        """Retrieve the script for a task definition  # noqa: E501

        Retrieves the script of the task definition.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_task_definition_script_with_http_info(task_id, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str task_id: The task id. (required)
        :key _return_http_data_only: response data without head status code
                                       and headers
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(str, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['task_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_task_definition_script" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'task_id' is set
        if ('task_id' not in local_var_params or
                local_var_params['task_id'] is None):
            raise ApiValueError("Missing the required parameter `task_id` when calling `get_task_definition_script`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'task_id' in local_var_params:
            path_params['task-id'] = local_var_params['task_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/javascript'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/task-definition/{task-id}/script', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='str',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_task_definitions(self, **kwargs):  # noqa: E501
        """Retrieve task definitions  # noqa: E501

        Retrieves all tasks that have been defined in the system.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_task_definitions(async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :key str type: Job type to retrieve task definitions for.
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: TaskDefinitionListType.
                 If the method is called asynchronously, returns the request thread.
        :rtype: TaskDefinitionListType or multiprocessing.pool.AsyncResult
        """
        kwargs['_return_http_data_only'] = True
        return self.get_task_definitions_with_http_info(**kwargs)  # noqa: E501

    def get_task_definitions_with_http_info(self, **kwargs):  # noqa: E501
        """Retrieve task definitions  # noqa: E501

        Retrieves all tasks that have been defined in the system.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_task_definitions_with_http_info(async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :key str type: Job type to retrieve task definitions for.
        :key _return_http_data_only: response data without head status code
                                       and headers
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(TaskDefinitionListType, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['type']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_task_definitions" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'type' in local_var_params:
            query_params.append(('type', local_var_params['type']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'application/xml'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/task-definition', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='TaskDefinitionListType',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_job_step_task_definition(self, type, step, task_definition_type, **kwargs):  # noqa: E501
        """Update an existing task  # noqa: E501

        Updates the task.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_job_step_task_definition(type, step, task_definition_type, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str type: The type. (required)
        :param str step: The step. (required)
        :param TaskDefinitionType task_definition_type: (required)
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: TaskDefinitionType.
                 If the method is called asynchronously, returns the request thread.
        :rtype: TaskDefinitionType or multiprocessing.pool.AsyncResult
        """
        kwargs['_return_http_data_only'] = True
        return self.update_job_step_task_definition_with_http_info(type, step, task_definition_type, **kwargs)  # noqa: E501

    def update_job_step_task_definition_with_http_info(self, type, step, task_definition_type, **kwargs):  # noqa: E501
        """Update an existing task  # noqa: E501

        Updates the task.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_job_step_task_definition_with_http_info(type, step, task_definition_type, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str type: The type. (required)
        :param str step: The step. (required)
        :param TaskDefinitionType task_definition_type: (required)
        :key _return_http_data_only: response data without head status code
                                       and headers
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(TaskDefinitionType, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['type', 'step', 'task_definition_type']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_job_step_task_definition" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'type' is set
        if ('type' not in local_var_params or
                local_var_params['type'] is None):
            raise ApiValueError("Missing the required parameter `type` when calling `update_job_step_task_definition`")  # noqa: E501
        # verify the required parameter 'step' is set
        if ('step' not in local_var_params or
                local_var_params['step'] is None):
            raise ApiValueError("Missing the required parameter `step` when calling `update_job_step_task_definition`")  # noqa: E501
        # verify the required parameter 'task_definition_type' is set
        if ('task_definition_type' not in local_var_params or
                local_var_params['task_definition_type'] is None):
            raise ApiValueError("Missing the required parameter `task_definition_type` when calling `update_job_step_task_definition`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'type' in local_var_params:
            path_params['type'] = local_var_params['type']  # noqa: E501
        if 'step' in local_var_params:
            path_params['step'] = local_var_params['step']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'task_definition_type' in local_var_params:
            body_params = local_var_params['task_definition_type']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'application/xml'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'application/xml'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/task-definition/jobtype/{type}/step/{step}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='TaskDefinitionType',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_job_step_task_definition_metadata(self, type, step, simple_metadata_type, **kwargs):  # noqa: E501
        """Create multiple key-value pairs  # noqa: E501

        Sets all the specified key-value pairs.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_job_step_task_definition_metadata(type, step, simple_metadata_type, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str type: The type. (required)
        :param str step: The step. (required)
        :param SimpleMetadataType simple_metadata_type: (required)
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None.
                 If the method is called asynchronously, returns the request thread.
        :rtype: None or multiprocessing.pool.AsyncResult
        """
        kwargs['_return_http_data_only'] = True
        return self.update_job_step_task_definition_metadata_with_http_info(type, step, simple_metadata_type, **kwargs)  # noqa: E501

    def update_job_step_task_definition_metadata_with_http_info(self, type, step, simple_metadata_type, **kwargs):  # noqa: E501
        """Create multiple key-value pairs  # noqa: E501

        Sets all the specified key-value pairs.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_job_step_task_definition_metadata_with_http_info(type, step, simple_metadata_type, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str type: The type. (required)
        :param str step: The step. (required)
        :param SimpleMetadataType simple_metadata_type: (required)
        :key _return_http_data_only: response data without head status code
                                       and headers
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['type', 'step', 'simple_metadata_type']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_job_step_task_definition_metadata" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'type' is set
        if ('type' not in local_var_params or
                local_var_params['type'] is None):
            raise ApiValueError("Missing the required parameter `type` when calling `update_job_step_task_definition_metadata`")  # noqa: E501
        # verify the required parameter 'step' is set
        if ('step' not in local_var_params or
                local_var_params['step'] is None):
            raise ApiValueError("Missing the required parameter `step` when calling `update_job_step_task_definition_metadata`")  # noqa: E501
        # verify the required parameter 'simple_metadata_type' is set
        if ('simple_metadata_type' not in local_var_params or
                local_var_params['simple_metadata_type'] is None):
            raise ApiValueError("Missing the required parameter `simple_metadata_type` when calling `update_job_step_task_definition_metadata`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'type' in local_var_params:
            path_params['type'] = local_var_params['type']  # noqa: E501
        if 'step' in local_var_params:
            path_params['step'] = local_var_params['step']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'simple_metadata_type' in local_var_params:
            body_params = local_var_params['simple_metadata_type']
        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'application/xml'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/task-definition/jobtype/{type}/step/{step}/metadata', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_job_step_task_definition_metadata_key(self, type, step, keypath, body, **kwargs):  # noqa: E501
        """Set the value for a specific key  # noqa: E501

        Sets the value for a specific key. The key path may not contain wildcards.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_job_step_task_definition_metadata_key(type, step, keypath, body, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str type: The type. (required)
        :param str step: The step. (required)
        :param str keypath: The keypath. (required)
        :param str body: The raw string value. (required)
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None.
                 If the method is called asynchronously, returns the request thread.
        :rtype: None or multiprocessing.pool.AsyncResult
        """
        kwargs['_return_http_data_only'] = True
        return self.update_job_step_task_definition_metadata_key_with_http_info(type, step, keypath, body, **kwargs)  # noqa: E501

    def update_job_step_task_definition_metadata_key_with_http_info(self, type, step, keypath, body, **kwargs):  # noqa: E501
        """Set the value for a specific key  # noqa: E501

        Sets the value for a specific key. The key path may not contain wildcards.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_job_step_task_definition_metadata_key_with_http_info(type, step, keypath, body, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str type: The type. (required)
        :param str step: The step. (required)
        :param str keypath: The keypath. (required)
        :param str body: The raw string value. (required)
        :key _return_http_data_only: response data without head status code
                                       and headers
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['type', 'step', 'keypath', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_job_step_task_definition_metadata_key" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'type' is set
        if ('type' not in local_var_params or
                local_var_params['type'] is None):
            raise ApiValueError("Missing the required parameter `type` when calling `update_job_step_task_definition_metadata_key`")  # noqa: E501
        # verify the required parameter 'step' is set
        if ('step' not in local_var_params or
                local_var_params['step'] is None):
            raise ApiValueError("Missing the required parameter `step` when calling `update_job_step_task_definition_metadata_key`")  # noqa: E501
        # verify the required parameter 'keypath' is set
        if ('keypath' not in local_var_params or
                local_var_params['keypath'] is None):
            raise ApiValueError("Missing the required parameter `keypath` when calling `update_job_step_task_definition_metadata_key`")  # noqa: E501
        # verify the required parameter 'body' is set
        if ('body' not in local_var_params or
                local_var_params['body'] is None):
            raise ApiValueError("Missing the required parameter `body` when calling `update_job_step_task_definition_metadata_key`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'type' in local_var_params:
            path_params['type'] = local_var_params['type']  # noqa: E501
        if 'step' in local_var_params:
            path_params['step'] = local_var_params['step']  # noqa: E501
        if 'keypath' in local_var_params:
            path_params['keypath'] = local_var_params['keypath']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in local_var_params:
            body_params = local_var_params['body']
        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['text/plain'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/task-definition/jobtype/{type}/step/{step}/metadata/{keypath}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_job_step_task_definition_script(self, type, step, body, **kwargs):  # noqa: E501
        """Set a script for a shape tag  # noqa: E501

        Sets a script for the task definition.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_job_step_task_definition_script(type, step, body, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str type: The type. (required)
        :param str step: The step. (required)
        :param str body: A JavaScript (required)
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None.
                 If the method is called asynchronously, returns the request thread.
        :rtype: None or multiprocessing.pool.AsyncResult
        """
        kwargs['_return_http_data_only'] = True
        return self.update_job_step_task_definition_script_with_http_info(type, step, body, **kwargs)  # noqa: E501

    def update_job_step_task_definition_script_with_http_info(self, type, step, body, **kwargs):  # noqa: E501
        """Set a script for a shape tag  # noqa: E501

        Sets a script for the task definition.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_job_step_task_definition_script_with_http_info(type, step, body, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str type: The type. (required)
        :param str step: The step. (required)
        :param str body: A JavaScript (required)
        :key _return_http_data_only: response data without head status code
                                       and headers
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['type', 'step', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_job_step_task_definition_script" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'type' is set
        if ('type' not in local_var_params or
                local_var_params['type'] is None):
            raise ApiValueError("Missing the required parameter `type` when calling `update_job_step_task_definition_script`")  # noqa: E501
        # verify the required parameter 'step' is set
        if ('step' not in local_var_params or
                local_var_params['step'] is None):
            raise ApiValueError("Missing the required parameter `step` when calling `update_job_step_task_definition_script`")  # noqa: E501
        # verify the required parameter 'body' is set
        if ('body' not in local_var_params or
                local_var_params['body'] is None):
            raise ApiValueError("Missing the required parameter `body` when calling `update_job_step_task_definition_script`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'type' in local_var_params:
            path_params['type'] = local_var_params['type']  # noqa: E501
        if 'step' in local_var_params:
            path_params['step'] = local_var_params['step']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in local_var_params:
            body_params = local_var_params['body']
        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/javascript'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/task-definition/jobtype/{type}/step/{step}/script', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_task_definition(self, task_id, task_definition_type, **kwargs):  # noqa: E501
        """Update an existing task  # noqa: E501

        Updates the task.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_task_definition(task_id, task_definition_type, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str task_id: The task id. (required)
        :param TaskDefinitionType task_definition_type: (required)
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: TaskDefinitionType.
                 If the method is called asynchronously, returns the request thread.
        :rtype: TaskDefinitionType or multiprocessing.pool.AsyncResult
        """
        kwargs['_return_http_data_only'] = True
        return self.update_task_definition_with_http_info(task_id, task_definition_type, **kwargs)  # noqa: E501

    def update_task_definition_with_http_info(self, task_id, task_definition_type, **kwargs):  # noqa: E501
        """Update an existing task  # noqa: E501

        Updates the task.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_task_definition_with_http_info(task_id, task_definition_type, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str task_id: The task id. (required)
        :param TaskDefinitionType task_definition_type: (required)
        :key _return_http_data_only: response data without head status code
                                       and headers
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(TaskDefinitionType, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['task_id', 'task_definition_type']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_task_definition" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'task_id' is set
        if ('task_id' not in local_var_params or
                local_var_params['task_id'] is None):
            raise ApiValueError("Missing the required parameter `task_id` when calling `update_task_definition`")  # noqa: E501
        # verify the required parameter 'task_definition_type' is set
        if ('task_definition_type' not in local_var_params or
                local_var_params['task_definition_type'] is None):
            raise ApiValueError("Missing the required parameter `task_definition_type` when calling `update_task_definition`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'task_id' in local_var_params:
            path_params['task-id'] = local_var_params['task_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'task_definition_type' in local_var_params:
            body_params = local_var_params['task_definition_type']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'application/xml'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'application/xml'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/task-definition/{task-id}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='TaskDefinitionType',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_task_definition_metadata(self, task_id, simple_metadata_type, **kwargs):  # noqa: E501
        """Create multiple key-value pairs  # noqa: E501

        Sets all the specified key-value pairs.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_task_definition_metadata(task_id, simple_metadata_type, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str task_id: The task id. (required)
        :param SimpleMetadataType simple_metadata_type: (required)
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None.
                 If the method is called asynchronously, returns the request thread.
        :rtype: None or multiprocessing.pool.AsyncResult
        """
        kwargs['_return_http_data_only'] = True
        return self.update_task_definition_metadata_with_http_info(task_id, simple_metadata_type, **kwargs)  # noqa: E501

    def update_task_definition_metadata_with_http_info(self, task_id, simple_metadata_type, **kwargs):  # noqa: E501
        """Create multiple key-value pairs  # noqa: E501

        Sets all the specified key-value pairs.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_task_definition_metadata_with_http_info(task_id, simple_metadata_type, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str task_id: The task id. (required)
        :param SimpleMetadataType simple_metadata_type: (required)
        :key _return_http_data_only: response data without head status code
                                       and headers
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['task_id', 'simple_metadata_type']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_task_definition_metadata" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'task_id' is set
        if ('task_id' not in local_var_params or
                local_var_params['task_id'] is None):
            raise ApiValueError("Missing the required parameter `task_id` when calling `update_task_definition_metadata`")  # noqa: E501
        # verify the required parameter 'simple_metadata_type' is set
        if ('simple_metadata_type' not in local_var_params or
                local_var_params['simple_metadata_type'] is None):
            raise ApiValueError("Missing the required parameter `simple_metadata_type` when calling `update_task_definition_metadata`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'task_id' in local_var_params:
            path_params['task-id'] = local_var_params['task_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'simple_metadata_type' in local_var_params:
            body_params = local_var_params['simple_metadata_type']
        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'application/xml'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/task-definition/{task-id}/metadata', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_task_definition_metadata_key(self, task_id, keypath, body, **kwargs):  # noqa: E501
        """Set the value for a specific key  # noqa: E501

        Sets the value for a specific key. The key path may not contain wildcards.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_task_definition_metadata_key(task_id, keypath, body, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str task_id: The task id. (required)
        :param str keypath: The keypath. (required)
        :param str body: The raw string value. (required)
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None.
                 If the method is called asynchronously, returns the request thread.
        :rtype: None or multiprocessing.pool.AsyncResult
        """
        kwargs['_return_http_data_only'] = True
        return self.update_task_definition_metadata_key_with_http_info(task_id, keypath, body, **kwargs)  # noqa: E501

    def update_task_definition_metadata_key_with_http_info(self, task_id, keypath, body, **kwargs):  # noqa: E501
        """Set the value for a specific key  # noqa: E501

        Sets the value for a specific key. The key path may not contain wildcards.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_task_definition_metadata_key_with_http_info(task_id, keypath, body, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str task_id: The task id. (required)
        :param str keypath: The keypath. (required)
        :param str body: The raw string value. (required)
        :key _return_http_data_only: response data without head status code
                                       and headers
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['task_id', 'keypath', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_task_definition_metadata_key" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'task_id' is set
        if ('task_id' not in local_var_params or
                local_var_params['task_id'] is None):
            raise ApiValueError("Missing the required parameter `task_id` when calling `update_task_definition_metadata_key`")  # noqa: E501
        # verify the required parameter 'keypath' is set
        if ('keypath' not in local_var_params or
                local_var_params['keypath'] is None):
            raise ApiValueError("Missing the required parameter `keypath` when calling `update_task_definition_metadata_key`")  # noqa: E501
        # verify the required parameter 'body' is set
        if ('body' not in local_var_params or
                local_var_params['body'] is None):
            raise ApiValueError("Missing the required parameter `body` when calling `update_task_definition_metadata_key`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'task_id' in local_var_params:
            path_params['task-id'] = local_var_params['task_id']  # noqa: E501
        if 'keypath' in local_var_params:
            path_params['keypath'] = local_var_params['keypath']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in local_var_params:
            body_params = local_var_params['body']
        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['text/plain'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/task-definition/{task-id}/metadata/{keypath}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_task_definition_script(self, task_id, body, **kwargs):  # noqa: E501
        """Set a script for a shape tag  # noqa: E501

        Sets a script for the task definition.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_task_definition_script(task_id, body, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str task_id: The task id. (required)
        :param str body: A JavaScript (required)
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None.
                 If the method is called asynchronously, returns the request thread.
        :rtype: None or multiprocessing.pool.AsyncResult
        """
        kwargs['_return_http_data_only'] = True
        return self.update_task_definition_script_with_http_info(task_id, body, **kwargs)  # noqa: E501

    def update_task_definition_script_with_http_info(self, task_id, body, **kwargs):  # noqa: E501
        """Set a script for a shape tag  # noqa: E501

        Sets a script for the task definition.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_task_definition_script_with_http_info(task_id, body, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str task_id: The task id. (required)
        :param str body: A JavaScript (required)
        :key _return_http_data_only: response data without head status code
                                       and headers
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['task_id', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_task_definition_script" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'task_id' is set
        if ('task_id' not in local_var_params or
                local_var_params['task_id'] is None):
            raise ApiValueError("Missing the required parameter `task_id` when calling `update_task_definition_script`")  # noqa: E501
        # verify the required parameter 'body' is set
        if ('body' not in local_var_params or
                local_var_params['body'] is None):
            raise ApiValueError("Missing the required parameter `body` when calling `update_task_definition_script`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'task_id' in local_var_params:
            path_params['task-id'] = local_var_params['task_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in local_var_params:
            body_params = local_var_params['body']
        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/javascript'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/task-definition/{task-id}/script', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def validate_job_step_task_definition(self, type, step, **kwargs):  # noqa: E501
        """Validate a task  # noqa: E501

        Verifies that the bean referred to in the task can be resolved and that it contains the specified method.  Does nothing if the task is a script task.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.validate_job_step_task_definition(type, step, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str type: The type. (required)
        :param str step: The step. (required)
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: str.
                 If the method is called asynchronously, returns the request thread.
        :rtype: str or multiprocessing.pool.AsyncResult
        """
        kwargs['_return_http_data_only'] = True
        return self.validate_job_step_task_definition_with_http_info(type, step, **kwargs)  # noqa: E501

    def validate_job_step_task_definition_with_http_info(self, type, step, **kwargs):  # noqa: E501
        """Validate a task  # noqa: E501

        Verifies that the bean referred to in the task can be resolved and that it contains the specified method.  Does nothing if the task is a script task.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.validate_job_step_task_definition_with_http_info(type, step, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str type: The type. (required)
        :param str step: The step. (required)
        :key _return_http_data_only: response data without head status code
                                       and headers
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(str, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['type', 'step']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method validate_job_step_task_definition" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'type' is set
        if ('type' not in local_var_params or
                local_var_params['type'] is None):
            raise ApiValueError("Missing the required parameter `type` when calling `validate_job_step_task_definition`")  # noqa: E501
        # verify the required parameter 'step' is set
        if ('step' not in local_var_params or
                local_var_params['step'] is None):
            raise ApiValueError("Missing the required parameter `step` when calling `validate_job_step_task_definition`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'type' in local_var_params:
            path_params['type'] = local_var_params['type']  # noqa: E501
        if 'step' in local_var_params:
            path_params['step'] = local_var_params['step']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/task-definition/jobtype/{type}/step/{step}/validate', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='str',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def validate_task_definition(self, task_id, **kwargs):  # noqa: E501
        """Validate a task  # noqa: E501

        Verifies that the bean referred to in the task can be resolved and that it contains the specified method.  Does nothing if the task is a script task.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.validate_task_definition(task_id, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str task_id: The task id. (required)
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: str.
                 If the method is called asynchronously, returns the request thread.
        :rtype: str or multiprocessing.pool.AsyncResult
        """
        kwargs['_return_http_data_only'] = True
        return self.validate_task_definition_with_http_info(task_id, **kwargs)  # noqa: E501

    def validate_task_definition_with_http_info(self, task_id, **kwargs):  # noqa: E501
        """Validate a task  # noqa: E501

        Verifies that the bean referred to in the task can be resolved and that it contains the specified method.  Does nothing if the task is a script task.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.validate_task_definition_with_http_info(task_id, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str task_id: The task id. (required)
        :key _return_http_data_only: response data without head status code
                                       and headers
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(str, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['task_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method validate_task_definition" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'task_id' is set
        if ('task_id' not in local_var_params or
                local_var_params['task_id'] is None):
            raise ApiValueError("Missing the required parameter `task_id` when calling `validate_task_definition`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'task_id' in local_var_params:
            path_params['task-id'] = local_var_params['task_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/task-definition/{task-id}/validate', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='str',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)
