# coding: utf-8

"""
    Vidispine API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)  # noqa: E501

    The version of the OpenAPI document: 5.x
    Contact: info@vidispine.com
    Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from vidispine.models import *
from vidispine.api_client import ApiClient
from vidispine.exceptions import (
    ApiTypeError,
    ApiValueError
)


class TaskGroupApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def add_task_group_transcoder(self, group_name, transcoder_id, **kwargs):  # noqa: E501
        """Add a transcoder to a task group  # noqa: E501

        Adds the transcoder to the specified task group.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.add_task_group_transcoder(group_name, transcoder_id, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str group_name: The group name. (required)
        :param str transcoder_id: The transcoder id. (required)
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None.
                 If the method is called asynchronously, returns the request thread.
        :rtype: None or multiprocessing.pool.AsyncResult
        """
        kwargs['_return_http_data_only'] = True
        return self.add_task_group_transcoder_with_http_info(group_name, transcoder_id, **kwargs)  # noqa: E501

    def add_task_group_transcoder_with_http_info(self, group_name, transcoder_id, **kwargs):  # noqa: E501
        """Add a transcoder to a task group  # noqa: E501

        Adds the transcoder to the specified task group.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_task_group_transcoder_with_http_info(group_name, transcoder_id, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str group_name: The group name. (required)
        :param str transcoder_id: The transcoder id. (required)
        :key _return_http_data_only: response data without head status code
                                       and headers
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['group_name', 'transcoder_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method add_task_group_transcoder" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'group_name' is set
        if ('group_name' not in local_var_params or
                local_var_params['group_name'] is None):
            raise ApiValueError("Missing the required parameter `group_name` when calling `add_task_group_transcoder`")  # noqa: E501
        # verify the required parameter 'transcoder_id' is set
        if ('transcoder_id' not in local_var_params or
                local_var_params['transcoder_id'] is None):
            raise ApiValueError("Missing the required parameter `transcoder_id` when calling `add_task_group_transcoder`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'group_name' in local_var_params:
            path_params['group-name'] = local_var_params['group_name']  # noqa: E501
        if 'transcoder_id' in local_var_params:
            path_params['transcoder-id'] = local_var_params['transcoder_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/task-group/{group-name}/transcoder/{transcoder-id}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_task_group(self, group_name, **kwargs):  # noqa: E501
        """Delete a task group  # noqa: E501

        Deletes the task group.  Note that this only deletes the task group. It will not remove any transcoders or other resources that are in the group.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_task_group(group_name, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str group_name: The group name. (required)
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None.
                 If the method is called asynchronously, returns the request thread.
        :rtype: None or multiprocessing.pool.AsyncResult
        """
        kwargs['_return_http_data_only'] = True
        return self.delete_task_group_with_http_info(group_name, **kwargs)  # noqa: E501

    def delete_task_group_with_http_info(self, group_name, **kwargs):  # noqa: E501
        """Delete a task group  # noqa: E501

        Deletes the task group.  Note that this only deletes the task group. It will not remove any transcoders or other resources that are in the group.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_task_group_with_http_info(group_name, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str group_name: The group name. (required)
        :key _return_http_data_only: response data without head status code
                                       and headers
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['group_name']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_task_group" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'group_name' is set
        if ('group_name' not in local_var_params or
                local_var_params['group_name'] is None):
            raise ApiValueError("Missing the required parameter `group_name` when calling `delete_task_group`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'group_name' in local_var_params:
            path_params['group-name'] = local_var_params['group_name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/task-group/{group-name}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_task_group_metadata(self, group_name, **kwargs):  # noqa: E501
        """Delete all key-value pairs  # noqa: E501

        Clears all key-value pairs for the specified entity.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_task_group_metadata(group_name, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str group_name: The group name. (required)
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None.
                 If the method is called asynchronously, returns the request thread.
        :rtype: None or multiprocessing.pool.AsyncResult
        """
        kwargs['_return_http_data_only'] = True
        return self.delete_task_group_metadata_with_http_info(group_name, **kwargs)  # noqa: E501

    def delete_task_group_metadata_with_http_info(self, group_name, **kwargs):  # noqa: E501
        """Delete all key-value pairs  # noqa: E501

        Clears all key-value pairs for the specified entity.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_task_group_metadata_with_http_info(group_name, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str group_name: The group name. (required)
        :key _return_http_data_only: response data without head status code
                                       and headers
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['group_name']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_task_group_metadata" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'group_name' is set
        if ('group_name' not in local_var_params or
                local_var_params['group_name'] is None):
            raise ApiValueError("Missing the required parameter `group_name` when calling `delete_task_group_metadata`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'group_name' in local_var_params:
            path_params['group-name'] = local_var_params['group_name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/task-group/{group-name}/metadata', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_task_group_metadata_key(self, group_name, keypath, **kwargs):  # noqa: E501
        """Delete key-value pairs  # noqa: E501

        Deletes the key-value pair with the specified key. If a key path is given, it may include wildcards for deleting multiple keys.  Key paths can also be specified as well as specific keys.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_task_group_metadata_key(group_name, keypath, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str group_name: The group name. (required)
        :param str keypath: The keypath. (required)
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None.
                 If the method is called asynchronously, returns the request thread.
        :rtype: None or multiprocessing.pool.AsyncResult
        """
        kwargs['_return_http_data_only'] = True
        return self.delete_task_group_metadata_key_with_http_info(group_name, keypath, **kwargs)  # noqa: E501

    def delete_task_group_metadata_key_with_http_info(self, group_name, keypath, **kwargs):  # noqa: E501
        """Delete key-value pairs  # noqa: E501

        Deletes the key-value pair with the specified key. If a key path is given, it may include wildcards for deleting multiple keys.  Key paths can also be specified as well as specific keys.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_task_group_metadata_key_with_http_info(group_name, keypath, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str group_name: The group name. (required)
        :param str keypath: The keypath. (required)
        :key _return_http_data_only: response data without head status code
                                       and headers
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['group_name', 'keypath']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_task_group_metadata_key" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'group_name' is set
        if ('group_name' not in local_var_params or
                local_var_params['group_name'] is None):
            raise ApiValueError("Missing the required parameter `group_name` when calling `delete_task_group_metadata_key`")  # noqa: E501
        # verify the required parameter 'keypath' is set
        if ('keypath' not in local_var_params or
                local_var_params['keypath'] is None):
            raise ApiValueError("Missing the required parameter `keypath` when calling `delete_task_group_metadata_key`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'group_name' in local_var_params:
            path_params['group-name'] = local_var_params['group_name']  # noqa: E501
        if 'keypath' in local_var_params:
            path_params['keypath'] = local_var_params['keypath']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/task-group/{group-name}/metadata/{keypath}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_task_groups(self, **kwargs):  # noqa: E501
        """Delete all task groups  # noqa: E501

        Deletes all task groups.  Note that this only deletes the task groups. It will not remove any transcoders or other resources that are in the groups.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_task_groups(async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None.
                 If the method is called asynchronously, returns the request thread.
        :rtype: None or multiprocessing.pool.AsyncResult
        """
        kwargs['_return_http_data_only'] = True
        return self.delete_task_groups_with_http_info(**kwargs)  # noqa: E501

    def delete_task_groups_with_http_info(self, **kwargs):  # noqa: E501
        """Delete all task groups  # noqa: E501

        Deletes all task groups.  Note that this only deletes the task groups. It will not remove any transcoders or other resources that are in the groups.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_task_groups_with_http_info(async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :key _return_http_data_only: response data without head status code
                                       and headers
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_task_groups" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/task-group', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_task_group(self, group_name, **kwargs):  # noqa: E501
        """Retrieve a task group  # noqa: E501

        Retrieves the task group document for a task group with a specific name.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_task_group(group_name, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str group_name: The group name. (required)
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: TaskGroupType.
                 If the method is called asynchronously, returns the request thread.
        :rtype: TaskGroupType or multiprocessing.pool.AsyncResult
        """
        kwargs['_return_http_data_only'] = True
        return self.get_task_group_with_http_info(group_name, **kwargs)  # noqa: E501

    def get_task_group_with_http_info(self, group_name, **kwargs):  # noqa: E501
        """Retrieve a task group  # noqa: E501

        Retrieves the task group document for a task group with a specific name.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_task_group_with_http_info(group_name, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str group_name: The group name. (required)
        :key _return_http_data_only: response data without head status code
                                       and headers
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(TaskGroupType, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['group_name']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_task_group" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'group_name' is set
        if ('group_name' not in local_var_params or
                local_var_params['group_name'] is None):
            raise ApiValueError("Missing the required parameter `group_name` when calling `get_task_group`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'group_name' in local_var_params:
            path_params['group-name'] = local_var_params['group_name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'application/xml'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/task-group/{group-name}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='TaskGroupType',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_task_group_metadata(self, group_name, **kwargs):  # noqa: E501
        """Retrieve all metadata  # noqa: E501

        Retrieves all key-value pairs associated with the specified entity.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_task_group_metadata(group_name, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str group_name: The group name. (required)
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: SimpleMetadataType.
                 If the method is called asynchronously, returns the request thread.
        :rtype: SimpleMetadataType or multiprocessing.pool.AsyncResult
        """
        kwargs['_return_http_data_only'] = True
        return self.get_task_group_metadata_with_http_info(group_name, **kwargs)  # noqa: E501

    def get_task_group_metadata_with_http_info(self, group_name, **kwargs):  # noqa: E501
        """Retrieve all metadata  # noqa: E501

        Retrieves all key-value pairs associated with the specified entity.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_task_group_metadata_with_http_info(group_name, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str group_name: The group name. (required)
        :key _return_http_data_only: response data without head status code
                                       and headers
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(SimpleMetadataType, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['group_name']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_task_group_metadata" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'group_name' is set
        if ('group_name' not in local_var_params or
                local_var_params['group_name'] is None):
            raise ApiValueError("Missing the required parameter `group_name` when calling `get_task_group_metadata`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'group_name' in local_var_params:
            path_params['group-name'] = local_var_params['group_name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'application/xml'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/task-group/{group-name}/metadata', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SimpleMetadataType',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_task_group_metadata_key(self, group_name, keypath, **kwargs):  # noqa: E501
        """Retrieve the metadata for a specific key  # noqa: E501

        Retrieves the value of a specific key. If a key path is specified, exactly one key-value pair must match the key path, else an error is returned.  Key paths can also be specified as well as specific keys.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_task_group_metadata_key(group_name, keypath, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str group_name: The group name. (required)
        :param str keypath: The keypath. (required)
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: str.
                 If the method is called asynchronously, returns the request thread.
        :rtype: str or multiprocessing.pool.AsyncResult
        """
        kwargs['_return_http_data_only'] = True
        return self.get_task_group_metadata_key_with_http_info(group_name, keypath, **kwargs)  # noqa: E501

    def get_task_group_metadata_key_with_http_info(self, group_name, keypath, **kwargs):  # noqa: E501
        """Retrieve the metadata for a specific key  # noqa: E501

        Retrieves the value of a specific key. If a key path is specified, exactly one key-value pair must match the key path, else an error is returned.  Key paths can also be specified as well as specific keys.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_task_group_metadata_key_with_http_info(group_name, keypath, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str group_name: The group name. (required)
        :param str keypath: The keypath. (required)
        :key _return_http_data_only: response data without head status code
                                       and headers
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(str, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['group_name', 'keypath']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_task_group_metadata_key" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'group_name' is set
        if ('group_name' not in local_var_params or
                local_var_params['group_name'] is None):
            raise ApiValueError("Missing the required parameter `group_name` when calling `get_task_group_metadata_key`")  # noqa: E501
        # verify the required parameter 'keypath' is set
        if ('keypath' not in local_var_params or
                local_var_params['keypath'] is None):
            raise ApiValueError("Missing the required parameter `keypath` when calling `get_task_group_metadata_key`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'group_name' in local_var_params:
            path_params['group-name'] = local_var_params['group_name']  # noqa: E501
        if 'keypath' in local_var_params:
            path_params['keypath'] = local_var_params['keypath']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/task-group/{group-name}/metadata/{keypath}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='str',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_task_groups(self, **kwargs):  # noqa: E501
        """List all task groups  # noqa: E501

        Retrieves all task groups that have been defined in the system.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_task_groups(async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: TaskGroupListType.
                 If the method is called asynchronously, returns the request thread.
        :rtype: TaskGroupListType or multiprocessing.pool.AsyncResult
        """
        kwargs['_return_http_data_only'] = True
        return self.get_task_groups_with_http_info(**kwargs)  # noqa: E501

    def get_task_groups_with_http_info(self, **kwargs):  # noqa: E501
        """List all task groups  # noqa: E501

        Retrieves all task groups that have been defined in the system.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_task_groups_with_http_info(async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :key _return_http_data_only: response data without head status code
                                       and headers
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(TaskGroupListType, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_task_groups" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'application/xml'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/task-group', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='TaskGroupListType',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def remove_task_group_transcoder(self, group_name, transcoder_id, **kwargs):  # noqa: E501
        """Remove a transcoder from a task group  # noqa: E501

        Removes a transcoder from the specified task group.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.remove_task_group_transcoder(group_name, transcoder_id, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str group_name: The group name. (required)
        :param str transcoder_id: The transcoder id. (required)
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None.
                 If the method is called asynchronously, returns the request thread.
        :rtype: None or multiprocessing.pool.AsyncResult
        """
        kwargs['_return_http_data_only'] = True
        return self.remove_task_group_transcoder_with_http_info(group_name, transcoder_id, **kwargs)  # noqa: E501

    def remove_task_group_transcoder_with_http_info(self, group_name, transcoder_id, **kwargs):  # noqa: E501
        """Remove a transcoder from a task group  # noqa: E501

        Removes a transcoder from the specified task group.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.remove_task_group_transcoder_with_http_info(group_name, transcoder_id, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str group_name: The group name. (required)
        :param str transcoder_id: The transcoder id. (required)
        :key _return_http_data_only: response data without head status code
                                       and headers
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['group_name', 'transcoder_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method remove_task_group_transcoder" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'group_name' is set
        if ('group_name' not in local_var_params or
                local_var_params['group_name'] is None):
            raise ApiValueError("Missing the required parameter `group_name` when calling `remove_task_group_transcoder`")  # noqa: E501
        # verify the required parameter 'transcoder_id' is set
        if ('transcoder_id' not in local_var_params or
                local_var_params['transcoder_id'] is None):
            raise ApiValueError("Missing the required parameter `transcoder_id` when calling `remove_task_group_transcoder`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'group_name' in local_var_params:
            path_params['group-name'] = local_var_params['group_name']  # noqa: E501
        if 'transcoder_id' in local_var_params:
            path_params['transcoder-id'] = local_var_params['transcoder_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/task-group/{group-name}/transcoder/{transcoder-id}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_or_create_task_group(self, group_name, task_group_type, **kwargs):  # noqa: E501
        """Update or create a task group  # noqa: E501

        Updates or creates the task group with the given name.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_or_create_task_group(group_name, task_group_type, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str group_name: The group name. (required)
        :param TaskGroupType task_group_type: (required)
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: TaskGroupType.
                 If the method is called asynchronously, returns the request thread.
        :rtype: TaskGroupType or multiprocessing.pool.AsyncResult
        """
        kwargs['_return_http_data_only'] = True
        return self.update_or_create_task_group_with_http_info(group_name, task_group_type, **kwargs)  # noqa: E501

    def update_or_create_task_group_with_http_info(self, group_name, task_group_type, **kwargs):  # noqa: E501
        """Update or create a task group  # noqa: E501

        Updates or creates the task group with the given name.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_or_create_task_group_with_http_info(group_name, task_group_type, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str group_name: The group name. (required)
        :param TaskGroupType task_group_type: (required)
        :key _return_http_data_only: response data without head status code
                                       and headers
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(TaskGroupType, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['group_name', 'task_group_type']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_or_create_task_group" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'group_name' is set
        if ('group_name' not in local_var_params or
                local_var_params['group_name'] is None):
            raise ApiValueError("Missing the required parameter `group_name` when calling `update_or_create_task_group`")  # noqa: E501
        # verify the required parameter 'task_group_type' is set
        if ('task_group_type' not in local_var_params or
                local_var_params['task_group_type'] is None):
            raise ApiValueError("Missing the required parameter `task_group_type` when calling `update_or_create_task_group`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'group_name' in local_var_params:
            path_params['group-name'] = local_var_params['group_name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'task_group_type' in local_var_params:
            body_params = local_var_params['task_group_type']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'application/xml'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'application/xml'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/task-group/{group-name}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='TaskGroupType',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_task_group_metadata(self, group_name, simple_metadata_type, **kwargs):  # noqa: E501
        """Create multiple key-value pairs  # noqa: E501

        Sets all the specified key-value pairs.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_task_group_metadata(group_name, simple_metadata_type, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str group_name: The group name. (required)
        :param SimpleMetadataType simple_metadata_type: (required)
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None.
                 If the method is called asynchronously, returns the request thread.
        :rtype: None or multiprocessing.pool.AsyncResult
        """
        kwargs['_return_http_data_only'] = True
        return self.update_task_group_metadata_with_http_info(group_name, simple_metadata_type, **kwargs)  # noqa: E501

    def update_task_group_metadata_with_http_info(self, group_name, simple_metadata_type, **kwargs):  # noqa: E501
        """Create multiple key-value pairs  # noqa: E501

        Sets all the specified key-value pairs.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_task_group_metadata_with_http_info(group_name, simple_metadata_type, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str group_name: The group name. (required)
        :param SimpleMetadataType simple_metadata_type: (required)
        :key _return_http_data_only: response data without head status code
                                       and headers
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['group_name', 'simple_metadata_type']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_task_group_metadata" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'group_name' is set
        if ('group_name' not in local_var_params or
                local_var_params['group_name'] is None):
            raise ApiValueError("Missing the required parameter `group_name` when calling `update_task_group_metadata`")  # noqa: E501
        # verify the required parameter 'simple_metadata_type' is set
        if ('simple_metadata_type' not in local_var_params or
                local_var_params['simple_metadata_type'] is None):
            raise ApiValueError("Missing the required parameter `simple_metadata_type` when calling `update_task_group_metadata`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'group_name' in local_var_params:
            path_params['group-name'] = local_var_params['group_name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'simple_metadata_type' in local_var_params:
            body_params = local_var_params['simple_metadata_type']
        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'application/xml'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/task-group/{group-name}/metadata', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_task_group_metadata_key(self, group_name, keypath, body, **kwargs):  # noqa: E501
        """Set the value for a specific key  # noqa: E501

        Sets the value for a specific key. The key path may not contain wildcards.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_task_group_metadata_key(group_name, keypath, body, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str group_name: The group name. (required)
        :param str keypath: The keypath. (required)
        :param str body: The raw string value. (required)
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None.
                 If the method is called asynchronously, returns the request thread.
        :rtype: None or multiprocessing.pool.AsyncResult
        """
        kwargs['_return_http_data_only'] = True
        return self.update_task_group_metadata_key_with_http_info(group_name, keypath, body, **kwargs)  # noqa: E501

    def update_task_group_metadata_key_with_http_info(self, group_name, keypath, body, **kwargs):  # noqa: E501
        """Set the value for a specific key  # noqa: E501

        Sets the value for a specific key. The key path may not contain wildcards.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_task_group_metadata_key_with_http_info(group_name, keypath, body, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str group_name: The group name. (required)
        :param str keypath: The keypath. (required)
        :param str body: The raw string value. (required)
        :key _return_http_data_only: response data without head status code
                                       and headers
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['group_name', 'keypath', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_task_group_metadata_key" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'group_name' is set
        if ('group_name' not in local_var_params or
                local_var_params['group_name'] is None):
            raise ApiValueError("Missing the required parameter `group_name` when calling `update_task_group_metadata_key`")  # noqa: E501
        # verify the required parameter 'keypath' is set
        if ('keypath' not in local_var_params or
                local_var_params['keypath'] is None):
            raise ApiValueError("Missing the required parameter `keypath` when calling `update_task_group_metadata_key`")  # noqa: E501
        # verify the required parameter 'body' is set
        if ('body' not in local_var_params or
                local_var_params['body'] is None):
            raise ApiValueError("Missing the required parameter `body` when calling `update_task_group_metadata_key`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'group_name' in local_var_params:
            path_params['group-name'] = local_var_params['group_name']  # noqa: E501
        if 'keypath' in local_var_params:
            path_params['keypath'] = local_var_params['keypath']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in local_var_params:
            body_params = local_var_params['body']
        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['text/plain'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/task-group/{group-name}/metadata/{keypath}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)
