# coding: utf-8

"""
    Vidispine API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)  # noqa: E501

    The version of the OpenAPI document: 5.x
    Contact: info@vidispine.com
    Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from vidispine.models import *
from vidispine.api_client import ApiClient
from vidispine.exceptions import (
    ApiTypeError,
    ApiValueError
)


class VidispineLogsApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def create_vidispine_log_job(self, endtime, starttime, **kwargs):  # noqa: E501
        """Start a log report job  # noqa: E501

        Starts a log report job that collects service log files into a zip file.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_vidispine_log_job(endtime, starttime, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str endtime: ISO 8601 end time of time span. (required)
        :param str starttime: ISO 8601 start time of time span. (required)
        :key list[str] storage: Comma-separated list of storage ids to retrieve information about.
        :key str comment: Detailed description of what the problem is, to be written in zip file.
        :key list[str] item: Comma-separated list of item ids to retrieve information about.
        :key list[str] user: Comma-separated list of user names to retrieve information about.
        :key list[str] job: Comma-separated list of job ids to retrieve information about.
        :key bool selftest: If `true`, includes the result of a self-test.
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: JobType.
                 If the method is called asynchronously, returns the request thread.
        :rtype: JobType or multiprocessing.pool.AsyncResult
        """
        kwargs['_return_http_data_only'] = True
        return self.create_vidispine_log_job_with_http_info(endtime, starttime, **kwargs)  # noqa: E501

    def create_vidispine_log_job_with_http_info(self, endtime, starttime, **kwargs):  # noqa: E501
        """Start a log report job  # noqa: E501

        Starts a log report job that collects service log files into a zip file.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_vidispine_log_job_with_http_info(endtime, starttime, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str endtime: ISO 8601 end time of time span. (required)
        :param str starttime: ISO 8601 start time of time span. (required)
        :key list[str] storage: Comma-separated list of storage ids to retrieve information about.
        :key str comment: Detailed description of what the problem is, to be written in zip file.
        :key list[str] item: Comma-separated list of item ids to retrieve information about.
        :key list[str] user: Comma-separated list of user names to retrieve information about.
        :key list[str] job: Comma-separated list of job ids to retrieve information about.
        :key bool selftest: If `true`, includes the result of a self-test.
        :key _return_http_data_only: response data without head status code
                                       and headers
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(JobType, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['endtime', 'starttime', 'storage', 'comment', 'item', 'user', 'job', 'selftest']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_vidispine_log_job" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'endtime' is set
        if ('endtime' not in local_var_params or
                local_var_params['endtime'] is None):
            raise ApiValueError("Missing the required parameter `endtime` when calling `create_vidispine_log_job`")  # noqa: E501
        # verify the required parameter 'starttime' is set
        if ('starttime' not in local_var_params or
                local_var_params['starttime'] is None):
            raise ApiValueError("Missing the required parameter `starttime` when calling `create_vidispine_log_job`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'endtime' in local_var_params:
            query_params.append(('endtime', local_var_params['endtime']))  # noqa: E501
        if 'storage' in local_var_params:
            query_params.append(('storage', local_var_params['storage']))  # noqa: E501
            collection_formats['storage'] = 'csv'  # noqa: E501
        if 'comment' in local_var_params:
            query_params.append(('comment', local_var_params['comment']))  # noqa: E501
        if 'item' in local_var_params:
            query_params.append(('item', local_var_params['item']))  # noqa: E501
            collection_formats['item'] = 'csv'  # noqa: E501
        if 'starttime' in local_var_params:
            query_params.append(('starttime', local_var_params['starttime']))  # noqa: E501
        if 'user' in local_var_params:
            query_params.append(('user', local_var_params['user']))  # noqa: E501
            collection_formats['user'] = 'csv'  # noqa: E501
        if 'job' in local_var_params:
            query_params.append(('job', local_var_params['job']))  # noqa: E501
            collection_formats['job'] = 'csv'  # noqa: E501
        if 'selftest' in local_var_params:
            query_params.append(('selftest', local_var_params['selftest']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'application/xml'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/vidispine-logs/job', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='JobType',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_vidispine_log_job_upload(self, job_id, uri_list_type, **kwargs):  # noqa: E501
        """Start an upload  # noqa: E501

        Starts upload.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_vidispine_log_job_upload(job_id, uri_list_type, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str job_id: The job id. (required)
        :param URIListType uri_list_type: A <em>URIListDocument</em> with URIs from the list of files in the log. (required)
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None.
                 If the method is called asynchronously, returns the request thread.
        :rtype: None or multiprocessing.pool.AsyncResult
        """
        kwargs['_return_http_data_only'] = True
        return self.create_vidispine_log_job_upload_with_http_info(job_id, uri_list_type, **kwargs)  # noqa: E501

    def create_vidispine_log_job_upload_with_http_info(self, job_id, uri_list_type, **kwargs):  # noqa: E501
        """Start an upload  # noqa: E501

        Starts upload.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_vidispine_log_job_upload_with_http_info(job_id, uri_list_type, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str job_id: The job id. (required)
        :param URIListType uri_list_type: A <em>URIListDocument</em> with URIs from the list of files in the log. (required)
        :key _return_http_data_only: response data without head status code
                                       and headers
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['job_id', 'uri_list_type']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_vidispine_log_job_upload" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'job_id' is set
        if ('job_id' not in local_var_params or
                local_var_params['job_id'] is None):
            raise ApiValueError("Missing the required parameter `job_id` when calling `create_vidispine_log_job_upload`")  # noqa: E501
        # verify the required parameter 'uri_list_type' is set
        if ('uri_list_type' not in local_var_params or
                local_var_params['uri_list_type'] is None):
            raise ApiValueError("Missing the required parameter `uri_list_type` when calling `create_vidispine_log_job_upload`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'job_id' in local_var_params:
            path_params['job-id'] = local_var_params['job_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'uri_list_type' in local_var_params:
            body_params = local_var_params['uri_list_type']
        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'application/xml'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/vidispine-logs/job/{job-id}/upload', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_vidispine_log_job(self, job_id, **kwargs):  # noqa: E501
        """Delete a log report job  # noqa: E501

        Deletes a job and the report created.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_vidispine_log_job(job_id, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str job_id: The job id. (required)
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None.
                 If the method is called asynchronously, returns the request thread.
        :rtype: None or multiprocessing.pool.AsyncResult
        """
        kwargs['_return_http_data_only'] = True
        return self.delete_vidispine_log_job_with_http_info(job_id, **kwargs)  # noqa: E501

    def delete_vidispine_log_job_with_http_info(self, job_id, **kwargs):  # noqa: E501
        """Delete a log report job  # noqa: E501

        Deletes a job and the report created.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_vidispine_log_job_with_http_info(job_id, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str job_id: The job id. (required)
        :key _return_http_data_only: response data without head status code
                                       and headers
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['job_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_vidispine_log_job" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'job_id' is set
        if ('job_id' not in local_var_params or
                local_var_params['job_id'] is None):
            raise ApiValueError("Missing the required parameter `job_id` when calling `delete_vidispine_log_job`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'job_id' in local_var_params:
            path_params['job-id'] = local_var_params['job_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/vidispine-logs/job/{job-id}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_vidispine_log_job_upload(self, job_id, **kwargs):  # noqa: E501
        """Abort an upload  # noqa: E501

        Aborts upload process.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_vidispine_log_job_upload(job_id, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str job_id: The job id. (required)
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None.
                 If the method is called asynchronously, returns the request thread.
        :rtype: None or multiprocessing.pool.AsyncResult
        """
        kwargs['_return_http_data_only'] = True
        return self.delete_vidispine_log_job_upload_with_http_info(job_id, **kwargs)  # noqa: E501

    def delete_vidispine_log_job_upload_with_http_info(self, job_id, **kwargs):  # noqa: E501
        """Abort an upload  # noqa: E501

        Aborts upload process.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_vidispine_log_job_upload_with_http_info(job_id, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str job_id: The job id. (required)
        :key _return_http_data_only: response data without head status code
                                       and headers
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['job_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_vidispine_log_job_upload" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'job_id' is set
        if ('job_id' not in local_var_params or
                local_var_params['job_id'] is None):
            raise ApiValueError("Missing the required parameter `job_id` when calling `delete_vidispine_log_job_upload`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'job_id' in local_var_params:
            path_params['job-id'] = local_var_params['job_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/vidispine-logs/job/{job-id}/upload', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_vidispine_log_job(self, job_id, **kwargs):  # noqa: E501
        """Retrieve a log report job  # noqa: E501

        Return information about specified job.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_vidispine_log_job(job_id, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str job_id: The job id. (required)
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: JobType.
                 If the method is called asynchronously, returns the request thread.
        :rtype: JobType or multiprocessing.pool.AsyncResult
        """
        kwargs['_return_http_data_only'] = True
        return self.get_vidispine_log_job_with_http_info(job_id, **kwargs)  # noqa: E501

    def get_vidispine_log_job_with_http_info(self, job_id, **kwargs):  # noqa: E501
        """Retrieve a log report job  # noqa: E501

        Return information about specified job.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_vidispine_log_job_with_http_info(job_id, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str job_id: The job id. (required)
        :key _return_http_data_only: response data without head status code
                                       and headers
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(JobType, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['job_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_vidispine_log_job" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'job_id' is set
        if ('job_id' not in local_var_params or
                local_var_params['job_id'] is None):
            raise ApiValueError("Missing the required parameter `job_id` when calling `get_vidispine_log_job`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'job_id' in local_var_params:
            path_params['job-id'] = local_var_params['job_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'application/xml'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/vidispine-logs/job/{job-id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='JobType',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_vidispine_log_job_file_info(self, job_id, **kwargs):  # noqa: E501
        """Retrieve files in job  # noqa: E501

        Return file information about specified job.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_vidispine_log_job_file_info(job_id, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str job_id: The job id. (required)
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: str.
                 If the method is called asynchronously, returns the request thread.
        :rtype: str or multiprocessing.pool.AsyncResult
        """
        kwargs['_return_http_data_only'] = True
        return self.get_vidispine_log_job_file_info_with_http_info(job_id, **kwargs)  # noqa: E501

    def get_vidispine_log_job_file_info_with_http_info(self, job_id, **kwargs):  # noqa: E501
        """Retrieve files in job  # noqa: E501

        Return file information about specified job.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_vidispine_log_job_file_info_with_http_info(job_id, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str job_id: The job id. (required)
        :key _return_http_data_only: response data without head status code
                                       and headers
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(str, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['job_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_vidispine_log_job_file_info" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'job_id' is set
        if ('job_id' not in local_var_params or
                local_var_params['job_id'] is None):
            raise ApiValueError("Missing the required parameter `job_id` when calling `get_vidispine_log_job_file_info`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'job_id' in local_var_params:
            path_params['job-id'] = local_var_params['job_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/vidispine-logs/job/{job-id}/uri', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='str',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_vidispine_log_jobs(self, **kwargs):  # noqa: E501
        """List all log report jobs  # noqa: E501

        Return information about all jobs that have not expired.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_vidispine_log_jobs(async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: JobListType.
                 If the method is called asynchronously, returns the request thread.
        :rtype: JobListType or multiprocessing.pool.AsyncResult
        """
        kwargs['_return_http_data_only'] = True
        return self.get_vidispine_log_jobs_with_http_info(**kwargs)  # noqa: E501

    def get_vidispine_log_jobs_with_http_info(self, **kwargs):  # noqa: E501
        """List all log report jobs  # noqa: E501

        Return information about all jobs that have not expired.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_vidispine_log_jobs_with_http_info(async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :key _return_http_data_only: response data without head status code
                                       and headers
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(JobListType, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_vidispine_log_jobs" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'application/xml'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/vidispine-logs/job', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='JobListType',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_vidispine_logs(self, endtime, starttime, **kwargs):  # noqa: E501
        """Retrieve log files  # noqa: E501

        Retrieves a zip file with the various service log files.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_vidispine_logs(endtime, starttime, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str endtime: ISO 8601 end time of time span. (required)
        :param str starttime: ISO 8601 start time of time span. (required)
        :key list[str] storage: Comma-separated list of storage ids to retrieve information about.
        :key str comment: Detailed description of what the problem is, to be written in zip file.
        :key list[str] item: Comma-separated list of item ids to retrieve information about.
        :key list[str] user: Comma-separated list of user names to retrieve information about.
        :key list[str] job: Comma-separated list of job ids to retrieve information about.
        :key bool selftest: If `true`, includes the result of a self-test.
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: str.
                 If the method is called asynchronously, returns the request thread.
        :rtype: str or multiprocessing.pool.AsyncResult
        """
        kwargs['_return_http_data_only'] = True
        return self.get_vidispine_logs_with_http_info(endtime, starttime, **kwargs)  # noqa: E501

    def get_vidispine_logs_with_http_info(self, endtime, starttime, **kwargs):  # noqa: E501
        """Retrieve log files  # noqa: E501

        Retrieves a zip file with the various service log files.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_vidispine_logs_with_http_info(endtime, starttime, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str endtime: ISO 8601 end time of time span. (required)
        :param str starttime: ISO 8601 start time of time span. (required)
        :key list[str] storage: Comma-separated list of storage ids to retrieve information about.
        :key str comment: Detailed description of what the problem is, to be written in zip file.
        :key list[str] item: Comma-separated list of item ids to retrieve information about.
        :key list[str] user: Comma-separated list of user names to retrieve information about.
        :key list[str] job: Comma-separated list of job ids to retrieve information about.
        :key bool selftest: If `true`, includes the result of a self-test.
        :key _return_http_data_only: response data without head status code
                                       and headers
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(str, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['endtime', 'starttime', 'storage', 'comment', 'item', 'user', 'job', 'selftest']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_vidispine_logs" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'endtime' is set
        if ('endtime' not in local_var_params or
                local_var_params['endtime'] is None):
            raise ApiValueError("Missing the required parameter `endtime` when calling `get_vidispine_logs`")  # noqa: E501
        # verify the required parameter 'starttime' is set
        if ('starttime' not in local_var_params or
                local_var_params['starttime'] is None):
            raise ApiValueError("Missing the required parameter `starttime` when calling `get_vidispine_logs`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'endtime' in local_var_params:
            query_params.append(('endtime', local_var_params['endtime']))  # noqa: E501
        if 'storage' in local_var_params:
            query_params.append(('storage', local_var_params['storage']))  # noqa: E501
            collection_formats['storage'] = 'csv'  # noqa: E501
        if 'comment' in local_var_params:
            query_params.append(('comment', local_var_params['comment']))  # noqa: E501
        if 'item' in local_var_params:
            query_params.append(('item', local_var_params['item']))  # noqa: E501
            collection_formats['item'] = 'csv'  # noqa: E501
        if 'starttime' in local_var_params:
            query_params.append(('starttime', local_var_params['starttime']))  # noqa: E501
        if 'user' in local_var_params:
            query_params.append(('user', local_var_params['user']))  # noqa: E501
            collection_formats['user'] = 'csv'  # noqa: E501
        if 'job' in local_var_params:
            query_params.append(('job', local_var_params['job']))  # noqa: E501
            collection_formats['job'] = 'csv'  # noqa: E501
        if 'selftest' in local_var_params:
            query_params.append(('selftest', local_var_params['selftest']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/zip', 'multipart/mixed', 'multipart/form-data'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/vidispine-logs', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='str',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)
