# coding: utf-8

"""
    Vidispine API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)  # noqa: E501

    The version of the OpenAPI document: 5.x
    Contact: info@vidispine.com
    Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from vidispine.models import *
from vidispine.api_client import ApiClient
from vidispine.exceptions import (
    ApiTypeError,
    ApiValueError
)


class WaveformApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def get_item_waveform(self, item_id, **kwargs):  # noqa: E501
        """Get waveform data  # noqa: E501

        Returns the waveform data as a *WaveformDataDocument*.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_item_waveform(item_id, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str item_id: The item id. (required)
        :key str shape: The shape id to use to get information from.  If omitted the shape tag will be used.  Note that an analysis of this shape must be done before the information is available.
        :key bool d_b: - `true` - Return RMS dB values.  - `false` (default) - Return RMS 1-based absolute values.
        :key str tag: The shape tag to use.
        :key str start: The start time code to get waveform information for.
        :key str item_track: The `itemTrack` value of the audio channel within the shape.
        :key str end: The end time code to get waveform information for.
        :key int width: The number of sample points to return.
        :key str channel: The channel value of the audio channel within the stream of the component.  If `itemTrack` and `stream` are omitted, this value can be used to denote tracks in a linear fashion, regardless of `itemTrack` and `stream`.  Then `channel=0` means the first audio track, <pre>channel=1`</pre> the second, etc.
        :key str stream: The stream value of the audio channel within the component of the shape.
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: WaveformDataType.
                 If the method is called asynchronously, returns the request thread.
        :rtype: WaveformDataType or multiprocessing.pool.AsyncResult
        """
        kwargs['_return_http_data_only'] = True
        return self.get_item_waveform_with_http_info(item_id, **kwargs)  # noqa: E501

    def get_item_waveform_with_http_info(self, item_id, **kwargs):  # noqa: E501
        """Get waveform data  # noqa: E501

        Returns the waveform data as a *WaveformDataDocument*.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_item_waveform_with_http_info(item_id, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str item_id: The item id. (required)
        :key str shape: The shape id to use to get information from.  If omitted the shape tag will be used.  Note that an analysis of this shape must be done before the information is available.
        :key bool d_b: - `true` - Return RMS dB values.  - `false` (default) - Return RMS 1-based absolute values.
        :key str tag: The shape tag to use.
        :key str start: The start time code to get waveform information for.
        :key str item_track: The `itemTrack` value of the audio channel within the shape.
        :key str end: The end time code to get waveform information for.
        :key int width: The number of sample points to return.
        :key str channel: The channel value of the audio channel within the stream of the component.  If `itemTrack` and `stream` are omitted, this value can be used to denote tracks in a linear fashion, regardless of `itemTrack` and `stream`.  Then `channel=0` means the first audio track, <pre>channel=1`</pre> the second, etc.
        :key str stream: The stream value of the audio channel within the component of the shape.
        :key _return_http_data_only: response data without head status code
                                       and headers
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(WaveformDataType, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['item_id', 'shape', 'd_b', 'tag', 'start', 'item_track', 'end', 'width', 'channel', 'stream']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_item_waveform" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'item_id' is set
        if ('item_id' not in local_var_params or
                local_var_params['item_id'] is None):
            raise ApiValueError("Missing the required parameter `item_id` when calling `get_item_waveform`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'item_id' in local_var_params:
            path_params['item-id'] = local_var_params['item_id']  # noqa: E501

        query_params = []
        if 'shape' in local_var_params:
            query_params.append(('shape', local_var_params['shape']))  # noqa: E501
        if 'd_b' in local_var_params:
            query_params.append(('dB', local_var_params['d_b']))  # noqa: E501
        if 'tag' in local_var_params:
            query_params.append(('tag', local_var_params['tag']))  # noqa: E501
        if 'start' in local_var_params:
            query_params.append(('start', local_var_params['start']))  # noqa: E501
        if 'item_track' in local_var_params:
            query_params.append(('itemTrack', local_var_params['item_track']))  # noqa: E501
        if 'end' in local_var_params:
            query_params.append(('end', local_var_params['end']))  # noqa: E501
        if 'width' in local_var_params:
            query_params.append(('width', local_var_params['width']))  # noqa: E501
        if 'channel' in local_var_params:
            query_params.append(('channel', local_var_params['channel']))  # noqa: E501
        if 'stream' in local_var_params:
            query_params.append(('stream', local_var_params['stream']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'application/xml'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/item/{item-id}/waveform/values', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='WaveformDataType',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_item_waveform_all_tracks(self, item_id, **kwargs):  # noqa: E501
        """Get waveform images for all audio channels  # noqa: E501

        Solely used for debugging. May be deprecated in newer releases.  Returns a HTML document including image references to waveform images for all channels. Query parameters can be used to control the image appearance.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_item_waveform_all_tracks(item_id, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str item_id: The item id. (required)
        :key str shape: The shape id to use to get information from.  If omitted the shape tag will be used.  Note that an analysis of this shape must be done before the information is available.
        :key str tag: The shape tag to use.
        :key int height: The height, in pixels, of the image.  Default is 100.
        :key str vgridline: The position of primary vertical gridlines, where 0 is left border and 1 is right border.
        :key str bgcolor: The background color of the image, as hex triplet.
        :key str end: The end time code to get waveform information for.
        :key float max: The audio value that corresponds the top border.  Defaults to `1` if `dB` is `false`, and `0` otherwise.
        :key int width: The number of sample points to return.
        :key str channel: The channel value of the audio channel within the stream of the component.  If `itemTrack` and `stream` are omitted, this value can be used to denote tracks in a linear fashion, regardless of `itemTrack` and `stream`.  Then `channel=0` means the first audio track, <pre>channel=1`</pre> the second, etc.
        :key str hgridline: The position of primary horizontal gridlines, in units of the audio.
        :key str vgridline2: The position of primary vertical gridlines, where 0 is left border and 1 is right border.
        :key float min: The audio value that corresponds the bottom border.  Defaults to `-1` if `dB` is `false`, and `-80` otherwise.
        :key str item_track: The `itemTrack` value of the audio channel within the shape.
        :key bool d_b: - `true` - Return RMS dB values.  - `false` (default) - Return RMS 1-based absolute values.
        :key str vgridlinecolor: The color of primary vertical gridlines
        :key str vgridline2color: The color of primary vertical gridlines
        :key str hgridline2: The position of secondary horizontal gridlines, in units of the audio.
        :key str hgridlinecolor: The color of primary horizontal gridlines.
        :key str hgridline2color: The color of secondary horizontal gridlines
        :key str start: The start time code to get waveform information for.
        :key str fgcolor: The color of the waveform, as hex triplet.
        :key str stream: The stream value of the audio channel within the component of the shape.
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: str.
                 If the method is called asynchronously, returns the request thread.
        :rtype: str or multiprocessing.pool.AsyncResult
        """
        kwargs['_return_http_data_only'] = True
        return self.get_item_waveform_all_tracks_with_http_info(item_id, **kwargs)  # noqa: E501

    def get_item_waveform_all_tracks_with_http_info(self, item_id, **kwargs):  # noqa: E501
        """Get waveform images for all audio channels  # noqa: E501

        Solely used for debugging. May be deprecated in newer releases.  Returns a HTML document including image references to waveform images for all channels. Query parameters can be used to control the image appearance.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_item_waveform_all_tracks_with_http_info(item_id, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str item_id: The item id. (required)
        :key str shape: The shape id to use to get information from.  If omitted the shape tag will be used.  Note that an analysis of this shape must be done before the information is available.
        :key str tag: The shape tag to use.
        :key int height: The height, in pixels, of the image.  Default is 100.
        :key str vgridline: The position of primary vertical gridlines, where 0 is left border and 1 is right border.
        :key str bgcolor: The background color of the image, as hex triplet.
        :key str end: The end time code to get waveform information for.
        :key float max: The audio value that corresponds the top border.  Defaults to `1` if `dB` is `false`, and `0` otherwise.
        :key int width: The number of sample points to return.
        :key str channel: The channel value of the audio channel within the stream of the component.  If `itemTrack` and `stream` are omitted, this value can be used to denote tracks in a linear fashion, regardless of `itemTrack` and `stream`.  Then `channel=0` means the first audio track, <pre>channel=1`</pre> the second, etc.
        :key str hgridline: The position of primary horizontal gridlines, in units of the audio.
        :key str vgridline2: The position of primary vertical gridlines, where 0 is left border and 1 is right border.
        :key float min: The audio value that corresponds the bottom border.  Defaults to `-1` if `dB` is `false`, and `-80` otherwise.
        :key str item_track: The `itemTrack` value of the audio channel within the shape.
        :key bool d_b: - `true` - Return RMS dB values.  - `false` (default) - Return RMS 1-based absolute values.
        :key str vgridlinecolor: The color of primary vertical gridlines
        :key str vgridline2color: The color of primary vertical gridlines
        :key str hgridline2: The position of secondary horizontal gridlines, in units of the audio.
        :key str hgridlinecolor: The color of primary horizontal gridlines.
        :key str hgridline2color: The color of secondary horizontal gridlines
        :key str start: The start time code to get waveform information for.
        :key str fgcolor: The color of the waveform, as hex triplet.
        :key str stream: The stream value of the audio channel within the component of the shape.
        :key _return_http_data_only: response data without head status code
                                       and headers
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(str, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['item_id', 'shape', 'tag', 'height', 'vgridline', 'bgcolor', 'end', 'max', 'width', 'channel', 'hgridline', 'vgridline2', 'min', 'item_track', 'd_b', 'vgridlinecolor', 'vgridline2color', 'hgridline2', 'hgridlinecolor', 'hgridline2color', 'start', 'fgcolor', 'stream']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_item_waveform_all_tracks" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'item_id' is set
        if ('item_id' not in local_var_params or
                local_var_params['item_id'] is None):
            raise ApiValueError("Missing the required parameter `item_id` when calling `get_item_waveform_all_tracks`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'item_id' in local_var_params:
            path_params['item-id'] = local_var_params['item_id']  # noqa: E501

        query_params = []
        if 'shape' in local_var_params:
            query_params.append(('shape', local_var_params['shape']))  # noqa: E501
        if 'tag' in local_var_params:
            query_params.append(('tag', local_var_params['tag']))  # noqa: E501
        if 'height' in local_var_params:
            query_params.append(('height', local_var_params['height']))  # noqa: E501
        if 'vgridline' in local_var_params:
            query_params.append(('vgridline', local_var_params['vgridline']))  # noqa: E501
        if 'bgcolor' in local_var_params:
            query_params.append(('bgcolor', local_var_params['bgcolor']))  # noqa: E501
        if 'end' in local_var_params:
            query_params.append(('end', local_var_params['end']))  # noqa: E501
        if 'max' in local_var_params:
            query_params.append(('max', local_var_params['max']))  # noqa: E501
        if 'width' in local_var_params:
            query_params.append(('width', local_var_params['width']))  # noqa: E501
        if 'channel' in local_var_params:
            query_params.append(('channel', local_var_params['channel']))  # noqa: E501
        if 'hgridline' in local_var_params:
            query_params.append(('hgridline', local_var_params['hgridline']))  # noqa: E501
        if 'vgridline2' in local_var_params:
            query_params.append(('vgridline2', local_var_params['vgridline2']))  # noqa: E501
        if 'min' in local_var_params:
            query_params.append(('min', local_var_params['min']))  # noqa: E501
        if 'item_track' in local_var_params:
            query_params.append(('itemTrack', local_var_params['item_track']))  # noqa: E501
        if 'd_b' in local_var_params:
            query_params.append(('dB', local_var_params['d_b']))  # noqa: E501
        if 'vgridlinecolor' in local_var_params:
            query_params.append(('vgridlinecolor', local_var_params['vgridlinecolor']))  # noqa: E501
        if 'vgridline2color' in local_var_params:
            query_params.append(('vgridline2color', local_var_params['vgridline2color']))  # noqa: E501
        if 'hgridline2' in local_var_params:
            query_params.append(('hgridline2', local_var_params['hgridline2']))  # noqa: E501
        if 'hgridlinecolor' in local_var_params:
            query_params.append(('hgridlinecolor', local_var_params['hgridlinecolor']))  # noqa: E501
        if 'hgridline2color' in local_var_params:
            query_params.append(('hgridline2color', local_var_params['hgridline2color']))  # noqa: E501
        if 'start' in local_var_params:
            query_params.append(('start', local_var_params['start']))  # noqa: E501
        if 'fgcolor' in local_var_params:
            query_params.append(('fgcolor', local_var_params['fgcolor']))  # noqa: E501
        if 'stream' in local_var_params:
            query_params.append(('stream', local_var_params['stream']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/html'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/item/{item-id}/waveform/alltracks', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='str',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_item_waveform_image(self, item_id, **kwargs):  # noqa: E501
        """Get waveform image  # noqa: E501

        Returns an image with the waveform drawn on the canvas as described by the query parameters.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_item_waveform_image(item_id, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str item_id: The item id. (required)
        :key str shape: The shape id to use to get information from.  If omitted the shape tag will be used.  Note that an analysis of this shape must be done before the information is available.
        :key str tag: The shape tag to use.
        :key int height: The height, in pixels, of the image.  Default is 100.
        :key str vgridline: The position of primary vertical gridlines, where 0 is left border and 1 is right border.
        :key str bgcolor: The background color of the image, as hex triplet.
        :key str end: The end time code to get waveform information for.
        :key float max: The audio value that corresponds the top border.  Defaults to `1` if `dB` is `false`, and `0` otherwise.
        :key int width: The number of sample points to return.
        :key str channel: The channel value of the audio channel within the stream of the component.  If `itemTrack` and `stream` are omitted, this value can be used to denote tracks in a linear fashion, regardless of `itemTrack` and `stream`.  Then `channel=0` means the first audio track, <pre>channel=1`</pre> the second, etc.
        :key str hgridline: The position of primary horizontal gridlines, in units of the audio.
        :key str vgridline2: The position of primary vertical gridlines, where 0 is left border and 1 is right border.
        :key float min: The audio value that corresponds the bottom border.  Defaults to `-1` if `dB` is `false`, and `-80` otherwise.
        :key str item_track: The `itemTrack` value of the audio channel within the shape.
        :key bool d_b: - `true` - Return RMS dB values.  - `false` (default) - Return RMS 1-based absolute values.
        :key str vgridlinecolor: The color of primary vertical gridlines
        :key str vgridline2color: The color of primary vertical gridlines
        :key str hgridline2: The position of secondary horizontal gridlines, in units of the audio.
        :key str hgridlinecolor: The color of primary horizontal gridlines.
        :key str hgridline2color: The color of secondary horizontal gridlines
        :key str start: The start time code to get waveform information for.
        :key str fgcolor: The color of the waveform, as hex triplet.
        :key str stream: The stream value of the audio channel within the component of the shape.
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: file.
                 If the method is called asynchronously, returns the request thread.
        :rtype: file or multiprocessing.pool.AsyncResult
        """
        kwargs['_return_http_data_only'] = True
        return self.get_item_waveform_image_with_http_info(item_id, **kwargs)  # noqa: E501

    def get_item_waveform_image_with_http_info(self, item_id, **kwargs):  # noqa: E501
        """Get waveform image  # noqa: E501

        Returns an image with the waveform drawn on the canvas as described by the query parameters.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_item_waveform_image_with_http_info(item_id, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str item_id: The item id. (required)
        :key str shape: The shape id to use to get information from.  If omitted the shape tag will be used.  Note that an analysis of this shape must be done before the information is available.
        :key str tag: The shape tag to use.
        :key int height: The height, in pixels, of the image.  Default is 100.
        :key str vgridline: The position of primary vertical gridlines, where 0 is left border and 1 is right border.
        :key str bgcolor: The background color of the image, as hex triplet.
        :key str end: The end time code to get waveform information for.
        :key float max: The audio value that corresponds the top border.  Defaults to `1` if `dB` is `false`, and `0` otherwise.
        :key int width: The number of sample points to return.
        :key str channel: The channel value of the audio channel within the stream of the component.  If `itemTrack` and `stream` are omitted, this value can be used to denote tracks in a linear fashion, regardless of `itemTrack` and `stream`.  Then `channel=0` means the first audio track, <pre>channel=1`</pre> the second, etc.
        :key str hgridline: The position of primary horizontal gridlines, in units of the audio.
        :key str vgridline2: The position of primary vertical gridlines, where 0 is left border and 1 is right border.
        :key float min: The audio value that corresponds the bottom border.  Defaults to `-1` if `dB` is `false`, and `-80` otherwise.
        :key str item_track: The `itemTrack` value of the audio channel within the shape.
        :key bool d_b: - `true` - Return RMS dB values.  - `false` (default) - Return RMS 1-based absolute values.
        :key str vgridlinecolor: The color of primary vertical gridlines
        :key str vgridline2color: The color of primary vertical gridlines
        :key str hgridline2: The position of secondary horizontal gridlines, in units of the audio.
        :key str hgridlinecolor: The color of primary horizontal gridlines.
        :key str hgridline2color: The color of secondary horizontal gridlines
        :key str start: The start time code to get waveform information for.
        :key str fgcolor: The color of the waveform, as hex triplet.
        :key str stream: The stream value of the audio channel within the component of the shape.
        :key _return_http_data_only: response data without head status code
                                       and headers
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(file, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['item_id', 'shape', 'tag', 'height', 'vgridline', 'bgcolor', 'end', 'max', 'width', 'channel', 'hgridline', 'vgridline2', 'min', 'item_track', 'd_b', 'vgridlinecolor', 'vgridline2color', 'hgridline2', 'hgridlinecolor', 'hgridline2color', 'start', 'fgcolor', 'stream']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_item_waveform_image" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'item_id' is set
        if ('item_id' not in local_var_params or
                local_var_params['item_id'] is None):
            raise ApiValueError("Missing the required parameter `item_id` when calling `get_item_waveform_image`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'item_id' in local_var_params:
            path_params['item-id'] = local_var_params['item_id']  # noqa: E501

        query_params = []
        if 'shape' in local_var_params:
            query_params.append(('shape', local_var_params['shape']))  # noqa: E501
        if 'tag' in local_var_params:
            query_params.append(('tag', local_var_params['tag']))  # noqa: E501
        if 'height' in local_var_params:
            query_params.append(('height', local_var_params['height']))  # noqa: E501
        if 'vgridline' in local_var_params:
            query_params.append(('vgridline', local_var_params['vgridline']))  # noqa: E501
        if 'bgcolor' in local_var_params:
            query_params.append(('bgcolor', local_var_params['bgcolor']))  # noqa: E501
        if 'end' in local_var_params:
            query_params.append(('end', local_var_params['end']))  # noqa: E501
        if 'max' in local_var_params:
            query_params.append(('max', local_var_params['max']))  # noqa: E501
        if 'width' in local_var_params:
            query_params.append(('width', local_var_params['width']))  # noqa: E501
        if 'channel' in local_var_params:
            query_params.append(('channel', local_var_params['channel']))  # noqa: E501
        if 'hgridline' in local_var_params:
            query_params.append(('hgridline', local_var_params['hgridline']))  # noqa: E501
        if 'vgridline2' in local_var_params:
            query_params.append(('vgridline2', local_var_params['vgridline2']))  # noqa: E501
        if 'min' in local_var_params:
            query_params.append(('min', local_var_params['min']))  # noqa: E501
        if 'item_track' in local_var_params:
            query_params.append(('itemTrack', local_var_params['item_track']))  # noqa: E501
        if 'd_b' in local_var_params:
            query_params.append(('dB', local_var_params['d_b']))  # noqa: E501
        if 'vgridlinecolor' in local_var_params:
            query_params.append(('vgridlinecolor', local_var_params['vgridlinecolor']))  # noqa: E501
        if 'vgridline2color' in local_var_params:
            query_params.append(('vgridline2color', local_var_params['vgridline2color']))  # noqa: E501
        if 'hgridline2' in local_var_params:
            query_params.append(('hgridline2', local_var_params['hgridline2']))  # noqa: E501
        if 'hgridlinecolor' in local_var_params:
            query_params.append(('hgridlinecolor', local_var_params['hgridlinecolor']))  # noqa: E501
        if 'hgridline2color' in local_var_params:
            query_params.append(('hgridline2color', local_var_params['hgridline2color']))  # noqa: E501
        if 'start' in local_var_params:
            query_params.append(('start', local_var_params['start']))  # noqa: E501
        if 'fgcolor' in local_var_params:
            query_params.append(('fgcolor', local_var_params['fgcolor']))  # noqa: E501
        if 'stream' in local_var_params:
            query_params.append(('stream', local_var_params['stream']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['image/png'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/item/{item-id}/waveform/image', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='file',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_item_waveform_image_uri(self, item_id, **kwargs):  # noqa: E501
        """Get waveform image URI  # noqa: E501

        Returns a URI that does not require authentication to the generated image. The URI expires after 1 hour.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_item_waveform_image_uri(item_id, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str item_id: The item id. (required)
        :key str shape: The shape id to use to get information from.  If omitted the shape tag will be used.  Note that an analysis of this shape must be done before the information is available.
        :key str tag: The shape tag to use.
        :key int height: The height, in pixels, of the image.  Default is 100.
        :key str vgridline: The position of primary vertical gridlines, where 0 is left border and 1 is right border.
        :key str bgcolor: The background color of the image, as hex triplet.
        :key str end: The end time code to get waveform information for.
        :key float max: The audio value that corresponds the top border.  Defaults to `1` if `dB` is `false`, and `0` otherwise.
        :key int width: The number of sample points to return.
        :key str channel: The channel value of the audio channel within the stream of the component.  If `itemTrack` and `stream` are omitted, this value can be used to denote tracks in a linear fashion, regardless of `itemTrack` and `stream`.  Then `channel=0` means the first audio track, <pre>channel=1`</pre> the second, etc.
        :key str hgridline: The position of primary horizontal gridlines, in units of the audio.
        :key str vgridline2: The position of primary vertical gridlines, where 0 is left border and 1 is right border.
        :key float min: The audio value that corresponds the bottom border.  Defaults to `-1` if `dB` is `false`, and `-80` otherwise.
        :key str item_track: The `itemTrack` value of the audio channel within the shape.
        :key bool d_b: - `true` - Return RMS dB values.  - `false` (default) - Return RMS 1-based absolute values.
        :key str vgridlinecolor: The color of primary vertical gridlines
        :key str vgridline2color: The color of primary vertical gridlines
        :key str hgridline2: The position of secondary horizontal gridlines, in units of the audio.
        :key str hgridlinecolor: The color of primary horizontal gridlines.
        :key str hgridline2color: The color of secondary horizontal gridlines
        :key str start: The start time code to get waveform information for.
        :key str fgcolor: The color of the waveform, as hex triplet.
        :key str stream: The stream value of the audio channel within the component of the shape.
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: str.
                 If the method is called asynchronously, returns the request thread.
        :rtype: str or multiprocessing.pool.AsyncResult
        """
        kwargs['_return_http_data_only'] = True
        return self.get_item_waveform_image_uri_with_http_info(item_id, **kwargs)  # noqa: E501

    def get_item_waveform_image_uri_with_http_info(self, item_id, **kwargs):  # noqa: E501
        """Get waveform image URI  # noqa: E501

        Returns a URI that does not require authentication to the generated image. The URI expires after 1 hour.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_item_waveform_image_uri_with_http_info(item_id, async_req=True)
        >>> result = thread.get()

        :key bool async_req: execute request asynchronously
        :param str item_id: The item id. (required)
        :key str shape: The shape id to use to get information from.  If omitted the shape tag will be used.  Note that an analysis of this shape must be done before the information is available.
        :key str tag: The shape tag to use.
        :key int height: The height, in pixels, of the image.  Default is 100.
        :key str vgridline: The position of primary vertical gridlines, where 0 is left border and 1 is right border.
        :key str bgcolor: The background color of the image, as hex triplet.
        :key str end: The end time code to get waveform information for.
        :key float max: The audio value that corresponds the top border.  Defaults to `1` if `dB` is `false`, and `0` otherwise.
        :key int width: The number of sample points to return.
        :key str channel: The channel value of the audio channel within the stream of the component.  If `itemTrack` and `stream` are omitted, this value can be used to denote tracks in a linear fashion, regardless of `itemTrack` and `stream`.  Then `channel=0` means the first audio track, <pre>channel=1`</pre> the second, etc.
        :key str hgridline: The position of primary horizontal gridlines, in units of the audio.
        :key str vgridline2: The position of primary vertical gridlines, where 0 is left border and 1 is right border.
        :key float min: The audio value that corresponds the bottom border.  Defaults to `-1` if `dB` is `false`, and `-80` otherwise.
        :key str item_track: The `itemTrack` value of the audio channel within the shape.
        :key bool d_b: - `true` - Return RMS dB values.  - `false` (default) - Return RMS 1-based absolute values.
        :key str vgridlinecolor: The color of primary vertical gridlines
        :key str vgridline2color: The color of primary vertical gridlines
        :key str hgridline2: The position of secondary horizontal gridlines, in units of the audio.
        :key str hgridlinecolor: The color of primary horizontal gridlines.
        :key str hgridline2color: The color of secondary horizontal gridlines
        :key str start: The start time code to get waveform information for.
        :key str fgcolor: The color of the waveform, as hex triplet.
        :key str stream: The stream value of the audio channel within the component of the shape.
        :key _return_http_data_only: response data without head status code
                                       and headers
        :key _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :key _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(str, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['item_id', 'shape', 'tag', 'height', 'vgridline', 'bgcolor', 'end', 'max', 'width', 'channel', 'hgridline', 'vgridline2', 'min', 'item_track', 'd_b', 'vgridlinecolor', 'vgridline2color', 'hgridline2', 'hgridlinecolor', 'hgridline2color', 'start', 'fgcolor', 'stream']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_item_waveform_image_uri" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'item_id' is set
        if ('item_id' not in local_var_params or
                local_var_params['item_id'] is None):
            raise ApiValueError("Missing the required parameter `item_id` when calling `get_item_waveform_image_uri`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'item_id' in local_var_params:
            path_params['item-id'] = local_var_params['item_id']  # noqa: E501

        query_params = []
        if 'shape' in local_var_params:
            query_params.append(('shape', local_var_params['shape']))  # noqa: E501
        if 'tag' in local_var_params:
            query_params.append(('tag', local_var_params['tag']))  # noqa: E501
        if 'height' in local_var_params:
            query_params.append(('height', local_var_params['height']))  # noqa: E501
        if 'vgridline' in local_var_params:
            query_params.append(('vgridline', local_var_params['vgridline']))  # noqa: E501
        if 'bgcolor' in local_var_params:
            query_params.append(('bgcolor', local_var_params['bgcolor']))  # noqa: E501
        if 'end' in local_var_params:
            query_params.append(('end', local_var_params['end']))  # noqa: E501
        if 'max' in local_var_params:
            query_params.append(('max', local_var_params['max']))  # noqa: E501
        if 'width' in local_var_params:
            query_params.append(('width', local_var_params['width']))  # noqa: E501
        if 'channel' in local_var_params:
            query_params.append(('channel', local_var_params['channel']))  # noqa: E501
        if 'hgridline' in local_var_params:
            query_params.append(('hgridline', local_var_params['hgridline']))  # noqa: E501
        if 'vgridline2' in local_var_params:
            query_params.append(('vgridline2', local_var_params['vgridline2']))  # noqa: E501
        if 'min' in local_var_params:
            query_params.append(('min', local_var_params['min']))  # noqa: E501
        if 'item_track' in local_var_params:
            query_params.append(('itemTrack', local_var_params['item_track']))  # noqa: E501
        if 'd_b' in local_var_params:
            query_params.append(('dB', local_var_params['d_b']))  # noqa: E501
        if 'vgridlinecolor' in local_var_params:
            query_params.append(('vgridlinecolor', local_var_params['vgridlinecolor']))  # noqa: E501
        if 'vgridline2color' in local_var_params:
            query_params.append(('vgridline2color', local_var_params['vgridline2color']))  # noqa: E501
        if 'hgridline2' in local_var_params:
            query_params.append(('hgridline2', local_var_params['hgridline2']))  # noqa: E501
        if 'hgridlinecolor' in local_var_params:
            query_params.append(('hgridlinecolor', local_var_params['hgridlinecolor']))  # noqa: E501
        if 'hgridline2color' in local_var_params:
            query_params.append(('hgridline2color', local_var_params['hgridline2color']))  # noqa: E501
        if 'start' in local_var_params:
            query_params.append(('start', local_var_params['start']))  # noqa: E501
        if 'fgcolor' in local_var_params:
            query_params.append(('fgcolor', local_var_params['fgcolor']))  # noqa: E501
        if 'stream' in local_var_params:
            query_params.append(('stream', local_var_params['stream']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/item/{item-id}/waveform/imageURI', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='str',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)
