from datetime import datetime, timezone
from unittest import main, TestCase
import sys

sys.path.insert(0,'..')
from str2date import str2date

_utc = timezone. utc

class Run( TestCase ):

    def test_proper_extended( self ):
        cases = (
            ( '1969', ( 1969, 1, 1, 0, 0, 0, 0, _utc )),
            ( '1969-07', ( 1969, 7, 1, 0, 0, 0, 0, _utc )),
            ( '1969-07-20', ( 1969, 7, 20, 0, 0, 0, 0, _utc )),
            ( '1969-07-20T20', ( 1969, 7, 20, 20, 0, 0, 0, _utc )),
            ( '1969-07-20T20:18', ( 1969, 7, 20, 20, 18, 0, 0, _utc )),
            ( '1969-07-20T20:18:30', ( 1969, 7, 20, 20, 18, 30, 0, _utc )),
            ( '1969-07-20T20:18:30.12', ( 1969, 7, 20, 20, 18, 30, 120000, _utc )),
            ( '1969-07-20T20:18:30,12', ( 1969, 7, 20, 20, 18, 30, 120000, _utc )),
            ( '1969-07-20T20Z', ( 1969, 7, 20, 20, 0, 0, 0, _utc )),
            ( '1969-07-20T20:18Z', ( 1969, 7, 20, 20, 18, 0, 0, _utc )),
            ( '1969-07-20T20:18:30Z', ( 1969, 7, 20, 20, 18, 30, 0, _utc )),
            ( '1969-07-20T20:18:30.12Z', ( 1969, 7, 20, 20, 18, 30, 120000, _utc )),
            ( '1969-07-20T20:18:30,12Z', ( 1969, 7, 20, 20, 18, 30, 120000, _utc )),
            ( '1969-07-20T20z', ( 1969, 7, 20, 20, 0, 0, 0, _utc )),
            ( '1969-07-20T20:18z', ( 1969, 7, 20, 20, 18, 0, 0, _utc )),
            ( '1969-07-20T20:18:30z', ( 1969, 7, 20, 20, 18, 30, 0, _utc )),
            ( '1969-07-20T20:18:30.12z', ( 1969, 7, 20, 20, 18, 30, 120000, _utc )),
            ( '1969-07-20T20:18:30,12z', ( 1969, 7, 20, 20, 18, 30, 120000, _utc )),
            ( '1969-07-20T16-04:00', ( 1969, 7, 20, 20, 0, 0, 0, _utc )),
            ( '1969-07-20T16:18-04:00', ( 1969, 7, 20, 20, 18, 0, 0, _utc )),
            ( '1969-07-20T16:18:30-04:00', ( 1969, 7, 20, 20, 18, 30, 0, _utc )),
            ( '1969-07-20T16:18:30.12-04:00', ( 1969, 7, 20, 20, 18, 30, 120000, _utc )),
            ( '1969-07-20T16:18:30,12-04:00', ( 1969, 7, 20, 20, 18, 30, 120000, _utc )),
            ( '1969-07-21T00+04:00', ( 1969, 7, 20, 20, 0, 0, 0, _utc )),
            ( '1969-07-21T00:18+04:00', ( 1969, 7, 20, 20, 18, 0, 0, _utc )),
            ( '1969-07-21T00:18:30+04:00', ( 1969, 7, 20, 20, 18, 30, 0, _utc )),
            ( '1969-07-21T00:18:30.12+04:00', ( 1969, 7, 20, 20, 18, 30, 120000, _utc )),
            ( '1969-07-21T00:18:30,12+04:00', ( 1969, 7, 20, 20, 18, 30, 120000, _utc )),
            ( '1969-07-20 20', ( 1969, 7, 20, 20, 0, 0, 0, _utc )),
            ( '1969-07-20 20:18', ( 1969, 7, 20, 20, 18, 0, 0, _utc )),
            ( '1969-07-20 20:18:30', ( 1969, 7, 20, 20, 18, 30, 0, _utc )),
            ( '1969-07-20 20:18:30.12', ( 1969, 7, 20, 20, 18, 30, 120000, _utc )),
            ( '1969-07-20 20:18:30,12', ( 1969, 7, 20, 20, 18, 30, 120000, _utc )),
            ( '1969-07-20 20Z', ( 1969, 7, 20, 20, 0, 0, 0, _utc )),
            ( '1969-07-20 20:18Z', ( 1969, 7, 20, 20, 18, 0, 0, _utc )),
            ( '1969-07-20 20:18:30Z', ( 1969, 7, 20, 20, 18, 30, 0, _utc )),
            ( '1969-07-20 20:18:30.12Z', ( 1969, 7, 20, 20, 18, 30, 120000, _utc )),
            ( '1969-07-20 20:18:30,12Z', ( 1969, 7, 20, 20, 18, 30, 120000, _utc )),
            ( '1969-07-20 20z', ( 1969, 7, 20, 20, 0, 0, 0, _utc )),
            ( '1969-07-20 20:18z', ( 1969, 7, 20, 20, 18, 0, 0, _utc )),
            ( '1969-07-20 20:18:30z', ( 1969, 7, 20, 20, 18, 30, 0, _utc )),
            ( '1969-07-20 20:18:30.12z', ( 1969, 7, 20, 20, 18, 30, 120000, _utc )),
            ( '1969-07-20 20:18:30,12z', ( 1969, 7, 20, 20, 18, 30, 120000, _utc )),
            ( '1969-07-20 16-04:00', ( 1969, 7, 20, 20, 0, 0, 0, _utc )),
            ( '1969-07-20 16:18-04:00', ( 1969, 7, 20, 20, 18, 0, 0, _utc )),
            ( '1969-07-20 16:18:30-04:00', ( 1969, 7, 20, 20, 18, 30, 0, _utc )),
            ( '1969-07-20 16:18:30.12-04:00', ( 1969, 7, 20, 20, 18, 30, 120000, _utc )),
            ( '1969-07-20 16:18:30,12-04:00', ( 1969, 7, 20, 20, 18, 30, 120000, _utc )),
            ( '1969-07-21 00+04:00', ( 1969, 7, 20, 20, 0, 0, 0, _utc )),
            ( '1969-07-21 00:18+04:00', ( 1969, 7, 20, 20, 18, 0, 0, _utc )),
            ( '1969-07-21 00:18:30+04:00', ( 1969, 7, 20, 20, 18, 30, 0, _utc )),
            ( '1969-07-21 00:18:30.12+04:00', ( 1969, 7, 20, 20, 18, 30, 120000, _utc )),
            ( '1969-07-21 00:18:30,12+04:00', ( 1969, 7, 20, 20, 18, 30, 120000, _utc )),
        )
        for date_str, date_tuple in cases:
            self. assertEqual( str2date( date_str ), datetime( *date_tuple ))

    def test_proper_basic( self ):
        cases = (
            ( '196907', ( 1969, 7, 1, 0, 0, 0, 0, _utc )),
            ( '19690720', ( 1969, 7, 20, 0, 0, 0, 0, _utc )),
            ( '19690720T20', ( 1969, 7, 20, 20, 0, 0, 0, _utc )),
            ( '19690720T2018', ( 1969, 7, 20, 20, 18, 0, 0, _utc )),
            ( '19690720T201830', ( 1969, 7, 20, 20, 18, 30, 0, _utc )),
            ( '19690720T201830.12', ( 1969, 7, 20, 20, 18, 30, 120000, _utc )),
            ( '19690720T201830,12', ( 1969, 7, 20, 20, 18, 30, 120000, _utc )),
            ( '19690720T20Z', ( 1969, 7, 20, 20, 0, 0, 0, _utc )),
            ( '19690720T2018Z', ( 1969, 7, 20, 20, 18, 0, 0, _utc )),
            ( '19690720T201830Z', ( 1969, 7, 20, 20, 18, 30, 0, _utc )),
            ( '19690720T201830.12Z', ( 1969, 7, 20, 20, 18, 30, 120000, _utc )),
            ( '19690720T201830,12Z', ( 1969, 7, 20, 20, 18, 30, 120000, _utc )),
            ( '19690720T20z', ( 1969, 7, 20, 20, 0, 0, 0, _utc )),
            ( '19690720T2018z', ( 1969, 7, 20, 20, 18, 0, 0, _utc )),
            ( '19690720T201830z', ( 1969, 7, 20, 20, 18, 30, 0, _utc )),
            ( '19690720T201830.12z', ( 1969, 7, 20, 20, 18, 30, 120000, _utc )),
            ( '19690720T201830,12z', ( 1969, 7, 20, 20, 18, 30, 120000, _utc )),
            ( '19690720T16-0400', ( 1969, 7, 20, 20, 0, 0, 0, _utc )),
            ( '19690720T1618-0400', ( 1969, 7, 20, 20, 18, 0, 0, _utc )),
            ( '19690720T161830-0400', ( 1969, 7, 20, 20, 18, 30, 0, _utc )),
            ( '19690720T161830.12-0400', ( 1969, 7, 20, 20, 18, 30, 120000, _utc )),
            ( '19690720T161830,12-0400', ( 1969, 7, 20, 20, 18, 30, 120000, _utc )),
            ( '19690721T00+0400', ( 1969, 7, 20, 20, 0, 0, 0, _utc )),
            ( '19690721T0018+0400', ( 1969, 7, 20, 20, 18, 0, 0, _utc )),
            ( '19690721T001830+0400', ( 1969, 7, 20, 20, 18, 30, 0, _utc )),
            ( '19690721T001830.12+0400', ( 1969, 7, 20, 20, 18, 30, 120000, _utc )),
            ( '19690721T001830,12+0400', ( 1969, 7, 20, 20, 18, 30, 120000, _utc )),
            ( '19690720 20', ( 1969, 7, 20, 20, 0, 0, 0, _utc )),
            ( '19690720 2018', ( 1969, 7, 20, 20, 18, 0, 0, _utc )),
            ( '19690720 201830', ( 1969, 7, 20, 20, 18, 30, 0, _utc )),
            ( '19690720 201830.12', ( 1969, 7, 20, 20, 18, 30, 120000, _utc )),
            ( '19690720 201830,12', ( 1969, 7, 20, 20, 18, 30, 120000, _utc )),
            ( '19690720 20Z', ( 1969, 7, 20, 20, 0, 0, 0, _utc )),
            ( '19690720 2018Z', ( 1969, 7, 20, 20, 18, 0, 0, _utc )),
            ( '19690720 201830Z', ( 1969, 7, 20, 20, 18, 30, 0, _utc )),
            ( '19690720 201830.12Z', ( 1969, 7, 20, 20, 18, 30, 120000, _utc )),
            ( '19690720 201830,12Z', ( 1969, 7, 20, 20, 18, 30, 120000, _utc )),
            ( '19690720 20z', ( 1969, 7, 20, 20, 0, 0, 0, _utc )),
            ( '19690720 2018z', ( 1969, 7, 20, 20, 18, 0, 0, _utc )),
            ( '19690720 201830z', ( 1969, 7, 20, 20, 18, 30, 0, _utc )),
            ( '19690720 201830.12z', ( 1969, 7, 20, 20, 18, 30, 120000, _utc )),
            ( '19690720 201830,12z', ( 1969, 7, 20, 20, 18, 30, 120000, _utc )),
            ( '19690720 16-0400', ( 1969, 7, 20, 20, 0, 0, 0, _utc )),
            ( '19690720 1618-0400', ( 1969, 7, 20, 20, 18, 0, 0, _utc )),
            ( '19690720 161830-0400', ( 1969, 7, 20, 20, 18, 30, 0, _utc )),
            ( '19690720 161830.12-0400', ( 1969, 7, 20, 20, 18, 30, 120000, _utc )),
            ( '19690720 161830,12-0400', ( 1969, 7, 20, 20, 18, 30, 120000, _utc )),
            ( '19690721 00+0400', ( 1969, 7, 20, 20, 0, 0, 0, _utc )),
            ( '19690721 0018+0400', ( 1969, 7, 20, 20, 18, 0, 0, _utc )),
            ( '19690721 001830+0400', ( 1969, 7, 20, 20, 18, 30, 0, _utc )),
            ( '19690721 001830.12+0400', ( 1969, 7, 20, 20, 18, 30, 120000, _utc )),
            ( '19690721 001830,12+0400', ( 1969, 7, 20, 20, 18, 30, 120000, _utc )),
        )
        for date_str, date_tuple in cases:
            self. assertEqual( str2date( date_str ), datetime( *date_tuple ))

    def test_fraction( self ):
        cases = (
            ( '1969-07-20 20.3', ( 1969, 7, 20, 20, 18, 0, 0, _utc )),
            ( '1969-07-20 20,3', ( 1969, 7, 20, 20, 18, 0, 0, _utc )),
            ( '1969-07-20 20:18.5', ( 1969, 7, 20, 20, 18, 30, 0, _utc )),
            ( '1969-07-20 20:18,5', ( 1969, 7, 20, 20, 18, 30, 0, _utc )),
        )
        for date_str, date_tuple in cases:
            self. assertEqual( str2date( date_str ), datetime( *date_tuple ))

if __name__ == '__main__':
    main()






