"""Comment, Strategy cross reference."""

from .comment_xref import convert_text_to_html

strategy_descriptions = {
                '0000': 'Not allocated',
                '0001': '1NT opener',
                '0002': '2C opener',
                '0003': '1 suit opener',
                '0004': '2NT opener',
                '0005': 'Opening Pass',
                '0006': 'Weak opener pre-empt',
                '0007': 'Responses to Blackwood',
                '0008': '',
                '0009': 'Response to suit',
                '0010': 'Response to 1NT, weak',
                '0011': 'Response to 1NT, 11- 12 pts',
                '0012': 'Response to 1NT strong',
                '0013': 'Response to 2NT',
                '0014': 'Response to 2C',
                '0015': 'Response  0 to 5 points',
                '0016': 'Response to a weak two',
                '0017': 'Response to a weak three',
                '0018': 'Openers rebid: suit support',
                '0019': 'Openers rebid after opening 1NT',
                '0020': 'Openers rebid after opening 2NT',
                '0021': 'Openers rebid: suit NT response',
                '0022': 'Openers rebid: suit no support',
                '0023': 'Openers rebid: 4441',
                '0024': 'Openers rebid: suit support for partner',
                '0025': 'Openers rebid: strong balanced',
                '0026': 'Openers rebid: after weak two',
                '0027': 'Openers rebid: after 2C',
                '0028': '',
                '0029': '',
                '0030': '',
                '0031': 'Responders rebid: supported opener',
                '0032': 'Responders rebid: opener bid NT (Stayman)',
                '0033': 'Responders rebid: no support for opener',
                '0034': 'Responders rebid: after 1NT (dustbin)',
                '0035': 'Responders rebid: opener supports responders suit',
                '0036': 'Responders rebid: opener bid NT (Weak takeout)',
                '0037': 'Responders rebid: opener bid NT (Shows suit)',
                '0038': 'Responders rebid: opener weak 2',
               }


class StrategyXref(object):
    """Provide a cross reference between strategy_id and the text."""
    def strategy(self, comment_id):
        """Return the basic i18n code for the comment associated with the comment_id."""
        strategy = convert_text_to_html(_('strategy comment '+self.strategies[comment_id]))
        return strategy

    strategies = {'comment_id': 'strategy_id',
                  '0000': '0000',
                  '0001': '0005',
                  '0002': '0001',
                  '0003': '0004',
                  '0004': '0003',
                  '0005': '0002',
                  '0006': '0003',
                  '0007': '0003',
                  '0008': '0003',
                  '0009': '0009',
                  '0010': '0003',
                  '0011': '0006',
                  '0012': '0006',
                  '0013': '0012',
                  '0014': '0011',
                  '0015': '0012',
                  '0016': '0022',
                  '0017': '0012',
                  '0018': '0009',
                  '0019': '0009',
                  '0020': '0009',
                  '0021': '0013',
                  '0022': '0009',
                  '0023': '0009',
                  '0024': '0009',
                  '0025': '0009',
                  '0026': '0009',
                  '0027': '0016',
                  '0028': '0012',
                  '0029': '0000',
                  '0030': '0013',
                  '0031': '0016',
                  '0032': '0016',
                  '0033': '0014',
                  '0034': '0014',
                  '0035': '0017',
                  '0036': '0009',
                  '0037': '0017',
                  '0038': '0022',
                  '0039': '0022',
                  '0040': '0019',
                  '0041': '0009',
                  '0042': '0000',
                  '0043': '0019',
                  '0044': '0019',
                  '0045': '0022',
                  '0046': '0019',
                  '0047': '0019',
                  '0048': '0024',
                  '0049': '0009',
                  '0050': '0021',
                  '0051': '0009',
                  '0052': '0007',
                  '0053': '0009',
                  '0054': '0009',
                  '0055': '0018',
                  '0056': '0021',
                  '0057': '0009',
                  '0058': '0009',
                  '0059': '0018',
                  '0060': '0009',
                  '0061': '0012',
                  '0062': '0017',
                  '0063': '0017',
                  '0064': '0000',
                  '0065': '0000',
                  '0066': '0009',
                  '0067': '0022',
                  '0068': '0012',
                  '0069': '0022',
                  '0070': '0009',
                  '0071': '0022',
                  '0072': '0022',
                  '0073': '0033',
                  '0074': '0022',
                  '0075': '0033',
                  '0076': '0034',
                  '0077': '0034',
                  '0078': '0034',
                  '0079': '0033',
                  '0080': '0033',
                  '0081': '0000',
                  '0082': '0009',
                  '0083': '0000',
                  '0084': '0033',
                  '0085': '0033',
                  '0086': '0014',
                  '0087': '0009',
                  '0088': '0000',
                  '0089': '0000',
                  '0090': '0000',
                  '0091': '0000',
                  '0092': '0000',
                  '0093': '0003',
                  '0094': '0019',
                  '0095': '0000',
                  '0096': '0003',
                  '0097': '0023',
                  '0098': '0023',
                  '0099': '0000',
                  '0100': '0000',
                  '0101': '0019',
                  '0102': '0000',
                  '0103': '0013',
                  '0104': '0019',
                  '0105': '0033',
                  '0106': '0033',
                  '0107': '0033',
                  '0108': '0033',
                  '0109': '0024',
                  '0110': '0035',
                  '0111': '0035',
                  '0112': '0000',
                  '0113': '0000',
                  '0114': '0000',
                  '0115': '0018',
                  '0116': '0020',
                  '0117': '0000',
                  '0118': '0018',
                  '0119': '0033',
                  '0120': '0031',
                  '0121': '0032',
                  '0122': '0000',
                  '0123': '0000',
                  '0124': '0000',
                  '0125': '0022',
                  '0126': '0000',
                  '0127': '0000',
                  '0128': '0009',
                  '0129': '0000',
                  '0130': '0018',
                  '0131': '0000',
                  '0132': '0000',
                  '0133': '0007',
                  '0134': '0000',
                  '0135': '0000',
                  '0136': '0016',
                  '0137': '0003',
                  '0138': '0019',
                  '0139': '0022',
                  '0140': '0019',
                  '0141': '0009',
                  '0142': '0009',
                  '0143': '0000',
                  '0144': '0000',
                  '0145': '0027',
                  '0146': '0021',
                  '0147': '0025',
                  '0148': '0000',
                  '0149': '0000',
                  '0150': '0000',
                  '0151': '0021',
                  '0152': '0022',
                  '0153': '0006',
                  '0154': '0000',
                  '0155': '0024',
                  '0156': '0000',
                  '0157': '0000',
                  '0158': '0000',
                  '0159': '0000',
                  '0160': '0000',
                  '0161': '0000',
                  '0162': '0000',
                  '0163': '0022',
                  '0164': '0000',
                  '0165': '0024',
                  '0166': '0000',
                  '0167': '0022',
                  '0168': '0000',
                  '0169': '0000',
                  '0170': '0000',
                  '0171': '0000',
                  '0172': '0000',
                  '0173': '0000',
                  '0174': '0000',
                  '0175': '0022',
                  '0176': '0000',
                  '0177': '0000',
                  '0178': '0033',
                  '0179': '0000',
                  '0180': '0000',
                  '0181': '0000',
                  '0182': '0033',
                  '0183': '0000',
                  '0184': '0022',
                  '0185': '0022',
                  '0186': '0022',
                  '0187': '0000',
                  '0188': '0033',
                  '0189': '0033',
                  '0190': '0033',
                  '0191': '0024',
                  '0192': '0033',
                  '0193': '0000',
                  '0194': '0024',
                  '0195': '0022',
                  '0196': '0000',
                  '0197': '0000',
                  '0198': '0000',
                  '0199': '0022',
                  '0200': '0000',
                  '0201': '0022',
                  '0202': '0022',
                  '0203': '0022',
                  '0204': '0031',
                  '0205': '0033',
                  '0206': '0033',
                  '0207': '0000',
                  '0208': '0022',
                  '0209': '0033',
                  '0210': '0000',
                  '0211': '0000',
                  '0212': '0000',
                  '0213': '0000',
                  '0214': '0022',
                  '0215': '0019',
                  '0216': '0022',
                  '0217': '0000',
                  '0218': '0022',
                  '0219': '0012',
                  '0220': '0022',
                  '0221': '0000',
                  '0222': '0000',
                  '0223': '0033',
                  '0224': '0031',
                  '0225': '0000',
                  '0226': '0000',
                  '0227': '0000',
                  '0228': '0000',
                  '0229': '0000',
                  '0230': '0000',
                  '0231': '0000',
                  '0232': '0012',
                  '0233': '0000',
                  '0234': '0033',
                  '0235': '0019',
                  '0236': '0022',
                  '0237': '0000',
                  '0238': '0033',
                  '0239': '0022',
                  '0240': '0022',
                  '0241': '0019',
                  '0242': '0026',
                  '0243': '0022',
                  '0244': '0022',
                  '0245': '0022',
                  '0246': '0018',
                  '0247': '0024',
                  '0248': '0022',
                  '0249': '0022',
                  '0250': '0018',
                  '0251': '0022',
                  '0252': '0019',
                  '0253': '0022',
                  '0254': '0020',
                  '0255': '0022',
                  '0256': '0022',
                  '0257': '0022',
                  '0258': '0021',
                  '0259': '0024',
                  '0260': '0022',
                  '0261': '0022',
                  '0262': '0022',
                  '0263': '0018',
                  '0264': '0024',
                  '0265': '0022',
                  '0266': '0022',
                  '0267': '0034',
                  '0268': '0032',
                  '0269': '0033',
                  '0270': '0033',
                  '0271': '0007',
                  '0272': '0007',
                  '0273': '0034',
                  '0274': '0034',
                  '0275': '0033',
                  '0276': '0037',
                  '0277': '0033',
                  # '0278': '0033',
                  '0278': '0034',
                  '0279': '0032',
                  '0280': '0035',
                  '0281': '0035',
                  '0282': '0035',
                  '0283': '0033',
                  '0284': '0032',
                  '0285': '0033',
                  '0286': '0033',
                  '0287': '0033',
                  '0288': '0033',
                  '0289': '0035',
                  '0290': '0033',
                  '0291': '0033',
                  '0292': '0031',
                  '0293': '0032',
                  '0294': '0032',
                  '0295': '0032',
                  '0296': '0032',
                  '0297': '0032',
                  '0298': '0031',
                  '0299': '0031',
                  '0300': '0031',
                  '0301': '0036',
                  '0302': '0033',
                  '0303': '0033',
                  '0304': '0033',
                  '0305': '0033',
                  '0306': '0031',
                  '0307': '0033',
                  '0308': '0031',
                  '0309': '0033',
                  '0310': '0037',
                  '0311': '0035',
                  '0312': '0031',
                  '0313': '0031',
                  '0314': '0033',
                  '0315': '0033',
                  '0316': '0033',
                  '0317': '0033',
                  '0318': '0036',
                  '0319': '0033',
                  '0320': '0033',
                  '0321': '0033',
                  '0322': '0037',
                  '0323': '0038',
                  '0324': '0031',
                  '0325': '0033',
                  '0326': '0032',
                  '0327': '0033',
                  '0328': '0033',
                  '0329': '0031',
                  '0330': '0031',
                  '0331': '0031',
                  '0332': '0031',
                  '0333': '0037',
                  '0334': '0003',
                  '0335': '0003',
                  '0336': '0009',
                  '0337': '0013',
                  '0338': '0016',
                  '0339': '0000',
                  '0340': '0012',
                  '0341': '0000',
                  '0342': '0000',
                  '0343': '0000',
                  '0344': '0000',
                  '0345': '0000',
                  '0346': '0000',
                  '0347': '0000',
                  '0348': '0013',
                  '0349': '0000',
                  '0350': '0009',
                  '0351': '0012',
                  '0352': '0000',
                  '0353': '0016',
                  '0354': '0012',
                  '0355': '0000',
                  '0356': '0009',
                  '0357': '0012',
                  '0358': '0016',
                  '0359': '0017',
                  '0360': '0016',
                  '0361': '0016',
                  '0362': '0003',
                  '0363': '0000',
                  '0364': '0000',
                  '0365': '0000',
                  '0366': '0000',
                  '0367': '0000',
                  '0368': '0000',
                  '0369': '0000',
                  '0370': '0000',
                  '0371': '0000',
                  '0372': '0000',
                  '0373': '0000',
                  '0374': '0000',
                  '0375': '0000',
                  '0376': '0000',
                  '0377': '0000',
                  '0378': '0000',
                  '0379': '0000',
                  '0380': '0000',
                  }
