/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build;

import VASSAL.build.AbstractBuildable;
import VASSAL.build.Buildable;
import VASSAL.build.GameModule;
import VASSAL.build.IllegalBuildException;
import VASSAL.tools.ErrorDialog;
import VASSAL.tools.ThrowableUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.SAXException;

public class Builder {
    private static final Logger logger = LoggerFactory.getLogger(Builder.class);

    private Builder() {
    }

    public static void build(Element e, Buildable parent) {
        if (e == null) {
            return;
        }
        for (Node child = e.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (1 != child.getNodeType()) continue;
            try {
                Buildable b = Builder.create((Element)child, parent);
                if (parent == null) continue;
                b.addTo(parent);
                parent.add(b);
                continue;
            }
            catch (IllegalBuildException ex) {
                ErrorDialog.bug(ex);
                continue;
            }
            catch (Error | RuntimeException ex) {
                logger.error("Error building " + child.getNodeName());
                throw ex;
            }
        }
    }

    public static Buildable create(Element e) throws IllegalBuildException {
        return Builder.create(e, null);
    }

    public static Buildable create(Element e, Buildable parent) throws IllegalBuildException {
        GameModule mod = GameModule.getGameModule();
        String name = e.getTagName();
        try {
            Buildable b = (Buildable)(mod == null ? Class.forName(name) : mod.getDataArchive().loadClass(name)).getConstructor(new Class[0]).newInstance(new Object[0]);
            if (b instanceof AbstractBuildable) {
                ((AbstractBuildable)b).setAncestor(parent);
            }
            b.build(e);
            return b;
        }
        catch (Throwable t) {
            ThrowableUtils.throwRecent(OutOfMemoryError.class, t);
            if (t instanceof ClassCastException || t instanceof ClassNotFoundException || t instanceof IllegalAccessException || t instanceof IllegalArgumentException || t instanceof InstantiationException || t instanceof InvocationTargetException || t instanceof NoSuchMethodException || t instanceof SecurityException || t instanceof ExceptionInInitializerError || t instanceof LinkageError) {
                throw new IllegalBuildException("failed to load class " + name, t);
            }
            if (t instanceof Error) {
                throw (Error)t;
            }
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            throw new IllegalStateException(t);
        }
    }

    public static Document createDocument(InputStream in) throws IOException {
        Document document;
        block9: {
            InputStream inputStream = in;
            try {
                document = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(in);
                if (inputStream == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (ParserConfigurationException e) {
                    ErrorDialog.bug(e);
                    return null;
                }
                catch (SAXException e) {
                    throw new IOException(e);
                }
            }
            inputStream.close();
        }
        return document;
    }

    public static Document createNewDocument() {
        try {
            return DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
        }
        catch (ParserConfigurationException e) {
            ErrorDialog.bug(e);
            return null;
        }
    }

    public static void writeDocument(Document doc, Writer writer) throws IOException {
        DOMSource source = new DOMSource(doc);
        StreamResult result = new StreamResult(writer);
        try {
            Transformer xformer = TransformerFactory.newInstance().newTransformer();
            xformer.setOutputProperty("indent", "yes");
            xformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
            xformer.transform(source, result);
        }
        catch (TransformerException e) {
            throw new IOException(e);
        }
    }

    public static String getText(Element e) {
        StringBuilder buffer = new StringBuilder();
        NodeList sub = e.getChildNodes();
        for (int i = 0; i < sub.getLength(); ++i) {
            if (sub.item(i).getNodeType() == 3) {
                buffer.append(((Text)sub.item(i)).getData());
                continue;
            }
            if (sub.item(i).getNodeType() != 5) continue;
            buffer.append(sub.item(i).getFirstChild());
        }
        return buffer.toString().trim();
    }

    public static String toString(Document doc) {
        StringWriter w = new StringWriter();
        try {
            Builder.writeDocument(doc, w);
            return w.toString();
        }
        catch (IOException e) {
            return "";
        }
    }

    public static void main(String[] args) {
        Document doc = Builder.createNewDocument();
        Element e = doc.createElement("test");
        Element e1 = doc.createElement("sub1");
        e.appendChild(e1);
        Element e2 = doc.createElement("sub2");
        e2.setAttribute("one", "1");
        e2.setAttribute("two", "2");
        e.appendChild(e2);
        Element e3 = doc.createElement("sub3");
        Element e4 = doc.createElement("sub4");
        e4.appendChild(doc.createTextNode("4 > 2"));
        e3.appendChild(e4);
        e.appendChild(e3);
        doc.appendChild(e);
        System.err.println(Builder.toString(doc));
        System.err.println("StringBuilder");
        StringBuilder buf = new StringBuilder(300000);
        for (int i = 0; i < 500000; ++i) {
            buf.append("  ");
            if (i % 10000 != 0) continue;
            System.err.println(buf.length());
        }
    }
}

