/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.module;

import VASSAL.Info;
import VASSAL.build.GameModule;
import VASSAL.build.module.BasicLogger;
import VASSAL.build.module.properties.MutableProperty;
import VASSAL.tools.BugUtils;
import java.awt.Desktop;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Iterator;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Console {
    Iterator<String> tok;
    String commandLine;
    private static final Logger log = LoggerFactory.getLogger(Console.class);

    private void show(String s) {
        GameModule.getGameModule().warn(s);
    }

    private boolean matches(String s1, String s2) {
        return this.matches(s1, s2, 2);
    }

    private boolean matches(String s1, String s2, int min) {
        if (s2.isEmpty() || s2.length() > s1.length() || s2.length() < min && s1.length() > s2.length()) {
            return false;
        }
        if (s2.length() < min) {
            return s1.equalsIgnoreCase(s2);
        }
        return s1.substring(0, s2.length()).equalsIgnoreCase(s2);
    }

    private String nextString(String def) {
        return this.tok.hasNext() ? this.tok.next() : def;
    }

    private int nextInt(int def) {
        try {
            return this.tok.hasNext() ? Integer.parseInt(this.tok.next()) : def;
        }
        catch (NumberFormatException e) {
            return def;
        }
    }

    private void browseFileOrFolder(File file) {
        Desktop desktop = Desktop.getDesktop();
        try {
            desktop.open(file);
        }
        catch (IOException e) {
            log.error("File Not Found", (Throwable)e);
        }
        catch (IllegalArgumentException iae) {
            log.error("Illegal argument", (Throwable)iae);
        }
    }

    private boolean doErrorLog() {
        String option = this.nextString("");
        if (this.matches("show", option)) {
            String errorLog = BugUtils.getErrorLog();
            String delims2 = "[\n]+";
            String[] lines = errorLog.split("[\n]+");
            if (lines.length > 0) {
                int start;
                int end = lines.length - 1;
                for (int line = start = (linesToShow = this.nextInt(0)) <= 0 ? 0 : Math.max(0, end - linesToShow + 1); line <= end; ++line) {
                    this.show(lines[line]);
                }
            }
        } else if (this.matches("write", option)) {
            int where = this.commandLine.toLowerCase().indexOf("write");
            if (where > 0 && this.commandLine.length() > where + 6) {
                log.info(this.commandLine.substring(where + 6));
            }
        } else if (this.matches("folder", option)) {
            this.browseFileOrFolder(Info.getConfDir());
        } else if (this.matches("noecho", option)) {
            GameModule.setErrorLogToChat(false);
            this.show("Errorlog Echo: OFF");
        } else if (this.matches("echo", option)) {
            GameModule.setErrorLogToChat(true);
            this.show("Errorlog Echo: ON");
        } else if (this.matches("open", option)) {
            this.browseFileOrFolder(Info.getErrorLogPath());
        } else if (this.matches("wipe", option)) {
            File errorLog = Info.getErrorLogPath();
            try {
                Files.newOutputStream(errorLog.toPath(), new OpenOption[0]).close();
                this.show("Wiped errorlog");
            }
            catch (IOException e) {
                this.show("Failed to wipe errorlog");
            }
        } else if (this.matches("?", option) || this.matches("help", option) || "".equals(option)) {
            this.show("Usage:");
            this.show("  /errorlog echo         - Echoes new errorlog info in chat log");
            this.show("  /errorlog folder       - Opens folder containing errorlog");
            this.show("  /errorlog noecho       - Disables echoing of errorlog info in chat log");
            this.show("  /errorlog open         - Opens errorlog in OS");
            this.show("  /errorlog show [n]     - Show last n lines of errorlog");
            this.show("  /errorlog wipe         - Wipe the errorlog file");
            this.show("  /errorlog write [text] - Write text into the errorlog file");
        } else {
            this.show("Unknown command.");
            this.show("Use '/errorlog help' for usage info.");
        }
        return true;
    }

    private boolean doProperty() {
        MutableProperty.Impl propValue;
        String option = this.nextString("");
        String property = this.nextString("");
        if (this.matches("?", option) || this.matches("help", option)) {
            this.show("Usage:");
            this.show("  /property show [property]        - show global property value");
            this.show("  /property set [property] [value] - set global property new value");
        } else if (this.matches("show", option)) {
            MutableProperty.Impl propValue2 = (MutableProperty.Impl)GameModule.getGameModule().getMutableProperty(property);
            if (propValue2 != null) {
                this.show("[" + property + "]: " + propValue2.getPropertyValue());
            } else {
                String propVal = (String)GameModule.getGameModule().getProperty(property);
                if (propVal != null) {
                    this.show("[" + property + "]: " + propVal);
                }
            }
        } else if (this.matches("set", option) && (propValue = (MutableProperty.Impl)GameModule.getGameModule().getMutableProperty(property)) != null) {
            propValue.setPropertyValue(this.nextString(""));
            this.show("[" + property + "]: " + propValue.getPropertyValue());
        }
        return true;
    }

    private boolean doHelp() {
        String topic = this.nextString("");
        if (topic.isEmpty()) {
            this.show("VASSAL console commands:");
            this.show("  /errorlog - commands for opening/clearing/altering errorlog");
            this.show("  /help     - shows list of commands");
            this.show("  /property - commands for reading/writing global properties");
        } else {
            this.tok = Pattern.compile(" +").splitAsStream("help").iterator();
            if (this.matches("errorlog", topic)) {
                return this.doErrorLog();
            }
            if (this.matches("property", topic)) {
                return this.doProperty();
            }
            this.show("Unknown help topic");
        }
        return true;
    }

    public boolean consoleHook(String s, String commandLine, Iterator<String> tok, String command) {
        return false;
    }

    public boolean exec(String s, String style, boolean html_allowed) {
        if (s.isEmpty() || s.charAt(0) != '/') {
            return false;
        }
        this.commandLine = s.substring(1);
        VASSAL.command.Logger log = GameModule.getGameModule().getLogger();
        if (log instanceof BasicLogger && (((BasicLogger)log).isMultiPlayer() || GameModule.getGameModule().isMultiPlayer())) {
            this.show("|<b>Console commands not allowed in multiplayer games.</b>");
            return false;
        }
        this.show(s);
        this.tok = Pattern.compile(" +").splitAsStream(this.commandLine).iterator();
        String command = this.nextString("");
        if (this.matches("help", command) || this.matches("?", command)) {
            return this.doHelp();
        }
        if (this.matches("errorlog", command)) {
            return this.doErrorLog();
        }
        if (this.matches("property", command)) {
            return this.doProperty();
        }
        if (!this.consoleHook(s, this.commandLine, this.tok, command)) {
            this.show("Unknown command. Use /help for list of commands.");
            return false;
        }
        return true;
    }
}

