/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.module;

import VASSAL.build.AbstractConfigurable;
import VASSAL.build.BadDataReport;
import VASSAL.build.Buildable;
import VASSAL.build.Builder;
import VASSAL.build.Configurable;
import VASSAL.build.GameModule;
import VASSAL.build.GpIdSupport;
import VASSAL.build.module.PrototypesContainer;
import VASSAL.build.module.documentation.HelpFile;
import VASSAL.build.module.properties.PropertySource;
import VASSAL.command.AddPiece;
import VASSAL.configure.Configurer;
import VASSAL.configure.StringConfigurer;
import VASSAL.configure.ValidationReport;
import VASSAL.configure.ValidityChecker;
import VASSAL.counters.BasicPiece;
import VASSAL.counters.Decorator;
import VASSAL.counters.GamePiece;
import VASSAL.counters.PieceDefiner;
import VASSAL.counters.PieceEditor;
import VASSAL.i18n.ComponentI18nData;
import VASSAL.i18n.Resources;
import VASSAL.script.expression.Auditable;
import VASSAL.search.ImageSearchTarget;
import VASSAL.tools.ErrorDialog;
import VASSAL.tools.FormattedString;
import VASSAL.tools.UniqueIdManager;
import java.awt.Component;
import java.awt.LayoutManager;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.miginfocom.swing.MigLayout;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class PrototypeDefinition
extends AbstractConfigurable
implements UniqueIdManager.Identifyable,
ValidityChecker {
    private String name = "Prototype";
    private String description = "";
    private static final String DESCRIPTION_PROPERTY = "description";
    private final Map<String, GamePiece> pieces = new HashMap<String, GamePiece>();
    private String pieceDefinition;
    private static final UniqueIdManager idMgr = new UniqueIdManager("prototype-");
    private final PropertyChangeSupport propSupport = new PropertyChangeSupport(this);

    @Override
    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.propSupport.addPropertyChangeListener(l);
    }

    public Class<?>[] getAllowableConfigureComponents() {
        return new Class[0];
    }

    @Override
    public Configurable[] getConfigureComponents() {
        return new Configurable[0];
    }

    @Override
    public String getConfigureName() {
        return this.name;
    }

    @Override
    public void setConfigureName(String s) {
        String oldName = this.name;
        this.name = s;
        this.propSupport.firePropertyChange("name", oldName, this.name);
    }

    @Override
    public Configurer getConfigurer() {
        return new Config(this);
    }

    @Override
    public HelpFile getHelpFile() {
        return HelpFile.getReferenceManualPage("GameModule.html", "Definition");
    }

    @Override
    public void remove(Buildable child) {
        idMgr.remove(this);
    }

    @Override
    public void removeFrom(Buildable parent) {
    }

    @Override
    public void add(Buildable child) {
    }

    @Override
    public String getId() {
        return null;
    }

    @Override
    public void setId(String id) {
    }

    @Override
    public void validate(Buildable target, ValidationReport report) {
        idMgr.validate(this, report);
    }

    @Override
    public void addTo(Buildable parent) {
        idMgr.add(this);
    }

    @Override
    public void addImageNamesRecursively(Collection<String> s) {
        super.addImageNamesRecursively(s);
        GamePiece p = this.getPiece();
        if (p instanceof ImageSearchTarget) {
            ((ImageSearchTarget)((Object)p)).addImageNamesRecursively(s);
        }
    }

    public GamePiece getPiece() {
        return this.getPiece(this.pieceDefinition);
    }

    public GamePiece getPiece(PropertySource props) {
        String def = props == null ? this.pieceDefinition : new FormattedString(this.pieceDefinition).getText(props, (Auditable)this, "Editor.Prototype.component_type");
        return this.getPiece(def);
    }

    protected GamePiece getPiece(String def) {
        GamePiece piece = this.pieces.get(def);
        if (piece == null && def != null) {
            try {
                AddPiece comm = (AddPiece)GameModule.getGameModule().decode(def);
                if (comm == null) {
                    ErrorDialog.dataWarning(new BadDataReport("Couldn't build piece ", def, null));
                } else {
                    piece = comm.getTarget();
                    piece.setState(comm.getState());
                }
            }
            catch (RuntimeException e) {
                ErrorDialog.dataWarning(new BadDataReport("Couldn't build piece", def, e));
            }
        }
        return piece;
    }

    public void clearCache() {
        this.pieces.clear();
    }

    public void setPiece(GamePiece p) {
        this.pieceDefinition = p == null ? null : GameModule.getGameModule().encode(new AddPiece(p));
        this.pieces.clear();
        PrototypesContainer container = PrototypesContainer.findInstance();
        if (container != null) {
            container.resetCache();
        }
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public void build(Element e) {
        if (e != null) {
            this.setConfigureName(e.getAttribute("name"));
            this.setDescription(e.getAttribute(DESCRIPTION_PROPERTY));
            this.pieceDefinition = Builder.getText(e);
        }
    }

    @Override
    public Element getBuildElement(Document doc) {
        Element el = doc.createElement(this.getClass().getName());
        el.setAttribute("name", this.name);
        el.setAttribute(DESCRIPTION_PROPERTY, this.description);
        el.appendChild(doc.createTextNode(this.pieceDefinition));
        return el;
    }

    public static String getConfigureTypeName() {
        return Resources.getString("Editor.Prototype.component_type");
    }

    @Override
    public void setAttribute(String attr, Object value) {
    }

    @Override
    public String[] getAttributeDescriptions() {
        return new String[0];
    }

    @Override
    public Class<?>[] getAttributeTypes() {
        return new Class[0];
    }

    @Override
    public String[] getAttributeNames() {
        return new String[0];
    }

    @Override
    public String getAttributeValueString(String attr) {
        return this.getI18nData().getLocalUntranslatedValue(attr);
    }

    @Override
    public ComponentI18nData getI18nData() {
        return new ComponentI18nData((Configurable)this, this.getPiece());
    }

    public static class Config
    extends Configurer {
        private final JPanel box = new JPanel((LayoutManager)new MigLayout("ins 0", "[grow,fill]", "[][grow]"));
        private final PieceDefiner pieceDefiner;
        private final StringConfigurer name;
        private final StringConfigurer description;
        private final PrototypeDefinition def;

        public Config(PrototypeDefinition def) {
            super(null, null, def);
            JPanel namePanel = new JPanel((LayoutManager)new MigLayout("ins 0", "[]rel[grow,fill]"));
            namePanel.add(new JLabel(Resources.getString("Editor.name_label")));
            this.name = new StringConfigurer(def.name);
            namePanel.add(this.name.getControls(), "grow, wrap");
            namePanel.add(new JLabel(Resources.getString("Editor.description_label")));
            this.description = new StringConfigurer(def.description);
            namePanel.add(this.description.getControls());
            this.box.add((Component)namePanel, "grow,wrap");
            this.pieceDefiner = new Definer(GameModule.getGameModule().getGpIdSupport());
            this.pieceDefiner.setPiece(def.getPiece());
            this.box.add((Component)this.pieceDefiner, "growy");
            this.def = def;
        }

        @Override
        public Object getValue() {
            if (this.def != null) {
                this.def.setPiece(this.pieceDefiner.getPiece());
                this.def.setConfigureName(this.name.getValueString());
                this.def.setDescription(this.description.getValueString());
            }
            return this.def;
        }

        @Override
        public Component getControls() {
            return this.box;
        }

        @Override
        public String getValueString() {
            return null;
        }

        @Override
        public void setValue(String s) {
        }

        public static class Definer
        extends PieceDefiner {
            private static final long serialVersionUID = 1L;

            public Definer(GpIdSupport s) {
                super(s);
            }

            @Override
            public void setPiece(GamePiece piece) {
                if (piece != null) {
                    GamePiece inner = Decorator.getInnermost(piece);
                    if (!(inner instanceof Plain)) {
                        Plain plain = new Plain();
                        Object outer = inner.getProperty("Outer");
                        if (outer instanceof Decorator) {
                            ((Decorator)outer).setInner(plain);
                        }
                        piece = Decorator.getOutermost(plain);
                    }
                } else {
                    piece = new Plain();
                }
                super.setPiece(piece);
            }

            @Override
            protected void removeTrait(int index) {
                if (index > 0) {
                    super.removeTrait(index);
                }
            }

            private static class Plain
            extends BasicPiece {
                public Plain() {
                    super("piece;;;;;");
                }

                @Override
                public String getDescription() {
                    return "";
                }

                @Override
                public PieceEditor getEditor() {
                    return null;
                }
            }
        }
    }
}

