/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.module.dice;

import VASSAL.build.GameModule;
import VASSAL.build.module.DieRoll;
import VASSAL.build.module.dice.RollSet;
import VASSAL.script.expression.Auditable;
import VASSAL.tools.ErrorDialog;
import VASSAL.tools.FormattedString;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Random;
import java.util.Vector;
import java.util.concurrent.ExecutionException;
import javax.swing.SwingWorker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DieServer
implements Auditable {
    private static final Logger logger = LoggerFactory.getLogger(DieServer.class);
    protected Random ran = GameModule.getGameModule().getRNG();
    protected String name;
    protected String description;
    protected boolean emailOnly;
    protected int maxRolls;
    protected int maxEmails;
    protected String serverURL;
    protected boolean passwdRequired = false;
    protected String password = "";
    protected boolean useEmail;
    protected String primaryEmail;
    protected String secondaryEmail;
    protected boolean canDoSeparateDice = false;

    public abstract String[] buildInternetRollString(RollSet var1);

    public abstract void parseInternetRollString(RollSet var1, Vector<String> var2);

    public abstract void roll(RollSet var1, FormattedString var2);

    public int[] getnDiceList() {
        return new int[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20};
    }

    public int[] getnSideList() {
        return new int[]{2, 3, 4, 5, 6, 7, 8, 9, 10, 12, 13, 20, 30, 50, 100, 1000};
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean isPasswdRequired() {
        return this.passwdRequired;
    }

    public String getPasswd() {
        return this.password;
    }

    public void setPasswd(String s) {
        this.password = s;
    }

    public void setPrimaryEmail(String e) {
        this.primaryEmail = e;
    }

    public String getPrimaryEmail() {
        return this.primaryEmail;
    }

    public void setSecondaryEmail(String e) {
        this.secondaryEmail = e;
    }

    public String getSecondaryEmail() {
        return this.secondaryEmail;
    }

    public void setUseEmail(boolean use) {
        this.useEmail = use;
    }

    public boolean getUseEmail() {
        return this.useEmail;
    }

    public int getMaxEmails() {
        return this.maxEmails;
    }

    protected String getReportPrefix(String d) {
        return " *** " + d + " = ";
    }

    public void doInternetRoll(final RollSet mroll, final FormattedString format) {
        new SwingWorker<Void, Void>(){

            @Override
            public Void doInBackground() throws Exception {
                DieServer.this.doIRoll(mroll);
                return null;
            }

            @Override
            protected void done() {
                try {
                    this.get();
                    DieServer.this.reportResult(mroll, format);
                }
                catch (InterruptedException e) {
                    ErrorDialog.bug(e);
                }
                catch (ExecutionException e) {
                    logger.error("", (Throwable)e);
                    String s = "- Internet dice roll attempt " + mroll.getDescription() + " failed.";
                    GameModule.getGameModule().getChatter().send(s);
                }
            }
        }.execute();
    }

    protected String formatResult(String description, String result, FormattedString format) {
        format.setProperty("result", result);
        format.setProperty("rollDetails", description);
        String text = format.getText(this, "Editor.report_format");
        return text.startsWith("*") ? "*" + text : "* " + text;
    }

    public void reportResult(RollSet mroll, FormattedString format) {
        DieRoll[] rolls;
        for (DieRoll roll : rolls = mroll.getDieRolls()) {
            int nDice = roll.getNumDice();
            boolean reportTotal = roll.isReportTotal();
            StringBuilder val = new StringBuilder();
            int total = 0;
            for (int j = 0; j < nDice; ++j) {
                int result = roll.getResult(j);
                if (reportTotal) {
                    total += result;
                    continue;
                }
                val.append(result);
                if (j >= nDice - 1) continue;
                val.append(',');
            }
            if (reportTotal) {
                val.append(total);
            }
            GameModule.getGameModule().getChatter().send(this.formatResult(roll.getDescription(), val.toString(), format));
        }
    }

    public void doIRoll(RollSet toss) throws IOException {
        String[] rollString = this.buildInternetRollString(toss);
        ArrayList<String> returnString = new ArrayList<String>();
        URL url = new URL(this.serverURL);
        URLConnection connection = url.openConnection();
        connection.setDoOutput(true);
        try (OutputStream os = connection.getOutputStream();
             PrintWriter out = new PrintWriter(os, true, StandardCharsets.UTF_8);){
            for (String s : rollString) {
                out.println(s);
            }
        }
        try (InputStream is = connection.getInputStream();
             InputStreamReader isr = new InputStreamReader(is, StandardCharsets.UTF_8);
             BufferedReader in = new BufferedReader(isr);){
            String inputLine;
            while ((inputLine = in.readLine()) != null) {
                returnString.add(inputLine);
            }
        }
        this.parseInternetRollString(toss, new Vector<String>(returnString));
    }

    public String extractEmail(String email) {
        int start = email.indexOf(60);
        int end = email.indexOf(62);
        if (start >= 0 && end >= 0 && end > start) {
            return email.substring(start + 1, end);
        }
        return email;
    }
}

