/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.module.gamepieceimage;

import VASSAL.build.AbstractConfigurable;
import VASSAL.build.Buildable;
import VASSAL.build.module.documentation.HelpFile;
import VASSAL.build.module.gamepieceimage.ColorManager;
import VASSAL.configure.ColorConfigurer;
import VASSAL.i18n.Resources;
import VASSAL.tools.SequenceEncoder;
import java.awt.Color;

public class ColorSwatch
extends AbstractConfigurable
implements Comparable<ColorSwatch> {
    protected static final String NAME = "name";
    protected static final String COLOR = "color";
    public static final String BLACK = "BLACK";
    public static final String WHITE = "WHITE";
    public static final String CLEAR = "CLEAR";
    public static final String RED = "RED";
    protected Color color;

    public ColorSwatch() {
        this.name = "";
        this.color = null;
    }

    public ColorSwatch(String n, Color c) {
        this();
        this.name = n;
        this.color = c;
    }

    public ColorSwatch(String code) {
        this();
        this.decode(code);
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color c) {
        this.color = c;
    }

    @Override
    public String[] getAttributeDescriptions() {
        return new String[]{Resources.getString("Editor.ColorSwatch.color_name"), Resources.getString("Editor.color_label")};
    }

    @Override
    public Class<?>[] getAttributeTypes() {
        return new Class[]{String.class, Color.class};
    }

    @Override
    public String[] getAttributeNames() {
        return new String[]{NAME, COLOR};
    }

    @Override
    public void setAttribute(String key, Object o) {
        if (NAME.equals(key)) {
            this.setConfigureName((String)o);
        } else if (COLOR.equals(key)) {
            if (o instanceof String) {
                o = ColorConfigurer.stringToColor((String)o);
            }
            this.color = (Color)o;
        }
    }

    @Override
    public String getAttributeValueString(String key) {
        if (NAME.equals(key)) {
            return this.getConfigureName();
        }
        if (COLOR.equals(key)) {
            return ColorConfigurer.colorToString(this.color);
        }
        return null;
    }

    @Override
    public void removeFrom(Buildable parent) {
    }

    @Override
    public HelpFile getHelpFile() {
        return null;
    }

    public Class<?>[] getAllowableConfigureComponents() {
        return new Class[0];
    }

    public static String getConfigureTypeName() {
        return Resources.getString("Editor.ColorSwatch.component_type");
    }

    @Override
    public void addTo(Buildable parent) {
        this.setAllAttributesUntranslatable();
    }

    public static ColorSwatch getBlack() {
        return new ColorSwatch(BLACK, Color.BLACK);
    }

    public static ColorSwatch getWhite() {
        return new ColorSwatch(WHITE, Color.WHITE);
    }

    public static ColorSwatch getRed() {
        return new ColorSwatch(RED, Color.RED);
    }

    public static ColorSwatch getClear() {
        return new ColorSwatch(CLEAR, null);
    }

    public String encode() {
        return this.getConfigureName();
    }

    public void decode(String s) {
        SequenceEncoder.Decoder sd = new SequenceEncoder.Decoder(s, ';');
        this.setConfigureName(sd.nextToken());
        Color c = ColorManager.getColorManager().getColorByName(this.getConfigureName());
        if (c == null && !this.getConfigureName().equals(CLEAR)) {
            c = ColorManager.getColorManager().getColorByName(BLACK);
        }
        this.setColor(c);
    }

    public static ColorSwatch getDefaultSwatch() {
        return ColorManager.getColorManager().getColorSwatch(ColorManager.DEFAULT_COLOR);
    }

    @Override
    public int compareTo(ColorSwatch c) {
        return this.name.compareTo(c.name);
    }
}

