/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.module.gamepieceimage;

import VASSAL.build.module.gamepieceimage.FontManager;
import VASSAL.build.module.gamepieceimage.FontStyle;
import VASSAL.build.module.gamepieceimage.OutlineFont;
import VASSAL.configure.BooleanConfigurer;
import VASSAL.configure.Configurer;
import VASSAL.configure.IntConfigurer;
import VASSAL.counters.TraitConfigPanel;
import VASSAL.i18n.Resources;
import VASSAL.tools.SequenceEncoder;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeListener;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import net.miginfocom.swing.MigLayout;

public class FontConfigurer
extends Configurer {
    private TraitConfigPanel p;
    private IntConfigurer size;
    private BooleanConfigurer bold;
    private BooleanConfigurer italic;
    private BooleanConfigurer outline;
    private JComboBox<String> family;
    private JTextField demo;

    public FontConfigurer(String key, String name) {
        super(key, name);
    }

    public FontConfigurer(String key, String name, OutlineFont f) {
        super(key, name);
        this.setValue(f);
    }

    public FontConfigurer(String key, String name, FontStyle f) {
        super(key, name);
        this.setValue(f.font);
        this.setName(f.getConfigureName());
    }

    @Override
    public String getValueString() {
        return FontConfigurer.encode((OutlineFont)this.value);
    }

    @Override
    public void setValue(String s) {
        this.setValue(FontConfigurer.decode(s));
    }

    @Override
    public Component getControls() {
        if (this.p == null) {
            this.p = new TraitConfigPanel();
            JPanel familyPanel = new JPanel((LayoutManager)new MigLayout("ins 0"));
            this.family = new JComboBox();
            for (int i = 0; i < FontManager.ALLOWABLE_FONTS.length; ++i) {
                this.family.addItem(FontManager.ALLOWABLE_FONTS[i]);
            }
            this.family.setSelectedItem(this.value == null ? "SanSerif" : this.getFontValue().getFamily());
            familyPanel.add(this.family);
            this.p.add("Editor.FontConfigurer.font_family", familyPanel);
            this.size = new IntConfigurer(this.getFontValue().getSize());
            this.p.add("Editor.FontConfigurer.font_size", (Configurer)this.size);
            this.bold = new BooleanConfigurer(this.isBold());
            this.p.add("Editor.FontConfigurer.bold_checkbox", (Configurer)this.bold);
            this.italic = new BooleanConfigurer(this.isItalic());
            this.p.add("Editor.FontConfigurer.italic_checkbox", (Configurer)this.italic);
            this.outline = new BooleanConfigurer(this.isOutline());
            JPanel demoPanel = new JPanel((LayoutManager)new MigLayout("ins 0", "grow,fill"));
            this.demo = new JTextField(Resources.getString("Editor.FontConfigurer.sample_text"), 20);
            this.demo.setEditable(false);
            demoPanel.add((Component)this.demo, "grow");
            this.p.add("Editor.FontConfigurer.sample_label", demoPanel, "grow");
            this.updateValue();
            ItemListener l = evt -> this.updateValue();
            this.family.addItemListener(l);
            PropertyChangeListener pc = evt -> this.updateValue();
            this.size.addPropertyChangeListener(pc);
            this.bold.addPropertyChangeListener(pc);
            this.italic.addPropertyChangeListener(pc);
            this.outline.addPropertyChangeListener(pc);
        }
        return this.p;
    }

    protected void updateValue() {
        int style = 0 | (this.bold.booleanValue() != false ? 1 : 0) | (this.italic.booleanValue() != false ? 2 : 0);
        OutlineFont font = new OutlineFont((String)this.family.getSelectedItem(), style, Integer.parseInt(this.size.getValueString()), this.outline.booleanValue());
        this.setValue(font);
        this.demo.setFont(font);
        Window w = SwingUtilities.getWindowAncestor(this.getControls());
        if (w != null) {
            w.pack();
        }
    }

    protected OutlineFont getFontValue() {
        return (OutlineFont)this.getValue();
    }

    public static OutlineFont decode(String s) {
        SequenceEncoder.Decoder sd = new SequenceEncoder.Decoder(s, ',');
        return new OutlineFont(sd.nextToken("Dialog"), sd.nextInt(0), sd.nextInt(10), sd.nextBoolean(false));
    }

    public static String encode(OutlineFont f) {
        SequenceEncoder se = new SequenceEncoder(f.getName(), ',');
        se.append(f.getStyle());
        se.append(f.getSize());
        se.append(f.isOutline());
        return se.getValue();
    }

    public boolean isBold() {
        return (this.getFontValue().getStyle() & 1) != 0;
    }

    public boolean isItalic() {
        return (this.getFontValue().getStyle() & 2) != 0;
    }

    public boolean isOutline() {
        return this.getFontValue().isOutline();
    }
}

