/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.module.gamepieceimage;

import VASSAL.build.module.gamepieceimage.ColorSwatch;
import VASSAL.build.module.gamepieceimage.ColorSwatchConfigurer;
import VASSAL.configure.BooleanConfigurer;
import VASSAL.configure.Configurer;
import VASSAL.i18n.Resources;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.util.StringTokenizer;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class NewColorConfigurer
extends Configurer {
    private JPanel p;
    private Panel cp;
    protected Box colorBox;
    protected Box swatchBox;
    BooleanConfigurer bc;
    ColorSwatchConfigurer csc;

    public NewColorConfigurer(String key, String name) {
        this(key, name, Color.black);
    }

    public NewColorConfigurer(String key, String name, Color val) {
        super(key, name, val);
    }

    @Override
    public String getValueString() {
        return this.value == null ? "" : NewColorConfigurer.colorToString(this.colorValue());
    }

    @Override
    public void setValue(Object o) {
        super.setValue(o);
        if (this.cp != null) {
            this.cp.repaint();
        }
    }

    @Override
    public void setValue(String s) {
        this.setValue(NewColorConfigurer.stringToColor(s));
    }

    @Override
    public Component getControls() {
        if (this.p == null) {
            this.p = new JPanel();
            this.p.setLayout(new BoxLayout(this.p, 1));
            Box box = Box.createHorizontalBox();
            box.add(new JLabel(Resources.getString("Editor.NewColorConfigurer.use_named_colors")));
            this.bc = new BooleanConfigurer(null, "", Boolean.FALSE);
            box.add(this.bc.getControls());
            this.bc.addPropertyChangeListener(e -> {
                this.colorBox.setVisible(this.bc.booleanValue() == false);
                this.swatchBox.setVisible(this.bc.booleanValue());
                SwingUtilities.getWindowAncestor(this.bc.getControls()).pack();
            });
            this.p.add(box);
            this.colorBox = Box.createHorizontalBox();
            this.colorBox.add(new JLabel(this.getName()));
            this.cp = new Panel();
            this.cp.setMaximumSize(new Dimension(40, 40));
            this.cp.setMinimumSize(new Dimension(40, 40));
            this.cp.setSize(new Dimension(40, 40));
            this.colorBox.add(this.cp);
            JButton b = new JButton(Resources.getString("Editor.select"));
            this.colorBox.add(b);
            this.p.add(this.colorBox);
            b.addActionListener(e -> {
                this.setValue(JColorChooser.showDialog(null, this.getName(), this.colorValue()));
                this.csc.setValue(new ColorSwatch("", (Color)this.getValue()));
            });
            this.swatchBox = Box.createHorizontalBox();
            this.csc = new ColorSwatchConfigurer(null, Resources.getString("Editor.NewColorConfigurer.select_color"), "WHITE");
            this.csc.addPropertyChangeListener(e -> this.setValue(this.csc.getValueColor()));
            this.swatchBox.add(this.csc.getControls());
            this.swatchBox.setVisible(false);
            this.p.add(this.swatchBox);
        }
        return this.p;
    }

    private Color colorValue() {
        return (Color)this.value;
    }

    public static String colorToString(Color c) {
        return c == null ? null : c.getRed() + "," + c.getGreen() + "," + c.getBlue();
    }

    public static Color stringToColor(String s) {
        if (s == null || "null".equals(s)) {
            return null;
        }
        StringTokenizer st = new StringTokenizer(s, ",");
        try {
            return new Color(Integer.parseInt(st.nextToken()), Integer.parseInt(st.nextToken()), Integer.parseInt(st.nextToken()));
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    private class Panel
    extends JPanel {
        private static final long serialVersionUID = 1L;

        private Panel() {
        }

        @Override
        public void paint(Graphics g) {
            if (NewColorConfigurer.this.colorValue() != null) {
                g.setColor(NewColorConfigurer.this.colorValue());
                g.fillRect(0, 0, this.getSize().width, this.getSize().height);
            } else {
                g.clearRect(0, 0, this.getSize().width, this.getSize().height);
            }
        }
    }
}

