/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.module.map;

import VASSAL.build.AbstractBuildable;
import VASSAL.build.Buildable;
import VASSAL.build.GameModule;
import VASSAL.build.module.Chatter;
import VASSAL.build.module.GameComponent;
import VASSAL.build.module.GlobalOptions;
import VASSAL.build.module.Map;
import VASSAL.build.module.map.KeyBufferer;
import VASSAL.build.module.map.MovementReporter;
import VASSAL.build.module.map.StackMetrics;
import VASSAL.build.module.map.boardPicker.Board;
import VASSAL.build.module.properties.PropertySource;
import VASSAL.build.widget.PieceSlot;
import VASSAL.command.ChangeTracker;
import VASSAL.command.Command;
import VASSAL.command.NullCommand;
import VASSAL.configure.BooleanConfigurer;
import VASSAL.configure.NamedHotKeyConfigurer;
import VASSAL.counters.BasicPiece;
import VASSAL.counters.BoundsTracker;
import VASSAL.counters.Deck;
import VASSAL.counters.DeckVisitor;
import VASSAL.counters.DeckVisitorDispatcher;
import VASSAL.counters.Decorator;
import VASSAL.counters.DragBuffer;
import VASSAL.counters.EventFilter;
import VASSAL.counters.GamePiece;
import VASSAL.counters.Highlighter;
import VASSAL.counters.KeyBuffer;
import VASSAL.counters.Mat;
import VASSAL.counters.MatCargo;
import VASSAL.counters.MatHolder;
import VASSAL.counters.PieceFinder;
import VASSAL.counters.PieceIterator;
import VASSAL.counters.PieceSorter;
import VASSAL.counters.PieceVisitorDispatcher;
import VASSAL.counters.PropertyExporter;
import VASSAL.counters.Stack;
import VASSAL.i18n.Resources;
import VASSAL.script.expression.Auditable;
import VASSAL.tools.FormattedString;
import VASSAL.tools.LaunchButton;
import VASSAL.tools.NamedKeyStroke;
import VASSAL.tools.image.ImageUtils;
import VASSAL.tools.imageop.Op;
import VASSAL.tools.swing.SwingUtils;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.datatransfer.StringSelection;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DragSourceMotionListener;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.dnd.InvalidDnDOperationException;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JRootPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import org.apache.commons.lang3.SystemUtils;

public class PieceMover
extends AbstractBuildable
implements MouseListener,
MouseMotionListener,
GameComponent,
Comparator<GamePiece> {
    public static final String AUTO_REPORT = "autoReport";
    public static final String NAME = "name";
    public static final String HOTKEY = "hotkey";
    protected Map map;
    protected Point dragBegin;
    protected boolean breachedThreshold;
    protected GamePiece dragging;
    protected LaunchButton markUnmovedButton;
    protected String markUnmovedText;
    protected String markUnmovedIcon;
    protected NamedKeyStroke markUnmovedHotkey;
    protected String markUnmovedReport;
    public static final String ICON_NAME = "icon";
    protected String iconName;
    protected PieceFinder dragTargetSelector;
    protected PieceFinder dropTargetSelector;
    protected LoadedCargoDropTargetSelector loadedCargoDropTargetSelector;
    protected MatDropTargetSelector matDropTargetSelector;
    protected PieceVisitorDispatcher selectionProcessor;
    protected Comparator<GamePiece> pieceSorter = new PieceSorter();
    protected int curPieceOffsetX;
    protected int curPieceOffsetY;

    public void setCurPieceOffset(int x, int y) {
        this.curPieceOffsetX = x;
        this.curPieceOffsetY = y;
    }

    public void setBreachedThreshold(boolean breachedThreshold) {
        this.breachedThreshold = breachedThreshold;
    }

    public boolean getBreachedThreshold() {
        return this.breachedThreshold;
    }

    @Override
    public void addTo(Buildable b) {
        this.dragTargetSelector = this.createDragTargetSelector();
        this.selectionProcessor = this.createSelectionProcessor();
        this.map = (Map)b;
        this.map.addLocalMouseListener(this);
        GameModule.getGameModule().getGameState().addGameComponent(this);
        DragHandler.addPieceMover(this);
        this.map.getView().addMouseMotionListener(this);
        this.map.setDragGestureListener(DragHandler.getTheDragHandler());
        this.map.setPieceMover(this);
        this.setAttribute("markUnmovedText", this.map.getAttributeValueString("markUnmovedText"));
        this.setAttribute("markUnmovedIcon", this.map.getAttributeValueString("markUnmovedIcon"));
        this.setAttribute("markUnmovedHotkey", this.map.getAttributeValueString("markUnmovedHotkey"));
        this.setAttribute("markUnmovedReport", this.map.getAttributeValueString("markUnmovedReport"));
    }

    protected MovementReporter createMovementReporter(Command c) {
        return new MovementReporter(c);
    }

    @Override
    public void addLocalImageNames(Collection<String> s) {
        if (this.iconName != null) {
            s.add(this.iconName);
        }
        if (this.markUnmovedIcon != null) {
            s.add(this.markUnmovedIcon);
        }
    }

    protected PieceFinder getDropTargetSelector(GamePiece piece, MatCargo cargo, Mat mat) {
        if (cargo != null && mat != null) {
            if (this.loadedCargoDropTargetSelector == null) {
                this.loadedCargoDropTargetSelector = new LoadedCargoDropTargetSelector();
            }
            this.loadedCargoDropTargetSelector.setPiece(piece, cargo, mat);
            return this.loadedCargoDropTargetSelector;
        }
        if (mat != null) {
            if (this.matDropTargetSelector == null) {
                this.matDropTargetSelector = new MatDropTargetSelector();
            }
            this.matDropTargetSelector.setPiece(piece, cargo, mat);
            return this.matDropTargetSelector;
        }
        if (this.dropTargetSelector == null) {
            this.dropTargetSelector = new StandardDropTargetSelector();
        }
        ((StandardDropTargetSelector)this.dropTargetSelector).setPiece(piece, cargo, mat);
        return this.dropTargetSelector;
    }

    protected PieceFinder createDropTargetSelector() {
        return this.dropTargetSelector;
    }

    protected PieceVisitorDispatcher createSelectionProcessor() {
        return new DeckVisitorDispatcher(new DeckVisitor(){

            @Override
            public Object visitDeck(Deck d) {
                DragBuffer dbuf = DragBuffer.getBuffer();
                dbuf.clear();
                PieceIterator it = d.drawCards();
                while (it.hasMoreElements()) {
                    GamePiece p = it.nextPiece();
                    p.setProperty("obs;", p.getProperty("ObscuredPreDraw"));
                    dbuf.add(p);
                }
                return null;
            }

            @Override
            public Object visitStack(Stack s) {
                DragBuffer dbuf = DragBuffer.getBuffer();
                dbuf.clear();
                boolean selectAllUnitsInStackRegardlessOfSelection = (Boolean)GameModule.getGameModule().getPrefs().getValue("movingStacksPickupUnits");
                s.asList().forEach(selectAllUnitsInStackRegardlessOfSelection ? dbuf::add : p -> {
                    if (Boolean.TRUE.equals(p.getProperty("Selected"))) {
                        dbuf.add((GamePiece)p);
                    }
                });
                KeyBuffer kbuf = KeyBuffer.getBuffer();
                if (kbuf.containsChild(s)) {
                    kbuf.sort(PieceMover.this);
                    for (GamePiece piece : kbuf.asList()) {
                        if (piece.getParent() == s) continue;
                        dbuf.add(piece);
                    }
                }
                return null;
            }

            @Override
            public Object visitDefault(GamePiece selected) {
                DragBuffer dbuf = DragBuffer.getBuffer();
                dbuf.clear();
                KeyBuffer kbuf = KeyBuffer.getBuffer();
                if (kbuf.contains(selected)) {
                    kbuf.sort(PieceMover.this);
                    for (GamePiece piece : kbuf.asList()) {
                        dbuf.add(piece);
                    }
                } else {
                    dbuf.add(selected);
                }
                if (GameModule.getGameModule().isMatSupport()) {
                    ArrayList<GamePiece> checkDrag = new ArrayList<GamePiece>(dbuf.asList());
                    for (GamePiece piece : checkDrag) {
                        List cargoList = (List)piece.getProperty("MatContents");
                        if (cargoList == null) continue;
                        for (GamePiece cargo : cargoList) {
                            if (dbuf.contains(cargo)) continue;
                            dbuf.add(cargo);
                        }
                    }
                }
                return null;
            }
        });
    }

    protected PieceFinder createDragTargetSelector() {
        return new PieceFinder.Movable(){

            @Override
            public Object visitDeck(Deck d) {
                Point pos = d.getPosition();
                Point p = new Point(this.pt.x - pos.x, this.pt.y - pos.y);
                return d.boundingBox().contains(p) && d.getPieceCount() > 0 ? d : null;
            }
        };
    }

    @Override
    public void setup(boolean gameStarting) {
        if (gameStarting) {
            this.initButton();
        }
    }

    @Override
    public Command getRestoreCommand() {
        return null;
    }

    private Image loadIcon(String name) {
        if (name == null || name.length() == 0) {
            return null;
        }
        return Op.load(name).getImage();
    }

    protected void initButton() {
        String value = this.getMarkOption();
        if ("Use Preferences Setting".equals(value)) {
            BooleanConfigurer config = new BooleanConfigurer("markMoved", Resources.getString("Editor.PieceMover.mark_moved_pieces"), Boolean.TRUE);
            GameModule.getGameModule().getPrefs().addOption(config);
        }
        if (!"Never".equals(value)) {
            if (this.markUnmovedButton == null) {
                ActionListener al = e -> {
                    GamePiece[] p = this.map.getAllPieces();
                    NullCommand c = new NullCommand();
                    for (GamePiece gamePiece : p) {
                        c.append(this.markMoved(gamePiece, false));
                    }
                    if (this.markUnmovedReport != null && !this.markUnmovedReport.isEmpty()) {
                        FormattedString format = new FormattedString(this.markUnmovedReport);
                        format.setProperty("mapName", this.map.getConfigureName());
                        String reportText = format.getLocalizedText((PropertySource)this.map, (Auditable)this, "Editor.Map.mark_unmoved_button_report");
                        if (!reportText.isEmpty()) {
                            Chatter.DisplayText display = new Chatter.DisplayText(GameModule.getGameModule().getChatter(), "* " + reportText);
                            display.execute();
                            c.append(display);
                        }
                    }
                    GameModule.getGameModule().sendAndLog(c);
                    this.map.repaint();
                };
                this.markUnmovedButton = new LaunchButton("", NAME, "markUnmovedHotkey", "markUnmovedIcon", al);
                Image img = null;
                if (this.iconName != null && this.iconName.length() > 0 && (img = this.loadIcon(this.iconName)) != null) {
                    this.markUnmovedButton.setAttribute("markUnmovedIcon", this.iconName);
                }
                if (img == null && (img = this.loadIcon(this.markUnmovedIcon)) != null) {
                    this.markUnmovedButton.setAttribute("markUnmovedIcon", this.markUnmovedIcon);
                }
                this.markUnmovedButton.setAttribute("markUnmovedHotkey", this.map.getAttributeValueString("markUnmovedHotkey"));
                this.markUnmovedButton.setAlignmentY(0.0f);
                this.markUnmovedButton.setText(this.markUnmovedText);
                this.markUnmovedButton.setToolTipText(this.map.getAttributeValueString("markUnmovedTooltip"));
                this.map.getToolBar().add(this.markUnmovedButton);
            }
        } else if (this.markUnmovedButton != null) {
            this.map.getToolBar().remove(this.markUnmovedButton);
            this.markUnmovedButton = null;
        }
    }

    private String getMarkOption() {
        String value = this.map.getAttributeValueString("markMoved");
        if (value == null) {
            value = GlobalOptions.getInstance().getAttributeValueString("markMoved");
        }
        return value;
    }

    @Override
    public String[] getAttributeNames() {
        return new String[]{ICON_NAME};
    }

    @Override
    public String getAttributeValueString(String key) {
        return ICON_NAME.equals(key) ? this.iconName : null;
    }

    @Override
    public void setAttribute(String key, Object value) {
        if (ICON_NAME.equals(key)) {
            this.iconName = (String)value;
        } else if ("markUnmovedText".equals(key)) {
            if (this.markUnmovedButton != null) {
                this.markUnmovedButton.setAttribute(NAME, value);
            }
            this.markUnmovedText = (String)value;
        } else if ("markUnmovedIcon".equals(key)) {
            if (this.markUnmovedButton != null) {
                this.markUnmovedButton.setAttribute("markUnmovedIcon", value);
            }
            this.markUnmovedIcon = (String)value;
        } else if ("markUnmovedHotkey".equals(key)) {
            if (this.markUnmovedButton != null) {
                this.markUnmovedButton.setAttribute("markUnmovedHotkey", value);
            }
            if (value instanceof String) {
                value = NamedHotKeyConfigurer.decode((String)value);
            }
            this.markUnmovedHotkey = (NamedKeyStroke)value;
        } else if ("markUnmovedReport".equals(key)) {
            this.markUnmovedReport = (String)value;
        }
    }

    protected boolean isMultipleSelectionEvent(MouseEvent e) {
        return e.isShiftDown();
    }

    protected Command movedPiece(GamePiece p, Point loc) {
        Command c = new NullCommand();
        c = c.append(this.setOldLocations(p));
        if (!loc.equals(p.getPosition())) {
            c = c.append(this.markMoved(p, true));
        }
        if (p.getParent() != null) {
            Command removedCommand = p.getParent().pieceRemoved(p);
            c = c.append(removedCommand);
        }
        return c;
    }

    protected Command setOldLocations(GamePiece p) {
        Command comm = new NullCommand();
        if (p instanceof Stack) {
            for (GamePiece gamePiece : ((Stack)p).asList()) {
                comm = comm.append(Decorator.putOldProperties(gamePiece));
            }
        } else {
            comm = comm.append(Decorator.putOldProperties(p));
        }
        return comm;
    }

    public Command markMoved(GamePiece p, boolean hasMoved) {
        if ("Never".equals(this.getMarkOption())) {
            hasMoved = false;
        }
        Command c = new NullCommand();
        if (!hasMoved || this.shouldMarkMoved()) {
            if (p instanceof Stack) {
                for (GamePiece gamePiece : ((Stack)p).asList()) {
                    c = c.append(this.markMoved(gamePiece, hasMoved));
                }
            } else if (p.getProperty("Moved") != null && p.getId() != null) {
                ChangeTracker comm = new ChangeTracker(p);
                p.setProperty("Moved", hasMoved ? Boolean.TRUE : Boolean.FALSE);
                c = c.append(comm.getChangeCommand());
            }
        }
        return c;
    }

    protected boolean shouldMarkMoved() {
        String option = this.getMarkOption();
        if ("Always".equals(option)) {
            return true;
        }
        if ("Never".equals(option)) {
            return false;
        }
        return Boolean.TRUE.equals(GameModule.getGameModule().getPrefs().getValue("markMoved"));
    }

    /*
     * WARNING - void declaration
     */
    public Command movePieces(Map map, Point p) {
        PieceIterator it = DragBuffer.getBuffer().getIterator();
        if (!it.hasMoreElements()) {
            return null;
        }
        ArrayList<GamePiece> allDraggedPieces = new ArrayList<GamePiece>();
        Point offset = null;
        Command comm = new NullCommand();
        BoundsTracker tracker = new BoundsTracker();
        HashMap<Point, ArrayList<GamePiece>> mergeTargets = new HashMap<Point, ArrayList<GamePiece>>();
        ArrayList<Object> otherPieces = new ArrayList<Object>();
        ArrayList<GamePiece> cargoPieces = new ArrayList<GamePiece>();
        ArrayList<MatMover> matPieces = new ArrayList<MatMover>();
        while (it.hasMoreElements()) {
            GamePiece piece = it.nextPiece();
            if (offset == null) {
                offset = new Point(p.x - piece.getPosition().x, p.y - piece.getPosition().y);
            }
            if (Boolean.TRUE.equals(piece.getProperty("IsCargo"))) {
                cargoPieces.add(piece);
                continue;
            }
            if (piece.getProperty("MatID") != null) {
                matPieces.add(new MatMover(piece));
                continue;
            }
            otherPieces.add(piece);
        }
        for (MatMover matMover : matPieces) {
            matMover.grabCargo(cargoPieces);
        }
        ArrayList<Object> newDragBuffer = new ArrayList<Object>();
        newDragBuffer.addAll(otherPieces);
        newDragBuffer.addAll(cargoPieces);
        for (MatMover mm : matPieces) {
            newDragBuffer.add(mm.getMatPiece());
            newDragBuffer.addAll(mm.getCargo());
        }
        Object var13_15 = null;
        MatCargo currentCargo = null;
        Iterator iterator = newDragBuffer.iterator();
        while (iterator.hasNext()) {
            GamePiece gp;
            this.dragging = gp = (GamePiece)iterator.next();
            tracker.addPiece(this.dragging);
            Mat tempMat = (Mat)Decorator.getDecorator(gp, Mat.class);
            if (tempMat != null) {
                Mat mat = tempMat;
            }
            currentCargo = (MatCargo)Decorator.getDecorator(gp, MatCargo.class);
            ArrayList<GamePiece> draggedPieces = new ArrayList<GamePiece>(0);
            if (this.dragging instanceof Stack) {
                draggedPieces.addAll(((Stack)this.dragging).asList());
            } else {
                draggedPieces.add(this.dragging);
            }
            if (offset != null) {
                p = new Point(this.dragging.getPosition().x + offset.x, this.dragging.getPosition().y + offset.y);
            }
            ArrayList<GamePiece> mergeCandidates = (ArrayList<GamePiece>)mergeTargets.get(p);
            GamePiece mergeWith = null;
            if (mergeCandidates != null) {
                int n = mergeCandidates.size();
                for (int i = 0; i < n; ++i) {
                    GamePiece candidate = (GamePiece)mergeCandidates.get(i);
                    if (!map.getPieceCollection().canMerge(candidate, this.dragging)) continue;
                    mergeWith = candidate;
                    mergeCandidates.set(i, this.dragging);
                    break;
                }
            }
            if (mergeWith == null) {
                void var13_16;
                mergeWith = map.findAnyPiece(p, this.getDropTargetSelector(this.dragging, currentCargo, (Mat)var13_16));
                if (mergeWith == null) {
                    Boolean b;
                    boolean ignoreGrid = false;
                    ignoreGrid = currentCargo == null ? (b = (Boolean)this.dragging.getProperty("IgnoreGrid")) != null && b != false : (var13_16 == null && currentCargo.locateNewMat(map, p) == null ? (b = (Boolean)this.dragging.getProperty("baseIgnoreGrid")) != null && b != false : true);
                    if (!ignoreGrid) {
                        p = map.snapTo(p);
                    }
                }
                offset = new Point(p.x - this.dragging.getPosition().x, p.y - this.dragging.getPosition().y);
                if (mergeWith != null && map.getStackMetrics().isStackingEnabled()) {
                    mergeCandidates = new ArrayList<GamePiece>();
                    mergeCandidates.add(this.dragging);
                    mergeCandidates.add(mergeWith);
                    mergeTargets.put(p, mergeCandidates);
                }
            }
            if (mergeWith == null) {
                Stack parent;
                comm = comm.append(this.movedPiece(this.dragging, p));
                comm = comm.append(map.placeAt(this.dragging, p));
                if (!(this.dragging instanceof Stack) && !Boolean.TRUE.equals(this.dragging.getProperty("NoStack")) && (parent = map.getStackMetrics().createStack(this.dragging)) != null) {
                    comm = comm.append(map.placeAt(parent, p));
                    mergeCandidates = new ArrayList();
                    mergeCandidates.add(this.dragging);
                    mergeCandidates.add(parent);
                    mergeTargets.put(p, mergeCandidates);
                }
            } else {
                if (mergeWith instanceof Deck) {
                    ArrayList<GamePiece> newList = new ArrayList<GamePiece>(0);
                    for (GamePiece piece : draggedPieces) {
                        boolean isObscuredToMe;
                        if (!((Deck)mergeWith).mayContain(piece) || (isObscuredToMe = Boolean.TRUE.equals(piece.getProperty("Obscured"))) && !"nobody".equals(piece.getProperty("obs;"))) continue;
                        newList.add(piece);
                    }
                    if (newList.size() != draggedPieces.size()) {
                        draggedPieces.clear();
                        draggedPieces.addAll(newList);
                    }
                }
                if (mergeWith instanceof Stack) {
                    for (GamePiece draggedPiece : draggedPieces) {
                        comm = comm.append(this.movedPiece(draggedPiece, mergeWith.getPosition()));
                        comm = comm.append(map.getStackMetrics().merge(mergeWith, draggedPiece));
                    }
                } else {
                    for (int i = draggedPieces.size() - 1; i >= 0; --i) {
                        comm = comm.append(this.movedPiece((GamePiece)draggedPieces.get(i), mergeWith.getPosition()));
                        comm = comm.append(map.getStackMetrics().merge(mergeWith, (GamePiece)draggedPieces.get(i)));
                    }
                }
            }
            for (GamePiece piece : draggedPieces) {
                Mat thisMat;
                KeyBuffer.getBuffer().add(piece);
                if (!GameModule.getGameModule().isMatSupport()) continue;
                if (Boolean.TRUE.equals(piece.getProperty("IsCargo"))) {
                    MatCargo cargo = (MatCargo)Decorator.getDecorator(piece, MatCargo.class);
                    GamePiece oldMat = cargo.getMat();
                    if (oldMat != null && (draggedPieces.contains(oldMat) || allDraggedPieces.contains(oldMat) || DragBuffer.getBuffer().contains(oldMat))) continue;
                    comm = comm.append(cargo.findNewMat(map, p));
                    continue;
                }
                if (piece.getProperty("MatName") == null || (thisMat = (Mat)Decorator.getDecorator(piece, Mat.class)) == null) continue;
                List<GamePiece> contents = thisMat.getContents();
                for (GamePiece cargo : contents) {
                    MatCargo theCargo;
                    if (draggedPieces.contains(cargo) || allDraggedPieces.contains(cargo) || DragBuffer.getBuffer().contains(cargo) || (theCargo = (MatCargo)Decorator.getDecorator(cargo, MatCargo.class)) == null) continue;
                    comm = comm.append(theCargo.findNewMat(cargo.getMap(), cargo.getPosition()));
                }
            }
            allDraggedPieces.addAll(draggedPieces);
            tracker.addPiece(this.dragging);
        }
        if (GlobalOptions.getInstance().autoReportEnabled()) {
            Command report = this.createMovementReporter(comm).getReportCommand().append(new MovementReporter.HiddenMovementReporter(comm).getReportCommand());
            report.execute();
            comm = comm.append(report);
        }
        if (map.getMoveKey() != null) {
            comm = comm.append(this.applyKeyAfterMove(allDraggedPieces, map.getMoveKey()));
        }
        tracker.repaint();
        return comm;
    }

    protected Command applyKeyAfterMove(List<GamePiece> pieces, KeyStroke key) {
        Command comm = new NullCommand();
        for (GamePiece piece : pieces) {
            if (piece.getProperty("snapshot") == null) {
                piece.setProperty("snapshot", ((PropertyExporter)((Object)piece)).getProperties());
            }
            comm = comm.append(piece.keyEvent(key));
        }
        return comm;
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (this.canHandleEvent(e)) {
            this.selectMovablePieces(e);
        }
    }

    protected void selectMovablePieces(MouseEvent e) {
        GamePiece p = this.map.findPiece(e.getPoint(), this.dragTargetSelector);
        this.dragBegin = e.getPoint();
        this.breachedThreshold = false;
        this.setCurPieceOffset(0, 0);
        if (p != null) {
            EventFilter filter = (EventFilter)p.getProperty("moveEventFilter");
            if (filter == null || !filter.rejectEvent(e)) {
                this.selectionProcessor.accept(p);
            } else {
                DragBuffer.getBuffer().clear();
            }
        } else {
            DragBuffer.getBuffer().clear();
        }
        this.map.repaint();
    }

    protected boolean canHandleEvent(MouseEvent e) {
        return !e.isConsumed() && !e.isShiftDown() && !SwingUtils.isSelectionToggle(e) && e.getClickCount() < 2 && (e.getButton() == 0 || SwingUtils.isMainMouseButtonDown(e));
    }

    public boolean isClick(Point pt) {
        boolean isClick = false;
        if (this.dragBegin != null) {
            boolean useGrid;
            Board b = this.map.findBoard(pt);
            boolean bl = useGrid = b != null && b.getGrid() != null;
            if (useGrid) {
                PieceIterator it = DragBuffer.getBuffer().getIterator();
                GamePiece dragging = it.hasMoreElements() ? it.nextPiece() : null;
                boolean bl2 = useGrid = dragging != null && !Boolean.TRUE.equals(dragging.getProperty("IgnoreGrid")) && (dragging.getParent() == null || !dragging.getParent().isExpanded());
            }
            if (useGrid && this.map.equals(DragBuffer.getBuffer().getFromMap()) && this.map.snapTo(pt).equals(this.map.snapTo(this.dragBegin))) {
                isClick = true;
            }
            if (!this.breachedThreshold && this.map.mapToComponent(Math.abs(pt.x - this.dragBegin.x - this.curPieceOffsetX)) <= GlobalOptions.getInstance().getDragThreshold() && this.map.mapToComponent(Math.abs(pt.y - this.dragBegin.y - this.curPieceOffsetY)) <= GlobalOptions.getInstance().getDragThreshold()) {
                isClick = true;
            }
        }
        return isClick;
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (this.canHandleEvent(e) && !this.isClick(e.getPoint())) {
            this.performDrop(e.getPoint());
        }
        this.dragBegin = null;
        this.breachedThreshold = false;
        this.map.getView().setCursor(null);
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (!this.breachedThreshold && this.dragBegin != null) {
            Point pt = this.map.componentToMap(e.getPoint());
            if (this.map.mapToComponent(Math.abs(pt.x - this.dragBegin.x)) > GlobalOptions.getInstance().getDragThreshold() || this.map.mapToComponent(Math.abs(pt.y - this.dragBegin.y)) > GlobalOptions.getInstance().getDragThreshold()) {
                this.breachedThreshold = true;
            }
        }
    }

    protected void performDrop(Point p) {
        Command move = this.movePieces(this.map, p);
        GameModule.getGameModule().sendAndLog(move);
        if (move != null) {
            DragBuffer.getBuffer().clear();
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public int compare(GamePiece p1, GamePiece p2) {
        return this.pieceSorter.compare(p1, p2);
    }

    static {
        try {
            Class.forName(MovementReporter.class.getName());
            Class.forName(KeyBuffer.class.getName());
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException(e);
        }
    }

    public static class DragHandler
    extends AbstractDragHandler {
        @Override
        public void dragGestureRecognized(DragGestureEvent dge) {
            if (this.dragGestureRecognizedPrep(dge) == null) {
                return;
            }
            super.dragGestureRecognized(dge);
        }

        @Override
        protected int getOffsetMult() {
            return -1;
        }

        @Override
        protected double getDeviceScale(DragGestureEvent dge) {
            Graphics2D g2d = (Graphics2D)dge.getComponent().getGraphics();
            double os_scale = g2d.getDeviceConfiguration().getDefaultTransform().getScaleX();
            g2d.dispose();
            return os_scale;
        }

        @Override
        public void dragMouseMoved(DragSourceDragEvent e) {
        }
    }

    public static abstract class AbstractDragHandler
    implements DragGestureListener,
    DragSourceListener,
    DragSourceMotionListener,
    DropTargetListener {
        private static AbstractDragHandler theDragHandler = AbstractDragHandlerFactory.getCorrectDragHandler();
        static final int CURSOR_ALPHA = 127;
        static final int EXTRA_BORDER = 4;
        protected JLabel dragCursor;
        private final Point drawOffset = new Point();
        private Rectangle boundingBox;
        private int originalPieceOffsetX;
        private int originalPieceOffsetY;
        protected double dragPieceOffCenterZoom = 1.0;
        private int currentPieceOffsetX;
        private int currentPieceOffsetY;
        protected double dragCursorZoom = 1.0;
        Component dragWin;
        Component dropWin;
        JLayeredPane drawWin;
        protected static List<PieceMover> pieceMovers = new ArrayList<PieceMover>();
        java.util.Map<Component, DropTargetListener> dropTargetListeners = new HashMap<Component, DropTargetListener>();
        protected Point lastDragLocation = new Point();

        public static AbstractDragHandler getTheDragHandler() {
            return theDragHandler;
        }

        public static void setTheDragHandler(AbstractDragHandler myHandler) {
            theDragHandler = myHandler;
        }

        protected abstract int getOffsetMult();

        protected abstract double getDeviceScale(DragGestureEvent var1);

        public static void resetRecursivePieceSlots(AbstractBuildable target) {
            for (Buildable b : target.getBuildables()) {
                if (b instanceof PieceSlot) {
                    Component panel = ((PieceSlot)b).getComponent();
                    panel.setDropTarget(AbstractDragHandler.makeDropTarget(panel, 2, null));
                    continue;
                }
                if (!(b instanceof AbstractBuildable)) continue;
                AbstractDragHandler.resetRecursivePieceSlots((AbstractBuildable)b);
            }
        }

        public static void resetDragHandler() {
            AbstractDragHandler newHandler = AbstractDragHandlerFactory.getCorrectDragHandler();
            AbstractDragHandler.setTheDragHandler(newHandler);
            for (Map map : Map.getMapList()) {
                map.setDragGestureListener(newHandler);
                map.getComponent().setDropTarget(AbstractDragHandler.makeDropTarget(map.getComponent(), 2, map));
            }
            AbstractDragHandler.resetRecursivePieceSlots(GameModule.getGameModule());
        }

        static void addPieceMover(PieceMover pm) {
            if (!pieceMovers.contains(pm)) {
                pieceMovers.add(pm);
            }
        }

        public static DropTarget makeDropTarget(Component theComponent, int dndContants, DropTargetListener dropTargetListener) {
            if (dropTargetListener != null) {
                DragHandler.getTheDragHandler().dropTargetListeners.put(theComponent, dropTargetListener);
            }
            return new DropTarget(theComponent, dndContants, DragHandler.getTheDragHandler());
        }

        public static void removeDropTarget(Component theComponent) {
            DragHandler.getTheDragHandler().dropTargetListeners.remove(theComponent);
        }

        protected DropTargetListener getListener(DropTargetEvent e) {
            Component component = e.getDropTargetContext().getComponent();
            return this.dropTargetListeners.get(component);
        }

        protected void moveDragCursor(int dragX, int dragY) {
            if (this.drawWin != null) {
                this.dragCursor.setLocation(dragX - this.drawOffset.x, dragY - this.drawOffset.y);
            }
        }

        protected void removeDragCursor() {
            if (this.drawWin != null) {
                if (this.dragCursor != null) {
                    this.dragCursor.setVisible(false);
                    this.drawWin.remove(this.dragCursor);
                }
                this.drawWin = null;
            }
        }

        private void calcDrawOffset() {
            if (this.drawWin != null) {
                this.drawOffset.x = -this.boundingBox.x - this.currentPieceOffsetX + 4;
                this.drawOffset.y = -this.boundingBox.y - this.currentPieceOffsetY + 4;
                SwingUtilities.convertPointToScreen(this.drawOffset, this.drawWin);
            }
        }

        private void setDrawWin(JLayeredPane newDrawWin) {
            if (newDrawWin != this.drawWin) {
                if (this.dragCursor.getParent() != null) {
                    this.dragCursor.getParent().remove(this.dragCursor);
                }
                if (this.drawWin != null) {
                    this.drawWin.repaint(this.dragCursor.getBounds());
                }
                this.drawWin = newDrawWin;
                this.calcDrawOffset();
                this.dragCursor.setVisible(false);
                this.drawWin.add((Component)this.dragCursor, JLayeredPane.DRAG_LAYER);
            }
        }

        public void setDrawWinToOwnerOf(Component newDropWin) {
            JRootPane rootWin;
            if (newDropWin != null && (rootWin = SwingUtilities.getRootPane(newDropWin)) != null) {
                this.setDrawWin(rootWin.getLayeredPane());
            }
        }

        BufferedImage makeDragImageCursorCommon(double zoom, boolean doOffset, Component target, boolean setSize) {
            this.dragCursorZoom = zoom;
            List<Point> relativePositions = this.buildBoundingBox(zoom, doOffset);
            int w = this.boundingBox.width + 8;
            int h = this.boundingBox.height + 8;
            BufferedImage image = ImageUtils.createCompatibleTranslucentImage(w, h);
            this.drawDragImage(image, target, relativePositions, zoom);
            if (setSize) {
                this.dragCursor.setSize(w, h);
            }
            return image;
        }

        private BufferedImage makeDragImage(double zoom) {
            return this.makeDragImageCursorCommon(zoom, false, null, false);
        }

        protected void makeDragCursor(double zoom) {
            if (this.dragCursor == null) {
                this.dragCursor = new JLabel();
                this.dragCursor.setVisible(false);
            }
            this.dragCursor.setIcon(new ImageIcon(this.makeDragImageCursorCommon(zoom, true, this.dragCursor, true)));
        }

        private List<Point> buildBoundingBox(double zoom, boolean doOffset) {
            GamePiece firstPiece;
            ArrayList<Point> relativePositions = new ArrayList<Point>();
            PieceIterator dragContents = DragBuffer.getBuffer().getIterator();
            GamePiece lastPiece = firstPiece = dragContents.nextPiece();
            this.currentPieceOffsetX = (int)((double)this.originalPieceOffsetX / this.dragPieceOffCenterZoom * zoom + 0.5);
            this.currentPieceOffsetY = (int)((double)this.originalPieceOffsetY / this.dragPieceOffCenterZoom * zoom + 0.5);
            this.boundingBox = firstPiece.getShape().getBounds();
            this.boundingBox.width = (int)((double)this.boundingBox.width * zoom);
            this.boundingBox.height = (int)((double)this.boundingBox.height * zoom);
            this.boundingBox.x = (int)((double)this.boundingBox.x * zoom);
            this.boundingBox.y = (int)((double)this.boundingBox.y * zoom);
            if (doOffset) {
                this.calcDrawOffset();
            }
            relativePositions.add(new Point(0, 0));
            int stackCount = 0;
            while (dragContents.hasMoreElements()) {
                GamePiece nextPiece = dragContents.nextPiece();
                Rectangle r = nextPiece.getShape().getBounds();
                r.width = (int)((double)r.width * zoom);
                r.height = (int)((double)r.height * zoom);
                r.x = (int)((double)r.x * zoom);
                r.y = (int)((double)r.y * zoom);
                Point p = new Point((int)Math.round(zoom * (double)(nextPiece.getPosition().x - firstPiece.getPosition().x)), (int)Math.round(zoom * (double)(nextPiece.getPosition().y - firstPiece.getPosition().y)));
                r.translate(p.x, p.y);
                if (nextPiece.getPosition().equals(lastPiece.getPosition())) {
                    StackMetrics sm = this.getStackMetrics(nextPiece);
                    r.translate((int)Math.round((double)(sm.unexSepX * ++stackCount) * zoom), (int)Math.round((double)(-sm.unexSepY * stackCount) * zoom));
                }
                this.boundingBox.add(r);
                relativePositions.add(p);
                lastPiece = nextPiece;
            }
            return relativePositions;
        }

        private void drawDragImage(BufferedImage image, Component target, List<Point> relativePositions, double zoom) {
            Graphics2D g = image.createGraphics();
            g.addRenderingHints(SwingUtils.FONT_HINTS);
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            int index = 0;
            Point lastPos = null;
            int stackCount = 0;
            PieceIterator dragContents = DragBuffer.getBuffer().getIterator();
            while (dragContents.hasMoreElements()) {
                GamePiece piece = dragContents.nextPiece();
                Point pos = relativePositions.get(index++);
                Map map = piece.getMap();
                if (piece instanceof Stack) {
                    stackCount = 0;
                    piece.draw(g, 4 - this.boundingBox.x + pos.x, 4 - this.boundingBox.y + pos.y, map == null ? target : map.getView(), zoom);
                } else {
                    Point offset = new Point(0, 0);
                    if (pos.equals(lastPos)) {
                        StackMetrics sm = this.getStackMetrics(piece);
                        offset.x = (int)Math.round((double)(sm.unexSepX * ++stackCount) * zoom);
                        offset.y = (int)Math.round((double)(sm.unexSepY * stackCount) * zoom);
                    } else {
                        stackCount = 0;
                    }
                    int x = 4 - this.boundingBox.x + pos.x + offset.x;
                    int y = 4 - this.boundingBox.y + pos.y - offset.y;
                    String owner = "";
                    if (piece.getParent() instanceof Deck) {
                        owner = (String)piece.getProperty("obs;");
                        piece.setProperty("obs;", ((Deck)piece.getParent()).isFaceDown() ? "nobody" : null);
                    }
                    AffineTransform t = AffineTransform.getScaleInstance(zoom, zoom);
                    t.translate((double)x / zoom, (double)y / zoom);
                    g.setClip(t.createTransformedShape(piece.getShape()));
                    piece.draw(g, x, y, map == null ? target : map.getView(), zoom);
                    if (piece.getParent() instanceof Deck) {
                        piece.setProperty("obs;", owner);
                    }
                    g.setClip(null);
                    Highlighter highlighter = map == null ? BasicPiece.getHighlighter() : map.getHighlighter();
                    highlighter.draw(piece, g, x, y, null, zoom);
                    Mat mat = (Mat)Decorator.getDecorator(piece, Mat.class);
                    if (mat != null) {
                        mat.drawCargo(g, x, y, null, zoom);
                    }
                }
                lastPos = pos;
            }
            g.setComposite(AlphaComposite.getInstance(6));
            g.setColor(new Color(255, 255, 255, 127));
            g.fillRect(0, 0, image.getWidth(), image.getHeight());
            g.dispose();
        }

        private StackMetrics getStackMetrics(GamePiece piece) {
            StackMetrics sm = null;
            Map map = piece.getMap();
            if (map != null) {
                sm = map.getStackMetrics();
            }
            if (sm == null) {
                sm = new StackMetrics();
            }
            return sm;
        }

        @Override
        public void dragGestureRecognized(DragGestureEvent dge) {
            try {
                this.beginDragging(dge);
            }
            catch (InvalidDnDOperationException invalidDnDOperationException) {
                // empty catch block
            }
        }

        protected Point dragGestureRecognizedPrep(DragGestureEvent dge) {
            Point piecePosition;
            DragBuffer db = DragBuffer.getBuffer();
            if (db.isEmpty()) {
                return null;
            }
            ArrayList<GamePiece> pieces = new ArrayList<GamePiece>();
            PieceIterator i = db.getIterator();
            while (i.hasMoreElements()) {
                pieces.add(i.nextPiece());
            }
            for (GamePiece piece : pieces) {
                if (piece.getMap() == null || !Boolean.TRUE.equals(piece.getProperty("cannotMove"))) continue;
                db.remove(piece);
            }
            if (db.isEmpty()) {
                return null;
            }
            GamePiece piece = db.getIterator().nextPiece();
            Map map = dge.getComponent() instanceof Map.View ? ((Map.View)dge.getComponent()).getMap() : null;
            Point mousePosition = dge.getDragOrigin();
            Point point = piecePosition = map == null ? piece.getPosition() : map.mapToComponent(piece.getPosition());
            if (piecePosition.x <= 0 || piecePosition.y <= 0) {
                piecePosition = mousePosition;
            }
            if (map != null) {
                this.dragPieceOffCenterZoom = map.getZoom();
            } else {
                Object tempZoom = piece.getProperty("ppScale");
                if (tempZoom != null) {
                    BasicPiece bp = (BasicPiece)Decorator.getInnermost(piece);
                    bp.setPersistentProperty("ppScale", null);
                    this.dragPieceOffCenterZoom = tempZoom instanceof Double ? (Double)tempZoom : Double.parseDouble((String)tempZoom);
                } else {
                    this.dragPieceOffCenterZoom = 1.0;
                }
            }
            this.dragPieceOffCenterZoom *= this.getDeviceScale(dge);
            if (piece.getParent() != null && map != null) {
                Point offset = piece.getParent().getStackMetrics().relativePosition(piece.getParent(), piece);
                piecePosition.translate((int)Math.round((double)offset.x * this.dragPieceOffCenterZoom), (int)Math.round((double)offset.y * this.dragPieceOffCenterZoom));
            }
            this.originalPieceOffsetX = piecePosition.x - mousePosition.x;
            this.originalPieceOffsetY = piecePosition.y - mousePosition.y;
            this.dragWin = dge.getComponent();
            this.drawWin = null;
            this.dropWin = null;
            return mousePosition;
        }

        protected void beginDragging(DragGestureEvent dge) {
            KeyBufferer kb;
            Map map;
            BufferedImage bImage = this.makeDragImage(this.dragPieceOffCenterZoom);
            Point dragPointOffset = new Point(this.getOffsetMult() * (this.boundingBox.x + this.currentPieceOffsetX - 4), this.getOffsetMult() * (this.boundingBox.y + this.currentPieceOffsetY - 4));
            for (PieceMover pieceMover : pieceMovers) {
                pieceMover.setCurPieceOffset(this.currentPieceOffsetX, this.currentPieceOffsetY);
                pieceMover.setBreachedThreshold(true);
            }
            dge.startDrag(Cursor.getPredefinedCursor(12), GlobalOptions.getInstance().isForceNonNativeDrag() ? null : bImage, dragPointOffset, new StringSelection(""), this);
            dge.getDragSource().addDragSourceMotionListener(this);
            Map map2 = map = dge.getComponent() instanceof Map.View ? ((Map.View)dge.getComponent()).getMap() : null;
            if (map != null && (kb = map.getKeyBufferer()) != null) {
                kb.dragStarted();
            }
        }

        @Override
        public void dragDropEnd(DragSourceDropEvent e) {
            DragSource ds = e.getDragSourceContext().getDragSource();
            ds.removeDragSourceMotionListener(this);
        }

        @Override
        public void dragEnter(DragSourceDragEvent e) {
        }

        @Override
        public void dragExit(DragSourceEvent e) {
        }

        @Override
        public void dragOver(DragSourceDragEvent e) {
        }

        @Override
        public void dropActionChanged(DragSourceDragEvent e) {
        }

        @Override
        public abstract void dragMouseMoved(DragSourceDragEvent var1);

        @Override
        public void dragEnter(DropTargetDragEvent e) {
            DropTargetListener forward = this.getListener(e);
            if (forward != null) {
                forward.dragEnter(e);
            }
        }

        @Override
        public void drop(DropTargetDropEvent e) {
            e.getLocation().translate(this.currentPieceOffsetX, this.currentPieceOffsetY);
            DropTargetListener forward = this.getListener(e);
            if (forward != null) {
                forward.drop(e);
            }
        }

        @Override
        public void dragExit(DropTargetEvent e) {
            DropTargetListener forward = this.getListener(e);
            if (forward != null) {
                forward.dragExit(e);
            }
        }

        @Override
        public void dragOver(DropTargetDragEvent e) {
            DropTargetListener forward = this.getListener(e);
            if (forward != null) {
                forward.dragOver(e);
            }
        }

        @Override
        public void dropActionChanged(DropTargetDragEvent e) {
            DropTargetListener forward = this.getListener(e);
            if (forward != null) {
                forward.dropActionChanged(e);
            }
        }

        public static class AbstractDragHandlerFactory {
            public static AbstractDragHandler getCorrectDragHandler() {
                if (!DragSource.isDragImageSupported() || GlobalOptions.getInstance().isForceNonNativeDrag()) {
                    return new DragHandlerNoImage();
                }
                return SystemUtils.IS_OS_MAC ? new DragHandlerMacOSX() : new DragHandler();
            }
        }
    }

    private class LoadedCargoDropTargetSelector
    extends StandardDropTargetSelector {
        private LoadedCargoDropTargetSelector() {
        }

        @Override
        public Object visitDeck(Deck d) {
            return null;
        }

        @Override
        public Object visitDefault(GamePiece piece) {
            return this.getMat().hasCargo(piece) ? super.visitDefault(piece) : null;
        }

        @Override
        public Object visitStack(Stack s) {
            if (s != null && s.getPieceCount() > 0) {
                return this.getMat().hasCargo(s.getPieceAt(0)) ? super.visitStack(s) : null;
            }
            return null;
        }
    }

    private class MatDropTargetSelector
    extends StandardDropTargetSelector {
        private MatDropTargetSelector() {
        }

        @Override
        public Object visitDeck(Deck d) {
            return this.getMat().getCargoCount() > 0 ? null : super.visitDeck(d);
        }
    }

    private class StandardDropTargetSelector
    extends PieceFinder.Movable {
        private GamePiece piece;
        private MatCargo cargo;
        private Mat mat;

        public void setPiece(GamePiece piece, MatCargo cargo, Mat mat) {
            this.piece = piece;
            this.cargo = cargo;
            this.mat = mat;
        }

        public GamePiece getPiece() {
            return this.piece;
        }

        public MatCargo getCargo() {
            return this.cargo;
        }

        public Mat getMat() {
            return this.mat;
        }

        @Override
        public Object visitDeck(Deck d) {
            Point pos = d.getPosition();
            Point p = new Point(this.pt.x - pos.x, this.pt.y - pos.y);
            return d.getShape().contains(p) ? d : null;
        }

        @Override
        public Object visitDefault(GamePiece piece) {
            MatCargo targetCargo;
            GamePiece selected = null;
            if (this.map.getStackMetrics().isStackingEnabled() && this.map.getPieceCollection().canMerge(PieceMover.this.dragging, piece)) {
                if (this.map.isLocationRestricted(this.pt)) {
                    Point snap = this.map.snapTo(this.pt);
                    if (piece.getPosition().equals(snap)) {
                        selected = piece;
                    }
                } else {
                    selected = (GamePiece)super.visitDefault(piece);
                }
            }
            if (selected != null && DragBuffer.getBuffer().contains(selected) && selected.getParent() != null && selected.getParent().topPiece() == selected) {
                selected = null;
            }
            if (selected != null && this.getCargo() == null && (targetCargo = (MatCargo)Decorator.getDecorator(selected, MatCargo.class)) != null && targetCargo.getMat() != null) {
                selected = null;
            }
            return selected;
        }

        @Override
        public Object visitStack(Stack s) {
            GamePiece selected = null;
            if (this.map.getStackMetrics().isStackingEnabled() && this.map.getPieceCollection().canMerge(PieceMover.this.dragging, s) && !DragBuffer.getBuffer().contains(s) && !DragBuffer.getBuffer().containsAllMembers(s) && s.topPiece() != null) {
                boolean stackIgnoresGrid;
                boolean bl = stackIgnoresGrid = this.isStackLoadedCargo(s) || Boolean.TRUE.equals(s.getPieceAt(0).getProperty("IgnoreGrid"));
                if (this.map.isLocationRestricted(this.pt) && !s.isExpanded() && !stackIgnoresGrid) {
                    if (s.getPosition().equals(this.map.snapTo(this.pt))) {
                        selected = s;
                    }
                } else {
                    selected = (GamePiece)super.visitStack(s);
                }
            }
            if (this.getCargo() == null && this.isStackLoadedCargo(selected)) {
                selected = null;
            }
            return selected;
        }

        protected boolean isStackLoadedCargo(GamePiece p) {
            MatCargo targetCargo = null;
            if (p instanceof Stack) {
                Stack s = (Stack)p;
                if (s.getPieceCount() > 0) {
                    targetCargo = (MatCargo)Decorator.getDecorator(s.getPieceAt(0), MatCargo.class);
                }
            } else if (p instanceof Decorator) {
                targetCargo = (MatCargo)Decorator.getDecorator(p, MatCargo.class);
            }
            return targetCargo != null && targetCargo.getMat() != null;
        }
    }

    private class MatMover
    extends MatHolder {
        public MatMover(GamePiece piece) {
            super(piece);
        }

        @Override
        public void grabCargo(List<GamePiece> allCargo) {
            super.grabCargo(allCargo);
            ArrayList<GamePiece> tempCargo = new ArrayList<GamePiece>();
            for (GamePiece c : this.getCargo()) {
                Stack parent = c.getParent();
                if (parent instanceof Stack) {
                    if (tempCargo.contains(c)) continue;
                    Stack s = parent;
                    for (int i = 0; i < s.getPieceCount(); ++i) {
                        tempCargo.add(s.getPieceAt(i));
                    }
                    continue;
                }
                tempCargo.add(c);
            }
            this.setCargo(tempCargo);
        }
    }

    public static class DragHandlerNoImage
    extends AbstractDragHandler {
        @Override
        public void dragGestureRecognized(DragGestureEvent dge) {
            Point mousePosition = this.dragGestureRecognizedPrep(dge);
            if (mousePosition == null) {
                return;
            }
            this.makeDragCursor(this.dragPieceOffCenterZoom);
            this.setDrawWinToOwnerOf(this.dragWin);
            SwingUtilities.convertPointToScreen(mousePosition, this.drawWin);
            this.moveDragCursor(mousePosition.x, mousePosition.y);
            super.dragGestureRecognized(dge);
        }

        @Override
        protected int getOffsetMult() {
            return 1;
        }

        @Override
        protected double getDeviceScale(DragGestureEvent dge) {
            return 1.0;
        }

        @Override
        public void dragDropEnd(DragSourceDropEvent e) {
            this.removeDragCursor();
            super.dragDropEnd(e);
        }

        @Override
        public void dragMouseMoved(DragSourceDragEvent e) {
            if (!e.getLocation().equals(this.lastDragLocation)) {
                this.lastDragLocation = e.getLocation();
                this.moveDragCursor(e.getX(), e.getY());
                if (this.dragCursor != null && !this.dragCursor.isVisible()) {
                    this.dragCursor.setVisible(true);
                }
            }
        }

        @Override
        public void dragEnter(DropTargetDragEvent e) {
            Component newDropWin = e.getDropTargetContext().getComponent();
            if (newDropWin != this.dropWin) {
                double newZoom;
                double d = newZoom = newDropWin instanceof Map.View ? ((Map.View)newDropWin).getMap().getZoom() : 1.0;
                if (Math.abs(newZoom - this.dragCursorZoom) > 0.01) {
                    this.makeDragCursor(newZoom);
                }
                this.setDrawWinToOwnerOf(e.getDropTargetContext().getComponent());
                this.dropWin = newDropWin;
            }
            super.dragEnter(e);
        }

        @Override
        public void drop(DropTargetDropEvent e) {
            this.removeDragCursor();
            super.drop(e);
        }
    }

    public static class DragHandlerMacOSX
    extends DragHandler {
        @Override
        protected int getOffsetMult() {
            return 1;
        }

        @Override
        protected double getDeviceScale(DragGestureEvent dge) {
            return 1.0;
        }
    }
}

